#charset "us-ascii"
#include <advlite.h>

// This file is strictly about the live actor, not about the object in the recruiting office.

// We need a mix-in class to handle the stairways that ajou can traverse while
// following:

class AjouStairs: Thing
;

ajouMarchingRegion: Region
    regionBeforeTravel(traveler, connector) { 
        if (!ajou.nowFollowing) return;
        // if we're attempting to leave the proper trajectory:
        if ((traveler == me) && (!roomList.indexOf(connector))
            && (!connector.ofKind(AjouStairs)))
        {
            "The soldier balks. <q>I don\'t think we should be going that way, ma\'am!</q> ";
            abort;
        }
    }
;

ajou: Actor 'wooden soldier;;; it him'
    "The soldier is wearing a tall hat with a tassel and a bright red 19th century dress uniform, with a double
    row of gold buttons running down the front. He's not unhandsome, in spite of a certain
    stiffness in his carriage and facial expression. "
    
    proper = nil
    cannotTakeMsg = 'You\'ve never learned the fireman\'s carry. Besides, he might think
        you were trying to use martial arts on him. '
    cannotPutPersonMsg = 'That\'s unlikely to be a useful thing to do. '
    cannotEatMsg = 'You\'re joking, right? '
    kissResponseMsg = 'Your husband would never understand. '
    cannotAttackMsg = 'If you\'re lucky, the soldier won\'t respond by stabbing you with the bayonet. '
    attackResponseMsg = 'A soldier with a rifle? A rifle with a bayonet? Really? '
    
    globalParamName = 'ajou'
    giveName {
        proper = true;
        replaceVocab ('Lieutenant Ajou; handsome wooden; man soldier; him');
    }
    smellDesc = "He smells of sawdust. "
    shouldNotFeelMsg = "Even a comradely pat on the shoulder might be misunderstood. "
    // nowFollowing will allow us to test travel in or out of the ajouMarchingRegion:
    nowFollowing = nil
    followDaemon() {
        local rm = gPlayerChar.getOutermostRoom();
        nowFollowing = true;
        if (ajou.getOutermostRoom() != rm) {
            ajou.moveInto(rm);
            if (ajou.getOutermostRoom() != chartreuseCaboose)
                "{The ajou}
                <<one of>>follows<<or>>marches along beside<<or>>walks
                beside<<at random>> you. ";
            else {
                // This will need to be adjusted to account for the possibility that Bianca
                // may already be present.
                "As you enter the nightclub, {the ajou} gazes around appreciatively. <q>I like
                this place,</q> he says. <q>Is this where you want me to wait?</q><.p>
                <q>That's right,</q> you tell him. <q>Please wait here.</q><.p>
                {The ajou} snaps a crisp salute. ";
                giveName();
                stopFollowing();
                nowFollowing = nil;
            }
        }
    }
    afterAction() {
        inherited();
        if(gActionIn(Play, BlowInto) && (gDobj == batteredTrumpet)) {
            "At the sound of the bugle, the wooden soldier snaps a crisp salute. ";
        }
    }
;

// stuff he's wearing or carrying:

+ Wearable 'tall hat; (soldier\'s)'
    "The tall hat is perched, naturally enough, on top of the soldier's head. Atop the
    hat is a gold tassel. "
;
++ Component 'gold tassel'
    "The gold tassel surmounts the soldier's tall hat. "
;
+ Component 'nose; (soldier\'s)'
    "The soldier's nose is in the usual location, in the center of his face. "
;
+ Wearable 'uniform; (soldier\'s) 19th century'
    "The soldier's uniform has a double row of gold buttons. "
;
++ Component 'gold buttons; (soldier\'s) double vertical rows;; them'
    "The gold buttons run in two vertical rows up the front of the uniform. "
;
+ Fixture 'rifle; (soldier\'s); musket gun'
    "The soldier's rifle, which he holds smartly on his shoulder, is equipped with a bayonet. "
;
++ Component 'bayonet; (soldier\'s)'
    "The bayonet is attached to the business end of the rifle. "
;


// actorstates

+ ajouAtAttention: ActorState
    stateDesc = "He's holding a wooden rifle and gazing imperturbably at nothing. "
    specialDesc = "A handsomely dressed wooden soldier is standing stiffly at attention in
        the corner of the room. "
    isInitState = true
;

++ AskTopic, StopEventList @ajou
    [
        '<q>Are you by any chance a real soldier?</q>, you ask.
        <.p><q>Yes, ma\'am! A lieutenant, ma\'am! Lieutenant Ajou,
        ma\'am!</q><<ajou.giveName()>> ',
        '<q>Can you tell me anything else about yourself, Lieutenant?</q>, you
        inquire.
        <.p><q>No, ma\'am! Nothing to tell, ma\'am!</q> ',
        'Lieutenant Ajou has already insisted that there is nothing he can
        tell you about himself. '
    ]
;

++ AskTellTopic @bianca
    "<q>There\'s a very nice mannequin downstairs,</q> you tell him. <q>I
    think you might like her.</q>
    <.p><q>If you say so, ma\'am!</q> "
;

++ DefaultAnyTopic
    "{The ajou} gazes fixedly at the wall, and does not respond. "
;

++ DefaultCommandTopic
    "The soldier thumps the butt of his rifle on the floor. <q>Begging your pardon, ma'am!
    You're not my commanding officer, ma'am!</q> "
;

++ GiveShowTopic @parchment
    topicResponse() {
        if (!parchment.isWaxed)
            "The soldier's eyes barely flick in the direction of the piece of
            parchment. <q>Those are not official orders, ma'am! Official orders
            have an official seal!</q> ";
        else if (!parchment.isSealed)
            "<q>That's not an official seal, ma'am! It's just a blob of wax!</q> ";
        else {
            ajou.setState(ajouAmenable);
            ajouAch.awardPointsOnce();
            "The wooden soldier nods stiffly. <q>You are my commanding officer! I will
            obey all reasonable orders, ma'am!</q> ";
        }
    }
;

+ ajouAmenable: ActorState
    stateDesc = "He's gazing stiffly at you, awaiting orders. "
    specialDesc = "A handsomely dressed wooden soldier is standing here. "
;

++ AskTellTopic @bianca
    "<q>Would you like to meet a pretty mannequin?</q> you ask.
    <.p><q>It would be a pleasure, ma\'am.</q> "
;
+++ AltTopic
    "<q>Does {bianca} meet with your approval, Lieutenant?</q>
    <.p><q>Very much so, ma\'am! I look forward to getting to know her.</q> "
    isActive = ((ajou.isIn(chartreuseCaboose)) && (bianca.isIn(chartreuseCaboose)))
;

++ CommandTopic @Follow
    readyToFollow {
        // Really, there's no reason to insist that Z have listed the items...
        // if (!zarbolphung.itemsListed) return nil;
        if (!bianca.isIn(behindCaboosePanel)) return nil;
        if ((!monkeys.equipped) || (!monkeys.talented)) return nil;
        return true;
    }
    topicResponse () {
        if (ajou.getOutermostRoom() == chartreuseCaboose)
            "<q>I feel certain this is our destination, ma\'am!</q> ";
        else if (readyToFollow) {
            "<q>I am ready, ma'am. Lead on.</q> ";
            ajou.startFollowing();
        }
        else "It occurs to you that while the soldier is ready to obey your orders,
            you may need to do a couple of other things before commanding him to
            follow you. ";
    }
    matchDobj = (gPlayerChar)
;

// This will allow the lieutenant to help you solve the money magnet
// problem as an alternative, since people are trying it. What's weird
// about it is that it's now technically possible for Joe to press one
// button while Ajou is holding the other, or vice-versa. We'll just
// assume that's too unlikely to worry about.

++ CommandTopic [Push, Feel]
    topicResponse () {
        if ((gDobj == floggButton) || (gDobj == grabbyButton)) {
            if (flogg.getOutermostRoom() == worldHeadquarters) {
                "{The ajou} looks at you uncertainly. <q>I fear I will be observed,
                ma\'am. We are not alone.</q> ";
                exit;
            }
            if (gDobj.beingHeld) {
                if (gDobj.beingHeldBy == ajou) "He's already holding that button. ";
                else "He can't very well push that button while you're already holding it. ";
                exit;
            }
            "He obligingly presses the button for just a moment. (If you need him to hold
            the button, tell him that.) ";
            safeDoor.buttonPressed(gDobj);
        }
        else {
            "<q>I don\'t understand, ma\'am,</q> he replies. ";
            exit;
        }
    }
    matchDobj = [floggButton, grabbyButton]
;

++ CommandTopic @Hold
    topicResponse () {
        if ((gDobj == floggButton) || (gDobj == grabbyButton)) {
            if (flogg.getOutermostRoom() == worldHeadquarters) {
                "{The ajou} looks at you uncertainly. <q>I fear I will be observed,
                ma\'am. We are not alone.</q> ";
                exit;
            }
            if (gDobj.beingHeld) {
                if (gDobj.beingHeldBy == joe) "The soldier is already holding that button. ";
                else "He can't very well push that button while you're already holding it. ";
                exit;
            }
            else if (((gDobj == floggButton) && (grabbyButton.beingHeldBy == joe)) ||
                     ((gDobj == grabbyButton) && (floggButton.beingHeldBy == joe))) {
                "<q>My arms are not long enough, ma\'am,</q> he explains. <q>I can't hold both buttons at
                once!</q> ";
            }
            else {
                gDobj.beingHeld = true;
                gDobj.beingHeldBy = joe;
                
                safeDoor.buttonPressed(gDobj);
                if (gDobj.releaseFuseID == nil) {
                    local releaseFuseID = new Fuse (gDobj, &releaseFuse, 5);
                    gDobj.releaseFuseID = releaseFuseID;
                    "He obligingly sticks his hand under the desk. <q>Is this what you wish?</q> he says. ";
                }
                else "Error --- this should never print. ";
            }
        }
        else {
            "<q>I don\'t understand, ma\'am,</q> he replies. ";
            exit;
        }
    }
    matchDobj = [floggButton, grabbyButton]
;