#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>


connectorIntoDuckHuntSenate : DuckHuntSenateRoomSet,OneWayRoomConnector
	-> duckHuntSenateLowerMezzanineS
	noteTraversal(traveler) {
		if(traveler==gPlayerChar) {
			gPlayerChar.posture = standing;
		}
	}
;


class DuckHuntSenateRoomSet : RoomInSet
	roomSetId = 'DuckHuntSenateRoom'
	
	notifyBeforeArriving() {
	}
	
	notifyBeforeLeaving() {
	}

	
	roomBeforeAction() {
		if(gActionIs(Yell) || gActionIs(YellAt) || gActionIs(YellRead)) {
			"This isn't an appropriate place to yell. It's undignified. ";
			exit;
		}
	}	
;



class DuckHuntSpeech : Readable
	dobjFor(Read) {
		action() {
			if(megaphone.isIn(gPlayerChar)) {
				"(with megaphone)\n";
				nestedAction(ReadWith,gDobj,megaphone);
			} else {
				"You read the speech, but no one seems to be paying attention to you. They
				don't even seem to hear you. You shouldn't yell or shout though. That would
				be very unseemly and would probably reduce your chances of convincing
				anyone of anything. ";
			}
		}
	}
	
	dobjFor(YellRead) {
		action() {
			"You shouldn't raise your voice in here. It's unseemly to act that
			way in this dignified environment. ";
		}
	}
	
	dobjFor(ReadWith) {
		verify() {}
		check() {
			if(!gPlayerChar.roomLocation.ofKind(DuckHuntSenateRoomSet)) {
				"This isn't really the place to be giving speeches. ";
				exit;
			} else if(!gPlayerChar.isIn(duckHuntSenateCenter)) {
				"Your name is not Jimmy Stewart and you are not a senator.
				If you want to read a speech then you need to be down on the senate
				floor. ";
				exit;
			}
		}
		action() {
//			if(numTimesRead==0) {
				giveSpeechToSenate();
				++numTimesRead;
//			} else {
//				"Once again you give the speech with gusto, but you only receive
//				polite claps afterward from a few people around the room.
//				Can you blame them? Who wants to listen to the same speech multiple times? ";
//				return;
//			}
		}
	}
	
	numTimesRead = 0
;



duckHuntSpeechProGun : DuckHuntSpeech 'shiny paper/speech*papers*speeches' 'shiny paper'
	@deskLSW
	"This is a speech. You can read it if you like.
	The general gist of the speech seems to be that gun control
	is wrong and that any rules preventing the ownership of guns impinges on the
	rights of freedom loving people everywhere. "
	
	
	giveSpeechToSenate() {
	
		// This point can only be reached once. It's not possible to read the same
		// speech multiple times, so there's no need to check to see if
		// guns are currently banned, because guns start out banned.

		if(duckHuntSpeechAntiGun.numTimesRead>0) {
			"No one likes a flip flopper... except those people who like flip floppers.
			Everyone says they are flip flop haters, but the reality is that flip flop
			haters will become flip flop lovers when the flip flopper flops in the
			proper direction.\b
			
			In this case, people are confused by your sudden change of heart, but somehow
			you pull it off and people start listening.\b";
		}
		 
		"You reach deep down and give the speech of your life. You bring up
		freedom of this and that and the other thing and then talk about life
		without them. You talk about Chewbacca and discuss how he shouldn't live
		on the planet Endor which has nothing but Ewoks on it. You paint verbal
		pictures of juicy meats and angry mean tigers that maul children and how
		guns are needed to get the former and stop the latter.
		Finally, you encourage people to think of the children. You don't indicate
		in what way people should think of those children, but specifics really
		aren't all that important here.\b
		 
		That did it. Nothing says don't-vote-against-me like a request to think of the
		children. The bill passes by a decent margin.\b
		
		The use of guns is now legal.
		";
		
		gunsAreBanned = nil;
	
//		achieve.awardPointsOnce();
	}

	gunsAreBanned = true
//	achieve : Achievement {+1 "gave anti gun control speech";}
;
duckHuntSpeechAntiGun : DuckHuntSpeech 'thin paper/speech*papers*speeches' 'thin paper'
	@deskLSE
	"This is a speech. You can read it if you like. The general gist of the speech seems to be that the current
	gun control law must remain in place in order to to save lives and prevent
	organizations like Bob's Deli from taking control. "
	
	
	giveSpeechToSenate() {
		// This point can only be reached once. It's not possible to read the same
		// speech multiple times, so there's no need to check to see if
		// guns are currently banned, because guns start out unbanned.
		
		if(duckHuntSpeechProGun.numTimesRead>0) {
			"No one likes a flip flopper... except those people who like flip floppers.
			Everyone says they are flip flop haters, but the reality is that flip flop
			haters will become flip flop lovers when the flip flopper flops in the
			proper direction.\b
			
			In this case, people are confused by your sudden change of heart, but somehow
			you pull it off and people start listening.\b";
		}
		
		if(duckHuntSpeechProGun.gunsAreBanned) {
			"You give the speech all you've got, but since guns were already banned
			to begin with, your speech doesn't change anything. ";
		} else {
			"You give the speech all you've got and somehow convince people
			that everything you said before was not in fact true.
			Johnny Cochrane's wookie speech was nothing compared to this.
            The winds of politics are ever changing and somehow you manage
			to make them blow in the direction you want. Guns are now banned. ";
			duckHuntSpeechProGun.gunsAreBanned = true;
		}
	}
;


//: Possibly open a bank or something up so that you're allowed to steal
// from them after giving this speech.
duckHuntSpeechAntiTheft : DuckHuntSpeech 'rough paper/speech*papers*speeches' 'rough paper'
	@deskLSE
	"This is a speech on theft. It goes on and on about how bad stealing is and how
	good not stealing is. In other words, it's non-contentious time filling drivel
	that no rational person disagrees with. It's the sort of thing that jacks up the
	emotions of people who believe themselves morally superior to the rest of humanity.\b
	
	Of course, there's a clause in it that excludes adventurers who, you know,
	really have a right to pick up anything that isn't nailed down.
	Some people might contest that exclusionary clause,
	but honestly, how the heck do these people expect adventurers to prevent
	themselves from being eaten by a grue if they're not allowed to break into
	other people's white houses and nick any spare lanterns that may be lying around?
	Sure stealing is wrong, no one disagrees with that, but what if they really
	really need it?\b
	
	It's a good speech though. Reading it to others would probably underline what
	a caring and morally upstanding person you are... or whatever. "
			
	giveSpeechToSenate() {
		"You read the speech and people cry because it's so good. Perhaps you convinced some of
		the politicians to stop stealing? Nah, probably not. It was still a good speech though. ";
	}
	
	dobjFor(Steal) {
		action() {
			"Obviously, you qualify as an adventurer (as does anyone who wants to walk around
			and take anything they see), so you deftly take the paper despite the obvious
			fact that it is not yours. ";
			inherited();
		}
	}
;

duckHuntSpeechAgainstUglyPeople : DuckHuntSpeech 'thick paper/speech*papers*speeches' 'thick paper'
	@deskLS
	"This is a speech on ugliness. Apparently the writer of this speech really
	had a thing about ugly people. It goes to great lengths to discuss how horrible
	ugliness is and how all ugly people should be strung up. Hmm. It's possible that
	this might pass considering that most politicians need to be reasonably attractive
	in order to get elected to high office. "
		
	giveSpeechToSenate() {
		"With great confidence you stand before the senate and speak on the
		horrors of ugliness and the effect it has on the children. You pound your
		fist and raise your voice and expound upon ugliness in all its forms.\b
		
		You evoke stunning imagery of ugly zombies taking over the country and
		destroying it from within. You then mention children a few dozen more times,
		evoke nationalism in an irrelevant but convincing way, then mention children
		a few more times.\b
		
		Finally, having done your all, you step back hoarse and
		exhausted, but triumphant in your feeling that you convinced those who
		needed to be convinced. A round of applause greets you when you finish.
		A standing ovation! It appears you touched a nerve! ";
		
		inputManager.pauseForMore(nil);
		"\b\b\b\b\b\b";
		
		"A vote takes place immediately afterwards. It passes! All ugly people
		in the country are hanged without delay. The country is now a much prettier
		place.\b
		 
		Not unexpectedly, the country soon plunges into ruin.\b
		
		Email viruses soon infest every computer on the planet because
		everyone still alive now has no one to keep reminding them that they
		are not supposed to click on email attachments even if they are from
		a friend or relative (unless they check with the friend or relative first).\b
		
		Nearly all the living now think math is hard, so science and engineering
		screech to  a halt. On the plus side, everyone has really low body fat.\b
		
		With their big muscles they attempt to build houses, but they don't know anything
		about housing codes proscribing gingerbread as a building material, so millions
		are killed during rainstorms as their houses melt around them and they are
		crushed in a big gooey mess of molasses.\b
		
		A combination of viruses, natural disasters, and poor engineering result in
		the destruction of everyone on earth.\b
		
		You have destroyed humanity. Good job. Sadly, you do not get to see the horror
		you have wrought because the senators strung you up as soon as the vote passed.
		";
		
		endGame('You have been hanged.');
	}
;


megaphone : Thing 'megaphone' 'megaphone'
	@tetrisBench
	"The megaphone is a typical megaphone. It has an end to speak into and an end
	that breaks the eardrums of anyone standing too close to you when you say things
	with it. "
	
	dobjFor(SayWith) {
		verify() {}
		check() {}
		action() {
			"<q><<gLiteral.toUpper()>></q> ";
		}
	}

	dobjFor(UseIt) {
		verify() {}
		check() {}
		action() {
			"You can read things and say them with the megaphone. For instance, to read a paper
			using the megaphone, just <q>read paper with megaphone</q>. ";
		}
	}
	
	// This just makes it possible to read things with the megaphone. All
	// the handling of what happens is done in the dobj.
	iobjFor(ReadWith) {
		verify() {}
		check() {}
		action() {}
	}
;


class DuckHuntSenateMezzanine : DuckHuntSenateRoomSet,Room
	desc = "You are clearly in an important government building.
		Desks are arrayed in a half circle
		on the mezzanine. From a distance you can see that farther down in the
		center of the room is a podium.
		The room is mostly empty, but there are a few people sitting at some of
		the desks around the room. In front of every desk is a gaudy chair.
		"
		
	vocabWords = 'mezzanine'
;


class SenateDesk : Surface,Heavy 'gaudy desk*desks' 'desk'
		"There are a bunch of identical desks arrayed around the senate floor.
		Like every other desk in the area, the desk here is ornately carved
		with lots of scrolls and curly things. It doesn't have any useful things like
		drawers or pencil holders though. It's typical government furniture
		(expensive, gaudy, but not too functional). "
;
+ Decoration 'curly*scrolls*things' 'curly things'
	"More gaudy scrollwork. "
;

class SenateChair : Chair,Fixture 'gaudy chair*chairs' 'chair'
		"In front of every desk is a very fancy and expensive chair.
		Like every other chair in the area, the chair here looks like it's done out in gold
		leaf with lots of gaudy scrollwork. Despite the obvious expense of the chair,
		it clearly is very uncomfortable. It was presumably created by someone who thought
		that ergonomics are for wimps. You can just feel the sparking pains running up your
		back as an imagined old lady yells at you to sit up straight. "
		
	cannotTakeMsg = 'The chair is bolted to the ground. That\'s not really surprising.
		There are a lot of government workers in this place, so it\'s obviously best to keep
		your hands on your wallet and bolt down everything you can\'t carry with you. '
	cannotPutMsg = cannotTakeMsg
	cannotMoveMsg = cannotTakeMsg
;
+ Decoration 'gold leaf/scrollwork' 'scrollwork'
	"Very gaudy indeed. "
;



/*
duckHuntSenateUpperMezzanineSW : DuckHuntSenateMezzanine 'upper mezzanine southwest'
	desc {
		inherited();
		"You can move east along the mezzanine or you can go down to the
		lower mezzanine to the northeast. ";
	}
	east = duckHuntSenateUpperMezzanineS
	northeast = duckHuntSenateLowerMezzanineSW
	down asExit(northeast)
;
+ deskUSW : SenateDesk;
+ chairUSW : SenateChair;

duckHuntSenateUpperMezzanineS : DuckHuntSenateMezzanine 'upper mezzanine south'
	desc {
		inherited();
		"You can move east and west along the mezzanine or you can go down to the
		lower mezzanine to the north. ";
	}
	west = duckHuntSenateUpperMezzanineSW
	east = duckHuntSenateUpperMezzanineSE
	north = duckHuntSenateLowerMezzanineS
	down asExit(north)
;
+ deskUS : SenateDesk;
+ chairUS : SenateChair;

duckHuntSenateUpperMezzanineSE : DuckHuntSenateMezzanine 'upper mezzanine southeast'
	desc {
		inherited();
		"You can move west along the mezzanine or you can go down to the
		lower mezzanine to the northwest. ";
	}
	west = duckHuntSenateUpperMezzanineS
	northwest = duckHuntSenateLowerMezzanineSE
	down asExit(northwest)
;
+ deskUSE : SenateDesk;
+ chairUSE : SenateChair;
*/

duckHuntSenateLowerMezzanineSW : DuckHuntSenateMezzanine 'mezzanine southwest'
	desc {
		inherited();
		"You can move east along the mezzanine or you can go down to the senate floor to the northeast. ";
	}
	east = duckHuntSenateLowerMezzanineS
	northeast = duckHuntSenateCenter
//	southwest = duckHuntSenateUpperMezzanineSW
	down asExit(northeast)
//	up asExit(southwest)
;
+ deskLSW : SenateDesk;
+ chairLSW : SenateChair;

duckHuntSenateLowerMezzanineS : DuckHuntSenateMezzanine 'mezzanine south'
	desc {
		inherited();
		"You can move east or west along the mezzanine or you can go down to the senate floor to the north. ";
	}
	west = duckHuntSenateLowerMezzanineSW
	east = duckHuntSenateLowerMezzanineSE
	north = duckHuntSenateCenter
//	south = duckHuntSenateUpperMezzanineS
	down asExit(north)
//	up asExit(south)
;
+ deskLS : SenateDesk;
+ chairLS : SenateChair;

duckHuntSenateLowerMezzanineSE : DuckHuntSenateMezzanine 'mezzanine southeast'
	desc {
		inherited();
		"You can move west along the mezzanine or you can go down to the senate floor to the northwest. ";
	}
	west = duckHuntSenateLowerMezzanineS
	northwest = duckHuntSenateCenter
//	southeast = duckHuntSenateUpperMezzanineSE
	down asExit(northwest)
//	up asExit(southeast)
;
+ deskLSE : SenateDesk;
+ chairLSE : SenateChair;



duckHuntSenateCenter : DuckHuntSenateRoomSet,Room 'senate floor'
	"This is the senate floor. There is a podium in the center of the floor.
	The podium is very useful if you are trying to get
	other people to spend taxes in some way that hasn't been thought of yet. "
	southwest = duckHuntSenateLowerMezzanineSW
	south = duckHuntSenateLowerMezzanineS
	southeast = duckHuntSenateLowerMezzanineSE
	up asExit(south)
;
+ podium : DuckHuntSenateRoomSet,Booth,Fixture 'podium' 'podium'
	"This is a podium behind which people often speak.
	Do you feel that other people have too much money? If so then you are in the
	right place! Speak away! "
	
	actorInPrep = 'behind'
;

// This is the podium as seen from the mezzanine areas
MultiLoc,Distant 'podium' 'podium' "The podium stands in the distance seemingly inviting people to speak."
	initialLocationClass = DuckHuntSenateMezzanine
	isPlural = true
;

theDistantPeople : MultiLoc,Distant 'people' 'people' "There are a few people scattered around the room. "
	initialLocationClass = DuckHuntSenateRoomSet
	isPlural = true
;

/*
SenseConnector, Intangible
	transSensingThru(sense) {
		return distant;
	} 
	
	initialLocationClass = DuckHuntSenateRoomSet
;
*/




class SenatePerson : Person
	isHim = true
	posture = sitting
	
	dobjFor(Attack) {
		verify() {}
		check() {}
		action() {
			"That would not be a good idea.
			Rule #1 in politics: Never attack, assault, or physically hurt those people that can
			vote against issues that you are interested in. ";
		}
	}
	dobjFor(Push) asDobjFor(Attack)
	dobjFor(Pull) asDobjFor(Attack)
;

+ snobbySenatorState : HermitActorState
	noResponse = "<<responseList.doScript()>>"

	responseList : StopEventList {
		[
		'He glances at you, determines that you are not a powerful political figure, and proceeds
		to ignore you. '
		,'He really has no interest in talking with you. '
		]
		}
//	isInitState = true
;



class OfKindTopic : object
	matchTopic(fromActor,obj) {
		return obj.ofKind(topicObjClass) ? matchScore : nil;
	}	
	topicObjClass = nil
;
class AskTellGiveShowOfKindTopic : OfKindTopic,AskTellGiveShowTopic;
class GiveShowOfKindTopic : OfKindTopic,GiveShowTopic;
class AskTellOfKindTopic : OfKindTopic,AskTellTopic;
class AskTellAboutForOfKindTopic : OfKindTopic,AskTellAboutForTopic;


+ niceSenatorState : ActorState
;
	++ AskTellGiveShowTopic topicObjClass=SenateChair topicResponse="<q>Everyone around here agrees that these chairs are terrible.</q> ";
	++ AskTellAboutForOfKindTopic topicObjClass=SenateDesk  topicResponse="<q>These desks do the job. You can put papers on them and sleep on them. What more could I ask for?</q> ";
	++ AskTellGiveShowOfKindTopic topicObjClass=DuckHuntSpeech  topicResponse="The man
		smiles and says, <q>These are speeches.
		Most of them follow the heptagonal philosophy of politics.
		The heptagonal philosophy of politics involves person A trying to get money for group B
		by convincing group C to give group D money from group E.
		Group D then distributes that money to groups B, F, and G.
		Generally, group E thinks it's ok to give money to groups F and G, but they don't want
		the money given to group B. However, the number of levels they are removed from the
		actual money distribution ensures that their money is distributed based on group C's
		desires and not group D's desires. See, it's simple! Now you know how to be a politician.</q> "
		;		
	++ AskTellTopic @theDistantPeople  topicResponse="<q>There aren't many people in here today.</q> ";
	++ AskTellTopic @podium  topicResponse="<q>That's where people give speeches.</q> ";



senator1 : SenatePerson
	name = 'tall thin senator'
	vocabWords = 'tall thin senator'

	location = chairLS
	curState = snobbySenatorState
	posture = sitting
	
	specialDesc = "A tall thin senator is sitting in the chair here, leaning over his desk. "
	desc = "He's a stylish devil, but his nose shape implies that he is rather snobby. "
;

senator2 : SenatePerson
	name = 'short chubby senator'
	vocabWords = 'short chubby senator'
	
	location = chairLSE
	curState = snobbySenatorState
	posture = sitting
	
	specialDesc = "A short chubby senator is sitting casually in a chair here. "
	desc = "He seems like a jolly nice fellow. "
;

