/*
** Common Ground
** Copyright (c) 1999 by Stephen Granade.  All Rights Reserved.
**
** Developed using TADS: The Text Adventure Development System
**
** Programming Begun: 14 March 1999
**
*/

// Since this is an HTML TADS game, let's use the HTML status line
#define USE_HTML_STATUS

// The version of the game. Do *NOT* forget to alter the version
// information contained in the version_info object, found in gndmenu.t
#define VERSION '2'

#include        <adv.t>         // Standard stuff
#include        "gndadv.t"      // Wacky stuff
#include        "gndstd.t"      // Nonstandard stuff
#include        "checks.t"      // Check version number &c.
#include        "menus.t"       // Help menus &c.
#include        "gndh.t"        // New verbs, etc.
#include        "gndthing.t"    // A new, more personal thing
#include        "gndparse.t"    // Parser magic

#include        "gndhaus1.t"    // The house (2nd story)
#include        "gndhaus2.t"    // The house (1st story)
#include        "gndbus.t"      // The bus station
#include        "gndjean.t"     // Jeanie
#include        "gndfrank.t"    // Frank
#include        "gnddeb.t"      // Deb
#include        "gndmenu.t"     // Menus for the game

// Here's my suite of debugging verbs.

#pragma C+

#ifdef __DEBUG

// Gimme that object!
gimmeVerb: sysverb
  verb = 'gimme'
  sdesc = "gimme"
  doAction = 'Gimme'
  validDo(actor, obj, seqno) = {
    if (obj.noGimme) return nil;
    return true;
  }
  validDoList(actor, prep, dobj) = nil
;

// Where'd I leave that object?
whereVerb: sysverb
  verb = 'where' 'whereis'
  sdesc = "where"
  doAction = 'Where'
  validDo(actor, obj, seqno) = {
    if (obj.noWhere) return nil;
    return true;
  }
  validDoList(actor, prep, dobj) = nil
;

// Teleport to an object
bamfVerb : sysverb
  verb = 'bamf'
  sdesc = "bamf"
  doAction = 'Bamf'
  validDo(actor, obj, seqno) = {
    if (obj == nil || obj.noBamf)
      return nil;
    return true;
  }
  validDoList(actor, prep, dobj) = nil;
;

modify thing
  verDoGimme(actor) = {
    if (isclass(self, floatingItem))
      "Not a good idea--<<self.thedesc>> is a floating item.  ";
  }
  doGimme(actor) = {
    self.moveInto(actor);
    "Poof! \^<<self.thedesc>> appears.";
  }
  verDoBamf(actor) = {
    if (self.location == nil and (!isclass(self, room)))
      "\^<<self.thedesc>> is nowhere--you can't go there!  ";
    else if (isclass(self, floatingItem))
      "\^<<self.thedesc>> is a floating item, so you can't bamf to it.  ";
  }
  doBamf( actor ) = {
    local loc;

    loc = self;
    while (loc and (!isclass(loc, room)))
      loc = loc.location;
    if (loc) {
      "Bamf!\b";
      parserGetMe().travelTo(loc);
    }
    else "Bamf failed.  ";
  }
  verDoWhere(actor) = {}
  doWhere(actor) = {
    "\^<<self.thedesc>> is ";
    if (self.location == nil)
      "nowhere. ";
    else
      "in <<self.location.sdesc>>.  ";
  }
;

modify fixeditem
  doGimme(actor) = {
    self.moveInto(actor.location);
    "Poof! \^<<self.thedesc>> appears.";
    if (!self.isactor) self.isListed = true;
  }
;

// Turn on Jeanie's search for billfold
findbillfold: deepverb
    sdesc = "findbillfold"
    verb = 'findbillfold'
    action(actor) = {
	"Jeanie's now looking for billfold. ";
	jeanieMe.lookingForBillfold = true;
    }
;

// Make Frank command that the TV be turned off
forceofftv: deepverb
    sdesc = "forceofftv"
    verb = 'forceofftv'
    action(actor) = {
	"Making Frank want that TV off. ";
	tv.currentBand = length(tv.bandList);
    }
;

// Shazam! I'm now Frank
makemefrank: deepverb
    sdesc = "makemefrank"
    verb = 'makemefrank'
    action(actor) = {
	prepareForFrank();
    }
;

// Shazam! Now I'm Deb
makemedeb: deepverb
    sdesc = "makemedeb"
    verb = 'makemedeb'
    action(actor) = {
	prepareForDeb();
    }
;

// Shazam! Make me Jeanie
makemejeanie: deepverb
    sdesc = "makemejeanie"
    verb = 'makemejeanie'
    action(actor) = {
	reprepareForJeanie();
    }
;

#endif
