/*
** GndFrank.t holds all the definitions etc. for Frank
**
** Copyright (c) 1999, Stephen Granade. All rights reserved.
*/

#pragma C+

frankMe: basicMe
    sdesc_pointer = &f_sdesc
    ldesc_pointer = &f_ldesc
    ldesc1_pointer = &f_ldesc1
    // Initialize the list with three absents
    jeanieActionList = ['A', 'A', 'A']
    pendingAction = ''
    currentAction = 1
    acceptingActions = nil
    respondingToJeanie = nil   // True while Jeanie's in the haus
    justTalkedToJeanie = nil   // Did Frank initiate conversation?
    sawBillfold = nil          // Did I see the billfold under the table
    actionChunk = 3            // Max actions we'll chunk together
    actionsOnSpeed = nil       // Is Frank bored?
    // jeanieTalkList is the list of conversation threads w/Jeanie
    jeanieTalkList = [ &conversationj5a, &conversationj6a ]
    jeanieCurrentTalk = 1      // Which possible conversation thread w/Jeanie
                               // are we on?

    f_sdesc = "you"
    f_ldesc = "You feel a lot better now that you're
	       home from the factory and wearing a t-shirt
	       and some jeans. "
    moveInto(room) = {
	if (room == franks_chair && !self.respondingToJeanie) {
	    self.respondingToJeanie = true;
	    notify(self, &advanceJResponses, 0);
	}
	pass moveInto;
    }
    // realizeJeanieLeft is called when Frank realizes she's gone. That
    // happens when a) the toaster is fixed and the player tries to stand
    // up, or b) we run out of actions for Jeanie to do
    realizeJeanieLeft = {
	"\bThe sound of the front door slamming startles you. Jeanie's
	 left already? Wonder where she's going.\b";
	prepareForDeb();
    }
    queueAction(act) = {
	if (!global.pauseRecorder && self.acceptingActions)
	    self.pendingAction = act;
    }
    addAction = {
	if (self.pendingAction != '') {
	    self.jeanieActionList += self.pendingAction;
	    self.pendingAction = '';
	}
	else {
	    if (jeanieMe.isIn(living_room))
		self.jeanieActionList += 'Z';  // Z for wait
	    else self.jeanieActionList += 'A'; // A for absent
	}
    }
    nextStarredResponse = {
	local i = self.currentAction, len = length(self.jeanieActionList);

	while (i <= len &&
	       substr(self.jeanieActionList[i], 1, 1) != '*' &&
	       substr(self.jeanieActionList[i], 1, 1) != '!')
	    i++;
	return (i <= len && self.jeanieActionList[i]);
    }
    conversationTookPlace(code) = {
	local i = self.currentAction, len = length(self.jeanieActionList);

	while (i < self.currentAction + 3 && i <= len &&
	       self.jeanieActionList[i] != code)
	    i++;
	return (i <= len && self.jeanieActionList[i] == code);
    }
    speedUpActions = {
	if (self.actionChunk == 3)
	    self.actionChunk = 5;
	else self.actionsOnSpeed = true;
    }
    advanceJResponses = {
	local i = 0, ch = '', action, len = length(self.jeanieActionList);

	if (self.currentAction > len || parserGetMe() != self) {
	    if (self.currentAction > len)
		self.realizeJeanieLeft;
	    unnotify(self, &advanceJResponses);
	    return;
	}
	// Frank skips thru a chunk of actions at a time
	while (i < self.actionChunk && ch != '*' && ch != '!' &&
	       self.currentAction + i <= len) {
	    action = self.jeanieActionList[self.currentAction + i];
	    ch = substr(action, 1, 1);
	    if (ch != '*' && ch != '!')
		switch (ch) {
		  case 'L':      // Jeanie leaves
		    jeanie.moveInto(nil);
		    break;
		  case 'E':      // Jeanie enters
		    jeanie.moveInto(living_room);
		    break;
		  case 's':      // J sits on couch
		    jeanie.onCouch = true;
		    break;
		  case 'S':      // J stands
		    jeanie.onCouch = nil;
		    break;
		  case 'D':      // J drops bag
		    switch (substr(action, 2, 1)) {
		      case 'L':  //   in living room
			flowerdy_bag.moveInto(living_room);
			break;
		      case 'C':  //   on couch
			flowerdy_bag.moveInto(couch);
			break;
		    }
		    break;
		  case 'P':      // J picks up bag
		    flowerdy_bag.moveInto(nil);
		    break;
		}
	    else switch (substr(action, 2, 1)) {
	      case 'H':          // Frank says hi to Jeanie
		"\bJeanie comes clumping down the stairs. She's all dressed
		 up, with her plaid shirt tied so that you can see her
		 midriff. <q>You going out again tonight?</q> you ask her.
		 She doesn't answer. ";
		jeanie.moveInto(living_room);
		break;
	      case 'M':          // Jeanie massages Frank
		"\bYou're startled by Jeanie putting her hands on your
		 shoulders. <q>You look tense,</q> she whispers in your
		 ear, her thumbs digging into sore muscles. You feel
		 the tension across your back slowly loosening. Deb
		 used to do this whenever she was&mdash;
		 \bDeb! What'd she say if she saw this? You gently
		 remove Jeanie's hands from your shoulders. <q>That's
		 not a good idea,</q> you tell her. She backs away
		 looking puzzled. ";
		break;
	      case 'T':          // We tell J to turn off TV...
		switch (substr(action, 3, 1)) {
		  case 'l':    // ...when she leaves
		    "\bYou realize that you've been hearing the TV for
		     some time and that Jeanie's leaving the room. <q>Turn
		     off that TV if you're leaving,</q> you tell her.
		     She grudgingly obeys, then walks out. ";
		    jeanie.moveInto(nil);
		    break;
		  case 's':    // ...for excessive switching
		    "\bJeanie keeps turning the TV on and off, on and off.
		     It gets to be too much for you; you twist around in
		     your chair and say, <q>Could you leave the TV off
		     for a while?</q>
		     \b<q>C'mon, Frank, I'm just trying to relax!</q>
		     \bYou sigh. <q>I'm trying to fix this toaster before
		     your mom gets home, and the TV keeps distracting me.
		     Okay?</q> ";
		    break;
		  case 't':    // ...after time has elapsed
		    "\bThe TV, which has been on for a while, keeps
		     irritating you more and more. Eventually you can't
		     stand it any more. <q>That's enough TV for now,
		     Jeanie.</q>
		     \b<q>But, Frank! It's not like I've got anything
		     else to do around here!</q>
		     \bYou sigh. <q>Please, find something else that won't
		     keep distracting me. Okay?</q> ";
		    break;
		}
	      case 'C':          // J converses with us
		switch (substr(action, 3, 1)) {
		  case 'b':      // J asks about billfold
		    if (self.justTalkedToJeanie)
			i--;     // Since we just talked to Jeanie,
		                 // wait a turn before talking
		    else {
			"\b<q>Hey, Frank,</q> Jeanie asks. <q>You seen
			 my billfold?</q> That's rich. If you kept up
			 with her billfold, she sure as hell wouldn't
			 be wasting all her money like she does. ";
			self.setResponse(&answerBillfoldQuestion, jeanie);
		    }
		    break;
		  case 'c':      // J complains about TV
		    switch (substr(action, 4, 1)) {
		      case '1':  // First complaint
			if (self.justTalkedToJeanie)
			    i--; // Since we just talked to Jeanie,
			         // wait a turn before talking
			else {
			    "\bJeanie says, <q>Frank, I'm headed out in a
			     little while. Why can't I have the TV on?</q> ";
			    self.setResponse(&complainAboutTV1, jeanie);
			}
			break;

		      case '2':  // Frank has to respond
			if (frank.respondedToCc2 == true) // Already responded
			    break;
			"\b<q>Hey, Frank, I asked you why I can't watch
			 TV.</q>
			 \bYou feel your shoulders getting tense. Jeanie's
			 whining does that to you. <q>I told you already.
			 Because it was bothering me.</q>
			 \b<q>That's just dumb,</q> she mutters. ";
			self.setResponse(&complainAboutTV2, jeanie);
			break;

		      case '3':  // The final complaint
			if (frank.respondedToCc3 == true) // Already responded
			    break;
			"\bYou can hear Jeanie tapping her foot behind you.
			 She can not say things louder than anybody you know.
			 <q>Look,</q> you say, turning to face her, <q>your
			 mom's been asking me to fix this toaster for a
			 while. I want to finish it before she gets home,
			 and I can't do that if I keep listening to the
			 TV.</q> You point to the toaster. <q>I'm almost
			 done with it, and then you can turn the TV
			 back on.</q>
			 \b<q>It's not like I'll have it up real loud,
			 you won't even hear it&mdash;</q> The whole time
			 she's going on, you can feel your shoulders knotting.
			 It finally gets to be too much.
			 \b<q>I said I wanted that TV off and by God it's
			 going to stay off, you hear?</q> You take a deep
			 breath. <q>All I'm asking for is some quiet,</q>
			 you say more calmly. <q>Please.</q> Judging from
			 the look Jeanie shoots you, she doesn't much care
			 what you're asking for. ";
			self.clearResponse;
			frank.yelledAtJeanieAboutTV = true;
			break;
		    }
		    break;
		  case '1':      // Conversation about toaster
		    if (self.actionsOnSpeed) {
			ch = ''; // If we're hurrying, skip this convers.
		    }
		    else switch (substr(action, 4, 1)) {
		      case 'a':
			if (self.justTalkedToJeanie)
			    i--; // Since we just talked to Jeanie,
			         // wait a turn before talking
			else {
			    "\b<q>What'cha working on?</q> You look up to
			     find Jeanie looking at the toaster like she's
			     never seen one before. ";
			    self.setResponse(&conversationj1a, jeanie);
			    jeanie.onCouch = nil;  // She gets up when she
			}                          // talks in this case
			break;
		      case 'b':  // Don't force a response here
			break;
		    }
		    break;
		  case '2':      // Conversation about where Mom went
		    if (self.actionsOnSpeed) {
			ch = ''; // If we're hurrying, skip this convers.
		    }
		    switch (substr(action, 4, 1)) {
		      case 'a':
			if (self.justTalkedToJeanie)
			    i--; // Since we just talked to Jeanie,
			         // wait a turn before talking
			else {
			    "\b<q>Where's mom, Frank?</q> Jeanie asks you. ";
			    self.setResponse(&conversationj2a, jeanie);
			}
			break;
		      case 'b':  // Shh! No response necessary
			break;
		    }
		    break;
		  case '3':      // Jeanie asks for money
		    switch (substr(action, 4, 1)) {
		      case 'a':
			if (self.justTalkedToJeanie)
			    i--; // Since we just talked to Jeanie,
			         // wait a turn before talking
			else {
			    "\bJeanie clears her throat. You brace
			     yourself for whatever she wants. <q>Um,
			     can I borrow some cash for tonight?
			     'Cause I'm kinda short.</q> ";
			    self.setResponse(&conversationj3a, jeanie);
			}
			break;
		      case 'b':  // She asks some more
			if (frank.respondedTof3a == true) // Already responded
			    break;
			"\b<q>So, about that money....?</q>
			 \bWhen is it not about money with her? <q>You know
			 money's tight now.</q>
			 \b<q>Money's always tight.</q> Her voice gives
			 you a headache every time she starts whining like
			 this. <q>I only need a twenty.</q> ";
			if (!self.conversationTookPlace('!C3c'))
			    "\bShe only needs a twenty. Does she even
			     listen to you? <q>I told you. Money's tight.
			     Fixing the station wagon took all our extra
			     money this month.</q>
			     Thankfully, she keeps her mouth shut after
			     that. ";
			self.setResponse(&conversationj3b, jeanie);
			break;
		      case 'c':  // The final whine
			if (frank.respondedTof3b == true) // Already responded
			    break;
			"\b<q>Um, if you don't have a twenty....</q>
			 \bDoes she even listen to you? <q>I told you.
			 Money's tight. Fixing the station wagon took all
			 our extra money this month.</q>
			 \bShe just doesn't know when to leave well enough
			 alone. Jeanie moves beside your desk. You look
			 up at her.
			 <q>How much would it hurt you to give me something
			 every once in a while, huh?</q>
			 \bYou look at your desk. You may love her, but
			 at times like this you want to spank her like
			 she was six again. God, you hope Deb's right
			 and this is just a phase. <q>I give you a house,
			 a bed, and as much food as you can shove in your
			 mouth. You want money? Why don't you go earn
			 it?</q> You deliberately stare at the toaster
			 in the hopes Jeanie will go away. She does. ";
			self.clearResponse;
			frank.yelledAtJeanieAboutMoney = true;
			jeanie.onCouch = nil;  // She gets up when she
			break;                 // talks in this case
		    }
		    break;
		}
	    }
	    i++;
	}
	self.currentAction += i;
	// The 'just talked to' flag can now be reset
	self.justTalkedToJeanie = nil;
    }
    talkTo(person) = {
	if (self.makeResponse(person)) return;
	if (person == jeanie) {
	    if (frank.yelledAtJeanieAboutTV ||
		frank.yelledAtJeanieAboutMoney)
		"She's sulking as dramatically as she can. When she's in
		 that kind of mood, you're better off leaving her be. ";
	    else if (self.jeanieCurrentTalk > length(self.jeanieTalkList))
		"As snappy as she's been tonight, you'd just as soon not
		 hear her talk right now. ";
	    else {
		self.(self.jeanieTalkList[self.jeanieCurrentTalk]);
		self.jeanieCurrentTalk++;
	    }
	}
	else if (person == self)
	    "Hey, you're not that crazy yet. ";
	else "Hey! How come you can talk to <<person.sdesc>>?
	      <i>{Error}</i>. ";
    }
    answerBillfoldQuestion = {
	if (self.sawBillfold)
	    "<Q>In the kitchen,</Q> you tell Jeanie. ";
	else "<q>I don't keep up with your billfold,</q> you tell Jeanie. ";
	self.justTalkedToJeanie = true;
	return true;
    }
    complainAboutTV1 = {
	"<q>I told you already. Because the TV was bothering me,</q> you
	 say. ";
	if (self.conversationTookPlace('!Cc2')) {
	    "\b<q>That's just dumb,</q> she mutters. ";
	    self.setResponse(&complainAboutTV2, jeanie);
	}
	else clearResponse;
	frank.respondedToCc2 = true;
	return true;
    }
    complainAboutTV2 = {
	"<q>Look,</q> you say, turning to face her, <q>your mom's
	 been asking me to fix this toaster for a while. I want to
	 finish it before she gets home, and I can't do that if I
	 keep listening to the TV.</q> You point to the toaster.
	 <q>I'm almost done with it, and then you can turn the TV
	 back on.</q> ";
	if (self.conversationTookPlace('!Cc3')) {
	    "\b<q>It's not like I'll have it up real loud,
	     you won't even hear it&mdash;</q>
	     \bThe whole time she's going on, you can feel your
	     shoulders knotting. It gets to be too much. <q>I said I
	     wanted that TV off and by God it's going to stay off,
	     you hear?</q> You take a deep breath. <q>All I'm asking
	     for is some quiet,</q> you say more calmly.
	     <q>Please.</q> Judging from the look Jeanie shoots you,
	     she doesn't care what you're asking for. ";
	    frank.yelledAtJeanieAboutTV = true;
	}
	self.clearResponse;
	frank.respondedToCc3 = true;
	return true;
    }
    conversationj1a = {
	"<q>It's a toaster,</q> you tell Jeanie, since she can't
	 figure it out by herself. ";
	if (self.conversationTookPlace('*C1b')) {
	    "\b<q>Oh. What's wrong with it?</q> ";
	    self.setResponse(&conversationj1b, jeanie);
	}
	else self.clearResponse;
	return true;
    }
    conversationj1b = {
	"You briefly toy with the idea of saying, <q>It's
	 broken,</q> but she seems almost interested. <q>Well, ";
	if (!heating_element.tested)
	    "I think the heating element might be shorting.";
	else {
	    "I thought the heating element was shorting, but it's
	     okay. With these old clunkers, just about anything can
	     go wrong. ";
	    if (frayed_power_cord.tested)
		"But it turns out it was the power cord, so I gotta
		 replace it.";
	    else "I guess I'll just keep testing things until I find
		  out what's busted.";
	}
	"</q>\b<q>Oh,</q> she says, and wanders away. Guess she wasn't
	 that interested. ";
	self.clearResponse;
	self.justTalkedToJeanie = true;
	return true;
    }
    conversationj2a = {
	"<q>She's gone to the Pig,</q> you tell her. <q>Why, was there
	 something you wanted her to get?</q> ";
	if (self.conversationTookPlace('*C2b')) {
	    "\bShe shakes her head. <q>Nah.</q> You shrug and turn back to
	     the toaster. ";
	}
	self.clearResponse;
	return true;
    }
    conversationj3a = {
	"<q>You know money's tight right now,</q> you tell Jeanie.
	 Besides, when does she not want money? ";
	if (self.conversationTookPlace('!C3b')) {
	    "\b<q>Money's always tight.</q> Her voice gives you a
	     headache every time she starts whining like this.
	     <q>I only need a twenty.</q> ";
	    self.setResponse(&conversationj3b, jeanie);
	}
	else self.clearResponse;
	frank.respondedTof3a = true;
	return true;
    }
    conversationj3b = {
	"Does Jeanie even listen to you? <q>I told you. Money's tight.
	 Fixing the station wagon took all our extra money this month.</q> ";
	if (self.conversationTookPlace('!C3c')) {
	    "\bShe doesn't know when to leave well enough alone.
	     Jeanie moves beside your desk. You look up at her.
	     <q>How much would it hurt you to give me something
	     every once in a while, huh?</q>
	     \bYou look at your desk. You may love her, but
	     at times like this you want to spank her like
	     she was six again. God, you hope Deb's right and this is
	     just a phase. <q>I give you a house, a bed, and as much
	     food as you can shove in your mouth. You want money? Why
	     don't you go earn it?</q> You deliberately stare at the
	     toaster in the hopes Jeanie will go away. She does. ";
	    frank.yelledAtJeanieAboutMoney = true;
	    jeanie.onCouch = nil;  // She gets up when she confronts Frank
	}
	else "Thankfully, she doesn't say anything back. ";
	self.clearResponse;
	frank.respondedTof3b = true;
	return true;
    }
    conversationj5a = {
	"You decide to take a break from messing with the toaster. <q>So,</q>
	 you ask Jeanie, <q>how was school?</q>
	 \bIt's a stupid question, and you realize just how stupid it is
	 right after you say it. Jeanie sighs. <q>How do you think it
	 was?</q> ";
	self.setResponse(&conversationj5b, jeanie);
	self.justTalkedToJeanie = true;
	return true;
    }
    conversationj5b = {
	"<q>I hated school, too. Couldn't wait to graduate.</q>
	 \b<q>Yeah? Why'd you even bother? Not like you need a diploma to
	 do factory work.</q>
	 \bShould of known better than to even try to talk to her. ";
	self.clearResponse;
	self.justTalkedToJeanie = true;
	return true;
    }
    conversationj6a = {
	"<q>Where you going tonight?</q> you ask Jeanie as you lean back in
	 the chair and stretch.
	 \b<q>Just out.</q> ";
	self.setResponse(&conversationj6b, jeanie);
	self.justTalkedToJeanie = true;
	return true;
    }
    conversationj6b = {
	"You roll your shoulders some";
	if (frank.jeanieTriedToRubMe)
	    ", but stop before Jeanie sees and tries to give you another
	     massage. ";
	else " to work the kinks out of them. ";
	"<q>Just out? Seems like you oughta stay in and rest up before
	 school tomorrow.</q>
	 \b<q>Look,</q> she snaps, <q>Mom okayed it. I'm just going to
	 ride around a while.</q>
	 \b<q>Whoa, whoa, okay.</q> You decide to drop the whole thing.
	 No skin off your nose if she wants to be tired tomorrow. ";
	self.clearResponse;
	self.justTalkedToJeanie = true;
	return true;
    }
;

frank: Actor
    isHim = true
    yelledAtJeanieAboutTV = nil
    yelledAtJeanieAboutMoney = nil
    jeanieTriedToRubMe = nil       // Jeanie tried to give me a massage
    massageHappenedRecently = nil  // True if massage was in last two moves
    // Conversation flags for frankMe.
    respondedToCc2 = nil
    respondedToCc3 = nil
    respondedTof3a = nil
    respondedTof3b = nil
    j_ldescCounter = 1
    j_ldescStrings = ['frowning at it from time to time',
		      'turning it over in his hands',
		      'peering deep into its insides',
		      'pulling a strand of wires apart one by one',
		      'reattaching something inside it',
		      'staring at in in contemplation',
		      'tugging on something inside it']
    noun = 'frank' 'dad' 'step-dad'
    location = living_room
    sdesc = "Frank"
    thedesc = "Frank"
    adesc = "Frank"
    j_ldesc = {
	if (jeanie.gotYelledAtAboutTV || jeanie.gotYelledAtAboutMoney) {
	    "All Frank cares about is that stupid toaster he's
	     working on. Makes you want to do something, anything, to
	     make him notice you. ";
	    return;
	}
	"Frank's dressed in that ratty old Bud t-shirt of his and
	 a greasy pair of jeans. He's working hard on ";
	if (jeanie.askedAboutWork1)      // Jeanie knows it's a toaster
	    "that toaster";
	else "some appliance";
	", <<self.j_ldescStrings[self.j_ldescCounter]>>. ";
	if (getfuse(self, &advance_j_ldescCounter) == nil &&
	    self.j_ldescCounter != length(j_ldescStrings))
	    notify(self, &advance_j_ldescCounter, 5);
    }
    advance_j_ldescCounter = { self.j_ldescCounter++; }
    resetRecentMassageFlag = { self.massageHappenedRecently = nil; }
    d_ldesc = "Frank is studying that broken toaster intently. "
    actorDesc = "Frank is sitting in the chair, hunched over his desk. "
    takedesc = "He's far too large for that. "
    verDoRub(actor) = {
	if (actor == debMe)
	    "Every time you do, he thinks you're in the mood. You
	     don't feel like fending him off right now. ";
	else if (actor == jeanieMe && (jeanie.gotYelledAtAboutTV ||
				  jeanie.gotYelledAtAboutMoney))
	    "Like you'd touch him after he yelled at you like that. ";
	else if (self.jeanieTriedToRubMe)
	    "He didn't seem to like the idea first time you tried
	     it. ";
    }
    doRub(actor) = {
	local stat;

	"You head over to Frank. <q>Your neck's tense. Lemme rub it.</q>
	 You put your hands on his shoulders and begin kneading them.
	 \bBefore you get too into it, Frank shrugs his shoulders, then
	 pushes your hands away. <q>Don't do that,</q> he says. ";
	self.jeanieTriedToRubMe = true;
	self.massageHappenedRecently = true;
	notify(self, &resetRecentMassageFlag, 2);
	frankMe.queueAction('*M');
	if (actor.location == couch) {
	    stat = outhide(true);
	    couch.doUnboard(actor);
	    outhide(stat);
	}
    }
    verDoHelp(actor) = {
	if (actor == jeanieMe) {
	    if (jeanie.gotYelledAtAboutTV ||
		jeanie.gotYelledAtAboutMoney)
		"Like hell you'd help him now. ";
	    else "He'd just yell at you every time you messed up. ";
	}
	else if (actor == debMe)
	    "Oh, Frank doesn't like it when you try to help him with his
	     projects. ";
    }
    verDoKiss(actor) = {
	if (actor == jeanieMe)
	    "Ew. ";
	else if (actor == debMe)
	    "You don't want to distract him. Besides, you're not really
	     in the mood tonight. ";
	else "You like yourself and all, but c'mon. ";
    }
    verDoScrew(actor) = {
	if (actor == jeanieMe)
	    "Sure, like you're that chick you read about in English.
	     Lolata. ";
	else if (actor == debMe)
	    "You're really not in the mood tonight. ";
    }
    verDoTouch(actor) = {
	if (actor == jeanieMe)
	    "Don't be gross. ";
	else if (actor == debMe)
	    self.verDoKiss(actor);
	else pass verDoTouch;
    }
    ioGiveTo(actor, dobj) = {
	if (actor == jeanieMe)
	    "As little as he's given you, why should you give him
	     anything? ";
	else if (actor == debMe)
	    "You don't want to disturb him. ";
    }
    ioSynonym('GiveTo') = 'ThrowTo'
    verDoAttack(actor) = {
	if (actor == jeanieMe) {
	    if (jeanie.gotYelledAtAboutTV || jeanie.gotYelledAtAboutMoney)
		"Damn, you'd love to. You'd love to. ";
	    else "He'd hit back. ";
	}
	else if (actor == debMe)
	    "Don't be silly. ";
    }
    doSynonym('Attack') = 'Kick' 'Push' 'Pull' 'Poke'
    verIoThrowAt(actor) = ( self.verDoAttack(actor))
    verDoDust(actor) = {
	if (actor == jeanieMe)
	    "Yeah, he doesn't move much, but he wouldn't think that was
	     funny. ";
	else "Don't be silly. ";
    }
;

// Here's where we do everything we need to do to the house in order to
// prepare for switching the player from Jeanie to Frank
prepareForFrank: function
{
    // Write the last Deb action
    debMe.addAction;

    // Move Jeanie's clothes to the new her
    cut_offs.moveInto(jeanie);
    plaid_shirt.moveInto(jeanie);

    // The doors in the 2nd floor hall
    delword(jeanie_door_hall, &adjective, 'my');
    delword(jeanie_door_hall, &adjective, 'bedroom');
    addword(parents_door_hall, &adjective, 'my');
    addword(parents_door_hall, &adjective, 'bedroom');
    addword(parents_door_bedroom, &adjective, 'my');

    jeanie_bath_bath.moveInto(nil);   // Only Jeanie needs a 'bath'
    jeanie_door_hall.setIsopen(true); // Jeanie's door should be open

    addword(waterbed, &adjective, 'my');

    broken_appliances.moveInto(nil);
    broken_toaster.moveInto(nil);
    remote.moveInto(nil);           // Frank can't find the remote
    groceries.moveInto(nil);
    flowerdy_bag.moveInto(nil);
    furniture.moveInto(parents_bedroom);
    old_stereo.moveInto(living_room);
    fake_billfold.moveInto(kitchen);
    franks_boots.moveInto(nil);

    // Stuff on the desk
    toaster.moveInto(little_desk);
    junk_box.moveInto(little_desk);
    screwdriver.moveInto(little_desk);
    multimeter.moveInto(little_desk);

    // Stop monitoring Jeanie's actions
    frankMe.acceptingActions = nil;
    debMe.acceptingActions = nil;

    // Prepare for the 1st time Frank steps into the living room
    living_room.isseen = nil;

    jeanieMe.moveInto(nil);
    frank.moveInto(nil);
    deb.moveInto(nil);
    fake_jeanie.moveInto(second_story_hall);
    parserSetMe(frankMe);
    frankMe.moveInto(kitchen);

    morePrompt();
    clearscreen();
    if (global.canDoGraphics)
	gprintf('two.png', 'alt="Two"');
    else "\(Two\)\n";
    "\nThat toaster's been giving you fits the last few nights.
     <q>Could you fix it?</q> Deb asks, like it's the easiest thing
     in the world. Least now you're pretty sure it's the power
     cord and not anything more serious. It oughta be a quick enough fix.
     \bQuick enough once you get a drink, that is.\b";
    execCommand(frankMe, lookVerb, nil, nil, nil, 0);
}

// A fake Jeanie object for upstairs
fake_jeanie: fixeditem, twodescthing
    noun = 'jeanie' 'daughter'
    sdesc = "Jeanie"
    thedesc = "Jeanie"
    adesc = "Jeanie"
    f_ldesc1 = "She keeps walking back and forth in her room, so you can
		only see her now and then. But you keep staring into the
		room, thinking of when she was little and happy. "
    f_ldesc = "You can only see Jeanie every once in a while. Looks like
	       she's picking herself out an outfit. "
    dobjGen(a, v, i, p) = {
        if (v != inspectVerb) {
	    "Jeanie notices you through the doorway and sighs. She shuts
	     her door, and you hear the click of the lock being pushed. ";
	    self.jeanieClosesDoor;
            exitobj;
        }
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
    actorAction(v, d, p, i) = { self.dobjGen(nil, nil, nil, nil); }
    jeanieClosesDoor = {
	jeanie_door_hall.setIsopen(nil); // Jeanie's door should be open
	self.moveInto(nil);
    }
;

// Jeanie's billfold (fake), for putting under the table
fake_billfold: fixeditem
    noun = 'billfold' 'wallet'
    adjective = 'jeanie' 'jeanie\'s'
    sdesc = "Jeanie's billfold"
    ldesc = "You're surprised Jeanie'd leave it under the table. Still,
	     if you move it, you're going to end up looking like the
	     bad guy. "
    takedesc = "Best to leave it there for Jeanie. She gets pretty touchy
		if you mess with her things. "
    verDoOpen(actor) = "You've found that you and Jeanie get along a
			lot better when you don't mess with her things. "
    verIoPutIn(actor) = (self.verDoOpen(actor))
;

// Fridge stuff for Frank
frank_fridge_food: fixeditem
    noun = 'food'
    adjective = 'bunch'
    location = refrigerator
    f_sdesc = "bunch of food"
    f_ldesc = "All kinds of stuff, but since you're not supposed to
	       have any snacks, you might as well not go making cow
	       eyes at it. "
    dobjGen(a, v, i, p) = {
	if (a != frankMe)
	    return;
        if (v != inspectVerb) {
            "Just leave the food alone. You're not supposed to eat
	     right now. ";
            exitobj;
        }
    }
    iobjGen(a, v, d, p) = {
	if (a != frankMe)
	    return;
        "Just leave the food alone. You're not supposed to eat right
	 now. ";
        exitobj;
    }
;

cans_of_coke: fixeditem
    isThem = true
    noun = 'coke' 'can' 'cans' 'soda' 'pop'
    adjective = 'coke' 'soda' 'pop'
    location = refrigerator
    j_sdesc = "Coke cans"
    f_sdesc = "Coke cans"
    d_sdesc = "cans of Coke"
    j_ldesc = "Frank's the only one who drinks Coke. All that sugar's bad
	       for your figure. "
    f_ldesc = "There's plenty of Coke cans to choose from. "
    d_ldesc = "You've never liked Coke. Too sweet. "
    dobjCheck(a, v, i, p) = {
	if (a != frankMe) {
	    if (v != askVerb && v != tellVerb && v != inspectVerb &&
		v != talkVerb) {
		if (a == jeanieMe)
		    "You'd rather just leave the Coke alone. ";
		else "You'd just as soon not. ";
		exitobj;
	    }
	}
    }
    iobjCheck(a, v, d, p) = {
	self.dobjCheck(a, v, d, p);
    }
    dobjGen(a, v, i, p) = {
	if (a != frankMe) {
	    if (v != askVerb && v != tellVerb && v != inspectVerb &&
		v != talkVerb) {
		if (a == jeanieMe)
		    "You'd rather just leave the Coke alone. ";
		else "You'd just as soon not. ";
		exitobj;
	    }
	    else return;
	}
        if (v != inspectVerb) {
	    if (single_can.drunk)
		"One can was enough. You're not that thirsty any
		 more. ";
	    else if (single_can.location != nil)
		"You've already got a drink. ";
	    else "If you want a Coke, just take one. ";
            exitobj;
        }
    }
    iobjGen(a, v, d, p) = {
	self.dobjGen(a, v, d, p);
    }
    verDoTake(actor) = {
	if (single_can.drunk)
	    "One can was enough. You're not that thirsty any more. ";
	else if (single_can.location != nil)
	    "You've already taken one can and haven't finished it yet. ";
    }
    doTake(actor) = {
	"You suddenly realize that you've been standing and staring into
	 the open fridge for a while. You shake your head slightly and
	 pull a Coke from the fridge. You'd prefer a Bud, really, but
	 Deb's been on you about that. ";
	single_can.setType(1);
	single_can.moveInto(actor);
	setit(single_can);
    }
    verDoOpen(actor) = {
	"You don't need to open all of them. ";
    }
;

cans_of_bud: fixeditem
    isThem = true
    noun = 'bud' 'budweiser' 'can' 'cans' 'beer'
    adjective = 'bud' 'budweiser' 'beer'
    location = refrigerator
    j_sdesc = "Bud cans"
    f_sdesc = "Bud cans"
    d_sdesc = "cans of Bud"
    j_ldesc = "Frank's beer. "
    f_ldesc = "The cans of Bud are stacked near the back of the fridge. "
    d_ldesc = "You wish Frank wouldn't drink so much. "
    dobjCheck(a, v, i, p) = {
	if (a != frankMe) {
	    if (v != askVerb && v != tellVerb && v != inspectVerb &&
		v != talkVerb) {
		if (a == jeanieMe)
		    "Ick. No thanks. ";
		else "You'd just as soon not. ";
		exitobj;
	    }
	}
    }
    iobjCheck(a, v, d, p) = {
	self.dobjCheck(a, v, d, p);
    }
    dobjGen(a, v, i, p) = {
	// This is no doubt redundant, but...
	if (a != frankMe) {
	    if (v != askVerb && v != tellVerb && v != inspectVerb &&
		v != talkVerb) {
		if (a == jeanieMe)
		    "Ick. No thanks. ";
		else "You'd just as soon not. ";
	    }
	    else return;
	}
        if (v != inspectVerb) {
	    if (single_can.drunk)
		"One can was enough. You're not that thirsty any
		 more. ";
	    else if (single_can.location != nil)
		"You've already got a drink. ";
	    else "If you want a beer, just take one. ";
            exitobj;
        }
    }
    iobjGen(a, v, d, p) = {
	self.dobjGen(a, v, d, p);
    }
    verDoTake(actor) = {
	if (single_can.drunk)
	    "One can was enough. You're not that thirsty any more. ";
	else if (single_can.location != nil)
	    "You've already taken one can and haven't finished it yet. ";
    }
    doTake(actor) = {
	"You suddenly realize that you've been standing and staring into
	 the open fridge for a while. You shake your head slightly and
	 grab a cold Bud. ";
	single_can.setType(2);
	single_can.moveInto(actor);
	setit(single_can);
    }
    verDoOpen(actor) = {
	"You don't need to open all of them. ";
    }
;

// The drink Frank takes
single_can: item
    isopen = nil
    drinksLeft = 8
    isCrushed = nil
    typeStr = ''
    noun = 'can'
    adjective = 'single' 'red' 'white' 'red-and-white'
    sdesc = {
	if (self.isCrushed)
	    "crushed";
	else "single";
	" can of <<self.typeStr>>";
    }
    ldesc = {
	"The red-and-white can is ";
	if (self.isCrushed)
	    "crumpled up";
	else switch (self.drinksLeft) {
	    case 8:
	    "still full";
	    break;

	    case 7:
	    case 6:
	    case 5:
	    "over half-full";
	    break;

	    case 4:
	    case 3:
	    "just under half-full";
	    break;

	    case 2:
	    case 1:
	    "almost ";
	    case 0:
	    "empty";
	}
	". ";
    }
    setType(type) = {
	if (type == 1) {
	    self.typeStr = 'Coke';
	    addword(self, &noun, 'coke');
	    addword(self, &adjective, 'coke');
	    addword(self, &noun, 'soda');
	    addword(self, &adjective, 'soda');
	    addword(self, &noun, 'pop');
	    addword(self, &adjective, 'pop');
	}
	else {
	    self.typeStr = 'Bud';
	    addword(self, &noun, 'bud');
	    addword(self, &adjective, 'bud');
	    addword(self, &noun, 'budweiser');
	    addword(self, &adjective, 'budweiser');
	    addword(self, &noun, 'beer');
	    addword(self, &adjective, 'beer');
	}
    }
    verDoDrink(actor) = {
	if (self.drinksLeft == 0)
	    "There's nothing left in the can. ";
	else if (!self.isopen)
	    "You have to open it first. ";
    }
    doDrink(actor) = {
	self.drinksLeft--;
	"You take a sip from the can";
	if (self.drinksLeft == 0)
	    ", emptying it. ";
	else if (self.drinksLeft < 4)
	    ". There's not that much left to drink now. ";
	else if (self.typeStr == 'Coke')
	    ", enjoying the sweet yet bitter taste. ";
	else " and let the beer sit in your mouth for a bit before
	      swallowing. ";
    }
    verDoCrush(actor) = {
	if (self.drinksLeft > 0)
	    "The can's not empty. ";
	else if (self.isCrushed)
	    "You're not gonna be able to crush it any further. ";
    }
    doCrush(actor) = {
	"You crush the can some. ";
	self.isCrushed = true;
	addword(self, &adjective, 'crushed');
	addword(self, &adjective, 'crumpled');
    }
    verDoOpen(actor) = {
	if (self.isopen)
	    "It's already open. ";
    }
    doOpen(actor) = {
	"You pop open the can. ";
	self.isopen = true;
    }
    verDoClose(actor) = {
	if (!self.isopen)
	    "It's not open. ";
	else "You can't re-close it. ";
    }
;

toaster: fixeditem
    fixed = {
	return (((new_power_cord.tested && new_power_cord.isIn(toaster)) ||
		 (stereo_power_cord.tested &&
		  stereo_power_cord.isIn(toaster))) &&
		heating_element.tested && heating_element.isIn(toaster));
    }
    // announcedFixed=true if we've told the player that the toaster's fixed
    announcedFixed = nil
    isListed = true
    isopen = true
    isqcontainer = true
    noun = 'toaster'
    adjective = 'broken' 'open' 'fixed'
    sdesc = {
	if (!self.fixed)
	    "broken ";
	"toaster";
    }
    ldesc = {
	local len;

	if (self.fixed) {
	    "Maybe, just maybe, you've fixed the toaster for good this
	     time. ";
	    if (self.isopen)
		"It's gaping open. ";
	}
	else {
	    "The toaster that you're in the middle of fixing sits
	     open. ";
	    len = itemcnt(self.contents);
	    if (len > 0) {
		" Inside it you can see its ";
		if (heating_element.isIn(self))
		    "heating element";
		if (len > 1)
		    " and ";
		if (frayed_power_cord.location == self)
		"frayed power cord";
		else if (new_power_cord.location == self)
		    "new replacement cord";
		else if (stereo_power_cord.location == self)
		    "the cord from the stereo";
		". ";
	    }
	}
    }
    takedesc = {
	if (!self.fixed)
	    "It's not fixed yet. ";
	else "When Deb gets home you'll show it to her. Until then,
	      might as well leave it here. ";
    }
    // Use verGrab to keep people from taking stuff from me
    verGrab(obj) = {
	if (isclass(obj, toasterContent) && obj.screwedIn)
	    "It's got to be unscrewed first. ";
    }
    // Also use the xobjChecks to put Frank in the chair if he works
    // on me
    dobjCheck(actor, verb, iobj, prep) = {
	if (verb.touch && !actor.isIn(franks_chair)) {
	    "Before starting work on the toaster you lower yourself into
	     your chair.\b";
	    actor.moveInto(franks_chair);
	}
    }
    iobjCheck(a, v, d, p) = (self.dobjCheck(a, v, d, p))
    checkFixedStatus = {
	if (self.announcedFixed) return;  // Tell the player only once
	if (self.fixed) {
	    "And that should do it. The toaster should be ready to go now. ";
	    self.announcedFixed = true;
	}
    }
    verDoFix(actor) = {
	if (self.fixed)
	    "You've already fixed it. ";
	else "You're going to have to be more specific. ";
    }
    verDoClose(actor) = {
	if (!self.fixed)
	    "No sense in closing it back up until you're sure you've fixed
	     it. ";
	else if (!self.isopen)
	    "The toaster's already closed. ";
    }
    doClose(actor) = {
	"You force the toaster back together. It looks pretty good, even
	 if you did dent one side in a little. ";
	self.isopen = nil;
    }
    verDoOpen(actor) = {
	if (self.isopen)
	    "It's already open. ";
	else "Now that it's fixed you'd just as soon not. ";
    }
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) = {
	if (!isclass(dobj, toasterContent)) {
	    "You can't put <<dobj.thatdesc>> in the toaster. ";
	    return;
	}
	if (!screwdriver.atTheReady(actor)) {
	    "You'll need the screwdriver. ";
	    return;
	}
	dobj.doScrew(actor);
    }
    verIoUnscrewFrom(actor) = {}
    ioSynonym('UnscrewFrom') = 'DetachFrom'
    verIoScrewTo(actor) = {}
    ioSynonym('ScrewTo') = 'AttachTo'
    verDoPlug(actor) = {
	if (!self.fixed)
	    "Not while you're fixing it. ";
	else "You'll wait to test it in the kitchen. ";
    }
    verDoTurnon(actor) = (self.verDoPlug(actor))
    hasAPowerCord = { return (frayed_power_cord.isIn(self) ||
			      new_power_cord.isIn(self)); }
;

heating_element: toasterContent
    noun = 'element'
    adjective = 'heating' 'busted' 'broken'
    location = toaster
    f_sdesc = "heating element"
    f_ldesc = {
	if (!self.tested)
	    "You think this heating element might be busted, but
	     you're not sure. ";
	else "It looks like the heating element's okay. ";
    }
    screwdesc = "You put the heating element back in. "
    unscrewdesc = "You unscrew the heating element and take it out of the
		   toaster. "
    firstTestDesc = "You put the two leads of the multimeter across the
		     heating element and get a satisfying beep. Sounds like
		     the element's passing current. "
    secondTestDesc = "The element's still okay, surprise surprise. "
;

frayed_power_cord: toasterContent
    isAPowerCord = true
    noun = 'cord'
    adjective = 'old' 'frayed' 'power' 'busted' 'broken'
    location = toaster
    sdesc = {
	if (self.tested)
	    "busted";
	else "frayed";
	" power cord";
    }
    f_ldesc = {
	if (!self.tested)
	    "The power cord's gotten pretty frayed from the toaster
	     being plugged and unplugged so much. ";
	else "You'd had a feeling that frayed cord was busted, and
	      it turns out you were right. ";
	if (self.isIn(toaster))
	    "It's held in the toaster by screws. ";
    }
    screwdesc = "You put the old power cord back in the toaster and screw
		 it in tight. "
    unscrewdesc = "As careful as you can you loosen the screws holding the
		   cord and take it out of the toaster. "
    firstTestDesc = "When you touch the multimeter leads to the cord,
		     the meter's needle doesn't even move. Looks like the
		     cord's busted. "
    secondTestDesc = "The frayed cord is just as broken now as it was
		      before. "
    doPlug -> toaster
    verDoFix(actor) = {
	if (!self.tested)
	    "You're not even sure it's broken. ";
	else "It's so frayed it's beyond hope. ";
    }
;

screws: fixeditem
    isThem = true
    noun = 'screw' 'screws'
    location = toaster
    sdesc = "screws"
    ldesc= {
	"There are screws holding <<listcontgen(toaster, 0, 0)>>. ";
    }
    // Use the xobjChecks to put Frank in the chair if he works
    // on me
    dobjCheck(actor, verb, iobj, prep) = {
	if (verb.touch && !actor.isIn(franks_chair)) {
	    "Before starting work on the toaster you lower yourself into
	     your chair.\b";
	    actor.moveInto(franks_chair);
	}
    }
    verDoUnscrew(actor) = {
	if (itemcnt(toaster.contents) > 1)
	    "There's <<listcontgen(toaster, 0, 0)>> you can unscrew. ";
	else toaster.contents[1].verDoUnscrew(actor);
    }
    doUnscrew(actor) = {
	toaster.contents[1].doUnscrew(actor);
    }
    doSynonym('Unscrew') = 'Detach'
    verDoUnscrewFrom(actor, iobj) = {
	if (iobj != toaster)
	    "The screws aren't screwed into <<iobj.thedesc>>. ";
	else self.verDoUnscrew(actor);
    }
    doUnscrewFrom(actor, iobj) = { self.doUnscrew(actor); }
    verDoUnscrewWith(actor, iobj) = {
	if (iobj != screwdriver)
	    "You can't unscrew the screws with that. ";
	else self.verDoUnscrew(actor);
    }
    doUnscrewWith(actor, iobj) = { self.doUnscrew(actor); }
;

junk_box: fixeditem
    isListed = true
    noun = 'box'
    adjective = 'junk'
    sdesc = "junk box"
    ldesc = "All sorts of odds and ends are jammed down in the box, most
	     of them ripped off of old appliances. "
    verDoSearch(actor) = {
	if (new_power_cord.location != nil)
	    "You dig in the box some more, but don't find anything
	     else that looks too useful right now. ";
    }
    doSearch(actor) = {
	"After some rooting around in the box you find a mostly new
	 power cord. You think it came from that old box fan with the
	 burnt-out motor you tossed last year. ";
	new_power_cord.moveInto(actor);
    }
    doSynonym('Search') = 'Lookin'
;

odds_and_ends: fixeditem
    noun = 'odds-and-ends' 'junk'
    location = junk_box
    sdesc = "odds and ends"
    ldesc = "A bunch of junk you've saved over the years. There's
	     all kinds of stuff hiding in that junk. "
    doSearch -> junk_box
    doLookin -> junk_box
;

new_power_cord: deskItem, toasterContent
    isAPowerCord = true
    screwedIn = nil
    noun = 'cord'
    adjective = 'new' 'power' 'mostly'
    location = nil
    f_sdesc = "new power cord"
    f_ldesc = {
	if (!self.tested)
	    "Offhand you don't remember whether this cord is any good or
	     not. ";
	else "Good thing this cord's okay, or you'd be making a run to
	      the hardware store tomorrow morning on the way into work. ";
	if (self.isIn(toaster))
	    "Right now the cord's being held in the toaster by a
	     couple of screws. ";
    }
    screwdesc = "You put the new cord in the toaster where the old one used
		 to be. "
    unscrewdesc = "You take out the new power cord. "
    firstTestDesc = "The multimeter beeps when you put it across the
		     cord you found in the box. Seems okay to you. "
    secondTestDesc = "Testing the cord again, you're pretty sure it's okay. "
    verDoPutIn(actor, iobj) = {
	if (iobj != toaster)
	    "Best you hang onto it if you're going to fix the
	     toaster. ";
	else self.verDoScrewTo(actor, iobj);
    }
    verDoPutOn(actor, io) = {
	if (io != little_desk && io != toaster)
	    "Best you hang onto it if you're going to fix the
	     toaster. ";
    }
    doPlug -> toaster
    verDoFix(actor) = {
	if (!self.tested)
	    "You're not even sure it's broken. ";
	else "It doesn't need to be fixed. ";
    }
;

stereo_power_cord: deskItem, toasterContent
    isAPowerCord = true
    screwedIn = nil
    isListed = nil
    playerHasNoticedMe = nil    // Has the player done something w/me?
    noun = 'cord'
    adjective = 'stereo' 'power'
    location = old_stereo
    f_sdesc = "stereo power cord"
    f_ldesc = {
	if (!self.tested)
	    "Maybe the cord's good; maybe it's shot. You weren't
	     ever sure why the stereo stopped working. ";
	else "And Deb wanted you to junk that old stereo! Maybe you
	      should tell her you got a good power cord off of it when
	      she gets home. ";
	if (self.isIn(toaster))
	    "Right now the cord's being held in the toaster by a
	     couple of screws. ";
    }
    moveInto(dest) = {
	self.isListed = true;
	pass moveInto;
    }
    screwdesc = "You put the cord from the stereo in the toaster
		 where the old one used to be. "
    unscrewdesc = "You take out the new power cord. "
    firstTestDesc = "The multimeter beeps when you put it across the
		     cord from the stereo. Seems okay to you. "
    secondTestDesc = "Testing the cord again, you're pretty sure it's okay. "
    // Use dobjCheck to record when the player does something with me
    dobjCheck(a, v, i, p) = {
	self.playerHasNoticedMe = true;
    }
    verDoUnscrew(actor) = {
	if (!self.isIn(old_stereo))
	    pass verDoUnscrew;
    }
    doUnscrew(actor) = {
	if (self.isIn(old_stereo)) {
	    "You unscrew the cord from the stereo. ";
	    self.moveInto(actor);
	}
	else pass doUnscrew;
    }
    verDoUnscrewFrom(actor, iobj) = {
	if (iobj != old_stereo || !self.isIn(iobj))
	    pass verDoUnscrewFrom;
    }
    verDoScrewTo(actor, iobj) = {
	if (iobj == old_stereo)
	    "You just took it off. Might as well keep it off. ";
	else pass verDoScrewTo;
    }
    verDoPutIn(actor, iobj) = {
	if (iobj == old_stereo)
	    "You just took it off. Might as well keep it off. ";
	else if (iobj != toaster)
	    "Best you hang onto it if you're going to fix the
	     toaster. ";
	else self.verDoScrewTo(actor, iobj);
    }
    verDoPutOn(actor, io) = {
	if (io == old_stereo)
	    "You just took it off. Might as well keep it off. ";
	else if (io != little_desk && io != toaster)
	    "Best you hang onto it if you're going to fix the
	     toaster. ";
    }
    doPlug -> toaster
    verDoFix(actor) = {
	if (!self.tested)
	    "You're not even sure it's broken. ";
	else "It doesn't need to be fixed. ";
    }
    doTake(actor) = {
	if (self.isIn(old_stereo))
	    "You take the cord off of the old stereo. ";
	else "Taken. ";
	self.moveInto(actor);
    }
;

screwdriver: deskItem
    noun = 'driver' 'screwdriver'
    adjective = 'phillips' 'phillips-head' 'little'
    sdesc = "Phillips-head screwdriver"
    ldesc = "This little screwdriver's the only one left from a set
	     Jeanie got for your birthday a few years ago. "
    verIoScrewWith(actor) = {}
    verIoUnscrewWith(actor) = {}
    atTheReady(actor) = {
	return (self.isIn(actor) || self.isIn(little_desk));
    }
;

multimeter: deskItem
    noun = 'meter' 'multimeter' 'tester'
    sdesc = "multimeter"
    ldesc = "It can do a bunch of stuff, but mainly you use it to
	     test things to see if current can pass through them. If
	     something won't pass current, chances are it's broken. "
    verIoTestWith(actor) = {}
    ioTestWith(actor, dobj) = { dobj.doTestWith(actor, self); }
    verDoPutOn(actor, iobj) = {
	if (!isclass(iobj, toasterContent))
	    pass verDoPutOn;
    }
    verDoAttachTo(actor, iobj) = {
	if (!isclass(iobj, toasterContent))
	    pass verDoPutOn;
    }
    verIoAttachTo(actor) = {}
    ioAttachTo(actor, dobj) = { dobj.doTestWith(actor, self); }
;
