/* Converse.t v1.0
   Include file for TADS.  Allows Monkey Island style conversations to take place.
   Copyright 1997 James Cole
 
   "Converse" is freeware.  This means that you may use it, copy it and give it 
   away without paying any royalties.  You are not allowed to sell it or 
   distribute modified copies without the written permission of the author.  
   You may charge a distribution fee for covering distribution costs.  

   The author accepts no responsibility for the function or usability of
   this code, or any ill effects that may result from its use or misuse. 

   two other files should complement this:
      converse.txt - a general information file.
      instruct.txt - instructions for using converse.

   Modification History
 
   08-Feb-97    jc     started.

*/


TalkVerb : Verb
   verb = 'talk to'
   sdesc = "talk to"
   doAction = 'TalkTo'
;
// ^ notice that there is no requires property.


conversation : function(rActor, initProp) {
/* PRE: rActor is the recipient actor (the actor you are talking to),
        initProp is the property pointer which points to the list which starts
         the conversation.
   POST: A conversation as described in instruct.txt has ensued.
*/
   

   local yourResponses,   // list of respsonses you choose from and prop Ptr's
         youHaveResponse, // whether or not you have a response to what the NPC said.
         NPCResponse,     // list containing what the NPC says and prop Ptr.
         numChoices,      // how many responses you can choose from. 
         choice,          // The number of you choice (response).
         loop;

   //-- Determine whether the player or the NPC started the conversation.

   if (datatype(rActor.initProp[1]) = 3) {
   // if the contents of the 1st elem of the list is a string, as apposed to
   //  another list, then it was the NPC which started it
      say(rActor.initProp[1]);
      yourResponses := rActor.initProp[2];
      if (rActor.initProp[2] = nil) 
         youHaveResponse := nil;
      else
         youHaveResponse := true;

   } else {  // the player has started the conversation
      // This is just so the while guard functions properly.  The player has
      // started the conversation, so in a sense has a "response".
      youHaveResponse := true;  
      yourResponses := rActor.initProp;
   }

   // v - (Loop invarient) Before entering the loop yourResponses and
   //  youHaveRepsonse should have been set.

   //-- While you have a response to what the NPC has said.
   while (youHaveResponse) {
   
      numChoices := length(yourResponses);

      //-- Display the players choices

      // only draw up responses if there is more than one.
      if (numChoices > 1) {
         "\b";
         for (loop := 1; loop <= numChoices; loop++) {
            "\t"; say(loop); " - ";
            say(yourResponses[loop][1]);
            "\n";
         }
      }
      
      //-- Get the player's choice and error check
      if (numChoices = 1) {
         choice := 1;
      } else {
      
         // there's more than one possible choice so let the player choose from it.
         do {
            choice := cvtnum(input());
         } while ((choice < 1) or (choice > numChoices));
      }

      //-- Display what the player has chosen (ie. what the character has said).
      "\b";
      say(yourResponses[choice][1]);

      //-- Now see if there is a NPC response to what you've said.
      if (yourResponses[choice][2] <> nil) {
      // there is a response, so say it
         "\b";
         NPCResponse := rActor.(yourResponses[choice][2]);
         say(NPCResponse[1]);
         
         // now check to see whether the player has a response to what the NPC has said. ...We're almost back up to the top of the loop now...
         if (NPCResponse[2] = nil) {
            youHaveResponse := nil;
         } else {
            // you have a response to what the NPC said, so we want to continue the loop.
            youHaveResponse := true;
            yourResponses := rActor.(NPCResponse[2]);
         }
 
      } else {
         // the NPC doesn't have a response to what you've said.
         break;  // sort of hackish... 
      }

   } // end while.

} // end conversation.


// ----------------------------------------------------------

