/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// ProcessTable.cpp: implementation of the CProcessTable class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProcessTable.h"
#include "ccondact.hpp"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMPLEMENT_SERIAL( CProcessTable, CObject, 1)

CProcessTable::CProcessTable()
{

	ProcessCount=0;
	ConditionCount=0;
}

CProcessTable::~CProcessTable()
{
     int count;
	Condition *p_Condition;
	for( count=0; count<ConditionCount; count++)
	{
		p_Condition=Conditions[count];
		delete p_Condition;
	}

	CCondAct *p_CondAct;

	for( count=0; count<ProcessCount; count++)
	{
		p_CondAct=Processes[count];
		delete p_CondAct;
	}

}

int CProcessTable::GetProcess( int Verb, int Noun )
{
	Condition *current;

	for ( int count=ConditionPtr; count<Conditions.GetSize(); count ++)
	{
		current = Conditions[count];
		{
			if ( (current->Verb== -1) && (current->Noun == -1 ) )//Both NULL
			{
				ConditionPtr = count+1;
				return current->CondAct;
			}

			if ( ( current->Noun == -1 ) && ( current->Verb == Verb ) )
			{
				ConditionPtr = count+1;
				return current->CondAct;
			}

			if ( ( current->Noun == Noun ) && ( current->Verb == -1 ) )
			{
				ConditionPtr = count+1;
				return current->CondAct;
			}
			
			if (( current->Noun == Noun ) && ( current->Verb == Verb ) )
			{
				ConditionPtr = count+1;
				return current->CondAct;
			}
		}
	}
	return -1;//No match;
}

CCondAct *CProcessTable::GetCondact( int CondAct )
{
	return Processes[ CondAct ];
}

void CProcessTable::Serialize( CArchive &ar )
{
	int count1;
	Condition *current;
	CCondAct *condact;

	if (ar.IsStoring())
	{
		ar<<ConditionCount;
		for ( count1 =0; count1<ConditionCount; count1++ )
		{
			current=Conditions[count1];
			ar<< current->Noun;
			ar<< current->Verb;
			ar<< current->CondAct;
		}


		ar<<ProcessCount;
		for ( count1=0; count1<ProcessCount; count1++)
		{
			condact = GetCondact( count1 );
			ar << condact->OpCode;
			ar << condact->Param1;
			ar << condact->Param2;
		}
	}
	else
	{
		ar>>ConditionCount;
		Conditions.SetSize( ConditionCount );
		for ( count1 =0; count1<ConditionCount; count1++ )
		{
			current=new Condition;
			ar>> current->Noun;
			ar>> current->Verb;
			ar>> current->CondAct;
			Conditions[count1]=current;
		}


		ar>>ProcessCount;
		Processes.SetSize( ProcessCount );

		for ( count1=0; count1<ProcessCount; count1++)
		{
			condact = new CCondAct;
			ar >> condact->OpCode;
			ar >> condact->Param1;
			ar >> condact->Param2;
			Processes[count1]=condact;
		}

	}
}

void CProcessTable::dump()
{
	int count;
	Condition *p_Condition;
	for( count=0; count<ConditionCount; count++)
	{
		p_Condition=Conditions[count];
		printf("Condition %d - Verb %d, Noun %d, CondActNo, %d\n",	count,
																	p_Condition->Verb,
																	p_Condition->Noun,
																	p_Condition->CondAct);
	}

	printf("\n");

	CCondAct *p_CondAct;

	for( count=0; count<ProcessCount; count++)
	{
		p_CondAct=Processes[count];
		printf("CondAct %d - OpCode %d, Param1 %d, Param2 %d\n",count,	p_CondAct->OpCode,
																		p_CondAct->Param1,
																		p_CondAct->Param2);
	}
	printf("\n");
}
