#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// NOTES
// DEBUG STUFF
// HAC-MAN MAZE: PROLOGUE CUT-SCENE
// HAC-MAN MAZE: MAZE STATE STUFF
// HAC-MAN MAZE: ROOM STUFF: ROOM CLASSES
// HAC-MAN MAZE: ROOM STUFF: ROOMS: ORDINARY ROOMS
// HAC-MAN MAZE: ROOM STUFF: ROOMS: ROOMS NEAR PINK GATE
// HAC-MAN MAZE: GENERAL STUFF: MISCELLANEOUS
// HAC-MAN MAZE: GENERAL STUFF: CHOMPING
// HAC-MAN MAZE: GENERAL STUFF: CHOMPDAEMON
// HAC-MAN MAZE: GENERAL STUFF: Victory, Sheila's final speech, etc.
// HAC-MAN MAZE: GENERAL STUFF: SIGHT DOWN HALLWAYS
// HAC-MAN MAZE: NPC STUFF: NPC CLASSES
// HAC-MAN MAZE: NPC STUFF: NPCs (and attendant PC modifications)
// HAC-MAN MAZE: NPC STUFF: ADAM CONVERSATION
// HAC-MAN MAZE: NPC STUFF: AGENDA ITEMS
// HAC-MAN MAZE: NPC STUFF: AGENDA ITEMS (OBSOLETE)
// HAC-MAN MAZE: NPC STUFF: MISC. NPC STUFF
// STUFF WRITTEN BY KRISTER FUNDIN
// HAC-MAN MAZE: NPC STUFF: PSEUDO-AI: MEASURING DISTANCES
// HAC-MAN MAZE: MAP
// HAC-MAN MAZE: MISC. STUFF NEEDED FOR MAP
// JUNK

// -------------------------------------------------------------------
// NOTES
// -------------------------------------------------------------------

/*
To do, top priority:
Implement Sheila conversation.
Implement Hac-Man hints.

To do, last priority:
When an NPC is in the pink gate, change the description of the pink gate.
When an NPC is in the pink gate, change the description of that NPC.
When an NPC is in the pink gate, change what happens when you try to enter the pink gate.
Create a distantPinkGate that is visible in hac rooms H4, H5, and H6.
Implement the void.
Implement the feature where you give a brief description of each NPC after seeing him for the first time.
Implement NPCs' clothing (parka/cape) and possessions (axe, etc.)
Have the copyright man say things about copyright as he walks along.
*/

/*
Nethack creatures designated by a red capital letter:
B  giant bat
D  red dragon
F  red mold
H  giant
L  demilich
M  gmome mummy
M  dwarf mummy
N  red naga
O  ogre lord
S  water moccasin
V  vampire
*/

/*
chicken
canary
cassowary
crane
cuckoo
cardinal
chickadee
crow
cockatoo
coot
cormorant
*/

/*
Status of Medusa (chaotic): Level 20  HP 101(101)  AC 2.

Status of the copyright man (lawful): Level 12  HP 
Status of the red dragon (chaotic): Level 15  HP 93(93)  AC -1.
Status of the blue/white duck/chicken (neutral): Level 0  HP 1(1)  AC 10.
Status of Adam Thornton (neutral): Level 24  HP 131(131)  AC 2, peaceful.
Status of the bandit (chaotic): Level 24  HP 131(131)  AC 2, peaceful.

Melac talks about the problem of shoplifters.

The imp casts aspersions on your ancestry.
"This time I shall let thee off with a spanking, but let it not happen again."
"Go play leapfrog with a herd of unicorns!"
"I first mistook thee for a statue, when I regarded thy head of stone."
*/
/*
In the mainframe version of Zork/Dungeon, there are only a few possible
responses to DIAGNOSE, as shown below. I don't know why "perfect health"
doesn't always imply the same thing about how many wounds you can take.

1.
You are in perfect health.
You are strong enough to take several wounds.

2.
You are in perfect health.
You can survive one serious wound.

3.
You have a light wound.
You will be cured after 29 moves.
You can be killed by a serious wound.

4.
You have a serious wound.
You will be cured after 59 moves.
You can be killed by one more light wound.
*/

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

axe: Thing 'axe' 'axe'
  "It looks sharp. "
  location = adam
;

DefineIAction(HacWin)
  execAction() {
    if (gPlayerChar.getOutermostRoom && gPlayerChar.getOutermostRoom.ofKind(HacRoom)) {
      local hacScore = libScore.totalScore - glob.scoreUponEnteringHac;
      "Okay, score added. ";
      addToScore(147 - hacScore, 'winning Net-Hac-Man by cheating');
      beachChairM.isInExe = true;
      glob.dotsEaten = glob.dotsEaten + 147;
    }
    else {
      "You can<./s>t do that here. ";
    }
  }
;
/*
DefineIAction(HacWin)
  execAction() {
    if (gPlayerChar.getOutermostRoom && gPlayerChar.getOutermostRoom.ofKind(HacRoom)) {
      local hacScore = libScore.totalScore - glob.scoreUponEnteringHac;
      "Okay, score added. ";
      addToScore(150 - hacScore, 'winning Net-Hac-Man by cheating');
      beachChairM.isInExe = true;
      glob.dotsEaten = glob.dotsEaten + 150;
    }
    else {
      "You can<./s>t do that here. ";
    }
  }
;
*/

VerbRule(HacWin)
  'HacWin'
  : HacWinAction
  verbPhrase = 'win/winning Net-Hac-Man'
;


DefineIAction(Speech)
  execAction() {
    letSheilaGiveFinalSpeech(true, '[direction]');
  }
;
VerbRule(Speech)
  'speech'
  : SpeechAction
  verbPhrase = 'solicit/soliciting Sheila<./s>s final speech'
;

DefineIAction(Inform)
  execAction() {
    local informTarget = nil;
    if (!gPlayerChar.getOutermostRoom || 
        !gPlayerChar.getOutermostRoom.ofKind(HacRoom)) {
      "You can<./s>t do that here. ";
      return;
    }
    if (!adam.realLocation) {
      "Adam isn<./s>t here to inform. ";
      return;
    }
    // UNIVERSALIZE (begun but not finished)
    // (Now that conversational informing has been implemented,
    // it doesn't seem worth universalizing this.
    for (local a = 1; a <= glob.hacEnemies.length; a++) {
      if (glob.hacEnemies[a].realLocation) {
        informTarget = glob.hacEnemies[a];
        break;
      }
    }
    if (!informTarget) {
      "It<./s>s not clear what you<./s>d want to inform Adam about,
        since no enemies are in the maze now. ";
      return;
    }
    if (adam.npcGoal == dragon && informTarget == dragon) {
      "Adam already knows about the dragon. ";
      return;
    }
    if ((adam.npcGoal == bandit || adam.npcGoal == copyman) && informTarget == copyman) {
      "Adam already knows about the copyright man. ";
      return;
    }
    if (informTarget == dragon) {
      "Okay, now Adam knows about the dragon. ";
      adam.npcGoal = dragon;
      return;
    }
    if (informTarget == copyman) {
      "Okay, now Adam knows about the copyright man. ";
      adam.npcGoal = bandit;
      return;
    }
    "Uh-oh. Unknown exception! ";
  }
;

VerbRule(Inform)
  'inform'
  : InformAction
  verbPhrase = 'inform/informing'
;

DefineLiteralAction(Melee)
  execAction() {
    local lit1, lit2, trans1, trans2, wasTrans1, wasTrans2, firstInSeries;
    local aggressor, defender;
    
    glob.initializeHacLists;
    
    if (getLiteral.length <= 0) {
      "You<./s>ll have to say who you want to initiate melee combat with. ";
      return;
    }
    lit1 = nil; lit2 = nil;
    firstInSeries = nil;
    getLiteral = getLiteral + ' ';
    for (local a = 1; a <= getLiteral.length - 1; a++) {
      if (getLiteral.substr(a, 1) != ' ' && !firstInSeries) {
        firstInSeries = a;
      }
      if (getLiteral.substr(a + 1, 1) == ' ' && firstInSeries) {
        if (!lit1)
          lit1 = getLiteral.substr(firstInSeries, a + 1 - firstInSeries);
        else
          lit2 = getLiteral.substr(firstInSeries, a + 1 - firstInSeries);
        firstInSeries = nil;
      }
      if (lit2)
        break;
    }
    if (!lit1 || !lit2) {
      "I couldn<./s>t get two literals from that. Please use the format
        MELEE [literal] [literal] ";
      return;
    }
    trans1 = nil;
    trans2 = nil;
    lit1 = lit1.toLower.substr(1,3);
    lit2 = lit2.toLower.substr(1,3);
    aggressor = nil;
    defender = nil;
    // UNIVERSALIZE (finished)
    for (local a = glob.hacChars.length; a >= 1; a--) {
      if (glob.hacChars[a].syntaxTokens.indexWhich(
          {x: x.substr(1, lit1.length) == lit1})) {
        aggressor = glob.hacChars[a];
        break;
      }
      if (glob.hacChars[a].transTokens.indexWhich(
          {x: x.substr(1, lit1.length) == lit1})) {
        aggressor = glob.hacChars[a];
        trans1 = true;
        break;
      }
    }
    for (local a = glob.hacChars.length; a >= 1; a--) {
      if (glob.hacChars[a].syntaxTokens.indexWhich(
          {x: x.substr(1, lit2.length) == lit2})) {
        defender = glob.hacChars[a];
        break;
      }
      if (glob.hacChars[a].transTokens.indexWhich(
          {x: x.substr(1, lit2.length) == lit2})) {
        defender = glob.hacChars[a];
        trans2 = true;
        break;
      }
    }
    //if      (lit1 == 'du') { aggressor = dragon ; trans1 = true; }
    //else if (lit1 == 'ch') { aggressor = copyman; trans1 = true; }
    //else if (lit1 == 'co') { aggressor = copyman; }
    //else if (lit1 == 'dr') { aggressor = dragon ; }
    //else if (lit1 == 'ad') { aggressor = adam   ; }
    //else if (lit1 == 'ba') { aggressor = bandit ; }
    //else if (lit1 == 'bo') { aggressor = bot    ; }
    //else if (lit1 == 'me') { aggressor = bot    ; }
    //if      (lit2 == 'du') { defender  = dragon ; trans2 = true; }
    //else if (lit2 == 'ch') { defender  = copyman; trans2 = true; }
    //else if (lit2 == 'co') { defender  = copyman; }
    //else if (lit2 == 'dr') { defender  = dragon ; }
    //else if (lit2 == 'ad') { defender  = adam   ; }
    //else if (lit2 == 'ba') { defender  = bandit ; }
    //else if (lit2 == 'bo') { defender  = bot    ; }
    //else if (lit2 == 'me') { defender  = bot    ; }
    if (!aggressor || !defender) {
      "I couldn<./s>t figure out who you wanted to attack whom. ";
      return;
    }
    // Success!
    wasTrans1 = aggressor.isTransformed;
    wasTrans2 = defender .isTransformed;
    if (trans1)
      aggressor.isTransformed = true;
    if (trans2)
      defender.isTransformed = true;
    glob.meleeTest = true;
    aggressor.startMelee(defender);
    glob.meleeTest = nil;
    if (aggressor.isTransformed != wasTrans1)
      aggressor.isTransformed = wasTrans1;
    if (defender.isTransformed != wasTrans2)
      defender.isTransformed = wasTrans2;
  }
;

VerbRule(Melee)
  ('melee' | 'combat') singleLiteral
  : MeleeAction
  verbPhrase = 'initiate/initiating melee combat (with whom)'
;



grr: Fixture 'grr' 'grr' @hacRoomH4
;

hacFixture: Fixture 
  'net hac hack nethac nethack man/nethackman/nethacman/net-hac-man/net-hack-man/hacman/hackman/hac-man/hack-man'
  'net-hac-man'
  @hacRoomH12
;
DefineLiteralAction(Link)
  execAction() {
    local linkRoom = 0;
    switch (getLiteral()) {
      case '1': case '104': case 'D2': case 'hacRoomD2':
        linkRoom = hacRoomD2; break;
      case '2': case '110': case 'J2': case 'hacRoomJ2':
        linkRoom = hacRoomJ2; break;
      case '3': case '118': case 'D4': case 'hacRoomD4':
        linkRoom = hacRoomD4; break;
      case '4': case '123': case 'J4': case 'hacRoomJ4':
        linkRoom = hacRoomJ4; break;
      case '5': case '135': case 'D6': case 'hacRoomD6':
        linkRoom = hacRoomD6; break;
      case '6': case '138': case 'H6': case 'hacRoomH6':
        linkRoom = hacRoomH6; break;
      case '7': case '142': case 'N6': case 'hacRoomN6':
        linkRoom = hacRoomN6; break;
      case '8': case '149': case 'D8': case 'hacRoomD8':
        linkRoom = hacRoomD8; break;
      case '9': case '153': case 'H8': case 'hacRoomH8':
        linkRoom = hacRoomH8; break;
      case '10': case '155': case 'J8': case 'hacRoomJ8':
        linkRoom = hacRoomJ8; break;
      case '11': case '163': case 'B10': case 'hacRoomB10':
        linkRoom = hacRoomB10; break;
      case '12': case '165': case 'D10': case 'hacRoomD10':
        linkRoom = hacRoomD10; break;
      case '13': case '166': case 'L10': case 'hacRoomL10':
        linkRoom = hacRoomL10; break;
      case '14': case '168': case 'N10': case 'hacRoomN10':
        linkRoom = hacRoomN10; break;
      case '15': case '176': case 'F12': case 'hacRoomF12':
        linkRoom = hacRoomF12; break;
      case '16': case '178': case 'H12': case 'hacRoomH12':
        linkRoom = hacRoomH12; break;
      case '17': case '182': case 'L12': case 'hacRoomL12':
        linkRoom = hacRoomL12; break;
      case '18': case '189': case 'B14': case 'hacRoomB14':
        linkRoom = hacRoomB14; break;
      case '19': case '193': case 'H14': case 'hacRoomH14':
        linkRoom = hacRoomH14; break;
      case '20': case '196': case 'L14': case 'hacRoomL14':
        linkRoom = hacRoomL14; break;
      case '21': case '208': case 'F16': case 'hacRoomF16':
        linkRoom = hacRoomF16; break;
      case '22': case '213': case 'L16': case 'hacRoomL16':
        linkRoom = hacRoomL16; break;
      case '23': case '221': case 'F18': case 'hacRoomF18':
        linkRoom = hacRoomF18; break;
      case '24': case '227': case 'L18': case 'hacRoomL18':
        linkRoom = hacRoomL18; break;
      default:
        "I don<./s>t recognize <.q><<getLiteral()>><./q> as a 
          junction that I can link to. ";
        return;
    }
    "Establishing a link to junction room <<linkRoom.xyName>>. <.p>";
    
    linkDaemon.startDaemon(linkRoom);
    
    return;
  }
;
VerbRule(Link)
  'link' singleLiteral //| 'link' 'to' singleLiteral
  : LinkAction
  verbPhrase = 'link/linking (to what)'
;
linkDaemon: DaemonComponent
  //location = me
  daemonID = nil
  roomID = nil
  startDaemon(linkRoom) {
    if (daemonID != nil) { endDaemon(); }
    moveInto(gPlayerChar);
    daemonID = new Daemon(self, &daemon, 1);
    roomID = linkRoom;
  }
  daemon() {
    if (!gActor.location.ofKind(HacRoom)) {
      endDaemon();
      return;
    }
    
    // Intended output:
    // To get from linked room F18 to current room D18, if you
    // started out in the following directions, would take the following
    // number of turns:
    // N: 14
    // E: 22
    // S: 1000
    // W: 2
    // Therefore, in this instance, you would want to go:
    // W (west).
    
    "<.p>To get from linked room <<roomID.xyName>> to current room
      <<gPlayerChar.location.xyName>>, if you started out in the following
      directions, would take the following number of turns:\n";
    for (local a=1; a<=4; ++a) {
      switch (a) {
        case 1: "N"; break;
        case 2: "E"; break;
        case 3: "S"; break;
        case 4: "W"; break;
      }
      ": <<roomID.distToRoom(gPlayerChar.location, a)>>\n";
    }
    "Therefore, in this instance, you would want to go:\n";
    switch (roomID.goWhereToGetToRoom(gPlayerChar.location, 0)) {
      case 1: "N (north)"; break;
      case 2: "E (east)";  break;
      case 3: "S (south)"; break;
      case 4: "W (west)";  break;
    }
    ". ";
  }    
  endDaemon {
    if (daemonID != nil) daemonID.removeEvent;
    daemonID = nil;
  }
;

#endif // __DEBUG

// -------------------------------------------------------------------
// HAC-MAN MAZE: PROLOGUE CUT-SCENE
// -------------------------------------------------------------------

/*

hacPrologue() {
  "<.q>Could this be the end of the maze?<./q> Sheila asks.
      <.q>Well, there<./s>s only one way to find out!<./q>
    <p>With that, she jumps enthusiastically into the hole
      and falls down and down\ .\ .\ . ";
  nbmPause();
  gPlayerChar.moveIntoForTravel(nil);
  glob.status = blank;
  statusLine.showStatusLineDaemon();
  nbmBanner.updateMe;
  nbmCls();
  "After falling for some time, Sheila 
      seems to decelerate,
      the air rushing past her 
      becoming less and less noticeable. 
      At length, she can detect no motion 
      at all, nor can she see anything.
      She is as if suspended in a void. ";
  nbmPause();
  nbmCls();
  //"<p>";
  "Long seconds go by. Then, suddenly, Sheila 
      hears the voice of an Oo: 
    <p><.q>So, traveler. You<./s>ve come this far. 
      Excellent work. 
    <p><.q>But there is one final challenge--the
      most perilous, but also the most rewarding. 
      And it cuts to the core of what is best 
      about Earth<./s>s interactive fiction.<./q> ";
  nbmPause();
  nbmCls();
  //"<p>";
  "<.q>You see, in our research, we found lots of Earth games 
      containing mazes. One game featured 
      a hungry yellow creature in a maze of dots. 
      Another had the player find an amulet 
      in a deep and dangerous dungeon. 
      Why did humans never recognize these maze-filled games 
      as interactive fiction? No one knows.<./q> ";
  nbmPause();
  nbmCls();
  //"<p>";
  "<.q>Therefore, in this final challenge, 
      we are pleased to bring you, for the first time, 
      a synthesis of the best of Earth<./s>s 
      interactive fiction!<./q> ";
  "<p><.q>But be warned. The following maze may be too intense 
      for some people. For example, certain directors 
      of humanities departments might say, <.s>What on Earth 
      are you thinking, Ovan? Get this thing 
      out of my game at once!<./s>
    <p><.q>But we know better than that, don't we?<./q> ";
  nbmPause();
  nbmCls();
  //"<p>";
  "<.q>Therefore, in this greatest challenge, we will blissfully 
      ignore full-sentence parsers and complex storylines, 
      while focusing on the most basic elements 
      of the text adventure game: mazes, puzzles, and dragons. 
    <p><.q>And so, my friend, we cannot keep this a secret 
      any longer. Can your heart stand the shocking facts 
      of\ .\ .\ .<./q> ";
  nbmPause();
  nbmCls();
  "<.q>.\ .\ .\ <i>Net-Hac-Man?<./q></i> ";
  "<p>With that, the voice falls silent, and a new world
      materializes around Sheila. ";
  //"<p>";
  glob.doingHacManForReal = true;
  if (adamThorntonM.isInExe)
    goToHac.execute;
  else
    goToHacWithoutAdam.execute;
  playSound('<sound src=\"sound/hacman.mp3\" layer=foreground>');
  nbmPause();
  nbmCls();
  // Presumably these next lines would be redundant:
  //glob.status = zork;
  //statusLine.showStatusLineDaemon();
  //nbmBanner.updateMe;
  hacTitle();
  "<.p>";
  gPlayerChar.lookAround(true);
}

*/


hacPrologue() {
  "<.q>Could this be the end of the maze?<./q> Sheila asks.
      <.q>Well, there<./s>s only one way to find out!<./q>
    <p>With that, she jumps enthusiastically into the hole
      and falls down and down\ .\ .\ . ";
  nbmPause();
  gPlayerChar.moveIntoForTravel(nil);
  glob.status = blank;
  statusLine.showStatusLineDaemon();
  nbmBanner.updateMe;
  nbmCls();
  "After falling for some time, Sheila 
      seems to decelerate,
      the air rushing past her 
      becoming less and less noticeable. 
      At length, she can detect no motion 
      at all, nor can she see anything.
      She is as if suspended in a void. ";
  nbmPause();
  nbmCls();
  //"<p>";
  "Long seconds go by. Then, suddenly, Sheila 
      hears the voice of an Oo: 
    <p><.q>So, traveler. You<./s>ve come this far. 
      Excellent work. 
    <p><.q>But there is one final challenge--the
      most perilous, but also the most rewarding. 
      And it cuts to the core of what is best 
      about Earth<./s>s interactive fiction.<./q> ";
  nbmPause();
  nbmCls();
  //"<p>";
  "<.q>You see, in our research, we found lots of Earth games 
      containing mazes. One game featured 
      a hungry yellow creature in a maze of dots. 
      Another featured an amulet 
      hidden in a dangerous dungeon. 
      Why were these maze-filled games never recognized
      as interactive fiction? No one knows.<./q> ";
  nbmPause();
  nbmCls();
  //"<p>";
  "<.q>Therefore, in this final challenge, 
      we are pleased to bring you, for the first time, 
      a synthesis of the best of Earth<./s>s 
      interactive fiction!<./q> ";
  "<p><.q>But be warned. The following maze may be too intense 
      for some people. For example, certain directors 
      of humanities departments might say, <.s>What on Earth 
      are you thinking, Ovan? Get this thing 
      out of my game at once!<./s>
    <p><.q>But we know better than that, don't we?<./q> ";
  nbmPause();
  nbmCls();
  //"<p>";
  "<.q>Therefore, in this greatest challenge, we will blissfully 
      ignore full-sentence parsers and complex storylines, 
      while focusing on the most basic elements 
      of the text adventure game: mazes, puzzles, and dragons. 
    <p><.q>And so, my friend, we cannot keep this a secret 
      any longer. Can your heart stand the shocking facts 
      of\ .\ .\ .<./q> ";
  nbmPause();
  nbmCls();
  "<.q>.\ .\ .\ <i>Net-Hac-Man?<./q></i> ";
  "<p>With that, the voice falls silent, and a new world
      materializes around Sheila. ";
  //"<p>";
  glob.doingHacManForReal = true;
  if (adamThorntonM.isInExe)
    goToHac.execute;
  else
    goToHacWithoutAdam.execute;
  playSound('<sound src=\"sound/hacman.mp3\" layer=foreground>');
  nbmPause();
  nbmCls();
  // Presumably these next lines would be redundant:
  //glob.status = zork;
  //statusLine.showStatusLineDaemon();
  //nbmBanner.updateMe;
  hacTitle();
  "<.p>";
  gPlayerChar.lookAround(true);
}

hacCutScene: CutScene
  beginScene {
    "<.q>Could this be the end of the maze?<./q> Sheila asks.
        <.q>Well, there<./s>s only one way to find out!<./q>
      <p>With that, she jumps enthusiastically into the hole
        and falls down and down\ .\ .\ . ";
  }
  endScene {
    glob.doingHacManForReal = true;
    if (adamThorntonM.isInExe)
      goToHac.execute;
    else
      goToHacWithoutAdam.execute;
    playSound('<sound src=\"sound/hacman.mp3\" layer=foreground>');
    //local k=0; k=k/k;
    cutSceneBanner.removeBanner;
    nbmBanner.updateMe;
    cutSceneBanner.hasVerticalScroll = true;
    csShout(
      '<.q>.\ .\ .\ <i>Net-Hac-Man?<./q></i> 
        <p>With that, the voice falls silent, and a new world
          materializes around Sheila. ');
    nbmPause();
    cutSceneBanner.removeBanner;
    cutSceneBanner.hasVerticalScroll = nil;
    
    //glob.status = zork;
    hacTitle();
    "<.p>";
    gPlayerChar.lookAround(true);
  }
  updateStatusLineAfterwards = nil
  //midScene {
  //  glob.doingHacManForReal = true;
  //  if (adamThorntonM.isInExe)
  //    goToHac.execute;
  //  else
  //    goToHacWithoutAdam.execute;
  //  playSound('<sound src=\"sound/hacman.mp3\" layer=foreground>');
  //  //local k=0; k=k/k;
  //  nbmBanner.updateMe;
  //}
  
  //banishBannerViaZeroWidth = true
  sceneList = [
    [ 'After falling for some time, Sheila 
          seems to decelerate,
          the air rushing past her 
          becoming less and less noticeable. 
          At length, she can detect no motion 
          at all, nor can she see anything.
          She is as if suspended in a void. ',
      nil,
      nil,
      nil ],
    [ 'Then, suddenly, Sheila 
          hears the voice of an Oo: 
        <p><.q>So, traveler. You<./s>ve come this far. 
          Excellent work. 
        <p><.q>But there is one final challenge--the
          most perilous, but also the most rewarding. 
          And it cuts to the core of what is best 
          about Earth<./s>s interactive fiction.<./q> ',
      nil,
      nil,
      nil ],
    [ '<.q>You see, in our research, we found lots of Earth games 
          containing mazes. One game featured 
          a hungry yellow creature in a maze of dots. 
          Another had the player find an amulet 
          in a deep and dangerous dungeon. 
          Why did humans never recognize these maze-filled games 
          as interactive fiction? No one knows.<./q> ',
      nil,
      nil,
      nil ],
    [ '<.q>What follows, therefore, is 
          a synthesis of the best of Earth<./s>s 
          interactive fiction!<./q> 
        <p><.q>But be warned. The following maze may be too intense 
          for some people. For example, certain bossy people 
          might say, <.s>What on Earth 
          are you thinking, Ovan? Get this thing 
          out of my game at once!<./s>
        <p><.q>But he doesn<./s>t know the grandeur
          of what is to come.<./q> ',
      nil,
      nil,
      nil ],
    [ '<.q>Therefore, in this final challenge, we will blissfully 
          ignore full-sentence parsers and complex storylines, 
          while focusing on the most basic elements 
          of the text adventure game: mazes, puzzles, and dragons. 
        <p><.q>And so, my friend, we cannot keep this a secret 
          any longer. Can your heart stand the shocking facts 
          of\ .\ .\ .<./q> ',
      nil,
      nil,
      nil ]
//    ,
//    [ nil,
//      '<.q>.\ .\ .\ <i>Net-Hac-Man?<./q></i> 
//        <p>With that, the voice falls silent, and a new world
//          materializes around Sheila. ',
//      true ]
      //'<sound src=\"sound/hacman.mp3\" layer=foreground>' ]
      //new function {
      //  //glob.doingHacManForReal = true;
      //  //if (adamThorntonM.isInExe)
      //  //  goToHac.execute;
      //  //else
      //  //  goToHacWithoutAdam.execute;
      //  playSound('<sound src=\"sound/hacman.mp3\" layer=foreground>');
      //} ]
      
//    [ nil,
//      '',
//      nil ],
//    [ 'firstalien.jpg',
//      '',
//      '<sound src=\"sound/alien.mp3\" layer=foreground>' ],
//    [ 'confroom.jpg',
//      '',
//      nil ],
//    [ nil,
//      '',
//      nil ]
  ]
;

modify glob
  doingHacManForReal = nil
;

hacTitle() {
  "Hello, Sheila, welcome to Net-Hac-Man! 
      You are a lawful female robot Chomper. 
    <p><b>NET-HAC-MAN!</b>
    <br>An Interactive Tribute to Pac-Man and NetHack 
    <br>by Ovan ";
  //"<br>Instructions: Virtually all commands have been disabled 
  //    except N, S, E, and W. Have fun! ";
}

// -------------------------------------------------------------------
// HAC-MAN MAZE: MAZE STATE STUFF
// -------------------------------------------------------------------

modify glob
  hacFriends {
    if (!_hacFriends)
      initializeHacLists;
    return _hacFriends;
  }
  _hacFriends = nil
  hacEnemies {
    if (!_hacEnemies)
      initializeHacLists;
    return _hacEnemies;
  }
  _hacEnemies = nil
  hacNpcs {
    if (!_hacNpcs)
      initializeHacLists;
    return _hacNpcs;
  }
  _hacNpcs = nil
  hacChars {
    if (!_hacChars)
      initializeHacLists;
    return _hacChars;
  }
  _hacChars = nil
  // Since this property is used only for the map, we let
  // nbmBanner.updateMe take care of it.
  localHacNpcs = nil
  initializeHacLists {
    _hacFriends = [adam, bandit];
    _hacEnemies = listClassMembers(HacEnemy);
    _hacEnemies = _hacEnemies.sort(nil, {a, b: a.priority - b.priority});
    _hacNpcs = _hacFriends + _hacEnemies;
    _hacChars = [bot] + _hacNpcs;
  }
  listClassMembers(cls) {
    local lst = [];
    for (local cur = firstObj(cls); cur != nil; 
         cur = nextObj(cur, cls)) {
      lst += cur;
    }
    return lst;
  }
;

saveInitialHacInfo() {
  glob.scoreUponEnteringHac = libScore.totalScore;
  glob.turnsUponEnteringHac = libGlobal.totalTurns;
  // Everything else should always be the same upon first entering 
  // Net-Hac-Man, except for any MazePortable items, which are
  // dealt with separately.
}

// Boy, oh boy, are there ever a lot of variables that need to
// be changed when resetting this maze. Hopefully I found them all.
restoreInitialHacInfo() {
  // ------------------
  // Score and turns
  
  // This is *seriously* not the way you're supposed to decrease 
  // the player's score. But, since the FULL SCORE command is 
  // disabled for my game, I don't think this should do any harm.
  libScore.totalScore = glob.scoreUponEnteringHac;
  scoreNotifier.lastScore = libScore.totalScore;
  libGlobal.totalTurns = glob.turnsUponEnteringHac;
  glob.dotsEaten = 0;
  glob.bigDotsEaten = 0;
  
  // ------------------
  // General stuff
  
  glob.eenieMeenie = 1;
  glob.meleeOpponent = nil;
  //glob.hacInvoked = nil; // unnecessary
  // I believe it would be entirely redundant and undesirable 
  // to run the chompDaemon here. It has already been taken care of
  // and shouldn't be dealt with more than once.
  //chompDaemon.startDaemon; 
  
  // ------------------
  // Room-related stuff
  
  for (local cur = firstObj(HacRoom); cur != nil; 
       cur = nextObj(cur,HacRoom)) {
    cur.hasDotType = cur.initiallyHasDotType;
  }
  
  // ------------------
  // PC-related stuff
  
  //bot.location //already taken care of
  bot.turnsDuringHac = 0;
  bot.dirFacing = eastValue;
  bot.chompCount = 0;
  bot.currentRoom = hacRoomH12;
  bot.previousRoom = nil;
  bot.isPowered = nil;
  bot.powerCount = 0;
  bot.hitPoints = bot.maxHitPoints;
  bot.hunger = 0;
  
  // ------------------
  // NPC-related stuff
  
  // First, deactivate the NPCs...
  for (local cur = firstObj(HacNpc); cur != nil; 
       cur = nextObj(cur, HacNpc)) {
    cur.deactivateNpc;
    cur.isDead = nil;
    cur.previousRoom = nil;
    cur.hasBeenSeen = nil;
    // Presumably, cur.location == nil after deactivation. Therefore, 
    // here we are setting cur.currentRoom to nil.
    cur.currentRoom = cur.location;
    //realLocation // already taken care of
    //location // already taken care of
    cur.agendaCount = 0;
    cur.isFleeing = nil;
    cur.banditState = 0;
    cur.hasScoffed = nil;
    cur.hitPoints = cur.maxHitPoints;
    if (cur.ofKind(HacEnemy)) {
      cur.knownByAdam = nil;
      cur.isTransformed = nil; // only for hostile npcs
      cur.isWhite = nil; // only for hostile npcs
      cur.vanquishedByBot = nil; // only for hostile npcs
      cur.vanquishedColor = nil;
    }
    if (cur.ofKind(HacFriend)) {
      cur.npcGoal = nil; // only for friendly npcs
      cur.northHowLong = 0; //only for friendly npcs
    }
  }
  bandit.hasBeenActivated = nil; // only for bandit
  copyman.gripeCount = 0;
  copyman.gripesUttered = 0;
  adam.helpInstances = 0;
  glob.vanquishedCreatures = [];
  glob.hacEnemyCount = 0; // make sure this happens *before* NPC re-activation
  
  // Do AdamTopic stuff
  for (local cur = firstObj(AdamTopic); cur != nil; 
       cur = nextObj(cur, AdamTopic)) {
    cur.timesUttered = 0;
    cur.isEligible = cur.initiallyEligible;
    cur.hasBeenUttered = nil;
  }
  
  // misc stuff
  adamWaitSouth.quaffCount = -1;
  
  // It is unnecessary and undesirable to call invokeHac() again.
  // We have already re-activated the NPCs, etc., and we don't want to 
  // re-run the chompDaemon.
}

activateInitialHacNpcs() {
  // ...then reactivate some NPCs as needed.
  glob.firstHacEnemy.activateNpc;
  glob.firstHacEnemy.currentRoom = glob.firstHacEnemy.location;
  //dragon.currentRoom = dragon.location;
  if (adamThorntonM.isInExe) {
    adam.activateNpc;
    adam.currentRoom = adam.location;
  }
}

modify glob
  scoreUponEnteringHac = 0
  turnsUponEnteringHac = 0
;


// -------------------------------------------------------------------
// HAC-MAN MAZE: ROOM STUFF: ROOM CLASSES
// -------------------------------------------------------------------

modify glob
  hackHacManMap = nil
;

class HacRoom: Room
  isNorthernHacRoom = nil
  bannerValue = nethacman
  potentialScoreProp = &potentialScoreHacman
  initialPsp = &initialPotentialScoreHacman
  firstRoomInThisMazeSet = hacRoomH12
  initiallyHasDotType = nil
  hasDotType = initiallyHasDotType
  // Going to a room isn't just as simple as going to a room. If 
  // there is an NPC in that room, we will have to confront that NPC.
  // If our confrontation rids the room of that NPC (i.e., basically, 
  // if we kill the NPC), then continue going on to that room.
  // If such confrontation leaves the NPC still in that room,
  // then don't enter the room.
  dobjFor(TravelVia) {
    action {
      // UNIVERSALIZE (finished)
      //local charList = [bot, dragon, copyman, adam, bandit];
      local whatToDo;
      // If by some chance gActor is an NPC, just do the default thing.
      if (gActor != gPlayerChar) {
        inherited();
        return;
      }
      // Now we know gActor is the PC.
      for (local a = 1; a <= glob.hacChars.length; a++) {
        if (glob.hacChars[a].realLocation == self) {
          // confrontChar() will either initiate combat or otherwise
          // confront the character who is standing in front of the NPC.
          // confrontChar() will also return a value, either advance, 
          // advanceQuietly, or halt. Act accordingly, as per this 
          // returned value, after the confrontation.
          whatToDo = gActor.confrontChar(glob.hacChars[a]);
          if (whatToDo == halt) {
            return;
          }
          else {
            inherited();
            return;
          }
        }
      }
      // If no NPC encountered, then do the normal thing.
      inherited();
    }
  }
  enteringRoom(traveler) {
    //nbmBanner.updateMe(); // Just to be safe, explicitly call this,
    //                      // though "inherited();" ought to work.
    //invokeHac();
  }
  dotDesc {
    if (hasDotType != nil)
      "<.p>There <<hasDotType == twoDots ? 'are' : 'is'>> 
        <<aDotName(hasDotType)>> here. <.p>";
  }
  leavingRoom(traveler) {
    if (gActor == gPlayerChar) {
      local gDobjIsDir = nil;
      local dirStr = 'distant hallway';
      local dotValue = 0;
      if (gDobj == north) { gPlayerChar.dirFacing = northValue; dirStr = 'north'; gDobjIsDir = true; }
      if (gDobj == south) { gPlayerChar.dirFacing = southValue; dirStr = 'south'; gDobjIsDir = true; }
      if (gDobj == east ) { gPlayerChar.dirFacing = eastValue ; dirStr = 'east' ; gDobjIsDir = true; }
      if (gDobj == west ) { gPlayerChar.dirFacing = westValue ; dirStr = 'west' ; gDobjIsDir = true; }
      // Check to see if by any chance we are about to 
      // complete Net-Hac-Man this turn. If so, let Sheila 
      // make a final speech first.
      if (gDobjIsDir && glob.totalHacScore >= 140
          && gDobj && gDobj.getDestination(self, bot) 
          && gDobj.getDestination(self, bot).hasDotType) {
        switch (gDobj.getDestination(self, bot).hasDotType) {
          case oneDot:
            dotValue = 1;
            break;
          case twoDots:
            dotValue = 2;
            break;
          case oneBigDot:
            dotValue = glob.bigDotValue;
            break;
        }
      }
      if (dotValue && dotValue + glob.totalHacScore >= 150) {
        letSheilaGiveFinalSpeech(nil, dirStr);
      }
    }
    //if (gActor != gPlayerChar) {
    //  previousRoom = location;
    //}
  }
  xyName() {
    local str;
    switch (xValue) {
      case  1: str = 'A'; break;
      case  2: str = 'B'; break;
      case  3: str = 'C'; break;
      case  4: str = 'D'; break;
      case  5: str = 'E'; break;
      case  6: str = 'F'; break;
      case  7: str = 'G'; break;
      case  8: str = 'H'; break;
      case  9: str = 'I'; break;
      case 10: str = 'J'; break;
      case 11: str = 'K'; break;
      case 12: str = 'L'; break;
      case 13: str = 'M'; break;
      case 14: str = 'N'; break;
      case 15: str = 'O'; break;
    }
    str = str + yValue;
    return str;
  }
  twoDotFilename = 'dots28'
  // UNIVERSALIZE (finished)
  giveFilename() {
    // First check for inhabitants...
    if (bot.location == self && !glob.pcIsDead)
      return bot.giveFilename;
    if (!glob.hackHacManMap) {
      for (local a = 1; a <= glob.localHacNpcs.length; a++) {
        if (glob.localHacNpcs[a].realLocation == self)
          return glob.localHacNpcs[a].giveFilename;
      }
    }
    // If there are no inhabitants, then...
    if (self == hacRoomH9) return 'gate';
    if (hasDotType == nil) return 'nil';
    if (hasDotType == oneDot) return 'dot';
    if (hasDotType == twoDots) return twoDotFilename;
    if (hasDotType == oneBigDot) return 'pellet';
    return 'nil';
  }
  
  
  //giveFilename() {
  //  // First check for inhabitants...
  //  if (gPlayerChar.location == self && !gPlayerChar.isDead) {
  //    switch (gPlayerChar.dirFacing) {
  //      case northValue: return 'hacmanN';
  //      case southValue: return 'hacmanS';
  //      case eastValue:  return 'hacmanE';
  //      case westValue:  return 'hacmanW';
  //    }
  //  }
  //  if (adam.realLocation == self) return 'adam';
  //  if (bandit.realLocation == self) return 'bandit';
  //  if (dragon.realLocation == self) {
  //    if (!dragon.isTransformed)
  //      return 'dragon';
  //    // If the dragon is transformed, make sure to check how long
  //    // the bot has been powered up. The color of the lowercase "d"
  //    // depends on that.
  //    else if (glob.maxPowerCount - bot.powerCount > 2)
  //      return 'duck';
  //    else
  //      return 'duck2';
  //  }
  //  if (copyman.realLocation == self) {
  //    if (!copyman.isTransformed)
  //      return 'copyman';
  //    // 
  //    else if (glob.maxPowerCount - bot.powerCount > 2)
  //      return 'chicken';
  //    else
  //      return 'chicken2';
  //  }
  //  if (death.location == self) return 'death';
  //  // If there are no inhabitants, then...
  //  if (hasDotType == nil) return 'nil';
  //  if (hasDotType == oneDot) return 'dot';
  //  if (hasDotType == twoDots) return twoDotFilename;
  //  if (hasDotType == oneBigDot) {
  //    if (glob.thornton) return 'beer';
  //    else return 'pellet';
  //  }
  //  return 'nil';
  //}
  resetThisMazeSet {
    restoreInitialHacInfo();
    if (gAction.baseActionClass != BeginAction)
      activateInitialHacNpcs();
    inherited();
  }
  giveHint {
    "Looking around wide-eyed, Sheila says, <.q>This isn<./s>t 
      a part of the game anybody ever told me about!
      I don<./s>t know what to do any more than you do.
      Sorry I can<./s>t help more.<./q> ";
  }
  hacColumn = nil
  hacRow = nil
  //dobjFor(TravelVia) {
  //  check() {
  //    "No, wait. I'm not sure I want you to be able to move around at all in this maze. You better stay put. ";
  //    exit;
  //  }
  //}
;

class HacHallwayWE: HacRoom
  roomName = 'Hallway'
  destName = 'the hallway'
  proxyName = 'hallway'
  proxyNamePlural = 'hallways'
  hacRoomType = hacHallway
  twoDotFilename = 'dots46'
  desc {
    if (west.hacRoomType == hacHallway && east.hacRoomType == hacHallway) {
      "This is a hallway that extends west and east. ";
    }
    else if (west.hacRoomType == hacHallway) {
      "This is a hallway that extends west. 
        To the east lies a <<east.proxyName>>. ";
    }
    else if (east.hacRoomType == hacHallway) {
      "This is a hallway that extends east. 
        To the west lies a <<west.proxyName>>. ";
    }
    else if (west.hacRoomType == east.hacRoomType) {
      "This is an east-west hallway. 
        There are <<west.proxyNamePlural>> 
        to the west and to the east. ";
    }
    else {
      "This is an east-west hallway. 
        To the west lies a <<west.proxyName>>, 
        while to the east lies a <<east.proxyName>>. ";
    }
    dotDesc;
  }
;

class HacHallwayNS: HacRoom
  roomName = 'Hallway'
  destName = 'the hallway'
  proxyName = 'hallway'
  proxyNamePlural = 'hallways'
  hacRoomType = hacHallway
  desc {
    if (north.hacRoomType == hacHallway && south.hacRoomType == hacHallway) {
      "This is a hallway that extends north and south. ";
    }
    else if (north.hacRoomType == hacHallway) {
      "This is a hallway that extends north. 
        To the south lies a <<south.proxyName>>. ";
    }
    else if (south.hacRoomType == hacHallway) {
      "This is a hallway that extends south. 
        To the north lies a <<north.proxyName>>. ";
    }
    else if (north.hacRoomType == south.hacRoomType) {
      "This is a north-south hallway. 
        There are <<north.proxyNamePlural>> 
        to the north and to the south. ";
    }
    else {
      "This is a north-south hallway. 
        To the north lies a <<north.proxyName>>, 
        while to the south lies a <<south.proxyName>>. ";
    }
    dotDesc;
  }
;

class HacBend: HacRoom
  roomName = 'Bend'
  destName = 'the bend'
  proxyName = 'bend in the hallway'
  proxyNamePlural = 'bends in the hallway'
  hacRoomType = hacBend
  dirString1 = ''
  dirString2 = ''
  desc {
    "The hallway bends here, allowing your bot to go either 
      <<dirString1>> or <<dirString2>>. ";
    dotDesc;
  }
  enteringRoom(traveler) {
    //nbmBanner.updateMe(); // Just to be safe, explicitly call this,
    //                      // though "inherited();" ought to work.
    //invokeHac();
    if (!gActor.hasSeen(self)) {
      if (north) {
        dirString1 = 'north';
        if (west) dirString2 = 'west';
        else dirString2 = 'east';
      }
      else { // If no exit goes north, there 
             // must be an exit that goes south.
        if (west) dirString1 = 'west';
        else dirString1 = 'east';
        dirString2 = 'south';
      }
    }
  }
;

class HacJunction: HacRoom
  roomName = 'Junction'
  destName = 'the junction'
  proxyName = 'junction'
  proxyNamePlural = 'junctions'
  hacRoomType = hacJunction
  dirString1 {
    if (north && south)
      return 'north and south';
    else if (west && east)
      return 'east and west';
    else if (west)
      return 'west';
    else
      return 'east';
  }
  dirString2 {
    if (north && south) {
      if (east && west)
        return 'east and west';
      else if (west)
        return 'west';
      else
        return 'east';
    }
    else { // we have to assume (east && west)
      if (north && south)
        return 'north and south';
      else if (north)
        return 'north';
      else
        return 'south';
    }
  }
  desc {
    "This is a junction of two hallways. 
      One hallway leads <<dirString1>>, 
      while the other leads <<dirString2>>. ";
    dotDesc;
  }
  enteringRoom(traveler) {
    //nbmBanner.updateMe(); // Just to be safe, explicitly call this,
    //                      // though "inherited();" ought to work.
    //invokeHac();
//    if (!gActor.hasSeen(self)) {
//      if (north && south) {
//        dirString1 = 'north and south';
//        if (west && east) dirString2 = 'east and west';
//        else if (west) dirString2 = 'west';
//        else dirString2 = 'east';
//      }
//      else {
//        dirString1 = 'east and west';
//        if (north && south) dirString2 = 'north and south';
//        else if (north) dirString2 = 'north';
//        else dirString2 = 'south';
//      }
//    }
  }
  // HacJunction is a special kind of HacRoom because it is where
  // NPCs decide which way to go, based on where they want to be.
  // Therefore, we need some special methods here.
  
  
  goWhereForRoom(rm, chasing, exclDirLst, stupidity) {
    //stupidity = 40;
    local distList, dirList, bestDist;
    local stumble = nil;
    // Under certain freak conditions, rm can be equal to nil.
    // To prevent a run-time error, make sure rm equals something -- 
    // say, hacRoomH8.
    if (!rm)
      rm = hacRoomH8;
    // If stupidity means bad estimation of distances, then NPCs will
    // make more mistakes when they are farther away from you. 
    // If stupidity does NOT mean bad estimation of distances,
    // NPCs will make mistakes just as often, no matter what distance
    // they are from you.
    local stupidityMeansBadEstimation = nil;
//    // The values in exclDirLst should be integers. If they are direction
//    // properties, change them to integers. E.g. &north -> 1.
//    for (local a = 1; a <= exclDirLst.length; a++) {
//      if (glob.fourDirList.indexOf(exclDirLst[a]))
//        exclDirLst[1] = glob.fourDirList.indexOf(exclDirLst[a]);
//    }
    // Get list of distances to the given room, of the form:
    // [distIfGoingNorth, distIfGoingEast, distIfGoingSouth, distIfGoingWest]
    distList = distToRoomList(rm);
    // Determine the best distance in the list (ignoring exclDirLst directions,
    // if applicable). There's probably a better way to do this, 
    // but this will do. Note that "best" means "shortest" if chasing, 
    // "longest" if not chasing.
    bestDist = (chasing ? 1000 : 0);
    for (local a = 1; a <= 4; a++) {
      if (chasing && distList[a] < bestDist && !exclDirLst.indexOf(a))
        bestDist = distList[a];
      else if (!chasing && distList[a] > bestDist && distList[a] < 1000 && !exclDirLst.indexOf(a))
        bestDist = distList[a];
    }
    // If we're chasing, and if bestDist shows we are reasonably
    // far away from the PC, then make it so that 
    // stupidity means bad estimation.
    if (chasing && bestDist > 5)
      stupidityMeansBadEstimation = true;
    // If stupidity DOES NOT mean bad estimation, then stupidity
    // means that the NPC will "stumble" every so often -- that is,
    // will go a random way instead of the best way. This will happen
    // equally often regardless of how far away the NPC is from the PC.
    // For that we need a stumble variable.
    local completeStupidity = 25;
    if (!stupidityMeansBadEstimation && stupidity > 1) { 
      if (stupidity > completeStupidity)
        stupidity = completeStupidity;
      if (rand(completeStupidity) < stupidity)
        stumble = true;
    }
    // Create a list of the directions that are to be considered
    // as acceptable choices.
    dirList = [];
    for (local a = 1; a <= 4; a++) {
      // If stupidity means bad estimation, 
      // choose the paths whose distances are within a stupidity factor's 
      // margin of being as good as the best distance.
      if (stupidityMeansBadEstimation && chasing
        && distList[a] <= (bestDist + stupidity) && !exclDirLst.indexOf(a)) {
          dirList = dirList + glob.fourDirList[a];
      }
      else if (stupidityMeansBadEstimation && !chasing
        && distList[a] >= (bestDist - stupidity) && distList[a] < 1000 && !exclDirLst.indexOf(a)) {
          dirList = dirList + glob.fourDirList[a];
      }
      // If stupidity does NOT mean bad estimation, and if we're not 
      // stumbling, choose only the paths whose distances are equal 
      // to the best distance.
      else if (!stupidityMeansBadEstimation && !stumble
        && distList[a] == (bestDist) && !exclDirLst.indexOf(a)) {
          dirList = dirList + glob.fourDirList[a];
      }
      // If stupidity does NOT mean bad estimation, and if we ARE 
      // stumbling, choose any and all legal paths.
      else if (!stupidityMeansBadEstimation && stumble
        && distList[a] <= 999 && !exclDirLst.indexOf(a)) {
          dirList = dirList + glob.fourDirList[a];
      }
    }
    
    //if (!chasing) { local k=0;k=k/k; }
    
    //local k=0;k=k/k;
    if (dirList.length == 1)
      return dirList[1];
    else
      return rand(dirList);
  }
/*
(stupidityMeansBadEstimation && chasing && distList[a] <= (bestDist + stupidity) && exclDirLst.indexOf(a))
(stupidityMeansBadEstimation && !chasing && distList[a] >= (bestDist - stupidity) && exclDirLst.indexOf(a))
(!stupidityMeansBadEstimation && !stumble && distList[a] == (bestDist) && exclDirLst.indexOf(a)
(!stupidityMeansBadEstimation && stumble && distList[a] <= 999 && exclDirLst.indexOf(a)
*/
  goWhereToChaseRoom(rm, excludeDir, stupidity) {
    local distList, dirList, shortestDist;
    // excludeDir should be an integer. If it is given as a direction
    // property, change it to an integer. E.g. &north -> 1.
    if (glob.fourDirList.indexOf(excludeDir))
      excludeDir = glob.fourDirList.indexOf(excludeDir);
    // Get list of distances to the given room, of the form:
    // [distIfGoingNorth, distIfGoingEast, distIfGoingSouth, distIfGoingWest]
    distList = distToRoomList(rm);
    // Determine the shortest distance in the list (ignoring excludeDir,
    // if applicable). There's probably 
    // a better way to do this, but this will do.
    shortestDist = 1000;
    for (local a = 1; a <= 4; a++) {
      if (distList[a] < shortestDist && a != excludeDir)
        shortestDist = distList[a];
    }
    // Create a list of the directions that are to be considered
    // as acceptable choices.
    dirList = [];
    for (local a = 1; a <= 4; a++) {
      // "stupidity" works here as a variable that decreases the
      // accuracy of the NPC's judgments at determining which
      // direction is best.
      if (distList[a] <= (shortestDist + stupidity) && a != excludeDir)
        dirList = dirList + glob.fourDirList[a];
    }
    if (dirList.length == 1)
      return dirList[1];
    else
      return rand(dirList);
  }
  // Determine the best direction for an NPC to go, in order to get to 
  // the specified location.
  goWhereToGetToRoom(rm, stupidness) {
    //local a;
    local shortdirvec = new Vector(4);
    local shortdist = 1000;
    local curdist = 0;
    local curlen = 0;
    for (local a=1; a<=4; ++a) {
      curdist = distToRoom(rm, a);
      if (curdist < shortdist) {
        shortdirvec = new Vector(4);
        shortdirvec[1] = a;
        shortdist = curdist;
      }
      else if (curdist == shortdist) {
        curlen = shortdirvec.length();
        shortdirvec[curlen + 1] = a;
      }
    }
    if (shortdirvec.length() == 0) {
      "Whoa, man! Serious problem with the vector in goWhereToGetToRoom! ";
      return 0;
    }
    if (shortdirvec.length() == 1) return shortdirvec[1];
    // Otherwise, there's a tie for the shortest route.
    // In this case, use glob.eenieMeenie to determine a pseudo-
    // random value.
    return eenieVector(shortdirvec);
  }
  // See below for the new and improved distToRoom.
  //distToRoom(rm, dir) {
  //  // rm  = Room to determine the distance to
  //  // dir = direction: 1=N, 2=E, 3=S, 4=W
  //  switch (rm) {
  //    case hacRoomA2 : return distToA2[dir];
  //    case hacRoomB2 : return distToB2[dir];
  //    case hacRoomC2 : return distToC2[dir];
  //    case hacRoomD2 : return distToD2[dir];
  //    case hacRoomE2 : return distToE2[dir];
  //    case hacRoomF2 : return distToF2[dir];
  //    case hacRoomG2 : return distToG2[dir];
  //    case hacRoomH2 : return distToH2[dir];
  //    case hacRoomI2 : return distToI2[dir];
  //    case hacRoomJ2 : return distToJ2[dir];
  //    case hacRoomK2 : return distToK2[dir];
  //    case hacRoomL2 : return distToL2[dir];
  //    case hacRoomM2 : return distToM2[dir];
  //    case hacRoomN2 : return distToN2[dir];
  //    case hacRoomD3 : return distToD3[dir];
  //    case hacRoomJ3 : return distToJ3[dir];
  //    case hacRoomN3 : return distToN3[dir];
  //    case hacRoomD4 : return distToD4[dir];
  //    case hacRoomE4 : return distToE4[dir];
  //    case hacRoomF4 : return distToF4[dir];
  //    case hacRoomH4 : return distToH4[dir];
  //    case hacRoomI4 : return distToI4[dir];
  //    case hacRoomJ4 : return distToJ4[dir];
  //    case hacRoomK4 : return distToK4[dir];
  //    case hacRoomL4 : return distToL4[dir];
  //    case hacRoomN4 : return distToN4[dir];
  //    case hacRoomD5 : return distToD5[dir];
  //    case hacRoomF5 : return distToF5[dir];
  //    case hacRoomH5 : return distToH5[dir];
  //    case hacRoomJ5 : return distToJ5[dir];
  //    case hacRoomL5 : return distToL5[dir];
  //    case hacRoomN5 : return distToN5[dir];
  //    case hacRoomB6 : return distToB6[dir];
  //    case hacRoomC6 : return distToC6[dir];
  //    case hacRoomD6 : return distToD6[dir];
  //    case hacRoomF6 : return distToF6[dir];
  //    case hacRoomG6 : return distToG6[dir];
  //    case hacRoomH6 : return distToH6[dir];
  //    case hacRoomJ6 : return distToJ6[dir];
  //    case hacRoomL6 : return distToL6[dir];
  //    case hacRoomM6 : return distToM6[dir];
  //    case hacRoomN6 : return distToN6[dir];
  //    case hacRoomB7 : return distToB7[dir];
  //    case hacRoomD7 : return distToD7[dir];
  //    case hacRoomH7 : return distToH7[dir];
  //    case hacRoomJ7 : return distToJ7[dir];
  //    case hacRoomN7 : return distToN7[dir];
  //    case hacRoomB8 : return distToB8[dir];
  //    case hacRoomD8 : return distToD8[dir];
  //    case hacRoomE8 : return distToE8[dir];
  //    case hacRoomF8 : return distToF8[dir];
  //    case hacRoomG8 : return distToG8[dir];
  //    case hacRoomH8 : return distToH8[dir];
  //    case hacRoomI8 : return distToI8[dir];
  //    case hacRoomJ8 : return distToJ8[dir];
  //    case hacRoomK8 : return distToK8[dir];
  //    case hacRoomL8 : return distToL8[dir];
  //    case hacRoomN8 : return distToN8[dir];
  //    case hacRoomB9 : return distToB9[dir];
  //    case hacRoomD9 : return distToD9[dir];
  //    case hacRoomL9 : return distToL9[dir];
  //    case hacRoomN9 : return distToN9[dir];
  //    case hacRoomB10: return distToB10[dir];
  //    case hacRoomC10: return distToC10[dir];
  //    case hacRoomD10: return distToD10[dir];
  //    case hacRoomL10: return distToL10[dir];
  //    case hacRoomM10: return distToM10[dir];
  //    case hacRoomN10: return distToN10[dir];
  //    case hacRoomB11: return distToB11[dir];
  //    case hacRoomD11: return distToD11[dir];
  //    case hacRoomL11: return distToL11[dir];
  //    case hacRoomN11: return distToN11[dir];
  //    case hacRoomB12: return distToB12[dir];
  //    case hacRoomD12: return distToD12[dir];
  //    case hacRoomE12: return distToE12[dir];
  //    case hacRoomF12: return distToF12[dir];
  //    case hacRoomG12: return distToG12[dir];
  //    case hacRoomH12: return distToH12[dir];
  //    case hacRoomI12: return distToI12[dir];
  //    case hacRoomJ12: return distToJ12[dir];
  //    case hacRoomK12: return distToK12[dir];
  //    case hacRoomL12: return distToL12[dir];
  //    case hacRoomN12: return distToN12[dir];
  //    case hacRoomB13: return distToB13[dir];
  //    case hacRoomF13: return distToF13[dir];
  //    case hacRoomH13: return distToH13[dir];
  //    case hacRoomL13: return distToL13[dir];
  //    case hacRoomN13: return distToN13[dir];
  //    case hacRoomB14: return distToB14[dir];
  //    case hacRoomC14: return distToC14[dir];
  //    case hacRoomD14: return distToD14[dir];
  //    case hacRoomF14: return distToF14[dir];
  //    case hacRoomH14: return distToH14[dir];
  //    case hacRoomI14: return distToI14[dir];
  //    case hacRoomJ14: return distToJ14[dir];
  //    case hacRoomL14: return distToL14[dir];
  //    case hacRoomM14: return distToM14[dir];
  //    case hacRoomN14: return distToN14[dir];
  //    case hacRoomB15: return distToB15[dir];
  //    case hacRoomD15: return distToD15[dir];
  //    case hacRoomF15: return distToF15[dir];
  //    case hacRoomH15: return distToH15[dir];
  //    case hacRoomJ15: return distToJ15[dir];
  //    case hacRoomL15: return distToL15[dir];
  //    case hacRoomB16: return distToB16[dir];
  //    case hacRoomD16: return distToD16[dir];
  //    case hacRoomE16: return distToE16[dir];
  //    case hacRoomF16: return distToF16[dir];
  //    case hacRoomG16: return distToG16[dir];
  //    case hacRoomH16: return distToH16[dir];
  //    case hacRoomJ16: return distToJ16[dir];
  //    case hacRoomK16: return distToK16[dir];
  //    case hacRoomL16: return distToL16[dir];
  //    case hacRoomB17: return distToB17[dir];
  //    case hacRoomF17: return distToF17[dir];
  //    case hacRoomL17: return distToL17[dir];
  //    case hacRoomB18: return distToB18[dir];
  //    case hacRoomC18: return distToC18[dir];
  //    case hacRoomD18: return distToD18[dir];
  //    case hacRoomE18: return distToE18[dir];
  //    case hacRoomF18: return distToF18[dir];
  //    case hacRoomG18: return distToG18[dir];
  //    case hacRoomH18: return distToH18[dir];
  //    case hacRoomI18: return distToI18[dir];
  //    case hacRoomJ18: return distToJ18[dir];
  //    case hacRoomK18: return distToK18[dir];
  //    case hacRoomL18: return distToL18[dir];
  //    case hacRoomM18: return distToM18[dir];
  //    case hacRoomN18: return distToN18[dir];
  //    case hacRoomO18: return distToO18[dir];
  //    case hacRoomH9 : return distToH9[dir];  // two final oddball cases:
  //    case hacRoomH10: return distToH10[dir];
  //    default: return -1; // bogus; should never happen
  //  }
  //}
  //distToRoomList(rm) {
  //  // rm  = Room to give a list of distances to
  //  switch (rm) {
  //    case hacRoomA2 : return distToA2;
  //    case hacRoomB2 : return distToB2;
  //    case hacRoomC2 : return distToC2;
  //    case hacRoomD2 : return distToD2;
  //    case hacRoomE2 : return distToE2;
  //    case hacRoomF2 : return distToF2;
  //    case hacRoomG2 : return distToG2;
  //    case hacRoomH2 : return distToH2;
  //    case hacRoomI2 : return distToI2;
  //    case hacRoomJ2 : return distToJ2;
  //    case hacRoomK2 : return distToK2;
  //    case hacRoomL2 : return distToL2;
  //    case hacRoomM2 : return distToM2;
  //    case hacRoomN2 : return distToN2;
  //    case hacRoomD3 : return distToD3;
  //    case hacRoomJ3 : return distToJ3;
  //    case hacRoomN3 : return distToN3;
  //    case hacRoomD4 : return distToD4;
  //    case hacRoomE4 : return distToE4;
  //    case hacRoomF4 : return distToF4;
  //    case hacRoomH4 : return distToH4;
  //    case hacRoomI4 : return distToI4;
  //    case hacRoomJ4 : return distToJ4;
  //    case hacRoomK4 : return distToK4;
  //    case hacRoomL4 : return distToL4;
  //    case hacRoomN4 : return distToN4;
  //    case hacRoomD5 : return distToD5;
  //    case hacRoomF5 : return distToF5;
  //    case hacRoomH5 : return distToH5;
  //    case hacRoomJ5 : return distToJ5;
  //    case hacRoomL5 : return distToL5;
  //    case hacRoomN5 : return distToN5;
  //    case hacRoomB6 : return distToB6;
  //    case hacRoomC6 : return distToC6;
  //    case hacRoomD6 : return distToD6;
  //    case hacRoomF6 : return distToF6;
  //    case hacRoomG6 : return distToG6;
  //    case hacRoomH6 : return distToH6;
  //    case hacRoomJ6 : return distToJ6;
  //    case hacRoomL6 : return distToL6;
  //    case hacRoomM6 : return distToM6;
  //    case hacRoomN6 : return distToN6;
  //    case hacRoomB7 : return distToB7;
  //    case hacRoomD7 : return distToD7;
  //    case hacRoomH7 : return distToH7;
  //    case hacRoomJ7 : return distToJ7;
  //    case hacRoomN7 : return distToN7;
  //    case hacRoomB8 : return distToB8;
  //    case hacRoomD8 : return distToD8;
  //    case hacRoomE8 : return distToE8;
  //    case hacRoomF8 : return distToF8;
  //    case hacRoomG8 : return distToG8;
  //    case hacRoomH8 : return distToH8;
  //    case hacRoomI8 : return distToI8;
  //    case hacRoomJ8 : return distToJ8;
  //    case hacRoomK8 : return distToK8;
  //    case hacRoomL8 : return distToL8;
  //    case hacRoomN8 : return distToN8;
  //    case hacRoomB9 : return distToB9;
  //    case hacRoomD9 : return distToD9;
  //    case hacRoomL9 : return distToL9;
  //    case hacRoomN9 : return distToN9;
  //    case hacRoomB10: return distToB10;
  //    case hacRoomC10: return distToC10;
  //    case hacRoomD10: return distToD10;
  //    case hacRoomL10: return distToL10;
  //    case hacRoomM10: return distToM10;
  //    case hacRoomN10: return distToN10;
  //    case hacRoomB11: return distToB11;
  //    case hacRoomD11: return distToD11;
  //    case hacRoomL11: return distToL11;
  //    case hacRoomN11: return distToN11;
  //    case hacRoomB12: return distToB12;
  //    case hacRoomD12: return distToD12;
  //    case hacRoomE12: return distToE12;
  //    case hacRoomF12: return distToF12;
  //    case hacRoomG12: return distToG12;
  //    case hacRoomH12: return distToH12;
  //    case hacRoomI12: return distToI12;
  //    case hacRoomJ12: return distToJ12;
  //    case hacRoomK12: return distToK12;
  //    case hacRoomL12: return distToL12;
  //    case hacRoomN12: return distToN12;
  //    case hacRoomB13: return distToB13;
  //    case hacRoomF13: return distToF13;
  //    case hacRoomH13: return distToH13;
  //    case hacRoomL13: return distToL13;
  //    case hacRoomN13: return distToN13;
  //    case hacRoomB14: return distToB14;
  //    case hacRoomC14: return distToC14;
  //    case hacRoomD14: return distToD14;
  //    case hacRoomF14: return distToF14;
  //    case hacRoomH14: return distToH14;
  //    case hacRoomI14: return distToI14;
  //    case hacRoomJ14: return distToJ14;
  //    case hacRoomL14: return distToL14;
  //    case hacRoomM14: return distToM14;
  //    case hacRoomN14: return distToN14;
  //    case hacRoomB15: return distToB15;
  //    case hacRoomD15: return distToD15;
  //    case hacRoomF15: return distToF15;
  //    case hacRoomH15: return distToH15;
  //    case hacRoomJ15: return distToJ15;
  //    case hacRoomL15: return distToL15;
  //    case hacRoomB16: return distToB16;
  //    case hacRoomD16: return distToD16;
  //    case hacRoomE16: return distToE16;
  //    case hacRoomF16: return distToF16;
  //    case hacRoomG16: return distToG16;
  //    case hacRoomH16: return distToH16;
  //    case hacRoomJ16: return distToJ16;
  //    case hacRoomK16: return distToK16;
  //    case hacRoomL16: return distToL16;
  //    case hacRoomB17: return distToB17;
  //    case hacRoomF17: return distToF17;
  //    case hacRoomL17: return distToL17;
  //    case hacRoomB18: return distToB18;
  //    case hacRoomC18: return distToC18;
  //    case hacRoomD18: return distToD18;
  //    case hacRoomE18: return distToE18;
  //    case hacRoomF18: return distToF18;
  //    case hacRoomG18: return distToG18;
  //    case hacRoomH18: return distToH18;
  //    case hacRoomI18: return distToI18;
  //    case hacRoomJ18: return distToJ18;
  //    case hacRoomK18: return distToK18;
  //    case hacRoomL18: return distToL18;
  //    case hacRoomM18: return distToM18;
  //    case hacRoomN18: return distToN18;
  //    case hacRoomO18: return distToO18;
  //    case hacRoomH9 : return distToH9;  // two final oddball cases:
  //    case hacRoomH10: return distToH10;
  //    default: return -1; // bogus; should never happen
  //  }
  //}
  //distToH9 = [distToH8[1]+1, distToH8[2]+1, distToH8[3]+1, distToH8[4]+1]
  //distToH10= [distToH8[1]+2, distToH8[2]+2, distToH8[3]+2, distToH8[4]+2]
;

// -------------------------------------------------------------------
// HAC-MAN MAZE: ROOM STUFF: ROOMS: ORDINARY ROOMS
// -------------------------------------------------------------------

hacRoomA2: HacHallwayWE
  xValue = 1
  yValue = 2
  west = hacRoomO18
  east = hacRoomB2
;
hacRoomB2: HacHallwayWE
  xValue = 2
  yValue = 2
  west = hacRoomA2
  east = hacRoomC2
;
hacRoomC2: HacHallwayWE
  xValue = 3
  yValue = 2
  west = hacRoomB2
  east = hacRoomD2
;
hacRoomD2: HacJunction
  xValue = 4
  yValue = 2
  initiallyHasDotType = oneDot
  south = hacRoomD3
  west = hacRoomC2
  east = hacRoomE2
;
hacRoomE2: HacHallwayWE
  xValue = 5
  yValue = 2
  initiallyHasDotType = twoDots
  west = hacRoomD2
  east = hacRoomF2
;
hacRoomF2: HacHallwayWE
  xValue = 6
  yValue = 2
  initiallyHasDotType = oneDot
  west = hacRoomE2
  east = hacRoomG2
;
hacRoomG2: HacHallwayWE
  xValue = 7
  yValue = 2
  initiallyHasDotType = twoDots
  west = hacRoomF2
  east = hacRoomH2
;
hacRoomH2: HacHallwayWE
  xValue = 8
  yValue = 2
  initiallyHasDotType = oneDot
  west = hacRoomG2
  east = hacRoomI2
;
hacRoomI2: HacHallwayWE
  xValue = 9
  yValue = 2
  initiallyHasDotType = twoDots
  west = hacRoomH2
  east = hacRoomJ2
;
hacRoomJ2: HacJunction
  xValue = 10
  yValue = 2
  initiallyHasDotType = oneDot
  south = hacRoomJ3
  west = hacRoomI2
  east = hacRoomK2
;
hacRoomK2: HacHallwayWE
  xValue = 11
  yValue = 2
  initiallyHasDotType = twoDots
  west = hacRoomJ2
  east = hacRoomL2
;
hacRoomL2: HacHallwayWE
  xValue = 12
  yValue = 2
  initiallyHasDotType = oneDot
  west = hacRoomK2
  east = hacRoomM2
;
hacRoomM2: HacHallwayWE
  xValue = 13
  yValue = 2
  initiallyHasDotType = twoDots
  west = hacRoomL2
  east = hacRoomN2
;
hacRoomN2: HacBend
  xValue = 14
  yValue = 2
  initiallyHasDotType = oneBigDot
  south = hacRoomN3
  west = hacRoomM2
;
hacRoomD3: HacHallwayNS
  xValue = 4
  yValue = 3
  initiallyHasDotType = twoDots
  north = hacRoomD2
  south = hacRoomD4
;
hacRoomJ3: HacHallwayNS
  xValue = 10
  yValue = 3
  initiallyHasDotType = twoDots
  north = hacRoomJ2
  south = hacRoomJ4
;
hacRoomN3: HacHallwayNS
  xValue = 14
  yValue = 3
  initiallyHasDotType = twoDots
  north = hacRoomN2
  south = hacRoomN4
;
hacRoomD4: HacJunction
  xValue = 4
  yValue = 4
  initiallyHasDotType = oneDot
  north = hacRoomD3
  south = hacRoomD5
  east = hacRoomE4
;
hacRoomE4: HacHallwayWE
  xValue = 5
  yValue = 4
  initiallyHasDotType = twoDots
  west = hacRoomD4
  east = hacRoomF4
;
hacRoomF4: HacBend
  xValue = 6
  yValue = 4
  initiallyHasDotType = oneDot
  south = hacRoomF5
  west = hacRoomE4
;
hacRoomH4: HacBend
  xValue = 8
  yValue = 4
  initiallyHasDotType = oneDot
  south = hacRoomH5
  east = hacRoomI4
;
hacRoomI4: HacHallwayWE
  xValue = 9
  yValue = 4
  initiallyHasDotType = twoDots
  west = hacRoomH4
  east = hacRoomJ4
;
hacRoomJ4: HacJunction
  xValue = 10
  yValue = 4
  initiallyHasDotType = oneDot
  north = hacRoomJ3
  south = hacRoomJ5
  west = hacRoomI4
  east = hacRoomK4
;
hacRoomK4: HacHallwayWE
  xValue = 11
  yValue = 4
  initiallyHasDotType = twoDots
  west = hacRoomJ4
  east = hacRoomL4
;
hacRoomL4: HacBend
  xValue = 12
  yValue = 4
  initiallyHasDotType = oneDot
  south = hacRoomL5
  west = hacRoomK4
;
hacRoomN4: HacHallwayNS
  xValue = 14
  yValue = 4
  initiallyHasDotType = oneDot
  north = hacRoomN3
  south = hacRoomN5
;
hacRoomD5: HacHallwayNS
  xValue = 4
  yValue = 5
  initiallyHasDotType = twoDots
  north = hacRoomD4
  south = hacRoomD6
;
hacRoomF5: HacHallwayNS
  xValue = 6
  yValue = 5
  initiallyHasDotType = twoDots
  north = hacRoomF4
  south = hacRoomF6
;
hacRoomH5: HacHallwayNS
  xValue = 8
  yValue = 5
  initiallyHasDotType = twoDots
  north = hacRoomH4
  south = hacRoomH6
;
hacRoomJ5: HacHallwayNS
  xValue = 10
  yValue = 5
  initiallyHasDotType = twoDots
  north = hacRoomJ4
  south = hacRoomJ6
;
hacRoomL5: HacHallwayNS
  xValue = 12
  yValue = 5
  initiallyHasDotType = twoDots
  north = hacRoomL4
  south = hacRoomL6
;
hacRoomN5: HacHallwayNS
  xValue = 14
  yValue = 5
  initiallyHasDotType = twoDots
  north = hacRoomN4
  south = hacRoomN6
;
hacRoomB6: HacBend
  xValue = 2
  yValue = 6
  initiallyHasDotType = oneDot
  south = hacRoomB7
  east = hacRoomC6
;
hacRoomC6: HacHallwayWE
  xValue = 3
  yValue = 6
  initiallyHasDotType = twoDots
  west = hacRoomB6
  east = hacRoomD6
;
hacRoomD6: HacJunction
  xValue = 4
  yValue = 6
  initiallyHasDotType = oneDot
  north = hacRoomD5
  south = hacRoomD7
  west = hacRoomC6
;
hacRoomF6: HacBend
  xValue = 6
  yValue = 6
  initiallyHasDotType = oneDot
  north = hacRoomF5
  east = hacRoomG6
;
hacRoomG6: HacHallwayWE
  xValue = 7
  yValue = 6
  initiallyHasDotType = twoDots
  west = hacRoomF6
  east = hacRoomH6
;
hacRoomH6: HacJunction
  xValue = 8
  yValue = 6
  initiallyHasDotType = oneDot
  north = hacRoomH5
  south = hacRoomH7
  west = hacRoomG6
;
hacRoomJ6: HacHallwayNS
  xValue = 10
  yValue = 6
  initiallyHasDotType = oneDot
  north = hacRoomJ5
  south = hacRoomJ7
;
hacRoomL6: HacBend
  xValue = 12
  yValue = 6
  initiallyHasDotType = oneDot
  north = hacRoomL5
  east = hacRoomM6
;
hacRoomM6: HacHallwayWE
  xValue = 13
  yValue = 6
  initiallyHasDotType = twoDots
  west = hacRoomL6
  east = hacRoomN6
;
hacRoomN6: HacJunction
  xValue = 14
  yValue = 6
  initiallyHasDotType = oneDot
  north = hacRoomN5
  south = hacRoomN7
  west = hacRoomM6
;
hacRoomB7: HacHallwayNS
  xValue = 2
  yValue = 7
  initiallyHasDotType = twoDots
  north = hacRoomB6
  south = hacRoomB8
;
hacRoomD7: HacHallwayNS
  xValue = 4
  yValue = 7
  north = hacRoomD6
  south = hacRoomD8
;
hacRoomH7: HacHallwayNS
  xValue = 8
  yValue = 7
  north = hacRoomH6
  south = hacRoomH8
;
hacRoomJ7: HacHallwayNS
  xValue = 10
  yValue = 7
  north = hacRoomJ6
  south = hacRoomJ8
;
hacRoomN7: HacHallwayNS
  xValue = 14
  yValue = 7
  initiallyHasDotType = twoDots
  north = hacRoomN6
  south = hacRoomN8
;
hacRoomB8: HacHallwayNS
  xValue = 2
  yValue = 8
  initiallyHasDotType = oneDot
  north = hacRoomB7
  south = hacRoomB9
;
hacRoomD8: HacJunction
  xValue = 4
  yValue = 8
  north = hacRoomD7
  south = hacRoomD9
  east = hacRoomE8
;
hacRoomE8: HacHallwayWE
  xValue = 5
  yValue = 8
  west = hacRoomD8
  east = hacRoomF8
;
hacRoomF8: HacHallwayWE
  xValue = 6
  yValue = 8
  west = hacRoomE8
  east = hacRoomG8
;
hacRoomG8: HacHallwayWE
  xValue = 7
  yValue = 8
  west = hacRoomF8
  east = hacRoomH8
;
hacRoomH8: HacJunction
  xValue = 8
  yValue = 8
  north = hacRoomH7
  west = hacRoomG8
  east = hacRoomI8
;
hacRoomI8: HacHallwayWE
  xValue = 9
  yValue = 8
  west = hacRoomH8
  east = hacRoomJ8
;
hacRoomJ8: HacJunction
  xValue = 10
  yValue = 8
  north = hacRoomJ7
  west = hacRoomI8
  east = hacRoomK8
;
hacRoomK8: HacHallwayWE
  xValue = 11
  yValue = 8
  west = hacRoomJ8
  east = hacRoomL8
;
hacRoomL8: HacBend
  xValue = 12
  yValue = 8
  south = hacRoomL9
  west = hacRoomK8
;
hacRoomN8: HacHallwayNS
  xValue = 14
  yValue = 8
  initiallyHasDotType = oneDot
  north = hacRoomN7
  south = hacRoomN9
;
hacRoomB9: HacHallwayNS
  xValue = 2
  yValue = 9
  initiallyHasDotType = twoDots
  north = hacRoomB8
  south = hacRoomB10
;
hacRoomD9: HacHallwayNS
  xValue = 4
  yValue = 9
  north = hacRoomD8
  south = hacRoomD10
;
hacRoomL9: HacHallwayNS
  xValue = 12
  yValue = 9
  north = hacRoomL8
  south = hacRoomL10
;
hacRoomN9: HacHallwayNS
  xValue = 14
  yValue = 9
  initiallyHasDotType = twoDots
  north = hacRoomN8
  south = hacRoomN10
;
hacRoomB10: HacJunction
  xValue = 2
  yValue = 10
  initiallyHasDotType = oneDot
  north = hacRoomB9
  south = hacRoomB11
  east = hacRoomC10
;
hacRoomC10: HacHallwayWE
  xValue = 3
  yValue = 10
  west = hacRoomB10
  east = hacRoomD10
;
hacRoomD10: HacJunction
  xValue = 4
  yValue = 10
  north = hacRoomD9
  south = hacRoomD11
  west = hacRoomC10
;
hacRoomL10: HacJunction
  xValue = 12
  yValue = 10
  north = hacRoomL9
  south = hacRoomL11
  east = hacRoomM10
;
hacRoomM10: HacHallwayWE
  xValue = 13
  yValue = 10
  west = hacRoomL10
  east = hacRoomN10
;
hacRoomN10: HacJunction
  xValue = 14
  yValue = 10
  initiallyHasDotType = oneDot
  north = hacRoomN9
  south = hacRoomN11
  west = hacRoomM10
;
hacRoomB11: HacHallwayNS
  xValue = 2
  yValue = 11
  initiallyHasDotType = twoDots
  north = hacRoomB10
  south = hacRoomB12
;
hacRoomD11: HacHallwayNS
  xValue = 4
  yValue = 11
  north = hacRoomD10
  south = hacRoomD12
;
hacRoomL11: HacHallwayNS
  xValue = 12
  yValue = 11
  north = hacRoomL10
  south = hacRoomL12
;
hacRoomN11: HacHallwayNS
  xValue = 14
  yValue = 11
  initiallyHasDotType = twoDots
  north = hacRoomN10
  south = hacRoomN12
;
hacRoomB12: HacHallwayNS
  xValue = 2
  yValue = 12
  initiallyHasDotType = oneDot
  north = hacRoomB11
  south = hacRoomB13
;
hacRoomD12: HacBend
  xValue = 4
  yValue = 12
  north = hacRoomD11
  east = hacRoomE12
;
hacRoomE12: HacHallwayWE
  xValue = 5
  yValue = 12
  west = hacRoomD12
  east = hacRoomF12
;
hacRoomF12: HacJunction
  xValue = 6
  yValue = 12
  south = hacRoomF13
  west = hacRoomE12
  east = hacRoomG12
;
hacRoomG12: HacHallwayWE
  xValue = 7
  yValue = 12
  west = hacRoomF12
  east = hacRoomH12
;
hacRoomH12: HacJunction
  xValue = 8
  yValue = 12
  south = hacRoomH13
  west = hacRoomG12
  east = hacRoomI12
;
hacRoomI12: HacHallwayWE
  xValue = 9
  yValue = 12
  west = hacRoomH12
  east = hacRoomJ12
;
hacRoomJ12: HacHallwayWE
  xValue = 10
  yValue = 12
  west = hacRoomI12
  east = hacRoomK12
;
hacRoomK12: HacHallwayWE
  xValue = 11
  yValue = 12
  west = hacRoomJ12
  east = hacRoomL12
;
hacRoomL12: HacJunction
  xValue = 12
  yValue = 12
  north = hacRoomL11
  south = hacRoomL13
  west = hacRoomK12
;
hacRoomN12: HacHallwayNS
  xValue = 14
  yValue = 12
  initiallyHasDotType = oneDot
  north = hacRoomN11
  south = hacRoomN13
;
hacRoomB13: HacHallwayNS
  xValue = 2
  yValue = 13
  initiallyHasDotType = twoDots
  north = hacRoomB12
  south = hacRoomB14
;
hacRoomF13: HacHallwayNS
  xValue = 6
  yValue = 13
  north = hacRoomF12
  south = hacRoomF14
;
hacRoomH13: HacHallwayNS
  xValue = 8
  yValue = 13
  north = hacRoomH12
  south = hacRoomH14
;
hacRoomL13: HacHallwayNS
  xValue = 12
  yValue = 13
  north = hacRoomL12
  south = hacRoomL14
;
hacRoomN13: HacHallwayNS
  xValue = 14
  yValue = 13
  initiallyHasDotType = twoDots
  north = hacRoomN12
  south = hacRoomN14
;
hacRoomB14: HacJunction
  xValue = 2
  yValue = 14
  initiallyHasDotType = oneDot
  north = hacRoomB13
  south = hacRoomB15
  east = hacRoomC14
;
hacRoomC14: HacHallwayWE
  xValue = 3
  yValue = 14
  initiallyHasDotType = twoDots
  west = hacRoomB14
  east = hacRoomD14
;
hacRoomD14: HacBend
  xValue = 4
  yValue = 14
  initiallyHasDotType = oneDot
  south = hacRoomD15
  west = hacRoomC14
;
hacRoomF14: HacHallwayNS
  xValue = 6
  yValue = 14
  initiallyHasDotType = oneDot
  north = hacRoomF13
  south = hacRoomF15
;
hacRoomH14: HacJunction
  xValue = 8
  yValue = 14
  initiallyHasDotType = oneDot
  north = hacRoomH13
  south = hacRoomH15
  east = hacRoomI14
;
hacRoomI14: HacHallwayWE
  xValue = 9
  yValue = 14
  initiallyHasDotType = twoDots
  west = hacRoomH14
  east = hacRoomJ14
;
hacRoomJ14: HacBend
  xValue = 10
  yValue = 14
  initiallyHasDotType = oneDot
  south = hacRoomJ15
  west = hacRoomI14
;
hacRoomL14: HacJunction
  xValue = 12
  yValue = 14
  initiallyHasDotType = oneDot
  north = hacRoomL13
  south = hacRoomL15
  east = hacRoomM14
;
hacRoomM14: HacHallwayWE
  xValue = 13
  yValue = 14
  initiallyHasDotType = twoDots
  west = hacRoomL14
  east = hacRoomN14
;
hacRoomN14: HacBend
  xValue = 14
  yValue = 14
  initiallyHasDotType = oneDot
  north = hacRoomN13
  west = hacRoomM14
;
hacRoomB15: HacHallwayNS
  xValue = 2
  yValue = 15
  initiallyHasDotType = twoDots
  north = hacRoomB14
  south = hacRoomB16
;
hacRoomD15: HacHallwayNS
  xValue = 4
  yValue = 15
  initiallyHasDotType = twoDots
  north = hacRoomD14
  south = hacRoomD16
;
hacRoomF15: HacHallwayNS
  xValue = 6
  yValue = 15
  initiallyHasDotType = twoDots
  north = hacRoomF14
  south = hacRoomF16
;
hacRoomH15: HacHallwayNS
  xValue = 8
  yValue = 15
  initiallyHasDotType = twoDots
  north = hacRoomH14
  south = hacRoomH16
;
hacRoomJ15: HacHallwayNS
  xValue = 10
  yValue = 15
  initiallyHasDotType = twoDots
  north = hacRoomJ14
  south = hacRoomJ16
;
hacRoomL15: HacHallwayNS
  xValue = 12
  yValue = 15
  initiallyHasDotType = twoDots
  north = hacRoomL14
  south = hacRoomL16
;
hacRoomB16: HacHallwayNS
  xValue = 2
  yValue = 16
  initiallyHasDotType = oneDot
  north = hacRoomB15
  south = hacRoomB17
;
hacRoomD16: HacBend
  xValue = 4
  yValue = 16
  initiallyHasDotType = oneDot
  north = hacRoomD15
  east = hacRoomE16
;
hacRoomE16: HacHallwayWE
  xValue = 5
  yValue = 16
  initiallyHasDotType = twoDots
  west = hacRoomD16
  east = hacRoomF16
;
hacRoomF16: HacJunction
  xValue = 6
  yValue = 16
  initiallyHasDotType = oneDot
  north = hacRoomF15
  south = hacRoomF17
  west = hacRoomE16
  east = hacRoomG16
;
hacRoomG16: HacHallwayWE
  xValue = 7
  yValue = 16
  initiallyHasDotType = twoDots
  west = hacRoomF16
  east = hacRoomH16
;
hacRoomH16: HacBend
  xValue = 8
  yValue = 16
  initiallyHasDotType = oneDot
  north = hacRoomH15
  west = hacRoomG16
;
hacRoomJ16: HacBend
  xValue = 10
  yValue = 16
  initiallyHasDotType = oneDot
  north = hacRoomJ15
  east = hacRoomK16
;
hacRoomK16: HacHallwayWE
  xValue = 11
  yValue = 16
  initiallyHasDotType = twoDots
  west = hacRoomJ16
  east = hacRoomL16
;
hacRoomL16: HacJunction
  xValue = 12
  yValue = 16
  initiallyHasDotType = oneDot
  north = hacRoomL15
  south = hacRoomL17
  west = hacRoomK16
;
hacRoomB17: HacHallwayNS
  xValue = 2
  yValue = 17
  initiallyHasDotType = twoDots
  north = hacRoomB16
  south = hacRoomB18
;
hacRoomF17: HacHallwayNS
  xValue = 6
  yValue = 17
  initiallyHasDotType = twoDots
  north = hacRoomF16
  south = hacRoomF18
;
hacRoomL17: HacHallwayNS
  xValue = 12
  yValue = 17
  initiallyHasDotType = twoDots
  north = hacRoomL16
  south = hacRoomL18
;
hacRoomB18: HacBend
  xValue = 2
  yValue = 18
  initiallyHasDotType = oneBigDot
  north = hacRoomB17
  east = hacRoomC18
;
hacRoomC18: HacHallwayWE
  xValue = 3
  yValue = 18
  initiallyHasDotType = twoDots
  west = hacRoomB18
  east = hacRoomD18
;
hacRoomD18: HacHallwayWE
  xValue = 4
  yValue = 18
  initiallyHasDotType = oneDot
  west = hacRoomC18
  east = hacRoomE18
;
hacRoomE18: HacHallwayWE
  xValue = 5
  yValue = 18
  initiallyHasDotType = twoDots
  west = hacRoomD18
  east = hacRoomF18
;
hacRoomF18: HacJunction
  xValue = 6
  yValue = 18
  initiallyHasDotType = oneDot
  north = hacRoomF17
  west = hacRoomE18
  east = hacRoomG18
;
hacRoomG18: HacHallwayWE
  xValue = 7
  yValue = 18
  initiallyHasDotType = twoDots
  west = hacRoomF18
  east = hacRoomH18
;
hacRoomH18: HacHallwayWE
  xValue = 8
  yValue = 18
  initiallyHasDotType = oneDot
  west = hacRoomG18
  east = hacRoomI18
;
hacRoomI18: HacHallwayWE
  xValue = 9
  yValue = 18
  initiallyHasDotType = nil
  // Note to self: The following comments seem misleading to me as I read this now.
  //initiallyHasDotType = twoDots // Dots removed because Adam is there. Also, I'd have to change the value of the power pellets if there were dots here.
  west = hacRoomH18
  east = hacRoomJ18
;
hacRoomJ18: HacHallwayWE
  xValue = 10
  yValue = 18
  initiallyHasDotType = oneDot
  west = hacRoomI18
  east = hacRoomK18
;
hacRoomK18: HacHallwayWE
  xValue = 11
  yValue = 18
  initiallyHasDotType = twoDots
  west = hacRoomJ18
  east = hacRoomL18
;
hacRoomL18: HacJunction
  xValue = 12
  yValue = 18
  initiallyHasDotType = oneDot
  north = hacRoomL17
  west = hacRoomK18
  east = hacRoomM18
;
hacRoomM18: HacHallwayWE
  xValue = 13
  yValue = 18
  west = hacRoomL18
  east = hacRoomN18
;
hacRoomN18: HacHallwayWE
  xValue = 14
  yValue = 18
  west = hacRoomM18
  east = hacRoomO18
;
hacRoomO18: HacHallwayWE
  xValue = 15
  yValue = 18
  west = hacRoomN18
  east = hacRoomA2
;


// -------------------------------------------------------------------
// HAC-MAN MAZE: ROOM STUFF: ROOMS: ROOMS NEAR PINK GATE
// -------------------------------------------------------------------

modify hacRoomH8
  desc = "This is a junction of two hallways. One hallway leads 
    east and west, while the other leads north. On the south wall
    there is a gate of sparkling pink light. "
  south = pinkGate
;

pinkGate: ThroughPassage, StopEventList
  'sparkling pink gate/portal' 'pink gate'
  "The gate sparkles and shines with pink light. "
  //desc {
  //  "The gate sparkles and crackles, as if with static electricity, 
  //    and shines radiantly with pink light. <.p>";
  //  if (curScriptState == 1)
  //    "<<botname>> retorts, <.q>It might look cool, but something 
  //      about it gives me the willies!<./q> ";
  //  else
  //    "<<botname>> retorts, <.q>My circuits are aching just looking
  //      at that thing!<./q> ";
  //}
  location = hacRoomH8
  //room1 = hacRoomH8
  //room2 = hacRoomH9
  //destination = hacRoomH9
  canTravelerPass(traveler) {
    if (traveler.isActor && traveler != gPlayerChar) return true;
    else return nil;
  }
  explainTravelBarrier(traveler) {
    doScript();
  }
  // No need to make this an agonizing experience, I guess
  eventList = [
    'Your bot boldly steps into the pink gate, but a flash of light
      erupts all around her, and she is thrown back 
      in a shower of sparks. '
    //'Your bot boldly steps into the pink gate, but a flash of light
    //  erupts all around her, and she is thrown back 
    //  in a shower of sparks. \b
    //  <.q>Yee-oww!<./q> shrieks ' + botname + '. <.q>Don<./s>t you ever make me
    //  do that again!<./q> ',
    //'<.q>Oh no!<./q> ' + botname + ' protests. <.q>I got enough agonizing pain
    //  the first time. You<./s>ll never see me go that way again!<./q> '
  ]
;

pinkGate2: ThroughPassage
  location = hacRoomH9
  masterObject = pinkGate
;

//distantPinkGate: MultiLoc, Distant
//  locationList = 
//;

hacRoomH9: HacRoom
  roomName = 'Illegal room to be in'
  desc = "You're not supposed to be in this room. How'd you get here? 
    However, as long as you're here, you can go north or south."
  north = pinkGate2
  south = hacRoomH10
  xValue = 8
  yValue = 9
  // Because of the new modifications to HacRoom.giveFilename,
  // this room need not override that method anymore.
  //giveFilename() {
  //  // UNIVERSALIZE (finished)
  //  // First check for inhabitants...
  //  if (gPlayerChar.location == self) {
  //    switch (gPlayerChar.dirFacing) {
  //      case northValue: return 'hacmanN';
  //      case southValue: return 'hacmanS';
  //      case eastValue:  return 'hacmanE';
  //      case westValue:  return 'hacmanW';
  //    }
  //  }
  //  if (adam.realLocation == self) return 'adam2';
  //  if (bandit.realLocation == self) return 'bandit2';
  //  if (dragon.realLocation == self) return 'dragon2';
  //  if (copyman.realLocation == self) return 'copyman2';
  //  if (death.location == self) return 'death';
  //  // If there are no inhabitants, then...
  //  if (hasDotType == nil) return 'gate';
  //  if (hasDotType == oneDot) return 'dot';
  //  if (hasDotType == twoDots) return twoDotFilename;
  //  if (hasDotType == oneBigDot) {
  //    if (glob.thornton) return 'beer';
  //    else return 'pellet';
  //  }
  //  return 'nil';
  //}
;

hacRoomH10: HacRoom
  roomName = 'Illegal room to be in'
  desc = "You're not supposed to be in this room. How'd you get here? 
    However, as long as you're here, you can go north. "
  north = hacRoomH9
  xValue = 8
  yValue = 10
;


// -------------------------------------------------------------------
// HAC-MAN MAZE: GENERAL STUFF: MISCELLANEOUS
// -------------------------------------------------------------------

enum northValue, southValue, westValue, eastValue;
enum hacHallway, hacJunction, hacBend;
enum oneDot, twoDots, oneBigDot;

modify glob
  hacEnemySequence {
    if (adamThorntonM.isInExe)
      return [dragon, copyman, troll, bat, balrog];
    else
      return [naga, balrog, dragon];
  }
  // If we don't specify the first enemy somewhere, it'll be hard
  // to know where to start.
  firstHacEnemy = (hacEnemySequence[1])
  // After the first enemy appears, this value becomes 1.
  // After the second enemy, it becomes 2. Etc.
  hacEnemyCount = 0
;

modify glob
  dotsEaten = 0
  bigDotsEaten = 0
  totalHacScore() { return dotsEaten + (bigDotsEaten * glob.bigDotValue); }
;

modify Actor
  isDead = nil
  //dotsEaten = 0
  //bigDotsEaten = 0
  chompCount = 0
  dirFacing = eastValue
  currentRoom = location // this is only the initial value
  previousRoom = nil
;

function invokeHac() {
//  if (glob.hacInvoked == nil) {
    chompDaemon.startDaemon;
    glob.hacInvoked = true;
    glob.firstHacEnemy.activateNpc;
    //local k=0; k=k/k;
    if (adamThorntonM.isInExe) {
      adam.activateNpc;
      hacRoomI18.hasDotType = nil;
      hacRoomI18.initiallyHasDotType = nil;
    }
    else {
      hacRoomI18.hasDotType = twoDots;
      hacRoomI18.initiallyHasDotType = twoDots;
    }
    //dragon.addToAgenda(dragonWaitToAppear);
    //dragon.addToAgenda(dragonExitBox);
    //dragon.addToAgenda(dragonRunAway);
    //dragon.addToAgenda(dragonVsThornton);
    //dragon.addToAgenda(dragonChasingYou);
//  }
}
modify glob
  eenieMeenie = 1
  //hacCount = 0
  hacInvoked = nil
  // How long NPCs remain transformed when you eat a pellet.
  maxPowerCount = 22
  // How long NPCs remain white during that transformation.
  whiteLength = 3
;
eenieVector(vec) {
  if (!vec.ofKind(Vector)) {
    "ERROR: Non-vector called to eenieVector! ";
    return 0;
  }
  return vec[(((glob.eenieMeenie - 1) % vec.length()) + 1)];
  //return vec[(((libGlobal.totalTurns - 1) % vec.length()) + 1)];
}

// the function pleaseSay will output text regardless of sense context.
pleaseSay(txt) {
  callWithSenseContext(nil, nil, new function { say(txt); } );
}

// This object's only purpose is to make sure the following
// vocab words are never absent from the dictionary.
bogusThing: Thing
  'red white blue dragon duck troll turtle dove balrog demon daemon
    bandit bat me giant frog albino bull bullfrog butterfly copyman copyright man
    morpho menelaus pieris brassicae
    chicken white white-winged'
  'bogus thing'
;




// -------------------------------------------------------------------
// HAC-MAN MAZE: GENERAL STUFF: CHOMPING
// -------------------------------------------------------------------

modify glob
  bigDotValue = (adamThorntonM.isInExe ? 7 : 6)
;

function chomp(dotType) {
  //"chomp function: ";
  if (dotType == nil) return;
  //"chomp dotType is non-nil: ";
  if (dotType != oneDot && dotType != twoDots && dotType != oneBigDot) {
    "ERROR: Unanticipated value for this location<./s>s hasDotType property! ";
    return;
  }
  // Now dotType must be either oneDot, twoDots, or oneBigDot.
  // It's chomp time.
  //inputManager.pauseForMore(nil);
  "<.p>";
  gActor.chompCount++;
  switch (gActor.chompCount) {
    case 1:
      "Suddenly, Sheila<./s>s eyes gleam, and she goes 
          into a frenzy! She charges at the 
          <<dotName(dotType, nil)>> and gobbles 
          <<itDot(dotType)>> down in a 
          flash. 
        <p>Then Sheila scratches her head, as if wondering 
          why she did that. ";
      break;
    case 2:
      "Once again Sheila goes wild when she sees
          the <<dotName(dotType, nil)>>. With sudden fury, 
          she charges at the <<dotName(dotType, true)>>
          and swallows <<itDot(dotType)>> 
          in a single gulp.
        <p><.q>This is rather unnerving,<./q> says Sheila. "; 
      break;
    case 3:
      "Yielding again to the uncontrollable impulse,
          Sheila charges at the <<dotName(dotType, nil)>>
          and swallows <<itDot(dotType)>>
          whole.
        <p><.q>Is this my fate? To be a compulsive overeater?<./q>
          Sheila asks. ";
      break;
    case 4:
      "Shiela charges at the <<dotName(dotType, nil)>>
          and gobbles <<itDot(dotType)>> 
          down in a flash. 
        <p>Sheila shakes her head, but shrugs, seemingly
          resigned to her fate. ";
      break;
    //case 5:
    //  " ";
    //  break;
    default:
      "Sheila ";
      say(rand(
         'charges at'
        ,'wheels over to'
        ,'speeds over to'
      ));
      " the <<dotName(dotType, nil)>> and ";
      if (dotType != oneBigDot) {
        say(rand(
           'devours ' + itDot(dotType) + ' in a single gulp. '
          ,'gobbles ' + itDot(dotType) + ' down in a flash. '
          ,'swallows ' + itDot(dotType) + ' whole. '
        ));
      }
      else {
        "drinks it down in a flash. ";
      }
      break;
  }
  switch (dotType) {
    //local adversary = nil;
    case oneDot:
      glob.dotsEaten++;
      addToScore(1, 'eating a dot');
      break;
    case twoDots:
      glob.dotsEaten = glob.dotsEaten + 2;
      addToScore(2, 'eating two dots');
      break;
    case oneBigDot:
      glob.bigDotsEaten++;
      gActor.isPowered = true;
      //gActor.powerCount = 1;
      // UNIVERSALIZE (finished)
      for (local a = 1; a <= glob.hacEnemies.length; a++) {
        if (glob.hacEnemies[a].location != nil)
          glob.hacEnemies[a].transformNpc;
      }
      //if (dragon.location != nil)
      //  dragon.transformNpc;
      //if (copyman.location != nil)
      //  copyman.transformNpc;
      //if (adamThorntonM.isInExe)
      //  addToScore(7, 'eating a big dot');
      //else
      //  addToScore(6, 'eating a big dot');
      addToScore(glob.bigDotValue, 'eating a big dot');
      break;
  }
  gPlayerChar.location.hasDotType = nil;
  // The following is just for debugging, to see what happens:
  //if (libScore.totalScore >= 10) {
  //  scoreNotifier.checkNotification();
  //  "<.p>And, with that... YOU'VE WON THE GAME! ";
  //  endGame(ftVictory);
  //}
  //return;
}
modify bot
  isPowered = nil
  powerCount = 0
;

function dotName(dotType, secondInstance) {
  switch (dotType) {
    case oneDot: return 'dot';
    case twoDots: return 'dots';
    case oneBigDot: 
      if (!secondInstance)
        return 'potion of polymorph monster';
      else
        return 'potion';
    default: return 'ERROR';
  }
}
function aDotName(dotType) {
  switch (dotType) {
    case oneDot: return 'a dot';
    case twoDots: return 'two dots';
    case oneBigDot: return 'a potion of polymorph monster';
    default: return 'ERROR';
  }
}
function itDot(dotType) {
  if (dotType == twoDots)
    return 'them';
  else
    return 'it';
}

modify HacRoom
  roomAfterAction {
    //local npcList;
    if (gActor == gPlayerChar) {
      // UNIVERSALIZE (finished)
      //npcList = [dragon, copyman, adam, bandit];
      for (local a = 1; a <= glob.hacNpcs.length; a++) {
        if (glob.hacNpcs[a].currentRoom != glob.hacNpcs[a].location) {
          glob.hacNpcs[a].previousRoom = glob.hacNpcs[a].currentRoom;
          glob.hacNpcs[a].currentRoom = glob.hacNpcs[a].location;
        }
      }
      //for (local a=1; a<=4; ++a) {
      //  if (npcList[a].currentRoom != npcList[a].location) {
      //    npcList[a].previousRoom = npcList[a].currentRoom;
      //    npcList[a].currentRoom = npcList[a].location;
      //  }
      //}
//      // At this point, Sheila may have entered into a new room but has not
//      // yet eaten the dots there. Now is the time to see if there are any
//      // hostile NPCs in the room, and, if so, confront them.
//      for (local a=1; a<=2; ++a) {
//        if (npcList[a].realLocation == gPlayerChar.location) {
//          if (npcList[a].isTransformed) {
//            "<.p>Your bot kills <<npcList[a].theName>>! ";
//            npcList[a].isDead = true;
//            npcList[a].moveInto(nil);
//            npcList[a].location = nil;
//            npcList[a].realLocation = nil;
//            npcList[a].agendaList = [];
//          }
//          else {
//            "<.p>\^<<npcList[a].theName>> kills your bot! ";
//            gPlayerChar.isDead = true;
//            endGame(ftDeath);
//          }
//        }
//      }
      
      
      
      chomp(gPlayerChar.location.hasDotType);
      //if (glob.eenieMeenie == 12) {
      //  glob.eenieMeenie = 1;
      //  "<.p>glob.eenieMeenie = <<glob.eenieMeenie>>; ";
      //}
      //else {
      //  glob.eenieMeenie++;
      //  "<.p>glob.eenieMeenie = <<glob.eenieMeenie>>; ";
      //}
      //glob.hacCount++;
      if (bot.powerCount == glob.maxPowerCount) {
        bot.isPowered = nil;
        bot.powerCount = 0;
        // UNIVERSALIZE (finished)
        for (local a = 1; a <= glob.hacEnemies.length; a++) {
          if (glob.hacEnemies[a].location && glob.hacEnemies[a].isTransformed)
            glob.hacEnemies[a].untransformNpc;
        }
        //if (dragon.location && dragon.isTransformed) {
        //  dragon.untransformNpc;
        //}
        //if (copyman.location && copyman.isTransformed) {
        //  copyman.untransformNpc;
        //}
      }
      else if (bot.isPowered) {
        bot.powerCount++;
        if (glob.maxPowerCount - bot.powerCount == glob.whiteLength - 1) {
          // UNIVERSALIZE (finished)
          for (local a = 1; a <= glob.hacEnemies.length; a++) {
            if (glob.hacEnemies[a].location && glob.hacEnemies[a].isTransformed)
              glob.hacEnemies[a].transformNpcToWhite;
          }
          //if (dragon.location && dragon.isTransformed) {
          //  dragon.transformNpcToWhite;
          //}
          //if (copyman.location && copyman.isTransformed) {
          //  copyman.transformNpcToWhite;
          //}
        }
      }
      //"<.p>totalHacScore == <<glob.totalHacScore>> ";
      if (glob.totalHacScore >= 150 || libScore.totalScore - glob.scoreUponEnteringHac >= 150) {
        finishHac();
      }
      
      //#ifdef __DEBUG
      //  if (glob.totalHacScore != libScore.totalScore - glob.scoreUponEnteringHac)
      //    pleaseSay('<font color=red>glob.totalHacScore != libScore.totalScore - glob.scoreUponEnteringHac!</font> ');
      //#endif // __DEBUG
  
      
      //if (
      /*
      for(local cur=firstObj(BasicDot); cur != nil; cur=nextObj(cur, BasicDot)) {
        if (cur.isIn(gActor.location)) {
          cur.moveInto(nil);
          devoured++;
          if (cur.ofKind(BigDot)) {
            powered++;
          }
        }
      }
      if (powered) {
        if (devoured != 1) {
          "ERROR: Somehow I ate a big huge dot this turn, but also ate a number of dots not equal to 1. Is that possible? ";
          return;
        }
        "<<BotName>> is seized by an uncontrollable urge to eat the gigantic huge power pellet. There it goes. Chomp! <.p>
          Boy, is he powerful now. Holy schnikeys! "; glob.dotsEaten++; return;
      }
      switch (devoured) {
        case 0: //"I tried to devour dots, but no dice! ";
                return;
        case 1: "<<BotName>> is seized by an uncontrollable urge to eat the dot. There it goes. Chomp! "; glob.dotsEaten++; return;
        case 2: "<<BotName>> is seized by an uncontrollable urge to eat the two dots. There they go. Chomp! "; glob.dotsEaten=glob.dotsEaten+2; return;
        default: "ERROR: Can it be, more than two dots eaten at once! "; return;
      }
      */
    }
  }
;

// -------------------------------------------------------------------
// HAC-MAN MAZE: GENERAL STUFF: CHOMPDAEMON
// -------------------------------------------------------------------

chompDaemon: DaemonComponent
  //location = me
  daemonID = nil
  startDaemon {
    if (daemonID == nil) {
      moveInto(gPlayerChar);
      daemonID = new Daemon(self, &daemon, 1);
    }
    // Otherwise, if the daemon is already running, let it continue.
  }
  daemon {
//    local npcList;
//    if (gActor == gPlayerChar) {
//      // UNIVERSALIZE (moot because commented out)
//      //npcList = [dragon, copyman, adam, bandit];
//      for (local a = 1; a <= glob.hacNpcs.length; a++) {
//        if (glob.hacNpcs[a].currentRoom != glob.hacNpcs[a].location) {
//          glob.hacNpcs[a].previousRoom = glob.hacNpcs[a].currentRoom;
//          glob.hacNpcs[a].currentRoom = glob.hacNpcs[a].location;
//        }
//      }
//      
//      
//      
//      chomp(gPlayerChar.location.hasDotType);
//      //if (glob.eenieMeenie == 12) {
//      //  glob.eenieMeenie = 1;
//      //  "<.p>glob.eenieMeenie = <<glob.eenieMeenie>>; ";
//      //}
//      //else {
//      //  glob.eenieMeenie++;
//      //  "<.p>glob.eenieMeenie = <<glob.eenieMeenie>>; ";
//      //}
//      //glob.hacCount++;
//      if (bot.powerCount == glob.maxPowerCount) {
//        bot.isPowered = nil;
//        bot.powerCount = 0;
//        // UNIVERSALIZE (moot because commented out)
//        if (dragon.location && dragon.isTransformed) {
//          dragon.untransformNpc;
//        }
//        if (copyman.location && copyman.isTransformed) {
//          copyman.untransformNpc;
//        }
//      }
//      else if (bot.isPowered) {
//        bot.powerCount++;
//        if (glob.maxPowerCount - bot.powerCount == 2) {
//          // UNIVERSALIZE (moot because commented out)
//          if (dragon.location && dragon.isTransformed) {
//            dragon.transformNpcToWhite;
//          }
//          if (copyman.location && copyman.isTransformed) {
//            copyman.transformNpcToWhite;
//          }
//        }
//      }
//  
//      
//      //if (
//      /*
//      for(local cur=firstObj(BasicDot); cur != nil; cur=nextObj(cur, BasicDot)) {
//        if (cur.isIn(gActor.location)) {
//          cur.moveInto(nil);
//          devoured++;
//          if (cur.ofKind(BigDot)) {
//            powered++;
//          }
//        }
//      }
//      if (powered) {
//        if (devoured != 1) {
//          "ERROR: Somehow I ate a big huge dot this turn, but also ate a number of dots not equal to 1. Is that possible? ";
//          return;
//        }
//        "<<BotName>> is seized by an uncontrollable urge to eat the gigantic huge power pellet. There it goes. Chomp! <.p>
//          Boy, is he powerful now. Holy schnikeys! "; glob.dotsEaten++; return;
//      }
//      switch (devoured) {
//        case 0: //"I tried to devour dots, but no dice! ";
//                return;
//        case 1: "<<BotName>> is seized by an uncontrollable urge to eat the dot. There it goes. Chomp! "; glob.dotsEaten++; return;
//        case 2: "<<BotName>> is seized by an uncontrollable urge to eat the two dots. There they go. Chomp! "; glob.dotsEaten=glob.dotsEaten+2; return;
//        default: "ERROR: Can it be, more than two dots eaten at once! "; return;
//      }
//      */
//    }
    
    
    
    
//    if (!systemInfo(SysInfoOsName).toLower.startsWith('win') 
//        && !glob.hypertadsNotificationGiven) {
//      "<.p>[Note: You seem to be playing this game with a non-Windows 
//          interpreter. You have reached a point in the game
//          where non-Windows interpreters have not proven their
//          ability to give good performance (as of 2009, 
//          when this game was tested). If the graphics in this
//          part of the game are intolerably slow or are not displayed
//          at all, you will have difficulties.]
//        <p>[If the graphics here are a problem for you and you want 
//          to skip past this part of the game, you may type 
//          SPARE ME.] ";
//      glob.hypertadsNotificationGiven = true;
//    }
    
    
    
    //pleaseSay('<.p><font color=red>chompDaemon!</font><.p>');
    if (gPlayerChar.isIn(dreamRoom) && endgameDaemon.daemonID == nil) {
      endgameDaemon.startDaemon;
    }
    
    //pleaseSay('<.p>Chomp daemon!<.p>');
    //"Chomp Daemon: ";
    //local devoured = 0, powered = 0;
    if (!gPlayerChar.location.ofKind(HacRoom)) {
      endDaemon();
      return;
    }
    bot.turnsDuringHac++;
    
    // If the bot gets any hit points deducted, she'll need a chance
    // to heal. Other characters may not need a chance to heal, but
    // provide a hook for this to happen in case I change my mind
    // later.
    for (local a = 1; a <= glob.hacChars.length; a++) {
      //if (glob.hacChars[a] == bot) {
      //  pleaseSay('<.p>bot.healCount == ' + bot.healCount + '<.p>');
      //}
      if (glob.hacChars[a].healCount == glob.hacChars[a].healTime) {
        glob.hacChars[a].doHealing;
        glob.hacChars[a].healCount = 0;
      }
      glob.hacChars[a].healCount++;
    }
    // If applicable, let the copyright man decide if he wants to gripe.
    if (copyman.realLocation && copyman.realLocation.ofKind(HacRoom)
        && !copyman.isTransformed) {
      copyman.gripeDaemon;
    }
    // In the case of this maze, the banner must be updated every 
    // turn, because NPC movement changes how it should look.
    nbmBanner.updateMe();
    
  }
  endDaemon {
    if (daemonID != nil) daemonID.removeEvent;
    daemonID = nil;
    moveInto(nil);
  }
;

modify glob
  hypertadsNotificationGiven = nil
;

// -------------------------------------------------------------------
// HAC-MAN MAZE: GENERAL STUFF: Victory, Sheila's final speech, etc.
// -------------------------------------------------------------------

letSheilaGiveFinalSpeech(onlyTesting, dirStr) {
  local doFinalParagraph = nil;
  // PART 1: Sheila prepares to speak.
  if (!onlyTesting) {
    "Sheila looks off to the <<dirStr>>. But before she heads
        off that way, she lifts her head upwards
        and begins to speak. ";
    // In case Sheila just turned to face in a new direction,
    // we might as well update the banner to show that.
    nbmBanner.updateMe();
    nbmPause();
    nbmCls();
  }
  // PART 2A: Sheila's speech, first paragraph, beginning
  "<.q>Well, it looks like our time together is at
      an end,<./q> she says. <.q>It<./s>s been fun,
      but this is where the game wraps up.
      But before I make this last move, I just wanted
      to say it<./s>s been fun playing with you,
      <<me.knownByBot ? me.firstName 
      : 'whoever you are'>>. ";
  // PART 2B: Sheila's speech, first paragraph, conclusion
  if (bcTellYou.hasReportedCryogenics 
      || bcTellEarth.hasBeenSelected) {
    "It was great hearing you tell your amazing stories
        about ";
    if (bcTellYou.hasReportedCryogenics
        && bcTellEarth.hasBeenSelected)
      "cryogenics and nuclear war and stuff. ";
    else if (bcTellYou.hasReportedCryogenics)
      "cryogenics and stuff. ";
    else
      "nuclear war and stuff. ";
  }
  else if (bcTellMazes.hasBeenSelected 
      || bcTellHumans.hasBeenSelected 
      || bcTellIf.hasBeenSelected) {
    if (bcTellMazes.hasBeenSelected) {
      if (!bcTellHumans.hasBeenSelected 
          && !bcTellIf.hasBeenSelected) {
        "I can<./s>t believe you don<./s>t like mazes, 
            but hey, to each his own. ";
      }
      else {
        "I was shocked to hear you don<./s>t like mazes, 
            and ";
        // No need to adjust doFinalParagraph here.
        // In fact, that would screw things up.
      }
    }
    if (bcTellHumans.hasBeenSelected 
        || bcTellIf.hasBeenSelected) {
      // Sheila won't be "a little surprised" to hear you
      // express sympathy for humans if she knows 
      // you're a human.
      if (!me.knownByBot)
        "I was a little surprised to hear you express
            sympathy for ";
      else
        "<<bcTellMazes.hasBeenSelected ? '' : '\^'>>it 
            was a new experience to hear someone express
            sympathy for ";
      if (bcTellHumans.hasBeenSelected
          && bcTellIf.hasBeenSelected)
        "humans and their interactive fiction. ";
      else if (bcTellIf.hasBeenSelected)
        "human interactive fiction. ";
      else
        "humans. ";
      if (!me.knownByBot) {
        "If I didn<./s>t know better, I<./s>d think
            you might be a human yourself! ";
        "But anyway, ";
        // No need to adjust doFinalParagraph here.
        // In fact, that would screw things up.
      }
      else {
        "Anyway, ";
      }
    }
    else {
      "Anyway, ";
    }
    "I certainly enjoyed chatting with you. ";
  }
  else {
    "I can tell you were really playing to win,
        not like Ovan, who just uses me for 
        alpha-testing. ";
  }
  // PART 3: Sheila's speech, second potential paragraph
  if (bcTellProfs.hasBeenSelected) {
    "<p><.q>Also, I<./s>ll certainly have to think about
        what you said about Neton and Ovan.
        I don<./s>t know if they<./s>re really
        imprisoning people unjustly, 
        but if they are, I<./s>d like to find out.
        And if so--well, I don<./s>t know what 
        I<./s>ll do. But I<./s>ll do something. ";
    doFinalParagraph = true;
  }
  // PART 4: Sheila's speech, third potential paragraph
  if (bcObey.hasBeenSelected) {
    "<p><.q>Oh, by the way, I still remember
        how you said I can decide things for myself, 
        that I don<./s>t always 
        have to do what people say. 
        That<./s>s a crazy idea, but an interesting one.
        I<./s>ll have to think about that. ";
    doFinalParagraph = true;
  }
  // PART 5: Sheila's speech, last sentence (perhaps 
  // a new paragraph, perhaps not)
  if (doFinalParagraph)
    "<p><.q>But anyway, enough talk. Let<./s>s
        get out of here!<./q> ";
  else
    "So thanks for the 
        fun<<me.knownByBot ? ', ' + me.firstName : ''>>,
        and I wish you well!<./q> ";
  // PART 6: One last sentence about what Sheila does
  // after making her speech
  if (!onlyTesting) {
    nbmPause();
    nbmCls();
    "<p>And then Sheila heads off to the <<dirStr>>. ";
  }
}

finishHac() {
  //local k=0; k=k/k;
  // ------------------------------
  // Preliminaries
  scoreNotifier.checkNotification;
  nbmBanner.updateMe;
  statusLine.showStatusLineDaemon();
  nbmPause();
  nbmCls();
  
  // ------------------------------
  // Deactivate NPCs
  // 
  // If we don't deactivate all the Hac-Man NPCs, we will get 
  // weird bugs. For example, the dragon/copyman will continue 
  // to try to chase the player character, and since this
  // is impossible (the PC will at that point be Gary, awake
  // in the dream room), it will cause run-time errors.
  for (local cur = firstObj(HacNpc); cur != nil; 
       cur = nextObj(cur,HacNpc)) {
    cur.deactivateNpc;
  }
  
  // ------------------------------
  // Initial "finish Net-Hac-Man" sequence: offered *immediately*
  // after eating the last dot.
  //"<.p>";
  "And with that, to Sheila<./s>s amazement, 
      the surrounding walls begin to glow as if filled 
      with fluorescent light. The glow subsides, 
      then begins again, and the process repeats itself. 
      Sheila is bathed in radiance. ";
  //nbmPause();
  "<p>Suddenly a hollow voice says: 
      <.q>Congratulations, mortal! You have braved 
      the Mazes of Earth and come out alive! 
      In doing so, you have ascended to the rank 
      of <<glob.scoreRank>>!<./q> ";
  //nbmPause();
  "<p>And then the voices of an invisible choir sing 
      an otherworldly song. ";
  nbmPause();
  nbmCls();
  
  // ------------------------------
  // View possesstions/attributes/enemies/conduct, a la NetHack
  viewNethackInfo();
  
  // ------------------------------
  // Very end of Net-Hac-Man
  nbmCls();
  "<p>In <<bot.turnsDuringHac>> moves of Net-Hac-Man, 
    you scored <<glob.totalHacScore>> points. 
    In previous mazes, you scored 
    <<libScore.totalScore - glob.totalHacScore>> points, 
    giving you a total score of <<libScore.totalScore>>.
    You achieved the rank of <<glob.scoreRank>>. ";
  "<p>Come back soon and revisit the newly remodelled 
    Mazes of Earth! ";
  "<p><br><p>";
  "<center><b>*** Thank you for playing 
    <br>Nothing but Mazes ***</b></center>";
  "<p><br><p>";
  "[Press SPACE to end the game.] ";
  nbmPause();
  nbmCls();
  
  // ------------------------------
  // Do argument
  // 
  // This single line of code is incredibly important. This line 
  // calls the entire "argument": the conversation menu maze which
  // it may take several minutes for the player to escape from.
  // During those minutes, they will have a lot of interacting
  // to do, but will not hit a single command prompt.
  goToArgument.execute;
  //argMain.select;
  
  // Transition to endgame is taken care of by goToArgument.execute(),
  // so that is truly all we need to do here.
}

viewNethackInfo() {
  // ------------------------------
  // Identify possessions
  "<p>Do you want your bot<./s>s possessions identified? ";
  switch (giveThreeOptions()) {
    case 1:
      "<br>";
      actorInventoryLister.showListInPastTense(
        gPlayerChar, // pov
        gPlayerChar, // parent
        gPlayerChar.contents, // lst
        ListRecurse /*| (tall ? ListTall : 0)*/, // options
        0, // indent
        gPlayerChar.inventorySenseInfoTable(), // infoTab
        nil); // parentGroup
      break;
    case 2:
      break;
    case 3:
      return;
  }
  
  // ------------------------------
  // View attributes
  "<p>Do you want to see your bot<./s>s attributes? ";
  switch (giveThreeOptions()) {
    case 1:
      "<br>Final Attributes: ";
      "<br>Your bot was piously aligned. ";
      "<br>Your bot survived. ";
      break;
    case 2:
      break;
    case 3:
      return;
  }
  //switch (inputManager.getKey(nil, nil).toLower) {
  //  case 'n':
  //    break;
  //  case 'q':
  //    return;
  //  default:
  //    "<br>Final Attributes: ";
  //    "<br>Your bot was piously aligned. ";
  //    "<br>Your bot survived. ";
  //    break;
  //}
  
  // ------------------------------
  // View creatures vanquished
  // (skip over this if no creatures vanquished)
  // UNIVERSALIZE (finished)
  if (glob.vanquishedCreatures && glob.vanquishedCreatures.length) {
    "<p>Do you want to see an account of creatures vanquished? ";
    switch (giveThreeOptions()) {
      case 1:
        "<br>Vanquished creatures: ";
        for (local a = 1; a <= glob.vanquishedCreatures.length; a++) {
          "<br><<glob.vanquishedCreatures[a]>> ";
        }
        //if (dragon.vanquishedByBot)
        //  "<br>a <<dragon.vanquishedColor>> duck ";
        //if (copyman.vanquishedByBot)
        //  "<br>a <<copyman.vanquishedColor>> chicken ";
        break;
      case 2:
        break;
      case 3:
        return;
    }
  }
  //if (copyman.vanquishedByBot || dragon.vanquishedByBot) {
  //  "<p>Do you want to see an account of creatures vanquished? ";
  //  switch (giveThreeOptions()) {
  //    case 1:
  //      "<br>Vanquished creatures: ";
  //      if (dragon.vanquishedByBot)
  //        "<br>a <<dragon.vanquishedColor>> duck ";
  //      if (copyman.vanquishedByBot)
  //        "<br>a <<copyman.vanquishedColor>> chicken ";
  //      break;
  //    case 2:
  //      break;
  //    case 3:
  //      return;
  //  }
  //}
  
  // ------------------------------
  // View conduct
  "<p>Do you want to see your bot<./s>s conduct? ";
  switch (giveThreeOptions()) {
    case 1:
      "<br>Voluntary challenges: ";
      // UNIVERSALIZE (finished)
      //if (!copyman.vanquishedByBot && !dragon.vanquishedByBot) {
      if (!glob.vanquishedCreatures || !glob.vanquishedCreatures.length) {
        "<br>Your bot was a pacifist. ";
      }
      if (!adamThorntonM.isInExe) {
        "<br>Your bot played without Adam Thornton. ";
      }
      else {
        if (adam.helpInstances == 0)
          "<br>Your bot never sought the help of Adam Thornton. ";
        else
          "<br>Your bot sought the help of Adam Thornton 
            <<adam.helpInstances>> 
            time<<adam.helpInstances == 1 ? '' : 's'>>. ";
      }
      nbmPause();
      break;
    case 2:
      break;
    case 3:
      return;
  }
}

giveThreeOptions() {
  local myKey;
  "[ynq] (y) ";
  myKey = inputManager.getKey(nil, nil);
  if (rexMatch('<AlphaNum>', myKey) != nil) {
    say(myKey);
  }
  switch (myKey.toLower) {
    case 'y': return 1;
    case 'n': return 2;
    case 'q': return 3;
    
    default : return 1;
  }
}

modify actorInventoryLister
  // my additions
  pastTense = nil
  showListInPastTense(pov, parent, lst, options, indent, infoTab, parentGroup) {
    pastTense = true;
    showList(pov, parent, lst, options, indent, infoTab, parentGroup);
    pastTense = nil;
  }
  giveInvNameIs(parent) {
    if (!pastTense)
      return parent.nameIs;
    else
      return parent.theName + ' was';
  }
  giveInvVerbToBe(parent) {
    if (!pastTense)
      return parent.verbToBe;
    else
      return 'was';
  }
  giveInvItIsContraction(parent) {
    if (!pastTense)
      return parent.itIsContraction;
    else
      return parent.itNom + ' was';
  }
    
  // modified library methods
  showInventoryEmpty(parent) {
    "\^<<giveInvNameIs(parent)>> empty-handed. ";
  }
  showInventoryWearingOnly(parent, wearing) {
    // we're carrying nothing but wearing some items
    "\^<<giveInvNameIs(parent)>> carrying nothing, and <<giveInvVerbToBe(parent)>>
    wearing <<wearing>>. ";
  }
  showInventoryCarryingOnly(parent, carrying) {
    // we have only carried items to report
    "\^<<giveInvNameIs(parent)>> carrying <<carrying>>. ";
  }
  showInventoryShortLists(parent, carrying, wearing) {
    // short lists - combine carried and worn in a single sentence
    "\^<<giveInvNameIs(parent)>> carrying <<carrying>>, and
    <<giveInvItIsContraction(parent)>> wearing <<wearing>>. ";
  }
  showInventoryLongLists(parent, carrying, wearing) {
    // long lists - show carried and worn in separate sentences
    "\^<<giveInvNameIs(parent)>> carrying <<carrying>>.
    \^<<giveInvItIsContraction(parent)>> wearing <<wearing>>. ";
  }
  // For 'tall' listings, we'll use the standard listing style, so we
  // need to provide the framing messages for the tall-mode listing.  
  showListPrefixTall(itemCount, pov, parent) {
    "\^<<giveInvNameIs(parent)>> carrying:";
  }
  showListContentsPrefixTall(itemCount, pov, parent) {
    "<<parent.aName>>, who <<giveInvVerbToBe(parent)>> carrying:";
  }
  showListEmpty(pov, parent) {
    "\^<<giveInvNameIs(parent)>> empty-handed. ";
  }
;
modify inlineListingContentsLister
  showListPrefixWide(cnt, pov, parent) {
    if (!actorInventoryLister.pastTense)
      " (which contains ";
    else
      " (which contained ";
  }
;


//reallyFinishHac() {
//}

// -------------------------------------------------------------------
// HAC-MAN MAZE: GENERAL STUFF: SIGHT DOWN HALLWAYS
// -------------------------------------------------------------------

class HacHall: object
;
class HacColumn: HacHall
;
class HacRow: HacHall
;

hacHallB_1: HacColumn
  hacHallRooms = [
     hacRoomB6
    ,hacRoomB7
    ,hacRoomB8
    ,hacRoomB9
    ,hacRoomB10
    ,hacRoomB11
    ,hacRoomB12
    ,hacRoomB13
    ,hacRoomB14
    ,hacRoomB15
    ,hacRoomB16
    ,hacRoomB17
    ,hacRoomB18
  ]
;
hacHallD_1: HacColumn
  hacHallRooms = [
     hacRoomD2
    ,hacRoomD3
    ,hacRoomD4
    ,hacRoomD5
    ,hacRoomD6
    ,hacRoomD7
    ,hacRoomD8
    ,hacRoomD9
    ,hacRoomD10
    ,hacRoomD11
    ,hacRoomD12
  ]
;
hacHallD_2: HacColumn
  hacHallRooms = [
     hacRoomD14
    ,hacRoomD15
    ,hacRoomD16
  ]
;
hacHallF_1: HacColumn
  hacHallRooms = [
     hacRoomF4
    ,hacRoomF5
    ,hacRoomF6
  ]
;
hacHallF_2: HacColumn
  hacHallRooms = [
     hacRoomF12
    ,hacRoomF13
    ,hacRoomF14
    ,hacRoomF15
    ,hacRoomF16
    ,hacRoomF17
    ,hacRoomF18
  ]
;
hacHallH_1: HacColumn
  hacHallRooms = [
     hacRoomH4
    ,hacRoomH5
    ,hacRoomH6
    ,hacRoomH7
    ,hacRoomH8
    ,hacRoomH9 // an addition for the sake of seeing NPCs in the pink gate
  ]
;
hacHallH_2: HacColumn
  hacHallRooms = [
     hacRoomH12
    ,hacRoomH13
    ,hacRoomH14
    ,hacRoomH15
    ,hacRoomH16
  ]
;
hacHallJ_1: HacColumn
  hacHallRooms = [
     hacRoomJ2
    ,hacRoomJ3
    ,hacRoomJ4
    ,hacRoomJ5
    ,hacRoomJ6
    ,hacRoomJ7
    ,hacRoomJ8
  ]
;
hacHallJ_2: HacColumn
  hacHallRooms = [
     hacRoomJ14
    ,hacRoomJ15
    ,hacRoomJ16
  ]
;
hacHallL_1: HacColumn
  hacHallRooms = [
     hacRoomL4
    ,hacRoomL5
    ,hacRoomL6
  ]
;
hacHallL_2: HacColumn
  hacHallRooms = [
     hacRoomL8
    ,hacRoomL9
    ,hacRoomL10
    ,hacRoomL11
    ,hacRoomL12
    ,hacRoomL13
    ,hacRoomL14
    ,hacRoomL15
    ,hacRoomL16
    ,hacRoomL17
    ,hacRoomL18
  ]
;
hacHallN_1: HacColumn
  hacHallRooms = [
     hacRoomN2
    ,hacRoomN3
    ,hacRoomN4
    ,hacRoomN5
    ,hacRoomN6
    ,hacRoomN7
    ,hacRoomN8
    ,hacRoomN9
    ,hacRoomN10
    ,hacRoomN11
    ,hacRoomN12
    ,hacRoomN13
    ,hacRoomN14
  ]
;
hacHall02_1: HacRow
  hacHallRooms = [
     hacRoomA2
    ,hacRoomB2
    ,hacRoomC2
    ,hacRoomD2
    ,hacRoomE2
    ,hacRoomF2
    ,hacRoomG2
    ,hacRoomH2
    ,hacRoomI2
    ,hacRoomJ2
    ,hacRoomK2
    ,hacRoomL2
    ,hacRoomM2
    ,hacRoomN2
  ]
;
hacHall04_1: HacRow
  hacHallRooms = [
     hacRoomD4
    ,hacRoomE4
    ,hacRoomF4
  ]
;
hacHall04_2: HacRow
  hacHallRooms = [
     hacRoomH4
    ,hacRoomI4
    ,hacRoomJ4
    ,hacRoomK4
    ,hacRoomL4
  ]
;
hacHall06_1: HacRow
  hacHallRooms = [
     hacRoomB6
    ,hacRoomC6
    ,hacRoomD6
  ]
;
hacHall06_2: HacRow
  hacHallRooms = [
     hacRoomF6
    ,hacRoomG6
    ,hacRoomH6
  ]
;
hacHall06_3: HacRow
  hacHallRooms = [
     hacRoomL6
    ,hacRoomM6
    ,hacRoomN6
  ]
;
hacHall08_1: HacRow
  hacHallRooms = [
     hacRoomD8
    ,hacRoomE8
    ,hacRoomF8
    ,hacRoomG8
    ,hacRoomH8
    ,hacRoomI8
    ,hacRoomJ8
    ,hacRoomK8
    ,hacRoomL8
  ]
;
hacHall10_1: HacRow
  hacHallRooms = [
     hacRoomB10
    ,hacRoomC10
    ,hacRoomD10
  ]
;
hacHall10_2: HacRow
  hacHallRooms = [
     hacRoomL10
    ,hacRoomM10
    ,hacRoomN10
  ]
;
hacHall12_1: HacRow
  hacHallRooms = [
     hacRoomD12
    ,hacRoomE12
    ,hacRoomF12
    ,hacRoomG12
    ,hacRoomH12
    ,hacRoomI12
    ,hacRoomJ12
    ,hacRoomK12
    ,hacRoomL12
  ]
;
hacHall14_1: HacRow
  hacHallRooms = [
     hacRoomB14
    ,hacRoomC14
    ,hacRoomD14
  ]
;
hacHall14_2: HacRow
  hacHallRooms = [
     hacRoomH14
    ,hacRoomI14
    ,hacRoomJ14
  ]
;
hacHall14_3: HacRow
  hacHallRooms = [
     hacRoomL14
    ,hacRoomM14
    ,hacRoomN14
  ]
;
hacHall16_1: HacRow
  hacHallRooms = [
     hacRoomD16
    ,hacRoomE16
    ,hacRoomF16
    ,hacRoomG16
    ,hacRoomH16
  ]
;
hacHall16_2: HacRow
  hacHallRooms = [
     hacRoomJ16
    ,hacRoomK16
    ,hacRoomL16
  ]
;
hacHall18_1: HacRow
  hacHallRooms = [
     hacRoomB18
    ,hacRoomC18
    ,hacRoomD18
    ,hacRoomE18
    ,hacRoomF18
    ,hacRoomG18
    ,hacRoomH18
    ,hacRoomI18
    ,hacRoomJ18
    ,hacRoomK18
    ,hacRoomL18
    ,hacRoomM18
    ,hacRoomN18
    ,hacRoomO18
  ]
;


modify hacRoomA2  hacRow    = hacHall02_1;
modify hacRoomB2  hacRow    = hacHall02_1;
modify hacRoomC2  hacRow    = hacHall02_1;
modify hacRoomD2  hacColumn = hacHallD_1 ;
modify hacRoomD2  hacRow    = hacHall02_1;
modify hacRoomE2  hacRow    = hacHall02_1;
modify hacRoomF2  hacRow    = hacHall02_1;
modify hacRoomG2  hacRow    = hacHall02_1;
modify hacRoomH2  hacRow    = hacHall02_1;
modify hacRoomI2  hacRow    = hacHall02_1;
modify hacRoomJ2  hacColumn = hacHallJ_1 ;
modify hacRoomJ2  hacRow    = hacHall02_1;
modify hacRoomK2  hacRow    = hacHall02_1;
modify hacRoomL2  hacRow    = hacHall02_1;
modify hacRoomM2  hacRow    = hacHall02_1;
modify hacRoomN2  hacColumn = hacHallN_1 ;
modify hacRoomN2  hacRow    = hacHall02_1;
modify hacRoomD3  hacColumn = hacHallD_1 ;
modify hacRoomJ3  hacColumn = hacHallJ_1 ;
modify hacRoomN3  hacColumn = hacHallN_1 ;
modify hacRoomD4  hacColumn = hacHallD_1 ;
modify hacRoomD4  hacRow    = hacHall04_1;
modify hacRoomE4  hacRow    = hacHall04_1;
modify hacRoomF4  hacColumn = hacHallF_1 ;
modify hacRoomF4  hacRow    = hacHall04_1;
modify hacRoomH4  hacColumn = hacHallH_1 ;
modify hacRoomH4  hacRow    = hacHall04_2;
modify hacRoomI4  hacRow    = hacHall04_2;
modify hacRoomJ4  hacColumn = hacHallJ_1 ;
modify hacRoomJ4  hacRow    = hacHall04_2;
modify hacRoomK4  hacRow    = hacHall04_2;
modify hacRoomL4  hacColumn = hacHallL_1 ;
modify hacRoomL4  hacRow    = hacHall04_2;
modify hacRoomN4  hacColumn = hacHallN_1 ;
modify hacRoomD5  hacColumn = hacHallD_1 ;
modify hacRoomF5  hacColumn = hacHallF_1 ;
modify hacRoomH5  hacColumn = hacHallH_1 ;
modify hacRoomJ5  hacColumn = hacHallJ_1 ;
modify hacRoomL5  hacColumn = hacHallL_1 ;
modify hacRoomN5  hacColumn = hacHallN_1 ;
modify hacRoomB6  hacColumn = hacHallB_1 ;
modify hacRoomB6  hacRow    = hacHall06_1;
modify hacRoomC6  hacRow    = hacHall06_1;
modify hacRoomD6  hacColumn = hacHallD_1 ;
modify hacRoomD6  hacRow    = hacHall06_1;
modify hacRoomF6  hacColumn = hacHallF_1 ;
modify hacRoomF6  hacRow    = hacHall06_2;
modify hacRoomG6  hacRow    = hacHall06_2;
modify hacRoomH6  hacColumn = hacHallH_1 ;
modify hacRoomH6  hacRow    = hacHall06_2;
modify hacRoomJ6  hacColumn = hacHallJ_1 ;
modify hacRoomL6  hacColumn = hacHallL_1 ;
modify hacRoomL6  hacRow    = hacHall06_3;
modify hacRoomM6  hacRow    = hacHall06_3;
modify hacRoomN6  hacColumn = hacHallN_1 ;
modify hacRoomN6  hacRow    = hacHall06_3;
modify hacRoomB7  hacColumn = hacHallB_1 ;
modify hacRoomD7  hacColumn = hacHallD_1 ;
modify hacRoomH7  hacColumn = hacHallH_1 ;
modify hacRoomJ7  hacColumn = hacHallJ_1 ;
modify hacRoomN7  hacColumn = hacHallN_1 ;
modify hacRoomB8  hacColumn = hacHallB_1 ;
modify hacRoomD8  hacColumn = hacHallD_1 ;
modify hacRoomD8  hacRow    = hacHall08_1;
modify hacRoomE8  hacRow    = hacHall08_1;
modify hacRoomF8  hacRow    = hacHall08_1;
modify hacRoomG8  hacRow    = hacHall08_1;
modify hacRoomH8  hacColumn = hacHallH_1 ;
modify hacRoomH8  hacRow    = hacHall08_1;
modify hacRoomI8  hacRow    = hacHall08_1;
modify hacRoomJ8  hacColumn = hacHallJ_1 ;
modify hacRoomJ8  hacRow    = hacHall08_1;
modify hacRoomK8  hacRow    = hacHall08_1;
modify hacRoomL8  hacColumn = hacHallL_2 ;
modify hacRoomL8  hacRow    = hacHall08_1;
modify hacRoomN8  hacColumn = hacHallN_1 ;
modify hacRoomB9  hacColumn = hacHallB_1 ;
modify hacRoomD9  hacColumn = hacHallD_1 ;
modify hacRoomL9  hacColumn = hacHallL_2 ;
modify hacRoomN9  hacColumn = hacHallN_1 ;
modify hacRoomB10 hacColumn = hacHallB_1 ;
modify hacRoomB10 hacRow    = hacHall10_1;
modify hacRoomC10 hacRow    = hacHall10_1;
modify hacRoomD10 hacColumn = hacHallD_1 ;
modify hacRoomD10 hacRow    = hacHall10_1;
modify hacRoomL10 hacColumn = hacHallL_2 ;
modify hacRoomL10 hacRow    = hacHall10_2;
modify hacRoomM10 hacRow    = hacHall10_2;
modify hacRoomN10 hacColumn = hacHallN_1 ;
modify hacRoomN10 hacRow    = hacHall10_2;
modify hacRoomB11 hacColumn = hacHallB_1 ;
modify hacRoomD11 hacColumn = hacHallD_1 ;
modify hacRoomL11 hacColumn = hacHallL_2 ;
modify hacRoomN11 hacColumn = hacHallN_1 ;
modify hacRoomB12 hacColumn = hacHallB_1 ;
modify hacRoomD12 hacColumn = hacHallD_1 ;
modify hacRoomD12 hacRow    = hacHall12_1;
modify hacRoomE12 hacRow    = hacHall12_1;
modify hacRoomF12 hacColumn = hacHallF_2 ;
modify hacRoomF12 hacRow    = hacHall12_1;
modify hacRoomG12 hacRow    = hacHall12_1;
modify hacRoomH12 hacColumn = hacHallH_2 ;
modify hacRoomH12 hacRow    = hacHall12_1;
modify hacRoomI12 hacRow    = hacHall12_1;
modify hacRoomJ12 hacRow    = hacHall12_1;
modify hacRoomK12 hacRow    = hacHall12_1;
modify hacRoomL12 hacColumn = hacHallL_2 ;
modify hacRoomL12 hacRow    = hacHall12_1;
modify hacRoomN12 hacColumn = hacHallN_1 ;
modify hacRoomB13 hacColumn = hacHallB_1 ;
modify hacRoomF13 hacColumn = hacHallF_2 ;
modify hacRoomH13 hacColumn = hacHallH_2 ;
modify hacRoomL13 hacColumn = hacHallL_2 ;
modify hacRoomN13 hacColumn = hacHallN_1 ;
modify hacRoomB14 hacColumn = hacHallB_1 ;
modify hacRoomB14 hacRow    = hacHall14_1;
modify hacRoomC14 hacRow    = hacHall14_1;
modify hacRoomD14 hacColumn = hacHallD_2 ;
modify hacRoomD14 hacRow    = hacHall14_1;
modify hacRoomF14 hacColumn = hacHallF_2 ;
modify hacRoomH14 hacColumn = hacHallH_2 ;
modify hacRoomH14 hacRow    = hacHall14_2;
modify hacRoomI14 hacRow    = hacHall14_2;
modify hacRoomJ14 hacColumn = hacHallJ_2 ;
modify hacRoomJ14 hacRow    = hacHall14_2;
modify hacRoomL14 hacColumn = hacHallL_2 ;
modify hacRoomL14 hacRow    = hacHall14_3;
modify hacRoomM14 hacRow    = hacHall14_3;
modify hacRoomN14 hacColumn = hacHallN_1 ;
modify hacRoomN14 hacRow    = hacHall14_3;
modify hacRoomB15 hacColumn = hacHallB_1 ;
modify hacRoomD15 hacColumn = hacHallD_2 ;
modify hacRoomF15 hacColumn = hacHallF_2 ;
modify hacRoomH15 hacColumn = hacHallH_2 ;
modify hacRoomJ15 hacColumn = hacHallJ_2 ;
modify hacRoomL15 hacColumn = hacHallL_2 ;
modify hacRoomB16 hacColumn = hacHallB_1 ;
modify hacRoomD16 hacColumn = hacHallD_2 ;
modify hacRoomD16 hacRow    = hacHall16_1;
modify hacRoomE16 hacRow    = hacHall16_1;
modify hacRoomF16 hacColumn = hacHallF_2 ;
modify hacRoomF16 hacRow    = hacHall16_1;
modify hacRoomG16 hacRow    = hacHall16_1;
modify hacRoomH16 hacColumn = hacHallH_2 ;
modify hacRoomH16 hacRow    = hacHall16_1;
modify hacRoomJ16 hacColumn = hacHallJ_2 ;
modify hacRoomJ16 hacRow    = hacHall16_2;
modify hacRoomK16 hacRow    = hacHall16_2;
modify hacRoomL16 hacColumn = hacHallL_2 ;
modify hacRoomL16 hacRow    = hacHall16_2;
modify hacRoomB17 hacColumn = hacHallB_1 ;
modify hacRoomF17 hacColumn = hacHallF_2 ;
modify hacRoomL17 hacColumn = hacHallL_2 ;
modify hacRoomB18 hacColumn = hacHallB_1 ;
modify hacRoomB18 hacRow    = hacHall18_1;
modify hacRoomC18 hacRow    = hacHall18_1;
modify hacRoomD18 hacRow    = hacHall18_1;
modify hacRoomE18 hacRow    = hacHall18_1;
modify hacRoomF18 hacColumn = hacHallF_2 ;
modify hacRoomF18 hacRow    = hacHall18_1;
modify hacRoomG18 hacRow    = hacHall18_1;
modify hacRoomH18 hacRow    = hacHall18_1;
modify hacRoomI18 hacRow    = hacHall18_1;
modify hacRoomJ18 hacRow    = hacHall18_1;
modify hacRoomK18 hacRow    = hacHall18_1;
modify hacRoomL18 hacColumn = hacHallL_2 ;
modify hacRoomL18 hacRow    = hacHall18_1;
modify hacRoomM18 hacRow    = hacHall18_1;
modify hacRoomN18 hacRow    = hacHall18_1;
modify hacRoomO18 hacRow    = hacHall18_1;

// hacRoomH10 never needs to be seen, but if it's not in any hallway,
// then the normal method of moving NPCs won't work. So make a token
// hallway.
modify hacRoomH9  hacColumn = hacHallH_1 ;
hacHall10_3: HacRow
  hacHallRooms = [
     hacRoomH10
  ]
;
modify hacRoomH10 hacRow    = hacHall10_3;

// -------------------------------------------------------------------
// HAC-MAN MAZE: NPC STUFF: NPC CLASSES
// -------------------------------------------------------------------

modify glob
  meleeTest = nil
  vanquishedCreatures = []
  meleeOpponent = nil
;

// these are the melee strategies
enum attack, attackOnceThenFlee, flee, piss, getPissedUpon;

modify Actor
  statusDesc {
    "Status of <<theName>> 
      <<scientificName ? '(<i>' + scientificName + '</i>) ' : ''>>(<<alignment>>): 
      Level <<experienceLevel>>&nbsp; 
      HP <<hitPoints>>(<<maxHitPoints>>)&nbsp;
      AC <<armorClass>><<isPeaceful ? ', peaceful' : ''>>. ";
  }
  scientificName = nil
  // This method is badly needed in the library. Debugging is a 
  // pain when it's hard to find out what an Actor's current
  // agenda item is.
  curAgendaItem {
    local item;
    /* if we don't have an agenda, there are obviously no items */
    if (agendaList == nil)
        return nil;
    /* remove any items that are marked as done */
    while ((item = agendaList.lastValWhich({x: x.isDone})) != nil)
        agendaList.removeElement(item);
    /* 
     *   Scan for an item that's ready to execute.  Since we keep the
     *   list sorted in ascending order of agendaOrder values, we can
     *   just pick the earliest item in the list that's ready to run,
     *   since that will be the ready-to-run item with the lowest
     *   agendaOrder number. 
     */
    item = agendaList.valWhich({x: x.isReady});
    return item;
  }
  /*
  // Since I am developing with TADS 3.0.8, I must here replace
  // Actor.executeAgenda() to get rid of a bug
  // (http://groups.google.com/group/rec.arts.int-fiction/browse_frm/thread/93b7fd317e1b2f18/)
  // that was not fixed until TADS 3.0.10.
  executeAgenda()
  {
    local item;
    if (agendaList == nil)
      return nil;
    while ((item = agendaList.lastValWhich({x: x.isDone})) != nil)
      agendaList.removeElement(item);
    item = agendaList.valWhich({x: x.isReady});
    if (item != nil) {
      try {
        item.invokeItem();
      }
      
      
      // BEGIN FIX: note RuntimeError, not Exception
      catch (RuntimeError err) {
        item.isDone = true;
        throw err;
      }
      // END FIX
      
      
      return true;
    }
    else {
        return nil;
    }
  }
  */
  startMelee(opponent) {
    local winner, loser, protagonist, iter;
    local smiter, smited, meleeCompleted;
    //local combatantList = [self, opponent];
    prepareForMelee;
    opponent.prepareForMelee;
    if (self.meleeDifficulty >= opponent.meleeDifficulty) {
      winner = self;
      loser = opponent;
    }
    else {
      winner = opponent;
      loser = self;
    }
    // "protagonist" means the person who you want to win during the
    // fighting
    if (self.protagonistLikelihood > opponent.protagonistLikelihood)
      protagonist = self;
    else
      protagonist = opponent;
    // If the combat cannot be seen, print an appropriate message.
    if (!bot.canSee(self) && !bot.canSee(opponent) && !glob.meleeTest) {
      pleaseSay('Your bot hears some noises in the distance. ');
      
    }
    // If combat can be seen, print an appropriate set of messages,
    // along with pauses for people to press a key.
    else {
      iter = 0;
      meleeCompleted = nil;
      for (;;) {
        iter++;
        for (local b = 1; b <= 2; b++) {
          if (b == 1) { smiter = self    ; smited = opponent; }
          else        { smiter = opponent; smited = self    ; }
          // "self", because "self" is the perpetrator.
          smiter.doMeleeAttack(smited, winner, self, iter);
          if (smited == loser && iter >= smited.meleeEndurance(smiter)) {
            if (smited == bot) {
              // No need to callWithSenseContext, as the bot can definitely
              // see the bot.
              "Your bot dies... ";
              endGame(ftDeath);
            }
            //else
            //  "\^<<loser.theName>> dies... ";
            meleeCompleted = true;
            break;
          }
          if (smited == protagonist && !meleeCompleted) {
            pleaseSay('--More-- ');
            //callWithSenseContext(nil, nil, new function { "--More-- "; } );
            //"--More--";
            nbmBanner.updateMe;
            inputManager.getKey(nil, nil);
            //if (gKey()) {local k=0;k=k/k;}
            //nbmPause();
            pleaseSay('\n');
            //callWithSenseContext(nil, nil, new function { "\n"; } );
            //"\n";
          }
        }
        if (meleeCompleted) break;
      }
    }
    if (winner == bot) {
      loser.vanquishedByBot = true;
      glob.vanquishedCreatures += loser.aName;
      if (loser.isWhite)
        loser.vanquishedColor = 'white';
      else
        loser.vanquishedColor = 'blue';
    }
    if (loser != bot && loser.location != nil && !glob.meleeTest)
      loser.killNpc;
    //nbmBanner.updateMe; // should be unnecessary
  }
  prepareForMelee {
    isFleeing = nil;
    banditState = 0;
#ifdef __DEBUG
    hasScoffed = nil;
#endif // __DEBUG
  }
  //doMeleeAttack(opponent, winner, perpetrator, iter) {
  //  //"[Actor.dMA:] ";
  //  sayFollowing(opponent);
  //  "\^<<self.theName>> hits <<opponent.theName>>. ";
  //}
  doMeleeAttack(opponent, winner, perpetrator, iter) {
    local successfulAttack;
    local deadlyAttack;
    local strategy;
    strategy = meleeStrategy(opponent, perpetrator);
    // If attacking...
    if (strategy == attack || (strategy == attackOnceThenFlee && iter == 1)
        || (strategy == getPissedUpon && opponent.banditState <= 0)) {
      sayFollowing(opponent);
      // Always attack successfully on the first try when striking first.
      if (perpetrator == self && iter == 1)
        successfulAttack = true;
      // When attacking a weaker opponent, never miss.
      else if (winner == self)
        successfulAttack = true;
      // Otherwise, 50% chance of success.
      else
        successfulAttack = (rand(2) == 0);
      if (successfulAttack && self == winner && iter == opponent.meleeEndurance(self))
        deadlyAttack = true;
      else
        deadlyAttack = nil;
      // If an attack against the bot is successful, it should reduce 
      // the bot's hit points.
      // 
      // Note that we do not reduce hit points for the other characters.
      // All other characters either (1) will die, (2) will kill Sheila, 
      // after which Sheila will not be able to glimpse her opponent's
      // injured state, or (3) will be Adam or the bandit, who each 
      // emerge unscathed from their fights due to fire resistance.
      // In all three cases, subtracting hit points is unnecessary.
      // 
      // However, Sheila needs to get her hit points subtracted, for 
      // two reasons:
      // (1) The data in the lower right-hand corner of the screen
      // should be properly updated during the fight, and
      // (2) When fighting against a weanie (the chicken, duck, etc.),
      // the weanie will do a slight amount of damage which will be
      // visible afterwards.
      if (successfulAttack && opponent == bot) {
        // A deadly attack must obviously reduce hit points to 0.
        if (deadlyAttack) {
          opponent.hitPoints = 0;
        }
        // If a weanie (duck, chicken) is attacking the bot, it 
        // only deducts 1 hit point.
        else if (winner != self) {
          opponent.hitPoints--;
          // also, make sure that the desired healing time goes by 
          // before this injury gets healed.
          opponent.healCount = 0;
          //pleaseSay('<.p>opponent.healCount was supposed to be reduced to 0 here.<.p>');
          //if (gKey()) {local k=0;k=k/k;}
        }
        // Otherwise, deduct an amount of hit points in indirect 
        // proportion to how much meleeEndurance the opponent (the bot) 
        // still has remaining.
        else {
          //       melee
          // iter  Endur  Proportion of hit points to deduct
          //    1      4  1/4 = 1 / (4 - 1 + 1)
          //    2      4  1/3 = 1 / (4 - 2 + 1)
          //    3      4  1/2 = 1 / (4 - 3 + 1)
          //    4      4    1 = 1 / (4 - 4 + 1)
          //if (iter == 2) {local k=0;k=k/k;}
          opponent.hitPoints -= opponent.hitPoints / (opponent.meleeEndurance(self) - iter + 1);
          // introduce a certain element of randomness...
          opponent.hitPoints -= rand(0, 1, 2);
          // ... but, as a fail-safe, make sure not to drop below 
          // 0 hit points until we're ready for the opponent to die.
          if (opponent.hitPoints <= 0)
            opponent.hitPoints = 1;
        }
      }
      // Do the message reporting
      if (deadlyAttack && opponent != bot)
        sayDeadlyAttack(opponent);
      else if (successfulAttack)
        saySuccessfulAttack(opponent);
      else
        sayUnsuccessfulAttack(opponent);
      // Deal with the "Thor-like blow" scenario. One of my testers
      // hated this; I'll get rid of it if other testers complain.
      if (deadlyAttack && self == copyman && !self.isTransformed && opponent == bot)
        pleaseSay('A THOR-LIKE BLOW! ');
      // Offer taunt, if applicable
      if (successfulAttack && !deadlyAttack) {
        doTaunt(opponent);
      }
      // Deal with the "Scoff, scoff, scoff, scoff I" scenario
      if (deadlyAttack && self == bandit && opponent != bot) {
        if (!hasScoffed)
          sayScoff(opponent);
        //if (opponent == copyman && !opponent.isTransformed)
        //  "\^<<theName>> puts his <<wandName>> back into his cape. ";
        hasScoffed = true;
      }
    }
    // If getting pissed upon...
    else if (strategy == getPissedUpon && opponent.banditState <= 2) {
      if (opponent.banditState == 1)
        pleaseSay('\^' + theName + ' prepares to attack, 
          but the sight of the ' + bandit.wandName 
          + ' makes his mind wander. ');
        //"\^<<theName>> prepares to attack, but the sight of the 
        //  <<bandit.wandName>> makes his mind wander. ";
      else if (opponent.banditState == 2)
        pleaseSay('Absent-mindedly, ' + theName 
          + ' puts his flamethrower into his ' + clothingPhrase 
          + ' and pulls out a bowl of Cheerios. ');
        //"Absent-mindedly, <<theName>> puts his flamethrower into his
        //  <<clothingPhrase>> and pulls out a bowl of Cheerios. ";
    }
    // If fleeing...
    else if (strategy == flee || strategy == attackOnceThenFlee || strategy == getPissedUpon) {
      if (!isFleeing)
        pleaseSay('\^' + theName + ' turns to flee' 
          + (self == bot ? '. ' : '! '));
        //"\^<<theName>> turns to flee<<self == bot ? '.' : '!'>> ";
      else
        pleaseSay('\^' + theName + ' flees' + (self == bot ? '. ' : '! '));
        //"\^<<theName>> flees<<self == bot ? '.' : '!'>> ";
      isFleeing = true;
    }
    // If pissing...
    else if (strategy == piss) {
      banditState = iter;
      sayFollowing(opponent);
      if (banditState == 1) {
        pleaseSay('\^' + theName + ' throws back his cape 
          and takes out his ' + wandName + '! ');
        //"\^<<theName>> throws back his cape and takes out his <<wandName>>! ";
      }
      else if (banditState == 2) {
        pleaseSay('\^' + theName + ' zaps his ' + wandName + '! ');
        //"\^<<theName>> zaps his <<wandName>>! ";
      }
      else {
        pleaseSay('\^' + theName + ' zaps his ' + wandName + '! 
          \^' + opponent.theName + ' is ');
        //"\^<<theName>> zaps his <<wandName>>! \^<<opponent.theName>> is ";
        if (iter < opponent.meleeEndurance(self)) {
          pleaseSay('struck by a blast of water. ');
          //"struck by a blast of water. ";
          doTaunt(opponent);
        }
        else {
          pleaseSay('killed by a blast of water! ');
          //"killed by a blast of water! ";
          sayScoff(opponent);
          pleaseSay('\^' + theName + ' puts his ' + wandName 
            + ' back into his cape. ');
          //"\^<<theName>> puts his <<wandName>> back into his cape. ";
          hasScoffed = true;
        }
      }
    }
  }
  banditState = 0
  sayScoff(opponent) {
    pleaseSay('<.q>Ha-HA! I scoff at ' + opponent.itPossAdj 
      + ' Pathetic Attempts to Defeat Me! 
      Scoff, scoff, scoff, scoff I!<./q> ');
    //"<.q>Ha-HA! I scoff at <<opponent.itPossAdj>> Pathetic Attempts 
    //  to Defeat Me! Scoff, scoff, scoff, scoff I!<./q> ";
  }
  hasScoffed = nil
  // meleeEndurance means how many times they will need to be hit
  // during a melee in order to die. The loser's meleeEndurance
  // determines the length of the fight.
  meleeEndurance(opponent) {
    // dragon, adam, and bandit: meleeEndurance is 5
    if (meleeDifficulty >= 17) return 5;
    // copyman: if up against the bandit, add 2 to the endurance,
    // since there will be two preliminary turns when nobody does much.
    if (self == copyman && opponent == bandit) return 6;
    // copyman: meleeEndurance is 4, except in the previous scenario
    if (meleeDifficulty >= 10) return 4;
    // bot, duck, chicken: meleeEndurance is 3
    return 3;
  }
  // As a default behavior, don't bother taunting.
  sayTaunt(opponent) { }
  sayFollowing(opponent) {
    if (opponent.isFleeing)
      pleaseSay('\^' + theName + ' follows. ');
      //"\^<<theName>> follows. ";
  }
  isFleeing = nil
  sayUnsuccessfulAttack(opponent) {
    pleaseSay('\^' + theName + ' misses ' + opponent.theName + '. ');
    //"\^<<theName>> misses <<opponent.theName>>. ";
  }
  // By default, actors don't taunt.
  tauntObj(opponent) { return nil; }
  doTaunt(opponent) {
    glob.meleeOpponent = opponent;
    if (tauntObj(opponent))
      tauntObj(opponent).doScript;
    glob.meleeOpponent = nil;
  }
  preferredBanditDestination = 'a Farmstead'
  healCount = 0
  healTime = 8 
  doHealing { } // do nothing by default
;


// Note to TADS 3 programmers: As you can see, I am creating actors
// that also belong to the MultiLoc class. This is not usually 
// a very good idea at all; in fact, it will tend to create massive
// run-time errors, as the code of class Actor frequently *assumes*
// that its location property is meaningful.
// 
// It is almost always much better to have the actor be a normal object 
// with a normal location property and use SenseConnectors to make 
// the actor visible from a distance.
// 
// The only reason I did it this way is that, if I recall correctly,
// the vast number of rooms in the Hac-Man maze made it so that 
// a normal collection of SenseConnectors really slowed things down
// a lot. If you are not experiencing similar problems, I strongly
// recommend you don't imitate this ghastly kludge.
class HacNpc: MultiLoc, Person
  desc {
    statusDesc;
  }
  agendaCount = 0
  // "nickname" is originally intended for use only when 
  // Shiela calls out "Hey, Adam!" or "Hey, bandit!"
  nickname = (name) // usually override
  pluralNickname = pluralNameFrom(nickname)
  hasBeenSeen = nil
  killNpc {
    isDead = true;
    deactivateNpc;
    if (successor)
      successor.activateNpc;
  }
  deactivateNpc {
    hacMoveInto(nil);
    agendaList = new Vector(10);
  }
  //successor = nil
  successor {
    if (glob.hacEnemyCount >= glob.hacEnemySequence.length)
      return nil;
    else
      return glob.hacEnemySequence[glob.hacEnemyCount + 1];
  }
  // Location with respect to the bot. This will return a list with
  // two items. The two items will represent where the NPC
  // is with respect to the bot, but only if the NPC is visible to the bot.
  // E.g., if the NPC is two rooms to the east of the PC,
  // return the list [eastDirection, 2]. However, if the bot
  // can't see the NPC, return the list [nil, 1000].
  locationWrtBot {
    local lst = [&hacColumn, &hacRow];
    local npcLstVal, botLstVal;
    if (!locationList.indexOf(bot.location))
      return [nil, 1000];
    if (realLocation == bot.location)
      return [true, 0];
    for (local a = 1; a <= 2; a++) {
      if (realLocation.(lst[a])) {
        botLstVal = realLocation.(lst[a]).hacHallRooms.indexOf(bot.location);
        if (botLstVal) {
          npcLstVal = realLocation.(lst[a]).hacHallRooms.indexOf(realLocation);
          return [
             (lst[a] == &hacRow 
               ? (npcLstVal < botLstVal ? westDirection : eastDirection) 
               : (npcLstVal < botLstVal ? northDirection : southDirection))
            ,(npcLstVal - botLstVal >= 0 
               ? npcLstVal - botLstVal 
               : botLstVal - npcLstVal)
          ];
        }
      }
    }
    // If everything failed... well, that's not good. In that case,
    // return a value signifying that the NPC is invisible.
    return [nil, 1500];
  }
  specialDesc() {
    actorHereDesc;
    hasBeenSeen = true;
  }
  distantSpecialDesc() { actorHereDesc; }
  remoteSpecialDesc(pov) { actorHereDesc; }
  specialDescListWith() { return []; }
  actorHereDesc {
    local locLst = locationWrtBot;
    if (!locLst[1])
      return;
    "\^<<theName>> is <<postureWord>> ";
    if (locLst[2] == 0 || !locLst[1].ofKind(Direction)) {
      "here. ";
      return;
    }  
    if (locLst[2] == 1) {
      "immediately to the <<locLst[1].name>>";
    }
    else {
      "down the hallway to the <<locLst[1].name>>";
    }
    if (realLocation == hacRoomH9)
      ", right in the middle of the pink gate";
    ". ";
    return;
  }
  postureWord = 'standing'
  //actorListWith() { return []; }
  // This method attempts to return a list of two values: the next junction
  // that the NPC is going to hit, and the room that it will hit
  // before it gets to that junction.
  // This should succeed, but if it fails, it will simply return nil.
  nextJunctionResults {
    local ct = 0;
    local rm = location;
    local prevRm = previousRoom;
    for (;;) {
      ct++;
      // If rm is a junction, return with the proper values.
      if (rm.ofKind(HacJunction))
        return [rm, prevRm];
      // If due to some unforeseen bug we iterate through this
      // loop more than 15 times, give up.
      if (ct >= 15)
        return nil;
      // Otherwise, look for the next room.
      for (local a = 1; a <= 4; a++) {
        if (rm.(glob.fourDirList[a]) != nil
            && rm.(glob.fourDirList[a]).ofKind(Room)
            && rm.(glob.fourDirList[a]) != prevRm)
        {
          prevRm = rm;
          rm = rm.(glob.fourDirList[a]);
          break;
        }
      }
    }
  }
  location = nil
  realLocation = nil
  hacLocationList = []
  // in hacMoveInto, the newRoom argument is a single room, and the NPC,
  // as a MultiLoc object, is "moved" into all the locations that are
  // visible from newRoom.
  hacMoveInto(newRoom) {
    local lst = [];
    // realLocation is now the new room.
    realLocation = newRoom;
    // It seems a little dicey to set the location of the actor to anything,
    // but apparently I must do it. NPCs are obviously not designed 
    // to be MultiLoc objects, and it's hard to avoid nil object errors
    // unless I do it this way.
    location = realLocation;
    // Momentarily remove this NPC from the game.
    baseMoveInto(nil);
    // If newRoom is nil, we're done.
    if (!newRoom) {
      agendaList = new Vector(10);
      return;
    }
    // Make "lst" equal to a list of all the rooms visible from the
    // NPC's new realLocation (realLocation itself should be part of the list),
    // with no elements of the list repeated.
    if (newRoom.hacRow)
      lst = lst + newRoom.hacRow.hacHallRooms;
    if (newRoom.hacColumn)
      lst = lst + newRoom.hacColumn.hacHallRooms;
    lst = lst.getUnique();
    // Here's a strategy that might work: simply make it so that
    // locationList equals "lst", then initializeLocation
    locationList = lst;
    initializeLocation();
    //if (self == dragon && newRoom != hacRoomH10) { local k=0;k=k/k; }
  }
  beforeHacMoveInto { }
  afterHacMoveInto { }
  dobjFor(TalkTo) {
    action {
      talkNoEffect;
    }
  }
  talkNoEffect {
    "Sheila says, <.q>Hey, <<nickname>>!<./q> 
      <p>\^<<theName>>, however, ignores her";
    if (ofKind(HacFriend) && !isCloseEnoughToTalk)
      ", perhaps because <<itIsContraction>> too far away";
    ". ";
  }
  isCloseEnoughToTalk {
    local loc = gPlayerChar.location;
    dirList = [&north, &east, &south, &west];
    for (local a = 1; a <= 4; a++) {
      if (loc.(dirList[a]) && loc.(dirList[a]).ofKind(Room)) {
        if (loc.(dirList[a]) == self.location)
          return true;
        for (local b = 1; b <= 4; b++) {
          if (loc.(dirList[a]).(dirList[b]) && loc.(dirList[a]).(dirList[b]).ofKind(Room)
              && loc.(dirList[a]).(dirList[b]) == self.location)
            return true;
        }
      }
    }
    return nil; 
  }
  isCalledByAttacker = 'beast'
  meleeDifficulty = 1
  experienceLevel = 0
  alignment = 'neutral'
  meleeStrategy(opponent, perpetrator) {
    return attack;
  }
  hitPoints = maxHitPoints
  maxHitPoints = 25 // override
  armorClass = 5 // override
  isPeaceful = true
  // Attack or otherwise confront an opponent who is presumably
  // standing in the place where this NPC wants to be.
  confrontChar(opponent) {
    startMelee(opponent);
    if (realLocation == nil)
      return halt;
    else
      return advance;
  }
  // syntaxTokens and transTokens are used only when doing
  // the debugging verb "melee".
  syntaxTokens = [' '] // override
  transTokens = [' '] // override for NPCs that get transformed; i.e. enemies
;

enum red, blue, white;

class HacEnemy: HacNpc
  name {
    if (!isTransformed)
      return redName;
    else if (!isWhite)
      return blueName;
    else
      return whiteName;
  }
  dobjFor(TalkTo) {
    verify { logicalRank(130, 'hac enemy'); }
  }
  nickname {
    if (!isTransformed)
      return redNickname;
    else if (!isWhite)
      return blueNickname;
    else
      return whiteNickname;
  }
  redName = '' // override
  blueName = '' // override
  whiteName = '' // override
  redVocabWords = '' // override
  blueVocabWords = '' // override
  whiteVocabWords = '' // override
  redNickname = (redName)
  blueNickname = (blueName)
  whiteNickname = (whiteName)
  pluralRedNickname = pluralNameFrom(redNickname)
  isDead = nil
  isTransformed = nil //(bot.isPowered)
  isWhite = nil
  knownByAdam = nil
  protagonistLikelihood = 10
  priority = 99999 // override
  vanquishedByBot = nil
  informAdamTopic = informAdamDefault
  vanquishedColor = nil
  roomToRunNorthTo = nil
  //isRunningAbruptly = nil
  transformNpc {
    sayTransform1;
    isTransformed = true;
    transformNpcCq(red, blue);
    sayTransform2;
  }
  transformNpcToWhite {
    sayTransform1;
    isWhite = true;
    transformNpcCq(blue, white);
    sayTransform2;
  }
  untransformNpc {
    sayTransform1;
    isTransformed = nil;
    isWhite = nil;
    transformNpcCq(white, red);
    sayTransform2;
  }
  transformNpcCq(clr1, clr2) {
    if (!redToks) {
      redToks = Tokenizer.tokenize(redVocabWords);
      blueToks = Tokenizer.tokenize(blueVocabWords);
      whiteToks = Tokenizer.tokenize(whiteVocabWords);
    }
    if (clr1 && self.(tokProp(clr1)).length) {
      for (local a = 1; a <= self.(tokProp(clr1)).length; a++) {
        cmdDict.removeWord(self, getTokVal(self.(tokProp(clr1))[a]), &adjective);
      }
    }
    if (self.(tokProp(clr2)).length) {
      for (local a = 1; a <= self.(tokProp(clr2)).length; a++) {
        cmdDict.addWord(self, getTokVal(self.(tokProp(clr2))[a]), &adjective);
      }
    }
  }
  tokProp(clr) {
    switch (clr) {
      case red:   return &redToks;
      case blue:  return &blueToks;
      case white: return &whiteToks;
      default: return nil;
    }
  }
  redToks = nil
  blueToks = nil
  whiteToks = nil
  //activateNpc {
  //  glob.hacEnemyCount++;
  //  selfWaitToArrive = new WaitToArrive.location == self;
  //}
  // I was going to do this stuff during construct(), but that didn't
  // work, and I don't have the time to bother figuring out why.
  createAgenda {
    //inherited;
    selfWaitToArrive = new WaitToArrive; selfWaitToArrive.location = self;
    selfWaitInBox    = new WaitInBox   ; selfWaitInBox   .location = self;
    selfExitBox      = new ExitBox     ; selfExitBox     .location = self;
    selfRunNorth     = new RunNorth    ; selfRunNorth    .location = self;
    selfStayNorth    = new StayNorth   ; selfStayNorth   .location = self;
    selfRunFromPc    = new RunFromPc   ; selfRunFromPc   .location = self;
    selfChasePc      = new ChasePc     ; selfChasePc     .location = self;
    // We need only tinker with the defaults in one case:
    if (runNorthAbruptly)
      selfRunNorth.runAbruptly = true;
    // remember that we did this:
    agendaCreated = true;
  }
  agendaCreated = nil
  selfWaitToArrive = nil // create dynamically during construct()
  selfWaitInBox    = nil // create dynamically during construct()
  selfExitBox      = nil // create dynamically during construct()
  selfRunNorth     = nil // create dynamically during construct()
  selfStayNorth    = nil // create dynamically during construct()
  selfRunFromPc    = nil // create dynamically during construct()
  selfChasePc      = nil // create dynamically during construct()
  activateNpc {
    glob.hacEnemyCount++;
    if (!agendaCreated) {
      for (local a = 1; a <= glob.hacEnemies.length; a++) {
        if (!glob.hacEnemies[a].agendaCreated)
          glob.hacEnemies[a].createAgenda;
      }
    }
    if (glob.firstHacEnemy == self && glob.hacEnemyCount == 1)
      npcGoRoom(self, hacRoomH10);
    else
      addToAgenda(selfWaitToArrive);
    addToAgenda(selfWaitInBox   );
    addToAgenda(selfExitBox     );
    addToAgenda(selfRunNorth    );
    addToAgenda(selfStayNorth   );
    addToAgenda(selfRunFromPc   );
    addToAgenda(selfChasePc     );
    // Without doing this next line, the NPC might be left with
    // no vocabulary.
    transformNpcCq(nil, red);
  }
  //turnsToWaitInBox = (WaitInBox.waitLength) // override as needed
  runNorthAbruptly = nil
  /*
    if (locLst[2] == 0 || !locLst[1].ofKind(Direction)) {
      "here. ";
      return;
    }  
    if (locLst[2] == 1) {
      "immediately to the <<locLst[1].name>>";
    }
  */
  saySuccessfulAttack(opponent) {
    pleaseSay('\^' + theName + ' hits ' + opponent.theName + '! ');
  }
  sayDeadlyAttack(opponent) {
    pleaseSay('\^' + theName + ' hits ' + opponent.theName + '! ');
    pleaseSay('\^' + opponent.theName + ' dies! ');
  }
  // Note to self: This overriding of the sayUnsuccessfulAttack()
  // method appears patently illogical. I have no idea why I did this
  // (several months ago), but I don't want to try to change it now.
  sayUnsuccessfulAttack(opponent) {
    if (isTransformed)
      inherited(opponent);
    else
      saySuccessfulAttack(opponent);
  }
  sayTransform1 {
    local lwrtb = locationWrtBot;
    if (bot.canSee(self)) {
      pleaseSay('<.p>\^');
      if (lwrtb && lwrtb.length && lwrtb[1] && lwrtb[1].ofKind(Direction) && lwrtb[2] > 0) {
        pleaseSay((lwrtb[2] <= 1 ? 'directly' : 'off')
          + ' to the ' + lwrtb[1].name + ', ');
      }
      pleaseSay(theName + ' transforms into ');
    }
    //if (gKey()) {local k=0;k=k/k;}
  }
  sayTransform2 {
    if (bot.canSee(self))
      pleaseSay(aName + '! ');
  }
  roomToGoNorthTo = nil
  killNpc {
    inherited;
    // Whenever a hostile Hac-Man NPC is killed, and no matter how 
    // he is killed, we will want Adam's npcGoal to be nil afterwards. 
    // Same with the bandit's npcGoal.
    adam.npcGoal = nil;
    bandit.npcGoal = nil;
  }
  isPeaceful = (isTransformed ? true : nil)
  sayExists = ('there<./s>s ' + aNameFrom(redNickname))
;

class HacFriend: HacNpc
  npcGoal = nil
  northHowLong = 0
  northPatience = 30
  dobjFor(TalkTo) {
    verify { logicalRank(150, 'hac friend'); }
  }
  //npcGoal {
  //  if (gPlayerChar.location == hacRoomH18)
  //    return dragon;
  //  if (gPlayerChar.location == hacRoomJ18)
  //    return bandit;
  //  return nil;
  //}
  //hasBloodlust = ()
  // Attack or otherwise confront an opponent who is presumably
  // standing in the place where this NPC wants to be.
//  confrontChar(opponent) {
//    local agItem;
//    local shoveAwayFrom;
//    local goWhere;
//    if (opponent.ofKind(HacEnemy)) {
//      return inherited(opponent);
//    }
//    else if (opponent == bot) {
//      //"\^<<theName>> takes a wand of teleportation out of his 
//      //  <<self == adam ? 'parka' : 'cape'>>. "
//      //if (self == adam) {
//      //  "<.q>Robot, you have not yet learned the rules of the road. <./q> ";
//      //}
//      //else {
//      //  "<.q>Forgive Me, Good Sir, but I am in Much Haste! Fare Well!<./q> ";
//      //}
//      
//      // Determine which room to shove the bot to. If 
//      "\^<<theName>> gives your bot a powerful shove! ";
//      if (!bot.location.ofKind(HacJunction)) {
//        for (local a = 1; a <= 4; a++) {
//          if (bot.realLocation.(glob.fourDirList[a]) != nil
//              && bot.realLocation.(glob.fourDirList[a]).ofKind(Room)
//              && bot.realLocation.(glob.fourDirList[a]) != self.realLocation)
//          {
//            nestedActorAction(bot, TravelVia, bot.realLocation.(glob.fourDirList[a]));
//            break;
//          }
//        }
//      }
//      else {
//        agItem = nil;
//        agItem = agendaList.valWhich({x: x.isReady});
//        if (agItem && agItem.ofKind(ChaseNpc))
//          shoveAwayFrom = agItem.targetNpc.realLocation;
//        else if (agItem && agItem.ofKind(GoNearBox))
//          shoveAwayFrom = hacRoomH8;
//        else if (agItem && agItem.ofKind(RunSouth))
//          shoveAwayFrom = hacRoomI18;
//        if (!shoveAwayFrom)
//          shoveAwayFrom = hacRoomH8;
//        goWhere = bot.realLocation.goWhereForRoom(
//          shoveAwayFrom, nil, [self.realLocation], 0);
//        nestedActorAction(bot, TravelVia, bot.realLocation.(goWhere));
//      }
//    }
//    return advance;
//  }
  confrontChar(opponent) {
    local goWhere;
    local destList = [];
    // UNIVERSALIZE (finished)
    //local npcList = [adam, bandit, dragon, copyman];
    local npcList = glob.hacNpcs;
    local leastFavorable;
    if (opponent.ofKind(HacEnemy)) {
      return inherited(opponent);
    }
    else if (opponent == bot) {
      "\^<<theName>> opens his <<cloakName>>
        and removes a wand of teleportation. ";
      if (self != bandit) {
        "<.q>Sorry, but you<./s>re in my way.<./q> ";
      }
      else {
        "<.q>Forgive Me, O Madam, but I am in Haste! 
          Fare Well!<./q> ";
      }
      "\^<<theName>> zaps your bot! ";
      "<.p>";
      for (local cur = firstObj(HacJunction); cur != nil; cur = nextObj(cur,HacJunction)) {
        destList = destList + cur;
      }
      for (;;) {
        // pick a random junction.
        goWhere = rand(destList);
        leastFavorable = 999;
        for (local a = 1; a <= npcList.length; a++) {
          if (npcList[a].realLocation && npcList[a].realLocation.ofKind(HacRoom)) {
            for (local b = 1; b <= 4; b++) {
              if (goWhere.distToRoom(npcList[a].realLocation, b) < leastFavorable)
                leastFavorable = goWhere.distToRoom(npcList[a].realLocation, b);
            }
          }
          // veto this with a zero if it is the actual location
          // of an NPC.
          if (goWhere == npcList[a].realLocation) {
            leastFavorable = 0;
            //pleaseSay('<.p><b><big>The idea of moving to the location of '
            //  + npcList[a].theName + ' is rejected out of hand.</big></b><.p> ');
          }
        }
        if (leastFavorable > 7)
          break;
      }
      gPlayerChar.dirFacing = eastValue;
      gPlayerChar.moveIntoForTravel(goWhere);
      gPlayerChar.lookAround(true); 
      chomp(gPlayerChar.location.hasDotType);
      if (bot.canSee(self))
        "<.p>\^<<theName>> puts the wand of teleportation back in his 
          <<cloakName>>. ";
    }
    return advance;
  }
  protagonistLikelihood = 50
;



// -------------------------------------------------------------------
// HAC-MAN MAZE: NPC STUFF: NPCs (and attendant PC modifications)
// -------------------------------------------------------------------

modify bot
  confrontChar(opponent) {
    if (opponent.ofKind(HacEnemy)) {
      startMelee(opponent);
      // If we're still alive after the melee is done, 
      // then we defeated the enemy and we may proceed.
      return advance;
    }
    else { // Otherwise, the NPC is friendly.
      if (!opponent.curAgendaItem || !opponent.curAgendaItem.ofKind(WaitSouth))
        "\^<<opponent.theName>> blocks your bot<./s>s path. ";
      else
        nestedAction(TalkTo, opponent);
      return halt;
    }
  }
  isCalledByAttacker = 'bot'
  // By authorial fiat, I am saying the bot is very much wimpier 
  // than any Nethack player char.
  meleeDifficulty = 2
  //activateNpc {
  //  addToAgenda(copymanWaitToArrive);
  //  addToAgenda(copymanWaitInBox);
  //  addToAgenda(copymanExitBox);
  //  addToAgenda(copymanRunNorth);
  //  addToAgenda(copymanStayNorth);
  //  addToAgenda(copymanRunFromPc);
  //  addToAgenda(copymanChasePc);
  //}
  meleeStrategy(opponent, perpetrator) {
    // You know what? Just always attack. Ignore the commented-out
    // stuff below; I can put that back in again if I change my mind.
    return attack;
//    // If the bot is attacking the duck or chicken, always attack.
//    if ((opponent == copyman || opponent == dragon) && opponent.isTransformed)
//      return attack;
//    // In the unlikely event that the bot is attacking Adam or the bandit, 
//    // always attack.
//    if (opponent == adam || opponent == bandit)
//      return attack;
//    // Otherwise, presumably the bot is attacking the copyright man
//    // or the dragon. In this case, if the bot is the perpetrator,
//    // keep on fighting. Otherwise, if the bot is not the perpetrator,
//    // just flee.
//    if (perpetrator == self)
//      return attack;
//    else
//      return flee;
  }
  protagonistLikelihood = 100
  saySuccessfulAttack(opponent) {
    pleaseSay('\^' + theName + ' hits ' + opponent.theName + '. ');
    //"\^<<theName>> hits <<opponent.theName>>. ";
  }
  sayDeadlyAttack(opponent) {
    pleaseSay('\^' + theName + ' kills ' + opponent.theName + '! ');
    //"\^<<theName>> kills <<opponent.theName>>! ";
  }
  preferredBanditDestination = 'a Salvage Yard'
  experienceLevel = 1
  experiencePoints = 0
  maxHitPoints = 15
  hitPoints = 15
  turnsDuringHac = 0
  turnsAtHacStartup = 1
  armorClass = (isPowered && glob.poweringEffect ? -3 : 0)
  //hacTurns = 0
  attributes = [
     11 // Strength
    , 6 // Dexterity
    ,13 // Constitution
    ,15 // Intelligence
    , 4 // Wisdom
    ,14 // Charisma
  ]
  hunger = 0
  hungerClass {
    if (hunger > 100) return 4; // "Ravenous"
    if (hunger >  75) return 3; // "Famished"
    if (hunger >  50) return 2; // "Starving"
    if (hunger >  25) return 1; // "Hungry"
    return 0; // not hungry
  }
  // ada adam
  // bal balrog
  // ban bandit
  // bat bat
  // bot me
  // bul bullfrog
  // but butterfly
  // cop copyman
  // chi chicken
  // dov (turtle) dove
  // dra dragon
  // duc duck
  // fro bullfrog
  // me  me
  // tro troll
  // tur (turtle) dove
  syntaxTokens = ['bot','me']
  transTokens = [' ']
  giveFilename {
    switch (dirFacing) {
      case northValue: return 'hacmanN';
      case southValue: return 'hacmanS';
      case westValue:  return 'hacmanW';
      default:         return 'hacmanE';
    }
  }
  doHealing {
    if (hitPoints < maxHitPoints)
      hitPoints++;
  }
;


adam: HacFriend 
  vocabWords = 'adam thornton'
  name = 'Adam Thornton'
  nickname = 'Adam'
  cloakName = 'parka'
  //desc = "It<./s>s Adam! "
  isProperName = true
  isHim = true
  //sayBegone {
  //  if (!hasSaidBegone)
  //    "Much as I<./s>d like to stay and chat, robot, you.
  //      Here, let me teach you.";
  //  else
  //    "What? ";
  //  hasSaidBegone = true
  //}
  helpInstances = 0
  activateNpc {
    npcGoal = nil;
    if (!dragon.isDead) {
      npcGoRoom(self, hacRoomI18);
      //moveIntoForTravel(hacRoomI18);
      addToAgenda(adamAmbushNpc);
      addToAgenda(adamChaseNpc);
      addToAgenda(adamGoNearBox);
      addToAgenda(adamEnterBox);
      addToAgenda(adamRunSouth);
      addToAgenda(adamWaitSouth);
    }
    else {
      //npcGoRoom(self, hacRoomH10);
      //moveIntoForTravel(hacRoomH10);
      addToAgenda(adamWaitToArrive);
      addToAgenda(adamExitBox);
      addToAgenda(adamRunSouth);
      addToAgenda(adamWaitSouth);
    }
  }
  isCalledByAttacker = 'man'
  // Conceptually, Adam could kick the bandit's ass in a fight.
  // He can also kill a dragon.
  meleeDifficulty = 26
  experienceLevel = 20
  maxHitPoints = 131
  armorClass = 2
  alignment = 'neutral'
  // Adam always attacks
  meleeStrategy(opponent, perpetrator) {
    return attack;
  }
  protagonistLikelihood = 80
  saySuccessfulAttack(opponent) {
    // "smites/hits/lands a solid blow against" here is because Adam 
    // supposedly has an axe.
    pleaseSay('\^' + theName + ' ' 
      + rand('smites','hits','slashes at') 
      + ' ' + opponent.theName + '. ');
    //"\^<<theName>> 
    //  <<rand('smites','hits','slashes at')>> 
    //  <<opponent.theName>>. ";
  }
  sayDeadlyAttack(opponent) {
    pleaseSay('\^' + theName + ' kills ' + opponent.theName + '! ');
    //"\^<<theName>> kills <<opponent.theName>>! ";
  }
  tauntObj(opponent) {
    if (opponent == dragon && !opponent.isTransformed)
      return adamTauntsDragon;
    // Yes, Adam will even taunt ducks and chickens if he attacks them.
    else
      return adamTaunts;
  }
  // ada adam
  // bal balrog
  // ban bandit
  // bat bat
  // bot me
  // bul bullfrog
  // but butterfly
  // cop copyman
  // chi chicken
  // dov (turtle) dove
  // dra dragon
  // duc duck
  // fro bullfrog
  // me  me
  // tro troll
  // tur (turtle) dove
  syntaxTokens = ['adam']
  giveFilename {
    if (location != hacRoomH9)
      return 'adam';
    return 'adam2';
  }
;

bandit: HacFriend
  vocabWords = 'bandit/bandito'
  name = 'bandit'
  cloakName = 'cape'
  isHim = true
  activateNpc {
    if (hasBeenActivated) return;
    pleaseSay('<.p>Bandit is being activated.<.p>');
    npcGoal = copyman;
    addToAgenda(banditWaitToArrive);
    addToAgenda(banditExitBox);
    addToAgenda(banditAmbushNpc);
    addToAgenda(banditChaseNpc);
    addToAgenda(banditGoNearBox);
    addToAgenda(banditEnterBox);
    hasBeenActivated = true;
  }
  hasBeenActivated = nil
  wandName = 'wand of micturition'
  isCalledByAttacker = 'rogue'
  // By authorial fiat, I am declaring that Adam and the bandit 
  // are stronger than a dragon.
  meleeDifficulty = 25
  experienceLevel = 20
  maxHitPoints = 131
  armorClass = 2
  alignment = 'chaotic'
  // The bandit generally just attacks, unless he encounters the 
  // copyright man, in which case he pulls out his secret weapon.
  meleeStrategy(opponent, perpetrator) {
    if (opponent == copyman && !copyman.isTransformed)
      return piss;
    else
      return attack;
  }
  protagonistLikelihood = 75
  saySuccessfulAttack(opponent) {
    // "smites/stabs/pierces" here is because the bandit supposedly
    // has a rapier.
    pleaseSay('\^' + theName + ' ' 
      + rand('smites','stabs','pierces') 
      + ' ' + opponent.theName + '. ');
    //"\^<<theName>> 
    //  <<rand('smites','stabs','pierces')>> 
    //  <<opponent.theName>>. ";
  }
  sayDeadlyAttack(opponent) {
    pleaseSay('\^' + theName + ' kills ' + opponent.theName + '! ');
    //"\^<<theName>> kills <<opponent.theName>>! ";
  }
  tauntObj(opponent) {
    return banditTaunts;
  }
  // ada adam
  // bal balrog
  // ban bandit
  // bat bat
  // bot me
  // bul bullfrog
  // but butterfly
  // cop copyman
  // chi chicken
  // dov (turtle) dove
  // dra dragon
  // duc duck
  // fro bullfrog
  // me  me
  // tro troll
  // tur (turtle) dove
  syntaxTokens = ['bandit']
  giveFilename {
    if (location != hacRoomH9)
      return 'bandit';
    return 'bandit2';
  }
;

dragon: HacEnemy
  //vocabWords = 'red blue white dragon/duck' 
  redVocabWords = 'red dragon beast animal reptile serpent'
  blueVocabWords = 'blue duck bird animal'
  whiteVocabWords = 'white duck bird animal'
  //name {
  //  if (!isTransformed)
  //    return 'red dragon';
  //  else if (!isWhite)
  //    return 'blue duck';
  //  else
  //    return 'white duck';
  //}
  //nickname {
  //  if (isTransformed)
  //    return 'duck';
  //  else
  //    return 'dragon';
  //}
  redName = 'red dragon'
  blueName = 'blue duck'
  whiteName = 'white duck'
  redNickname = 'dragon'
  blueNickname = 'duck'
  whiteNickname = 'duck'
  postureWord = (isTransformed ? 'squatting' : 'standing')
  priority = 100
  //killNpc {
  //  inherited;
  //  copyman.activateNpc;
  //}
  //desc = "The dragon looks angry! "
  //activateNpc {
  //  //moveIntoForTravel(hacRoomH10);
  //  npcGoRoom(self, hacRoomH10);
  //  //addToAgenda(dragonWaitToArrive);
  //  addToAgenda(dragonWaitInBox);
  //  addToAgenda(dragonExitBox);
  //  addToAgenda(dragonRunNorth);
  //  addToAgenda(dragonStayNorth);
  //  addToAgenda(dragonRunFromPc);
  //  addToAgenda(dragonChasePc);
  //}
  //successor {
  //  return troll;
  //  //if (adamThorntonM.isInExe)
  //  //  return copyman;
  //  //else
  //  //  return nil;
  //}
  informAdamTopic = informAdamDragon
  isCalledByAttacker = (isTransformed ? 'bird' : 'beast')
  // The duck has the same difficulty as a Nethack newt.
  // The red dragon has difficulty equal to what it has in Nethack.
  meleeDifficulty = (isTransformed ? 1 : 20)
  experienceLevel = ( isTransformed ? 0 : 15)
  maxHitPoints = (isTransformed ? 1 : 93)
  armorClass = (isTransformed ? 10 : -1)
  alignment = (isTransformed ? 'neutral' : 'chaotic')
  meleeStrategy(opponent, perpetrator) {
    // The duck's melee strategy: if the duck perpetrated the
    // fight, then keep attacking until dead. Otherwise, attack once,
    // then try to flee.
    if (isTransformed) {
      return attackOnceThenFlee;
      //if (perpetrator == self)
      //  return attack;
      //else
      //  return attackOnceThenFlee;
    }
    // The dragon's melee strategy: always attack.
    else {
      return attack;
    }
  }
  saySuccessfulAttack(opponent) {
    if (isTransformed) {
      pleaseSay('\^' + theName + ' pecks! ');
      //pleaseSay('\^' + theName + ' pecks at ' + opponent.theName + '. ');
      //"\^<<theName>> pecks at <<opponent.theName>>. ";
    }
    else {
      pleaseSay('\^' + theName + ' breathes fire! ');
      //"\^<<theName>> breathes fire! ";
      if (opponent == adam || opponent == bandit)
        pleaseSay('\^' + opponent.theName + ' seems unaffected 
          by the fire. ');
        //"\^<<opponent.theName>> seems unaffected by the fire. ";
    }
  }
  sayDeadlyAttack(opponent) {
    if (isTransformed)
      inherited(opponent);
    else
      pleaseSay('\^' + theName + ' breathes fire! 
        \^' + opponent.theName + ' dies! ');
      //"\^<<theName>> breathes fire! \^<<opponent.theName>> dies! ";
  }
  protagonistLikelihood = 10
  preferredBanditDestination = (isTransformed ? 'a Farmstead' : 'a Manure Pile')
  // ada adam
  // bal balrog
  // ban bandit
  // bat bat
  // bot me
  // bul bullfrog
  // but butterfly
  // cop copyman
  // chi chicken
  // dov (turtle) dove
  // dra dragon
  // duc duck
  // fro bullfrog
  // me  me
  // tro troll
  // tur (turtle) dove
  syntaxTokens = ['dragon']
  transTokens = ['duck']
  giveFilename {
    if (location == hacRoomH9)
      return 'dragon2';
    if (!isTransformed)
      return 'dragon';
    if (!isWhite)
      return 'duck';
    return 'duck2';
  }
;

copyman: HacEnemy
  //vocabWords = 'blue white red copyman copyright man/chicken'
  redVocabWords = 'red copyright copy copyman man'
  blueVocabWords = 'blue chicken bird animal'
  whiteVocabWords = 'white chicken bird animal'
  //name {
  //  if (!isTransformed)
  //    return 'copyright man';
  //  else if (!isWhite)
  //    return 'blue chicken';
  //  else
  //    return 'white chicken';
  //}
  //nickname {
  //  if (isTransformed)
  //    return 'chicken';
  //  else
  //    return inherited;
  //}
  redName = 'copyright man'
  blueName = 'blue chicken'
  whiteName = 'white chicken'
  redNickname = 'copyright man'
  blueNickname = 'chicken'
  whiteNickname = 'chicken'
  //postureWord = (isTransformed ? 'standing' : 'standing')
  priority = 200
  isHim = true
  //activateNpc {
  //  addToAgenda(copymanWaitToArrive);
  //  addToAgenda(copymanWaitInBox);
  //  addToAgenda(copymanExitBox);
  //  addToAgenda(copymanRunNorth);
  //  addToAgenda(copymanStayNorth);
  //  addToAgenda(copymanRunFromPc);
  //  addToAgenda(copymanChasePc);
  //}
  
  clothingPhrase = 'suit coat'
  informAdamTopic = informAdamCopyman
  sayExists = 'there<./s>s some kind of copyright man'
  isCalledByAttacker = (isTransformed ? 'bird' : 'knave')
  // The chicken has the same difficulty as a Nethack newt.
  // The copyright man has difficulty equal to a shopkeeper,
  // a standard bad-ass humanoid in Nethack.
  meleeDifficulty = (isTransformed ? 1 : 15)
  experienceLevel = (isTransformed ? 0 : 12)
  maxHitPoints = (isTransformed ? 1 : 72)
  armorClass = (isTransformed ? 10 : 3)
  alignment = (isTransformed ? 'neutral' : 'lawful')
  meleeStrategy(opponent, perpetrator) {
    // The chicken's melee strategy: if the chicken perpetrated the
    // fight, then keep attacking until dead. Otherwise, attack once,
    // then try to flee.
    if (isTransformed) {
      return attackOnceThenFlee;
      //if (perpetrator == self)
      //  return attack;
      //else
      //  return attackOnceThenFlee;
    }
    // The copyright man's melee strategy: always attack, unless
    // under the spell of the bandit.
    else {
      if (opponent == bandit)
        return getPissedUpon;
      else
        return attack;
    }
  }
  protagonistLikelihood = 10
  saySuccessfulAttack(opponent) {
    if (isTransformed) {
      pleaseSay('\^' + theName + ' pecks! ');
      //pleaseSay('\^' + theName + ' pecks at ' + opponent.theName + '. ');
      //"\^<<theName>> pecks at <<opponent.theName>>. ";
    }
    else {
      pleaseSay('\^' + theName + ' blasts his flamethrower! ');
      //"\^<<theName>> blasts his flamethrower! ";
      if (opponent == adam || opponent == bandit)
        pleaseSay('\^' + opponent.theName + ' seems unaffected 
          by the fire. ');
        //"\^<<opponent.theName>> seems unaffected by the fire. ";
    }
  }
  sayDeadlyAttack(opponent) {
    if (isTransformed)
      inherited(opponent);
    else
      pleaseSay('\^' + theName + ' blasts his flamethrower! 
        \^' + opponent.theName + ' dies! ');
      //"\^<<theName>> blasts his flamethrower! \^<<opponent.theName>> dies! ";
  }
  doTaunt(opponent) {
    // Never let the copyman do the taunt if he's transformed 
    // into a chicken, and never if his opponent is the bandit.
    if (!isTransformed && opponent != bandit)
      inherited(opponent);
  }
  tauntObj(opponent) {
    if (isTransformed)
      return nil;
    //else
    //  return copymanTaunts;
    else if (opponent == bot)
      return winningCopymanTaunts;
    else
      return nil; //losingCopymanTaunts;
  }
  preferredBanditDestination = (isTransformed ? 'a Farmstead' : 'a Manure Pile')
  // A pseudodaemon. If it is appropriate for the copyright man
  // to gripe, let him do so.
  gripeDaemon {
    local copyDir = copyman.locationWrtBot;
    local copyDist = copyDir[2];
    local gripeVal = 0;
    local gripeList = [
       [1,3] // Gripe at multiples of 1 three times
      ,[2,1] // Gripe at multiples of 2 once
      ,[3,2] // Gripe at multiples of 3 twice
      ,[5,2] // Gripe at multiples of 5 twice
      ,[7,9999999] // Thereafter, gripe at multiples of 7
    ];
    copyDir = copyDir[1];
    if (!realLocation || !realLocation.ofKind(HacRoom) ||
        realLocation is in (hacRoomH9, hacRoomH10) ||
        isTransformed) {
      return;
    }
    gripeCount++;
    gripeVal = gripeCount;
    for (local a = 1; a <= gripeList.length; a++) {
      if (gripeVal <= gripeList[a][1] * gripeList[a][2]) {
        if (gripeVal % gripeList[a][1] == 0) {
          doGripe(copyDir, copyDist);
        }
        break;
      }
      else {
        gripeVal = gripeVal - (gripeList[a][1] * gripeList[a][2]);
      }
    }
  }
  doGripe(copyDir, copyDist) {
    local s = 's';
    if (copyDist == 0) {
      "<.p>The copyright man ";
    }
    else if (!(copyDir is in (northDirection, southDirection,
        eastDirection, westDirection))) {
      "<.p>From elsewhere in the maze, your bot hears 
        someone ";
      s = '';
    }
    else {
      "<.p><<copyDist == 1 ? 'Directly' : 'Down the hallway'>>
        to the <<copyDir.name>>, the copyright man ";
    }
    "say<<s>>, ";
    gripesUttered++;
    switch (gripesUttered) {
      case 1:
        "<.q>The copyright man, goin<./s> through 
            the pink gate.<./q> ";
        break;
      case 2:
        "<.q>The copyright man, firin<./s> up the old tablet device.<./q> ";
        if (copyDir) {
          "With that, the copyright man removes an electronic 
            device from his suit coat, pushes a few buttons, 
            and nods. ";
        }
        else {
          "Some beeps come from down the hallway. 
            Then the voice continues. ";
        }
        "<.q>Just as the copyright man suspected! Another 
            person playin<./s> this game without a registration 
            code! A human, too! A human named Gary Randall!<./q> ";
        if (copyDir) {
          "With that, he puts the device back in his suit coat. ";
        }
        if (bcIntro.isOn) {
          "<p><.q>Wow, you<./s>re a human?<./q> Sheila exclaims. 
              <.q>I didn<./s>t know that!<./q> 
            <p><.q>Er, yes,<./q> you say. <.q>I<./s>d been meaning 
              to introduce myself. My name<./s>s Gary, and 
              I<./s>m a human.<./q> ";
          me.suspectedByBot = true;
          me.knownByBot = true;
          bcIntro.isOn = nil;
        }
        copyman.hasBeenSeen = true;
        break;
      case 3:
        "<.q>The Garymeister, playin<./s> without a registration 
          code! Gary von Randolph! Probably a software pirate!<./q> ";
        break;
      default:
        say(cyclicGripeList[gripesUttered - 3]);
        if (gripesUttered == cyclicGripeList.length + 3)
          gripesUttered = 3;
        break;
    }
  }
  cyclicGripeList = [
     '<.q>Ga-ryyyy! The software pirate! Makin<./s> copies 
       of every game in sight!<./q> '
    ,'<.q>Captain One-Eyed Gary of the ghost ship Grayware! 
       Pirate on the high seas!<./q> '
    ,'<.q>The Garymatic 3000! Makin<./s> perfect copies 
       every time!<./q> '
    ,'<.q>President James A. Garyfield! Promising to make 
       more copies! For you and for your children!<./q> '
    ,'<.q>Garyopolis: the capital of Makincopiestan!<./q> '
    ,'<.q>Garyholics Anonymous! Addicted to software piracy!<./q> '
    ,'<.q>The Great Garyrino! Watch as he makes copies 
       while doing somersaults!<./q> '
    ,'<.q>Wing Commander Gary Randall of the 82nd 
       Copying Division!<./q> '
    ,'<.q>Gary von Randolph, the official copyist 
       of the Austro-Hungarian Empire!<./q> '
    ,'<.q>It<./s>s Super-Gary! Copying software 
       in a single bound!<./q> '
    ,'<.q>Gary <.s>Two-Disk<./s> Randowski, a.k.a. <.s>The 
       Copier.<./s> A guy who knows how to get things done!<./q> '
    ,'<.q>The one and only Garymeister! Always 
       makin<./s> copies!<./q> '
  ]
  gripeCount = 0
  gripesUttered = 0
  //gripeListElement = 1
  // ada adam
  // bal balrog
  // ban bandit
  // bat bat
  // bot me
  // bul bullfrog
  // but butterfly
  // cop copyman
  // chi chicken
  // dov (turtle) dove
  // dra dragon
  // duc duck
  // fro bullfrog
  // me  me
  // tro troll
  // tur (turtle) dove
  syntaxTokens = ['copyman']
  transTokens = ['chicken']
  giveFilename {
    if (location == hacRoomH9)
      return 'copyman2';
    if (!isTransformed)
      return 'copyman';
    if (!isWhite)
      return 'chicken';
    return 'chicken2';
  }
;

troll: HacEnemy
  // NAME/DESCRIPTION STUFF
  //vocabWords = ''
  redVocabWords = 'red internet troll beast animal'
  blueVocabWords = 'blue turkey bird animal'
  whiteVocabWords = 'white turkey bird animal'
  redName = 'Internet troll'
  blueName = 'blue turkey'
  whiteName = 'white turkey'
  redNickname = 'troll'
  blueNickname = 'turkey'
  whiteNickname = 'turkey'
  //pluralNickname = pluralNameFrom(nickname)
  isCalledByAttacker = (isTransformed ? 'bird' : 'beast')
  //preferredBanditDestination = 'a Farmstead'
  //sayExists = ('there<./s>s ' + aNameFrom(redNickname))
  //isHim = nil
  //isProperName = nil
  //postureWord = (isTransformed ? 'standing' : 'standing')
  // syntaxTokens and transTokens are used only when doing
  // the debugging verb "melee".
  syntaxTokens = ['troll']
  transTokens = ['turkey']
  
  // MISC. DATA
  //successor = nil
  //priority = 99999 // override
  informAdamTopic = informAdamTroll
  //runNorthAbruptly = nil // presumably true only for the copyman
  //tauntObj(opponent) {
  //  if (opponent == bot && !isTransformed)
  //    return trollTaunts;
  //  else
  //    return nil;
  //}
  //transformNpcCq(clr1, clr2) { inherited(clr1, clr2); } // if, e.g., transforming to a different color implies a change in isProperName, then say so here.
  //protagonistLikelihood = 10 // an enemy
  
  // NETHACK STATS
  meleeDifficulty = (isTransformed ? 1 : 12)
  experienceLevel = (isTransformed ? 0 : 13)
  alignment = (isTransformed ? 'neutral' : 'chaotic')
  maxHitPoints = (isTransformed ? 1 : 93)
  armorClass = (isTransformed ? 10 : 0)
  isPeaceful = (isTransformed ? true : nil) // for statusDesc.
  
  // FIGHTING MECHANICS
  meleeStrategy(opponent, perpetrator) {
    if (isTransformed)
      return attackOnceThenFlee;
    else
      return attack;
  }
  saySuccessfulAttack(opponent) {
    if (isTransformed) {
      pleaseSay('\^' + theName + ' pecks! ');
      //pleaseSay('\^' + theName + ' pecks at ' + opponent.theName + '. ');
    }
    // Important: unlike other NPCs, who taunt *in addition to*
    // doing physical attacks, the troll taunts *in lieu of*
    // doing physical attacks. As with the cruel puppet in Beyond Zork,
    // the taunting itself is what does the damage.
    // 
    // Since the threats are custom-tailored to the bot,
    // make sure, as a fail-safe, that they are never targeted at
    // any other opponent but the bot.
    else if (opponent == bot) { // note: not transformed
      trollTaunts.doScript;
      pleaseSay('Your bot recoils in shock! ');
    }
    else {
      //pleaseSay('\^' + theName + ' ' + rand('hits! ','bites! ','misses. '));
      //pleaseSay('\^' + theName + ' ' + rand('hits! ','bites! ','misses. '));
      pleaseSay('\^' + theName + ' ' + rand('hits','bites') + '! ');
    }
  }
  //sayUnsuccessfulAttack(opponent) {
  //  if (isTransformed)
  //    inherited(opponent);
  //  else
  //    saySuccessfulAttack(opponent);
  //}
  sayDeadlyAttack(opponent) {
    if (isTransformed)
      inherited(opponent);
    else
      pleaseSay('\^' + theName + ' ' + rand('hits','bites') + '! '
        + '\^' + opponent.theName + ' dies! ');
  }
  // FILENAME FOR MAP:
  giveFilename {
    if (location == hacRoomH9)
      return 'troll2';
    if (!isTransformed)
      return 'troll';
    // 'turtle' and 'turtle2' are relic of when this was supposed to be 
    // a turtle dove.
    if (!isWhite)
      return 'turtle'; 
    return 'turtle2';
  }
;

balrog: HacEnemy
  // NAME/DESCRIPTION STUFF
  //vocabWords = ''
  redVocabWords = 'red balrog demon daemon beast'
  blueVocabWords = 'blue bull frog bullfrog amphibian animal'
  whiteVocabWords = 'white albino bull frog bullfrog amphibian animal'
  // I previously thought balrog was capitalized and a proper name.
  // Replaying NetHack confirms the opposite. It is improper and 
  // uncapitalized: "The balrog hits!"
  redName = 'balrog'
  blueName = 'blue bullfrog'
  whiteName = 'white bullfrog'
  //redNickname = (redName)
  blueNickname = 'bullfrog'
  whiteNickname = 'bullfrog'
  //pluralNickname = pluralNameFrom(nickname)
  isCalledByAttacker = (isTransformed ? 'frog' : 'demon')
  preferredBanditDestination = (isTransformed ? 'a Farmstead' : 'a Hell-Hole')
  //sayExists = ('there<./s>s ' + aNameFrom(redNickname))
  //isHim = nil
  //isProperName = nil
  // syntaxTokens and transTokens are used only when doing
  // the debugging verb "melee".
  postureWord = (isTransformed ? 'squatting' : 'standing')
  syntaxTokens = ['balrog'] // override with a noun(s), used only when doing the debugging verb "melee."
  transTokens = ['bullfrog','frog'] // override with a noun(s) for transformed (weakened) state, used only when doing the debugging verb "melee."
  
  // MISC. DATA
  //successor = nil // Do not override this
  //priority = 99999
  informAdamTopic = informAdamBalrog
  //runNorthAbruptly = nil // presumably true only for the copyman
  //tauntObj(opponent) { return nil; }
  //transformNpcCq(clr1, clr2) { inherited(clr1, clr2); } // if, e.g., transforming to a different color implies a change in isProperName, then say so here.
  //protagonistLikelihood = 10 // an enemy
  
  // NETHACK STATS
  // Nethack says a balrog's difficulty is 20, the same is true of dragons,
  // but theoretically a Balrog is tougher than a dragon, so we budge
  // it upwards.
  meleeDifficulty = (isTransformed ? 1 : 21) 
  experienceLevel = (isTransformed ? 0 : 24)
  alignment = (isTransformed ? 'neutral' : 'chaotic')
  maxHitPoints = (isTransformed ? 1 : 117)
  armorClass = (isTransformed ? 10 : -2)
  isPeaceful = (isTransformed ? true : nil) // for statusDesc.
  
  // FIGHTING MECHANICS
  meleeStrategy(opponent, perpetrator) {
    if (isTransformed)
      return attackOnceThenFlee;
    else
      return attack;
  }
  saySuccessfulAttack(opponent) {
    if (isTransformed) {
      pleaseSay('\^' + theName + ' bites! ');
    }
    else {
      pleaseSay('\^' + theName + ' hits! ');
      pleaseSay('\^' + theName + ' hits! ');
    }
  }
  //sayUnsuccessfulAttack(opponent) {
  //  if (isTransformed)
  //    inherited(opponent);
  //  else
  //    saySuccessfulAttack(opponent);
  //}
  sayDeadlyAttack(opponent) {
    if (isTransformed)
      inherited(opponent);
    else
      pleaseSay('\^' + theName + ' hits! 
        \^' + theName + ' hits! 
        \^' + opponent.theName + ' dies! ');
  }
  
  // FILENAME FOR MAP:
  giveFilename {
    if (location == hacRoomH9)
      return 'balrog2';
    if (!isTransformed)
      return 'balrog';
    if (!isWhite)
      return 'bullfrog';
    return 'bullfrog2';
  }
;

bat: HacEnemy
  // NAME/DESCRIPTION STUFF
  //vocabWords = ''
  redVocabWords = 'red giant bat beast animal'
  blueVocabWords = 'blue morpho menelaus butterfly insect animal'
  whiteVocabWords = 'white large pieris brassicae butterfly insect animal'
  redName = 'giant bat'
  blueName = (butterflyIdM.isInExe ? 'Blue Morpho butterfly' : 'blue butterfly')
  whiteName = (butterflyIdM.isInExe ? 'Large White butterfly' : 'white butterfly')
  redNickname = 'bat'
  blueNickname = 'butterfly'
  whiteNickname = 'butterfly'
  //pluralNickname = pluralNameFrom(nickname)
  isCalledByAttacker = (isTransformed ? 'beast' : 'beast')
  //preferredBanditDestination = 'a Farmstead'
  //sayExists = ('there<./s>s ' + aNameFrom(redNickname))
  postureWord = (isTransformed ? 'hovering' : 'hovering')
  //isHim = nil
  //isProperName = nil
  // syntaxTokens and transTokens are used only when doing
  // the debugging verb "melee".
  syntaxTokens = [' '] // override with a noun(s), used only when doing the debugging verb "melee."
  transTokens = [' '] // override with a noun(s) for transformed (weakened) state, used only when doing the debugging verb "melee."
  scientificName {
    if (!isTransformed || !butterflyIdM.isInExe)
      return nil;
    if (isWhite)
      return 'Pieris brassicae';
    else // blue
      return 'Morpho menelaus';
  }
  sayTransform2 {
    if (bot.canSee(self))
      pleaseSay(aName 
        + (scientificName ? ' (<i>' + scientificName + '</i>)' : '') 
        + '! ');
  }
  
  // MISC. DATA
  //successor = nil // Do not override this
  //priority = 99999
  informAdamTopic = informAdamBat
  //runNorthAbruptly = nil // presumably true only for the copyman
  //tauntObj(opponent) { return nil; }
  //transformNpcCq(clr1, clr2) { inherited(clr1, clr2); } // if, e.g., transforming to a different color implies a change in isProperName, then say so here.
  //protagonistLikelihood = 10 // an enemy
  
  // NETHACK STATS
  meleeDifficulty = (isTransformed ? 1 : 6)
  experienceLevel = (isTransformed ? 0 : 5)
  alignment = (isTransformed ? 'neutral' : 'neutral')
  maxHitPoints = (isTransformed ? 1 : 23)
  armorClass = (isTransformed ? 10 : 7)
  isPeaceful = (isTransformed ? true : nil) // for statusDesc.
  
  // FIGHTING MECHANICS
  meleeStrategy(opponent, perpetrator) {
    if (isTransformed)
      return attackOnceThenFlee;
    else
      return attack;
  }
  saySuccessfulAttack(opponent) {
    if (isTransformed) {
      pleaseSay('\^' + theName + ' bites! ');
    }
    else {
      pleaseSay('\^' + theName + ' bites! ');
      pleaseSay('\^' + theName + ' bites! ');
    }
  }
  //sayUnsuccessfulAttack(opponent) {
  //  if (isTransformed)
  //    inherited(opponent);
  //  else
  //    saySuccessfulAttack(opponent);
  //}
  sayDeadlyAttack(opponent) {
    if (isTransformed)
      inherited(opponent);
    else
      pleaseSay('\^' + theName + ' bites! 
        \^' + theName + ' bites! 
        \^' + opponent.theName + ' dies! ');
  }
  
  // FILENAME FOR MAP:
  giveFilename {
    if (location == hacRoomH9)
      return 'bat2';
    if (!isTransformed)
      return 'bat';
    if (!isWhite)
      return 'butterfly';
    return 'butterfly2';
  }
;

naga: HacEnemy
  // NAME/DESCRIPTION STUFF
  //vocabWords = ''
  redVocabWords = 'red naga serpent snake beast animal'
  blueVocabWords = 'blue nightingale bird animal'
  whiteVocabWords = 'white nightingale bird animal'
  redName = 'red naga'
  blueName = 'blue nightingale'
  whiteName = 'white nightingale'
  redNickname = 'naga'
  blueNickname = 'nightingale'
  whiteNickname = 'nightingale'
  //pluralNickname = pluralNameFrom(nickname)
  isCalledByAttacker = (isTransformed ? 'bird' : 'beast')
  //preferredBanditDestination = 'a Farmstead'
  //sayExists = ('there<./s>s ' + aNameFrom(redNickname))
  //isHim = nil
  //isProperName = nil
  // Apparently nagas have no legs, so they can hardly "stand"
  postureWord = (isTransformed ? 'standing' : 'crouching')
  // syntaxTokens and transTokens are used only when doing
  // the debugging verb "melee".
  syntaxTokens = ['naga'] // override with a noun(s), used only when doing the debugging verb "melee."
  transTokens = ['nightingale'] // override with a noun(s) for transformed (weakened) state, used only when doing the debugging verb "melee."
  
  // MISC. DATA
  //successor = nil // Do not override this
  //priority = 99999
  //informAdamTopic = informAdamDefault
  //runNorthAbruptly = nil // presumably true only for the copyman
  //tauntObj(opponent) { return nil; }
  //transformNpcCq(clr1, clr2) { inherited(clr1, clr2); } // if, e.g., transforming to a different color implies a change in isProperName, then say so here.
  //protagonistLikelihood = 10 // an enemy
  
  // NETHACK STATS
  meleeDifficulty = (isTransformed ? 1 : 8)
  experienceLevel = (isTransformed ? 0 : 9)
  alignment = (isTransformed ? 'neutral' : 'chaotic')
  maxHitPoints = (isTransformed ? 1 : 47)
  armorClass = (isTransformed ? 10 : 4)
  isPeaceful = (isTransformed ? true : nil) // for statusDesc.
  
  // FIGHTING MECHANICS
  meleeStrategy(opponent, perpetrator) {
    if (isTransformed)
      return attackOnceThenFlee;
    else
      return attack;
  }
  saySuccessfulAttack(opponent) {
    if (isTransformed) {
      pleaseSay('\^' + theName + ' pecks! ');
      //pleaseSay('\^' + theName + ' pecks at ' + opponent.theName + '. ');
    }
    else {
      pleaseSay('\^' + theName + ' bites! ');
    }
  }
  //sayUnsuccessfulAttack(opponent) {
  //  if (isTransformed)
  //    inherited(opponent);
  //  else
  //    saySuccessfulAttack(opponent);
  //}
  sayDeadlyAttack(opponent) {
    if (isTransformed)
      inherited(opponent);
    else
      pleaseSay('\^' + theName + ' bites! 
        \^' + opponent.theName + ' dies! ');
  }
  
  // FILENAME FOR MAP:
  giveFilename {
    if (location == hacRoomH9)
      return 'naga2';
    if (!isTransformed)
      return 'naga';
    if (!isWhite)
      return 'numbat';
    return 'numbat2';
  }
;

/*
genericHacEnemy: HacEnemy
  // NAME/DESCRIPTION STUFF
  //vocabWords = ''
  redVocabWords = 'red '
  blueVocabWords = 'blue '
  whiteVocabWords = 'white '
  redName = ''
  blueName = ''
  whiteName = ''
  redNickname = (redName)
  blueNickname = (blueName)
  whiteNickname = (whiteName)
  //pluralNickname = pluralNameFrom(nickname)
  isCalledByAttacker = (isTransformed ? 'beast' : 'beast')
  //preferredBanditDestination = 'a Farmstead'
  //sayExists = ('there<./s>s ' + aNameFrom(redNickname))
  //isHim = nil
  //isProperName = nil
  //postureWord = (isTransformed ? 'standing' : 'standing')
  // syntaxTokens and transTokens are used only when doing
  // the debugging verb "melee".
  syntaxTokens = [' '] // override with a noun(s), used only when doing the debugging verb "melee."
  transTokens = [' '] // override with a noun(s) for transformed (weakened) state, used only when doing the debugging verb "melee."
  
  // MISC. DATA
  //successor = nil // Do not override this
  //priority = 99999
  //informAdamTopic = informAdamDefault
  //runNorthAbruptly = nil // presumably true only for the copyman
  //tauntObj(opponent) { return nil; }
  //transformNpcCq(clr1, clr2) { inherited(clr1, clr2); } // if, e.g., transforming to a different color implies a change in isProperName, then say so here.
  //protagonistLikelihood = 10 // an enemy
  
  // NETHACK STATS
  meleeDifficulty = (isTransformed ? 1 : 15)
  experienceLevel = (isTransformed ? 0 : 12)
  alignment = (isTransformed ? 'neutral' : 'lawful')
  maxHitPoints = (isTransformed ? 1 : 93)
  armorClass = (isTransformed ? 10 : -1)
  isPeaceful = (isTransformed ? true : nil) // for statusDesc.
  
  // FIGHTING MECHANICS
  meleeStrategy(opponent, perpetrator) {
    if (isTransformed)
      return attackOnceThenFlee;
    else
      return attack;
  }
  saySuccessfulAttack(opponent) {
    if (isTransformed) {
      pleaseSay('\^' + theName + ' pecks! ');
      //pleaseSay('\^' + theName + ' pecks at ' + opponent.theName + '. ');
    }
    else {
      pleaseSay('\^' + theName + ' blasts his flamethrower! ');
      if (opponent == adam || opponent == bandit)
        pleaseSay('\^' + opponent.theName + ' seems unaffected 
          by the fire. ');
    }
  }
  //sayUnsuccessfulAttack(opponent) {
  //  if (isTransformed)
  //    inherited(opponent);
  //  else
  //    saySuccessfulAttack(opponent);
  //}
  sayDeadlyAttack(opponent) {
    if (isTransformed)
      inherited(opponent);
    else
      pleaseSay('\^' + theName + ' blasts his flamethrower! 
        \^' + opponent.theName + ' dies! ');
  }
  
  // FILENAME FOR MAP:
  giveFilename {
    if (location == hacRoomH9)
      return 'badass2';
    if (!isTransformed)
      return 'badass';
    if (!isWhite)
      return 'weanie';
    return 'weanie2';
  }
;
*/

// -------------------------------------------------------------------
// HAC-MAN MAZE: NPC STUFF: ADAM CONVERSATION
// -------------------------------------------------------------------

class EventListALaGreg: object // a mix-in class
  doScriptEvent(evt) {
    switch (dataTypeXlat(evt)) {
    case TypeSString:
      
      
      // START HACK
      pleaseSay(evt);
      //say(evt);
      // END HACK
      
      
      break;
    case TypeObject:
      evt.doScript();
      break;
    case TypeFuncPtr:
      (evt)();
      break;
    case TypeProp:
      self.(evt)();
      break;
    default:
      break;
    }
  }
;

adamTaunts: EventListALaGreg, ShuffledEventList
  [
     '<.q>Bah! Cursed ' + glob.meleeOpponent.isCalledByAttacker + '!
       Take that!<./q> '
    //,'<.q>Die, ' + glob.meleeOpponent.isCalledByAttacker + ',
    //   so I can get back to my beer!<./q> '
    ,'<.q>\^' + glob.meleeOpponent.isCalledByAttacker + ',
       you<./s>re pissing me off almost as much as dragons do.<./q> '
    ,'<.q>Wuss! I bet even a newt could kick your ass.<./q> '
  ]
;

adamTauntsDragon: EventListALaGreg, ShuffledEventList
  [
     '<.q>Dragons--abominations in the nostrils of the divine!<./q> '
    //,'<.q>After I kill this dragon, I<./s>ll set fire to its lair!
    //   And burn its cat too!<./q> '
    //,'<.q>Hanging, drawing, quartering, and kneecapping to all
    //   dragons!<./q> '
    ,'<.q>Hanging, drawing, and quartering to all dragons!<./q> '
    ,'<.q>First I<./s>ll flay you! Then I<./s>ll see if my dogs 
       like dragon meat!<./q> '
    ,'<.q>Go back to <i>Westfront PC</i> where you came from,
       $&*$&#ing dragon!<./q> '
    //,'<.q>If there<./s>s anything I hate more than copyright arguments,
    //   it<./s>s $&*$&#ing dragons!<./q> '
    //,'<.q>Dragons! Dragons! Everywhere, $&*$&#ing dragons!<./q> '
  ]
;

banditTaunts: EventListALaGreg, ShuffledEventList
  [
     '<.q>Nyah! Nyah and Neener!<./q> '
    ,'<.q>As the Skalds of Trondheim would Say, Go Topple
       off a Turret!<./q> '
    ,'<.q>Take That, O You Odious Churl!<./q> '
    ,'<.q>Get Thee to ' + glob.meleeOpponent.preferredBanditDestination 
       + ' in the Wastes of Entre R&iacute;os!<./q> '
    ,'<.q>How ' 
       + (glob.meleeOpponent == copyman && !copyman.isTransformed
         ? 'Taste Your Cheerios' : 'Feel You') + ' Now, ' 
       + (glob.meleeOpponent == bot ? 'Madam' : 'Sir') + '?<./q> '
  ]
;

winningCopymanTaunts: EventListALaGreg, StopEventList
  [
     '<.q>Sheil-o-rama! Soon gonna be in 
       a world of pain!<./q> '
    ,'<.q>Sh-sh-sh-sheila! The robot that fights!
       Chia seeds sold separately!<./q> '
    ,'<.q>The Sheilameister! Does she actually think
       she can defeat the copyright man?<./q> '
    ,'<.q>The Sheilanator! She<./s>s got good armor, 
       but that<./s>s not enough.<./q> '
    ,'<.q>The unfortunate Sheila, knockin<./s> on
       death<./s>s door.<./q> '
  ]
;

losingCopymanTaunts: EventListALaGreg, StopEventList
  [
     '<.q>The copyright man sincerely apologizes!<./q> '
    ,'<.q>The copyright-phile, concerned that he 
       might never be able to gripe about copyright 
       again!<./q> '
    ,'<.q>The copyright-monger, wondering if this
       is what they call a panic attack!<./q> '
    ,'<.q>The copyright-meister, feeling very 
       concerned about the outcome of this fight!<./q> '
    ,'<.q>Dr. Copyright, Ph.D., sincerely praying
       for somebody to help him!<./q> '
  ]
;
// glob.meleeOpponent
copymanTaunts: EventListALaGreg, CyclicEventList
  [
     '<.q>As I have said 20,000 times before, abandonware is a sin!<./q> '
    ,'<.q>Pig-dog of a software pirate, you deserve what you get!<./q> '
    ,'<.q>Your usage of this game violates Section 754(c) of the license agreement!<./q> '
    ,'<.q>Take that, you Home of the Underdogs sympathizer!<./q> '
  ]
;

trollTaunts: EventListALaGreg, ShuffledEventList
  [
     '\^' + troll.theName + ' opines that robots might
       be especially well suited to cleaning outhouses. '
    ,'\^' + troll.theName + ' proposes a variety of
       substances into which your bot might dunk her head. '
    ,'\^' + troll.theName + ' suggests that your bot
       might be a big fan of the Atari 2600 port of Pac-Man. '
    ,'\^' + troll.theName + ' implies that your bot is
       descended from an out-of-repair IBM Selectric typewriter. '
    //,'\^' + troll.theName + ' . '
    //,'\^' + troll.theName + ' . '
    //,'\^' + troll.theName + ' . '
    //,'\^' + troll.theName + ' . '
  ]
;

/*
100  introductionAdamTopic

210  banditAdamTopic
220  dragonsAdamTopic
230  copyrightAdamTopic

310  nethackAdamTopic
320  pacmanAdamTopic
330  alcoholAdamTopic

410  literatureAdamTopic
420  ifAdamTopic
430  gamesAdamTopic
*/
modify adam
  dobjFor(TalkTo) {
    action {
      local curTopic = nil;
      local maxUttered = 0; 
      local minUttered = 99999; 
      // Case 1: Adam is too busy to talk.
      // If Adam is busy doing something, he'll ignore Sheila's
      // attempt at conversation.
      if (!curAgendaItem || !curAgendaItem.ofKind(WaitSouth) || !isCloseEnoughToTalk) {
        talkNoEffect;
        return;
      }
      // Case 2: Introductions.
      // If Sheila hasn't yet introduced herself yet, then
      // let her introduce herself first.
      if (introductionAdamTopic.isEligible) {
        introductionAdamTopic.topicDesc;
        introductionAdamTopic.isEligible = nil;
        return;
      }
      // Case 3: Informing about enemies.
      // If the PC has seen, e.g., the dragon or the copyright man,
      // but has not yet informed Adam about them, then do the 
      // informing now.
      // UNIVERSALIZE (finished)
      for (local a = 1; a <= glob.hacEnemies.length; a++) {
        if (glob.hacEnemies[a].realLocation &&
            glob.hacEnemies[a].hasBeenSeen &&
            !glob.hacEnemies[a].knownByAdam &&
            glob.hacEnemies[a].informAdamTopic != nil) {
          glob.curEnemyForDiscussion = glob.hacEnemies[a];
          glob.hacEnemies[a].informAdamTopic.topicDesc;
          glob.curEnemyForDiscussion = nil;
          glob.hacEnemies[a].knownByAdam = true;
          return;
        }
      }
//      if (dragon.hasBeenSeen && dragon.realLocation) {
//        "Sheila says, <.q>Say, Adam. Did you realize
//            there<./s>s a dragon in this maze?<./q> 
//          <p>Adam Thornton<./s>s eyes go wide, and he cries, 
//            <.q>DRAGONS! DRAGONS! EVRYWHERE, $&*$&#ING DRAGONS!<./q> ";
//        adam.npcGoal = dragon;
//        return;
//        //"Then, muttering something to himself about 
//        //    what he<./s>ll do to the next dragon he sees,
//        //    he ge ";
//        //"<p><.q>DRAGONS! DRAGONS! EVRYWHERE, $&*$&#ING DRAGONS! 
//        //  If I EVER see another game with DRAGON in the title, 
//        //  or about a DRAGON, or that uses the letters 
//        //  D, R, A, G, O, and N, I<./s>m going to set fire 
//        //  to the author<./s>s cat AND give the game 
//        //  a 1 in the COMPETITION!<./q> ";
//      }
//      if (copyman.hasBeenSeen && copyman.realLocation) {
//        "Sheila says, <.q>Say, Adam. Did you realize
//            there<./s>s some kind of copyright man
//            in this maze?<./q> 
//          <p>Adam Thornton thinks for a moment, and he says,
//            <.q>Copyright, did you say? You did the right thing 
//            in coming to me. I know just what to do.<./q> ";
//        adam.npcGoal = bandit;
//        return;
//      }
      // Case 4. Idle chit-chat
      // Otherwise, engage in idle conversation with Adam.
      //
      // As a preliminary step, activate any topics that need activating.
      if (dragon.hasBeenSeen)
        dragonsAdamTopic.isEligible = true;
      if (copyman.hasBeenSeen) {
        copyrightAdamTopic.isEligible = true;
        banditAdamTopic.isEligible = true;
      }
      // Next, set up the topics and eligible Topics
      // lists (the latter of which may need to be updated).
      if (topics.length == 0) {
        for (local cur = firstObj(AdamTopic); cur != nil; 
             cur = nextObj(cur, AdamTopic)) {
          topics += cur;
        }
        topics = topics.sort(nil, {a, b: a.priority - b.priority});
      }
      eligibleTopics = topics.subset({x: x.isEligible});
      // define maxUttered and minUttered
      for (local a = 1; a <= eligibleTopics.length; a++) {
        if (eligibleTopics[a].initiallyEligible &&
            eligibleTopics[a].timesUttered > maxUttered)
          maxUttered = eligibleTopics[a].timesUttered;
        if (eligibleTopics[a].initiallyEligible && 
            !eligibleTopics[a].utterOnlyOnce && 
            eligibleTopics[a].timesUttered < minUttered)
          minUttered = eligibleTopics[a].timesUttered;
      }
      // define current topic
      curTopic = eligibleTopics[
        eligibleTopics.indexWhich({x: x.timesUttered <= minUttered})
      ];
      // say current topic
      curTopic.topicDesc;
      // change timesUttered, etc., to reflect having been uttered
      //
      // In the special case of uttering a not-initially-eligible topic 
      // for the first time, bend over backwards to ensure it won't be 
      // repeated during the next turn.
      if (!curTopic.initiallyEligible && !curTopic.hasBeenUttered)
        curTopic.timesUttered = maxUttered + 1;
      // Otherwise, just accurately update the number of times the topic
      // has been uttered.
      else
        curTopic.timesUttered++;
      curTopic.hasBeenUttered = true;
      if (curTopic.utterOnlyOnce)
        curTopic.isEligible = nil;
    }
  }
  topics = []
  eligibleTopics = []
;
class AdamTopic: object
  topicDesc = "" // override
  priority = 50000 // override
  timesUttered = 0
  isEligible = (initiallyEligible)
  initiallyEligible = true
  utterOnlyOnce = nil
  hasBeenUttered = nil
;
modify glob
  curEnemyForDiscussion = nil
;
//class InformAdamTopic: AdamTopic
//  initiallyEligible = nil
//;




introductionAdamTopic: AdamTopic
  topicDesc =
    "Sheila says to Adam Thornton, 
        <.q>Hi, I<./s>m Sheila. I<./s>m a robot.<./q>
      <p>Adam replies, <.q>Nice to meet you, Sheila. 
        Me? I<./s>m Adam Thornton.
        I grew up in Georgia and now live in St. Louis. 
        I like music, fine literature, and interactive fiction. 
        I even wrote a few games of my own.<./q> "
  priority = 100
  //initiallyEligible = nil // this is a special case
  utterOnlyOnce = true
;

// -----------------
// Note to self: The "inform adam" objects must either
// *not* derive from class AdamTopic, or else if they do
// derive therefrom, they must override initiallyEligible
// to make it nil.
informAdamDragon: object
  topicDesc {
    "Sheila says, <.q>Say, Adam. Did you realize
        there<./s>s a dragon in this maze?<./q> 
      <p>Adam Thornton<./s>s eyes go wide, and he cries, 
        <.q>DRAGONS! DRAGONS! EVRYWHERE, $&*$&#ING DRAGONS!<./q> ";
    adam.npcGoal = dragon;
    adam.helpInstances++;
  }
;
informAdamCopyman: object
  topicDesc {
    "Sheila says, <.q>Say, Adam. Did you realize
        there<./s>s some kind of copyright man
        in this maze?<./q> 
      <p>Adam Thornton thinks for a moment, and he says,
        <.q>Copyright, did you say? You did the right thing 
        in coming to me. I know just what to do.<./q> ";
    adam.npcGoal = bandit;
    adam.helpInstances++;
  }
;
informAdamTroll: object
  topicDesc =
    "Sheila says, <.q>Say, Adam. Did you realize
        there<./s>s a troll in this maze?<./q>
      <p>Adam Thornton replies,
        <.q>Those trolls piss me off 
        nearly as much as dragons do. 
        Still, attacking them doesn<./s>t usually help.
        I generally prefer to ignore them.<./q> "
;
informAdamBalrog: object
  topicDesc =
    "Sheila says, <.q>Say, Adam. Did you realize
        there<./s>s a balrog in this maze?<./q>
      <p>Adam Thornton replies,
        <.q>A balrog? Those guys are pretty badass.
        I<./s>d stay away from them 
        until you think you<./s>re prepared.<./q> "
;
informAdamBat: object
  // replace this if I decide to write something unique here.
  topicDesc { informAdamDefault.topicDesc; }
;
informAdamDefault: object
  topicDesc {
    "Sheila says, <.q>Say, Adam. Did you realize
        <<glob.curEnemyForDiscussion.sayExists>>
        in this maze?
      <p>Adam Thornton replies, <.q>Yeah, those 
        <<glob.curEnemyForDiscussion.pluralRedNickname>>
        really piss me off sometimes. But not so much
        that I feel the need to kill every one.
        Go and kill 
        <<glob.curEnemyForDiscussion.isProperName
          ? glob.curEnemyForDiscussion.redNickname 
          : 'the ' + glob.curEnemyForDiscussion.redNickname>>
        if you want, or else just avoid 
        <<glob.curEnemyForDiscussion.itObj>>,
        that<./s>s my advice.<./q> ";
  }
;
//      if (dragon.hasBeenSeen && dragon.realLocation) {
//        "Sheila says, <.q>Say, Adam. Did you realize
//            there<./s>s a dragon in this maze?<./q> 
//          <p>Adam Thornton<./s>s eyes go wide, and he cries, 
//            <.q>DRAGONS! DRAGONS! EVRYWHERE, $&*$&#ING DRAGONS!<./q> ";
//        adam.npcGoal = dragon;
//        return;
//        //"Then, muttering something to himself about 
//        //    what he<./s>ll do to the next dragon he sees,
//        //    he ge ";
//        //"<p><.q>DRAGONS! DRAGONS! EVRYWHERE, $&*$&#ING DRAGONS! 
//        //  If I EVER see another game with DRAGON in the title, 
//        //  or about a DRAGON, or that uses the letters 
//        //  D, R, A, G, O, and N, I<./s>m going to set fire 
//        //  to the author<./s>s cat AND give the game 
//        //  a 1 in the COMPETITION!<./q> ";
//      }
//      if (copyman.hasBeenSeen && copyman.realLocation) {
//        "Sheila says, <.q>Say, Adam. Did you realize
//            there<./s>s some kind of copyright man
//            in this maze?<./q> 
//          <p>Adam Thornton thinks for a moment, and he says,
//            <.q>Copyright, did you say? You did the right thing 
//            in coming to me. I know just what to do.<./q> ";
//        adam.npcGoal = bandit;
//        return;
//      }





banditAdamTopic: AdamTopic
  topicDesc =
    "Sheila says to Adam Thornton, 
        <.q>Who was that masked man?<./q>
      <p>Adam replies, <.q>I don<./s>t know who you mean.<./q>
      <p>Sheila says, <.q>You know, the bandit.<./q>
      <p>Adam says, <.q>Oh, him.
        I haven<./s>t heard from him in a while. 
        He was off in Spain for a while, 
        tilting at windmills to ease the pain of lost love. 
        Then I got a postcard from somewhere near Elsinore; 
        he<./s>d struck up a friendship with a deranged hermit 
        living in a leaky castle on a bleak and windswept fjord. 
        Said he was going to an Ingrid Bergman 
        and lutefisk festival, or something.<./q> "
  priority = 210
  initiallyEligible = nil // can't talk about this topic till you've learned more
;
dragonsAdamTopic: AdamTopic
  topicDesc =
    "Sheila says to Adam Thornton, 
        <.q>I take it you don<./s>t have much love 
        for dragons.<./q>
      <p>Adam replies,
        <.q>Dragons! Dragons! Everywhere, $&*$&#ing dragons!
        If I EVER see another game with dragon in the title, 
        or about a dragon, or that uses the letters 
        D, R, A, G, O, and N, I<./s>m going to set fire 
        to the author<./s>s cat AND give the game 
        a 1 in the competition!<./q> "
    //"Sheila says to Adam Thornton, 
    //    <.q>I take it you don<./s>t have much love 
    //    for dragons.<./q>
    //  <p>Adam replies,
    //    <.q>Dragons! Dragons! Everywhere, $&*$&#ing dragons!
    //    If I <i>ever</i> see another game with dragon in the title, 
    //    or about a dragon, or that uses the letters 
    //    D, R, A, G, O, and N, I<./s>m going to set fire 
    //    to the author<./s>s cat <i>and</i> give the game 
    //    a 1 in the competition!<./q> "
    //"
    //  <p><i><.q>Dragons! Dragons! Everywhere, $&*$&#ing dragons!</i>
    //    If I <i>ever</i> see another game with <i>dragon</i> in the title, 
    //    or about a <i>dragon,</i> or that uses the letters 
    //    D, R, A, G, O, and N, I<./s>m going to set fire 
    //    to the author<./s>s cat <i>and</i> give the game 
    //    a 1 in the <i>competition!<./q></i> "
    //"
    //  <p><.q>DRAGONS! DRAGONS! EVRYWHERE, $&*$&#ING DRAGONS! 
    //    If I EVER see another game with DRAGON in the title, 
    //    or about a DRAGON, or that uses the letters 
    //    D, R, A, G, O, and N, I<./s>m going to set fire 
    //    to the author<./s>s cat AND give the game 
    //    a 1 in the COMPETITION!<./q> "
  priority = 220
  initiallyEligible = nil // can't talk about this topic till you've learned more
;
copyrightAdamTopic: AdamTopic
  // After asking about copyright:
  topicDesc =
    "Sheila says to Adam Thornton, 
        <.q>Can I ask you a question about that copyright--?<./q>
      <p><.q>No,<./q> says Adam. "
  priority = 230
  initiallyEligible = nil // can't talk about this topic till you've learned more
;
/*
100  introductionAdamTopic

210  banditAdamTopic
220  dragonsAdamTopic
230  copyrightAdamTopic

310  nethackAdamTopic
320  pacmanAdamTopic
330  alcoholAdamTopic

410  literatureAdamTopic
420  ifAdamTopic
430  gamesAdamTopic
*/
nethackAdamTopic: AdamTopic
  topicDesc =
    "Sheila asks Adam Thornton, 
        <.q>What do you think of Nethack?<./q>
      <p>Adam replies, <.q>I<./s>m a terrible Nethack player. 
        I<./s>ve never gotten to the quest. 
        A good game for me is one where I make it 
        to Minetown or the Oracle. I descend too fast, 
        I don<./s>t take the time to carefully identify items, 
        and thus I have short and awful games.<./q> "
  priority = 310
;
pacmanAdamTopic: AdamTopic
  topicDesc =
    "Sheila asks Adam Thornton, 
        <.q>What do you think of Pac-Man?<./q>
      <p>Adam says, 
        <.q>Can Pac-Man make you cry? 
        It<./s>s an honest question. 
        Does that little yellow chomping fellow 
        strike an emotional resonance within you? 
        Can you get choked up about the meaning of a life 
        spent gobbling food dots and power pellets, 
        alternately avoiding and courting 
        Inky, Blinky, Pinky, and Clyde?<./q>
      <p>Then, seeing Sheila<./s>s blank expression,
        he says, <.q>No? Ah well.<./q> "
  priority = 320
;
alcoholAdamTopic: AdamTopic
  topicDesc =
    "Sheila asks Adam Thornton, 
        <.q>What are you drinking?<./q>
      <p>Adam replies, <.q>I have attempted to resurrect the gentle art 
        of the cocktail. I make a mean Manhattan, 
        and I like to experiment with 
        eighteenth-century drink recipes.<./q> "
  priority = 440 //330
  //initiallyEligible = nil // can't talk about this topic till you've learned more
;
literatureAdamTopic: AdamTopic
  topicDesc =
    "Sheila says to Adam Thornton, <.q>You said before that
        you like books and music, right?<./q>
      <p>Adam replies, <.q>I am as much a Tom Waits fanboy as I am 
        a Thomas Pynchon fanboy, and I view the world 
        through lenses of Waits and <i>Gravity<./s>s Rainbow.</i> 
        Which does make it an interesting place to live.<./q> "
  priority = 410
;
ifAdamTopic: AdamTopic
  topicDesc =
    "Sheila asks Adam Thornton, 
        <.q>What do you think of interactive fiction?<./q>
      <p>Adam replies, <.q>I played ADVENT on the PDP-11 
        at the automobile dealership my dad worked at 
        when I was very young and impressionable, 
        in something like 1979. 
        After that it was a slippery slope 
        of Adventure and Zork and the Infocom catalogue 
        and writing BASIC adventures on the Apple II. 
        And then somewhere in college I found AGT 
        and registered TADS 2.0, 
        and then Inform came out, and...<./q> "
  priority = 420
;
gamesAdamTopic: AdamTopic
  topicDesc =
    "Sheila says to Adam Thornton, 
        <.q>You said you wrote some games, right?<./q>
      <p>Adam replies, <.q>I spent a matter of years writing 
        <i>Stiffy Makane: The Undiscovered Country,</i> 
        and likewise my later game, 
        <i>Mentula Macanus: Apocolocyntosis.</i> 
        However, if you<./s>re bothered by vile pornography, 
        you probably shouldn<./s>t play those. 
        Well, there<./s>s always <i>Sins Against Mimesis.<./q></i> "
  priority = 430
;



// -------------------------------------------------------------------
// HAC-MAN MAZE: NPC STUFF: AGENDA ITEMS
// -------------------------------------------------------------------

/*
Here are the agenda items, the NPCs to whom they apply, 
and the agendaOrder value that defines their priority.

             Drag Copy Adam Band
             ---- ---- ---- ----
WaitToArrive        50   50   50
WaitInBox     100  100       
ExitBox       150  150  150  150
RunNorth      400  400       
StayNorth     450  450       
RunFromPc     800  800       
ChasePc      1000 1000       
AmbushNpc               375  375
ChaseNpc                400  400
GoNearBox               300  800
EnterBox                350  850
RunSouth                800  
WaitSouth              1000  
*/

modify glob
  fourDirList = [&north, &east, &south, &west]
;

class HacAgendaItem: AgendaItem
  stupidityFactor = 0
  noAdamHallway() {
    // if NPC is west of Adam's hallway, NPC can't go east
    if (getActor.realLocation == hacRoomF18)
      return 2;
    // if NPC is eest of Adam's hallway, NPC can't go west
    else if (getActor.realLocation == hacRoomL18)
      return 4;
    // otherwise, no prohibitions
    else
      return 0;
  }
  turnAround {
    // If we haven't previously been to another room, then
    // "turning around" has no meaning, so do nothing.
    if (!getActor.previousRoom)
      return;
    // If we're not in a junction, "turning around" is relatively
    // easy. Just make it so the other room you can go to is the 
    // "previousRoom".
    if (!getActor.realLocation.ofKind(HacJunction)) {
      for (local a = 1; a <= 4; a++) {
        if (getActor.realLocation.(glob.fourDirList[a]) != getActor.previousRoom) {
          getActor.previousRoom = getActor.realLocation.(glob.fourDirList[a]);
          break;
        }
      }
      return;
    }
    // If we're at a junction... well, if we're at a junction,
    // then it would be a major hassle to tell the program to 
    // turn around. So don't bother.
  }
  // isWaryOfNpc should only be used with hostile NPCs, when they 
  // are wary of other NPCs. I believe (adam.npcGoal != nil)
  // should work as a defining condition for this.
  isWaryOfNpc {
    if (adam.npcGoal) return true;
    else return nil;
  }
  runToRoom(rm, chasing) {
    //local dirPrp = nil;
    local goWhere = nil;
    local exclDirInt = 0;
    local exclDirInt2 = 0;
    // Under certain freak conditions, rm can be equal to nil.
    // To prevent a run-time error, make sure rm equals something -- 
    // say, hacRoomH8.
    if (!rm)
      rm = hacRoomH8;
    
    //local k;
    //k = inputManager.getKey(nil, nil);
    //if (k.toLower == 'q') { k = 0; k=k/k; }
    
    // If at a junction, look at all the directions except 
    // the one we just came from. Evaluate those directions 
    // according to which is best for pursuing the PC.
    // Then choose either the best direction for pursuing the PC,
    // or else something less than the best, depending on 
    // how stupid the NPC is supposed to be.
    // As a final rule, if Adam Thornton is part of the game, 
    // then never go down the corridor where he usually sits.
    if (getActor.realLocation.ofKind(HacJunction)) {
      // figure out which direction to exclude
      for (local a = 1; a <= 4; a++) {
        if (getActor.realLocation.(glob.fourDirList[a]) == getActor.previousRoom) {
          exclDirInt = a;
          break;
        }
      }
      // Disallow going down Adam's hallway
      if (getActor.ofKind(HacEnemy))
        exclDirInt2 = noAdamHallway;
//if (bot.location == adam.location) { local k=0;k=k/k; }
      goWhere = getActor.realLocation.goWhereForRoom(
        rm, chasing, [exclDirInt, exclDirInt2], stupidityFactor);
      //switch (getActor.realLocation.goWhereToChaseRoom(gPlayerChar.location, 0)) {
      //  case 1: dirPrp = &north; break;
      //  case 2: dirPrp = &east ; break;
      //  case 3: dirPrp = &south; break;
      //  case 4: dirPrp = &west ; break;
      //}
      if (goWhere != nil) {
        hacGoDir(getActor, goWhere);
      }
    }
    // If in one of the rooms behind the pink gate...
    else if (getActor.realLocation is in (hacRoomH9, hacRoomH10)) {
      // If we're already in the room, do nothing.
      if (rm == getActor.realLocation)
        { }
      else if (rm == hacRoomH10) {
        hacGoDir(getActor, &south);
      }
      else {
        hacGoDir(getActor, &north);
      }
    }
    // If not at a junction or in one of the rooms behind the 
    // pink gate, just keep moving ahead.
    else {
      // Look in all four directions. Whichever one goes to the 
      // room we weren't just in, that's the direction to take.
      for (local a = 1; a <= 4; a++) {
        if (getActor.realLocation.(glob.fourDirList[a]) != nil
            && getActor.realLocation.(glob.fourDirList[a]).ofKind(Room)
            && getActor.realLocation.(glob.fourDirList[a]) != getActor.previousRoom)
        {
          hacGoDir(getActor, glob.fourDirList[a]);
          break;
        }
      }
      //if (getActor.realLocation.north != nil 
      //  && getActor.realLocation.north != getActor.previousRoom) {
      //    hacGoDir(getActor, &north);
      //}
      //else if (getActor.realLocation.east != nil 
      //  && getActor.realLocation.east != getActor.previousRoom) {
      //    hacGoDir(getActor, &east);
      //}
      //else if (getActor.realLocation.south != nil 
      //  && getActor.realLocation.south != getActor.previousRoom) {
      //    hacGoDir(getActor, &south);
      //}
      //else if (getAsctor.location.west != nil 
      //  && getActor.realLocation.west != getActor.previousRoom) {
      //    hacGoDir(getActor, &west);
      //}
    }
  }
;

class WaitToArrive: HacAgendaItem // (dragon), copyman, adam, bandit
  agendaOrder = 50
  invokeItem() {
    // Always let each turn count as a waiting turn, *unless*
    // (1) the NPC in question is an enemy, (2) Adam Thornton
    // is in the game, AND (3) Adam Thornton is not in his usual
    // location. If all three of those conditions are true, then
    // wait for Adam to return to his usual spot before letting
    // any turns count as waiting turns.
    if (!getActor.ofKind(HacEnemy) || 
        !adamThorntonM.isInExe || adam.realLocation == hacRoomI18)
      getActor.agendaCount++;
    if (getActor.agendaCount > waitLength) {
      npcGoRoom(getActor, hacRoomH10);
      getActor.agendaCount = 0;
      isDone = true;
    }
  }
  waitLength = 4
;
//dragonWaitToArrive: WaitToArrive // Probably won't be used. But just in case.
//  location = dragon
//;
//copymanWaitToArrive: WaitToArrive
//  location = copyman
//  //invokeItem() {
//  //  if (!adamThorntonM.isInExe || adam.realLocation == hacRoomI18)
//  //    getActor.agendaCount++;
//  //  if (getActor.agendaCount > waitLength) {
//  //    npcGoRoom(getActor, hacRoomH10);
//  //    //getActor.moveIntoForTravel(hacRoomH10);
//  //    getActor.agendaCount = 0;
//  //    isDone = true;
//  //  }
//  //}
//;
adamWaitToArrive: WaitToArrive
  location = adam
  waitLength = 0
;
banditWaitToArrive: WaitToArrive
  location = bandit
  waitLength = 1
;

class WaitInBox: HacAgendaItem // dragon, copyman
  agendaOrder = 100
  invokeItem() {
    //if (getActor.realLocation == nil) {
    //  getActor.moveIntoForTravel(hacRoomH10);
    //}
    getActor.agendaCount++;
    if (getActor.agendaCount >= waitLength) {
      getActor.agendaCount = 0;
      isDone = true;
    }
  }
  waitLength {
    if (glob.firstHacEnemy == getActor && glob.hacEnemyCount == 1)
      return 6;
    else
      return 0;
  }
  //waitLength = 0 // 6
;
//dragonWaitInBox: WaitInBox
//  location = dragon
//  waitLength = 6
//;
//copymanWaitInBox: WaitInBox
//  //isReady = nil
//  location = copyman
//  //waitLength = 0
//;

class ExitBox: HacAgendaItem // dragon, copyman, adam, bandit
  agendaOrder = 150
  invokeItem() {
    if (getActor.realLocation == hacRoomH10 || getActor.realLocation == hacRoomH9) {
      hacGoDir(getActor, &north);
    }
    //if (getActor.realLocation == hacRoomH8) {
    if (getActor.realLocation != hacRoomH10 && getActor.realLocation != hacRoomH9) {
      isDone = true;
    }
    //getActor.agendaCount++;
    //switch (getActor.agendaCount) {
    //  case 3:
    //    npcGoRoom(getActor, hacRoomH9);
    //    break;
    //  case 4:
    //    npcGoRoom(getActor, hacRoomH9);
    //    //getActor.agendaCount = 0;
    //    //isDone = true;
    //    break;
    //}
    //if (!getActor.isIn(hacRoomH10) && !getActor.isIn(hacRoomH9)) {
    //  getActor.agendaCount = 0;
    //  isDone = true;
    //}
  }
;
//dragonExitBox: ExitBox
//  location = dragon
//;
//copymanExitBox: ExitBox
//  location = copyman
//;
adamExitBox: ExitBox
  location = adam
;
banditExitBox: ExitBox
  location = bandit
;
class RunNorth: HacAgendaItem // dragon, copyman
  agendaOrder = 400
  isReady = (isWaryOfNpc && !getActor.realLocation.isNorthernHacRoom)
  invokeItem() {
//    local whichJunction;
//    local whichPrevLoc;
    // deal with the "runAbruptly" case
    if (runAbruptly && !getActor.roomToGoNorthTo) {
      //getActor.isRunningAbruptly = true;
      turnAround;
    }
    // Tell NPC which room to run north to.
    if (!getActor.roomToGoNorthTo)
      setRoomToRunNorthTo;
//if (bot.location == adam.location) { local k=0;k=k/k; }
    // run to the established destination
    runToRoom(getActor.roomToGoNorthTo, true);
  }
  setRoomToRunNorthTo {
    local whichJunction;
    local whichPrevRm;
    local bestRoom = nil;
    local targetRooms = [
       hacRoomD2
      ,hacRoomN6
      ,hacRoomJ4
      ,hacRoomD4
      //,hacRoomH6
    ];
    local bestDistToTargetRooms = [1000, 1000, 1000, 1000, 1000];
    // if room has already been determined, we're done
    if (getActor.roomToGoNorthTo)
      return;
    // Attempt to get data about the next junction the NPC 
    // will be visiting. Temporarily store that data (a list)
    // in the whichJunction variable.
    whichJunction = getActor.nextJunctionResults;
    // If data retrieval failed, tell the NPC to go to the northeast
    // corner. That should work, I guess.
    if (!whichJunction) {
      getActor.roomToGoNorthTo = hacRoomN2;
      return;
    }
    // If whichJunction has a list as it is supposed to, separate
    // the elements of that list into their appropriately-named variables.
    whichPrevRm = whichJunction[2];
    whichJunction = whichJunction[1];
    // Look at each of the possible targets to aim for (rooms
    // D2, D4, H6, J4, and N6), and find out which is closest.
    // This will involve looping through each of the four compass
    // directions for each of the five possible targets.
    for (local a = 1; a <= targetRooms.length; a++) {
      for (local b = 1; b <= 4; b++) {
        if (whichJunction.(glob.fourDirList[b]) != whichPrevRm 
          && whichJunction.distToRoom(targetRooms[a], b) < bestDistToTargetRooms[a])
            bestDistToTargetRooms[a] = whichJunction.distToRoom(targetRooms[a], b);
      }
      if (a == 1)
        bestRoom = targetRooms[a];
      else if (bestDistToTargetRooms[a] < bestDistToTargetRooms[a - 1])
        bestRoom = targetRooms[a];
    }
    // Set getActor.roomToGoNorthTo = bestRoom.
    if (bestRoom)
      getActor.roomToGoNorthTo = bestRoom;
    else
      getActor.roomToGoNorthTo = hacRoomN2;
//if (bot.location == adam.location) { local k=0;k=k/k; }
  }
  runAbruptly = nil
;
//dragonRunNorth: RunNorth
//  location = dragon
//;
//copymanRunNorth: RunNorth
//  location = copyman
//  runAbruptly = true
//;

// For RunNorth, we need to define which are northern hac-man rooms.
modify hacRoomD2 isNorthernHacRoom = true;
modify hacRoomE2 isNorthernHacRoom = true;
modify hacRoomF2 isNorthernHacRoom = true;
modify hacRoomG2 isNorthernHacRoom = true;
modify hacRoomH2 isNorthernHacRoom = true;
modify hacRoomI2 isNorthernHacRoom = true;
modify hacRoomJ2 isNorthernHacRoom = true;
modify hacRoomK2 isNorthernHacRoom = true;
modify hacRoomL2 isNorthernHacRoom = true;
modify hacRoomM2 isNorthernHacRoom = true;
modify hacRoomN2 isNorthernHacRoom = true;

modify hacRoomD3 isNorthernHacRoom = true;
modify hacRoomJ3 isNorthernHacRoom = true;
modify hacRoomN3 isNorthernHacRoom = true;

modify hacRoomD4 isNorthernHacRoom = true;
modify hacRoomE4 isNorthernHacRoom = true;
modify hacRoomF4 isNorthernHacRoom = true;
modify hacRoomH4 isNorthernHacRoom = true;
modify hacRoomI4 isNorthernHacRoom = true;
modify hacRoomJ4 isNorthernHacRoom = true;
modify hacRoomK4 isNorthernHacRoom = true;
modify hacRoomL4 isNorthernHacRoom = true;
modify hacRoomN4 isNorthernHacRoom = true;

modify hacRoomF5 isNorthernHacRoom = true;
modify hacRoomH5 isNorthernHacRoom = true;
modify hacRoomJ5 isNorthernHacRoom = true; // questionable
modify hacRoomL5 isNorthernHacRoom = true;
modify hacRoomN5 isNorthernHacRoom = true;

modify hacRoomF6 isNorthernHacRoom = true;
modify hacRoomG6 isNorthernHacRoom = true;
modify hacRoomH6 isNorthernHacRoom = true;
modify hacRoomJ6 isNorthernHacRoom = true; // questionable
modify hacRoomL6 isNorthernHacRoom = true;
modify hacRoomM6 isNorthernHacRoom = true;
modify hacRoomN6 isNorthernHacRoom = true;

class StayNorth: HacAgendaItem // dragon, copyman
  agendaOrder = 450
  isReady = (isWaryOfNpc)
  invokeItem() {
    //local exclDirInt = 0;
    local exclDirInt2 = 0;
    // NPC is now done going north; now it need only stay north.
    getActor.roomToGoNorthTo = nil;
    // figure out which way to go for a 
    if (getActor.realLocation.ofKind(HacJunction)) {
      local goWhere;
      //local rm;
      local legalDirList = [];
      // Disallow going anywhere that would take you out of the 
      // northern region.
      if (getActor.realLocation==hacRoomD2) exclDirInt2 = 4;
      if (getActor.realLocation==hacRoomD4) exclDirInt2 = 3;
      if (getActor.realLocation==hacRoomJ4) exclDirInt2 = 3;
      if (getActor.realLocation==hacRoomH6) exclDirInt2 = 3;
      if (getActor.realLocation==hacRoomN6) exclDirInt2 = 3;
      // Add any legal directions to legalDirList
      for (local a = 1; a <= 4; a++) {
        // If the given direction leads somewhere, and if it leads
        // somewhere the NPC hasn't just been to, and if we didn't just
        // exclude the given direction using exclDirInt2,
        // then add the direction to the list of legal directions.
        // This should always leave at least one direction.
        if (getActor.realLocation.(glob.fourDirList[a]) &&
            getActor.realLocation.(glob.fourDirList[a]) != getActor.previousRoom &&
            a != exclDirInt2) {
          legalDirList = legalDirList + glob.fourDirList[a];
        }
      }
      goWhere = rand(legalDirList);
      //goWhere = getActor.realLocation.goWhereForRoom(
      //  rm, chasing, [exclDirInt, exclDirInt2], stupidityFactor);
      if (goWhere != nil) {
        hacGoDir(getActor, goWhere);
      }
    }
    // If not at a junction, just keep moving ahead.
    else {
      // Look in all four directions. Whichever one goes to the 
      // room we weren't just in, that's the direction to take.
      for (local a = 1; a <= 4; a++) {
        if (getActor.realLocation.(glob.fourDirList[a]) != nil
            && getActor.realLocation.(glob.fourDirList[a]).ofKind(Room)
            && getActor.realLocation.(glob.fourDirList[a]) != getActor.previousRoom)
        {
          hacGoDir(getActor, glob.fourDirList[a]);
          break;
        }
      }
      //if (getActor.realLocation.north != nil 
      //  && getActor.realLocation.north != getActor.previousRoom) {
      //    hacGoDir(getActor, &north);
      //}
      //else if (getActor.realLocation.east != nil 
      //  && getActor.realLocation.east != getActor.previousRoom) {
      //    hacGoDir(getActor, &east);
      //}
      //else if (getActor.realLocation.south != nil 
      //  && getActor.realLocation.south != getActor.previousRoom) {
      //    hacGoDir(getActor, &south);
      //}
      //else if (getAsctor.location.west != nil 
      //  && getActor.realLocation.west != getActor.previousRoom) {
      //    hacGoDir(getActor, &west);
      //}
    }
  }
;
//dragonStayNorth: StayNorth
//  location = dragon
//;
//copymanStayNorth: StayNorth
//  location = copyman
//;

class RunFromPc: HacAgendaItem // dragon, copyman
  agendaOrder = 800
  isReady = (getActor.isTransformed)
  invokeItem() {
    //local k=0;k=k/k;
    //"<.p>RunFromPC is active.
    //  \bgetActor.powerCount == <<getActor.powerCount>> ";
    if (gPlayerChar.powerCount == 1) {
      //"\bTherefore, turn around. ";
      turnAround;
    }
    //"<.p>";
    runToRoom(gPlayerChar.location, nil);
  }
  // If the NPCs are sufficiently stupid when running away from the PC,
  // then the PC will at least have a chance of catching them.
  // For good measure, make them very stupid indeed.
  stupidityFactor = 15
;
//dragonRunFromPc: RunFromPc
//  location = dragon
//;
//copymanRunFromPc: RunFromPc
//  location = copyman
//;

class ChasePc: HacAgendaItem // dragon, copyman
  agendaOrder = 1000
  invokeItem() {
    runToRoom(gPlayerChar.location, true);
  }
  // stupidityFactor values and their intended[*] meanings: 
  // ([*] I may not have succeeded at doing what I intended, but
  // this was what I intended.)
  // sF =  0: As intelligent as possible.
  // sF =  2: Just stupid enough so that it might be noticeable.
  // sF =  4: Probably stupid enough to be noticeable.
  // sf =  6: Probably stupid enough to not be a very serious threat
  //          to any player exerting a reasonable effort.
  // sF =  8: Definitely stupid enough to not be a threat.
  // sF = 35  As stupid as possible. I.e., although the NPC is supposed
  //      or  to be pursuing a goal, he is so stupid that he behaves
  //    more: as if at random. Any number from 35 to 999 can be taken
  //          as arbitrarily large and thus means "as stupid as possible."
  //          Do not use a stupidityFactor of 1000 or more, 
  //          or the game will probably crash.
  stupidityFactor = 4
;
//dragonChasePc: ChasePc
//  location = dragon
//;
//copymanChasePc: ChasePc
//  location = copyman
//;

class AmbushNpc: HacAgendaItem // adam, bandit
  isReady = (getActor.npcGoal == targetNpc && 
    getActor.northHowLong >= getActor.northPatience)
  invokeItem() {
    // if we're not in the proper room to ambush the NPC, then go there.
    if (getActor.realLocation != hacRoomJ3) {
      runToRoom(hacRoomJ3, true);
    }
    // if we're in the proper room for ambush, then wait in ambush.
    else {
      // If target NPC is adjacent, attack.
      if (targetNpc.realLocation == getActor.realLocation.north) {
        hacGoDir(getActor, &north);
      }
      else if (targetNpc.realLocation == getActor.realLocation.south) {
        hacGoDir(getActor, &south);
      }
      // Otherwise, wait (i.e., do nothing).
      else {
      }
    }
  }
  agendaOrder = 375
;
adamAmbushNpc: AmbushNpc
  location = adam
  targetNpc = dragon
;
banditAmbushNpc: AmbushNpc
  //isReady = (getActor.northHowLong >= getActor.northPatience)
  location = bandit
  targetNpc = copyman
;

class ChaseNpc: HacAgendaItem // adam, bandit
  isReady = (getActor.npcGoal == targetNpc)
  invokeItem() {
    if (getActor.realLocation == hacRoomI18 &&
        (bot.location == hacRoomF18 || bot.location == hacRoomG18 
        || bot.location == hacRoomH18)) {
      //"Scenario 1. ";
      //runToRoom(hacRoomL18, true);
      hacGoDir(getActor, &east);
    }
    else if (getActor.realLocation == hacRoomI18 &&
        (bot.location == hacRoomJ18 || bot.location == hacRoomK18 
        || bot.location == hacRoomL18)) {
      //"Scenario 2. ";
      //runToRoom(hacRoomF18, true);
      hacGoDir(getActor, &west);
    }
    else {
      //"Scenario 3. ";
      runToRoom(targetNpc.realLocation, true);
    }
    if (getActor.realLocation.isNorthernHacRoom)
      getActor.northHowLong++;
    //if (getActor.northHowLong > getActor.northPatience) {
    //  getActor.addToAgenda(ambushAgendaItem);
    //  northHowLong = 0;
    //}
  }
  //northHowLong = 0
  agendaOrder = 400
;
adamChaseNpc: ChaseNpc
  location = adam
  ambushAgendaItem = adamAmbushNpc
  targetNpc = dragon
;
banditChaseNpc: ChaseNpc
  //isReady = true
  location = bandit
  ambushAgendaItem = banditAmbushNpc
  targetNpc = copyman
;

class GoNearBox: HacAgendaItem // adam, bandit
  isReady = (getActor.npcGoal == bandit)
  invokeItem() {
    if (getActor.realLocation == hacRoomI18 &&
        (bot.location == hacRoomF18 || bot.location == hacRoomG18 
        || bot.location == hacRoomH18)) {
      runToRoom(hacRoomL18, true);
    }
    else if (getActor.realLocation == hacRoomI18 &&
        (bot.location == hacRoomJ18 || bot.location == hacRoomK18 
        || bot.location == hacRoomL18)) {
      runToRoom(hacRoomF18, true);
    }
    else if (getActor.realLocation != hacRoomH8) {
      runToRoom(hacRoomH8, true);
    }
    if (getActor.realLocation == hacRoomH8) {
      isDone = true;
      if (getActor == adam)
        getActor.addToAgenda(adamEnterBox);
      else if (getActor == bandit)
        getActor.addToAgenda(banditEnterBox);
    }
    
  }
  agendaOrder = 300 // override to 800 for bandit
;
adamGoNearBox: GoNearBox
  isReady = (getActor.npcGoal == bandit)
  location = adam
;
banditGoNearBox: GoNearBox
  isReady = true
  location = bandit
  agendaOrder = 800
;

class EnterBox: HacAgendaItem // adam, bandit
  agendaOrder = 350 // override to 850 for bandit
  invokeItem() {
    if (getActor.realLocation == hacRoomH8 || getActor.realLocation == hacRoomH9) {
      hacGoDir(getActor, &south);
    }
    //if (getActor.realLocation == hacRoomH8) {
    else if (getActor.realLocation != hacRoomH8 && getActor.realLocation != hacRoomH9) {
      getActor.deactivateNpc;
      targetNpc.activateNpc;
      //if (getActor == adam) {
      //  bandit.activateNpc;
      //}
    }
  }
;
adamEnterBox: EnterBox
  isReady = (getActor.npcGoal == bandit)
  location = adam
  targetNpc = bandit
;
banditEnterBox: EnterBox
  isReady = true
  location = bandit
  targetNpc = adam
  agendaOrder = 850
;

class RunSouth: HacAgendaItem // adam
  isReady = (getActor.realLocation != hacRoomI18)
  agendaOrder = 800
  invokeItem() {
    //local k = 0; k=k/k;
    if (getActor.realLocation && getActor.realLocation.yValue == 18) {
      runToRoom(hacRoomI18, true);
    }
    else if (bot.location && bot.location.yValue == 18 && bot.location.xValue > 9) {
      runToRoom(hacRoomF18, true);
    }
    else {
      runToRoom(hacRoomL18, true);
    }
    //if (bot.location == hacRoomI18) {
    //  if (!copyman.isDead && !copyman.realLocation)
    //    copyman.activateNpc;
    //}
  }
;
adamRunSouth: RunSouth
  location = adam
;

class WaitSouth: HacAgendaItem // adam
  isReady = true
  agendaOrder = 1000
  // With this agenda item, the NPC just waits -- i.e., does nothing whatsoever.
  invokeItem() {
  }
;
adamWaitSouth: WaitSouth
  location = adam
  // But wait, there's one exception to "doing nothing whatsoever." 
  // Sometimes when Adam will open up his parka and quaff a potion of booze.
  invokeItem() {
    if (bot.canSee(adam) && quaffCount == -1) {
      quaffCount++;
    }
    else if (bot.canSee(adam) && quaffCount == 0) {
      //"\^<<adam.theName>> opens his <<adam.cloakName>>
      //  and removes a potion of booze. ";
      //"\^<<adam.theName>> drinks a potion of booze! ";
      sayQuaffing;
      quaffCount++;
    }
    // For any random turn when adam is waiting, give him a 15% chance of 
    // quaffing a potion of booze, up until he's drunk 4 potions.
    else if (bot.canSee(adam) && quaffCount <= 4 && rand(100) < 15) {
      sayQuaffing;
      quaffCount++;
    }
  }
  sayQuaffing {
    "\^<<adam.theName>> opens his <<adam.cloakName>>
      and removes a potion of booze. ";
    "\^<<adam.theName>> drinks a potion of booze! ";
  }
  quaffCount = -1
;

// -------------------------------------------------------------------
// HAC-MAN MAZE: NPC STUFF: AGENDA ITEMS (OBSOLETE)
// -------------------------------------------------------------------

//dragonWaitToAppear: AgendaItem
//  location = dragon
//  agendaOrder = 20
//  invokeItem() {
//    getActor.agendaCount++;
//    if (getActor.agendaCount == 5) {
//      npcGoRoom(getActor, hacRoomH10);
//      getActor.agendaCount = 0;
//      //"[The dragon has arrived.] ";
//      isDone = true;
//    }
//  }
//;
///*
//dragonExitBox: AgendaItem
//  location = dragon
//  agendaOrder = 40
//  invokeItem() {
//    getActor.agendaCount++;
//    switch (getActor.agendaCount) {
//      case 3:
//        //"[The dragon has moved to H9.] ";
//        npcGoRoom(getActor, hacRoomH9);
//        //nestedActorAction(getActor, TravelVia, hacRoomH9);
//        break;
//      case 4:
//        //"[The dragon has moved to H10.] ";
//        getActor.agendaCount == 0;
//        npcGoRoom(getActor, hacRoomH9);
//        //nestedActorAction(getActor, TravelVia, pinkGate2);
//        isDone = true;
//        break;
//    }
//    
//  }
//;
//*/
//dragonRunAway: AgendaItem
//  location = dragon
//  isReady = nil
//  agendaOrder = 100
//  invokeItem() {
//    
//  }
//;
//dragonVsThornton: AgendaItem
//  location = dragon
//  isReady = nil
//  agendaOrder = 200
//  invokeItem() {
//    
//  }
//;
//dragonChasingYou: AgendaItem
//  location = dragon
//  agendaOrder = 300
//  invokeItem() {
//    if (getActor.location.ofKind(HacJunction)) {
//      switch (getActor.location.goWhereToGetToRoom(gPlayerChar.location, 0)) {
//        case 1:
//          hacGoDir(getActor, &north);
//          break;
//        case 2:
//          hacGoDir(getActor, &east);
//          break;
//        case 3:
//          hacGoDir(getActor, &south);
//          break;
//        case 4:
//          hacGoDir(getActor, &west);
//          break;
//      }
//    }
//    else { // the actor is not at a junction
//      if (getActor.location.north != nil 
//        && getActor.location.north != getActor.previousRoom) {
//          hacGoDir(getActor, &north);
//      }
//      else if (getActor.location.east != nil 
//        && getActor.location.east != getActor.previousRoom) {
//          hacGoDir(getActor, &east);
//      }
//      else if (getActor.location.south != nil 
//        && getActor.location.south != getActor.previousRoom) {
//          hacGoDir(getActor, &south);
//      }
//      else if (getActor.location.west != nil 
//        && getActor.location.west != getActor.previousRoom) {
//          hacGoDir(getActor, &west);
//      }
//    }
//    //getKey(nil, nil);
//  }
//;
//
///*
//class AgendaItem: object
//  getActor() { return location; } // the actor to whom this item belongs
//  initiallyActive = nil           // active from beginning of game?
//  isReady = true                  // provides conditions for whether action is pursued
//  isDone = nil                    // if isDone, then remove from agenda.
//  agendaOrder = 100               // the lower the agendaOrder value, the higher the priority
//  invokeItem() { }                // THIS IS THE METHOD THAT CONTAINS THE AGENDA'S CONTENT.
//  resetItem() {...}               // called when item is added to agenda; makes isDone = nil.
//;
//*/
///*
//  10 Wait a few turns, then move from the bullpen to H10.
//  30 Wait a couple of turns, then go north from from H10 to H8.
// 100 Run away when the actor becomes powered (0% stupidity)
// 200 Perhaps behave differently when being pursued by Adam Thornton.
//1000 Keep on going towards actor (20% stupidity) and try to kill him.
//*/

// -------------------------------------------------------------------
// HAC-MAN MAZE: NPC STUFF: MISC. NPC STUFF
// -------------------------------------------------------------------

bullpen: Room 'Bullpen' "This is a bullpen. ";
dungeon: Room 'Dungeon' "This is a dungeon. ";
death: Fixture
  location = bullpen
;
modify Actor
  firstTheName = (theName)
  firstTheNameHasBeenUttered = nil
;
modify HacEnemy
  firstTheName {
    if (!firstTheNameHasBeenUttered) {
      firstTheNameHasBeenUttered = true;
      return aNameFrom(name);
    }
    else
      return theName;
  }
;

enum advance, advanceQuietly, halt;

function hacGoDir(npc, dir) {
  local dirBefore, dirAfter, distBefore, distAfter, movementDir, intendedDest;
  // UNIVERSALIZE (finished)
  //local charList = [bot, dragon, copyman, adam, bandit];
  local charList = glob.hacChars;
  
  // As a last resort to prevent run-time errors, exit this
  // function if necessary.
  if (!npc || !npc.realLocation)
    return;
  
  // intendedDest = the place the NPC intends to move to.
  intendedDest = npc.realLocation.(dir).getDestination(npc.realLocation, npc);
  // Before moving, check to see if there is an NPC in the place we
  // intend to move to. If so, act accordingly -- either initiating
  // melee combat, or else (if the two characters are not hostile 
  // to one another) then doing something else.
  for (local a = 1; a <= charList.length; a++) {
    if (charList[a].realLocation == intendedDest) {
      // confrontChar() will either initiate combat or otherwise
      // confront the character who is standing in front of the NPC.
      // confrontChar() will also return a value, either advance, 
      // advanceQuietly, or halt. Act accordingly, as per this 
      // returned value, after the confrontation.
      if (npc.confrontChar(charList[a]) == halt) {
        return;
      }
      //switch (npc.confrontChar(charList[a])) {
      //}
    }
  }
  //npc.startMelee(opponent);
  
  
  
  // set dirBefore and distBefore
  dirBefore = npc.locationWrtBot;
  distBefore = dirBefore[2];
  dirBefore = dirBefore[1];
  // set npc.previousRoom
  npc.previousRoom = npc.realLocation;
//  nestedActorAction(npc, TravelVia, npc.location.(dir));
  // If there is a problem involved in moving the NPC, report the problem,
  if (npc.beforeHacMoveInto) {
    return;
  }
  // Actually move the NPC
  npc.hacMoveInto(intendedDest);
  // Set dirAfter and distAfter
  dirAfter = npc.locationWrtBot;
  distAfter = dirAfter[2];
  dirAfter = dirAfter[1];
  // Set movementDir
  switch (dir) {
    case &north: movementDir = northDirection; break;
    case &south: movementDir = southDirection; break;
    case &east : movementDir = eastDirection ; break;
    case &west : movementDir = westDirection ; break;
    default    : movementDir = nil           ; break;
  }
  
  
  
  // Say the messages
  if (dirBefore || dirAfter) {
    "<.p>";
    npc.hasBeenSeen = true;
  }
  // If NPC was invisible both before and after the move, say nothing.
  if (!dirBefore && !dirAfter) {
  }
//  local k = inputManager.getKey(nil,nil); if (k=='q') { k=0;k=k/k; }
  // If NPC was invisible before, but is visible now, then describe
  // its coming into view.
  else if (!dirBefore) {
    // It should be impossible for the NPC to appear from out of nowhere
    // directly to where the PC is. But just to be sure.
    if (dirAfter == true)
      "\^<<npc.firstTheName>> comes into view. ";
    // Deal with "void" scenario.
    else if (npc.realLocation == hacRoomA2 || npc.realLocation == hacRoomO18) {
      "<<distAfter == 1 ? 'Directly' : 'Off'>> to the <<dirAfter.name>>, 
        <<npc.firstTheName>> appears from out of the void. ";
    }
    // Deal with pink gate scenario.
    else if (npc.realLocation == hacRoomH9) {
      "<<distAfter == 1 ? 'Directly' : 'Off'>> to the <<dirAfter.name>>, 
        <<npc.firstTheName>> walks halfway out of the pink gate,
        which flickers, but allows <<npc.itObj>> to remain there. ";
    }
    // Normal handling
    else {
      "<<distAfter == 1 ? 'Directly' : 'Off'>> to the <<dirAfter.name>>, 
        <<npc.firstTheName>> comes into view";
      switch (dir) {
        case &north: " from the south"; break;
        case &south: " from the north"; break;
        case &east : " from the west";  break;
        case &west : " from the east";  break;
      }
      ". ";
    }
    //JAN 12, 2007: FINISH THIS SOON IF POSSIBLE.
    //if (!npc.hasBeenIdentified) {
    //  "<p>
    //  npc.hasBeenIdentified = true;
    //}
  }
  // If NPC was visible before, but is invisible now, describe its
  // disappearing.
  else if (!dirAfter) {
    // It should be impossible for the NPC to start next to the bot,
    // then go off to where it's invisible. But just to be sure.
    if (dirBefore == true) {
      "\^<<npc.theName>> disappears. ";
    }
    // Deal with the "void" scenario.
    else if (npc.previousRoom == hacRoomA2 || npc.previousRoom == hacRoomO18) {
      callWithSenseContext(nil, nil, new function { 
        "<<distBefore == 1 ? 'Directly' : 'Off'>> to the <<dirBefore.name>>,
          <<npc.theName>> disappears into the void. ";
      } );
    }
    // Deal with pink gate scenario.
    else if (npc.previousRoom == hacRoomH9) {
      callWithSenseContext(nil, nil, new function {
        "<<distAfter == 1 ? 'Directly' : 'Off'>> to the <<dirBefore.name>>, 
          <<npc.firstTheName>> walks southward, completely disappearing through 
          the pink gate. ";
      } );
    }
    // Normal handling
    else {
      // Man alive. I hate TADS 3's sensory stuff. It took me forever
      // to realize I need callWithSenseContext() here.
      callWithSenseContext(nil, nil, new function { 
        "<<distBefore == 1 ? 'Directly' : 'Off'>> to the <<dirBefore.name>>,
          <<npc.theName>> disappears<<movementDir && movementDir.ofKind(Direction) 
          ? ' ' + movementDir.name + 'ward' : ''>>. ";
      } );
    }
  }
  // It should be impossible for the NPC to be in the same room as the 
  // PC both before and after the move. If this happens, however, 
  // say nothing.
  else if (dirBefore == true && dirAfter == true) {
  }
  // If the NPC started out in the same room as the PC, and has moved
  // to a new place (where he's still visible now), say so.
  else if (dirBefore == true) {
    "\^<<npc.theName>> exits to the <<movementDir.name>>. ";
  }
  // If the NPC started out visible in some direction, and has now
  // moved to the same room as the PC, say so.
  else if (dirAfter == true) {
    "\^<<npc.theName>> comes in";
    switch (dir) {
      case &north: " from the south"; break;
      case &south: " from the north"; break;
      case &east : " from the west";  break;
      case &west : " from the east";  break;
    }
    ". ";
  }
  // This should take care of all cases where dirBefore or dirAfter
  // are not directions. Just to be sure...
  else if (!dirBefore.ofKind(Direction) || !dirAfter.ofKind(Direction)) {
  }
  // All other cases can be lumped together. The NPC is moving either
  // toward the PC or away from the PC, and remains visible throughout
  // the movement, is always visible in the same direction throughout
  // the movment, and remains in a separate room from the PC 
  // throughout the movement.
  else {
    // Deal with pink gate scenario
    if (npc.realLocation == hacRoomH8) {
      "<<distBefore == 1 || distAfter == 1 ? 'Directly' : 'Off'>> to the 
        <<dirBefore.name>>, <<npc.theName>> steps out of the pink gate and 
        <<distAfter > distBefore ? 'moves away from' : 'heads toward'>> your bot. ";
    }
    else if (npc.realLocation == hacRoomH9) {
      "<<distBefore == 1 || distAfter == 1 ? 'Directly' : 'Off'>> to the 
        <<dirBefore.name>>, <<npc.theName>> steps into the pink gate,
        coming to a halt halfway inside of it. The gate flickers,
        but allows <<npc.itObj>> to remain there. ";
    }
    // Normal handling
    else {
      "<<distBefore == 1 || distAfter == 1 ? 'Directly' : 'Off'>> to the 
        <<dirBefore.name>>, <<npc.theName>> 
        <<distAfter > distBefore ? 'moves away from' : 'heads toward'>> your bot. ";
    }
  }
}
npcGoRoom(npc, room) {
  npc.previousRoom = npc.realLocation;
  //nestedActorAction(npc, TravelVia, room);
  npc.hacMoveInto(room);
}




































// -------------------------------------------------------------------
// STUFF WRITTEN BY KRISTER FUNDIN
// -------------------------------------------------------------------

/* ---------------------------------------------------------------------- */
/*
 *   An custom interface to the path-finder.
 */
modify HacJunction
    /* 
     *   determine the shortest distance from this junction to another 
     *   room, given that we start out by going in a certain direction
     */
    distToRoom(room, dir)
    {
        local start;
        
// Begin stuff added by Greg Boettcher on 4/11/07:
        // For no reason I understand, this has been called sometimes
        // on non-Hac rooms after the PC has left the Hac-Man maze. 
        // Deal with this scenario.
        if (!room || !room.ofKind(HacRoom) || !dir)
          return 1000;
// End 4/11/07 stuff
// Begin stuff added by Greg Boettcher on 10/8/07:
        if (dir == 1) dir = &north;
        if (dir == 2) dir = &east;
        if (dir == 3) dir = &south;
        if (dir == 4) dir = &west;
// End 10/8/07 stuff

        /* get the room in this direction */
        start = self.(dir);

        /* see if there's an exit there at all */
        if (start == nil)
            return 1000;

// Begin Krister's version:
//        /* if it's a passage, use its destination instead */
//        if (start.ofKind(Passage))
//            start = start.destination;
// End Krister's version; begin my version:
        /* if it's a passage, ignore it */
        if (start.ofKind(Passage))
            return 1000;
// End my version

        /* 
         *   return the distance from THIS room to the goal, which is 
         *   one more than the distance from the room we're using as the 
         *   origin for the search
         */
        return (pathFinder.getDistance(start, dir, room) + 1);
    }

    /* 
     *   determine the shortest distances from this junction to another 
     *   room for each of the four cardinal directions that we could 
     *   start out by going in
     */
    distToRoomList(room)
    {
        return [&north, &east, &south, &west]
                   .mapAll({ dir: distToRoom(room, dir) });
        
    }
;

/* ---------------------------------------------------------------------- */
/*
 *   The pathFinder object is responsible for the actual path-finding.
 */
pathFinder: object
    /*
     *   Calculate the best path from one room to another, given that we 
     *   start out facing a certain direction, and return the number of 
     *   steps on this path. If we can't reach the goal, then nil is 
     *   returned.
     */
    getDistance(startRoom, dir, goalRoom)
    {
        local bestf, bestNode, node, rooms;

        /* store the goal */
        self.goalRoom = goalRoom;

        /* add the starting point to the list of open nodes */
        openNode(startRoom, dir, nil, 0);

        /* repeat until we have reached the end point */
        for (;;)
        {
            /*
             *   find the node with the lowest estimated distance from
             *   start to goal
             */
            bestf = 10000;
            bestNode = nil;

            foreach (node in openNodes)
            {
                if (node.f < bestf)
                {
                    bestf = node.f;
                    bestNode = node;
                }
            }

            /* there might be no solution at all */
            if (bestNode == nil)
                return nil;

            /* see if we have reached the goal */
            if (bestNode.room == goalRoom)
            {
                /* count the number of rooms on the path */
                rooms = 0;

                /* work our way backwards from goal to start */
                for (node = bestNode ; node != nil ; node = node.prevNode)
                {
                    /* count this room */
                    rooms++;
                }
                
                /* profiling */
                //"Pathfinding done: finished with <<openNodes.length>> open
                //and <<closedNodes.length>> closed node(s).<.p>";
                
                /* clear temporary data before leaving */
                openNodes.setLength(0);
                closedNodes.setLength(0);

                /* 
                 *   now we're done - return the distance from start to 
                 *   origin, which is one less than the number of rooms 
                 *   on the path
                 */
                return rooms - 1;
            }

            /*
             *   we haven't reached the goal, so close this node and keep
             *   searching
             */
            closeNode(bestNode);
        }
    }

    /* consider adding a new open node */
    openNode(room, dir, prevNode, g)
    {
        /* if the "room" is a passage, get its destination instead */
        if (room.ofKind(Passage))
            room = room.destination;
        
        /*
         *   we need to use the same comparison function twice, so create a
         *   single copy in advance
         */
        local func = new function(node)
        {
            return (node.room == room && node.dir == dir);
        };

        /*
         *   Check that the node is not either open or closed already. We
         *   only open nodes that we haven't considered before.
         */
        if (openNodes.indexWhich(func) == nil
            && closedNodes.indexWhich(func) == nil)
        {
            /* create the node and add it to the list of open nodes */
            openNodes.append(
                new PathFinderNode(room, dir, prevNode, g));
        }
    }

    /* close a node */
    closeNode(node)
    {
        local room, dir, g;

        /* move it from the open nodes to the closed nodes */
        openNodes.removeElement(node);
        closedNodes.append(node);

        /* fetch the room of the node we're closing */
        room = node.room;

        /* fetch the current direction of travel */
        dir = node.dir;

        /*
         *   increment the g value, since the neighbours of this node are
         *   one step further from the origin
         */
        g = node.g + 1;

        /*
         *   See which ways we can go. We have to check against the 
         *   available exits and the current direction of travel, since 
         *   we aren't allowed to turn around.
         */
        
        /* see if we can go north */
        if (dir != &south && room.north != nil)
            openNode(room.north, &north, node, g);

        /* see if we can go east */
        if (dir != &west && room.east != nil)
            openNode(room.east, &east, node, g);

        /* see if we can go south */
        if (dir != &north && room.south != nil)
            openNode(room.south, &south, node, g);

        /* see if we can go west */
        if (dir != &east && room.west != nil)
            openNode(room.west, &west, node, g);
    }

    /* our lists of open and closed nodes */
    openNodes = static new Vector(20)
    closedNodes = static new Vector(40)

    /*
     *   the current goal of the path finder, stored here so that the nodes
     *   can see how far from this point they are
     */
    goalRoom = nil
;

/* a data structure for use by the path finder */
class PathFinderNode: object
    construct(room, dir, prevNode, g)
    {
        /* remember our specifics */
        self.room = room;
        self.dir = dir;
        self.prevNode = prevNode;
        self.g = g;

        /*
         *   Calculate a heuristic estimate of the distance from origin 
         *   to goal going through this node. The g value is the number 
         *   of steps that we have taken from the origin. We only have 
         *   to add an estimate of the number of steps left before we 
         *   reach the goal. Note that we must never overestimate this 
         *   distance. We use a simple straight line (well, a zig-zag 
         *   line anyway), so that the real solution is guaranteed not 
         *   to be any shorter than this.
         *
         *   Start by calculating the straight line distance to the goal.
         */
        local dx = hacAbsVal(pathFinder.goalRoom.xValue - room.xValue);
        local dy = hacAbsVal(pathFinder.goalRoom.yValue - room.yValue);

        /* 
         *   Now, we have to consider the fact that we can wrap around 
         *   from A2 to O18. This somewhat complicates the calculation.
         */

        // -----------------------------------------------------------
        //Krister's original line, as sent to me 3/15/2007:
        //f = g + min(dx, 15 - dx) + min(dy, 16 - dy);
        
        //Krister's new version of this line, as sent to me 4/4/07:
        f = g + min(dx + dy, (15 - dx) + (16 - dy));
        // -----------------------------------------------------------
        
    }

    room = nil
    dir = nil
    prevNode = nil
    f = 0
    g = 0
;

/* service function: return the absolute value of an integer */
hacAbsVal(val)
{
    return (val < 0 ? -val : val);
}

// -------------------------------------------------------------------
// HAC-MAN MAZE: NPC STUFF: PSEUDO-AI: MEASURING DISTANCES
// -------------------------------------------------------------------

#ifdef __DEBUG

DefineIAction(DistReport)
  execAction() {
    local roomList = [
       hacRoomA2 
      ,hacRoomA2 
      ,hacRoomB2 
      ,hacRoomC2 
      ,hacRoomD2 
      ,hacRoomE2 
      ,hacRoomF2 
      ,hacRoomG2 
      ,hacRoomH2 
      ,hacRoomI2 
      ,hacRoomJ2 
      ,hacRoomK2 
      ,hacRoomL2 
      ,hacRoomM2 
      ,hacRoomN2 
      ,hacRoomD3 
      ,hacRoomJ3 
      ,hacRoomN3 
      ,hacRoomD4 
      ,hacRoomE4 
      ,hacRoomF4 
      ,hacRoomH4 
      ,hacRoomI4 
      ,hacRoomJ4 
      ,hacRoomK4 
      ,hacRoomL4 
      ,hacRoomN4 
      ,hacRoomD5 
      ,hacRoomF5 
      ,hacRoomH5 
      ,hacRoomJ5 
      ,hacRoomL5 
      ,hacRoomN5 
      ,hacRoomB6 
      ,hacRoomC6 
      ,hacRoomD6 
      ,hacRoomF6 
      ,hacRoomG6 
      ,hacRoomH6 
      ,hacRoomJ6 
      ,hacRoomL6 
      ,hacRoomM6 
      ,hacRoomN6 
      ,hacRoomB7 
      ,hacRoomD7 
      ,hacRoomH7 
      ,hacRoomJ7 
      ,hacRoomN7 
      ,hacRoomB8 
      ,hacRoomD8 
      ,hacRoomE8 
      ,hacRoomF8 
      ,hacRoomG8 
      ,hacRoomH8 
      ,hacRoomI8 
      ,hacRoomJ8 
      ,hacRoomK8 
      ,hacRoomL8 
      ,hacRoomN8 
      ,hacRoomB9 
      ,hacRoomD9 
      ,hacRoomL9 
      ,hacRoomN9 
      ,hacRoomB10
      ,hacRoomC10
      ,hacRoomD10
      ,hacRoomL10
      ,hacRoomM10
      ,hacRoomN10
      ,hacRoomB11
      ,hacRoomD11
      ,hacRoomL11
      ,hacRoomN11
      ,hacRoomB12
      ,hacRoomD12
      ,hacRoomE12
      ,hacRoomF12
      ,hacRoomG12
      ,hacRoomH12
      ,hacRoomI12
      ,hacRoomJ12
      ,hacRoomK12
      ,hacRoomL12
      ,hacRoomN12
      ,hacRoomB13
      ,hacRoomF13
      ,hacRoomH13
      ,hacRoomL13
      ,hacRoomN13
      ,hacRoomB14
      ,hacRoomC14
      ,hacRoomD14
      ,hacRoomF14
      ,hacRoomH14
      ,hacRoomI14
      ,hacRoomJ14
      ,hacRoomL14
      ,hacRoomM14
      ,hacRoomN14
      ,hacRoomB15
      ,hacRoomD15
      ,hacRoomF15
      ,hacRoomH15
      ,hacRoomJ15
      ,hacRoomL15
      ,hacRoomB16
      ,hacRoomD16
      ,hacRoomE16
      ,hacRoomF16
      ,hacRoomG16
      ,hacRoomH16
      ,hacRoomJ16
      ,hacRoomK16
      ,hacRoomL16
      ,hacRoomB17
      ,hacRoomF17
      ,hacRoomL17
      ,hacRoomB18
      ,hacRoomC18
      ,hacRoomD18
      ,hacRoomE18
      ,hacRoomF18
      ,hacRoomG18
      ,hacRoomH18
      ,hacRoomI18
      ,hacRoomJ18
      ,hacRoomK18
      ,hacRoomL18
      ,hacRoomM18
      ,hacRoomN18
      ,hacRoomO18
      ,hacRoomH9 
      ,hacRoomH10
    ];
    local tempList;
    //local tempList2;
    "<tt>";
    for (local a = 1; a <= roomList.length - 2; a++) {
      if (roomList[a].ofKind(HacJunction)) {
        "Distances from <<roomList[a].xyName>> to various rooms:<br>";
        for (local b = 1; b <= roomList.length; b++) {
          tempList = roomList[a].distToRoomList(roomList[b]);
          "<<roomList[b].xyName>>: ";
          "[";
          for (local c = 1; c <= 4; c++) {
            say(tempList[c]);
            if (c < 4) ",";
          }
          "] ";
          //tempList2 = roomList[a].distToRoomListKF(roomList[b]);
          //"[";
          //for (local c = 1; c <= 4; c++) {
          //  say(tempList2[c]);
          //  if (c < 4) ",";
          //}
          //"] ";
          //if (tempList != tempList2) {
          //  "ERROR!!!";
          //  inputManager.getKey(nil, nil);
          //}
          "<br>";
        }
        inputManager.getKey(nil, nil);
      }
    }
    "</tt>";
  }
;
VerbRule(DistReport)
  ('distance' | 'dist') 'report'
  : DistReportAction
  verbPhrase = 'give/giving a distance report'
;

DefineIAction(Hack)
  execAction() {
    glob.dotsEaten = 149;
    "Done. ";
    //"butterflyIdM.isInExe = true. ";
    //butterflyIdM.isInExe = true;
  }
;
VerbRule(Hack)
  'hack'
  : HackAction
  verbPhrase = 'hack/hacking'
;


#endif // __DEBUG


/*
modify hacRoomD2
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [1000,  23,  23,   3]
  distToB2  = [1000,  22,  22,   2]
  distToC2  = [1000,  21,  21,   1]
  distToD2  = [1000,  20,  20,  31]
  distToE2  = [1000,   1,  19,  30]
  distToF2  = [1000,   2,  18,  29]
  distToG2  = [1000,   3,  17,  28]
  distToH2  = [1000,   4,  16,  27]
  distToI2  = [1000,   5,  15,  26]
  distToJ2  = [1000,   6,  14,  25]
  distToK2  = [1000,   7,  15,  26]
  distToL2  = [1000,   8,  16,  27]
  distToM2  = [1000,   9,  17,  26]
  distToN2  = [1000,  10,  18,  25]
  distToD3  = [1000,  19,   1,  30]
  distToJ3  = [1000,   7,  13,  24]
  distToN3  = [1000,  11,  19,  24]
*/

/*
modify hacRoomD2
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [1000,  23,  23,   3]
  distToB2  = [1000,  22,  22,   2]
  distToC2  = [1000,  21,  21,   1]
  distToD2  = [1000,  20,  20,  31]
  distToE2  = [1000,   1,  19,  30]
  distToF2  = [1000,   2,  18,  29]
  distToG2  = [1000,   3,  17,  28]
  distToH2  = [1000,   4,  16,  27]
  distToI2  = [1000,   5,  15,  26]
  distToJ2  = [1000,   6,  14,  25]
  distToK2  = [1000,   7,  15,  26]
  distToL2  = [1000,   8,  16,  27]
  distToM2  = [1000,   9,  17,  26]
  distToN2  = [1000,  10,  18,  25]
  distToD3  = [1000,  19,   1,  30]
  distToJ3  = [1000,   7,  13,  24]
  distToN3  = [1000,  11,  19,  24]
  distToD4  = [1000,  18,   2,  29]
  distToE4  = [1000,  17,   3,  28]
  distToF4  = [1000,  16,   4,  27]
  distToH4  = [1000,  10,  10,  25]
  distToI4  = [1000,   9,  11,  24]
  distToJ4  = [1000,   8,  12,  23]
  distToK4  = [1000,   9,  13,  24]
  distToL4  = [1000,  10,  14,  25]
  distToN4  = [1000,  12,  20,  23]
  distToD5  = [1000,  19,   3,  28]
  distToF5  = [1000,  15,   5,  26]
  distToH5  = [1000,  11,   9,  24]
  distToJ5  = [1000,   9,  13,  22]
  distToL5  = [1000,  11,  15,  24]
  distToN5  = [1000,  13,  19,  22]
  distToB6  = [1000,  22,   6,  29]
  distToC6  = [1000,  21,   5,  28]
  distToD6  = [1000,  20,   4,  27]
  distToF6  = [1000,  14,   6,  25]
  distToG6  = [1000,  13,   7,  24]
  distToH6  = [1000,  12,   8,  23]
  distToJ6  = [1000,  10,  14,  21]
  distToL6  = [1000,  12,  16,  23]
  distToM6  = [1000,  13,  17,  22]
  distToN6  = [1000,  14,  18,  21]
  distToB7  = [1000,  23,   7,  28]
  distToD7  = [1000,  19,   5,  26]
  distToH7  = [1000,  13,   9,  22]
  distToJ7  = [1000,  11,  13,  20]
  distToN7  = [1000,  15,  19,  20]
  distToB8  = [1000,  24,   8,  27]
  distToD8  = [1000,  18,   6,  25]
  distToE8  = [1000,  17,   7,  24]
  distToF8  = [1000,  16,   8,  23]
  distToG8  = [1000,  15,   9,  22]
  distToH8  = [1000,  14,  10,  21]
  distToI8  = [1000,  13,  11,  20]
  distToJ8  = [1000,  12,  12,  19]
  distToK8  = [1000,  13,  13,  18]
  distToL8  = [1000,  14,  14,  17]
  distToN8  = [1000,  16,  20,  19]
  distToB9  = [1000,  23,   9,  26]
  distToD9  = [1000,  19,   7,  24]
  distToL9  = [1000,  15,  15,  16]
  distToN9  = [1000,  17,  19,  18]
  distToB10 = [1000,  22,  10,  25]
  distToC10 = [1000,  21,   9,  24]
  distToD10 = [1000,  20,   8,  23]
  distToL10 = [1000,  16,  16,  15]
  distToM10 = [1000,  17,  17,  16]
  distToN10 = [1000,  18,  18,  17]
  distToB11 = [1000,  23,  11,  24]
  distToD11 = [1000,  21,   9,  22]
  distToL11 = [1000,  17,  17,  14]
  distToN11 = [1000,  19,  19,  16]
  distToB12 = [1000,  24,  12,  23]
  distToD12 = [1000,  22,  10,  21]
  distToE12 = [1000,  23,  11,  20]
  distToF12 = [1000,  24,  12,  19]
  distToG12 = [1000,  23,  13,  18]
  distToH12 = [1000,  22,  14,  17]
  distToI12 = [1000,  21,  15,  16]
  distToJ12 = [1000,  20,  16,  15]
  distToK12 = [1000,  19,  17,  14]
  distToL12 = [1000,  18,  18,  13]
  distToN12 = [1000,  20,  20,  15]
  distToB13 = [1000,  25,  13,  22]
  distToF13 = [1000,  25,  13,  18]
  distToH13 = [1000,  23,  15,  16]
  distToL13 = [1000,  19,  19,  12]
  distToN13 = [1000,  21,  21,  14]
  distToB14 = [1000,  26,  14,  21]
  distToC14 = [1000,  27,  15,  20]
  distToD14 = [1000,  28,  16,  19]
  distToF14 = [1000,  26,  14,  17]
  distToH14 = [1000,  24,  16,  15]
  distToI14 = [1000,  25,  17,  14]
  distToJ14 = [1000,  26,  18,  13]
  distToL14 = [1000,  20,  20,  11]
  distToM14 = [1000,  21,  21,  12]
  distToN14 = [1000,  22,  22,  13]
  distToB15 = [1000,  27,  15,  20]
  distToD15 = [1000,  29,  17,  18]
  distToF15 = [1000,  27,  15,  16]
  distToH15 = [1000,  25,  17,  16]
  distToJ15 = [1000,  25,  19,  12]
  distToL15 = [1000,  21,  21,  10]
  distToB16 = [1000,  28,  16,  19]
  distToD16 = [1000,  30,  18,  17]
  distToE16 = [1000,  29,  17,  16]
  distToF16 = [1000,  28,  16,  15]
  distToG16 = [1000,  27,  17,  16]
  distToH16 = [1000,  26,  18,  17]
  distToJ16 = [1000,  24,  20,  11]
  distToK16 = [1000,  23,  21,  10]
  distToL16 = [1000,  22,  22,   9]
  distToB17 = [1000,  29,  17,  18]
  distToF17 = [1000,  29,  17,  14]
  distToL17 = [1000,  23,  23,   8]
  distToB18 = [1000,  30,  18,  17]
  distToC18 = [1000,  31,  19,  16]
  distToD18 = [1000,  32,  20,  15]
  distToE18 = [1000,  31,  19,  14]
  distToF18 = [1000,  30,  18,  13]
  distToG18 = [1000,  29,  19,  12]
  distToH18 = [1000,  28,  20,  11]
  distToI18 = [1000,  27,  21,  10]
  distToJ18 = [1000,  26,  22,   9]
  distToK18 = [1000,  25,  23,   8]
  distToL18 = [1000,  24,  24,   7]
  distToM18 = [1000,  25,  25,   6]
  distToN18 = [1000,  25,  25,   5]
  distToO18 = [1000,  24,  24,   4]
;
modify hacRoomJ2
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [1000,  25,  17,   9]
  distToB2  = [1000,  24,  16,   8]
  distToC2  = [1000,  23,  15,   7]
  distToD2  = [1000,  22,  14,   6]
  distToE2  = [1000,  21,  15,   5]
  distToF2  = [1000,  20,  16,   4]
  distToG2  = [1000,  19,  17,   3]
  distToH2  = [1000,  18,  18,   2]
  distToI2  = [1000,  17,  17,   1]
  distToJ2  = [1000,  16,  16,  20]
  distToK2  = [1000,   1,  15,  21]
  distToL2  = [1000,   2,  14,  22]
  distToM2  = [1000,   3,  13,  23]
  distToN2  = [1000,   4,  12,  24]
  distToD3  = [1000,  23,  13,   7]
  distToJ3  = [1000,  15,   1,  19]
  distToN3  = [1000,   5,  11,  25]
  distToD4  = [1000,  24,  12,   8]
  distToE4  = [1000,  23,  11,   9]
  distToF4  = [1000,  22,  10,  10]
  distToH4  = [1000,  16,   4,  16]
  distToI4  = [1000,  15,   3,  17]
  distToJ4  = [1000,  14,   2,  18]
  distToK4  = [1000,  13,   3,  19]
  distToL4  = [1000,  12,   4,  20]
  distToN4  = [1000,   6,  10,  26]
  distToD5  = [1000,  25,  13,   9]
  distToF5  = [1000,  21,   9,  11]
  distToH5  = [1000,  17,   5,  15]
  distToJ5  = [1000,  15,   3,  19]
  distToL5  = [1000,  11,   5,  21]
  distToN5  = [1000,   7,   9,  25]
  distToB6  = [1000,  28,  16,  12]
  distToC6  = [1000,  27,  15,  11]
  distToD6  = [1000,  26,  14,  10]
  distToF6  = [1000,  20,   8,  12]
  distToG6  = [1000,  19,   7,  13]
  distToH6  = [1000,  18,   6,  14]
  distToJ6  = [1000,  16,   4,  20]
  distToL6  = [1000,  10,   6,  22]
  distToM6  = [1000,   9,   7,  23]
  distToN6  = [1000,   8,   8,  24]
  distToB7  = [1000,  29,  17,  13]
  distToD7  = [1000,  25,  13,  11]
  distToH7  = [1000,  19,   7,  15]
  distToJ7  = [1000,  17,   5,  19]
  distToN7  = [1000,   9,   9,  25]
  distToB8  = [1000,  30,  18,  14]
  distToD8  = [1000,  24,  12,  12]
  distToE8  = [1000,  23,  11,  13]
  distToF8  = [1000,  22,  10,  14]
  distToG8  = [1000,  21,   9,  15]
  distToH8  = [1000,  20,   8,  16]
  distToI8  = [1000,  19,   7,  17]
  distToJ8  = [1000,  18,   6,  18]
  distToK8  = [1000,  17,   7,  19]
  distToL8  = [1000,  16,   8,  20]
  distToN8  = [1000,  10,  10,  25]
  distToB9  = [1000,  29,  17,  15]
  distToD9  = [1000,  25,  13,  13]
  distToL9  = [1000,  15,   9,  21]
  distToN9  = [1000,  11,  11,  24]
  distToB10 = [1000,  28,  16,  16]
  distToC10 = [1000,  27,  15,  15]
  distToD10 = [1000,  26,  14,  14]
  distToL10 = [1000,  14,  10,  21]
  distToM10 = [1000,  13,  11,  22]
  distToN10 = [1000,  12,  12,  23]
  distToB11 = [1000,  29,  17,  17]
  distToD11 = [1000,  25,  15,  15]
  distToL11 = [1000,  15,  11,  20]
  distToN11 = [1000,  13,  13,  22]
  distToB12 = [1000,  30,  18,  18]
  distToD12 = [1000,  24,  16,  16]
  distToE12 = [1000,  23,  17,  17]
  distToF12 = [1000,  22,  18,  18]
  distToG12 = [1000,  21,  17,  19]
  distToH12 = [1000,  20,  16,  20]
  distToI12 = [1000,  19,  15,  21]
  distToJ12 = [1000,  18,  14,  21]
  distToK12 = [1000,  17,  13,  20]
  distToL12 = [1000,  16,  12,  19]
  distToN12 = [1000,  14,  14,  21]
  distToB13 = [1000,  31,  19,  19]
  distToF13 = [1000,  23,  19,  19]
  distToH13 = [1000,  21,  17,  21]
  distToL13 = [1000,  17,  13,  18]
  distToN13 = [1000,  15,  15,  20]
  distToB14 = [1000,  32,  20,  20]
  distToC14 = [1000,  31,  21,  21]
  distToD14 = [1000,  30,  22,  22]
  distToF14 = [1000,  24,  20,  20]
  distToH14 = [1000,  22,  18,  21]
  distToI14 = [1000,  23,  19,  20]
  distToJ14 = [1000,  24,  20,  19]
  distToL14 = [1000,  18,  14,  17]
  distToM14 = [1000,  17,  15,  18]
  distToN14 = [1000,  16,  16,  19]
  distToB15 = [1000,  33,  21,  21]
  distToD15 = [1000,  29,  23,  23]
  distToF15 = [1000,  25,  21,  21]
  distToH15 = [1000,  23,  19,  22]
  distToJ15 = [1000,  23,  19,  18]
  distToL15 = [1000,  19,  15,  16]
  distToB16 = [1000,  34,  22,  22]
  distToD16 = [1000,  28,  24,  23]
  distToE16 = [1000,  27,  23,  22]
  distToF16 = [1000,  26,  22,  21]
  distToG16 = [1000,  25,  21,  22]
  distToH16 = [1000,  24,  20,  23]
  distToJ16 = [1000,  22,  18,  17]
  distToK16 = [1000,  21,  17,  16]
  distToL16 = [1000,  20,  16,  15]
  distToB17 = [1000,  33,  23,  23]
  distToF17 = [1000,  27,  23,  20]
  distToL17 = [1000,  21,  17,  14]
  distToB18 = [1000,  32,  24,  23]
  distToC18 = [1000,  31,  25,  22]
  distToD18 = [1000,  30,  26,  21]
  distToE18 = [1000,  29,  25,  20]
  distToF18 = [1000,  28,  24,  19]
  distToG18 = [1000,  27,  23,  18]
  distToH18 = [1000,  26,  22,  17]
  distToI18 = [1000,  25,  21,  16]
  distToJ18 = [1000,  24,  20,  15]
  distToK18 = [1000,  23,  19,  14]
  distToL18 = [1000,  22,  18,  13]
  distToM18 = [1000,  23,  19,  12]
  distToN18 = [1000,  24,  19,  11]
  distToO18 = [1000,  25,  18,  10]
;
modify hacRoomD4
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [   5,  21,  21,1000]
  distToB2  = [   4,  20,  20,1000]
  distToC2  = [   3,  19,  19,1000]
  distToD2  = [   2,  18,  18,1000]
  distToE2  = [   3,  17,  19,1000]
  distToF2  = [   4,  16,  20,1000]
  distToG2  = [   5,  15,  19,1000]
  distToH2  = [   6,  14,  18,1000]
  distToI2  = [   7,  13,  17,1000]
  distToJ2  = [   8,  12,  16,1000]
  distToK2  = [   9,  13,  17,1000]
  distToL2  = [  10,  14,  18,1000]
  distToM2  = [  11,  15,  19,1000]
  distToN2  = [  12,  16,  20,1000]
  distToD3  = [   1,  17,  17,1000]
  distToJ3  = [   9,  11,  15,1000]
  distToN3  = [  13,  17,  21,1000]
  distToD4  = [  20,  16,  16,1000]
  distToE4  = [  19,   1,  15,1000]
  distToF4  = [  18,   2,  14,1000]
  distToH4  = [  12,   8,  12,1000]
  distToI4  = [  11,   9,  13,1000]
  distToJ4  = [  10,  10,  14,1000]
  distToK4  = [  11,  11,  15,1000]
  distToL4  = [  12,  12,  16,1000]
  distToN4  = [  14,  18,  22,1000]
  distToD5  = [  21,  15,   1,1000]
  distToF5  = [  17,   3,  13,1000]
  distToH5  = [  13,   7,  11,1000]
  distToJ5  = [  11,  11,  13,1000]
  distToL5  = [  13,  13,  17,1000]
  distToN5  = [  15,  17,  21,1000]
  distToB6  = [  24,  16,   4,1000]
  distToC6  = [  23,  15,   3,1000]
  distToD6  = [  22,  14,   2,1000]
  distToF6  = [  16,   4,  12,1000]
  distToG6  = [  15,   5,  11,1000]
  distToH6  = [  14,   6,  10,1000]
  distToJ6  = [  12,  12,  12,1000]
  distToL6  = [  14,  14,  18,1000]
  distToM6  = [  15,  15,  19,1000]
  distToN6  = [  16,  16,  20,1000]
  distToB7  = [  25,  17,   5,1000]
  distToD7  = [  21,  13,   3,1000]
  distToH7  = [  15,   7,   9,1000]
  distToJ7  = [  13,  11,  11,1000]
  distToN7  = [  17,  17,  19,1000]
  distToB8  = [  26,  18,   6,1000]
  distToD8  = [  20,  12,   4,1000]
  distToE8  = [  19,  11,   5,1000]
  distToF8  = [  18,  10,   6,1000]
  distToG8  = [  17,   9,   7,1000]
  distToH8  = [  16,   8,   8,1000]
  distToI8  = [  15,   9,   9,1000]
  distToJ8  = [  14,  10,  10,1000]
  distToK8  = [  15,  11,  11,1000]
  distToL8  = [  16,  12,  12,1000]
  distToN8  = [  18,  18,  18,1000]
  distToB9  = [  25,  17,   7,1000]
  distToD9  = [  21,  13,   5,1000]
  distToL9  = [  17,  13,  13,1000]
  distToN9  = [  19,  17,  17,1000]
  distToB10 = [  24,  16,   8,1000]
  distToC10 = [  23,  15,   7,1000]
  distToD10 = [  22,  14,   6,1000]
  distToL10 = [  17,  14,  14,1000]
  distToM10 = [  18,  15,  15,1000]
  distToN10 = [  19,  16,  16,1000]
  distToB11 = [  25,  17,   9,1000]
  distToD11 = [  23,  15,   7,1000]
  distToL11 = [  16,  15,  15,1000]
  distToN11 = [  18,  17,  17,1000]
  distToB12 = [  25,  18,  10,1000]
  distToD12 = [  23,  16,   8,1000]
  distToE12 = [  22,  17,   9,1000]
  distToF12 = [  21,  18,  10,1000]
  distToG12 = [  20,  19,  11,1000]
  distToH12 = [  19,  20,  12,1000]
  distToI12 = [  18,  19,  13,1000]
  distToJ12 = [  17,  18,  14,1000]
  distToK12 = [  16,  17,  15,1000]
  distToL12 = [  15,  16,  16,1000]
  distToN12 = [  17,  18,  18,1000]
  distToB13 = [  24,  19,  11,1000]
  distToF13 = [  20,  19,  11,1000]
  distToH13 = [  18,  21,  13,1000]
  distToL13 = [  14,  17,  17,1000]
  distToN13 = [  16,  19,  19,1000]
  distToB14 = [  23,  20,  12,1000]
  distToC14 = [  22,  21,  13,1000]
  distToD14 = [  21,  22,  14,1000]
  distToF14 = [  19,  20,  12,1000]
  distToH14 = [  17,  22,  14,1000]
  distToI14 = [  16,  23,  15,1000]
  distToJ14 = [  15,  24,  16,1000]
  distToL14 = [  13,  18,  18,1000]
  distToM14 = [  14,  19,  19,1000]
  distToN14 = [  15,  20,  20,1000]
  distToB15 = [  22,  21,  13,1000]
  distToD15 = [  20,  23,  15,1000]
  distToF15 = [  18,  21,  13,1000]
  distToH15 = [  18,  23,  15,1000]
  distToJ15 = [  14,  23,  17,1000]
  distToL15 = [  12,  19,  19,1000]
  distToB16 = [  21,  22,  14,1000]
  distToD16 = [  19,  24,  16,1000]
  distToE16 = [  18,  23,  15,1000]
  distToF16 = [  17,  22,  14,1000]
  distToG16 = [  18,  23,  15,1000]
  distToH16 = [  19,  24,  16,1000]
  distToJ16 = [  13,  22,  18,1000]
  distToK16 = [  12,  21,  19,1000]
  distToL16 = [  11,  20,  20,1000]
  distToB17 = [  20,  23,  15,1000]
  distToF17 = [  16,  23,  15,1000]
  distToL17 = [  10,  21,  21,1000]
  distToB18 = [  19,  24,  16,1000]
  distToC18 = [  18,  25,  17,1000]
  distToD18 = [  17,  26,  18,1000]
  distToE18 = [  16,  25,  17,1000]
  distToF18 = [  15,  24,  16,1000]
  distToG18 = [  14,  25,  17,1000]
  distToH18 = [  13,  26,  18,1000]
  distToI18 = [  12,  25,  19,1000]
  distToJ18 = [  11,  24,  20,1000]
  distToK18 = [  10,  23,  21,1000]
  distToL18 = [   9,  22,  22,1000]
  distToM18 = [   8,  23,  23,1000]
  distToN18 = [   7,  23,  23,1000]
  distToO18 = [   6,  22,  22,1000]
;
modify hacRoomJ4
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  11,  23,  19,  15]
  distToB2  = [  10,  22,  18,  14]
  distToC2  = [   9,  21,  17,  13]
  distToD2  = [   8,  20,  16,  12]
  distToE2  = [   7,  19,  17,  13]
  distToF2  = [   6,  18,  18,  14]
  distToG2  = [   5,  17,  17,  15]
  distToH2  = [   4,  16,  16,  16]
  distToI2  = [   3,  15,  15,  15]
  distToJ2  = [   2,  14,  14,  14]
  distToK2  = [   3,  13,  15,  15]
  distToL2  = [   4,  12,  16,  16]
  distToM2  = [   5,  11,  17,  17]
  distToN2  = [   6,  10,  18,  18]
  distToD3  = [   9,  21,  15,  11]
  distToJ3  = [   1,  15,  13,  13]
  distToN3  = [   7,   9,  17,  19]
  distToD4  = [  10,  22,  14,  10]
  distToE4  = [  11,  23,  13,   9]
  distToF4  = [  12,  24,  12,   8]
  distToH4  = [  18,  18,  10,   2]
  distToI4  = [  17,  17,  11,   1]
  distToJ4  = [  16,  16,  12,  12]
  distToK4  = [  15,   1,  13,  13]
  distToL4  = [  14,   2,  14,  14]
  distToN4  = [   8,   8,  16,  20]
  distToD5  = [  11,  23,  13,  11]
  distToF5  = [  13,  23,  11,   7]
  distToH5  = [  17,  19,   9,   3]
  distToJ5  = [  17,  17,   1,  11]
  distToL5  = [  13,   3,  15,  15]
  distToN5  = [   9,   7,  15,  19]
  distToB6  = [  14,  26,  14,  14]
  distToC6  = [  13,  25,  13,  13]
  distToD6  = [  12,  24,  12,  12]
  distToF6  = [  14,  22,  10,   6]
  distToG6  = [  15,  21,   9,   5]
  distToH6  = [  16,  20,   8,   4]
  distToJ6  = [  18,  18,   2,  10]
  distToL6  = [  12,   4,  16,  16]
  distToM6  = [  11,   5,  15,  17]
  distToN6  = [  10,   6,  14,  18]
  distToB7  = [  15,  27,  15,  15]
  distToD7  = [  13,  23,  11,  11]
  distToH7  = [  17,  19,   7,   5]
  distToJ7  = [  19,  17,   3,   9]
  distToN7  = [  11,   7,  13,  17]
  distToB8  = [  16,  28,  16,  16]
  distToD8  = [  14,  22,  10,  10]
  distToE8  = [  15,  21,   9,   9]
  distToF8  = [  16,  20,   8,   8]
  distToG8  = [  17,  19,   7,   7]
  distToH8  = [  18,  18,   6,   6]
  distToI8  = [  19,  17,   5,   7]
  distToJ8  = [  20,  16,   4,   8]
  distToK8  = [  19,  15,   5,   9]
  distToL8  = [  18,  14,   6,  10]
  distToN8  = [  12,   8,  12,  16]
  distToB9  = [  17,  27,  15,  15]
  distToD9  = [  15,  23,  11,  11]
  distToL9  = [  17,  13,   7,  11]
  distToN9  = [  13,   9,  11,  15]
  distToB10 = [  18,  26,  14,  14]
  distToC10 = [  17,  25,  13,  13]
  distToD10 = [  16,  24,  12,  12]
  distToL10 = [  16,  12,   8,  12]
  distToM10 = [  15,  11,   9,  13]
  distToN10 = [  14,  10,  10,  14]
  distToB11 = [  19,  27,  15,  15]
  distToD11 = [  17,  23,  13,  13]
  distToL11 = [  17,  13,   9,  13]
  distToN11 = [  15,  11,  11,  15]
  distToB12 = [  20,  28,  16,  16]
  distToD12 = [  18,  22,  14,  14]
  distToE12 = [  19,  21,  15,  15]
  distToF12 = [  20,  20,  16,  16]
  distToG12 = [  21,  19,  15,  17]
  distToH12 = [  22,  18,  14,  18]
  distToI12 = [  21,  17,  13,  17]
  distToJ12 = [  20,  16,  12,  16]
  distToK12 = [  19,  15,  11,  15]
  distToL12 = [  18,  14,  10,  14]
  distToN12 = [  16,  12,  12,  16]
  distToB13 = [  21,  29,  17,  17]
  distToF13 = [  21,  21,  17,  17]
  distToH13 = [  23,  19,  15,  19]
  distToL13 = [  19,  15,  11,  15]
  distToN13 = [  17,  13,  13,  17]
  distToB14 = [  22,  30,  18,  18]
  distToC14 = [  23,  29,  19,  19]
  distToD14 = [  24,  28,  20,  20]
  distToF14 = [  22,  22,  18,  18]
  distToH14 = [  23,  20,  16,  20]
  distToI14 = [  22,  21,  17,  21]
  distToJ14 = [  21,  22,  18,  22]
  distToL14 = [  19,  16,  12,  16]
  distToM14 = [  19,  15,  13,  17]
  distToN14 = [  18,  14,  14,  18]
  distToB15 = [  23,  31,  19,  19]
  distToD15 = [  25,  27,  21,  21]
  distToF15 = [  23,  23,  19,  19]
  distToH15 = [  24,  21,  17,  21]
  distToJ15 = [  20,  21,  17,  21]
  distToL15 = [  18,  17,  13,  17]
  distToB16 = [  24,  32,  20,  20]
  distToD16 = [  25,  26,  22,  22]
  distToE16 = [  24,  25,  21,  21]
  distToF16 = [  23,  24,  20,  20]
  distToG16 = [  24,  23,  19,  21]
  distToH16 = [  25,  22,  18,  22]
  distToJ16 = [  19,  20,  16,  20]
  distToK16 = [  18,  19,  15,  19]
  distToL16 = [  17,  18,  14,  18]
  distToB17 = [  25,  31,  21,  21]
  distToF17 = [  22,  25,  21,  21]
  distToL17 = [  16,  19,  15,  19]
  distToB18 = [  25,  30,  22,  22]
  distToC18 = [  24,  29,  23,  23]
  distToD18 = [  23,  28,  24,  24]
  distToE18 = [  22,  27,  23,  23]
  distToF18 = [  21,  26,  22,  22]
  distToG18 = [  20,  25,  21,  23]
  distToH18 = [  19,  24,  20,  23]
  distToI18 = [  18,  23,  19,  22]
  distToJ18 = [  17,  22,  18,  21]
  distToK18 = [  16,  21,  17,  20]
  distToL18 = [  15,  20,  16,  19]
  distToM18 = [  14,  21,  17,  18]
  distToN18 = [  13,  22,  18,  17]
  distToO18 = [  12,  23,  19,  16]
;
modify hacRoomD6
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [   7,1000,  19,  19]
  distToB2  = [   6,1000,  18,  18]
  distToC2  = [   5,1000,  17,  17]
  distToD2  = [   4,1000,  16,  16]
  distToE2  = [   5,1000,  17,  17]
  distToF2  = [   6,1000,  18,  18]
  distToG2  = [   7,1000,  17,  19]
  distToH2  = [   8,1000,  16,  20]
  distToI2  = [   9,1000,  15,  21]
  distToJ2  = [  10,1000,  14,  22]
  distToK2  = [  11,1000,  15,  23]
  distToL2  = [  12,1000,  16,  24]
  distToM2  = [  13,1000,  17,  25]
  distToN2  = [  14,1000,  18,  26]
  distToD3  = [   3,1000,  15,  15]
  distToJ3  = [  11,1000,  13,  21]
  distToN3  = [  15,1000,  19,  27]
  distToD4  = [   2,1000,  14,  14]
  distToE4  = [   3,1000,  13,  15]
  distToF4  = [   4,1000,  12,  16]
  distToH4  = [  10,1000,  10,  18]
  distToI4  = [  11,1000,  11,  19]
  distToJ4  = [  12,1000,  12,  20]
  distToK4  = [  13,1000,  13,  21]
  distToL4  = [  14,1000,  14,  22]
  distToN4  = [  16,1000,  20,  28]
  distToD5  = [   1,1000,  13,  13]
  distToF5  = [   5,1000,  11,  17]
  distToH5  = [   9,1000,   9,  17]
  distToJ5  = [  13,1000,  11,  19]
  distToL5  = [  15,1000,  15,  23]
  distToN5  = [  17,1000,  19,  27]
  distToB6  = [  18,1000,  10,   2]
  distToC6  = [  17,1000,  11,   1]
  distToD6  = [  16,1000,  12,  12]
  distToF6  = [   6,1000,  10,  18]
  distToG6  = [   7,1000,   9,  17]
  distToH6  = [   8,1000,   8,  16]
  distToJ6  = [  14,1000,  10,  18]
  distToL6  = [  16,1000,  16,  24]
  distToM6  = [  17,1000,  17,  25]
  distToN6  = [  18,1000,  18,  26]
  distToB7  = [  19,1000,   9,   3]
  distToD7  = [  15,1000,   1,  11]
  distToH7  = [   9,1000,   7,  15]
  distToJ7  = [  13,1000,   9,  17]
  distToN7  = [  19,1000,  17,  25]
  distToB8  = [  20,1000,   8,   4]
  distToD8  = [  14,1000,   2,  10]
  distToE8  = [  13,1000,   3,  11]
  distToF8  = [  12,1000,   4,  12]
  distToG8  = [  11,1000,   5,  13]
  distToH8  = [  10,1000,   6,  14]
  distToI8  = [  11,1000,   7,  15]
  distToJ8  = [  12,1000,   8,  16]
  distToK8  = [  13,1000,   9,  17]
  distToL8  = [  14,1000,  10,  18]
  distToN8  = [  20,1000,  16,  24]
  distToB9  = [  19,1000,   7,   5]
  distToD9  = [  15,1000,   3,   9]
  distToL9  = [  15,1000,  11,  19]
  distToN9  = [  19,1000,  15,  23]
  distToB10 = [  18,1000,   6,   6]
  distToC10 = [  17,1000,   5,   7]
  distToD10 = [  16,1000,   4,   8]
  distToL10 = [  16,1000,  12,  20]
  distToM10 = [  17,1000,  13,  21]
  distToN10 = [  18,1000,  14,  22]
  distToB11 = [  19,1000,   7,   7]
  distToD11 = [  17,1000,   5,   9]
  distToL11 = [  17,1000,  13,  19]
  distToN11 = [  19,1000,  15,  23]
  distToB12 = [  20,1000,   8,   8]
  distToD12 = [  18,1000,   6,  10]
  distToE12 = [  19,1000,   7,  11]
  distToF12 = [  20,1000,   8,  12]
  distToG12 = [  21,1000,   9,  13]
  distToH12 = [  21,1000,  10,  14]
  distToI12 = [  20,1000,  11,  15]
  distToJ12 = [  19,1000,  12,  16]
  distToK12 = [  18,1000,  13,  17]
  distToL12 = [  17,1000,  14,  18]
  distToN12 = [  19,1000,  16,  24]
  distToB13 = [  21,1000,   9,   9]
  distToF13 = [  21,1000,   9,  13]
  distToH13 = [  20,1000,  11,  15]
  distToL13 = [  16,1000,  15,  19]
  distToN13 = [  18,1000,  17,  23]
  distToB14 = [  22,1000,  10,  10]
  distToC14 = [  23,1000,  11,  11]
  distToD14 = [  23,1000,  12,  12]
  distToF14 = [  21,1000,  10,  14]
  distToH14 = [  19,1000,  12,  16]
  distToI14 = [  18,1000,  13,  17]
  distToJ14 = [  17,1000,  14,  18]
  distToL14 = [  15,1000,  16,  20]
  distToM14 = [  16,1000,  17,  21]
  distToN14 = [  17,1000,  18,  22]
  distToB15 = [  23,1000,  11,  11]
  distToD15 = [  22,1000,  13,  13]
  distToF15 = [  20,1000,  11,  15]
  distToH15 = [  20,1000,  13,  17]
  distToJ15 = [  16,1000,  15,  19]
  distToL15 = [  14,1000,  17,  21]
  distToB16 = [  23,1000,  12,  12]
  distToD16 = [  21,1000,  14,  14]
  distToE16 = [  20,1000,  13,  15]
  distToF16 = [  19,1000,  12,  16]
  distToG16 = [  20,1000,  13,  17]
  distToH16 = [  21,1000,  14,  18]
  distToJ16 = [  15,1000,  16,  20]
  distToK16 = [  14,1000,  17,  21]
  distToL16 = [  13,1000,  18,  22]
  distToB17 = [  22,1000,  13,  13]
  distToF17 = [  18,1000,  13,  17]
  distToL17 = [  12,1000,  19,  23]
  distToB18 = [  21,1000,  14,  14]
  distToC18 = [  20,1000,  15,  15]
  distToD18 = [  19,1000,  16,  16]
  distToE18 = [  18,1000,  15,  17]
  distToF18 = [  17,1000,  14,  18]
  distToG18 = [  16,1000,  15,  19]
  distToH18 = [  15,1000,  16,  20]
  distToI18 = [  14,1000,  17,  21]
  distToJ18 = [  13,1000,  18,  22]
  distToK18 = [  12,1000,  19,  23]
  distToL18 = [  11,1000,  20,  23]
  distToM18 = [  10,1000,  21,  22]
  distToN18 = [   9,1000,  21,  21]
  distToO18 = [   8,1000,  20,  20]
;
modify hacRoomH6
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  15,1000,  15,  11]
  distToB2  = [  14,1000,  14,  10]
  distToC2  = [  13,1000,  13,   9]
  distToD2  = [  12,1000,  12,   8]
  distToE2  = [  11,1000,  13,   9]
  distToF2  = [  10,1000,  14,  10]
  distToG2  = [   9,1000,  13,  11]
  distToH2  = [   8,1000,  12,  12]
  distToI2  = [   7,1000,  11,  13]
  distToJ2  = [   6,1000,  10,  14]
  distToK2  = [   7,1000,  11,  15]
  distToL2  = [   8,1000,  12,  16]
  distToM2  = [   9,1000,  13,  17]
  distToN2  = [  10,1000,  14,  18]
  distToD3  = [  13,1000,  11,   7]
  distToJ3  = [   5,1000,   9,  15]
  distToN3  = [  11,1000,  15,  19]
  distToD4  = [  14,1000,  10,   6]
  distToE4  = [  15,1000,  11,   5]
  distToF4  = [  16,1000,  12,   4]
  distToH4  = [   2,1000,  10,  18]
  distToI4  = [   3,1000,   9,  17]
  distToJ4  = [   4,1000,   8,  16]
  distToK4  = [   5,1000,   9,  17]
  distToL4  = [   6,1000,  10,  18]
  distToN4  = [  12,1000,  16,  20]
  distToD5  = [  15,1000,   9,   7]
  distToF5  = [  15,1000,  13,   3]
  distToH5  = [   1,1000,  11,  17]
  distToJ5  = [   5,1000,   7,  17]
  distToL5  = [   7,1000,  11,  19]
  distToN5  = [  11,1000,  15,  21]
  distToB6  = [  18,1000,  10,  10]
  distToC6  = [  17,1000,   9,   9]
  distToD6  = [  16,1000,   8,   8]
  distToF6  = [  14,1000,  14,   2]
  distToG6  = [  13,1000,  13,   1]
  distToH6  = [  12,1000,  12,  16]
  distToJ6  = [   6,1000,   6,  18]
  distToL6  = [   8,1000,  12,  20]
  distToM6  = [   9,1000,  13,  21]
  distToN6  = [  10,1000,  14,  22]
  distToB7  = [  19,1000,  11,  11]
  distToD7  = [  15,1000,   7,   9]
  distToH7  = [  11,1000,   1,  15]
  distToJ7  = [   7,1000,   5,  17]
  distToN7  = [  11,1000,  13,  23]
  distToB8  = [  20,1000,  12,  12]
  distToD8  = [  14,1000,   6,  10]
  distToE8  = [  13,1000,   5,  11]
  distToF8  = [  12,1000,   4,  12]
  distToG8  = [  11,1000,   3,  13]
  distToH8  = [  10,1000,   2,  14]
  distToI8  = [   9,1000,   3,  15]
  distToJ8  = [   8,1000,   4,  16]
  distToK8  = [   9,1000,   5,  17]
  distToL8  = [  10,1000,   6,  18]
  distToN8  = [  12,1000,  12,  24]
  distToB9  = [  19,1000,  11,  13]
  distToD9  = [  15,1000,   7,  11]
  distToL9  = [  11,1000,   7,  19]
  distToN9  = [  13,1000,  11,  23]
  distToB10 = [  18,1000,  10,  14]
  distToC10 = [  17,1000,   9,  13]
  distToD10 = [  16,1000,   8,  12]
  distToL10 = [  12,1000,   8,  20]
  distToM10 = [  13,1000,   9,  21]
  distToN10 = [  14,1000,  10,  22]
  distToB11 = [  19,1000,  11,  15]
  distToD11 = [  17,1000,   9,  13]
  distToL11 = [  13,1000,   9,  21]
  distToN11 = [  15,1000,  11,  23]
  distToB12 = [  20,1000,  12,  16]
  distToD12 = [  18,1000,  10,  14]
  distToE12 = [  19,1000,  11,  15]
  distToF12 = [  20,1000,  12,  16]
  distToG12 = [  19,1000,  13,  17]
  distToH12 = [  18,1000,  14,  18]
  distToI12 = [  17,1000,  13,  19]
  distToJ12 = [  16,1000,  12,  20]
  distToK12 = [  15,1000,  11,  21]
  distToL12 = [  14,1000,  10,  21]
  distToN12 = [  16,1000,  12,  23]
  distToB13 = [  21,1000,  13,  17]
  distToF13 = [  21,1000,  13,  17]
  distToH13 = [  19,1000,  15,  19]
  distToL13 = [  15,1000,  11,  20]
  distToN13 = [  17,1000,  13,  22]
  distToB14 = [  22,1000,  14,  18]
  distToC14 = [  23,1000,  15,  19]
  distToD14 = [  24,1000,  16,  20]
  distToF14 = [  22,1000,  14,  18]
  distToH14 = [  20,1000,  16,  20]
  distToI14 = [  21,1000,  17,  21]
  distToJ14 = [  22,1000,  18,  21]
  distToL14 = [  16,1000,  12,  19]
  distToM14 = [  17,1000,  13,  20]
  distToN14 = [  18,1000,  14,  21]
  distToB15 = [  23,1000,  15,  19]
  distToD15 = [  25,1000,  17,  21]
  distToF15 = [  23,1000,  15,  19]
  distToH15 = [  21,1000,  17,  21]
  distToJ15 = [  21,1000,  17,  20]
  distToL15 = [  17,1000,  13,  18]
  distToB16 = [  24,1000,  16,  20]
  distToD16 = [  26,1000,  18,  22]
  distToE16 = [  25,1000,  17,  21]
  distToF16 = [  24,1000,  16,  20]
  distToG16 = [  23,1000,  17,  21]
  distToH16 = [  22,1000,  18,  22]
  distToJ16 = [  20,1000,  16,  19]
  distToK16 = [  19,1000,  15,  18]
  distToL16 = [  18,1000,  14,  17]
  distToB17 = [  25,1000,  17,  21]
  distToF17 = [  25,1000,  17,  21]
  distToL17 = [  19,1000,  15,  16]
  distToB18 = [  26,1000,  18,  22]
  distToC18 = [  27,1000,  19,  23]
  distToD18 = [  27,1000,  20,  23]
  distToE18 = [  26,1000,  19,  22]
  distToF18 = [  25,1000,  18,  21]
  distToG18 = [  24,1000,  19,  20]
  distToH18 = [  23,1000,  20,  19]
  distToI18 = [  22,1000,  19,  18]
  distToJ18 = [  21,1000,  18,  17]
  distToK18 = [  20,1000,  17,  16]
  distToL18 = [  19,1000,  16,  15]
  distToM18 = [  18,1000,  17,  14]
  distToN18 = [  17,1000,  17,  13]
  distToO18 = [  16,1000,  16,  12]
;
modify hacRoomN6
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  17,1000,  18,  17]
  distToB2  = [  16,1000,  19,  16]
  distToC2  = [  15,1000,  20,  15]
  distToD2  = [  14,1000,  21,  14]
  distToE2  = [  13,1000,  21,  13]
  distToF2  = [  12,1000,  20,  12]
  distToG2  = [  11,1000,  19,  11]
  distToH2  = [  10,1000,  18,  10]
  distToI2  = [   9,1000,  17,   9]
  distToJ2  = [   8,1000,  16,   8]
  distToK2  = [   7,1000,  17,   9]
  distToL2  = [   6,1000,  18,  10]
  distToM2  = [   5,1000,  19,  11]
  distToN2  = [   4,1000,  20,  12]
  distToD3  = [  15,1000,  21,  15]
  distToJ3  = [   9,1000,  15,   7]
  distToN3  = [   3,1000,  21,  13]
  distToD4  = [  16,1000,  20,  16]
  distToE4  = [  17,1000,  19,  15]
  distToF4  = [  18,1000,  18,  14]
  distToH4  = [  12,1000,  16,   8]
  distToI4  = [  11,1000,  15,   7]
  distToJ4  = [  10,1000,  14,   6]
  distToK4  = [  11,1000,  15,   5]
  distToL4  = [  12,1000,  16,   4]
  distToN4  = [   2,1000,  22,  14]
  distToD5  = [  17,1000,  19,  17]
  distToF5  = [  17,1000,  17,  13]
  distToH5  = [  13,1000,  15,   9]
  distToJ5  = [  11,1000,  13,   7]
  distToL5  = [  13,1000,  17,   3]
  distToN5  = [   1,1000,  21,  15]
  distToB6  = [  20,1000,  20,  20]
  distToC6  = [  19,1000,  19,  19]
  distToD6  = [  18,1000,  18,  18]
  distToF6  = [  16,1000,  16,  12]
  distToG6  = [  15,1000,  15,  11]
  distToH6  = [  14,1000,  14,  10]
  distToJ6  = [  12,1000,  12,   8]
  distToL6  = [  14,1000,  18,   2]
  distToM6  = [  15,1000,  19,   1]
  distToN6  = [  16,1000,  20,  16]
  distToB7  = [  21,1000,  21,  21]
  distToD7  = [  19,1000,  17,  17]
  distToH7  = [  15,1000,  13,  11]
  distToJ7  = [  13,1000,  11,   9]
  distToN7  = [  17,1000,   1,  17]
  distToB8  = [  22,1000,  22,  22]
  distToD8  = [  20,1000,  16,  16]
  distToE8  = [  19,1000,  15,  15]
  distToF8  = [  18,1000,  14,  14]
  distToG8  = [  17,1000,  13,  13]
  distToH8  = [  16,1000,  12,  12]
  distToI8  = [  15,1000,  11,  11]
  distToJ8  = [  14,1000,  10,  10]
  distToK8  = [  15,1000,   9,  11]
  distToL8  = [  16,1000,   8,  12]
  distToN8  = [  18,1000,   2,  18]
  distToB9  = [  23,1000,  21,  21]
  distToD9  = [  21,1000,  17,  17]
  distToL9  = [  17,1000,   7,  13]
  distToN9  = [  19,1000,   3,  17]
  distToB10 = [  24,1000,  20,  20]
  distToC10 = [  23,1000,  19,  19]
  distToD10 = [  22,1000,  18,  18]
  distToL10 = [  18,1000,   6,  14]
  distToM10 = [  19,1000,   5,  15]
  distToN10 = [  20,1000,   4,  16]
  distToB11 = [  25,1000,  21,  21]
  distToD11 = [  23,1000,  17,  19]
  distToL11 = [  19,1000,   7,  15]
  distToN11 = [  21,1000,   5,  17]
  distToB12 = [  26,1000,  22,  22]
  distToD12 = [  24,1000,  16,  20]
  distToE12 = [  25,1000,  15,  21]
  distToF12 = [  26,1000,  14,  22]
  distToG12 = [  25,1000,  13,  21]
  distToH12 = [  24,1000,  12,  20]
  distToI12 = [  23,1000,  11,  19]
  distToJ12 = [  22,1000,  10,  18]
  distToK12 = [  21,1000,   9,  17]
  distToL12 = [  20,1000,   8,  16]
  distToN12 = [  22,1000,   6,  18]
  distToB13 = [  27,1000,  23,  23]
  distToF13 = [  27,1000,  15,  23]
  distToH13 = [  25,1000,  13,  21]
  distToL13 = [  21,1000,   9,  17]
  distToN13 = [  23,1000,   7,  19]
  distToB14 = [  28,1000,  24,  24]
  distToC14 = [  29,1000,  23,  25]
  distToD14 = [  30,1000,  22,  26]
  distToF14 = [  28,1000,  16,  24]
  distToH14 = [  26,1000,  14,  22]
  distToI14 = [  27,1000,  15,  23]
  distToJ14 = [  27,1000,  16,  24]
  distToL14 = [  22,1000,  10,  18]
  distToM14 = [  23,1000,   9,  19]
  distToN14 = [  24,1000,   8,  20]
  distToB15 = [  29,1000,  25,  25]
  distToD15 = [  31,1000,  21,  27]
  distToF15 = [  29,1000,  17,  25]
  distToH15 = [  27,1000,  15,  23]
  distToJ15 = [  26,1000,  15,  23]
  distToL15 = [  23,1000,  11,  19]
  distToB16 = [  30,1000,  26,  26]
  distToD16 = [  31,1000,  20,  28]
  distToE16 = [  30,1000,  19,  27]
  distToF16 = [  29,1000,  18,  26]
  distToG16 = [  29,1000,  17,  25]
  distToH16 = [  28,1000,  16,  24]
  distToJ16 = [  25,1000,  14,  22]
  distToK16 = [  24,1000,  13,  21]
  distToL16 = [  23,1000,  12,  20]
  distToB17 = [  31,1000,  25,  27]
  distToF17 = [  28,1000,  19,  27]
  distToL17 = [  22,1000,  13,  21]
  distToB18 = [  31,1000,  24,  28]
  distToC18 = [  30,1000,  23,  29]
  distToD18 = [  29,1000,  22,  29]
  distToE18 = [  28,1000,  21,  28]
  distToF18 = [  27,1000,  20,  27]
  distToG18 = [  26,1000,  19,  26]
  distToH18 = [  25,1000,  18,  25]
  distToI18 = [  24,1000,  17,  24]
  distToJ18 = [  23,1000,  16,  23]
  distToK18 = [  22,1000,  15,  22]
  distToL18 = [  21,1000,  14,  21]
  distToM18 = [  20,1000,  15,  20]
  distToN18 = [  19,1000,  16,  19]
  distToO18 = [  18,1000,  17,  18]
;
modify hacRoomD8
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [   9,  17,  17,1000]
  distToB2  = [   8,  16,  16,1000]
  distToC2  = [   7,  15,  15,1000]
  distToD2  = [   6,  14,  14,1000]
  distToE2  = [   7,  15,  15,1000]
  distToF2  = [   8,  16,  16,1000]
  distToG2  = [   9,  15,  17,1000]
  distToH2  = [  10,  14,  18,1000]
  distToI2  = [  11,  13,  19,1000]
  distToJ2  = [  12,  12,  20,1000]
  distToK2  = [  13,  13,  21,1000]
  distToL2  = [  14,  14,  22,1000]
  distToM2  = [  15,  15,  23,1000]
  distToN2  = [  16,  16,  24,1000]
  distToD3  = [   5,  13,  13,1000]
  distToJ3  = [  13,  11,  21,1000]
  distToN3  = [  17,  17,  23,1000]
  distToD4  = [   4,  12,  12,1000]
  distToE4  = [   5,  11,  13,1000]
  distToF4  = [   6,  10,  14,1000]
  distToH4  = [  12,   8,  20,1000]
  distToI4  = [  13,   9,  21,1000]
  distToJ4  = [  14,  10,  22,1000]
  distToK4  = [  15,  11,  23,1000]
  distToL4  = [  16,  12,  24,1000]
  distToN4  = [  18,  18,  22,1000]
  distToD5  = [   3,  13,  11,1000]
  distToF5  = [   7,   9,  15,1000]
  distToH5  = [  11,   7,  19,1000]
  distToJ5  = [  15,   9,  21,1000]
  distToL5  = [  17,  13,  23,1000]
  distToN5  = [  19,  17,  21,1000]
  distToB6  = [   4,  16,   8,1000]
  distToC6  = [   3,  15,   9,1000]
  distToD6  = [   2,  14,  10,1000]
  distToF6  = [   8,   8,  16,1000]
  distToG6  = [   9,   7,  17,1000]
  distToH6  = [  10,   6,  18,1000]
  distToJ6  = [  16,   8,  20,1000]
  distToL6  = [  18,  14,  22,1000]
  distToM6  = [  19,  15,  21,1000]
  distToN6  = [  20,  16,  20,1000]
  distToB7  = [   5,  17,   7,1000]
  distToD7  = [   1,  15,  11,1000]
  distToH7  = [  11,   5,  17,1000]
  distToJ7  = [  15,   7,  19,1000]
  distToN7  = [  21,  15,  19,1000]
  distToB8  = [   6,  18,   6,1000]
  distToD8  = [  12,  16,  12,1000]
  distToE8  = [  13,   1,  13,1000]
  distToF8  = [  14,   2,  14,1000]
  distToG8  = [  13,   3,  15,1000]
  distToH8  = [  12,   4,  16,1000]
  distToI8  = [  13,   5,  17,1000]
  distToJ8  = [  14,   6,  18,1000]
  distToK8  = [  15,   7,  17,1000]
  distToL8  = [  16,   8,  16,1000]
  distToN8  = [  22,  14,  18,1000]
  distToB9  = [   7,  19,   5,1000]
  distToD9  = [  11,  17,   1,1000]
  distToL9  = [  17,   9,  15,1000]
  distToN9  = [  21,  13,  17,1000]
  distToB10 = [   8,  20,   4,1000]
  distToC10 = [   9,  19,   3,1000]
  distToD10 = [  10,  18,   2,1000]
  distToL10 = [  18,  10,  14,1000]
  distToM10 = [  19,  11,  15,1000]
  distToN10 = [  20,  12,  16,1000]
  distToB11 = [   9,  21,   5,1000]
  distToD11 = [  11,  19,   3,1000]
  distToL11 = [  19,  11,  13,1000]
  distToN11 = [  21,  13,  17,1000]
  distToB12 = [  10,  22,   6,1000]
  distToD12 = [  12,  20,   4,1000]
  distToE12 = [  13,  19,   5,1000]
  distToF12 = [  14,  18,   6,1000]
  distToG12 = [  15,  17,   7,1000]
  distToH12 = [  16,  16,   8,1000]
  distToI12 = [  17,  15,   9,1000]
  distToJ12 = [  18,  14,  10,1000]
  distToK12 = [  19,  13,  11,1000]
  distToL12 = [  19,  12,  12,1000]
  distToN12 = [  21,  14,  18,1000]
  distToB13 = [  11,  23,   7,1000]
  distToF13 = [  15,  19,   7,1000]
  distToH13 = [  17,  17,   9,1000]
  distToL13 = [  18,  13,  13,1000]
  distToN13 = [  20,  15,  17,1000]
  distToB14 = [  12,  24,   8,1000]
  distToC14 = [  13,  25,   9,1000]
  distToD14 = [  14,  26,  10,1000]
  distToF14 = [  16,  20,   8,1000]
  distToH14 = [  18,  18,  10,1000]
  distToI14 = [  19,  19,  11,1000]
  distToJ14 = [  19,  20,  12,1000]
  distToL14 = [  17,  14,  14,1000]
  distToM14 = [  18,  15,  15,1000]
  distToN14 = [  19,  16,  16,1000]
  distToB15 = [  13,  25,   9,1000]
  distToD15 = [  15,  25,  11,1000]
  distToF15 = [  17,  21,   9,1000]
  distToH15 = [  19,  19,  11,1000]
  distToJ15 = [  18,  19,  13,1000]
  distToL15 = [  16,  15,  15,1000]
  distToB16 = [  14,  26,  10,1000]
  distToD16 = [  16,  24,  12,1000]
  distToE16 = [  17,  23,  11,1000]
  distToF16 = [  18,  22,  10,1000]
  distToG16 = [  19,  21,  11,1000]
  distToH16 = [  20,  20,  12,1000]
  distToJ16 = [  17,  18,  14,1000]
  distToK16 = [  16,  17,  15,1000]
  distToL16 = [  15,  16,  16,1000]
  distToB17 = [  15,  27,  11,1000]
  distToF17 = [  19,  23,  11,1000]
  distToL17 = [  14,  17,  17,1000]
  distToB18 = [  16,  28,  12,1000]
  distToC18 = [  17,  27,  13,1000]
  distToD18 = [  18,  26,  14,1000]
  distToE18 = [  19,  25,  13,1000]
  distToF18 = [  19,  24,  12,1000]
  distToG18 = [  18,  23,  13,1000]
  distToH18 = [  17,  22,  14,1000]
  distToI18 = [  16,  21,  15,1000]
  distToJ18 = [  15,  20,  16,1000]
  distToK18 = [  14,  19,  17,1000]
  distToL18 = [  13,  18,  18,1000]
  distToM18 = [  12,  19,  19,1000]
  distToN18 = [  11,  19,  19,1000]
  distToO18 = [  10,  18,  18,1000]
;
modify hacRoomH8
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  13,  17,1000,  13]
  distToB2  = [  12,  16,1000,  12]
  distToC2  = [  11,  15,1000,  11]
  distToD2  = [  10,  14,1000,  10]
  distToE2  = [  11,  13,1000,  11]
  distToF2  = [  12,  12,1000,  12]
  distToG2  = [  11,  11,1000,  13]
  distToH2  = [  10,  10,1000,  14]
  distToI2  = [   9,   9,1000,  15]
  distToJ2  = [   8,   8,1000,  16]
  distToK2  = [   9,   9,1000,  17]
  distToL2  = [  10,  10,1000,  18]
  distToM2  = [  11,  11,1000,  19]
  distToN2  = [  12,  12,1000,  20]
  distToD3  = [   9,  15,1000,   9]
  distToJ3  = [   7,   7,1000,  17]
  distToN3  = [  13,  13,1000,  21]
  distToD4  = [   8,  16,1000,   8]
  distToE4  = [   7,  15,1000,   9]
  distToF4  = [   6,  14,1000,  10]
  distToH4  = [   4,   8,1000,  16]
  distToI4  = [   5,   7,1000,  17]
  distToJ4  = [   6,   6,1000,  18]
  distToK4  = [   7,   7,1000,  19]
  distToL4  = [   8,   8,1000,  20]
  distToN4  = [  14,  14,1000,  22]
  distToD5  = [   9,  17,1000,   7]
  distToF5  = [   5,  13,1000,  11]
  distToH5  = [   3,   9,1000,  15]
  distToJ5  = [   7,   5,1000,  19]
  distToL5  = [   9,   9,1000,  21]
  distToN5  = [  13,  13,1000,  23]
  distToB6  = [  12,  20,1000,   8]
  distToC6  = [  11,  19,1000,   7]
  distToD6  = [  10,  18,1000,   6]
  distToF6  = [   4,  12,1000,  12]
  distToG6  = [   3,  11,1000,  13]
  distToH6  = [   2,  10,1000,  14]
  distToJ6  = [   8,   4,1000,  20]
  distToL6  = [  10,  10,1000,  22]
  distToM6  = [  11,  11,1000,  23]
  distToN6  = [  12,  12,1000,  24]
  distToB7  = [  13,  21,1000,   9]
  distToD7  = [  11,  17,1000,   5]
  distToH7  = [   1,  11,1000,  15]
  distToJ7  = [   9,   3,1000,  19]
  distToN7  = [  13,  11,1000,  23]
  distToB8  = [  14,  22,1000,  10]
  distToD8  = [  12,  16,1000,   4]
  distToE8  = [  13,  15,1000,   3]
  distToF8  = [  14,  14,1000,   2]
  distToG8  = [  13,  13,1000,   1]
  distToH8  = [  12,  12,1000,  16]
  distToI8  = [  11,   1,1000,  17]
  distToJ8  = [  10,   2,1000,  18]
  distToK8  = [  11,   3,1000,  19]
  distToL8  = [  12,   4,1000,  20]
  distToN8  = [  14,  10,1000,  22]
  distToB9  = [  15,  21,1000,   9]
  distToD9  = [  13,  17,1000,   5]
  distToL9  = [  13,   5,1000,  19]
  distToN9  = [  15,   9,1000,  21]
  distToB10 = [  16,  20,1000,   8]
  distToC10 = [  15,  19,1000,   7]
  distToD10 = [  14,  18,1000,   6]
  distToL10 = [  14,   6,1000,  18]
  distToM10 = [  15,   7,1000,  19]
  distToN10 = [  16,   8,1000,  20]
  distToB11 = [  17,  21,1000,   9]
  distToD11 = [  15,  17,1000,   7]
  distToL11 = [  15,   7,1000,  17]
  distToN11 = [  17,   9,1000,  21]
  distToB12 = [  18,  22,1000,  10]
  distToD12 = [  16,  16,1000,   8]
  distToE12 = [  17,  15,1000,   9]
  distToF12 = [  18,  14,1000,  10]
  distToG12 = [  19,  13,1000,  11]
  distToH12 = [  20,  12,1000,  12]
  distToI12 = [  19,  11,1000,  13]
  distToJ12 = [  18,  10,1000,  14]
  distToK12 = [  17,   9,1000,  15]
  distToL12 = [  16,   8,1000,  16]
  distToN12 = [  18,  10,1000,  22]
  distToB13 = [  19,  23,1000,  11]
  distToF13 = [  19,  15,1000,  11]
  distToH13 = [  21,  13,1000,  13]
  distToL13 = [  17,   9,1000,  17]
  distToN13 = [  19,  11,1000,  21]
  distToB14 = [  20,  24,1000,  12]
  distToC14 = [  21,  23,1000,  13]
  distToD14 = [  22,  22,1000,  14]
  distToF14 = [  20,  16,1000,  12]
  distToH14 = [  22,  14,1000,  14]
  distToI14 = [  23,  15,1000,  15]
  distToJ14 = [  23,  16,1000,  16]
  distToL14 = [  18,  10,1000,  18]
  distToM14 = [  19,  11,1000,  19]
  distToN14 = [  20,  12,1000,  20]
  distToB15 = [  21,  25,1000,  13]
  distToD15 = [  23,  21,1000,  15]
  distToF15 = [  21,  17,1000,  13]
  distToH15 = [  23,  15,1000,  15]
  distToJ15 = [  22,  15,1000,  17]
  distToL15 = [  19,  11,1000,  19]
  distToB16 = [  22,  26,1000,  14]
  distToD16 = [  24,  20,1000,  16]
  distToE16 = [  23,  19,1000,  15]
  distToF16 = [  22,  18,1000,  14]
  distToG16 = [  23,  17,1000,  15]
  distToH16 = [  24,  16,1000,  16]
  distToJ16 = [  21,  14,1000,  18]
  distToK16 = [  20,  13,1000,  19]
  distToL16 = [  19,  12,1000,  19]
  distToB17 = [  23,  25,1000,  15]
  distToF17 = [  23,  19,1000,  15]
  distToL17 = [  18,  13,1000,  18]
  distToB18 = [  24,  24,1000,  16]
  distToC18 = [  25,  23,1000,  17]
  distToD18 = [  25,  22,1000,  18]
  distToE18 = [  24,  21,1000,  17]
  distToF18 = [  23,  20,1000,  16]
  distToG18 = [  22,  19,1000,  17]
  distToH18 = [  21,  18,1000,  18]
  distToI18 = [  20,  17,1000,  19]
  distToJ18 = [  19,  16,1000,  19]
  distToK18 = [  18,  15,1000,  18]
  distToL18 = [  17,  14,1000,  17]
  distToM18 = [  16,  15,1000,  16]
  distToN18 = [  15,  16,1000,  15]
  distToO18 = [  14,  17,1000,  14]
;
modify hacRoomJ8
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  15,  16,1000,  15]
  distToB2  = [  14,  17,1000,  14]
  distToC2  = [  13,  18,1000,  13]
  distToD2  = [  12,  19,1000,  12]
  distToE2  = [  11,  20,1000,  13]
  distToF2  = [  10,  21,1000,  14]
  distToG2  = [   9,  21,1000,  13]
  distToH2  = [   8,  20,1000,  12]
  distToI2  = [   7,  19,1000,  11]
  distToJ2  = [   6,  18,1000,  10]
  distToK2  = [   7,  17,1000,  11]
  distToL2  = [   8,  16,1000,  12]
  distToM2  = [   9,  15,1000,  13]
  distToN2  = [  10,  14,1000,  14]
  distToD3  = [  13,  20,1000,  11]
  distToJ3  = [   5,  17,1000,   9]
  distToN3  = [  11,  13,1000,  15]
  distToD4  = [  14,  21,1000,  10]
  distToE4  = [  13,  22,1000,   9]
  distToF4  = [  12,  23,1000,   8]
  distToH4  = [   6,  18,1000,   6]
  distToI4  = [   5,  17,1000,   7]
  distToJ4  = [   4,  16,1000,   8]
  distToK4  = [   5,  15,1000,   9]
  distToL4  = [   6,  14,1000,  10]
  distToN4  = [  12,  12,1000,  16]
  distToD5  = [  15,  21,1000,   9]
  distToF5  = [  11,  23,1000,   7]
  distToH5  = [   7,  19,1000,   5]
  distToJ5  = [   3,  17,1000,   9]
  distToL5  = [   7,  13,1000,  11]
  distToN5  = [  11,  11,1000,  15]
  distToB6  = [  18,  22,1000,  10]
  distToC6  = [  17,  21,1000,   9]
  distToD6  = [  16,  20,1000,   8]
  distToF6  = [  10,  22,1000,   6]
  distToG6  = [   9,  21,1000,   5]
  distToH6  = [   8,  20,1000,   4]
  distToJ6  = [   2,  18,1000,  10]
  distToL6  = [   8,  12,1000,  12]
  distToM6  = [   9,  11,1000,  13]
  distToN6  = [  10,  10,1000,  14]
  distToB7  = [  19,  21,1000,  11]
  distToD7  = [  15,  19,1000,   7]
  distToH7  = [   9,  21,1000,   3]
  distToJ7  = [   1,  19,1000,  11]
  distToN7  = [  11,   9,1000,  15]
  distToB8  = [  20,  20,1000,  12]
  distToD8  = [  14,  18,1000,   6]
  distToE8  = [  13,  19,1000,   5]
  distToF8  = [  12,  20,1000,   4]
  distToG8  = [  11,  21,1000,   3]
  distToH8  = [  10,  22,1000,   2]
  distToI8  = [  11,  21,1000,   1]
  distToJ8  = [  12,  20,1000,  12]
  distToK8  = [  13,   1,1000,  13]
  distToL8  = [  14,   2,1000,  14]
  distToN8  = [  12,   8,1000,  16]
  distToB9  = [  19,  19,1000,  11]
  distToD9  = [  15,  17,1000,   7]
  distToL9  = [  15,   3,1000,  15]
  distToN9  = [  13,   7,1000,  17]
  distToB10 = [  18,  18,1000,  10]
  distToC10 = [  17,  17,1000,   9]
  distToD10 = [  16,  16,1000,   8]
  distToL10 = [  16,   4,1000,  16]
  distToM10 = [  15,   5,1000,  17]
  distToN10 = [  14,   6,1000,  18]
  distToB11 = [  19,  19,1000,  11]
  distToD11 = [  17,  15,1000,   9]
  distToL11 = [  17,   5,1000,  17]
  distToN11 = [  15,   7,1000,  19]
  distToB12 = [  20,  20,1000,  12]
  distToD12 = [  18,  14,1000,  10]
  distToE12 = [  19,  13,1000,  11]
  distToF12 = [  20,  12,1000,  12]
  distToG12 = [  21,  11,1000,  13]
  distToH12 = [  22,  10,1000,  14]
  distToI12 = [  21,   9,1000,  15]
  distToJ12 = [  20,   8,1000,  16]
  distToK12 = [  19,   7,1000,  17]
  distToL12 = [  18,   6,1000,  18]
  distToN12 = [  16,   8,1000,  20]
  distToB13 = [  21,  21,1000,  13]
  distToF13 = [  21,  13,1000,  13]
  distToH13 = [  23,  11,1000,  15]
  distToL13 = [  19,   7,1000,  19]
  distToN13 = [  17,   9,1000,  21]
  distToB14 = [  22,  22,1000,  14]
  distToC14 = [  23,  21,1000,  15]
  distToD14 = [  24,  20,1000,  16]
  distToF14 = [  22,  14,1000,  14]
  distToH14 = [  24,  12,1000,  16]
  distToI14 = [  25,  13,1000,  17]
  distToJ14 = [  25,  14,1000,  18]
  distToL14 = [  20,   8,1000,  20]
  distToM14 = [  19,   9,1000,  21]
  distToN14 = [  18,  10,1000,  22]
  distToB15 = [  23,  23,1000,  15]
  distToD15 = [  25,  19,1000,  17]
  distToF15 = [  23,  15,1000,  15]
  distToH15 = [  25,  13,1000,  17]
  distToJ15 = [  24,  13,1000,  19]
  distToL15 = [  21,   9,1000,  21]
  distToB16 = [  24,  24,1000,  16]
  distToD16 = [  26,  18,1000,  18]
  distToE16 = [  25,  17,1000,  17]
  distToF16 = [  24,  16,1000,  16]
  distToG16 = [  25,  15,1000,  17]
  distToH16 = [  26,  14,1000,  18]
  distToJ16 = [  23,  12,1000,  20]
  distToK16 = [  22,  11,1000,  21]
  distToL16 = [  21,  10,1000,  21]
  distToB17 = [  25,  23,1000,  17]
  distToF17 = [  25,  17,1000,  17]
  distToL17 = [  20,  11,1000,  20]
  distToB18 = [  26,  22,1000,  18]
  distToC18 = [  27,  21,1000,  19]
  distToD18 = [  27,  20,1000,  20]
  distToE18 = [  26,  19,1000,  19]
  distToF18 = [  25,  18,1000,  18]
  distToG18 = [  24,  17,1000,  19]
  distToH18 = [  23,  16,1000,  20]
  distToI18 = [  22,  15,1000,  21]
  distToJ18 = [  21,  14,1000,  21]
  distToK18 = [  20,  13,1000,  20]
  distToL18 = [  19,  12,1000,  19]
  distToM18 = [  18,  13,1000,  18]
  distToN18 = [  17,  14,1000,  17]
  distToO18 = [  16,  15,1000,  16]
;
modify hacRoomB10
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  13,  13,  22,1000]
  distToB2  = [  12,  12,  23,1000]
  distToC2  = [  11,  11,  24,1000]
  distToD2  = [  10,  10,  25,1000]
  distToE2  = [  11,  11,  26,1000]
  distToF2  = [  12,  12,  27,1000]
  distToG2  = [  13,  13,  28,1000]
  distToH2  = [  14,  14,  29,1000]
  distToI2  = [  15,  15,  30,1000]
  distToJ2  = [  16,  16,  31,1000]
  distToK2  = [  17,  17,  32,1000]
  distToL2  = [  18,  18,  33,1000]
  distToM2  = [  19,  19,  33,1000]
  distToN2  = [  20,  20,  32,1000]
  distToD3  = [   9,   9,  25,1000]
  distToJ3  = [  17,  15,  31,1000]
  distToN3  = [  21,  21,  31,1000]
  distToD4  = [   8,   8,  24,1000]
  distToE4  = [   9,   9,  25,1000]
  distToF4  = [  10,  10,  26,1000]
  distToH4  = [  16,  12,  28,1000]
  distToI4  = [  17,  13,  29,1000]
  distToJ4  = [  18,  14,  30,1000]
  distToK4  = [  19,  15,  31,1000]
  distToL4  = [  20,  16,  32,1000]
  distToN4  = [  22,  22,  30,1000]
  distToD5  = [   7,   7,  23,1000]
  distToF5  = [  11,  11,  27,1000]
  distToH5  = [  15,  11,  27,1000]
  distToJ5  = [  17,  13,  29,1000]
  distToL5  = [  21,  17,  31,1000]
  distToN5  = [  23,  21,  29,1000]
  distToB6  = [   4,   8,  24,1000]
  distToC6  = [   5,   7,  23,1000]
  distToD6  = [   6,   6,  22,1000]
  distToF6  = [  12,  12,  28,1000]
  distToG6  = [  13,  11,  27,1000]
  distToH6  = [  14,  10,  26,1000]
  distToJ6  = [  16,  12,  28,1000]
  distToL6  = [  22,  18,  30,1000]
  distToM6  = [  23,  19,  29,1000]
  distToN6  = [  24,  20,  28,1000]
  distToB7  = [   3,   9,  23,1000]
  distToD7  = [   7,   5,  21,1000]
  distToH7  = [  13,   9,  25,1000]
  distToJ7  = [  15,  11,  27,1000]
  distToN7  = [  23,  19,  27,1000]
  distToB8  = [   2,  10,  22,1000]
  distToD8  = [   8,   4,  20,1000]
  distToE8  = [   9,   5,  21,1000]
  distToF8  = [  10,   6,  22,1000]
  distToG8  = [  11,   7,  23,1000]
  distToH8  = [  12,   8,  24,1000]
  distToI8  = [  13,   9,  25,1000]
  distToJ8  = [  14,  10,  26,1000]
  distToK8  = [  15,  11,  25,1000]
  distToL8  = [  16,  12,  24,1000]
  distToN8  = [  22,  18,  26,1000]
  distToB9  = [   1,  11,  21,1000]
  distToD9  = [   9,   3,  19,1000]
  distToL9  = [  17,  13,  23,1000]
  distToN9  = [  21,  17,  25,1000]
  distToB10 = [  12,  12,  20,1000]
  distToC10 = [  11,   1,  19,1000]
  distToD10 = [  10,   2,  18,1000]
  distToL10 = [  18,  14,  22,1000]
  distToM10 = [  19,  15,  23,1000]
  distToN10 = [  20,  16,  24,1000]
  distToB11 = [  13,  13,   1,1000]
  distToD11 = [  11,   3,  17,1000]
  distToL11 = [  19,  13,  21,1000]
  distToN11 = [  21,  17,  25,1000]
  distToB12 = [  14,  14,   2,1000]
  distToD12 = [  12,   4,  16,1000]
  distToE12 = [  13,   5,  15,1000]
  distToF12 = [  14,   6,  14,1000]
  distToG12 = [  15,   7,  15,1000]
  distToH12 = [  16,   8,  16,1000]
  distToI12 = [  17,   9,  17,1000]
  distToJ12 = [  18,  10,  18,1000]
  distToK12 = [  19,  11,  19,1000]
  distToL12 = [  20,  12,  20,1000]
  distToN12 = [  22,  18,  26,1000]
  distToB13 = [  15,  15,   3,1000]
  distToF13 = [  15,   7,  13,1000]
  distToH13 = [  17,   9,  15,1000]
  distToL13 = [  21,  13,  21,1000]
  distToN13 = [  23,  17,  25,1000]
  distToB14 = [  16,  16,   4,1000]
  distToC14 = [  17,  15,   5,1000]
  distToD14 = [  18,  14,   6,1000]
  distToF14 = [  16,   8,  12,1000]
  distToH14 = [  18,  10,  14,1000]
  distToI14 = [  19,  11,  15,1000]
  distToJ14 = [  20,  12,  16,1000]
  distToL14 = [  21,  14,  22,1000]
  distToM14 = [  22,  15,  23,1000]
  distToN14 = [  23,  16,  24,1000]
  distToB15 = [  17,  17,   5,1000]
  distToD15 = [  19,  13,   7,1000]
  distToF15 = [  17,   9,  11,1000]
  distToH15 = [  19,  11,  13,1000]
  distToJ15 = [  21,  13,  17,1000]
  distToL15 = [  20,  15,  21,1000]
  distToB16 = [  18,  18,   6,1000]
  distToD16 = [  20,  12,   8,1000]
  distToE16 = [  19,  11,   9,1000]
  distToF16 = [  18,  10,  10,1000]
  distToG16 = [  19,  11,  11,1000]
  distToH16 = [  20,  12,  12,1000]
  distToJ16 = [  21,  14,  18,1000]
  distToK16 = [  20,  15,  19,1000]
  distToL16 = [  19,  16,  20,1000]
  distToB17 = [  19,  17,   7,1000]
  distToF17 = [  19,  11,  11,1000]
  distToL17 = [  18,  17,  19,1000]
  distToB18 = [  20,  16,   8,1000]
  distToC18 = [  21,  15,   9,1000]
  distToD18 = [  22,  14,  10,1000]
  distToE18 = [  21,  13,  11,1000]
  distToF18 = [  20,  12,  12,1000]
  distToG18 = [  21,  13,  13,1000]
  distToH18 = [  21,  14,  14,1000]
  distToI18 = [  20,  15,  15,1000]
  distToJ18 = [  19,  16,  16,1000]
  distToK18 = [  18,  17,  17,1000]
  distToL18 = [  17,  17,  18,1000]
  distToM18 = [  16,  16,  19,1000]
  distToN18 = [  15,  15,  20,1000]
  distToO18 = [  14,  14,  21,1000]
;
modify hacRoomD10
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  11,1000,  20,  15]
  distToB2  = [  10,1000,  21,  14]
  distToC2  = [   9,1000,  22,  13]
  distToD2  = [   8,1000,  23,  12]
  distToE2  = [   9,1000,  24,  13]
  distToF2  = [  10,1000,  25,  14]
  distToG2  = [  11,1000,  25,  15]
  distToH2  = [  12,1000,  24,  16]
  distToI2  = [  13,1000,  23,  17]
  distToJ2  = [  14,1000,  22,  18]
  distToK2  = [  15,1000,  23,  19]
  distToL2  = [  16,1000,  24,  20]
  distToM2  = [  17,1000,  23,  21]
  distToN2  = [  18,1000,  22,  22]
  distToD3  = [   7,1000,  24,  11]
  distToJ3  = [  13,1000,  21,  19]
  distToN3  = [  19,1000,  21,  23]
  distToD4  = [   6,1000,  25,  10]
  distToE4  = [   7,1000,  25,  11]
  distToF4  = [   8,1000,  24,  12]
  distToH4  = [  10,1000,  22,  18]
  distToI4  = [  11,1000,  21,  19]
  distToJ4  = [  12,1000,  20,  20]
  distToK4  = [  13,1000,  21,  21]
  distToL4  = [  14,1000,  22,  22]
  distToN4  = [  20,1000,  20,  24]
  distToD5  = [   5,1000,  25,   9]
  distToF5  = [   9,1000,  23,  13]
  distToH5  = [   9,1000,  21,  17]
  distToJ5  = [  11,1000,  19,  19]
  distToL5  = [  15,1000,  21,  23]
  distToN5  = [  19,1000,  19,  25]
  distToB6  = [   6,1000,  22,   6]
  distToC6  = [   5,1000,  23,   7]
  distToD6  = [   4,1000,  24,   8]
  distToF6  = [  10,1000,  22,  14]
  distToG6  = [   9,1000,  21,  15]
  distToH6  = [   8,1000,  20,  16]
  distToJ6  = [  10,1000,  18,  18]
  distToL6  = [  16,1000,  20,  24]
  distToM6  = [  17,1000,  19,  25]
  distToN6  = [  18,1000,  18,  26]
  distToB7  = [   7,1000,  21,   5]
  distToD7  = [   3,1000,  23,   9]
  distToH7  = [   7,1000,  19,  15]
  distToJ7  = [   9,1000,  17,  17]
  distToN7  = [  17,1000,  17,  25]
  distToB8  = [   8,1000,  20,   4]
  distToD8  = [   2,1000,  22,  10]
  distToE8  = [   3,1000,  21,  11]
  distToF8  = [   4,1000,  20,  12]
  distToG8  = [   5,1000,  19,  13]
  distToH8  = [   6,1000,  18,  14]
  distToI8  = [   7,1000,  17,  15]
  distToJ8  = [   8,1000,  16,  16]
  distToK8  = [   9,1000,  15,  17]
  distToL8  = [  10,1000,  14,  18]
  distToN8  = [  16,1000,  16,  24]
  distToB9  = [   9,1000,  19,   3]
  distToD9  = [   1,1000,  21,  11]
  distToL9  = [  11,1000,  13,  19]
  distToN9  = [  15,1000,  15,  23]
  distToB10 = [  10,1000,  18,   2]
  distToC10 = [  11,1000,  19,   1]
  distToD10 = [  12,1000,  20,  12]
  distToL10 = [  12,1000,  12,  20]
  distToM10 = [  13,1000,  13,  21]
  distToN10 = [  14,1000,  14,  22]
  distToB11 = [  11,1000,  17,   3]
  distToD11 = [  13,1000,   1,  13]
  distToL11 = [  13,1000,  11,  21]
  distToN11 = [  15,1000,  15,  23]
  distToB12 = [  12,1000,  16,   4]
  distToD12 = [  14,1000,   2,  14]
  distToE12 = [  15,1000,   3,  15]
  distToF12 = [  16,1000,   4,  16]
  distToG12 = [  17,1000,   5,  17]
  distToH12 = [  18,1000,   6,  18]
  distToI12 = [  17,1000,   7,  19]
  distToJ12 = [  16,1000,   8,  20]
  distToK12 = [  15,1000,   9,  21]
  distToL12 = [  14,1000,  10,  22]
  distToN12 = [  16,1000,  16,  24]
  distToB13 = [  13,1000,  15,   5]
  distToF13 = [  17,1000,   5,  15]
  distToH13 = [  19,1000,   7,  17]
  distToL13 = [  15,1000,  11,  23]
  distToN13 = [  17,1000,  15,  25]
  distToB14 = [  14,1000,  14,   6]
  distToC14 = [  15,1000,  13,   7]
  distToD14 = [  16,1000,  12,   8]
  distToF14 = [  18,1000,   6,  14]
  distToH14 = [  20,1000,   8,  16]
  distToI14 = [  21,1000,   9,  17]
  distToJ14 = [  21,1000,  10,  18]
  distToL14 = [  16,1000,  12,  23]
  distToM14 = [  17,1000,  13,  24]
  distToN14 = [  18,1000,  14,  25]
  distToB15 = [  15,1000,  15,   7]
  distToD15 = [  17,1000,  11,   9]
  distToF15 = [  19,1000,   7,  13]
  distToH15 = [  21,1000,   9,  15]
  distToJ15 = [  20,1000,  11,  19]
  distToL15 = [  17,1000,  13,  22]
  distToB16 = [  16,1000,  16,   8]
  distToD16 = [  18,1000,  10,  10]
  distToE16 = [  19,1000,   9,  11]
  distToF16 = [  20,1000,   8,  12]
  distToG16 = [  21,1000,   9,  13]
  distToH16 = [  22,1000,  10,  14]
  distToJ16 = [  19,1000,  12,  20]
  distToK16 = [  18,1000,  13,  21]
  distToL16 = [  17,1000,  14,  21]
  distToB17 = [  17,1000,  15,   9]
  distToF17 = [  21,1000,   9,  13]
  distToL17 = [  16,1000,  15,  20]
  distToB18 = [  18,1000,  14,  10]
  distToC18 = [  19,1000,  13,  11]
  distToD18 = [  20,1000,  12,  12]
  distToE18 = [  21,1000,  11,  13]
  distToF18 = [  21,1000,  10,  14]
  distToG18 = [  20,1000,  11,  15]
  distToH18 = [  19,1000,  12,  16]
  distToI18 = [  18,1000,  13,  17]
  distToJ18 = [  17,1000,  14,  18]
  distToK18 = [  16,1000,  15,  19]
  distToL18 = [  15,1000,  16,  19]
  distToM18 = [  14,1000,  17,  18]
  distToN18 = [  13,1000,  18,  17]
  distToO18 = [  12,1000,  19,  16]
;
modify hacRoomL10
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  19,  16,  12,1000]
  distToB2  = [  18,  17,  13,1000]
  distToC2  = [  17,  18,  14,1000]
  distToD2  = [  16,  19,  15,1000]
  distToE2  = [  15,  19,  16,1000]
  distToF2  = [  14,  18,  17,1000]
  distToG2  = [  13,  17,  18,1000]
  distToH2  = [  12,  16,  19,1000]
  distToI2  = [  11,  15,  20,1000]
  distToJ2  = [  10,  14,  21,1000]
  distToK2  = [  11,  13,  21,1000]
  distToL2  = [  12,  12,  20,1000]
  distToM2  = [  13,  11,  19,1000]
  distToN2  = [  14,  10,  18,1000]
  distToD3  = [  15,  20,  16,1000]
  distToJ3  = [   9,  13,  21,1000]
  distToN3  = [  15,   9,  17,1000]
  distToD4  = [  14,  21,  17,1000]
  distToE4  = [  13,  21,  18,1000]
  distToF4  = [  12,  20,  19,1000]
  distToH4  = [  10,  14,  22,1000]
  distToI4  = [   9,  13,  21,1000]
  distToJ4  = [   8,  12,  20,1000]
  distToK4  = [   9,  11,  19,1000]
  distToL4  = [  10,  10,  18,1000]
  distToN4  = [  16,   8,  16,1000]
  distToD5  = [  13,  22,  17,1000]
  distToF5  = [  11,  19,  20,1000]
  distToH5  = [   9,  15,  21,1000]
  distToJ5  = [   7,  13,  19,1000]
  distToL5  = [  11,   9,  17,1000]
  distToN5  = [  15,   7,  15,1000]
  distToB6  = [  14,  25,  18,1000]
  distToC6  = [  13,  24,  17,1000]
  distToD6  = [  12,  23,  16,1000]
  distToF6  = [  10,  18,  21,1000]
  distToG6  = [   9,  17,  21,1000]
  distToH6  = [   8,  16,  20,1000]
  distToJ6  = [   6,  14,  18,1000]
  distToL6  = [  12,   8,  16,1000]
  distToM6  = [  13,   7,  15,1000]
  distToN6  = [  14,   6,  14,1000]
  distToB7  = [  15,  25,  17,1000]
  distToD7  = [  11,  23,  15,1000]
  distToH7  = [   7,  17,  19,1000]
  distToJ7  = [   5,  15,  17,1000]
  distToN7  = [  15,   5,  13,1000]
  distToB8  = [  16,  24,  16,1000]
  distToD8  = [  10,  22,  14,1000]
  distToE8  = [   9,  21,  15,1000]
  distToF8  = [   8,  20,  16,1000]
  distToG8  = [   7,  19,  17,1000]
  distToH8  = [   6,  18,  18,1000]
  distToI8  = [   5,  17,  17,1000]
  distToJ8  = [   4,  16,  16,1000]
  distToK8  = [   3,  15,  15,1000]
  distToL8  = [   2,  14,  14,1000]
  distToN8  = [  16,   4,  12,1000]
  distToB9  = [  15,  23,  15,1000]
  distToD9  = [  11,  21,  13,1000]
  distToL9  = [   1,  13,  13,1000]
  distToN9  = [  17,   3,  11,1000]
  distToB10 = [  14,  22,  14,1000]
  distToC10 = [  13,  21,  13,1000]
  distToD10 = [  12,  20,  12,1000]
  distToL10 = [  20,  12,  12,1000]
  distToM10 = [  19,   1,  11,1000]
  distToN10 = [  18,   2,  10,1000]
  distToB11 = [  15,  23,  15,1000]
  distToD11 = [  13,  19,  11,1000]
  distToL11 = [  21,  11,   1,1000]
  distToN11 = [  19,   3,   9,1000]
  distToB12 = [  16,  24,  16,1000]
  distToD12 = [  14,  18,  10,1000]
  distToE12 = [  15,  17,   9,1000]
  distToF12 = [  16,  16,   8,1000]
  distToG12 = [  17,  15,   7,1000]
  distToH12 = [  18,  14,   6,1000]
  distToI12 = [  19,  13,   5,1000]
  distToJ12 = [  20,  12,   4,1000]
  distToK12 = [  21,  11,   3,1000]
  distToL12 = [  22,  10,   2,1000]
  distToN12 = [  20,   4,   8,1000]
  distToB13 = [  17,  25,  17,1000]
  distToF13 = [  17,  17,   9,1000]
  distToH13 = [  19,  15,   7,1000]
  distToL13 = [  23,   9,   3,1000]
  distToN13 = [  21,   5,   7,1000]
  distToB14 = [  18,  26,  18,1000]
  distToC14 = [  19,  25,  17,1000]
  distToD14 = [  20,  24,  16,1000]
  distToF14 = [  18,  18,  10,1000]
  distToH14 = [  20,  16,   8,1000]
  distToI14 = [  21,  15,   9,1000]
  distToJ14 = [  22,  14,  10,1000]
  distToL14 = [  24,   8,   4,1000]
  distToM14 = [  23,   7,   5,1000]
  distToN14 = [  22,   6,   6,1000]
  distToB15 = [  19,  25,  19,1000]
  distToD15 = [  21,  23,  15,1000]
  distToF15 = [  19,  19,  11,1000]
  distToH15 = [  21,  17,   9,1000]
  distToJ15 = [  23,  13,   9,1000]
  distToL15 = [  25,   9,   5,1000]
  distToB16 = [  20,  24,  20,1000]
  distToD16 = [  22,  22,  14,1000]
  distToE16 = [  21,  21,  13,1000]
  distToF16 = [  20,  20,  12,1000]
  distToG16 = [  21,  19,  11,1000]
  distToH16 = [  22,  18,  10,1000]
  distToJ16 = [  24,  12,   8,1000]
  distToK16 = [  25,  11,   7,1000]
  distToL16 = [  25,  10,   6,1000]
  distToB17 = [  21,  23,  19,1000]
  distToF17 = [  21,  19,  13,1000]
  distToL17 = [  24,  11,   7,1000]
  distToB18 = [  22,  22,  18,1000]
  distToC18 = [  23,  21,  17,1000]
  distToD18 = [  24,  20,  16,1000]
  distToE18 = [  23,  19,  15,1000]
  distToF18 = [  22,  18,  14,1000]
  distToG18 = [  23,  17,  13,1000]
  distToH18 = [  24,  16,  12,1000]
  distToI18 = [  25,  15,  11,1000]
  distToJ18 = [  25,  14,  10,1000]
  distToK18 = [  24,  13,   9,1000]
  distToL18 = [  23,  12,   8,1000]
  distToM18 = [  22,  13,   9,1000]
  distToN18 = [  21,  14,  10,1000]
  distToO18 = [  20,  15,  11,1000]
;
modify hacRoomN10
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  21,1000,  14,  14]
  distToB2  = [  20,1000,  15,  15]
  distToC2  = [  19,1000,  16,  16]
  distToD2  = [  18,1000,  17,  17]
  distToE2  = [  17,1000,  18,  17]
  distToF2  = [  16,1000,  19,  16]
  distToG2  = [  15,1000,  20,  15]
  distToH2  = [  14,1000,  21,  14]
  distToI2  = [  13,1000,  21,  13]
  distToJ2  = [  12,1000,  20,  12]
  distToK2  = [  11,1000,  21,  13]
  distToL2  = [  10,1000,  22,  14]
  distToM2  = [   9,1000,  21,  15]
  distToN2  = [   8,1000,  20,  16]
  distToD3  = [  19,1000,  18,  17]
  distToJ3  = [  11,1000,  19,  11]
  distToN3  = [   7,1000,  19,  17]
  distToD4  = [  20,1000,  19,  16]
  distToE4  = [  19,1000,  20,  15]
  distToF4  = [  18,1000,  21,  14]
  distToH4  = [  12,1000,  20,  12]
  distToI4  = [  11,1000,  19,  11]
  distToJ4  = [  10,1000,  18,  10]
  distToK4  = [   9,1000,  19,  11]
  distToL4  = [   8,1000,  20,  12]
  distToN4  = [   6,1000,  18,  18]
  distToD5  = [  21,1000,  20,  15]
  distToF5  = [  17,1000,  21,  13]
  distToH5  = [  13,1000,  19,  11]
  distToJ5  = [  11,1000,  17,   9]
  distToL5  = [   7,1000,  19,  13]
  distToN5  = [   5,1000,  17,  17]
  distToB6  = [  24,1000,  23,  16]
  distToC6  = [  23,1000,  22,  15]
  distToD6  = [  22,1000,  21,  14]
  distToF6  = [  16,1000,  20,  12]
  distToG6  = [  15,1000,  19,  11]
  distToH6  = [  14,1000,  18,  10]
  distToJ6  = [  12,1000,  16,   8]
  distToL6  = [   6,1000,  18,  14]
  distToM6  = [   5,1000,  17,  15]
  distToN6  = [   4,1000,  16,  16]
  distToB7  = [  25,1000,  23,  17]
  distToD7  = [  21,1000,  21,  13]
  distToH7  = [  15,1000,  17,   9]
  distToJ7  = [  13,1000,  15,   7]
  distToN7  = [   3,1000,  15,  15]
  distToB8  = [  26,1000,  22,  18]
  distToD8  = [  20,1000,  20,  12]
  distToE8  = [  19,1000,  19,  11]
  distToF8  = [  18,1000,  18,  10]
  distToG8  = [  17,1000,  17,   9]
  distToH8  = [  16,1000,  16,   8]
  distToI8  = [  15,1000,  15,   7]
  distToJ8  = [  14,1000,  14,   6]
  distToK8  = [  15,1000,  13,   5]
  distToL8  = [  16,1000,  12,   4]
  distToN8  = [   2,1000,  14,  14]
  distToB9  = [  25,1000,  21,  17]
  distToD9  = [  21,1000,  19,  13]
  distToL9  = [  17,1000,  11,   3]
  distToN9  = [   1,1000,  13,  13]
  distToB10 = [  24,1000,  20,  16]
  distToC10 = [  23,1000,  19,  15]
  distToD10 = [  22,1000,  18,  14]
  distToL10 = [  18,1000,  10,   2]
  distToM10 = [  19,1000,  11,   1]
  distToN10 = [  20,1000,  12,  12]
  distToB11 = [  25,1000,  21,  17]
  distToD11 = [  23,1000,  17,  13]
  distToL11 = [  19,1000,   9,   3]
  distToN11 = [  21,1000,   1,  11]
  distToB12 = [  26,1000,  22,  18]
  distToD12 = [  24,1000,  16,  12]
  distToE12 = [  25,1000,  15,  11]
  distToF12 = [  26,1000,  14,  10]
  distToG12 = [  25,1000,  13,   9]
  distToH12 = [  24,1000,  12,   8]
  distToI12 = [  23,1000,  11,   7]
  distToJ12 = [  22,1000,  10,   6]
  distToK12 = [  21,1000,   9,   5]
  distToL12 = [  20,1000,   8,   4]
  distToN12 = [  22,1000,   2,  10]
  distToB13 = [  27,1000,  23,  19]
  distToF13 = [  27,1000,  15,  11]
  distToH13 = [  25,1000,  13,   9]
  distToL13 = [  21,1000,   7,   5]
  distToN13 = [  23,1000,   3,   9]
  distToB14 = [  28,1000,  24,  20]
  distToC14 = [  29,1000,  23,  19]
  distToD14 = [  30,1000,  22,  18]
  distToF14 = [  28,1000,  16,  12]
  distToH14 = [  26,1000,  14,  10]
  distToI14 = [  27,1000,  13,  11]
  distToJ14 = [  28,1000,  12,  12]
  distToL14 = [  22,1000,   6,   6]
  distToM14 = [  23,1000,   5,   7]
  distToN14 = [  24,1000,   4,   8]
  distToB15 = [  29,1000,  23,  21]
  distToD15 = [  31,1000,  21,  17]
  distToF15 = [  29,1000,  17,  13]
  distToH15 = [  27,1000,  15,  11]
  distToJ15 = [  27,1000,  11,  11]
  distToL15 = [  23,1000,   7,   7]
  distToB16 = [  30,1000,  22,  22]
  distToD16 = [  32,1000,  20,  16]
  distToE16 = [  31,1000,  19,  15]
  distToF16 = [  30,1000,  18,  14]
  distToG16 = [  29,1000,  17,  13]
  distToH16 = [  28,1000,  16,  12]
  distToJ16 = [  26,1000,  10,  10]
  distToK16 = [  25,1000,   9,   9]
  distToL16 = [  24,1000,   8,   8]
  distToB17 = [  31,1000,  21,  21]
  distToF17 = [  31,1000,  17,  15]
  distToL17 = [  25,1000,   9,   9]
  distToB18 = [  32,1000,  20,  20]
  distToC18 = [  33,1000,  19,  19]
  distToD18 = [  33,1000,  18,  18]
  distToE18 = [  32,1000,  17,  17]
  distToF18 = [  31,1000,  16,  16]
  distToG18 = [  30,1000,  15,  15]
  distToH18 = [  29,1000,  14,  14]
  distToI18 = [  28,1000,  13,  13]
  distToJ18 = [  27,1000,  12,  12]
  distToK18 = [  26,1000,  11,  11]
  distToL18 = [  25,1000,  10,  10]
  distToM18 = [  24,1000,  11,  11]
  distToN18 = [  23,1000,  12,  12]
  distToO18 = [  22,1000,  13,  13]
;
modify hacRoomF12
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [1000,  16,  16,  15]
  distToB2  = [1000,  17,  17,  14]
  distToC2  = [1000,  18,  18,  13]
  distToD2  = [1000,  19,  19,  12]
  distToE2  = [1000,  20,  20,  13]
  distToF2  = [1000,  21,  21,  14]
  distToG2  = [1000,  21,  22,  15]
  distToH2  = [1000,  20,  23,  16]
  distToI2  = [1000,  19,  24,  17]
  distToJ2  = [1000,  18,  25,  18]
  distToK2  = [1000,  19,  26,  19]
  distToL2  = [1000,  20,  27,  20]
  distToM2  = [1000,  19,  27,  21]
  distToN2  = [1000,  18,  26,  22]
  distToD3  = [1000,  20,  20,  11]
  distToJ3  = [1000,  17,  25,  17]
  distToN3  = [1000,  17,  25,  23]
  distToD4  = [1000,  21,  21,  10]
  distToE4  = [1000,  21,  22,  11]
  distToF4  = [1000,  20,  23,  12]
  distToH4  = [1000,  18,  26,  14]
  distToI4  = [1000,  17,  25,  15]
  distToJ4  = [1000,  16,  24,  16]
  distToK4  = [1000,  17,  25,  17]
  distToL4  = [1000,  18,  26,  18]
  distToN4  = [1000,  16,  24,  24]
  distToD5  = [1000,  21,  21,   9]
  distToF5  = [1000,  19,  24,  13]
  distToH5  = [1000,  17,  25,  13]
  distToJ5  = [1000,  15,  23,  15]
  distToL5  = [1000,  17,  25,  19]
  distToN5  = [1000,  15,  23,  23]
  distToB6  = [1000,  22,  18,  10]
  distToC6  = [1000,  21,  19,   9]
  distToD6  = [1000,  20,  20,   8]
  distToF6  = [1000,  18,  25,  14]
  distToG6  = [1000,  17,  25,  13]
  distToH6  = [1000,  16,  24,  12]
  distToJ6  = [1000,  14,  22,  14]
  distToL6  = [1000,  16,  24,  20]
  distToM6  = [1000,  15,  23,  21]
  distToN6  = [1000,  14,  22,  22]
  distToB7  = [1000,  21,  17,   9]
  distToD7  = [1000,  19,  19,   7]
  distToH7  = [1000,  15,  23,  11]
  distToJ7  = [1000,  13,  21,  13]
  distToN7  = [1000,  13,  21,  21]
  distToB8  = [1000,  20,  16,   8]
  distToD8  = [1000,  18,  18,   6]
  distToE8  = [1000,  17,  19,   7]
  distToF8  = [1000,  16,  20,   8]
  distToG8  = [1000,  15,  21,   9]
  distToH8  = [1000,  14,  22,  10]
  distToI8  = [1000,  13,  21,  11]
  distToJ8  = [1000,  12,  20,  12]
  distToK8  = [1000,  11,  19,  13]
  distToL8  = [1000,  10,  18,  14]
  distToN8  = [1000,  12,  20,  20]
  distToB9  = [1000,  19,  15,   7]
  distToD9  = [1000,  17,  17,   5]
  distToL9  = [1000,   9,  17,  15]
  distToN9  = [1000,  11,  19,  19]
  distToB10 = [1000,  18,  14,   6]
  distToC10 = [1000,  17,  15,   5]
  distToD10 = [1000,  16,  16,   4]
  distToL10 = [1000,   8,  16,  16]
  distToM10 = [1000,   9,  17,  17]
  distToN10 = [1000,  10,  18,  18]
  distToB11 = [1000,  17,  13,   7]
  distToD11 = [1000,  15,  15,   3]
  distToL11 = [1000,   7,  15,  17]
  distToN11 = [1000,  11,  19,  19]
  distToB12 = [1000,  16,  12,   8]
  distToD12 = [1000,  14,  14,   2]
  distToE12 = [1000,  13,  13,   1]
  distToF12 = [1000,  12,  12,  20]
  distToG12 = [1000,   1,  11,  21]
  distToH12 = [1000,   2,  10,  22]
  distToI12 = [1000,   3,  11,  21]
  distToJ12 = [1000,   4,  12,  20]
  distToK12 = [1000,   5,  13,  19]
  distToL12 = [1000,   6,  14,  18]
  distToN12 = [1000,  12,  20,  20]
  distToB13 = [1000,  15,  11,   9]
  distToF13 = [1000,  11,   1,  19]
  distToH13 = [1000,   3,   9,  21]
  distToL13 = [1000,   7,  15,  19]
  distToN13 = [1000,  11,  19,  21]
  distToB14 = [1000,  14,  10,  10]
  distToC14 = [1000,  13,   9,  11]
  distToD14 = [1000,  12,   8,  12]
  distToF14 = [1000,  10,   2,  18]
  distToH14 = [1000,   4,   8,  20]
  distToI14 = [1000,   5,   9,  21]
  distToJ14 = [1000,   6,  10,  22]
  distToL14 = [1000,   8,  16,  20]
  distToM14 = [1000,   9,  17,  21]
  distToN14 = [1000,  10,  18,  22]
  distToB15 = [1000,  15,  11,  11]
  distToD15 = [1000,  11,   7,  13]
  distToF15 = [1000,   9,   3,  17]
  distToH15 = [1000,   5,   7,  19]
  distToJ15 = [1000,   7,  11,  23]
  distToL15 = [1000,   9,  15,  21]
  distToB16 = [1000,  16,  12,  12]
  distToD16 = [1000,  10,   6,  14]
  distToE16 = [1000,   9,   5,  15]
  distToF16 = [1000,   8,   4,  16]
  distToG16 = [1000,   7,   5,  17]
  distToH16 = [1000,   6,   6,  18]
  distToJ16 = [1000,   8,  12,  23]
  distToK16 = [1000,   9,  13,  22]
  distToL16 = [1000,  10,  14,  21]
  distToB17 = [1000,  15,  11,  13]
  distToF17 = [1000,   9,   5,  17]
  distToL17 = [1000,  11,  13,  20]
  distToB18 = [1000,  14,  10,  14]
  distToC18 = [1000,  13,   9,  15]
  distToD18 = [1000,  12,   8,  16]
  distToE18 = [1000,  11,   7,  17]
  distToF18 = [1000,  10,   6,  18]
  distToG18 = [1000,  11,   7,  19]
  distToH18 = [1000,  12,   8,  20]
  distToI18 = [1000,  13,   9,  21]
  distToJ18 = [1000,  14,  10,  21]
  distToK18 = [1000,  13,  11,  20]
  distToL18 = [1000,  12,  12,  19]
  distToM18 = [1000,  13,  13,  18]
  distToN18 = [1000,  14,  14,  17]
  distToO18 = [1000,  15,  15,  16]
;
modify hacRoomH12
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [1000,  14,  14,  17]
  distToB2  = [1000,  15,  15,  16]
  distToC2  = [1000,  16,  16,  15]
  distToD2  = [1000,  17,  17,  14]
  distToE2  = [1000,  18,  18,  15]
  distToF2  = [1000,  19,  19,  16]
  distToG2  = [1000,  19,  20,  17]
  distToH2  = [1000,  18,  21,  18]
  distToI2  = [1000,  17,  22,  19]
  distToJ2  = [1000,  16,  23,  20]
  distToK2  = [1000,  17,  24,  21]
  distToL2  = [1000,  18,  25,  22]
  distToM2  = [1000,  17,  25,  23]
  distToN2  = [1000,  16,  24,  24]
  distToD3  = [1000,  18,  18,  13]
  distToJ3  = [1000,  15,  23,  19]
  distToN3  = [1000,  15,  23,  25]
  distToD4  = [1000,  19,  19,  12]
  distToE4  = [1000,  19,  20,  13]
  distToF4  = [1000,  18,  21,  14]
  distToH4  = [1000,  16,  24,  16]
  distToI4  = [1000,  15,  23,  17]
  distToJ4  = [1000,  14,  22,  18]
  distToK4  = [1000,  15,  23,  19]
  distToL4  = [1000,  16,  24,  20]
  distToN4  = [1000,  14,  22,  26]
  distToD5  = [1000,  19,  19,  11]
  distToF5  = [1000,  17,  22,  15]
  distToH5  = [1000,  15,  23,  15]
  distToJ5  = [1000,  13,  21,  17]
  distToL5  = [1000,  15,  23,  21]
  distToN5  = [1000,  13,  21,  25]
  distToB6  = [1000,  20,  20,  12]
  distToC6  = [1000,  19,  19,  11]
  distToD6  = [1000,  18,  18,  10]
  distToF6  = [1000,  16,  23,  16]
  distToG6  = [1000,  15,  23,  15]
  distToH6  = [1000,  14,  22,  14]
  distToJ6  = [1000,  12,  20,  16]
  distToL6  = [1000,  14,  22,  22]
  distToM6  = [1000,  13,  21,  23]
  distToN6  = [1000,  12,  20,  24]
  distToB7  = [1000,  21,  19,  11]
  distToD7  = [1000,  17,  17,   9]
  distToH7  = [1000,  13,  21,  13]
  distToJ7  = [1000,  11,  19,  15]
  distToN7  = [1000,  11,  19,  23]
  distToB8  = [1000,  22,  18,  10]
  distToD8  = [1000,  16,  16,   8]
  distToE8  = [1000,  15,  17,   9]
  distToF8  = [1000,  14,  18,  10]
  distToG8  = [1000,  13,  19,  11]
  distToH8  = [1000,  12,  20,  12]
  distToI8  = [1000,  11,  19,  13]
  distToJ8  = [1000,  10,  18,  14]
  distToK8  = [1000,   9,  17,  15]
  distToL8  = [1000,   8,  16,  16]
  distToN8  = [1000,  10,  18,  22]
  distToB9  = [1000,  21,  17,   9]
  distToD9  = [1000,  17,  15,   7]
  distToL9  = [1000,   7,  15,  17]
  distToN9  = [1000,   9,  17,  21]
  distToB10 = [1000,  20,  16,   8]
  distToC10 = [1000,  19,  15,   7]
  distToD10 = [1000,  18,  14,   6]
  distToL10 = [1000,   6,  14,  18]
  distToM10 = [1000,   7,  15,  19]
  distToN10 = [1000,   8,  16,  20]
  distToB11 = [1000,  21,  15,   9]
  distToD11 = [1000,  19,  13,   5]
  distToL11 = [1000,   5,  13,  17]
  distToN11 = [1000,   9,  15,  21]
  distToB12 = [1000,  22,  14,  10]
  distToD12 = [1000,  20,  12,   4]
  distToE12 = [1000,  19,  11,   3]
  distToF12 = [1000,  18,  10,   2]
  distToG12 = [1000,  17,  11,   1]
  distToH12 = [1000,  16,  12,  12]
  distToI12 = [1000,   1,  13,  13]
  distToJ12 = [1000,   2,  14,  14]
  distToK12 = [1000,   3,  13,  15]
  distToL12 = [1000,   4,  12,  16]
  distToN12 = [1000,  10,  14,  22]
  distToB13 = [1000,  23,  13,  11]
  distToF13 = [1000,  19,   9,   3]
  distToH13 = [1000,  15,   1,  11]
  distToL13 = [1000,   5,  11,  17]
  distToN13 = [1000,   9,  13,  21]
  distToB14 = [1000,  24,  12,  12]
  distToC14 = [1000,  23,  11,  11]
  distToD14 = [1000,  22,  10,  10]
  distToF14 = [1000,  20,   8,   4]
  distToH14 = [1000,  14,   2,  10]
  distToI14 = [1000,  13,   3,  11]
  distToJ14 = [1000,  12,   4,  12]
  distToL14 = [1000,   6,  10,  18]
  distToM14 = [1000,   7,  11,  19]
  distToN14 = [1000,   8,  12,  20]
  distToB15 = [1000,  23,  13,  13]
  distToD15 = [1000,  21,   9,   9]
  distToF15 = [1000,  19,   7,   5]
  distToH15 = [1000,  15,   3,   9]
  distToJ15 = [1000,  11,   5,  13]
  distToL15 = [1000,   7,   9,  17]
  distToB16 = [1000,  22,  14,  14]
  distToD16 = [1000,  20,   8,   8]
  distToE16 = [1000,  19,   7,   7]
  distToF16 = [1000,  18,   6,   6]
  distToG16 = [1000,  17,   5,   7]
  distToH16 = [1000,  16,   4,   8]
  distToJ16 = [1000,  10,   6,  14]
  distToK16 = [1000,   9,   7,  15]
  distToL16 = [1000,   8,   8,  16]
  distToB17 = [1000,  21,  13,  13]
  distToF17 = [1000,  17,   7,   7]
  distToL17 = [1000,   9,   9,  15]
  distToB18 = [1000,  20,  12,  12]
  distToC18 = [1000,  19,  11,  11]
  distToD18 = [1000,  18,  10,  10]
  distToE18 = [1000,  17,   9,   9]
  distToF18 = [1000,  16,   8,   8]
  distToG18 = [1000,  15,   9,   9]
  distToH18 = [1000,  14,  10,  10]
  distToI18 = [1000,  13,  11,  11]
  distToJ18 = [1000,  12,  12,  12]
  distToK18 = [1000,  11,  11,  13]
  distToL18 = [1000,  10,  10,  14]
  distToM18 = [1000,  11,  11,  15]
  distToN18 = [1000,  12,  12,  16]
  distToO18 = [1000,  13,  13,  17]
;
modify hacRoomL12
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  18,1000,  10,  18]
  distToB2  = [  19,1000,  11,  19]
  distToC2  = [  19,1000,  12,  19]
  distToD2  = [  18,1000,  13,  18]
  distToE2  = [  17,1000,  14,  19]
  distToF2  = [  16,1000,  15,  20]
  distToG2  = [  15,1000,  16,  21]
  distToH2  = [  14,1000,  17,  22]
  distToI2  = [  13,1000,  18,  23]
  distToJ2  = [  12,1000,  19,  24]
  distToK2  = [  13,1000,  19,  25]
  distToL2  = [  14,1000,  18,  26]
  distToM2  = [  13,1000,  17,  27]
  distToN2  = [  12,1000,  16,  28]
  distToD3  = [  17,1000,  14,  17]
  distToJ3  = [  11,1000,  19,  23]
  distToN3  = [  11,1000,  15,  27]
  distToD4  = [  16,1000,  15,  16]
  distToE4  = [  15,1000,  16,  17]
  distToF4  = [  14,1000,  17,  18]
  distToH4  = [  12,1000,  20,  20]
  distToI4  = [  11,1000,  19,  21]
  distToJ4  = [  10,1000,  18,  22]
  distToK4  = [  11,1000,  17,  23]
  distToL4  = [  12,1000,  16,  24]
  distToN4  = [  10,1000,  14,  26]
  distToD5  = [  15,1000,  16,  15]
  distToF5  = [  13,1000,  18,  19]
  distToH5  = [  11,1000,  19,  19]
  distToJ5  = [   9,1000,  17,  21]
  distToL5  = [  11,1000,  15,  25]
  distToN5  = [   9,1000,  13,  25]
  distToB6  = [  16,1000,  19,  16]
  distToC6  = [  15,1000,  18,  15]
  distToD6  = [  14,1000,  17,  14]
  distToF6  = [  12,1000,  19,  20]
  distToG6  = [  11,1000,  19,  19]
  distToH6  = [  10,1000,  18,  18]
  distToJ6  = [   8,1000,  16,  20]
  distToL6  = [  10,1000,  14,  26]
  distToM6  = [   9,1000,  13,  25]
  distToN6  = [   8,1000,  12,  24]
  distToB7  = [  17,1000,  20,  15]
  distToD7  = [  13,1000,  18,  13]
  distToH7  = [   9,1000,  17,  17]
  distToJ7  = [   7,1000,  15,  19]
  distToN7  = [   7,1000,  11,  23]
  distToB8  = [  18,1000,  21,  14]
  distToD8  = [  12,1000,  19,  12]
  distToE8  = [  11,1000,  19,  13]
  distToF8  = [  10,1000,  18,  14]
  distToG8  = [   9,1000,  17,  15]
  distToH8  = [   8,1000,  16,  16]
  distToI8  = [   7,1000,  15,  17]
  distToJ8  = [   6,1000,  14,  18]
  distToK8  = [   5,1000,  13,  19]
  distToL8  = [   4,1000,  12,  20]
  distToN8  = [   6,1000,  10,  22]
  distToB9  = [  17,1000,  21,  13]
  distToD9  = [  13,1000,  19,  11]
  distToL9  = [   3,1000,  11,  19]
  distToN9  = [   5,1000,   9,  21]
  distToB10 = [  16,1000,  20,  12]
  distToC10 = [  15,1000,  19,  11]
  distToD10 = [  14,1000,  18,  10]
  distToL10 = [   2,1000,  10,  18]
  distToM10 = [   3,1000,   9,  19]
  distToN10 = [   4,1000,   8,  20]
  distToB11 = [  17,1000,  21,  13]
  distToD11 = [  15,1000,  17,   9]
  distToL11 = [   1,1000,  11,  17]
  distToN11 = [   5,1000,   7,  19]
  distToB12 = [  18,1000,  22,  14]
  distToD12 = [  16,1000,  16,   8]
  distToE12 = [  17,1000,  15,   7]
  distToF12 = [  18,1000,  14,   6]
  distToG12 = [  17,1000,  13,   5]
  distToH12 = [  16,1000,  12,   4]
  distToI12 = [  15,1000,  13,   3]
  distToJ12 = [  14,1000,  14,   2]
  distToK12 = [  13,1000,  13,   1]
  distToL12 = [  12,1000,  12,  16]
  distToN12 = [   6,1000,   6,  18]
  distToB13 = [  19,1000,  21,  15]
  distToF13 = [  19,1000,  15,   7]
  distToH13 = [  17,1000,  11,   5]
  distToL13 = [  11,1000,   1,  15]
  distToN13 = [   7,1000,   5,  17]
  distToB14 = [  20,1000,  20,  16]
  distToC14 = [  21,1000,  19,  15]
  distToD14 = [  22,1000,  18,  14]
  distToF14 = [  20,1000,  16,   8]
  distToH14 = [  18,1000,  10,   6]
  distToI14 = [  17,1000,   9,   7]
  distToJ14 = [  16,1000,   8,   8]
  distToL14 = [  10,1000,   2,  14]
  distToM14 = [   9,1000,   3,  15]
  distToN14 = [   8,1000,   4,  16]
  distToB15 = [  21,1000,  19,  17]
  distToD15 = [  23,1000,  17,  13]
  distToF15 = [  21,1000,  15,   9]
  distToH15 = [  19,1000,  11,   7]
  distToJ15 = [  15,1000,   7,   9]
  distToL15 = [  11,1000,   3,  13]
  distToB16 = [  22,1000,  18,  18]
  distToD16 = [  24,1000,  16,  12]
  distToE16 = [  23,1000,  15,  11]
  distToF16 = [  22,1000,  14,  10]
  distToG16 = [  21,1000,  13,   9]
  distToH16 = [  20,1000,  12,   8]
  distToJ16 = [  14,1000,   6,  10]
  distToK16 = [  13,1000,   5,  11]
  distToL16 = [  12,1000,   4,  12]
  distToB17 = [  23,1000,  17,  17]
  distToF17 = [  21,1000,  13,  11]
  distToL17 = [  13,1000,   5,  13]
  distToB18 = [  24,1000,  16,  16]
  distToC18 = [  23,1000,  15,  15]
  distToD18 = [  22,1000,  14,  14]
  distToE18 = [  21,1000,  13,  13]
  distToF18 = [  20,1000,  12,  12]
  distToG18 = [  19,1000,  11,  13]
  distToH18 = [  18,1000,  10,  14]
  distToI18 = [  17,1000,   9,  15]
  distToJ18 = [  16,1000,   8,  16]
  distToK18 = [  15,1000,   7,  15]
  distToL18 = [  14,1000,   6,  14]
  distToM18 = [  15,1000,   7,  15]
  distToN18 = [  16,1000,   8,  16]
  distToO18 = [  17,1000,   9,  17]
;
modify hacRoomB14
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  17,  18,  18,1000]
  distToB2  = [  16,  19,  19,1000]
  distToC2  = [  15,  20,  20,1000]
  distToD2  = [  14,  21,  21,1000]
  distToE2  = [  15,  22,  22,1000]
  distToF2  = [  16,  23,  23,1000]
  distToG2  = [  17,  24,  24,1000]
  distToH2  = [  18,  25,  25,1000]
  distToI2  = [  19,  26,  26,1000]
  distToJ2  = [  20,  27,  27,1000]
  distToK2  = [  21,  28,  28,1000]
  distToL2  = [  22,  29,  29,1000]
  distToM2  = [  23,  29,  30,1000]
  distToN2  = [  24,  28,  31,1000]
  distToD3  = [  13,  21,  22,1000]
  distToJ3  = [  19,  27,  28,1000]
  distToN3  = [  25,  27,  31,1000]
  distToD4  = [  12,  20,  23,1000]
  distToE4  = [  13,  21,  24,1000]
  distToF4  = [  14,  22,  25,1000]
  distToH4  = [  16,  24,  28,1000]
  distToI4  = [  17,  25,  29,1000]
  distToJ4  = [  18,  26,  29,1000]
  distToK4  = [  19,  27,  30,1000]
  distToL4  = [  20,  28,  31,1000]
  distToN4  = [  26,  26,  30,1000]
  distToD5  = [  11,  19,  23,1000]
  distToF5  = [  15,  23,  26,1000]
  distToH5  = [  15,  23,  27,1000]
  distToJ5  = [  17,  25,  29,1000]
  distToL5  = [  21,  27,  31,1000]
  distToN5  = [  25,  25,  29,1000]
  distToB6  = [   8,  20,  24,1000]
  distToC6  = [   9,  19,  23,1000]
  distToD6  = [  10,  18,  22,1000]
  distToF6  = [  16,  24,  27,1000]
  distToG6  = [  15,  23,  27,1000]
  distToH6  = [  14,  22,  26,1000]
  distToJ6  = [  16,  24,  28,1000]
  distToL6  = [  22,  26,  30,1000]
  distToM6  = [  23,  25,  29,1000]
  distToN6  = [  24,  24,  28,1000]
  distToB7  = [   7,  19,  23,1000]
  distToD7  = [   9,  17,  21,1000]
  distToH7  = [  13,  21,  25,1000]
  distToJ7  = [  15,  23,  27,1000]
  distToN7  = [  23,  23,  27,1000]
  distToB8  = [   6,  18,  22,1000]
  distToD8  = [   8,  16,  20,1000]
  distToE8  = [   9,  17,  21,1000]
  distToF8  = [  10,  18,  22,1000]
  distToG8  = [  11,  19,  23,1000]
  distToH8  = [  12,  20,  24,1000]
  distToI8  = [  13,  21,  25,1000]
  distToJ8  = [  14,  22,  26,1000]
  distToK8  = [  15,  21,  25,1000]
  distToL8  = [  16,  20,  24,1000]
  distToN8  = [  22,  22,  26,1000]
  distToB9  = [   5,  17,  21,1000]
  distToD9  = [   7,  15,  19,1000]
  distToL9  = [  17,  19,  23,1000]
  distToN9  = [  21,  21,  25,1000]
  distToB10 = [   4,  16,  20,1000]
  distToC10 = [   5,  15,  19,1000]
  distToD10 = [   6,  14,  18,1000]
  distToL10 = [  18,  18,  22,1000]
  distToM10 = [  19,  19,  23,1000]
  distToN10 = [  20,  20,  24,1000]
  distToB11 = [   3,  17,  19,1000]
  distToD11 = [   7,  13,  17,1000]
  distToL11 = [  17,  17,  21,1000]
  distToN11 = [  21,  21,  23,1000]
  distToB12 = [   2,  18,  18,1000]
  distToD12 = [   8,  12,  16,1000]
  distToE12 = [   9,  11,  15,1000]
  distToF12 = [  10,  10,  14,1000]
  distToG12 = [  11,  11,  15,1000]
  distToH12 = [  12,  12,  16,1000]
  distToI12 = [  13,  13,  17,1000]
  distToJ12 = [  14,  14,  18,1000]
  distToK12 = [  15,  15,  19,1000]
  distToL12 = [  16,  16,  20,1000]
  distToN12 = [  22,  22,  22,1000]
  distToB13 = [   1,  17,  17,1000]
  distToF13 = [  11,   9,  13,1000]
  distToH13 = [  13,  11,  15,1000]
  distToL13 = [  17,  17,  19,1000]
  distToN13 = [  21,  21,  21,1000]
  distToB14 = [  20,  16,  16,1000]
  distToC14 = [  19,   1,  15,1000]
  distToD14 = [  18,   2,  14,1000]
  distToF14 = [  12,   8,  12,1000]
  distToH14 = [  14,  10,  14,1000]
  distToI14 = [  15,  11,  15,1000]
  distToJ14 = [  16,  12,  16,1000]
  distToL14 = [  18,  18,  18,1000]
  distToM14 = [  19,  19,  19,1000]
  distToN14 = [  20,  20,  20,1000]
  distToB15 = [  21,  15,   1,1000]
  distToD15 = [  17,   3,  13,1000]
  distToF15 = [  13,   7,  11,1000]
  distToH15 = [  15,   9,  13,1000]
  distToJ15 = [  17,  13,  17,1000]
  distToL15 = [  19,  17,  17,1000]
  distToB16 = [  22,  14,   2,1000]
  distToD16 = [  16,   4,  12,1000]
  distToE16 = [  15,   5,  11,1000]
  distToF16 = [  14,   6,  10,1000]
  distToG16 = [  15,   7,  11,1000]
  distToH16 = [  16,   8,  12,1000]
  distToJ16 = [  18,  14,  18,1000]
  distToK16 = [  19,  15,  17,1000]
  distToL16 = [  20,  16,  16,1000]
  distToB17 = [  21,  13,   3,1000]
  distToF17 = [  15,   7,   9,1000]
  distToL17 = [  21,  15,  15,1000]
  distToB18 = [  20,  12,   4,1000]
  distToC18 = [  19,  11,   5,1000]
  distToD18 = [  18,  10,   6,1000]
  distToE18 = [  17,   9,   7,1000]
  distToF18 = [  16,   8,   8,1000]
  distToG18 = [  17,   9,   9,1000]
  distToH18 = [  18,  10,  10,1000]
  distToI18 = [  19,  11,  11,1000]
  distToJ18 = [  20,  12,  12,1000]
  distToK18 = [  21,  13,  13,1000]
  distToL18 = [  21,  14,  14,1000]
  distToM18 = [  20,  15,  15,1000]
  distToN18 = [  19,  16,  16,1000]
  distToO18 = [  18,  17,  17,1000]
;
modify hacRoomH14
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  16,  12,  16,1000]
  distToB2  = [  17,  13,  17,1000]
  distToC2  = [  17,  14,  18,1000]
  distToD2  = [  16,  15,  19,1000]
  distToE2  = [  17,  16,  20,1000]
  distToF2  = [  18,  17,  21,1000]
  distToG2  = [  19,  18,  22,1000]
  distToH2  = [  20,  19,  23,1000]
  distToI2  = [  19,  20,  24,1000]
  distToJ2  = [  18,  21,  25,1000]
  distToK2  = [  19,  22,  26,1000]
  distToL2  = [  20,  23,  27,1000]
  distToM2  = [  19,  23,  27,1000]
  distToN2  = [  18,  22,  26,1000]
  distToD3  = [  15,  16,  19,1000]
  distToJ3  = [  17,  21,  25,1000]
  distToN3  = [  17,  21,  25,1000]
  distToD4  = [  14,  17,  18,1000]
  distToE4  = [  15,  18,  19,1000]
  distToF4  = [  16,  19,  20,1000]
  distToH4  = [  18,  22,  22,1000]
  distToI4  = [  17,  21,  23,1000]
  distToJ4  = [  16,  20,  24,1000]
  distToK4  = [  17,  21,  25,1000]
  distToL4  = [  18,  22,  26,1000]
  distToN4  = [  16,  20,  24,1000]
  distToD5  = [  13,  18,  17,1000]
  distToF5  = [  17,  20,  21,1000]
  distToH5  = [  17,  21,  21,1000]
  distToJ5  = [  15,  19,  23,1000]
  distToL5  = [  17,  21,  25,1000]
  distToN5  = [  15,  19,  23,1000]
  distToB6  = [  14,  21,  18,1000]
  distToC6  = [  13,  20,  17,1000]
  distToD6  = [  12,  19,  16,1000]
  distToF6  = [  18,  21,  22,1000]
  distToG6  = [  17,  21,  21,1000]
  distToH6  = [  16,  20,  20,1000]
  distToJ6  = [  14,  18,  22,1000]
  distToL6  = [  16,  20,  24,1000]
  distToM6  = [  15,  19,  23,1000]
  distToN6  = [  14,  18,  22,1000]
  distToB7  = [  13,  22,  17,1000]
  distToD7  = [  11,  20,  15,1000]
  distToH7  = [  15,  19,  19,1000]
  distToJ7  = [  13,  17,  21,1000]
  distToN7  = [  13,  17,  21,1000]
  distToB8  = [  12,  23,  16,1000]
  distToD8  = [  10,  21,  14,1000]
  distToE8  = [  11,  21,  15,1000]
  distToF8  = [  12,  20,  16,1000]
  distToG8  = [  13,  19,  17,1000]
  distToH8  = [  14,  18,  18,1000]
  distToI8  = [  13,  17,  19,1000]
  distToJ8  = [  12,  16,  20,1000]
  distToK8  = [  11,  15,  19,1000]
  distToL8  = [  10,  14,  18,1000]
  distToN8  = [  12,  16,  20,1000]
  distToB9  = [  11,  23,  15,1000]
  distToD9  = [   9,  21,  13,1000]
  distToL9  = [   9,  13,  17,1000]
  distToN9  = [  11,  15,  19,1000]
  distToB10 = [  10,  22,  14,1000]
  distToC10 = [   9,  21,  13,1000]
  distToD10 = [   8,  20,  12,1000]
  distToL10 = [   8,  12,  16,1000]
  distToM10 = [   9,  13,  17,1000]
  distToN10 = [  10,  14,  18,1000]
  distToB11 = [  11,  23,  13,1000]
  distToD11 = [   7,  19,  11,1000]
  distToL11 = [   7,  11,  15,1000]
  distToN11 = [  11,  13,  19,1000]
  distToB12 = [  12,  24,  12,1000]
  distToD12 = [   6,  18,  10,1000]
  distToE12 = [   5,  17,   9,1000]
  distToF12 = [   4,  16,   8,1000]
  distToG12 = [   3,  15,   9,1000]
  distToH12 = [   2,  14,  10,1000]
  distToI12 = [   3,  13,  11,1000]
  distToJ12 = [   4,  12,  12,1000]
  distToK12 = [   5,  11,  13,1000]
  distToL12 = [   6,  10,  14,1000]
  distToN12 = [  12,  12,  20,1000]
  distToB13 = [  13,  23,  11,1000]
  distToF13 = [   5,  17,   7,1000]
  distToH13 = [   1,  15,  11,1000]
  distToL13 = [   7,   9,  15,1000]
  distToN13 = [  11,  11,  19,1000]
  distToB14 = [  14,  22,  10,1000]
  distToC14 = [  13,  21,   9,1000]
  distToD14 = [  12,  20,   8,1000]
  distToF14 = [   6,  18,   6,1000]
  distToH14 = [  12,  16,  12,1000]
  distToI14 = [  13,   1,  13,1000]
  distToJ14 = [  14,   2,  14,1000]
  distToL14 = [   8,   8,  16,1000]
  distToM14 = [   9,   9,  17,1000]
  distToN14 = [  10,  10,  18,1000]
  distToB15 = [  15,  21,  11,1000]
  distToD15 = [  11,  19,   7,1000]
  distToF15 = [   7,  17,   5,1000]
  distToH15 = [  11,  17,   1,1000]
  distToJ15 = [  13,   3,  15,1000]
  distToL15 = [   9,   7,  15,1000]
  distToB16 = [  16,  20,  12,1000]
  distToD16 = [  10,  18,   6,1000]
  distToE16 = [   9,  17,   5,1000]
  distToF16 = [   8,  16,   4,1000]
  distToG16 = [   9,  17,   3,1000]
  distToH16 = [  10,  18,   2,1000]
  distToJ16 = [  12,   4,  16,1000]
  distToK16 = [  11,   5,  15,1000]
  distToL16 = [  10,   6,  14,1000]
  distToB17 = [  15,  19,  11,1000]
  distToF17 = [   9,  15,   5,1000]
  distToL17 = [  11,   7,  13,1000]
  distToB18 = [  14,  18,  10,1000]
  distToC18 = [  13,  17,   9,1000]
  distToD18 = [  12,  16,   8,1000]
  distToE18 = [  11,  15,   7,1000]
  distToF18 = [  10,  14,   6,1000]
  distToG18 = [  11,  13,   7,1000]
  distToH18 = [  12,  12,   8,1000]
  distToI18 = [  13,  11,   9,1000]
  distToJ18 = [  14,  10,  10,1000]
  distToK18 = [  13,   9,  11,1000]
  distToL18 = [  12,   8,  12,1000]
  distToM18 = [  13,   9,  13,1000]
  distToN18 = [  14,  10,  14,1000]
  distToO18 = [  15,  11,  15,1000]
;
modify hacRoomL14
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  20,  20,   8,1000]
  distToB2  = [  21,  21,   9,1000]
  distToC2  = [  21,  22,  10,1000]
  distToD2  = [  20,  23,  11,1000]
  distToE2  = [  19,  23,  12,1000]
  distToF2  = [  18,  22,  13,1000]
  distToG2  = [  17,  21,  14,1000]
  distToH2  = [  16,  20,  15,1000]
  distToI2  = [  15,  19,  16,1000]
  distToJ2  = [  14,  18,  17,1000]
  distToK2  = [  15,  17,  18,1000]
  distToL2  = [  16,  16,  19,1000]
  distToM2  = [  15,  15,  20,1000]
  distToN2  = [  14,  14,  21,1000]
  distToD3  = [  19,  23,  12,1000]
  distToJ3  = [  13,  17,  18,1000]
  distToN3  = [  13,  13,  22,1000]
  distToD4  = [  18,  22,  13,1000]
  distToE4  = [  17,  21,  14,1000]
  distToF4  = [  16,  20,  15,1000]
  distToH4  = [  14,  18,  21,1000]
  distToI4  = [  13,  17,  20,1000]
  distToJ4  = [  12,  16,  19,1000]
  distToK4  = [  13,  15,  20,1000]
  distToL4  = [  14,  14,  21,1000]
  distToN4  = [  12,  12,  23,1000]
  distToD5  = [  17,  21,  14,1000]
  distToF5  = [  15,  19,  16,1000]
  distToH5  = [  13,  17,  20,1000]
  distToJ5  = [  11,  15,  20,1000]
  distToL5  = [  13,  13,  22,1000]
  distToN5  = [  11,  11,  23,1000]
  distToB6  = [  18,  22,  17,1000]
  distToC6  = [  17,  21,  16,1000]
  distToD6  = [  16,  20,  15,1000]
  distToF6  = [  14,  18,  17,1000]
  distToG6  = [  13,  17,  18,1000]
  distToH6  = [  12,  16,  19,1000]
  distToJ6  = [  10,  14,  21,1000]
  distToL6  = [  12,  12,  23,1000]
  distToM6  = [  11,  11,  23,1000]
  distToN6  = [  10,  10,  22,1000]
  distToB7  = [  17,  23,  18,1000]
  distToD7  = [  15,  19,  16,1000]
  distToH7  = [  11,  15,  20,1000]
  distToJ7  = [   9,  13,  21,1000]
  distToN7  = [   9,   9,  21,1000]
  distToB8  = [  16,  24,  19,1000]
  distToD8  = [  14,  18,  17,1000]
  distToE8  = [  13,  17,  18,1000]
  distToF8  = [  12,  16,  19,1000]
  distToG8  = [  11,  15,  20,1000]
  distToH8  = [  10,  14,  21,1000]
  distToI8  = [   9,  13,  21,1000]
  distToJ8  = [   8,  12,  20,1000]
  distToK8  = [   7,  11,  19,1000]
  distToL8  = [   6,  10,  18,1000]
  distToN8  = [   8,   8,  20,1000]
  distToB9  = [  15,  23,  19,1000]
  distToD9  = [  13,  19,  17,1000]
  distToL9  = [   5,   9,  17,1000]
  distToN9  = [   7,   7,  19,1000]
  distToB10 = [  14,  22,  18,1000]
  distToC10 = [  13,  21,  17,1000]
  distToD10 = [  12,  20,  16,1000]
  distToL10 = [   4,   8,  16,1000]
  distToM10 = [   5,   7,  17,1000]
  distToN10 = [   6,   6,  18,1000]
  distToB11 = [  15,  23,  19,1000]
  distToD11 = [  11,  19,  15,1000]
  distToL11 = [   3,   9,  15,1000]
  distToN11 = [   7,   5,  19,1000]
  distToB12 = [  16,  24,  20,1000]
  distToD12 = [  10,  18,  14,1000]
  distToE12 = [   9,  17,  13,1000]
  distToF12 = [   8,  16,  12,1000]
  distToG12 = [   7,  15,  11,1000]
  distToH12 = [   6,  14,  10,1000]
  distToI12 = [   5,  13,  11,1000]
  distToJ12 = [   4,  12,  12,1000]
  distToK12 = [   3,  11,  13,1000]
  distToL12 = [   2,  10,  14,1000]
  distToN12 = [   8,   4,  20,1000]
  distToB13 = [  17,  25,  19,1000]
  distToF13 = [   9,  17,  13,1000]
  distToH13 = [   7,  15,   9,1000]
  distToL13 = [   1,  11,  15,1000]
  distToN13 = [   9,   3,  19,1000]
  distToB14 = [  18,  26,  18,1000]
  distToC14 = [  17,  25,  17,1000]
  distToD14 = [  16,  24,  16,1000]
  distToF14 = [  10,  18,  14,1000]
  distToH14 = [   8,  16,   8,1000]
  distToI14 = [   9,  17,   7,1000]
  distToJ14 = [  10,  18,   6,1000]
  distToL14 = [  12,  12,  16,1000]
  distToM14 = [  11,   1,  17,1000]
  distToN14 = [  10,   2,  18,1000]
  distToB15 = [  19,  27,  17,1000]
  distToD15 = [  15,  23,  15,1000]
  distToF15 = [  11,  19,  13,1000]
  distToH15 = [   9,  17,   9,1000]
  distToJ15 = [  11,  17,   5,1000]
  distToL15 = [  13,  13,   1,1000]
  distToB16 = [  20,  28,  16,1000]
  distToD16 = [  14,  22,  14,1000]
  distToE16 = [  13,  21,  13,1000]
  distToF16 = [  12,  20,  12,1000]
  distToG16 = [  11,  19,  11,1000]
  distToH16 = [  10,  18,  10,1000]
  distToJ16 = [  12,  16,   4,1000]
  distToK16 = [  13,  15,   3,1000]
  distToL16 = [  14,  14,   2,1000]
  distToB17 = [  19,  27,  15,1000]
  distToF17 = [  13,  21,  11,1000]
  distToL17 = [  15,  15,   3,1000]
  distToB18 = [  18,  26,  14,1000]
  distToC18 = [  17,  25,  13,1000]
  distToD18 = [  16,  24,  12,1000]
  distToE18 = [  15,  23,  11,1000]
  distToF18 = [  14,  22,  10,1000]
  distToG18 = [  15,  21,   9,1000]
  distToH18 = [  16,  20,   8,1000]
  distToI18 = [  17,  19,   7,1000]
  distToJ18 = [  18,  18,   6,1000]
  distToK18 = [  17,  17,   5,1000]
  distToL18 = [  16,  16,   4,1000]
  distToM18 = [  17,  17,   5,1000]
  distToN18 = [  18,  18,   6,1000]
  distToO18 = [  19,  19,   7,1000]
;
modify hacRoomF16
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  19,  16,  12,  23]
  distToB2  = [  18,  17,  13,  22]
  distToC2  = [  17,  18,  14,  21]
  distToD2  = [  16,  19,  15,  20]
  distToE2  = [  17,  20,  16,  21]
  distToF2  = [  18,  21,  17,  22]
  distToG2  = [  19,  22,  18,  23]
  distToH2  = [  20,  23,  19,  24]
  distToI2  = [  21,  23,  20,  25]
  distToJ2  = [  22,  22,  21,  26]
  distToK2  = [  23,  23,  22,  27]
  distToL2  = [  24,  24,  23,  28]
  distToM2  = [  23,  23,  24,  29]
  distToN2  = [  22,  22,  25,  30]
  distToD3  = [  15,  19,  16,  19]
  distToJ3  = [  21,  21,  22,  25]
  distToN3  = [  21,  21,  25,  31]
  distToD4  = [  14,  18,  17,  18]
  distToE4  = [  15,  19,  18,  19]
  distToF4  = [  16,  20,  19,  20]
  distToH4  = [  18,  22,  25,  22]
  distToI4  = [  19,  21,  24,  23]
  distToJ4  = [  20,  20,  23,  24]
  distToK4  = [  21,  21,  24,  25]
  distToL4  = [  22,  22,  25,  26]
  distToN4  = [  20,  20,  24,  32]
  distToD5  = [  13,  17,  18,  17]
  distToF5  = [  17,  21,  20,  21]
  distToH5  = [  17,  21,  24,  21]
  distToJ5  = [  19,  19,  23,  23]
  distToL5  = [  21,  21,  25,  27]
  distToN5  = [  19,  19,  23,  31]
  distToB6  = [  14,  18,  18,  14]
  distToC6  = [  13,  17,  19,  15]
  distToD6  = [  12,  16,  19,  16]
  distToF6  = [  18,  22,  21,  22]
  distToG6  = [  17,  21,  22,  21]
  distToH6  = [  16,  20,  23,  20]
  distToJ6  = [  18,  18,  22,  22]
  distToL6  = [  20,  20,  24,  28]
  distToM6  = [  19,  19,  23,  29]
  distToN6  = [  18,  18,  22,  30]
  distToB7  = [  13,  17,  17,  13]
  distToD7  = [  11,  15,  19,  15]
  distToH7  = [  15,  19,  23,  19]
  distToJ7  = [  17,  17,  21,  21]
  distToN7  = [  17,  17,  21,  29]
  distToB8  = [  12,  16,  16,  12]
  distToD8  = [  10,  14,  18,  14]
  distToE8  = [  11,  15,  19,  15]
  distToF8  = [  12,  16,  20,  16]
  distToG8  = [  13,  17,  21,  17]
  distToH8  = [  14,  18,  22,  18]
  distToI8  = [  15,  17,  21,  19]
  distToJ8  = [  16,  16,  20,  20]
  distToK8  = [  15,  15,  19,  21]
  distToL8  = [  14,  14,  18,  22]
  distToN8  = [  16,  16,  20,  28]
  distToB9  = [  11,  15,  15,  11]
  distToD9  = [   9,  13,  17,  13]
  distToL9  = [  13,  13,  17,  23]
  distToN9  = [  15,  15,  19,  27]
  distToB10 = [  10,  14,  14,  10]
  distToC10 = [   9,  13,  15,  11]
  distToD10 = [   8,  12,  16,  12]
  distToL10 = [  12,  12,  16,  24]
  distToM10 = [  13,  13,  17,  25]
  distToN10 = [  14,  14,  18,  26]
  distToB11 = [  11,  15,  13,   9]
  distToD11 = [   7,  11,  17,  13]
  distToL11 = [  11,  11,  15,  23]
  distToN11 = [  15,  15,  17,  27]
  distToB12 = [  12,  16,  12,   8]
  distToD12 = [   6,  10,  18,  14]
  distToE12 = [   5,   9,  19,  15]
  distToF12 = [   4,   8,  20,  16]
  distToG12 = [   5,   7,  19,  17]
  distToH12 = [   6,   6,  18,  18]
  distToI12 = [   7,   7,  17,  19]
  distToJ12 = [   8,   8,  16,  20]
  distToK12 = [   9,   9,  15,  21]
  distToL12 = [  10,  10,  14,  22]
  distToN12 = [  16,  16,  16,  28]
  distToB13 = [  13,  17,  11,   7]
  distToF13 = [   3,   9,  19,  17]
  distToH13 = [   7,   5,  17,  19]
  distToL13 = [  11,  11,  13,  23]
  distToN13 = [  15,  15,  15,  27]
  distToB14 = [  14,  18,  10,   6]
  distToC14 = [  15,  17,  11,   5]
  distToD14 = [  16,  16,  12,   4]
  distToF14 = [   2,  10,  18,  18]
  distToH14 = [   8,   4,  16,  20]
  distToI14 = [   9,   5,  15,  21]
  distToJ14 = [  10,   6,  14,  22]
  distToL14 = [  12,  12,  12,  24]
  distToM14 = [  13,  13,  13,  25]
  distToN14 = [  14,  14,  14,  26]
  distToB15 = [  15,  19,   9,   7]
  distToD15 = [  15,  15,  13,   3]
  distToF15 = [   1,  11,  17,  17]
  distToH15 = [   9,   3,  17,  19]
  distToJ15 = [  11,   7,  13,  23]
  distToL15 = [  13,  11,  11,  23]
  distToB16 = [  16,  20,   8,   8]
  distToD16 = [  14,  14,  14,   2]
  distToE16 = [  13,  13,  15,   1]
  distToF16 = [  12,  12,  16,  16]
  distToG16 = [  11,   1,  17,  17]
  distToH16 = [  10,   2,  18,  18]
  distToJ16 = [  12,   8,  12,  24]
  distToK16 = [  13,   9,  11,  23]
  distToL16 = [  14,  10,  10,  22]
  distToB17 = [  17,  19,   7,   9]
  distToF17 = [  13,  13,   1,  15]
  distToL17 = [  15,  11,   9,  21]
  distToB18 = [  18,  18,   6,  10]
  distToC18 = [  17,  17,   5,  11]
  distToD18 = [  16,  16,   4,  12]
  distToE18 = [  15,  15,   3,  13]
  distToF18 = [  14,  14,   2,  14]
  distToG18 = [  15,  15,   3,  15]
  distToH18 = [  16,  16,   4,  16]
  distToI18 = [  17,  15,   5,  17]
  distToJ18 = [  18,  14,   6,  18]
  distToK18 = [  17,  13,   7,  19]
  distToL18 = [  16,  12,   8,  20]
  distToM18 = [  17,  13,   9,  21]
  distToN18 = [  18,  14,  10,  22]
  distToO18 = [  19,  15,  11,  23]
;
modify hacRoomL16
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  22,1000,   6,  22]
  distToB2  = [  23,1000,   7,  23]
  distToC2  = [  23,1000,   8,  23]
  distToD2  = [  22,1000,   9,  22]
  distToE2  = [  21,1000,  10,  23]
  distToF2  = [  20,1000,  11,  24]
  distToG2  = [  19,1000,  12,  25]
  distToH2  = [  18,1000,  13,  26]
  distToI2  = [  17,1000,  14,  25]
  distToJ2  = [  16,1000,  15,  24]
  distToK2  = [  17,1000,  16,  25]
  distToL2  = [  18,1000,  17,  26]
  distToM2  = [  17,1000,  18,  25]
  distToN2  = [  16,1000,  19,  24]
  distToD3  = [  21,1000,  10,  21]
  distToJ3  = [  15,1000,  16,  23]
  distToN3  = [  15,1000,  20,  23]
  distToD4  = [  20,1000,  11,  20]
  distToE4  = [  19,1000,  12,  21]
  distToF4  = [  18,1000,  13,  22]
  distToH4  = [  16,1000,  19,  24]
  distToI4  = [  15,1000,  18,  23]
  distToJ4  = [  14,1000,  17,  22]
  distToK4  = [  15,1000,  18,  23]
  distToL4  = [  16,1000,  19,  24]
  distToN4  = [  14,1000,  21,  22]
  distToD5  = [  19,1000,  12,  19]
  distToF5  = [  17,1000,  14,  23]
  distToH5  = [  15,1000,  18,  23]
  distToJ5  = [  13,1000,  18,  21]
  distToL5  = [  15,1000,  20,  23]
  distToN5  = [  13,1000,  22,  21]
  distToB6  = [  20,1000,  15,  20]
  distToC6  = [  19,1000,  14,  19]
  distToD6  = [  18,1000,  13,  18]
  distToF6  = [  16,1000,  15,  24]
  distToG6  = [  15,1000,  16,  23]
  distToH6  = [  14,1000,  17,  22]
  distToJ6  = [  12,1000,  19,  20]
  distToL6  = [  14,1000,  21,  22]
  distToM6  = [  13,1000,  22,  21]
  distToN6  = [  12,1000,  23,  20]
  distToB7  = [  19,1000,  16,  19]
  distToD7  = [  17,1000,  14,  17]
  distToH7  = [  13,1000,  18,  21]
  distToJ7  = [  11,1000,  20,  19]
  distToN7  = [  11,1000,  24,  19]
  distToB8  = [  18,1000,  17,  18]
  distToD8  = [  16,1000,  15,  16]
  distToE8  = [  15,1000,  16,  17]
  distToF8  = [  14,1000,  17,  18]
  distToG8  = [  13,1000,  18,  19]
  distToH8  = [  12,1000,  19,  20]
  distToI8  = [  11,1000,  20,  19]
  distToJ8  = [  10,1000,  21,  18]
  distToK8  = [   9,1000,  22,  17]
  distToL8  = [   8,1000,  23,  16]
  distToN8  = [  10,1000,  25,  18]
  distToB9  = [  17,1000,  18,  17]
  distToD9  = [  15,1000,  16,  15]
  distToL9  = [   7,1000,  23,  15]
  distToN9  = [   9,1000,  25,  17]
  distToB10 = [  16,1000,  19,  16]
  distToC10 = [  15,1000,  18,  15]
  distToD10 = [  14,1000,  17,  14]
  distToL10 = [   6,1000,  22,  14]
  distToM10 = [   7,1000,  23,  15]
  distToN10 = [   8,1000,  24,  16]
  distToB11 = [  17,1000,  19,  17]
  distToD11 = [  13,1000,  17,  13]
  distToL11 = [   5,1000,  21,  13]
  distToN11 = [   7,1000,  25,  17]
  distToB12 = [  18,1000,  18,  18]
  distToD12 = [  12,1000,  16,  12]
  distToE12 = [  11,1000,  15,  11]
  distToF12 = [  10,1000,  14,  10]
  distToG12 = [   9,1000,  15,   9]
  distToH12 = [   8,1000,  16,   8]
  distToI12 = [   7,1000,  17,   9]
  distToJ12 = [   6,1000,  18,  10]
  distToK12 = [   5,1000,  19,  11]
  distToL12 = [   4,1000,  20,  12]
  distToN12 = [   6,1000,  26,  18]
  distToB13 = [  19,1000,  17,  17]
  distToF13 = [  11,1000,  13,  11]
  distToH13 = [   9,1000,  15,   7]
  distToL13 = [   3,1000,  21,  13]
  distToN13 = [   5,1000,  25,  17]
  distToB14 = [  20,1000,  16,  16]
  distToC14 = [  19,1000,  15,  15]
  distToD14 = [  18,1000,  14,  14]
  distToF14 = [  12,1000,  12,  12]
  distToH14 = [  10,1000,  14,   6]
  distToI14 = [  11,1000,  15,   5]
  distToJ14 = [  12,1000,  16,   4]
  distToL14 = [   2,1000,  22,  14]
  distToM14 = [   3,1000,  23,  15]
  distToN14 = [   4,1000,  24,  16]
  distToB15 = [  21,1000,  15,  17]
  distToD15 = [  17,1000,  13,  13]
  distToF15 = [  13,1000,  11,  11]
  distToH15 = [  11,1000,  13,   7]
  distToJ15 = [  13,1000,  17,   3]
  distToL15 = [   1,1000,  21,  15]
  distToB16 = [  22,1000,  14,  18]
  distToD16 = [  16,1000,  12,  12]
  distToE16 = [  15,1000,  11,  11]
  distToF16 = [  14,1000,  10,  10]
  distToG16 = [  13,1000,  11,   9]
  distToH16 = [  12,1000,  12,   8]
  distToJ16 = [  14,1000,  18,   2]
  distToK16 = [  15,1000,  19,   1]
  distToL16 = [  16,1000,  20,  16]
  distToB17 = [  21,1000,  13,  17]
  distToF17 = [  15,1000,   9,  11]
  distToL17 = [  17,1000,   1,  17]
  distToB18 = [  20,1000,  12,  16]
  distToC18 = [  19,1000,  11,  15]
  distToD18 = [  18,1000,  10,  14]
  distToE18 = [  17,1000,   9,  13]
  distToF18 = [  16,1000,   8,  12]
  distToG18 = [  17,1000,   7,  13]
  distToH18 = [  18,1000,   6,  14]
  distToI18 = [  19,1000,   5,  15]
  distToJ18 = [  20,1000,   4,  16]
  distToK18 = [  19,1000,   3,  17]
  distToL18 = [  18,1000,   2,  18]
  distToM18 = [  19,1000,   3,  19]
  distToN18 = [  20,1000,   4,  20]
  distToO18 = [  21,1000,   5,  21]
;
modify hacRoomF18
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  18,  10,1000,  25]
  distToB2  = [  19,  11,1000,  24]
  distToC2  = [  19,  12,1000,  23]
  distToD2  = [  18,  13,1000,  22]
  distToE2  = [  19,  14,1000,  23]
  distToF2  = [  20,  15,1000,  24]
  distToG2  = [  21,  16,1000,  25]
  distToH2  = [  22,  17,1000,  26]
  distToI2  = [  23,  18,1000,  27]
  distToJ2  = [  24,  19,1000,  28]
  distToK2  = [  25,  20,1000,  29]
  distToL2  = [  26,  21,1000,  30]
  distToM2  = [  25,  22,1000,  31]
  distToN2  = [  24,  23,1000,  32]
  distToD3  = [  17,  14,1000,  21]
  distToJ3  = [  23,  20,1000,  27]
  distToN3  = [  23,  23,1000,  33]
  distToD4  = [  16,  15,1000,  20]
  distToE4  = [  17,  16,1000,  21]
  distToF4  = [  18,  17,1000,  22]
  distToH4  = [  20,  23,1000,  24]
  distToI4  = [  21,  22,1000,  25]
  distToJ4  = [  22,  21,1000,  26]
  distToK4  = [  23,  22,1000,  27]
  distToL4  = [  24,  23,1000,  28]
  distToN4  = [  22,  22,1000,  34]
  distToD5  = [  15,  16,1000,  19]
  distToF5  = [  19,  18,1000,  23]
  distToH5  = [  19,  22,1000,  23]
  distToJ5  = [  21,  21,1000,  25]
  distToL5  = [  23,  23,1000,  29]
  distToN5  = [  21,  21,1000,  33]
  distToB6  = [  16,  19,1000,  16]
  distToC6  = [  15,  18,1000,  17]
  distToD6  = [  14,  17,1000,  18]
  distToF6  = [  20,  19,1000,  24]
  distToG6  = [  19,  20,1000,  23]
  distToH6  = [  18,  21,1000,  22]
  distToJ6  = [  20,  20,1000,  24]
  distToL6  = [  22,  22,1000,  30]
  distToM6  = [  21,  21,1000,  31]
  distToN6  = [  20,  20,1000,  32]
  distToB7  = [  15,  20,1000,  15]
  distToD7  = [  13,  18,1000,  17]
  distToH7  = [  17,  21,1000,  21]
  distToJ7  = [  19,  19,1000,  23]
  distToN7  = [  19,  19,1000,  31]
  distToB8  = [  14,  21,1000,  14]
  distToD8  = [  12,  19,1000,  16]
  distToE8  = [  13,  20,1000,  17]
  distToF8  = [  14,  21,1000,  18]
  distToG8  = [  15,  21,1000,  19]
  distToH8  = [  16,  20,1000,  20]
  distToI8  = [  17,  19,1000,  21]
  distToJ8  = [  18,  18,1000,  22]
  distToK8  = [  17,  17,1000,  23]
  distToL8  = [  16,  16,1000,  24]
  distToN8  = [  18,  18,1000,  30]
  distToB9  = [  13,  22,1000,  13]
  distToD9  = [  11,  20,1000,  15]
  distToL9  = [  15,  15,1000,  25]
  distToN9  = [  17,  17,1000,  29]
  distToB10 = [  12,  23,1000,  12]
  distToC10 = [  11,  22,1000,  13]
  distToD10 = [  10,  21,1000,  14]
  distToL10 = [  14,  14,1000,  26]
  distToM10 = [  15,  15,1000,  27]
  distToN10 = [  16,  16,1000,  28]
  distToB11 = [  11,  24,1000,  11]
  distToD11 = [   9,  21,1000,  15]
  distToL11 = [  13,  13,1000,  25]
  distToN11 = [  17,  15,1000,  29]
  distToB12 = [  10,  25,1000,  10]
  distToD12 = [   8,  20,1000,  16]
  distToE12 = [   7,  19,1000,  17]
  distToF12 = [   6,  18,1000,  18]
  distToG12 = [   7,  17,1000,  19]
  distToH12 = [   8,  16,1000,  20]
  distToI12 = [   9,  15,1000,  21]
  distToJ12 = [  10,  14,1000,  22]
  distToK12 = [  11,  13,1000,  23]
  distToL12 = [  12,  12,1000,  24]
  distToN12 = [  18,  14,1000,  30]
  distToB13 = [   9,  25,1000,   9]
  distToF13 = [   5,  19,1000,  17]
  distToH13 = [   7,  15,1000,  19]
  distToL13 = [  13,  11,1000,  25]
  distToN13 = [  17,  13,1000,  29]
  distToB14 = [   8,  24,1000,   8]
  distToC14 = [   7,  23,1000,   9]
  distToD14 = [   6,  22,1000,  10]
  distToF14 = [   4,  20,1000,  16]
  distToH14 = [   6,  14,1000,  18]
  distToI14 = [   7,  13,1000,  19]
  distToJ14 = [   8,  12,1000,  20]
  distToL14 = [  14,  10,1000,  26]
  distToM14 = [  15,  11,1000,  27]
  distToN14 = [  16,  12,1000,  28]
  distToB15 = [   9,  25,1000,   7]
  distToD15 = [   5,  21,1000,  11]
  distToF15 = [   3,  19,1000,  15]
  distToH15 = [   5,  15,1000,  17]
  distToJ15 = [   9,  11,1000,  21]
  distToL15 = [  13,   9,1000,  25]
  distToB16 = [  10,  26,1000,   6]
  distToD16 = [   4,  20,1000,  12]
  distToE16 = [   3,  19,1000,  13]
  distToF16 = [   2,  18,1000,  14]
  distToG16 = [   3,  17,1000,  15]
  distToH16 = [   4,  16,1000,  16]
  distToJ16 = [  10,  10,1000,  22]
  distToK16 = [  11,   9,1000,  23]
  distToL16 = [  12,   8,1000,  24]
  distToB17 = [  11,  25,1000,   5]
  distToF17 = [   1,  19,1000,  15]
  distToL17 = [  13,   7,1000,  23]
  distToB18 = [  12,  24,1000,   4]
  distToC18 = [  13,  23,1000,   3]
  distToD18 = [  14,  22,1000,   2]
  distToE18 = [  15,  21,1000,   1]
  distToF18 = [  16,  20,1000,  16]
  distToG18 = [  17,   1,1000,  17]
  distToH18 = [  18,   2,1000,  18]
  distToI18 = [  17,   3,1000,  19]
  distToJ18 = [  16,   4,1000,  20]
  distToK18 = [  15,   5,1000,  21]
  distToL18 = [  14,   6,1000,  22]
  distToM18 = [  15,   7,1000,  23]
  distToN18 = [  16,   8,1000,  24]
  distToO18 = [  17,   9,1000,  25]
;
modify hacRoomL18
  // The following properties give the distance from this
  // room to the specified room, assuming you start by
  // going in a specified direction [N, E, S, W].
  distToA2  = [  24,   4,1000,  24]
  distToB2  = [  25,   5,1000,  25]
  distToC2  = [  25,   6,1000,  25]
  distToD2  = [  24,   7,1000,  24]
  distToE2  = [  23,   8,1000,  25]
  distToF2  = [  22,   9,1000,  26]
  distToG2  = [  21,  10,1000,  27]
  distToH2  = [  20,  11,1000,  28]
  distToI2  = [  19,  12,1000,  29]
  distToJ2  = [  18,  13,1000,  30]
  distToK2  = [  19,  14,1000,  31]
  distToL2  = [  20,  15,1000,  32]
  distToM2  = [  19,  16,1000,  31]
  distToN2  = [  18,  17,1000,  30]
  distToD3  = [  23,   8,1000,  23]
  distToJ3  = [  17,  14,1000,  29]
  distToN3  = [  17,  18,1000,  29]
  distToD4  = [  22,   9,1000,  22]
  distToE4  = [  21,  10,1000,  23]
  distToF4  = [  20,  11,1000,  24]
  distToH4  = [  18,  17,1000,  26]
  distToI4  = [  17,  16,1000,  27]
  distToJ4  = [  16,  15,1000,  28]
  distToK4  = [  17,  16,1000,  29]
  distToL4  = [  18,  17,1000,  30]
  distToN4  = [  16,  19,1000,  28]
  distToD5  = [  21,  10,1000,  21]
  distToF5  = [  19,  12,1000,  25]
  distToH5  = [  17,  16,1000,  25]
  distToJ5  = [  15,  16,1000,  27]
  distToL5  = [  17,  18,1000,  29]
  distToN5  = [  15,  20,1000,  27]
  distToB6  = [  22,  13,1000,  22]
  distToC6  = [  21,  12,1000,  21]
  distToD6  = [  20,  11,1000,  20]
  distToF6  = [  18,  13,1000,  26]
  distToG6  = [  17,  14,1000,  25]
  distToH6  = [  16,  15,1000,  24]
  distToJ6  = [  14,  17,1000,  26]
  distToL6  = [  16,  19,1000,  28]
  distToM6  = [  15,  20,1000,  27]
  distToN6  = [  14,  21,1000,  26]
  distToB7  = [  21,  14,1000,  21]
  distToD7  = [  19,  12,1000,  19]
  distToH7  = [  15,  16,1000,  23]
  distToJ7  = [  13,  18,1000,  25]
  distToN7  = [  13,  22,1000,  25]
  distToB8  = [  20,  15,1000,  20]
  distToD8  = [  18,  13,1000,  18]
  distToE8  = [  17,  14,1000,  19]
  distToF8  = [  16,  15,1000,  20]
  distToG8  = [  15,  16,1000,  21]
  distToH8  = [  14,  17,1000,  22]
  distToI8  = [  13,  18,1000,  23]
  distToJ8  = [  12,  19,1000,  24]
  distToK8  = [  11,  20,1000,  23]
  distToL8  = [  10,  21,1000,  22]
  distToN8  = [  12,  23,1000,  24]
  distToB9  = [  19,  16,1000,  19]
  distToD9  = [  17,  14,1000,  17]
  distToL9  = [   9,  22,1000,  21]
  distToN9  = [  11,  24,1000,  23]
  distToB10 = [  18,  17,1000,  18]
  distToC10 = [  17,  16,1000,  17]
  distToD10 = [  16,  15,1000,  16]
  distToL10 = [   8,  23,1000,  20]
  distToM10 = [   9,  24,1000,  21]
  distToN10 = [  10,  25,1000,  22]
  distToB11 = [  19,  18,1000,  17]
  distToD11 = [  15,  16,1000,  15]
  distToL11 = [   7,  24,1000,  19]
  distToN11 = [   9,  26,1000,  23]
  distToB12 = [  20,  19,1000,  16]
  distToD12 = [  14,  17,1000,  14]
  distToE12 = [  13,  18,1000,  13]
  distToF12 = [  12,  19,1000,  12]
  distToG12 = [  11,  20,1000,  13]
  distToH12 = [  10,  21,1000,  14]
  distToI12 = [   9,  22,1000,  15]
  distToJ12 = [   8,  23,1000,  16]
  distToK12 = [   7,  24,1000,  17]
  distToL12 = [   6,  25,1000,  18]
  distToN12 = [   8,  27,1000,  24]
  distToB13 = [  19,  20,1000,  15]
  distToF13 = [  13,  20,1000,  11]
  distToH13 = [   9,  22,1000,  13]
  distToL13 = [   5,  26,1000,  19]
  distToN13 = [   7,  28,1000,  23]
  distToB14 = [  18,  21,1000,  14]
  distToC14 = [  17,  22,1000,  13]
  distToD14 = [  16,  23,1000,  12]
  distToF14 = [  14,  21,1000,  10]
  distToH14 = [   8,  23,1000,  12]
  distToI14 = [   7,  24,1000,  13]
  distToJ14 = [   6,  25,1000,  14]
  distToL14 = [   4,  27,1000,  20]
  distToM14 = [   5,  28,1000,  21]
  distToN14 = [   6,  29,1000,  22]
  distToB15 = [  19,  22,1000,  13]
  distToD15 = [  15,  24,1000,  11]
  distToF15 = [  13,  22,1000,   9]
  distToH15 = [   9,  24,1000,  11]
  distToJ15 = [   5,  26,1000,  15]
  distToL15 = [   3,  28,1000,  19]
  distToB16 = [  20,  23,1000,  12]
  distToD16 = [  14,  25,1000,  10]
  distToE16 = [  13,  24,1000,   9]
  distToF16 = [  12,  23,1000,   8]
  distToG16 = [  11,  24,1000,   9]
  distToH16 = [  10,  25,1000,  10]
  distToJ16 = [   4,  27,1000,  16]
  distToK16 = [   3,  28,1000,  17]
  distToL16 = [   2,  29,1000,  18]
  distToB17 = [  19,  24,1000,  11]
  distToF17 = [  13,  24,1000,   7]
  distToL17 = [   1,  30,1000,  19]
  distToB18 = [  18,  25,1000,  10]
  distToC18 = [  17,  26,1000,   9]
  distToD18 = [  16,  27,1000,   8]
  distToE18 = [  15,  26,1000,   7]
  distToF18 = [  14,  25,1000,   6]
  distToG18 = [  15,  26,1000,   5]
  distToH18 = [  16,  27,1000,   4]
  distToI18 = [  17,  28,1000,   3]
  distToJ18 = [  18,  29,1000,   2]
  distToK18 = [  19,  30,1000,   1]
  distToL18 = [  20,  31,1000,  20]
  distToM18 = [  21,   1,1000,  21]
  distToN18 = [  22,   2,1000,  22]
  distToO18 = [  23,   3,1000,  23]
;
*/












// -------------------------------------------------------------------
// HAC-MAN MAZE: MAP
// -------------------------------------------------------------------

modify glob
  // The "power pellets" are now seen to be "potions of polymorph monster";
  // as such, they do not "power up" Sheila (increasing her attributes, etc.),
  // but rather "power down" her adversary, polymorphing it to its 
  // disadvantage.
  poweringEffect = nil
;

function hacMapPrint() {
return '<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
  <tr> 
    <td colspan="15" align="center"><img src="hacman/title.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall48.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/' + hacRoomA2.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomB2.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomC2.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomD2.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomE2.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomF2.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomG2.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomH2.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomI2.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomJ2.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomK2.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomL2.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomM2.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomN2.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall48.png" border="0"></td>
    <td><img src="hacman/' + hacRoomD3.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall6.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall468.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall4.png" border="0"></td>
    <td><img src="hacman/' + hacRoomJ3.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall6.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall48.png" border="0"></td>
    <td><img src="hacman/' + hacRoomN3.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/nil.png\" border=\"0\"></td>
    <td><img src="hacman/nil.png\" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomD4.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomE4.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomF4.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomH4.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomI4.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomJ4.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomK4.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomL4.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomN4.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall68.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall24.png" border="0"></td>
    <td><img src="hacman/' + hacRoomD5.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall8.png" border="0"></td>
    <td><img src="hacman/' + hacRoomF5.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall2.png" border="0"></td>
    <td><img src="hacman/' + hacRoomH5.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall8.png" border="0"></td>
    <td><img src="hacman/' + hacRoomJ5.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall8.png" border="0"></td>
    <td><img src="hacman/' + hacRoomL5.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall2.png" border="0"></td>
    <td><img src="hacman/' + hacRoomN5.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomB6.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomC6.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomD6.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomF6.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomG6.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomH6.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomJ6.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomL6.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomM6.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomN6.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomB7.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall8.png" border="0"></td>
    <td><img src="hacman/' + hacRoomD7.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall26.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall4.png" border="0"></td>
    <td><img src="hacman/' + hacRoomH7.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall2.png" border="0"></td>
    <td><img src="hacman/' + hacRoomJ7.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall26.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall48.png" border="0"></td>
    <td><img src="hacman/' + hacRoomN7.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomB8.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomD8.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomE8.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomF8.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomG8.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomH8.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomI8.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomJ8.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomK8.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomL8.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomN8.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomB9.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall2.png" border="0"></td>
    <td><img src="hacman/' + hacRoomD9.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall68.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/' + hacRoomH9.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall48.png" border="0"></td>
    <td><img src="hacman/' + hacRoomL9.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall2.png" border="0"></td>
    <td><img src="hacman/' + hacRoomN9.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomB10.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomC10.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomD10.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/nil.png\" border=\"0\"></td>
    <td><img src="hacman/nil.png\" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomH10.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/nil.png\" border=\"0\"></td>
    <td><img src="hacman/nil.png\" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomL10.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomM10.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomN10.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomB11.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall8.png" border="0"></td>
    <td><img src="hacman/' + hacRoomD11.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall26.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall24.png" border="0"></td>
    <td><img src="hacman/' + hacRoomL11.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall8.png" border="0"></td>
    <td><img src="hacman/' + hacRoomN11.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomB12.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomD12.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomE12.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomF12.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomG12.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomH12.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomI12.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomJ12.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomK12.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomL12.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomN12.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomB13.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall26.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall48.png" border="0"></td>
    <td><img src="hacman/' + hacRoomF13.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall8.png" border="0"></td>
    <td><img src="hacman/' + hacRoomH13.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall6.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall48.png" border="0"></td>
    <td><img src="hacman/' + hacRoomL13.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall2.png" border="0"></td>
    <td><img src="hacman/' + hacRoomN13.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomB14.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomC14.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomD14.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomF14.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomH14.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomI14.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomJ14.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomL14.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomM14.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomN14.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomB15.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall8.png" border="0"></td>
    <td><img src="hacman/' + hacRoomD15.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall2.png" border="0"></td>
    <td><img src="hacman/' + hacRoomF15.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall2.png" border="0"></td>
    <td><img src="hacman/' + hacRoomH15.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall8.png" border="0"></td>
    <td><img src="hacman/' + hacRoomJ15.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall2.png" border="0"></td>
    <td><img src="hacman/' + hacRoomL15.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall68.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall24.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomB16.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomD16.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomE16.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomF16.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomG16.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomH16.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomJ16.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomK16.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomL16.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/nil.png\" border=\"0\"></td>
    <td><img src="hacman/nil.png\" border=\"0\"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomB17.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall26.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall4.png" border="0"></td>
    <td><img src="hacman/' + hacRoomF17.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall6.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall246.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall4.png" border="0"></td>
    <td><img src="hacman/' + hacRoomL17.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/wall26.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall28.png" border="0"></td>
    <td><img src="hacman/' + hacRoomB18.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomC18.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomD18.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomE18.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomF18.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomG18.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomH18.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomI18.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomJ18.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomK18.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomL18.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomM18.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomN18.giveFilename() + '.png" border=\"0\"></td>
    <td><img src="hacman/' + hacRoomO18.giveFilename() + '.png" border=\"0\"></td>
  </tr>
  <tr>
    <td><img src="hacman/wall26.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
    <td><img src="hacman/wall46.png" border="0"></td>
  </tr>' +
  
  
  
  
  
  
 '<tr> 
    <td colspan="15"><img 
      src="hacman/nhv_spacer6.png" border="0"><img 
      src="hacman/nhc_sheilathe.png" border="0"><img 
      src="hacman/nhv_rank' + bot.experienceLevel + '.png" border="0"><img 
      src="hacman/nhv_spaces3.png" border="0"><img 
      src="hacman/nhc_align1.png" border="0"><img 
      src="hacman/nhv_spaces7.png" border="0"><img 
      src="hacman/nhv_spacer7.png" border="0"></td>
  </tr>
  <tr> 
    <td colspan="15"><img 
      src="hacman/nhv_spacer6.png" border="0"><img 
      src="hacman/nhc_score.png" border="0">' +
      giveNethackNumber(libScore.totalScore, 4, nil) + '<img 
      src="hacman/nhv_spaces1.png" border="0"><img 
      src="hacman/nhc_hp.png" border="0">' +
      giveNethackNumber(bot.hitPoints, 0, true) + '<img 
      src="hacman/nhc_paren1.png" border="0">' +
      giveNethackNumber(bot.maxHitPoints, 0, true) + '<img 
      src="hacman/nhc_paren2.png" border="0"><img 
      src="hacman/nhv_spaces' + (5 - toString(bot.hitPoints).length - toString(bot.maxHitPoints).length) + '.png" border="0"><img 
      src="hacman/nhc_st.png" border="0"><img 
      src="hacman/nhv_spaces1.png" border="0">' +
      giveNethackNumber(bot.isPowered && glob.poweringEffect ? 18 : bot.attributes[1], 2, true) + '<img 
      src="hacman/nhv_spaces1.png" border="0"><img 
      src="hacman/nhc_in.png" border="0"><img 
      src="hacman/nhv_spaces1.png" border="0">' +
      giveNethackNumber(bot.isPowered && glob.poweringEffect ? 18 : bot.attributes[4], 2, true) + '<img 
      src="hacman/nhv_spacer7.png" border="0"></td>
  </tr>
  <tr> 
    <td colspan="15"><img 
      src="hacman/nhv_spacer6.png" border="0"><img 
      src="hacman/nhc_turns.png" border="0">' +
      giveNethackNumber(bot.turnsDuringHac, 4, nil) + '<img 
      src="hacman/nhv_spaces1.png" border="0"><img 
      src="hacman/nhc_pw.png" border="0"><img 
      src="hacman/nhv_spaces3.png" border="0"><img 
      src="hacman/nhc_dx.png" border="0"><img 
      src="hacman/nhv_spaces1.png" border="0">' +
      giveNethackNumber(bot.isPowered && glob.poweringEffect ? 18 : bot.attributes[2], 2, true) + '<img 
      src="hacman/nhv_spaces1.png" border="0"><img 
      src="hacman/nhc_wi.png" border="0"><img 
      src="hacman/nhv_spaces1.png" border="0">' +
      giveNethackNumber(bot.isPowered && glob.poweringEffect ? 18 : bot.attributes[5], 2, true) + '<img 
      src="hacman/nhv_spacer7.png" border="0"></td>
  </tr>
  <tr> 
    <td colspan="15"><img 
      src="hacman/nhv_spacer6.png" border="0"><img 
      src="hacman/nhc_dlvl.png" border="0"><img 
      src="hacman/nhv_digit1.png" border="0"><img 
      src="hacman/nhv_spaces5.png" border="0"><img 
      src="hacman/nhc_ac.png" border="0">' + 
      giveNethackNumber(bot.armorClass, 3, nil) + '<img 
      src="hacman/nhv_spaces4.png" border="0"><img 
      src="hacman/nhc_co.png" border="0"><img 
      src="hacman/nhv_spaces1.png" border="0">' +
      giveNethackNumber(bot.isPowered && glob.poweringEffect ? 18 : bot.attributes[3], 2, true) + '<img 
      src="hacman/nhv_spaces1.png" border="0"><img 
      src="hacman/nhc_ch.png" border="0"><img 
      src="hacman/nhv_spaces1.png" border="0">' +
      giveNethackNumber(bot.isPowered && glob.poweringEffect ? 18 : bot.attributes[6], 2, true) + '<img 
      src="hacman/nhv_spacer7.png" border="0"></td>
  </tr>
  <tr> 
    <td colspan="15"><img 
      src="hacman/nhv_spacer6.png" border="0"><img 
      src="hacman/nhc_gold.png" border="0"><img 
      src="hacman/nhv_digit0.png" border="0"><img 
      src="hacman/nhv_spaces5.png" border="0"><img 
      src="hacman/nhc_xp.png" border="0">' +
      giveNethackNumber(bot.experienceLevel, 0, true) + '<img 
      src="hacman/nhc_slash.png" border="0">' +
      giveNethackNumber(bot.experiencePoints, toString(bot.experiencePoints).length, true) + '<img 
      src="hacman/nhv_spaces4.png" border="0"><img 
      src="hacman/nhv_hunger' + bot.hungerClass + '.png" border="0"><img 
      src="hacman/nhv_spaces5.png" border="0"><img 
      src="hacman/nhv_spacer7.png" border="0"></td>
  </tr>
</table>' + doCompass(wait);
/*
 '<tr> 
    <td colspan="15"><img src="hacman/nhv_blackdot.png" width="315" height="4" border="0"></td>
  </tr>
  <tr> 
    <td colspan="15"><img 
      src="hacman/nhv_spacer6.png" border="0"><img 
      src="hacman/nhc_sheilathe.png" border="0"><img 
      src="hacman/nhv_rank' + bot.experienceLevel + '.png" border="0"><img 
      src="hacman/nhv_spaces2.png" border="0"><img 
      src="hacman/nhc_lawful.png" border="0"><img 
      src="hacman/nhv_spaces2.png" border="0"><img 
      src="hacman/nhc_score.png" border="0">' +
      giveNethackNumber(libScore.totalScore, 4, true) + '<img 
      src="hacman/nhv_spacer5.png" border="0"></td>
  </tr>
  <tr> 
    <td colspan="15"><img 
      src="hacman/nhv_spacer6.png" border="0"><img 
      src="hacman/nhc_turns.png" border="0">' +
      giveNethackNumber(bot.turnsDuringHac, 4, true) + '<img 
      src="hacman/nhv_spaces3.png" border="0"><img 
      src="hacman/nhc_dlvl.png" border="0"><img 
      src="hacman/nhv_digit_.png" border="0"><img 
      src="hacman/nhv_digit_.png" border="0"><img 
      src="hacman/nhv_digit1.png" border="0"><img 
      src="hacman/nhv_spaces3.png" border="0"><img 
      src="hacman/nhc_st.png" border="0"><img 
      src="hacman/nhv_spaces1.png" border="0">' +
      giveNethackNumber(bot.isPowered ? 18 : bot.attributes[1], 2, true) + '<img 
      src="hacman/nhv_spaces2.png" border="0"><img 
      src="hacman/nhc_in.png" border="0"><img 
      src="hacman/nhv_spaces1.png" border="0">' +
      giveNethackNumber(bot.isPowered ? 18 : bot.attributes[4], 2, true) + '<img 
      src="hacman/nhv_spacer5.png" border="0"></td>
  </tr>
  <tr> 
    <td colspan="15"><img 
      src="hacman/nhv_spacer6.png" border="0"><img 
      src="hacman/nhc_hp.png" border="0">' +
      giveNethackNumber(bot.hitPoints, toString(bot.hitPoints).length, true) + '<img 
      src="hacman/nhc_paren1.png" border="0">' +
      giveNethackNumber(bot.maxHitPoints, toString(bot.maxHitPoints).length, true) + '<img 
      src="hacman/nhc_paren2.png" border="0"><img 
      src="hacman/nhv_spaces4.png" border="0"><img 
      src="hacman/nhc_pw.png" border="0"><img 
      src="hacman/nhv_spaces4.png" border="0"><img 
      src="hacman/nhc_dx.png" border="0"><img 
      src="hacman/nhv_spaces1.png" border="0">' +
      giveNethackNumber(bot.isPowered ? 18 : bot.attributes[2], 2, true) + '<img 
      src="hacman/nhv_spaces2.png" border="0"><img 
      src="hacman/nhc_wi.png" border="0"><img 
      src="hacman/nhv_spaces1.png" border="0">' +
      giveNethackNumber(bot.isPowered ? 18 : bot.attributes[5], 2, true) + '<img 
      src="hacman/nhv_spacer5.png" border="0"></td>
  </tr>
  <tr> 
    <td colspan="15"><img 
      src="hacman/nhv_spacer6.png" border="0"><img 
      src="hacman/nhc_ac.png" border="0">' + 
      (bot.armorClass < 0 ? '<img src="hacman/nhv_minus.png" border="0">' : '') +
      giveNethackNumber(bot.armorClass, 2, nil) + 
      (bot.armorClass < 0 ? '' : '<img src="hacman/nhv_digit_.png" border="0">') + '<img 
      src="hacman/nhv_spaces7.png" border="0"><img 
      src="hacman/nhc_xp.png" border="0">' +
      giveNethackNumber(bot.experienceLevel, toString(bot.experienceLevel).length, true) + '<img 
      src="hacman/nhc_slash.png" border="0">' +
      giveNethackNumber(bot.experiencePoints, toString(bot.experiencePoints).length, true) + '<img 
      src="hacman/nhv_spaces' + (7 - toString(bot.experienceLevel).length - toString(bot.experiencePoints).length) + '.png" border="0"><img 
      src="hacman/nhc_co.png" border="0"><img 
      src="hacman/nhv_spaces1.png" border="0">' +
      giveNethackNumber(bot.isPowered ? 18 : bot.attributes[3], 2, true) + '<img 
      src="hacman/nhv_spaces2.png" border="0"><img 
      src="hacman/nhc_ch.png" border="0"><img 
      src="hacman/nhv_spaces1.png" border="0">' +
      giveNethackNumber(bot.isPowered ? 18 : bot.attributes[6], 2, true) + '<img 
      src="hacman/nhv_spacer5.png" border="0"></td>
  </tr>
</table>';
*/
}

// -------------------------------------------------------------------
// HAC-MAN MAZE: MISC. STUFF NEEDED FOR MAP
// -------------------------------------------------------------------

giveNethackNumber(nm, dgts, rightJustify) {
  local max = 1;
  local str;
  local retStr = '';
  //local negative;
  //if (nm < 0) {
  //  negative = true;
  //  nm = 0 - nm;
  //}
  
  // If dgts <= 0, assume 
  if (dgts == nil)
    dgts = 0;
  if (dgts <= 0)
    dgts = toString(nm).length;
  // Make sure nm is not bigger than the maximum for the specified 
  // number of digits. I.e., if dgts = 4, nm must not be greater than 9999.
  // Note: This will not work for negative numbers. Fortunately,
  // it doesn't have to.
  else if (nm > 9) {
    // This loop is a crude way of calculating 10 to the (dgts) power.
    for (local a = 1; a <= dgts; a++) {
      max = max * 10;
    }
    max = max - 1;
    if (nm > max) nm = max;
  }
  // If dgts == 2 and rightJustify == true and nm is one of 
  // the special values, then treat this as a special case.
  if (dgts == 2 && rightJustify && ((nm >= 0 && nm <= 20) || nm == 25 || nm == 30))
    return '<img src="hacman/nhv_digits' + nm + '.png" border="0">';
  //if (dgts == 2 && !rightJustify && (nm >= 0 && nm <= 9))
  //  return '<img src="hacman/nhv_digits' + nm + '.png" border="0">';
    //else
    //  return '<img src="hacman/nhv_digit' + toString(nm).substr(1,1) + '.png" border="0">'
    //       + '<img src="hacman/nhv_digit' + toString(nm).substr(2,1) + '.png" border="0">';
  // The normal method of returning a string.
  // First, set str. E.g., if nm == 42 and dgts == 4, then str == '__42'.
  str = toString(nm);
  if (str.length < dgts) {
    if (rightJustify)
      str = underscores(dgts - str.length) + str;
    else
      str = str + underscores(dgts - str.length);
  }
  // add digits according to str.
  for (local a = 1; a <= str.length; a++) {
    retStr = retStr + '<img src="hacman/nhv_digit' + str.substr(a,1) + '.png" border="0">';
  }
  return retStr;
}

// A crude way of giving a string consisting of (nm) underscores.
underscores(nm) {
  switch (nm) {
    //case 0: return '';
    case 1: return '_';
    case 2: return '__';
    case 3: return '___';
    case 4: return '____';
    case 5: return '_____';
    case 6: return '______';
    case 7: return '_______';
    case 8: return '________';
    case 9: return '_________';
  }
  return '';
}

hacTurns() {
  //if (bot.turnsAtHacStartup < 0)
  //  bot.turnsAtHacStartup = libGlobal.totalTurns;
  return (libGlobal.totalTurns - bot.turnsAtHacStartup);
}






// -------------------------------------------------------------------
// JUNK
// -------------------------------------------------------------------

/*
dragon: Person, Daemon //Person, rather than UntakeableActor, is deliberate.
  location = bullpen
  daemonID = nil
  startDaemon {
    if (daemonID == nil) {
      moveInto(gPlayerChar);
      daemonID = new Daemon(self, &daemon, 1);
    }
    // Otherwise, if the daemon is already running, let it continue.
  }
  daemon {
    //"Chomp Daemon: ";
    //local devoured = 0, powered = 0;
    if (!gPlayerChar.location.ofKind(HacRoom)) {
      endDaemon();
      return;
    }
    chomp(gPlayerChar.location.hasDotType);
    if (glob.eenieMeenie == 12) {
      glob.eenieMeenie = 1;
      "<.p>glob.eenieMeenie = <<glob.eenieMeenie>>; ";
    }
    else {
      glob.eenieMeenie++;
      "<.p>glob.eenieMeenie = <<glob.eenieMeenie>>; ";
    }
    glob.hacCount++;
  }    
  endDaemon {
    if (daemonID != nil) daemonID.removeEvent;
    daemonID = nil;
    moveInto(nil);
  }
;
*/
/*
class BasicDot: Food
  dobjFor(Eat) {
    preCond = [] // no objheld precondition
  }
;

class Dot: BasicDot 'small little dot/pellet*dots*pellets' 'dot'
  isEquivalent = true
;
class BigDot: BasicDot 'big large power food dot/pellet*dots*pellets' 'big dot'
  isEquivalent = true
;

Dot location = hacRoomD2;
Dot location = hacRoomE2;
Dot location = hacRoomE2;
Dot location = hacRoomF2;
Dot location = hacRoomG2;
Dot location = hacRoomG2;
Dot location = hacRoomH2;
Dot location = hacRoomI2;
Dot location = hacRoomI2;
Dot location = hacRoomJ2;
Dot location = hacRoomK2;
Dot location = hacRoomK2;
Dot location = hacRoomL2;
Dot location = hacRoomM2;
Dot location = hacRoomM2;
//Dot location = hacRoomN2; //will be big dot there instead
Dot location = hacRoomD3;
Dot location = hacRoomD3;
Dot location = hacRoomJ3;
Dot location = hacRoomJ3;
Dot location = hacRoomN3;
Dot location = hacRoomN3;
Dot location = hacRoomD4;
Dot location = hacRoomE4;
Dot location = hacRoomE4;
Dot location = hacRoomF4;
Dot location = hacRoomH4;
Dot location = hacRoomI4;
Dot location = hacRoomI4;
Dot location = hacRoomJ4;
Dot location = hacRoomK4;
Dot location = hacRoomK4;
Dot location = hacRoomL4;
Dot location = hacRoomN4;
Dot location = hacRoomD5;
Dot location = hacRoomD5;
Dot location = hacRoomF5;
Dot location = hacRoomF5;
Dot location = hacRoomH5;
Dot location = hacRoomH5;
Dot location = hacRoomJ5;
Dot location = hacRoomJ5;
Dot location = hacRoomL5;
Dot location = hacRoomL5;
Dot location = hacRoomN5;
Dot location = hacRoomN5;
Dot location = hacRoomB6;
Dot location = hacRoomC6;
Dot location = hacRoomC6;
Dot location = hacRoomD6;
Dot location = hacRoomF6;
Dot location = hacRoomG6;
Dot location = hacRoomG6;
Dot location = hacRoomH6;
Dot location = hacRoomJ6;
Dot location = hacRoomL6;
Dot location = hacRoomM6;
Dot location = hacRoomM6;
Dot location = hacRoomN6;
Dot location = hacRoomB7;
Dot location = hacRoomB7;
Dot location = hacRoomN7;
Dot location = hacRoomN7;
Dot location = hacRoomB8;
Dot location = hacRoomN8;
Dot location = hacRoomB9;
Dot location = hacRoomB9;
Dot location = hacRoomN9;
Dot location = hacRoomN9;
Dot location = hacRoomB10;
Dot location = hacRoomN10;
Dot location = hacRoomB11;
Dot location = hacRoomB11;
Dot location = hacRoomN11;
Dot location = hacRoomN11;
Dot location = hacRoomB12;
Dot location = hacRoomN12;
Dot location = hacRoomB13;
Dot location = hacRoomB13;
Dot location = hacRoomN13;
Dot location = hacRoomN13;
Dot location = hacRoomB14;
Dot location = hacRoomC14;
Dot location = hacRoomC14;
Dot location = hacRoomD14;
Dot location = hacRoomF14;
Dot location = hacRoomH14;
Dot location = hacRoomI14;
Dot location = hacRoomI14;
Dot location = hacRoomJ14;
Dot location = hacRoomL14;
Dot location = hacRoomM14;
Dot location = hacRoomM14;
Dot location = hacRoomN14;
Dot location = hacRoomB15;
Dot location = hacRoomB15;
Dot location = hacRoomD15;
Dot location = hacRoomD15;
Dot location = hacRoomF15;
Dot location = hacRoomF15;
Dot location = hacRoomH15;
Dot location = hacRoomH15;
Dot location = hacRoomJ15;
Dot location = hacRoomJ15;
Dot location = hacRoomL15;
Dot location = hacRoomL15;
Dot location = hacRoomB16;
Dot location = hacRoomD16;
Dot location = hacRoomE16;
Dot location = hacRoomE16;
Dot location = hacRoomF16;
Dot location = hacRoomG16;
Dot location = hacRoomG16;
Dot location = hacRoomH16;
Dot location = hacRoomJ16;
Dot location = hacRoomK16;
Dot location = hacRoomK16;
Dot location = hacRoomL16;
Dot location = hacRoomB17;
Dot location = hacRoomB17;
Dot location = hacRoomF17;
Dot location = hacRoomF17;
Dot location = hacRoomL17;
Dot location = hacRoomL17;
//Dot location = hacRoomB18; //will be big dot there instead
Dot location = hacRoomC18;
Dot location = hacRoomC18;
Dot location = hacRoomD18;
Dot location = hacRoomE18;
Dot location = hacRoomE18;
Dot location = hacRoomF18;
Dot location = hacRoomG18;
Dot location = hacRoomG18;
Dot location = hacRoomH18;
Dot location = hacRoomI18;
Dot location = hacRoomI18;
Dot location = hacRoomJ18;
Dot location = hacRoomK18;
Dot location = hacRoomK18;
Dot location = hacRoomL18;

BigDot location = hacRoomN2;
BigDot location = hacRoomB18;
*/

/*
duckie: Thing 'duckie' 'duckie' @westHallway;

westHallway: Room 
  roomName = 'Hallway'
  name = 'hallway'
  desc = "This is the west end of the hallway. "
  east = middleHallway
;
middleHallway: Room
  roomName = 'Hallway'
  name = 'hallway'
  desc = "This is the middle of the hallway. "
  west = westHallway
  east = eastHallway
;
eastHallway: Room
  roomName = 'Hallway'
  name = 'hal\u6Cway'
  desc = "This is the east end of the hallway. "
  west = middleHallway
;
*/

/*
class MiddleHallwayRoom: Room 'Hallway'
  "This is a very long hallway that extends to the east and west."
;

westHallway: Room 'Dead end'
  "This is the west end of the hallway. You can go back east. "
  east = middleHallway1
;
middleHallway1: Room 'Hallway'
  west = westHallway
  east = middleHallway2
;
middleHallway2: Room 'Hallway'
  west = middleHallway1
  east = middleHallway3
;
middleHallway3: Room 'Hallway'
  west = middleHallway2
  east = eastHallway
;
eastHallway: Room 'Dead end'
  "This is a dead end of the hallway. You can go back west. "
  west = middleHallway3
;
*/


#ifdef __DEBUG

DefineTAction(Annihilate)
  // We want all objects to be in scope, so we always return true
  // here.
  objInScope(obj) { return true; }
;

VerbRule(Annihilate)
  'annihilate' singleDobj
  : AnnihilateAction
  verbPhrase = 'annihilate/annihilating (what)'
;

modify Thing
  dobjFor(Annihilate) {
    verify() {
      illogical('{You/he} do{es}n\'t know how to annihilate 
                {that dobj/him}. ');
    }
  }
;

modify HacEnemy
  dobjFor(Annihilate) {
    verify { }
    //preCond = [objVisible]
    action {
      local prevDiff = bot.meleeDifficulty;
      bot.meleeDifficulty = 100000;
      bot.startMelee(self);
      bot.meleeDifficulty = prevDiff;
    }
  }
;

#endif // __DEBUG



