/* Copyright (c) 1993, 2002 by Michael J. Roberts.  All Rights Reserved. */
/*

                         Perdition's Flames

		      TADS Interactive Fiction
		       by Michael J. Roberts


    This is Perdition's Flames, a TADS game.  The source for this
    game can be freely distributed subject to the license restrictions,
    but cannot be distributed in modified form - see README.PFS (which
    should have been included with the distribution you received) for
    license details.

--------
Version 1.01

    - "pry mirror" is now responsive (in the bathroom of the house,
      hellsub.t)

    - The airplane's description now calls attention to the fact that you
      can enter the plane.  Many people never bothered getting in, so they
      never saw some information in the airplane's interior description.
      (helleast.t)
*/

#include <helladv.t>          // slightly modified adv.t
#include <hellstd.t>          // verbs, init, classes, adv.t extensions
#include <gameinfo.t>         // game information utilities

#include <hellboat.t>         // boat ride into hell
#include <hellciv.t>          // civic center
#include <hellsub.t>          // suburban hell
#include <helldt.t>           // downtown hell
#include <helleast.t>         // eastern hell
#include <hellghos.t>         // haunted house section
#include <helldes.t>          // desolate plains, wastelands, fire cave
#include <hellinst.t>         // instructions commands
#include <hellheav.t>         // heaven


// source distribution/testing version: dummy copy protection function
introQuestion: function
{
    global.copyOK := true;
}

// card catalog information
getGameInfo: function
{
    return
        ['Name', 'Perdition\'s Flames',
        'Byline', 'by Michael J. Roberts',
        'Desc', 'The afterlife isn\'t what you expected.  Explore a
                strangely modernized and bureaucratic underworld,
                replete with strip malls, government offices, and
                science labs, as well as the occasional lake of
                molten rock.  A classic text adventure, with a
                sprawling setting and numerous puzzles, but without
                any way to die (after all, you\'re already dead) or
                get stuck.',
        'Version', version.vsnnum,
        'ReleaseDate', '2001-12-23',
        'LicenseType', 'Freeware',
        'CopyingRules', 'Nominal Cost Only'];
}
