/*
**  Arrival, or Attack of the B-Movie Cliches
**  Copyright (c) 1998 by Stephen Granade.  All Rights Reserved.
**
**  Developed using TADS: The Text Adventure Development System
**
**  Programming Begun: 15 Mar 98
**
*/

/*
** You'll notice that this file is, well, tiny. I like to break my game up
** into separate files in order to keep things reasonably organized. If your
** game is short, this isn't all that necessary. If your game is more than
** about five rooms, though, I've found that having separate modules is the
** only way to keep track of what's going on.
**
** Some people like to put all the objects in one file, all the rooms in
** another, etc. I, however, like to break the game up into sections and
** put all of the rooms and objects for that section in one file. I'll
** make an exception for complex things like Actors other than the player,
** and put them in their own file.
*/

// Since this is an HTML TADS game, let's use the HTML status line
#define USE_HTML_STATUS

#include        <adv.t>         // Standard stuff
#include        "arr_adv.t"     // Wacky stuff
#include        "menus.t"       // Menus
#include        "compass.t"     // Compass rose banner
#include        "arr_std.t"     // Nonstandard stuff
#include        "arr_h.t"       // New verbs, etc.

#include        "arr_ban.t"     // The banner code
#include        "arr_home.t"    // The house
#include        "arr_ship.t"    // The ship
#include        "arr_npcs.t"    // All NPCs in the game
#include        "arr_fake.t"    // Fake stuff
#include        "arr_hint.t"    // The hints
#include        "arr_note.t"    // My author's note

// Here's my suite of debugging verbs.

#pragma C+
/*
// Gimme that object!
gimmeVerb: sysverb
  verb = 'gimme'
  sdesc = "gimme"
  doAction = 'Gimme'
  validDo(actor, obj, seqno) = {
    if (obj.noGimme) return nil;
    return true;
  }
  validDoList(actor, prep, dobj) = nil
;

// Where'd I leave that object?
whereVerb: sysverb
  verb = 'where' 'whereis'
  sdesc = "where"
  doAction = 'Where'
  validDo(actor, obj, seqno) = {
    if (obj.noWhere) return nil;
    return true;
  }
  validDoList(actor, prep, dobj) = nil
;

// Teleport to an object
bamfVerb : sysverb
  verb = 'bamf'
  sdesc = "bamf"
  doAction = 'Bamf'
  validDo(actor, obj, seqno) = {
    if (obj == nil || obj.noBamf)
      return nil;
    return true;
  }
  validDoList(actor, prep, dobj) = nil;
;

modify thing
  verDoGimme(actor) = {
    if (isclass(self, floatingItem))
      "Not a good idea--<<self.thedesc>> is a floating item.  ";
  }
  doGimme(actor) = {
    self.moveInto(actor);
    "Poof! \^<<self.thedesc>> appears.";
  }
  verDoBamf(actor) = {
    if (self.location == nil and (!isclass(self, room)))
      "\^<<self.thedesc>> is nowhere--you can't go there!  ";
    else if (isclass(self, floatingItem))
      "\^<<self.thedesc>> is a floating item, so you can't bamf to it.  ";
  }
  doBamf( actor ) = {
    local loc;

    loc = self;
    while (loc and (!isclass(loc, room)))
      loc = loc.location;
    if (loc) {
      "Bamf!\b";
      Me.travelTo(loc);
    }
    else "Bamf failed.  ";
  }
  verDoWhere(actor) = {}
  doWhere(actor) = {
    "\^<<self.thedesc>> is ";
    if (self.location == nil)
      "nowhere. ";
    else
      "in <<self.location.sdesc>>.  ";
  }
;

modify fixeditem
  doGimme(actor) = {
    self.moveInto(actor.location);
    "Poof! \^<<self.thedesc>> appears.";
    if (!self.isactor) self.isListed = true;
  }
;
*/
