/*
** Arr_ban.t contains code to handle the small map banner
**
** Copyright (c) 1998, Stephen Granade. All rights reserved.
*/

#pragma C+

// The banner itself
map_banner: object
    // Here's the deal: UNDO doesn't undo any HTML formatting, including
    // banner printing. Since I don't like that, I'm going to hack UNDO to
    // turn the banner off/on when bannerTurnedOn/Off is true.
    // bannerTurnedOn/Off is true if the banner was turned on/off last turn.
    bannerTurnedOn = nil
    bannerTurnedOff = nil
    
    bannerOn = nil              // True if the banner is on

    // These next two routines are called by a daemon, and are used to clear
    // the state flags bannerTurnedOn/Off.
    clearOnFlag = { self.bannerTurnedOn = nil; }
    clearOffFlag = { self.bannerTurnedOff = nil; }

    displayBanner = {
        "<BANNER id=LittleMap width=134 align=left border>";
        // Notice that I define the image map for the little map *inside* the
        // banner. This is necessary, as image map names are local to whatever
        // window/banner they are defined in.
        "<MAP NAME=\"littlemapmap\">
<AREA SHAPE=\"RECT\" COORDS=\"53, 88, 70, 135\" HREF=\"goto ramp\">
<AREA SHAPE=\"RECT\" COORDS=\"86, 33, 113, 86\" HREF=\"goto slumber chamber\">
<AREA SHAPE=\"RECT\" COORDS=\"70, 84, 105, 115\" HREF=\"goto hold\">
<AREA SHAPE=\"RECT\" COORDS=\"17, 85, 52, 116\" HREF=\"goto exam room\">
<AREA SHAPE=\"RECT\" COORDS=\"9, 34, 34, 86\" HREF=\"goto rec room\">
<AREA SHAPE=\"RECT\" COORDS=\"30, 8, 96, 36\" HREF=\"goto bridge\">
</MAP>";
        "<table width=100% height=100%>
            <tr><td valign=\"middle\">";
        "<IMG SRC=\"resources/little map.jpg\" Width=\"120\"
            height=\"142\" Alt=\"Little map of the ship\"
            USEMAP=\"#littlemapmap\">
        <center><<link('Remove Map', 'display map')>></center>";
        "</td></tr></table>";
        "</BANNER>";
        self.bannerOn = true;
    }
    hideBanner = {
        "<BANNER ID=LittleMap REMOVE>";
        self.bannerOn = nil;
    }
    // handleBanner either hides or displays the banner, depending on the
    // current setting of the bannerOn variable (defined above)
    handleBanner = {
        if (self.bannerOn)
            self.displayBanner;
        else self.hideBanner;
    }
    toggleBanner = {
        if (self.bannerOn)
            self.turnOffBanner;
        else self.turnOnBanner;
    }
    turnOnBanner = {
        self.displayBanner;
        self.bannerTurnedOn = true;
        notify(self, &clearOnFlag, 2);
    }
    turnOffBanner = {
        self.hideBanner;
        self.bannerTurnedOff = true;
        notify(self, &clearOffFlag, 2);
    }
;

// mainRestore must be modified to handle the banner
// [N.B. This code is ripped from adv.t]
replace mainRestore: function(fname)
{
    /* try restoring the game */
    if (restore(fname)) {
        /* an error occurred - tell the player */
        "Restore failed. ";
        return nil;
    }
    else {
        /* update the status line */
        scoreStatus(global.score, global.turnsofar);

        /* tell the user we succeeded, and show the location */
        "Restored.\b";
        parserGetMe().location.lookAround(true);

	    /* If the banner's on, print it. Otherwise, hide it. */
	    map_banner.handleBanner;

        /* success */
        return true;
    }
}

// I'm modifying 'undo' so that it turns the banner on/off properly
modify undoVerb
    undoMove(actor) = {
        /* Take care of the banner, if necessary */
        if (map_banner.bannerTurnedOn)
            map_banner.hideBanner;
        else if (map_banner.bannerTurnedOff)
            map_banner.displayBanner;
        /* do TWO undo's - one for this 'undo', one for previous command */
        if (undo() && undo()) {
            "(Undoing one command)\b";
            parserGetMe().location.lookAround(true);
            scoreStatus(global.score, global.turnsofar);
        }
        else
            "No more undo information is available. ";
    }
;

compass: compassItem
    verDoDisplay(actor) = {}
    doDisplay(actor) = {
        self.ison = !self.ison;
        "The compass rose is now <<self.ison ? "on" : "off">>. You may
            turn it back <<self.ison ? "off" : "on">> with the command
            <b>DISPLAY COMPASS</b>. ";
        abort;
    }
;

