#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>


connectorIntoArcade : ArcadeRoomSet,OneWayRoomConnector
	-> arcade
	noteTraversal(traveler) {
		if(traveler==gPlayerChar) {
			gPlayerChar.posture = standing;
			gPlayerChar.returnPath = nil;
		}
	}
;

connectorIntoArcadeBasement : ArcadeRoomSet,OneWayRoomConnector
	-> arcadeBasement
	noteTraversal(traveler) {
		if(traveler==gPlayerChar) {
			gPlayerChar.posture = standing;
			gPlayerChar.returnPath = nil;
		}
	}
;


class ArcadeRoomSet : RoomInSet
	roomSetId = 'ArcadeRoomSet'
	
	notifyBeforeArriving() {
		if(arcadeLightning.daemon==nil) {
			arcadeLightning.reset();
			arcadeLightning.daemon = new Daemon(arcadeLightning, &doStuff, 1);
		}
	}
	
	notifyBeforeLeaving() {
		if(arcadeLightning.daemon!=nil) {
			arcadeLightning.daemon.removeEvent();
			arcadeLightning.daemon = nil;
		}
	}
;

arcadeSoundSenseConnector : SenseConnector, Intangible
	transSensingThru(sense) {
		if(sense==sound)
			return distant;
		else
			return opaque;
//			return distant;
	} 
	
	initialLocationClass = ArcadeRoomSet
;



twentyDollarBill : Thing 'twenty dollar bill/money' 'twenty dollar bill'
	@me
	"This is a twenty dollar bill. "
;



ballRoom : ArcadeRoomSet,Room 'ball room' 'ball room'
	// This calls notifyBeforeArriving() to ensure that, when we initially start in this
	// room, that this room is properly set up.
	"This is one of those rooms that is filled with countless small multicolored balls that kids
	can play in. You've heard that some kids think that playing in a <q>sea</q> of balls is sort
	of like being in a pool... and they act accordingly. But, the room smells fine, so it looks
	like you're safe. The main room of the arcade lies to the west. <<notifyBeforeArriving>>"
//	in = balls
//	down = balls
	west = arcade
	
	vocabWords = 'ball room'
	
//	roomParts = [balls, defaultCeiling,
//		defaultNorthWall, defaultSouthWall,
//		defaultEastWall, defaultWestWall]	
//	roomParts = static inherited - defaultFloor + balls
	roomParts = static inherited - defaultFloor
;
//+ ballFloor : Floor 'floor' 'floor'
//	"There are a whole bunch of multicolored balls here. "
//;
//+ balls : ArcadeRoomSet, Booth, Fixture, Container 'multicolored ball*balls' 'balls'
//+ balls : /*Floor, */ArcadeRoomSet, Container, Booth 'multicolored red blue green ball/floor/ground*balls' 'balls'
+ balls : ArcadeRoomSet, RoomAutoConnector, Booth 'multicolored red blue green ball/floor/ground*balls' 'balls'
	"The balls are numerous in quantity and solid colored in cheerful hues of red, blue and green. "
	
	isPlural = true
	isListed = nil

	west = arcade
	out asExit(west)
	
	down = nil
	
	dobjFor(Take) {
		verify() {}
		check() {}
		action() {
			"You really don't need any of the balls, but you take one of the multicolored balls anyway. ";

			local theBallType = rand(Ball.ballTypes);
			
//			local tokenList = gAction.getTopicTokens();
//			local tokenList = gAction.getTopicWords();			
			local tokenList = gAction.getOrigTokenList();
			
			foreach(local wordToken in tokenList) {
				if(wordToken[1].toLower()=='red') {
					theBallType = RedBall;
					break;
				} else if(wordToken[1].toLower()=='blue') {
					theBallType = BlueBall;
					break;
				} else if(wordToken[1].toLower()=='green') {
					theBallType = GreenBall;
					break;
				}
			}

			local newBall = theBallType.createInstance();

			newBall.moveInto(gPlayerChar);
		}
	}
		
	dobjFor(GetOutOf) {
		verify() {}
		check() {}
		action() {
			inherited;
			nestedAction(TravelVia,west);
//			inherited;
//			gPlayerChar.moveIntoForTravel(ballRoom.west);
		}
	}
	
	iobjFor(PutOn) asIobjFor(PutIn)
		
/*	
	dobjFor(Take) {
		verify() {
			"You really shouldn't  ";
			exit;
		}
	}
*/
	
	dobjFor(Play) {
		verify() {
			logicalRank(120, 'play with balls');
		}
		check() {}
		action() {
			"You swim around in the balls for a bit. You toss them against the wall and
			push your arms through them. It's fun for a while, but eventually you tire of
			it. You can't win at playing with the balls, so the total enjoyment that you can
			get from playing with them is going to be fairly limited. ";
		}
	}
	
	dobjFor(SwimIn) {
		verify() {
			logicalRank(120, 'swim in balls');
		}
		check() {}
		action() {
			"You attempt to doggy paddle through the balls, but despite your best efforts,
			you are unable to get much of a cardiovascular workout by doing laps in here. ";
		}
	}
;

class BallGroup : ItemizingCollectiveGroup
    construct(ballColor) {
		self.ballColor = ballColor;
		
		name=ballColor +' balls';
		initializeVocabWith( ballColor +' smooth plastic ball*balls' );
		inherited();
	}
	
	isPlural = true
	
	desc {
//		if(gPlayerChar.isIn(ballRoom))
//			"The ball{s} you are holding {is} a colored smooth plastic ball. ";
//			"The balls you are holding is a colored smooth plastic ball. ";
			"All of the <<ballColor>> balls are plain, smooth, and made of plastic. ";
//		else
//			"These are multicolored balls. ";
	}
	
//    hideFromAll(action)
//    {
//        return gPlayerChar.isIn(ballRoom);
//    }
	
	ballColor = nil
;


class Ball : Thing
	ballTypes = [BlueBall,RedBall,GreenBall]
//	ballColors = ['blue','red','green']
	
	isEquivalent = true
//	collectiveGroup = nil

    construct() {
//		local ballColor = ballColors[rand(ballColors.length)+1];
//		"\nNEW <<ballColor>>\n";
//		self.ballColor = ballColor;
				
		name=ballColor +' ball';
		initializeVocabWith( ballColor +' plain smooth plastic ball*balls' );
		inherited();
	}
		
	desc = "This is a plain smooth <<ballColor>> plastic ball. "
//	happyBlop = 'SMOOSH'
//	desc = "This is a simple smooth plastic ball. "

	dobjFor(Drop) {
		verify() {}
		check() {}
		action() {
			inherited();
			if(isIn(ballRoom))
				self.moveInto(nil);
		}
	}
	
	dobjFor(PutIn) {
		verify() {}
		check() {}
		action() {
			if(gIobj==balls || gIobj==ballRoom)
				self.moveInto(nil);
			else
				inherited();
		}
	}
	

	dobjFor(ThrowAt) {
		verify() {}
//		preCond = [objHeld]
		check() {}
//		action() {

//			if(gPlayerChar.isIn(duckHuntField) && [duckhuntWater,theReeds].indexOf(gDobj)!=nil) {
//				"The ball flies out onto the water and lands well short of the reeds.
//				In moments it floats away. ";
//				self.moveInto(nil);
//			} else {
//				inherited;
//			}
//			exit;			
//		}
	}
	
	ballColor = nil
;

blueBallGroup : BallGroup  construct() {inherited('blue');}  ;
redBallGroup : BallGroup  construct() {inherited('red');}  ;
greenBallGroup : BallGroup  construct() {inherited('green');}  ;

class BlueBall : Ball
	ballColor = 'blue'
	collectiveGroup = blueBallGroup
	construct() {inherited();}
;
class RedBall : Ball
	ballColor = 'red'
	collectiveGroup = redBallGroup
	construct() {inherited();}
;
class GreenBall : Ball
	ballColor = 'green'
	collectiveGroup = greenBallGroup
	construct() {inherited();}
;


arcadeFront : ArcadeRoomSet,Room 'arcade front' 'arcade front'
	"This is the front room of the arcade. The main arcade is to the east and
	the front door leading outside is to the west. Next to the door are windows that
	look outside into the rainy darkness. There is a sign hanging from the ceiling
	near the door. "
	east = arcade
	west = arcadeFrontDoor
;
+ arcadeFrontDoor : Fixture,FakeConnector '(arcade) front door' 'door'
	"The arcade's front door is a typical solid wooden door. "
	travelDesc = 
		"Are you kidding? It's practically a hurricane out there!
		In any case, you've got the arcade nearly all to yourself. It would be nuts to
		leave now! "
	openDesc = travelDesc
	cannotMoveThroughMsg = travelDesc
	initiallyOpen = nil
	isOpen = nil
	
	dobjFor(Open) {
		verify() {}
		check() {}
		action() {
			travelDesc;
		}
	}
	dobjFor(Close) {
		verify() {}
		check() {}
		action() {
			"The door is already closed. ";
		}
	}
	
	// This is here so that the player can ask about it before seeing it.
	isKnown = true
;
+ Fixture 'rain rainy darkness nasty storm parking lot tree window*windows*trees' 'windows'
	desc {
		if(arcadeLightning.canSeeBecauseOfLightning()) {
			"It looks like it's raining pretty hard out there.
			During the moment that the lightning lit things up, you were able to see
			the parking lot outside. On a typical day the lot is often filled up with cars and
			bicycles, but tonight it is completely empty.<.p>
			
			The wind is blowing so hard that the trees that run alongside the edge of the lot are
			practically bent over at 90 degree angles. It's a good thing you walked here. Your bike
			wouldn't have appreciated being left out in a storm like this. ";
		} else {
			"You can see the rain blattering against the windows, but unfortunately it's pitch
			dark out there, so you can't see anything else.
			It sure sounds like a nasty storm though. ";
		}
	}
	
	dobjFor(LookThrough) asDobjFor(Examine)

	dobjFor(Open) {
		verify() {}
		check() {}
		action() {
			"The windows are fixed windows that do not open or close. ";
		}
	}
	dobjFor(Close) {
		verify() {}
		check() {}
		action() {
			"The windows are fixed windows that do not open or close. ";
		}
	}
;
+ SimpleNoise 'nasty storm' 'nasty storm'
	"It sounds like it's practically a hurricane outside! "
;
+ Fixture,Readable 'hanging sign' 'sign'
	"The sign says, <q>Welcome to the Total Reality Arcade!</q>"
;

/*
+ desk: Immovable, Surface
    'massive big huge edifice drab gray grey steel metal desk' 'desk'
    desc
    {
        "It's a big desk with a single drawer (currently
        <<deskDrawer.openDesc>>).  A small button is set inconspicuously
        into the edge of the desktop";
        if (hiddenPanel.isOpen)
            ", and in the side is a small compartment containing a lever";
        ". ";
    }

    dobjFor(Open) remapTo(Open, deskDrawer)
    dobjFor(Close) remapTo(Close, deskDrawer)
    dobjFor(LookIn) remapTo(LookIn, deskDrawer)
    iobjFor(PutIn) remapTo(PutIn, DirectObject, deskDrawer)
;
*/

arcadeContentsLister : ParagraphLister
    showListPrefixWide(itemCount, pov, parent) { "<.p>{You/he} see{s} "; }
	
    // we show no list separators
    showListSeparator(options, curItemNum, totalItems)
    {
        // add a paragraph separator between items
		"\n";
    }
;

emptyLister : ParagraphLister
    showListPrefixWide(itemCount, pov, parent) {}
    showListSeparator(options, curItemNum, totalItems) {}
;



arcade : ArcadeRoomSet,Room 'arcade'
	desc {
		"This is a video arcade. Video game machines line the walls and
		a money changer occupies the center of the arcade. Strangely,
		some of the machines aren't labelled at all.
		The ball room is in the back of the arcade to the east and the
		front room of the arcade is to the west. There is also a door in the north wall. ";
	}
	west = arcadeFront
	east : TravelMessage {
//			-> ballRoom
			-> balls
			"You enter the ball room and wade into the balls. "
			
/*			
			dobjFor(TravelVia) {
				verify() {}
				check() {}
				action() {
					gPlayerChar.moveIntoForTravel(ballRoom);
					gPlayerChar.moveIntoForTravel(balls);
					
					inherited;
					
					gPlayerChar.moveIntoForTravel(balls);
				}
			}
*/			
			
/*			
			noteTraversal(traveler) {
				inherited(traveler);
				if(traveler==gPlayerChar) {
//					gPlayerChar.posture = standing;
"Going into balls. ";
//					gPlayerChar.moveIntoForTravel(ballRoom);
//					gPlayerChar.moveIntoForTravel(balls);
					nestedAction(Enter,balls);
				}
			}
*/			
		}
/*	east : ArcadeRoomSet, TravelWithMessage, TravelConnector {
		canTravelerPass(traveler) {return true;}
		destination=ballRoom
		room1 = arcade
		room2 = ballRoom
		travelDesc="You enter the ball room. "
		}
*/		
	north = arcadeDoorToStairs
	
	vocabWords = 'Total Reality (video) building/arcade'
	
	roomContentsLister = arcadeContentsLister
	
	roomParts = [scuffedFloorAroundMoneyChanger, defaultCeiling,
		defaultNorthWall, defaultSouthWall,
		defaultEastWall, defaultWestWall]	
;
+ arcadeDoorToStairs : LockableWithKey,Door ->arcadeDoorFromStairs '(arcade) door' 'arcade door'
	"It's an extremely solidly built door. "
	keyList = [arcadeMiddleDoorKey]
	initiallyLocked = true
	isKnown = true
;
+ arcadeHumming : SimpleNoise 'humming/machines' 'humming'
	"All the machines in the room hum with life. "
	soundPresence {return powerSwitch.isOn;}
;
/*
+ machines : Heavy 'video game videogame machine*machines' 'video game machines'
	"There are video games lining the walls of the arcade. "
	isPlural = true
	
	dobjFor(Play) {
		verify() {}
		check() {}
		action() {
			"If you want to play a game then you need to be more specific about which game you want to play. ";
		}
	}
;
*/

//: Have door unlock automatically if you have the keys and you try to go north.
arcadeKeyring : Keyring 'tin (key) keyring/ring*keys' 'tin keyring'
	@player2
	"The keyring is the sort of thing that just screams out <q>You must have me!</q>. "
;
+ arcadeMiddleDoorKey : Key 'brass key' 'brass key'
	"It's a pretty nice brass key. ";
+ arcadeBasementKey : Key 'gold golden key' 'gold key'
	"It's just your everyday golden key that probably leads to wild treasures unknown. Or, maybe
	it's just a key to a door in the arcade. ";

panel : OpenableContainer, Hidden, Fixture 'panel' 'panel' @arcade
	specialDesc {
		if(isOpen) {
			"There is a panel in the floor next to the money changer.  It has a big red switch inside. ";
		} else {
			"There is a panel in the floor next to the money changer. ";
		}
	}
	desc = specialDesc
	
	dobjFor(Open) {
		action() {
			inherited;
			"The panel opens to reveal a big red switch. ";
		}
	}
;

powerSwitch : Switch, Fixture '(big) (red) power switch' 'power switch' @panel
	"This is a big red switch. It is labelled <q>Power</q>."

	makeOn(val) {
		inherited(val);
		
		if(powerSwitch.isOn) {
			"All the machines in the room power on. The room is now filled with a steady humming. ";
			achieve.awardPointsOnce();
			wasTurnedOnAtLeastOnce = true;
		} else {
			"All the machines shut down. The room is suddenly silent. ";
		}
	}
	
	dobjFor(Push) asDobjFor(Flip)
	dobjFor(Pull) asDobjFor(Flip)
	dobjFor(Attack) asDobjFor(Flip)
	dobjFor(Turn) asDobjFor(Flip)
    
	achieve : Achievement {+1 "powering on arcade";}
	
	wasTurnedOnAtLeastOnce = nil
;


arcadeRoof : ArcadeRoomSet,Room 'arcade roof'
	desc {
		"The storm is horrible! The wind is so strong that you can barely remain standing.
		The rain pounds on you hard enough that it actually hurts.
		You should probably not stay up here too long. ";
		
		if(arcadeLightning.canSeeBecauseOfLightning()) {
			"The lightning allows you to the rest of the roof and the area around it.
			The parking lot below is deserted. The wind is blowing so hard that the trees
			that run alongside the edge of the lot are practically bent over at 90 degree angles.
			The roof extends to the east and west and the door to the stairwell is to the north. ";
		} else {
			if(arcadeRoofDoorToStairs.isOpen) {
				"It's nearly pitch dark out here. The light from the stairs allows you to see
				the doorway to the north, but that's pretty much all you can see. ";
			} else {
				"It's pitch dark! You can't see anything at all! ";
			}
		}
	}
	
	roomDarkDesc = desc
	
	brightness {
		if(arcadeLightning.canSeeBecauseOfLightning())
			return 3;
		else if(arcadeRoofDoorToStairs.isOpen)
			return 2;
		else
			return 0;
	}

	
	north = arcadeRoofDoorToStairs
	east : FakeConnector {"Are you nuts? If you go out there you'll probably be blown off the roof! ";}
	west : FakeConnector {"Are you nuts? If you go out there you'll probably be blown off the roof! ";}
;
+ arcadeRoofDoorToStairs : Door ->arcadeRoofDoorFromStairs 'roof door' 'roof door'
	"<<arcadeDoorToStairs.desc>>"
;
/*
+ arcadeRoofShallowHole : Container,Fixture 'shallow metal hole' 'shallow hole'
	"It's a shallow metal hole on the edge of the roof.
	Perhaps someone likes to practice their putting on the roof? "
	
	iobjFor(PutIn) {
		verify() {
			if(gDobj!=nil && gDobj!=flagpole) {
				"This hole clearly has a special purpose (people don't build metal holes into
				roofs unless there's a special purpose for them). So, you really shouldn't
				put just anything in there. ";
			}
		}
		
		action() {
			"You stand the flagpole in the hole. ";
			
			if(isFirstTimeStandingFlagpole) {
				"\b
				You know, if you were to contact your local veteran's society, they would
				probably tell you that putting up a flagpole during a thunderstorm is not
				one of the wisest things that a person could do... Then again, what do they
				know? Just because they walked naked for ten miles through twenty feet
				of snow up hill both ways in order to get to and from school every day, that
				doesn't qualify them to tell you when you should and should not put up
				flagpoles! Perhaps thunderstorms are the best times to put up flagpoles!
				Have they ever actually tried it? Pfft. Screw them and their wimpy stance
				on flagpole standing times! ";
				isFirstTimeStandingFlagpole = nil;
			}
		}
	}
	
	isFirstTimeStandingFlagpole = true
;
*/

arcadeStairwellByRoof : ArcadeRoomSet,Room 'arcade stairwell top'
	"This is the top of the stairwell. There is a door to the south with a sign on it. "
	south = arcadeRoofDoorFromStairs
	down = arcadeStairsRoofToMiddle
;
+ Readable, Fixture 'sign' 'sign'
	"<center>Roof\bEmployees only!</center> "
;
+ arcadeRoofDoorFromStairs : Door 'door' 'door'
	"<<arcadeDoorToStairs.desc>>"
	isKnown = true
;
+ arcadeStairsRoofToMiddle : StairwayDown 'stairwell stairway stairs down' 'stairway'
	"The stairs lead down. "
;

arcadeStairwellMiddle : ArcadeRoomSet,Room 'arcade stairwell top'
//	"Stairs lead up and down. A door to the south leads back to the arcade. "
	"Stairs lead down and a door to the south leads back to the arcade. "
	south = arcadeDoorFromStairs
//	up = arcadeStairsMiddleToRoof
	down = arcadeStairsMiddleToBasement
;
+ arcadeDoorFromStairs : Lockable,Door 'door' 'door'
	"<<arcadeDoorToStairs.desc>>"
;
//+ arcadeStairsMiddleToRoof : StairwayUp ->arcadeStairsRoofToMiddle 'stairwell stairway stairs up' 'stairway up'
//	"The stairs lead up. "
//;
+ arcadeStairsMiddleToBasement : StairwayDown 'stairwell stairway stairs down' 'stairway'
	"The stairs lead down. "
;


arcadeStairwellBottom : ArcadeRoomSet,Room 'arcade stairwell bottom'
	"This is the bottom of the stairwell. A wide stairway leads up and the basement door is to the south. "
	south = arcadeBasementDoorFromStairs
	up = arcadeStairsBasementToMiddle
;
+ arcadeStairsBasementToMiddle : StairwayUp ->arcadeStairsMiddleToBasement 'stairwell stairway stairs up' 'stairway up'
	"The stairs lead up. "
;
+ arcadeBasementDoorFromStairs : LockableWithKey,Door ->arcadeBasementDoorToStairs 'basement door' 'basement door'
	"<<arcadeDoorToStairs.desc>>"
	keyList = [arcadeBasementKey]
	initiallyLocked = true
	isKnown = true
;

arcadeBasement : ArcadeRoomSet,Room 'basement'
	"This is a small storage room beneath the arcade. The walls are mostly unadorned except
	for a large poster.
	To the north is the door that leads back to the stairwell.
	"
	north = arcadeBasementDoorToStairs
	
//	roomContentsLister = arcadeContentsLister
;
+ arcadeBasementDoorToStairs : Lockable,Door 'basement door' 'basement door'
	"<<arcadeDoorToStairs.desc>>"
;
+ msPacmanPoster : CustomImmovable 'naughty large pinup Ms Pac-Man/pacman poster' 'Ms. Pac-Man poster'
	"It is a very naughty pinup poster of Ms&#46; Pac-Man. She is pouting her lips
	and has her hand positioned to pull her red bow undone. "
	
	cannotTakeMsg = 'Eric would be upset if you took that poster down. It should be quite obvious why... '
;
++ Decoration 'red bow' 'red bow'
	"It's almost undone! She looks so naughty! "
;
++ Decoration 'hand*hands*lips' 'hand'
	"So naughty! "
;

arcadeLightning : object
	daemon = nil
	
	doStuff() {
		if(turnsUntilThunder==1) {
			makeLightning();
		}
		 
		if(turnsUntilThunder==0) {
			makeThunder();
			
			if(thunderIx<thunderTimes.length)
				++thunderIx;
			turnsUntilThunder = thunderTimes[thunderIx];
		} else {
			--turnsUntilThunder;
		}
	}
	
	reset() {
		turnsUntilThunder = thunderTimes[thunderIx];
	}

	makeLightning() {
		if(gPlayerChar.isIn(arcadeFront)) {
			"<.p>Lightning flashes in the windows. For a moment it is almost daylight in here.<.p>";
		} else if(gPlayerChar.isIn(arcadeStairwellByRoof)) {
			if(arcadeRoofDoorFromStairs.isOpen)
				"<.p>Lightning flashes in the doorway. For a moment it is almost daylight in here.<.p>";
		} else if(gPlayerChar.isIn(arcadeRoof)) {
			"<.p>Lightning flashes. For a moment it is almost daylight up here.<.p>";
		}
	}
	makeThunder() {
		if(gPlayerChar.isIn(arcadeRoof)) {
			"<.p>KRRRRRRACK-RUMBLE-RUMBLE-RUMBLE! An earsplitting thunder crack issues from the storm.
			For a moment you're deafened, but after a bit of ringing your ears are fine again.<.p>";
		} else {
			"<.p>KRRRRRRACK-RUMBLE-RUMBLE-RUMBLE! A thunder crack issues from the storm outside.<.p>";
		}
	}
	
	canSeeBecauseOfLightning() {
		if(turnsUntilThunder==0)
			return true;
		else
			return nil;
	}
	
	
	thunderIx = 1
//	thunderTimes = [5,6,11,20]
	thunderTimes = [5,8]

	turnsUntilThunder = thunderTimes[1]
;

