#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>


versionInfo: GameID
	name = 'I Must Play'
//	name = 'Apparition of the Arcade'
//	name = 'BEEP BLEEP BLING BLONG'
//	name = 'BEEP BOOP BLEEP BLONG'
//	name = 'BEEP BLEEP BLING BLEED'
//	name = 'BEEP BLEEP BLING BLOOD'
//	name = 'I Wanna Play Pac-Man'
//	name = 'Pac-Man and Frogger and Pong, Oh My!'
    byline = 'by Geoff Fortytwo'
    htmlByline = 'by <a href="mailto:ifcomp2004/_AT_/g42.org">Geoff Fortytwo</a> (<A HREF=\"http://ecstaticfuturist.com/tiki/tiki-index.php?page=IMustPlay\">website</A>)'
    version = '42.00.009'
	releaseDate = '2004-October-01'
    authorEmail = 'Geoff Fortytwo <ifcomp2004/_AT_/g42.org>'
	desc = 'Why are the older boys so mean? You stood around the arcade all day and weren\'t able
		to play even one game on any of the machines! You thought you had your chance when
		nearly everyone else went home earlier in the evening in order to beat the storm that was
		gathering outside. Unfortunately, the arcade owner decided to call it quits early
		as well. Luckily, when the call went out that he was closing up, you were able to sneak
		into the ball room and hide under the balls. The owner finally left and now
		it\'s time to play some games! '
    htmlDesc = desc
	presentationProfile = 'Multimedia'

    showCredit()
    {
        // show our credits
        "author: <A HREF=\"http://ecstaticfuturist.com\">Geoff Fortytwo</A>
		<p>
		
		Many thanks go to the people on rec.arts.int-fiction and specifically Eric Eve
		for providing so much TADS3 language help. And of course 
		he is also the author of the very helpful <q>Getting Started in TADS</q> guide as
		well as the very helpful
		<A HREF=\"http://users.ox.ac.uk/~manc0049/TADSGuide/index.html\">TADS Tour Guide</A>.
		<p>
		
		My thanks go out to my beta testers! Their testing helped me really tighten up this
		game.
		<UL>
		 <LI>Stephan Schonberg
		 <LI>Clay Busker
		 <LI>Curtis Rueden
		 <LI>RootShell
		 <LI>John Baker
		 <LI>Adrian Fanger
		 <LI>javri
		 <LI>Jed
		</UL>
		I'd like to especially thank Stephan Schonberg. He was extremely thorough in his testing
		and had plenty of very helpful constructive comments that allowed me to tighten up a
		few spots and flesh out others.

		<p>
		
		Edward L. Stauff also provided the TADS 3 Library Proto-Documentation tool which was
		of inestimable value.
		<p>
		
		Of course I must mention Michael Roberts, the creator of TADS.
		TADS 3 is a wonderfully consistent and powerful language that has made the development of this
		game very pleasant and enjoyable.
		<p>
		";
/*
		 <LI>Steve Breslin
		 <LI>Jed from FriendsOfTheUnicorn
		 <LI>Aaron A. Reed
*/
		
		
/*
		I refer to a number of trademarked works in this game. If you look at these credits
		again after finishing the game, you will see that list of trademarks here. I can't
		list them before the end because that would ruin part of the fun of the game.<.p>

		Some of the games that are in this game are trademarked. Those that are trademarked
		are listed here for the games that you have finished so far:\n
		<<pongMachine.credits()>>\n
		<<froggerMachine.credits()>>\n
		<<spaceInvadersBunkerMachine.credits()>>\n
		<<tetrisMachine.credits()>>\n
		<<duckHuntFieldMachine.credits()>>\n
		\n
		\n
		
		
		";
*/		
		
		
        // The game credits are displayed first, but the library will
        // display additional credits for library modules.  It's a good
        // idea to show a blank line after the game credits to separate
        // them visually from the (usually one-liner) library credits
        // that follow.  
        "\b";
    }
    showAbout()
    {
		"What follows are instructions specific to this game. For much more elaborate and
		general instructions about playing text adventure games, enter the command <q>instructions</q>.
		<p>
		If you want to play a video game then just play it. For instance, if there's a
		red video game machine then just type <q>play red</q>. Note that some games can be played
		again after you win them while others cannot be played any more once you win them. Also,
		some game worlds are reachable via multiple game machines that take you to different
		locations in the same game. Furthermore, some games are more lethal than others.
		In some games if you die then you just get sent back to the arcade. In others, the
		game has lethal consequences if you perish in the game.
		<p>
		If you want to stop playing a game at any point then just type <q>stop playing</q>.
		<p>
		If you get really stuck, type <q>help</q> for information on what you can do to get
		help.
		<p>
		If you prefer the classic game look, check out the <q>Themes</q> menu and
		choose <q>Plain Text</q>. Personally I prefer <q>Web Style</q>.
		Of course, that assumes you're using the same TADS
		interpreter that I am, which is obviously not a good assumption since IF games
		can be played on countless different platforms decades after they were
		initially written.)
		<p>
		The <q>credits</q> command will display the credits for this game.
		<p>
		There are certain recognized ways of talking with people and creatures in the game.
		If you're talking to a dog, you could say things like:\b
			\task dog about dog\n
			\task dog about bone\n
			\task dog for bone\n
		\b
		You can also listen to sounds by doing things like:\n
			\tlisten to squeaking\n
			\tlisten to rusty machine\n
		\b
		You can get hints by using the <q>hints</q> command.
		<p>
		If you're curious about the strange person who wrote this game then feel free to visit
		me at <A HREF=\"http://ecstaticfuturist.com\">http://ecstaticfuturist.com</A>. You might
		be specifically interested in my video game related projects (see that section in the left
		nav bar on my site). However, until after IFComp2004 is over, I will not have anything on my
		website about this game other than the walkthrough (type <q>walkthrough</q> to see the
		url where I have the walkthrough if you are really stuck).
		";
    }
;



me: MeRoomInSet,Actor
	vocabWords = 'me/self/myself'

	// Initial location is arcade ball room, lying in balls
	location = balls
	posture = lying
    
	mayStopPlaying = true
	
	returnPath = nil
	
	properName = nil	
	
	desc = "You look excellent! "
	
	dobjFor(Kiss) {
		verify() {}
		check() {}
		action() {
			"You're not hurt, and even if you were, only moms have the ability to kiss boo boos and
			make them all better. ";
		}
	}
;

+ yourPocket : Component 'pocket*pockets' 'pocket'
	"Isn't it amazing how you can hold in your pockets? "
;

/*
+ teeth : Component 'teeth' 'teeth'
	desc {
		if(wereBrushed) {
			"Your teeth are sparkling white! ";
		} else {
			"Your teeth are a bit yellowish, but they're not too bad. ";
		}
	}
	
	isPlural = true
	
	dobjFor(Brush) {
		verify() {}
		check() {}
		action() {
			if(toothBrush.isIn(gPlayerChar)) {
				nestedAction(BrushWith,teeth,toothBrush);
			} else {
				"You don't have anything to brush them with. ";
			}
		}
	}
	
	dobjFor(BrushWith) {
		verify() {}
		check() {}
		action() {
			"Your teeth are now sparkling clean. ";
			wereBrushed = true;
		}
	}

	
	wereBrushed = nil
;
*/

gameMain: GameMainDef
    initialPlayerChar = me

    showIntro()
    {
		"<<versionInfo.desc>><.p>
		
		<b><font color=green>
		<<versionInfo.name>>\n
		<I>(an arcade adventure)</I>\n
		(<A HREF=\"http://ecstaticfuturist.com/tiki/tiki-index.php?page=IMustPlay\">website</A>)\n
		<<versionInfo.byline>>\n
		(First time players of this game should type <q>about</q> for details.)\n
		Release <<versionInfo.version>> / Serial Number 424242 / TADS 3.0.7 <.p>
		</font></b>
		"
		;
		
		startupStuff.runScript();
		arcade.notifyBeforeArriving();
    }

    showGoodbye()
    {
        "<.p>GAME OVER (FOR REAL)\b";
    }

	
	scoreRankTable = [
		[0,            'a newbie']
		,[maxScore*1/3,'a casual gamer']
		,[maxScore*2/3,'a ninth key know-it-all']
		,[maxScore,    'Billy Mitchell']
		];	
;


function endGame(msg)
{  
	finishGameMsg(msg, [finishOptionUndo,finishOptionFullScore]);
}


// This goes through all objects in the game and counts how many exist which are
// of the specified class.
function countAllOfType(whichClass) {
	local cnt = 0;
	local cur = firstObj(whichClass);
	while(cur != nil) {
		++cnt;
		cur = nextObj(cur,whichClass);
	}
	return cnt;
}





/*
modify ActorState
  obeyCommand(issuingActor, action)
     {
         // 
         //   By default, we ignore all orders.  We do need to generate a
         //   response, though, so for this purpose, treat the order as a
         //   conversational action, with the 'action' object as the topic.
         //

         // 
         //   If the action takes a direct object (and so could have a list
         //   of direct objects), split it into a series of actions
         //   with a single direct object
         local dobjLst = action.getResolvedDobjList;

         if(dobjLst != nil) 
         {
            local singleAction = action;
 
        foreach(local obj in dobjLst)
           {
              singleAction.dobjCur_ = obj;
              handleConversation(issuingActor, singleAction, commandConvType); 
           }
         }
         // Otherwise, just treat it as a single command

         else
           handleConversation(issuingActor, action, commandConvType);
 
         // indicate that the order is refused
         return nil;
     }
;

TCommandTopic : CommandTopic
  // 
  //  The direct object, or a list of direct objects, that will be matched
  //  by this topic.
  matchDobj = nil
  
  // 
  //  The first direct object of the command that this CommandTopic matches.
  //  We cache it here so that it can easily be picked up in topicResponse.
  currentDobj = nil
  
  //
  //  Cache the action that has been matched so that it is readily accessible
  //  from topicResponse 
  currentAction = nil
  
  matchTopic(fromActor, action)
  {
    // First check whether we match the action of the command
    if(!inherited(fromActor, action))
      return nil;
        
    // Then cache the first direct object of the command
     
    currentDobj = action.getDobj();
        
    // If matchDobj is a list, check if the current direct object is in the list
    if(matchDobj.ofKind(Collection))
    {
      if(matchDobj.indexWhich({x: currentDobj.ofKind(x)}) != nil)
          return matchScore;
    }
    else    
    {
      // See if the direct object matches that specified in matchDobj 
      //  if it's a single object.
      if(currentDobj.ofKind(matchDobj))
        return matchScore;
    }   
    
     // We can't match the direct object at all, so return nil
   return nil; 
  }
  
  handleTopic(fromActor, action)
  {
    actionPhrase = action.getInfPhrase;
    currentAction = action;
    
    // 
    //  if the player types a command like X ME, getInfPhrase will
    //  return 'examine you'. In such a case we want to replace 'you'
    //  with 'me'.
    actionPhrase = actionPhrase.findReplace(' you ', ' me ', ReplaceAll);
    if(actionPhrase.endsWith(' you'))
      actionPhrase = actionPhrase.findReplace(' you', ' me', ReplaceOnce,
        actionPhrase.length-5);
    inherited(fromActor, action);
  }  
  
  // The action phrase of the command currently directed to this actor;
  //  for example, if the player types 'X ME' the actionPhrase will be
  //  'examine me'. This can be used in topicResponse to construct the
  //  command given by the player character, e.g. 
  // 
  //     "Sarah, please examine me," you ask.
  actionPhrase = nil
;
*/


DefineIAction(Help)
	execAction() {
		"The <q>about</q> command will show you general tips on playing.\n
		The <q>hints</q> command will let you look at hints on how to solve specific puzzles. ";
	}
;
VerbRule(Help)
	'help'
	: HelpAction
	verbPhrase = 'help'
;


DefineIAction(Walkthru)
	execAction() {
		"The walkthrough for this game is available at\n
			\t<A HREF=\"http://ecstaticfuturist.com/projects/IFComp2004/IMustPlay_walkthrough.cmd\">http://ecstaticfuturist.com/projects/IFComp2004/IMustPlay_walkthrough.cmd</A>";
	}
;
VerbRule(Walkthru)
	('walkthrough'|'walkthru')
	: WalkthruAction
	verbPhrase = 'walkthru'
;


DefineIAction(Fortytwo)
	execAction() {
		"It's the answer to the ultimate question of life, the universe, and everything. It's
		also the last name of the author of this game. (see http://g42.org) ";
	}
;
VerbRule(Fortytwo)
	'fortytwo'|'42'|'fourtytwo'
	: FortytwoAction
	verbPhrase = 'fortytwo'
;



DefineTAction(Play);
VerbRule(Play)
	('play')
	(
		('with'|'in'|'on')
		| ()
	) singleDobj
	: PlayAction
	verbPhrase = 'play/playing (what)'
;
modify Thing
	dobjFor(Play) {
		verify() { illogical('{You/he} can\'t play {that dobj/him}.'); }
	}
;


DefineIAction(StopPlaying)
	execAction() {
		if(gPlayerChar.roomLocation.ofKind(ArcadeRoomSet)) {
			"Life isn't a game. ";
		} else if(!gPlayerChar.mayStopPlaying) {
			"Somehow, this is more than just a game. You can't stop playing. ";
		} else {
			"You slowly regain consciousness of the real world...\b ";

			if(gPlayerChar.location.ofKind(Vehicle))
				gPlayerChar.moveIntoForTravel(gPlayerChar.location.location);

			local returnPath = gPlayerChar.returnPath;
			if(returnPath==nil)
				returnPath = connectorIntoArcade;
			nestedAction(TravelVia,returnPath);
		}
	}
;

VerbRule(StopPlaying)
	('stop' ('playing'|'play')) | 'xyzzy'
	: StopPlayingAction
	verbPhrase = 'stop playing/stopping play'
;


DefineTIAction(ReadWith);
VerbRule(ReadWith)
	('read'|'say') singleDobj 'with' singleIobj
	: ReadWithAction
	verbPhrase = 'read/reading (what) (with what)'
;
modify Thing
	dobjFor(ReadWith) {
		verify() { illogical('{You/he} can\'t read {that dobj/him} with {that iobj/him}. '); }
	}
;


DefineLiteralTAction(SayWith,DirectObject);
VerbRule(SayWith)
	('say'|'speak') singleLiteral 'with' singleDobj
	: SayWithAction
	verbPhrase = 'say/saying (what) (with what)'
;
modify Thing
	dobjFor(SayWith) {
		verify() { 
			illogical('{You/he} can\'t say anything with {that dobj/him}. ');
		}
	}
;


/*
DefineTIAction(Bleach);
VerbRule(Bleach)
	'bleach' dobjList 'with' singleIobj
	: BleachAction
	verbPhrase = 'bleach/bleaching (what) (with what)'
;
modify Thing
	dobjFor(Bleach) {
		verify() { illogical('{You/he} can\'t bleach {that dobj/him}. ');}
	}
	iobjFor(Bleach) {
		verify() {
			illogical('{That iobj/he} can\'t be used to bleach things. ');
		}
	}
;
*/


DefineTAction(Skip);
VerbRule(Skip)
	('skip'|'skim') singleDobj
	: SkipAction
	verbPhrase = 'skip/skipping (what)'
;
modify Thing
	dobjFor(Skip) asDobjFor(Throw)
;


DefineTAction(YellRead);
VerbRule(YellRead)
	('yell'|'shout'|'scream')
	singleDobj
	: YellReadAction
	verbPhrase = 'yell/yelling (what)'
;
DefineTAction(YellAt);
VerbRule(YellAt)
	(
	('yell'|'shout'|'scream')
	('through'|'at'|'with'|'into')
	)	
	singleDobj
	: YellAtAction
	verbPhrase = 'yell/yelling at (what)'
;
modify Thing
	dobjFor(YellRead) {
		verify() {
			if(gDobj!=nil && !gDobj.ofKind(Readable)) {
				illogical('{The dobj/he} {is} not something that can be yelled. ');
			}
		}
		action() {
		}
	}
	dobjFor(YellAt) {
		verify() {}
		check() {}
		action() {
			if(gDobj==me)
				"You chastise yourself for a bit, but you end up just feeling drained. ";
			else
				"You yell at {the dobj/him}. You feel better now, but you have elicited no response from {it/him}. ";
		}
	}
	
;

/*
VerbRule(Yell)
    'yell' | 'scream' | 'shout' | 'holler'
    : YellAction
    verbPhrase = 'yell/yelling'
;
DefineIAction(Yell)
    execAction()
    {
        // yelling generally has no effect; issue a default response
        mainReport(&okayYellMsg);
    }
;
*/


DefineTAction(Feed);
VerbRule(Feed)
	'feed' singleDobj
	: FeedAction
	verbPhrase = 'feed/feeding the (what)'
;
modify Thing
	dobjFor(Feed) {
		verify() {illogical('{You/he} can\'t feed {the dobj/him}. ');}
	}
;

DefineTIAction(FeedInto);
VerbRule(FeedInto)
	'feed' singleDobj ('into'|'to'|'in') singleIobj
	: FeedIntoAction
	verbPhrase = 'feed/feeding (what) (into what)'
;
modify Thing
	dobjFor(FeedInto) {
		verify() { illogical('{You/he} can\'t feed {that dobj/him} into {that iobj/him}. '); }
	}
;


DefineTIAction(InsertInto);
VerbRule(InsertInto)
	'insert' singleDobj ('into'|'in') singleIobj
	: InsertIntoAction
	verbPhrase = 'insert/inserting (what) (into what)'
;
modify Thing
	dobjFor(InsertInto) asDobjFor(PutIn)
	iobjFor(InsertInto) asIobjFor(PutIn)
;


DefineTAction(Brush);
VerbRule(Brush)
	'brush' singleDobj
	: BrushAction
	verbPhrase = 'brush/brushing (what)'
;
modify Thing
	dobjFor(Brush) {
		verify() {illogical('{That dobj/him} isn\'t something that you can brush. ');}
	}
;

DefineTIAction(BrushWith);
VerbRule(BrushWith)
	'brush' singleDobj ('with'|'using') singleIobj
	: BrushWithAction
	verbPhrase = 'brush/brushing (what) (with what)'
;
modify Thing
	dobjFor(BrushWith) {
		verify() {illogical('{That dobj/him} isn\'t something that you can brush. ');}
	}
	iobjFor(BrushWith) {
		verify() {illogical('{That iobj/him} isn\'t something that you can brush with. ');}
	}
;



VerbRule(StandBehind)
    'stand' 'behind' singleDobj
    : EnterAction
    verbPhrase = 'stand/standing behind (what)'
;


DefineTAction(UseIt);
VerbRule(UseIt)
	'use' singleDobj
	: UseItAction
	verbPhrase = 'use (what)'
;
modify Thing
	dobjFor(UseIt) {
		verify() { illogical('The use command doesn\'t work with {that dobj/him}. '); }
	}
;

DefineTAction(Flick);
VerbRule(Flick)
	'flick' singleDobj
	: FlickAction
	verbPhrase = 'flick/flicking (what)'
;
modify Thing
	dobjFor(Flick) asDobjFor(Flip)
;

DefineTAction(Tip);
VerbRule(Tip)
	'tip' singleDobj
	: TipAction
	verbPhrase = 'tip/tipping (what)'
;
modify Thing
	dobjFor(Tip) asDobjFor(Attack)
;


DefineTAction(Drive);
VerbRule(Drive)
	'drive' singleDobj
	: DriveAction
	verbPhrase = 'drive (what)'
;
modify Thing
	dobjFor(Drive) {
		verify() { illogical('{That dobj/him} is not something you can drive. '); }
	}
;

DefineTAction(Fix);
VerbRule(Fix)
	'fix' singleDobj
	: FixAction
	verbPhrase = 'fix (what)'
;
modify Thing
	dobjFor(Fix) {
		verify() { illogical('{That dobj/him} is not something you can fix. '); }
	}
;

DefineTAction(Wake);
VerbRule(Wake)
	('wake'|'awaken') singleDobj
	: WakeAction
	verbPhrase = 'wake (what)'
;
modify Thing
	dobjFor(Wake) {
		verify() { illogical('{That dobj/him} is not something you can wake. '); }
	}
;


// This is used to switch a general name of an actor to a proper name.
modify Actor
	makeProper() {
		if(properName != nil) {
			name = properName;
			initializeVocabWith(properName);
			isProperName = true;
		}
		return name;
	}
;

/*
modify Matchstick
	vocabWords = 'match/matchstick*matches'
	name = 'match'
	isEquivalent = true;
;
*/


DefineIAction(Shoot)
	execAction() {
//		askForDobj(ShootIt);
		"Try <q>shoot BLAH with THING</q>. ";
	}
;
VerbRule(Shoot)
	'shoot'
	: ShootAction
	verbPhrase = 'shoot/shooting'
;

DefineTAction(ShootIt);
VerbRule(ShootIt)
	'shoot' singleDobj
	: ShootItAction
	verbPhrase = 'shoot (what)'
;

DefineTIAction(ShootItWith)
    resolveFirst = IndirectObject
;
VerbRule(ShootItWith)
	'shoot' singleDobj ('with') singleIobj
	: ShootItWithAction
	verbPhrase = 'shoot/shooting (what) (with what)'
;


modify Thing
	dobjFor(ShootIt) {
		action() {
			askForIobj(ShootItWith);
		}
	}

	dobjFor(ShootItWith) {
		check() { "There\'s no reason to shoot {the dobj/him}. "; exit; }
	}
	iobjFor(ShootItWith) {
		verify() { illogical('{The iobj/he is} {is} not something you can shoot with. '); }
	}
;


DefineTAction(SwimIn);
VerbRule(SwimIn)
	(
		('swim'|'dive'|'doggy' 'paddle'|'paddle'|'do lap'|'do laps')
		(
			('in'|'through'|'under'|'into')
			| ()
		)
	)
	singleDobj
	: SwimInAction
	verbPhrase = 'swim/swimming in (what)'
;
DefineTAction(WadeIn);
VerbRule(WadeIn)
	(
		('wade')
		(
			('in'|'through'|'under'|'into')
			| ()
		)
	)
	singleDobj
	: WadeInAction
	verbPhrase = 'wade/wading in (what)'
;

modify Thing
	dobjFor(SwimIn) {
		verify() { illogical('{The dobj/him} {is} not something that you can swim in. '); }
	}
	dobjFor(WadeIn) asDobjFor(SwimIn)
//	{
//		verify() { illogical('{The dobj/him} {is} not something that you can wade in. '); }
//	}
;


DefineTAction(Steal);
VerbRule(Steal)
	'steal' singleDobj
	: StealAction
	verbPhrase = 'steal/stealing (what)'
;

modify Thing
	dobjFor(Steal) asDobjFor(Take)
;



/*
destNotCurrentRoom: PreCondition
    checkPreCondition(obj, allowImplicit)
    {
		if(gActor.roomLocation==gDobj) {
			reportFailure('You are already in it. ');
			exit;
		} else {
			return true;
		}
    }
;
*/

DefineTAction(JumpTo)
    preCond = [actorStanding]
;
VerbRule(JumpTo)
	(
		('jump'|'hop'|'leap')
		// This is optional, so it starts with a '|'
		(|'to'|'onto'|'on'|'towards'|'into'|'over'|'under')
	)
	singleDobj
	: JumpToAction
	verbPhrase = 'jump/jumping to (what)'
;
modify Thing
	dobjFor(JumpTo) asDobjFor(StandOn)
;





DefineTAction(Watch);
VerbRule(Watch)
	(
		('watch')
		| ('stare' 'at')
	)
	 singleDobj
	: WatchAction
	verbPhrase = 'watch/watching (what)'
;
modify Thing
	dobjFor(Watch) {
		verify() { illogical('{You/he} stare intently at {the dobj/him} for a bit, but you learn nothing new. '); }
	}
;



/*
nicegun : Thing 'nicegun' 'nicegun'
	@me
	
	iobjFor(ShootItWith) {
		verify() {}
		check() {}
		action() {
			"You shoot the nice gun. ";
		}
	}
;
*/



/*
modify Actor
	makeProper {
		if(isProperName == nil && properName != nil) {
			isProperName = true;
			name = properName;
			local tokList = Tokenizer.tokenize(properName);
			for (local i = 1, local cnt = tokList.length() ; i <= cnt ; ++i) {
				if(i < cnt)
					G_dict.addWord(self, getTokVal(tokList[i]), &adjective);
				G_dict.addWord(self, getTokVal(tokList[i]), &noun);
			}
		}
	}
;
*/	



#ifdef __DEBUG

	DefineIAction(TestFlip)
		execAction() {
			powerSwitch.makeOn(!powerSwitch.isOn);
			
			//executeCommand(gActor,gActor,[TravelVia],nil);
	
			//nestedAction(gActor,gActor.TravelVia, gActor.location.west);
			//nestedAction(gActor,TravelVia,gActor.location.east);
			
			//executeAction(gActor,'n',gActor,true,Move);
			//executeAction(targetActor, targetActorPhrase,issuingActor, countsAsIssuerTurn, action)		
			//mainReport('{You\'re} not sleepy right now. ');
		}
	;
	VerbRule(TestFlip)
		'testflip'
		: TestFlipAction
		verbPhrase = 'testflip/testingflip'
	;
	



	/* The purpose of the everything object is to contain a list of all usable
	game objects which can be used as a list of objects in scope for certain debugging
	verb. Everything caches a list of all relevant objects the first time its lst
	method is called. */
	everything : object
		/* lst_ will contain the list of all relevant objects. We initialize it to
		nil to show that the list is yet to be cached */
		lst_ = nil
		/* The lst_ method checks whether the list of objects has been cached yet.
		If so, it simply returns it; if not, it calls initLst to build it first
		(and then returns it). */
		lst() {
			if (lst_ == nil)
				initLst();
			return lst_;
		}
		/* initLst loops through every game object and adds it to lst_, unless
		it's a Topic, which we don't want included even in this universal scope.
		*/
		initLst() {
			lst_ = new Vector(50);
			local obj = firstObj();
			while (obj != nil) {
				if(!obj.ofKind(Topic) && !obj.ofKind(TopicEntry) && !obj.ofKind(ActorState))
					lst_.append(obj);
				obj = nextObj(obj);
			}
			lst_ = lst_.toList();
		}
	;	
		
	DefineTAction(Purloin)
		cacheScopeList() {
			scope_ = everything.lst();
		}
	;
	VerbRule(Purloin)
		('purloin'|'pn') dobjList
		:PurloinAction
		verbPhrase = 'purloin/purloining (what)'
	;
	modify Thing
		dobjFor(Purloin)
		{
			verify() {
				if(isHeldBy(gActor)) illogicalNow('{You/he} {is} already holding it. ');
			}
			check() {}
			action {
				mainReport('{The/he dobj} pops into your hands.\n ');
				moveInto(gActor);
			}
		}
	;
	modify Fixture
		dobjFor(Purloin) {
			verify {illogical ('That is not something you can purloin - it is fixed in place.'); }
		}
	;
	modify Immovable
		dobjFor(Purloin) {
			check() {
				"You can't take {the/him dobj}. ";
				exit;
			}
		}
	;
	DefineTAction(Gonear)
		cacheScopeList() {
			scope_ = everything.lst();
		}
	;
	VerbRule(Gonear)
		('gonear'|'gn'|'go' 'near') singleDobj
		:GonearAction
		verbPhrase = 'gonear/going near (what)'
	;
	modify Thing
		dobjFor(Gonear) {
			verify() {}
			check() {}
			action() {
				local obj = self.roomLocation;
				if(obj != nil) {
					"{You/he} {are} miraculously transported...</p>";
					replaceAction(TravelVia, obj);
				} else
					"{You/he} can't go there. ";
			}
		}
	;
	modify Decoration
		dobjFor(Gonear) {
			verify() {}
			check() {}
			action() {inherited;}
		}
	;
	modify Distant
		dobjFor(Gonear) {
			verify() {}
			check() {}
			action() {inherited;}
		}
	;
	modify MultiLoc
		dobjFor(Gonear) {
			verify() { illogical('{You/he} cannot gonear {the dobj/him}, since it
			exists in more than one location. '); }
		}
		dobjFor(Purloin) {
			verify() { illogical('{You/he} cannot purloin {the dobj/him}, since it
			exists in more than one location. '); }
		}
	;
		
		
		
	// "fiat lux"
	// creates light
	DefineIAction(FiatLux)
		execAction {
			if(gPlayerChar.brightness == 0) {
				"You start to glow!\n";
				gPlayerChar.brightness = 3;
			} else {
				"Repeating the spell reverses its effect, and your glowing aura disappears. ";
				gPlayerChar.brightness = 0;
			}
		}
	;	
	VerbRule(FiatLux)
		'fiat' 'lux'
		: FiatLuxAction
		verbPhrase = 'make/making light'
	;
	

	PreinitObject
		execute {
			// count total # of rooms
			local roomCount = countAllOfType(Room);
			local outdoorRoomCount = countAllOfType(OutdoorRoom);
			
			local paddingRooms =
				0 // all of the rooms are reasonably interesting and useful
				;
				
			local interestingRoomCount = roomCount - paddingRooms;

			local thingCount = countAllOfType(Thing);
			
			local achievementCount = countAllOfType(Achievement);
			
			local numVideoGamePortals = countAllOfType(VideoGameMachinePortal);
			
			local numWinningTickets = countAllOfType(WinningTicket);
			
			"<font color=green><p>STATS:\n
			\t<<achievementCount>> total achievements possible (maxScore=<<gameMain.maxScore>>)\n
			\t<<numVideoGamePortals>> total video game portals\n
			\t<<numWinningTickets>> total winning tickets\n
			
			\t<<roomCount>> rooms total\n
			\t\t<<interestingRoomCount>> interesting rooms (ones that truly add to the game)\n
			\t\t<<outdoorRoomCount>> of all rooms are OutdoorRooms\n
			\t\t<<paddingRooms>> of all rooms are padding rooms (which don't add much to the game)\n
			
			\t<<countAllOfType(Object)>> Objects total\n
			\t\t<<thingCount>> Things total\n
			\t\t\t<<countAllOfType(NonPortable)>> total NonPortables\n
			\t\t\t\t<<countAllOfType(Immovable)>> total Immovables\n
			\t\t\t\t<<countAllOfType(Fixture)>> total Fixtures (this includes all decorations)\n
			
			<p></font>\b\b";
		}
		execBeforeMe = [adv3LibPreinit]
	;






	// During testing, this sets the game to a certain state so that it's not necessary to
	// do these things over and over.
	startupStuff : InitObject
		execute {
		
			// start with machines powered on	
//			"*** flip power switch ***\n";
//			powerSwitch.makeOn(!powerSwitch.isOn);
			
//			gPlayerChar.moveIntoForTravel(arcade);
			
			
//			hintManager.showHints();
			
			"\n<HR>\b";
			
		}
		execBeforeMe = [adv3LibInit]
		
		runScript {
			setScriptFile('start.cmd',0);
//			setScriptFile('g:/prog/TADS/Games/IMustPlay/start.cmd',0);
//			setScriptFile('g:/prog/TADS/Games/pacman/scripts/toChicken.cmd',0);
//			setScriptFile('g:/prog/TADS/Games/IMustPlay/toHints.cmd',0);
		}
	;


#else

	//
	// Stuff that runs at start of release build.
	//

	startupStuff : InitObject
		execute {}
		runScript {}
	;
	
#endif

