/*
** GndHaus1.t defines the second floor of the house where all of the
** action takes place.
**
** Copyright (c) 1999, Stephen Granade. All rights reserved.
*/

#pragma C+

jeanie_bedroom: houseRm
    nameStr = 'your bedroom'  // nameStr is for when we get the flowerdy bag
    j_sdesc = "Your Bedroom"
    f_sdesc = "Jeanie's Bedroom"
    j_ldesc = "You've spent a lot of time in this room, enough that
	       it's really beginning to get on your nerves.
	       You're tired of the stupid posters, you're
	       tired of your stupid bed, you're tired of everything.
	       You just wish it weren't such a hassle to try to change
	       any of it. Besides, if you were going to change anything,
	       you'd start with the clothes in your closet. To the
	       west, across from your window, is a <<
	       jeanie_door_bedroom.wordDesc>> door going out. "
    exits = 'west'
    west = jeanie_door_bedroom
    sw = jeanie_door_bedroom
    out = jeanie_door_bedroom
;

jeanie_vanity: fixeditem, surface
    noun = 'vanity' 'mirror' 'table'
    adjective = 'dressing'
    location = jeanie_bedroom
    sdesc = "vanity"
    ldesc = {
	"Mom says the vanity used to belong to gramma. The mirror's
	 discolored enough to make you believe it. ";
	if (!jeanieMe.makeupDone)
	    self.printMakeupList;
	if (itemcnt(self.contents))
	    "There's <<listcont(self)>> on the vanity. ";
    }
    verDoLookin(actor) = {}
    doLookin(actor) = {
	if (actor.hurriedMakeup)
	    "You didn't take as much time as you normally like,
	     but what makeup you did put on looks decent. ";
	else if (actor.blushOn && actor.eyeshadowOn && actor.mascaraOn)
	    "Your makeup doesn't look half bad. Your roots are
	     showing&mdash;you'll have to bleach again soon. ";
	else self.printMakeupList;
    }
    printMakeupList = {
	local i, onList = [], offList = [];

	if (jeanieMe.blushOn)
	    onList += 'blush';
	else offList += 'blush';
	if (jeanieMe.eyeshadowOn)
	    onList += 'eye shadow';
	else offList += 'eye shadow';
	if (jeanieMe.mascaraOn)
	    onList += 'mascara';
	else offList += 'mascara';
	"You're done putting on foundation";
	if (length(onList) > 1) {
	    for (i = 1; i < length(onList); i++)
		", <<onList[i]>>";
	    ",";
	}
	if (length(onList) > 0)
	    " and <<onList[length(onList)]>>";
	". ";
	if (length(offList) > 0) {
	    "That just leaves <<offList[1]>>";
	    if (length(offList) == 3)
		", <<offList[2]>>, and <<offList[3]>>";
	    else if (length(offList) == 2)
		" and <<offList[2]>>";
	    " to go. ";
	}
    }
    verDoLookunder(actor) = {
	if (actor != jeanieMe || !actor.lookingForBillfold)
	    pass verDoLookunder;
    }
    doLookunder(actor) = {
	"Your billfold's not under there. ";
	if (!actor.mentionedKitchenAgain) {
	    actor.mentionedKitchenAgain = true;
	    "Besides, you're pretty sure you didn't take your
	     billfold out of the kitchen, and Frank's given up
	     picking up after you. ";
	}
    }
    doSiton -> jeanie_chair
;

jeanie_chair: chairitem
    firstStand = true
    reachable = ([jeanie_vanity] + flowerdy_bag + cane_bottom + self)
    noun = 'chair'
    adjective = 'rickety' 'cane-bottomed'
    location = jeanie_bedroom
    sdesc = "cane-bottomed chair"
    ldesc = "The cane bottom is about wore out, and the whole chair's
	     pretty rickety. "
    doUnboard(actor) = {
	if (self.firstStand) {
	    self.firstStand = nil;
	    if (!actor.makeupDone) {
		actor.hurriedMakeup = true;
		"Forget this. You stand up";
		if (!makeup.allIn(actor))
		    " and grab your makeup";
		if (!actor.blushOn) {
		    ". A dab of some blush";
		    if (!actor.mascaraOn)
			" and a little mascara";
		    if (!actor.eyeshadowOn)
			"&mdash;screw the eye shadow&mdash;";
		    else ", ";
		    "then you dump";
		}
		else if (!actor.mascaraOn) {
		    ". A little bit of mascara";
		    if (!actor.eyeshadowOn)
			"&mdash;screw the eye shadow&mdash;";
		    else ", ";
		    "then you dump";
		}
		else ", then dump ";
		" all the makeup ";
		if (makeup.allIn(flowerdy_bag))
		    "back ";
		"into your bag. ";
		actor.makeupDone = true;
		actor.blushOn = true;
		actor.mascaraOn = true;
		actor.eyeshadowOn = true;
	    }
	    else {
		"Enough staring into the mirror. You ";
		if (makeup.allIn(flowerdy_bag))
		    "stand up, making sure all your makeup's in your
		     bag. ";
		else {
		    if (!makeup.allIn(actor))
			"grab all your makeup and dump it";
		    else "dump all your makeup";
		    " in your bag. ";
		}
	    }
	    makeup.allMove(flowerdy_bag);
	    makeup.moveInto(flowerdy_bag);
	}
	else "Okay, %you're% no longer <<self.statusPrep>> <<
	      self.thedesc>>. ";
	self.leaveRoom(actor);
	actor.moveInto(self.location);
    }
    west = {
	local stat;

	if (!self.firstStand) {
	    execCommand(actorObject(), getOutVerb, self, nil, nil,
			EC_HIDE_SUCCESS | EC_HIDE_ERROR);
	}
	else {
	    execCommand(actorObject(), getOutVerb, self, nil, nil, 0);
	    "\b";
	}

	return jeanie_door_bedroom;
    }
    sw = (self.west)
    out = (self.west)
;

cane_bottom: fixeditem
    noun = 'bottom'
    adjective = 'cane'
    location = jeanie_bedroom
    sdesc = "cane bottom"
    ldesc = "It's looking mighty thin these days. "
    takedesc = "It may be thin, but it'd still be a pain to rip out.
		And then where would you sit? "
    doBoard -> jeanie_chair
    doSiton -> jeanie_chair
    doLieon -> jeanie_chair
    ioPutOn -> jeanie_chair
;

jeanie_door_bedroom: doorway
    isopen = nil
    lockPooshed = true
    otherside = jeanie_door_hall
    doordest = second_story_hall
    noun = 'door'
    adjective = 'bedroom' 'my'
    location = jeanie_bedroom
    sdesc = "bedroom door"
    ldesc = {
	if (self.isopen)
	    "You left your door open. Through it you can see the hall. ";
	else "There is a small dingle near the bottom of the door that
	      you can see when it's closed, like now. ";
    }
    verDoLookthru(actor) = {
	if (!self.isopen)
	    "You can't see through it when it's shut. ";
    }
    doLookthru(actor) = { "You can see the hall. "; }
    verDoLock(actor) = {
	if (self.lockPooshed)
	    "It is already locked. ";
    }
    doLock(actor) = {
	"You push on the button to lock the door. ";
	self.lockPooshed = true;
    }
    setIsopen(setting) = {
	if (setting)
	    self.lockPooshed = nil;
	pass setIsopen;
    }
;

jeanie_dingle: twodescthing, decoration
    noun = 'dingle' 'dent'
    adjective = 'door'
    location = jeanie_bedroom
    sdesc = "dingle"
    j_ldesc1 = "One time, when you were seven, mom and Frank sent you to
		your room. After being locked up in here a few hours, when
		you asked if you could come out yet, mom told you no. So you
		kicked the door hard as you could and put this little
		dingle in it. Good thing mom never saw. "
    j_ldesc = "A small dent you put in the door when you were seven. "
;

geode: fixeditem
    isListed = true
    noun = 'geode' 'rock'
    location = jeanie_vanity
    sdesc = "geode"
    ldesc = "It's the only thing left from when you were little and
	     thought you wanted to be a scientist. You only keep it
	     because it's pretty. "
    takedesc = "You don't need to go dragging that thing all over
		creation. "
;

jeanie_window: fixeditem
    noun = 'window'
    adjective = 'my' 'one'
    location = jeanie_bedroom
    sdesc = "window"
    ldesc = {
        if (jeanie_curtains.isopen)
            "Even with the curtains open you can't see much.
	     It's too dark outside. ";
        else "Curtains cover the window. ";
    }
    verDoLookthru(actor) = {
        if (!jeanie_curtains.isopen)
            "All you see are curtains. ";
    }
    doLookthru(actor) = {
        "You can almost see the street below, but not well enough to see
	 if April's here yet. ";
    }
    verDoOpen(actor) = {
	"The window's been painted shut ever since you can
	 remember. ";
    }
    verDoClosed(actor) = { "It's already closed. "; }
;

jeanie_curtains: fixeditem
    isThem = true
    isopen = nil
    wordDesc = { self.isopen ? "open" : "closed"; }
    noun = 'curtain'
    plural = 'curtains'
    adjective = 'tan'
    location = jeanie_bedroom
    sdesc = "tan curtains"
    ldesc = "You kinda remember picking the fabric for mom to make the
	     curtains out of when you
	     were in first grade. Right now the curtains are <<
	     self.wordDesc>>. "
    verDoOpen(actor) = {
        if (self.isopen)
            "The curtains are already open. ";
    }
    doOpen(actor) = {
	"You open the curtains. It's gotten dark outside
	 while you've been getting ready. ";
        self.isopen = true;
        street.moveInto(jeanie_bedroom);
    }
    verDoClose(actor) = {
        if (!self.isopen)
            "The curtains are already closed. ";
    }
    doClose(actor) = {
        "You pull the curtains shut. ";
        self.isopen = nil;
        street.moveInto(nil);
    }
;

street: thing
    isListed = nil
    noun = 'street'
    sdesc = "street"
    ldesc = "You can barely see the street, it's gotten so dark.
	     You certainly can't see if April's here yet or
	     not. "
    dobjGen(a, v, i, p) = {
        if (!v.issysverb && v != inspectVerb && v != askVerb &&
                v != tellVerb) {
            "The window's between you and the street. ";
            exitobj;
        }
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a,v,d,p); }
;

posters: fixeditem
    isThem = true
    noun = 'poster' 'posters' 'crue'
    adjective = 'stupid' 'motley'
    location = jeanie_bedroom
    sdesc = "posters"
    ldesc = "You liked all of the posters when you put them up, especially
	     that one of M&ouml;tley Cr&uuml;e. But they've
	     been up there long enough that you're bored of them.
	     Even the Cr&uuml;e is last year's band now. "
    takedesc = "Nah. Take too much time, time you don't want to spend
		right now. "
;

jeanie_bed: beditem
    noun = 'bed'
    adjective = 'my' 'stupid' 'frilly'
    location = jeanie_bedroom
    sdesc = "bed"
    ldesc = "Did you ever really think four-poster beds were cool? "
    takedesc = "Yeah, you and Mr.\ Universe are going to cart this frilly
		thing away. "
    verDoLieon(actor) = "Not after you spent so long on your hair. "
    verDoLookunder(actor) = {}
    doLookunder(actor) = {
	if (actor.lookingForBillfold) {
	    "Your billfold's not under there. ";
	    if (!actor.mentionedKitchenAgain) {
		actor.mentionedKitchenAgain = true;
		"Besides, you're pretty sure you didn't take your
		 billfold out of the kitchen, and Frank's given up
		 picking up after you. ";
	    }
	}
	else "You used to keep magazines under there until you got
	      tired of your mom yapping at you about them and threw
	      them away. ";
    }
    verDoMake(actor) = { "It's already made. "; }
;

jeanie_closet: fixeditem
    noun = 'closet'
    adjective = 'my'
    location = jeanie_bedroom
    sdesc = "closet"
    ldesc = "Sure, there are a lot of clothes in there, but most of them
	     are way out of date. And don't even think about that
	     nasty Hardee's uniform hanging at one end. "
    verDoEnter(actor) = "There's barely enough room for your clothes
			 in there. "
    doSynonym('Enter') = 'Board'
    verDoSearch(actor) = {
	if (!actor.lookingForBillfold)
	    "You've already picked your outfit for tonight. You're not
	     magically going to find better clothes. ";
    }
    doSearch(actor) = {
	"You root around in there, but don't find your billfold. ";
	if (!actor.mentionedKitchenAgain) {
	    actor.mentionedKitchenAgain = true;
	    "Besides, you're pretty sure you didn't take your
	     billfold out of the kitchen, and Frank's given up
	     picking up after you. ";
	}
    }
    verDoOpen(actor) = {
	"It's always open, seeing as how its door's been missing since
	 before it was your room. ";
    }
    verDoClose(actor) = {
	"You can't. It doesn't have a door. ";
    }
    verDoLookin(actor) = {
	"Your closet's full of old clothes. ";
    }
;

jeanie_closet_clothes: fixeditem
    isThem = true
    noun = 'clothes'
    adjective = 'my'
    location = jeanie_closet
    sdesc = "clothes"
    ldesc = "You guess they aren't <i>that</i> bad. You'd still
	     like some new ones. "
    takedesc = "You've wasted enough time picking tonight's
		outfit. No changing your mind now, girl. "
    verDoWear(actor) = { self.takedesc; }
;

hardees_uniform: fixeditem
    noun = 'uniform'
    adjective = 'hardees' 'hardee\'s'
    location = jeanie_closet
    sdesc = "Hardee's uniform"
    ldesc = "That has to be about the shittiest job you can imagine. Getting
	     up at the butt-crack of dawn to go make biscuits, all because
	     Frank won't cough up enough of an allowance any more. "
    takedesc = "Sure, wear that when you go out tonight. That'd
		impress people. "
    verDoWear(actor) = { self.takedesc; }
;

second_story_hall: houseRm
    j_sdesc = "Hall"
    f_sdesc = "Hallway"
    j_ldesc = {
	"The hall goes north to your bathroom and south to the stairs. Mom
	 and Frank's bedroom is to the west, directly across from
	 your room. ";
	if (!jeanie_door_hall.isopen)
	    "The door to your bedroom is closed. ";
    }
    f_ldesc = {
	"The hallway runs from the north end of the house to the south end.
	 At the north end is the extra bathroom Jeanie uses, and the stairs
	 are at the south end. Your bedroom is west, across from
	 Jeanie's room. ";
	if (jeanie_door_hall.isopen)
	    "Through the open door you can see Jeanie moving around in
	     her bedroom. ";
    }
    exits = {
	"north, ";
	if (jeanie_door_hall.isopen)
	    "east, ";
	"west, and down";
    }
    north = jeanie_bath_door_hall
    south = (self.down)
    east = {
	if (actorObject() == frankMe) {
	    if (jeanie_door_hall.isopen) {
		"You start to walk into Jeanie's bedroom, but she
		 rushes towards you. <q>Privacy, Frank! Ever heard
		 of it?</q> Before you know it you're standing back
		 in the hall, looking at a closed door. You look at
		 the door for a while before stepping back. ";
		fake_jeanie.jeanieClosesDoor;
	    }
	    else "You try the knob gently, but the door is locked. ";
	    return nil;
	}
	return jeanie_door_hall;
    }
    west = parents_door_hall
    down = {
	if (actorObject() == jeanieMe && !flowerdy_bag.isIn(jeanieMe)) {
	    "Almost forgot your bag. You ";
	    if (uberloc(flowerdy_bag) != self)
		"duck into <<uberloc(flowerdy_bag).nameStr>> and ";
	    "grab it before heading downstairs.\b";
	    flowerdy_bag.moveInto(jeanieMe);
	}
	else if (actorObject() == frankMe && jeanie_door_hall.isopen) {
	    "As you head down the stairs, a quiet click makes you glance
	     back in time to see Jeanie's door shut. You swear you
	     can hear her sighing heavily behind the door.\b";
	    fake_jeanie.jeanieClosesDoor;
	}
	else "You head down the stairs.\b";
	return living_room;
    }
;

stairs_down: fixeditem
    isThem = true
    noun = 'stairs' 'step' 'staircase'
    plural = 'steps'
    sdesc = "stairs"
    ldesc = "They go down. "
    location = second_story_hall
    verDoClimb(actor) = {}
    doClimb(actor) = {
        actor.travelTo(actor.location.down);
    }
    doSynonym('Climb') = 'Enter'
;

jeanie_door_hall: doorway
    isopen = nil
    otherside = jeanie_door_bedroom
    doordest = jeanie_bedroom
    noun = 'door'
    adjective = 'east' 'bedroom' 'my' 'jeanie\'s'
    location = second_story_hall
    j_sdesc = "your bedroom door"
    f_sdesc = "east door"
    adesc = {
	if (actorObject() == jeanieMe)
	    return j_sdesc;
	pass adesc;
    }
    thedesc = {
	if (actorObject() == jeanieMe)
	    return j_sdesc;
	pass thedesc;
    }
    ldesc = "It's <<self.wordDesc>>. "
    verDoOpen(actor) = {
	if (actor == frankMe && !self.isopen)
	    "You try the knob gently, but the door's locked. ";
	else pass verDoOpen;
    }
    verDoUnlock(actor) = {
	"%You% %do%n't %have% the key. ";
    }
    doSynonym('Unlock') = 'Lock'
;

parents_door_hall: doorway
    isopen = true
    otherside = parents_door_bedroom
    doordest = parents_bedroom
    noun = 'door'
    adjective = 'west'
    location = second_story_hall
    j_sdesc = "west door"
    f_sdesc = "door to your bedroom"
    ldesc = "It's <<self.wordDesc>>. "
    verDoClose(actor) = {
	if (actor == jeanieMe)
	    "No way. Frank's got a rod up his ass about you messing
	     with his stuff. ";
	else "Deb doesn't like it when you do that. Says it makes
	      Jeanie think you don't trust her. Well, hell, half
	      of the time you're not sure whether you do or not. ";
    }
;

jeanie_bath_door_hall: autoDoor
    doordest = second_story_bath
    adjective = 'north'
    location = second_story_hall
    sdesc = "north door"
;

second_story_bath: houseRm
    isBathroom = true
    sinkObj = jeanie_bath_sink
    nameStr = 'your bathroom'
    j_sdesc = "Your Bathroom"
    f_sdesc = "Extra Bathroom"
    j_ldesc = "Your bathroom's not only small, it's not even
	       right by your bedroom. Some day maybe you'll streak
	       between here and your room, give Frank a real
	       show. A bunch of your bottles are scattered round the
	       sink. The hallway is back to the south. "
    f_ldesc = "It's pretty obvious Jeanie uses this extra bathroom,
	       since her stuff is scattered all over the sink. At least
	       she keeps the shower pretty neat most of the time. "
    exits = 'south'
    south = jeanie_bath_door_bath
    out = jeanie_bath_door_bath
;

jeanie_bath_toilet: fixeditem
    noun = 'toilet' 'crapper' 'commode' 'john' 'loo'
    adjective = 'porcelain'
    location = second_story_bath
    j_sdesc = "toilet"
    f_sdesc = "commode"
    j_ldesc = "A porcelain toilet. "
    f_ldesc = "A porcelain commode. "
    verDoEnter(actor) = {
	"You don't have to go right now. ";
    }
    doSynonym('Enter') = 'Siton' 'Use' 'Open'
    verDoFlush(actor) = {
	"You flush it and watch the water swirl around. ";
    }
;

// So the player can use the bathroom
jeanie_bath_bathroom: decoration
    noun = 'bathroom'
    location = second_story_bath
    sdesc = "bathroom"
    ldesc = {
	execCommand(actorObject(), lookVerb);
    }
    doUse -> jeanie_bath_toilet
    doEnter -> jeanie_bath_toilet
;

jeanie_bath_mirror: fixeditem
    noun = 'mirror'
    location = second_story_bath
    sdesc = "mirror"
    j_ldesc = "You should probably clean the water spots off the mirror,
	       but as long as you can see yourself, you probably won't
	       get around to it. In it, you look about as ready as
	       you're going to be for tonight. "
    f_ldesc = "You can barely see yourself through the water spots, but
	       what you can see shows a tired-looking man. "
    verDoLookin(actor) = {}
    doLookin(actor) = (self.ldesc)
    verDoClean(actor) = {
	if (actor == jeanieMe)
	    "Maybe later. Then again, maybe never. ";
	else "You've got enough stuff to do around the house as it
	      is without volunteering for more. ";
    }
;

jeanie_bath_sink: fixeditem
    noun = 'sink'
    adjective = 'porcelain'
    location = second_story_bath
    sdesc = "porcelain sink"
    j_ldesc = "You've left a bunch of your bottles around the sink. "
    f_ldesc = "A porcelain sink that's just about covered with
	       Jeanie's bottles. "
    verDoTurnon(actor) = {
	if (actor == jeanieMe)
	    "No way you're going to risk splashing water on you. ";
	else "Nah. Your hands aren't that dirty. ";
    }
    verDoTurnoff(actor) = { "The sink's not on. "; }
    doSynonym('Turnon') = 'Use'
    verDoLookunder(actor) = {
	if (actor != jeanieMe || !actor.lookingForBillfold)
	    pass verDoLookunder;
    }
    doLookunder(actor) = {
	"Your billfold's not under there. ";
	if (!actor.mentionedKitchenAgain) {
	    actor.mentionedKitchenAgain = true;
	    "Besides, you're pretty sure you didn't take your
	     billfold out of the kitchen, and Frank's given up
	     picking up after you. ";
	}
    }
;

jeanie_bottles: fixeditem
    isThem = true
    noun = 'bottle' 'bottles' 'moisturizer' 'shampoo' 'shampoos' 'stuff'
    location = second_story_bath
    sdesc = "bottles"
    j_ldesc = "Moisturizer, shampoo, shit like that. "
    f_ldesc = "Why does Jeanie need all these bottles? Three different
	       shampoos? Why's anyone need three shampoos? "
    takedesc = {
	if (actorObject() == jeanieMe)
	    "Nah. You're travelling light tonight. ";
	else "Jeanie'd have a screaming fit if you tried to throw
	      any of those bottles away. ";
    }
;

jeanie_bath_bath: fixeditem
    noun = 'bath' 'tub'
    location = second_story_bath
    sdesc = "bath"
    j_ldesc = "You only wish you had a tub. All you've got is that
	       shower. "
    dobjGen(a, v, i, p) = {
        if (!v.issysverb && v != inspectVerb && v != askVerb &&
                v != tellVerb) {
	    "Don't you remember? You don't have a tub. ";
            exitobj;
        }
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a,v,d,p); }
;

jeanie_bath_shower: fixeditem
    noun = 'shower' 'stall'
    adjective = 'shower'
    location = second_story_bath
    sdesc = "shower"
    j_ldesc = "All it is is a stall&mdash;no tub or anything. "
    f_ldesc = "That shower stall is starting to look nasty. Better tell
	       Jeanie. "
    verDoClean(actor) = {
	if (actor == jeanieMe)
	    "Maybe later. Then again, maybe never. ";
	else "If you start doing Jeanie's chores, she'll never
	      do any of them again. ";
    }
    verDoTake(actor) = {
	if (takeVerb.takeTyped)
	    self.verDoEnter(actor);
	else pass verDoTake;
    }
    verDoEnter(actor) = {
	if (actor == jeanieMe)
	    "Forgetting that shower you took about an hour ago? ";
	else "You already bathed this morning. ";
    }
    doSynonym('Enter') = 'Board' 'Turnon'
;

jeanie_bath_door_bath: autoDoor
    doordest = second_story_hall
    location = second_story_bath
    sdesc = "door"
    verDoLock(actor) = {}
;

parents_bedroom: houseRm
    nameStr = 'mom and Frank\'s room'
    j_sdesc = "Mom and Frank\'s Room"
    f_sdesc = "Your Bedroom"
    j_ldesc = "Mom and Frank's room is okay, you guess. That waterbed
	       of theirs is pretty sweet, even with that stupid little
	       nightstand next to it. Their bathroom is north, and an open
	       door to the east goes back into the hall. "
    f_ldesc = "Your bedroom is okay, though all the furniture makes it
	       feel cluttered. The waterbed alone takes up most of the
	       room. There's barely enough room for that nightstand
	       you fixed or for your dresser. Your bathroom is north. "
    exits = {
	if (actorObject() != jeanieMe)
	    "north and ";
	"east";
    }
    north = parents_bath
    east = {
	if (nightstand_drawer.isopen) {
	    if (actorObject() == jeanieMe) {
		"Shit, the drawer! Frank would have your hide if he knew
		 you'd been messing with his stuff. ";
		if (roll_of_bills.takenBills)
		    "I mean, he's going to find out sooner or later,
		     but better later than sooner. ";
		"You slide the drawer shut before you leave.\b";
	    }
	    else "As you're leaving, you notice that the nightstand
		  drawer is open and close it. No sense in hiding money
		  if you're going to leave the drawer wide open
		  like that.\b";
	    nightstand_drawer.isopen = nil;
	}
	return parents_door_bedroom;
    }
    out = (self.east)
;

parents_door_bedroom: doorway
    isopen = true
    otherside = parents_door_hall
    doordest = second_story_hall
    noun = 'door'
    adjective = 'bedroom' 'open'
    location = parents_bedroom
    sdesc = "bedroom door"
    ldesc = "It's <<self.wordDesc>>. "
    verDoClose(actor) = {
	if (actor == jeanieMe)
	    "No way. Frank's got a rod up his ass about you messing with
	     his stuff. ";
	else "Deb doesn't like it when you do that. Says it makes
	      Jeanie think you don't trust her. Well, hell, half
	      of the time you're not sure whether you do or not. ";
    }
;

furniture: decoration
    noun = 'furniture'
    sdesc = "furniture"
    f_ldesc = "There's a waterbed, a nightstand, and your dresser. "
;

waterbed: beditem
    notMade = true
    noun = 'bed' 'waterbed'
    location = parents_bedroom
    sdesc = "waterbed"
    j_ldesc = "This is the one thing in mom's bedroom that you'd
	       about kill for. Anything would be better than that four-poster
	       monster you've got now, but this would be awesome. "
    f_ldesc = {
	"Deb may like it, but you're pretty sure it's
	 not helping your back problems. ";
	if (self.notMade)
	    "It's still mussed from where you took that nap earlier. ";
    }
    takedesc = {
	if (actorObject() == jeanieMe)
	    "Liking it is one thing; trying to take it is a whole
	     'nother story. ";
	else "If you think sleeping on that thing messes up your back,
	      imagine what picking it up would do. ";
    }
    verDoMake(actor) = {
	if (actor == jeanieMe)
	    "You're not gonna touch that bed. ";
	else if (!self.notMade)
	    "You've already made the bed. ";
    }
    doMake(actor) = {
	"You tug on the sheets and pull them taut enough for the bed to
	 pass muster. ";
	self.notMade = nil;
    }
    verDoLieon(actor) = {
	if (actor == jeanieMe)
	    "It'd mess up your hair. ";
	else "You're tired, but there's lots of work to be done before
	      bed. ";
    }
    verDoSiton(actor) = {
	if (actor == frankMe)
	    "Nah. That thing just isn't that comfortable. ";
    }
    doSiton(actor) = {
	"You sit on the bed, sending out little waves that eventually
	 stop. ";
	actor.travelTo(self);
    }
    verDoLookunder(actor) = {
	if (actor != jeanieMe || !actor.lookingForBillfold)
	    pass verDoLookunder;
    }
    doLookunder(actor) = {
	"There's no way your billfold could've gotten under there,
	 but you look anyway. It's not there. ";
	if (!actor.mentionedKitchenAgain) {
	    actor.mentionedKitchenAgain = true;
	    "Besides, you're pretty sure you didn't take your
	     billfold out of the kitchen, and Frank's given up
	     picking up after you. ";
	}
    }
;

dresser: fixeditem
    noun = 'dresser'
    adjective = 'my' 'Frank\'s'
    location = parents_bedroom
    j_sdesc = "Frank's dresser"
    f_sdesc = "your dresser"
    j_ldesc = "No telling what's inside there, and no way you'd
	       open it. What if you found his tighty whities? "
    f_ldesc = "Deb keeps asking if she can have a drawer in your dresser.
	       What's that about? There's barely enough room
	       in there for your clothes as it. "
    verDoOpen(actor) = {
	if (actor == jeanieMe)
	    "Ew. You just know you'd find his underwear, streak marks
	     and all. ";
    }
    doOpen(actor) = {
	"You aimlessly open a drawer or two, then close them. ";
    }
    verDoLookunder(actor) = {
	if (actor != jeanieMe || !actor.lookingForBillfold)
	    pass verDoLookunder;
    }
    doLookunder(actor) = {
	"There's no way your billfold could've gotten under there,
	 but you look anyway. It's not there. ";
	if (!actor.mentionedKitchenAgain) {
	    actor.mentionedKitchenAgain = true;
	    "Besides, you're pretty sure you didn't take your
	     billfold out of the kitchen, and Frank's given up
	     picking up after you. ";
	}
    }
;

nightstand: fixeditem
    noun = 'stand' 'nightstand'
    adjective = 'little'
    location = parents_bedroom
    sdesc = "little nightstand"
    j_ldesc = "It's not much to look at. There's <<
	       nightstand_drawer.aWordDesc>> drawer in it. "
    f_ldesc = "Looks like you're going to have another refinishing
	       job soon. Its drawer is <<nightstand_drawer.wordDesc>>. "
    verDoLookunder(actor) = {
	if (actor != jeanieMe || !actor.lookingForBillfold)
	    pass verDoLookunder;
    }
    doLookunder(actor) = {
	"There's no way your billfold could've gotten under there,
	 but you look anyway. It's not there. ";
	if (!actor.mentionedKitchenAgain) {
	    actor.mentionedKitchenAgain = true;
	    "Besides, you're pretty sure you didn't take your
	     billfold out of the kitchen, and Frank's given up
	     picking up after you. ";
	}
    }
    doOpen -> nightstand_drawer
    doClose -> nightstand_drawer
    ioPutIn -> nightstand_drawer
;

nightstand_drawer: fixeditem, openable
    isopen = nil
    firstOpen = true
    noun = 'drawer'
    adjective = 'nightstand'
    location = nightstand
    sdesc = "nightstand drawer"
    ldesc = {
	"It's <<self.wordDesc>>. ";
	if (self.isopen && itemcnt(self.contents) != 0)
	    "There's <<listcont(self)>> inside it. ";
    }
    takedesc = {
	if (actorObject() == jeanieMe)
	    "It's light enough to, but you're better off leaving it
	     where it is. ";
	else "It's just fine where it is. ";
    }
    doOpen(actor) = {
	if (actor != jeanieMe || !self.firstOpen)
	    pass doOpen;
	self.firstOpen = nil;
	"You slide open the drawer&mdash;surely Frank won't
	 notice&mdash;to find <<listcont(self)>>. ";
	self.isopen = true;
    }
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) = {
	if (dobj != stolen_money)
	    "You want to advertise that you've been messing around with
	     the nightstand? ";
	else pass ioPutIn;
    }
;

roll_of_bills: item
    takenBills = nil
    firstTake = true    // True the first time Jeanie takes the bills
    noun = 'bill' 'bills' 'roll' 'money'
    adjective = 'bills'
    location = nightstand_drawer
    sdesc = "roll of bills"
    j_ldesc = {
	if (self.takenBills)
	    "The roll of bills is a little thinner than it was. ";
	else "Frank's little stash of money. There's probably
	      over a hundred bucks, easy. ";
    }
    f_ldesc = "Your backup roll is still where it should be. "
    verDoTake(actor) = {
	if (actor == jeanieMe && self.takenBills)
	    "You've taken about as much as you can without making
	     Frank suspicious. ";
	else if (actor == frankMe)
	    "You start to take it, but figure you'll just spend it
	     if you do. ";
    }
    doTake(actor) = {
	if (self.firstTake) {
	    self.firstTake = nil;
	    "You glance over your shoulder, then pull a bunch of
	     bills from the roll. You stop after about eighty. If
	     you're lucky, Frank won't find them gone for a while. ";
	    if (jeanie.gotYelledAtAboutTV || jeanie.gotYelledAtAboutMoney)
		"It's not like you care about Frank getting mad all
		 that much, but mom'd be <q>disappointed in you</q>. ";
	    "You put the roll back in the drawer and ";
	}
	else "You again peel some bills off the roll before putting the
	      roll back in the drawer. You then ";
	if (billfold.isIn(actor)) {
	    "stuff the bills in your billfold. ";
	    billfold.addedBills = true;
	}
	else {
	    "hide the bills you took. ";
	    stolen_money.moveInto(actor);
	}
	self.takenBills = true;
    }
    verDoCount(actor) = {}
    doCount(actor) = {
	if (actor == jeanieMe) {
	    if (self.takenBills)
		"You've left about forty bucks. ";
	    else "You riffle through the roll. Yeah, looks like about
		  a hundred twenty, maybe a hundred forty. ";
	}
	else "You thumb through the roll. One hundred thirty-seven dollars,
	      just like last time you counted. ";
    }
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) = {
	if (dobj != stolen_money)
	    "You can't put anything in the roll of bills. ";
	else dobj.doPutIn(actor, self);
    }
    ioSynonym('PutIn') = 'PutOn'
;

parents_bath: houseRm
    isBathroom = true
    sinkObj = parents_bath_sink
    nameStr = 'mom and Frank\'s bathroom'
    j_sdesc = "Mom and Frank\'s Bathroom"
    f_sdesc = "Your Bathroom"
    j_ldesc = "You don't know why Frank has this big thing about you
	       not using his and mom's bathroom. It's not like it's
	       any big secret deal. You can leave it to the south. "
    f_ldesc = "One of the fluorescent lights is flickering. Probably the
	       balance is out of whack. Anyway, it gives you a headache. You
	       can leave to the south. "
    exits = 'south'
    south = parents_bedroom
    out = parents_bedroom
;

parents_light: fixeditem
    isThem = true
    noun = 'light' 'lights'
    adjective = 'fluorescent' 'flickering'
    location = parents_bath
    sdesc = "fluorescent lights"
    j_ldesc = "There's a light that's out of whack. It flickers on
	       and off. "
    f_ldesc = "One of the fluorescent lights keeps flickering on and off,
	     and its buzzing puts your teeth on edge. "
    dobjGen(a, v, i, p) = {
        if (v != askVerb && v != tellVerb && v != inspectVerb) {
	    if (a == jeanieMe)
		"The lights are too high above you. ";
            else "You won't be reaching the lights without a ladder. ";
            exitobj;
        }
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
    verDoFix(actor) = {
	if (actor == jeanieMe)
	    "Like you'd know the first thing about fixing the lights. ";
	else if (actor == frankMe)
	    "It's on your to-do list. Right now the toaster's priority
	     one. ";
    }
;

parents_bath_sink: fixeditem
    noun = 'sink'
    adjective = 'porcelain' 'old'
    location = parents_bath
    sdesc = "porcelain sink"
    j_ldesc = "The sink's really clean. "
    f_ldesc = "The sink in your bathroom's exactly the same as all
	       the other ones in the house&mdash;old. "
    verDoTurnon(actor) = {
	if (actor == jeanieMe)
	    "No way you're going to risk splashing water on you. ";
	else "Nah. Your hands aren't that dirty. ";
    }
    verDoTurnoff(actor) = { "The sink's not on. "; }
    doSynonym('Turnon') = 'Use'
    verDoLookunder(actor) = {
	if (actor != jeanieMe || !actor.lookingForBillfold)
	    pass verDoLookunder;
    }
    doLookunder(actor) = {
	"There's no way your billfold could've gotten under there,
	 but you look anyway. It's not there. ";
	if (!actor.mentionedKitchenAgain) {
	    actor.mentionedKitchenAgain = true;
	    "Besides, you're pretty sure you didn't take your
	     billfold out of the kitchen, and Frank's given up
	     picking up after you. ";
	}
    }
;

parents_bath_bath: fixeditem
    noun = 'bath' 'tub' 'bathtub'
    adjective = 'clawfoot'
    location = parents_bath
    sdesc = "bath"
    j_ldesc = "It'd be great if you had a bath. You'd be taking
	       bubble baths like every night. "
    f_ldesc = "You're more of a shower kind of guy, but Deb really
	       wanted this clawfoot bath. "
    takedesc = "It's way too heavy for you. "
    verDoTake(actor) = {
	if (takeVerb.takeTyped) {
	    if (actor == jeanieMe)
		"There's no way you could take a bath in this thing
		 without Frank finding out. ";
	    else "You already bathed this morning. ";
	}
	else pass verDoTake;
    }
    verDoEnter(actor) = {
	if (actor == jeanieMe)
	    "There's no way you could take a bath in this thing
	     without Frank finding out. ";
	else "You already bathed this morning. ";
    }
    doSynonym('Enter') = 'Board' 'Turnon'
;

parents_bath_toilet: fixeditem
    noun = 'toilet' 'crapper' 'commode' 'john' 'loo'
    adjective = 'porcelain'
    location = parents_bath
    j_sdesc = "toilet"
    f_sdesc = "commode"
    j_ldesc = "A porcelain toilet. "
    f_ldesc = "A porcelain commode. "
    verDoEnter(actor) = {
	"You don't have to go right now. ";
    }
    doSynonym('Enter') = 'Siton' 'Use' 'Open'
    verDoFlush(actor) = {
	"You flush it and watch the water swirl around. ";
    }
;

// So the player can use the bathroom
parents_bath_bathroom: decoration
    noun = 'bathroom'
    location = parents_bath
    sdesc = "bathroom"
    ldesc = {
	execCommand(actorObject(), lookVerb);
    }
    doUse -> parents_bath_toilet
    doEnter -> parents_bath_toilet
;
