/*
clayton		1981	wrote getpar
hale		1982	?  INPAR?
JFC		1-22-83	stdin copied to stdout and parsed first.
ron		1-28-83 allow for multiple names of a variable
ron		2-1-83  does not count entries where there is no
			argument as being found
ron		2-2-83  changed the stdin read from character by character
			to line by line
ron		2-4-83	altered the stdin read to not keep lines starting
			with '#'
JFC		2-7-83  hetch introduced
ron		2-8-83  split up the text file of getpar and fetch
ron		2-15-83 added count_found so that the routines in fetch and
			getpar would use the same found.
ron		2-23-83 added save_get and getm_getsav so that only the last
			parameter is used.
ron		2-25-83 fixed getpar so that it can do recursive par= in
			par files. The limit in depth of the calls is
			MAXPARLEVEL.
stew		3-5-83  defined getpar() as alias for getpar_()
stew		7-14-83 added err and perror diagnostics
stew		9-6-87  use <varargs> for portability to Sun-4 and Cray-2
joe		2-25-88 Make the other getpar synonyms share the same code
*/

#ifndef GETPARSYNONYM
#define GETPARSYNONYM getpar
#endif  GETPARSYNONYM

typedef union { int *i; float *f; double *g ; char *s; } MIXED;

#include <varargs.h>

/*VARARGS0*/
int
GETPARSYNONYM(va_alist /*name,type,ptr*/)
va_dcl
{
	char *name, *type;
	va_list apdum;
	int rc;
	MIXED var;
	extern int getch_();
	va_start(apdum);
	name = va_arg(apdum,char *);
	type = va_arg(apdum,char *);
	switch(type[0]) {
	case 'g': var.g = va_arg(apdum,double *); break;
	case 's': var.s = va_arg(apdum,char *); break;
	case 'f': case 'r': var.f = va_arg(apdum,float *); break;
	default: var.i = va_arg(apdum,int *); break;
	}
	va_end(apdum);
	switch(type[0]) {
	case 'g': rc = getch_(name,type,var.g); break;
	case 's': rc = getch_(name,type,var.s); break;
	case 'f': case 'r': rc = getch_(name,type,var.f); break;
	default: rc = getch_(name,type,var.i); break;
	}
	return (rc);
}
