/*
 * simple RPC RTMP test
 *
 * Created: David Hornsby, Melbourne University <djh@munnari.OZ.AU>
 *
 */

#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <netat/appletalk.h>
#include <rpc/rpc.h>
#include "aarpd.h"

extern u_char *rtmp_getbaddr_clnt();
extern u_char *rtmp_setbaddr_clnt();

extern u_short	this_net,	bridge_net,	nis_net,	async_net;
extern u_char	this_node,	bridge_node,	nis_node;
extern char	this_zone[34],	async_zone[34],	interface[50];

main(argc, argv)
int argc;
char **argv;
{
  CLIENT *cl;
  u_char *addr;
  AddrBlock baddr;
#ifdef pyr
  int sock;
  struct timeval tv;
  struct sockaddr_in sin;
#endif pyr

#ifdef pyr
  sin.sin_family = AF_INET;
  sin.sin_port = 0;
  bzero(sin.sin_zero, sizeof(sin.sin_zero));
  sin.sin_addr.s_addr = htonl(0x7f000001);
  sock = RPC_ANYSOCK;
  tv.tv_sec = 5;
  tv.tv_usec = 0;
  cl = clntudp_create(&sin, AARPDPROG, AARPDVERS, tv, &sock);
#else pyr
  cl = clnt_create("localhost", AARPDPROG, AARPDVERS, "udp");
#endif pyr
  if (cl == NULL) {
    clnt_pcreateerror("localhost");
    exit(1);
  }

  if (argc == 3) {
    baddr.net = atoi(argv[1]);
    baddr.node = atoi(argv[2]);
    addr = rtmp_setbaddr_clnt(&baddr, cl);
    if (addr == NULL) {
      clnt_perror(cl, "localhost");
      exit(1);
    }
    printf("set bridge addr %x.%x %x %x\n", addr[0], addr[1], addr[2], addr[3]);
    addr = rtmp_getbaddr_clnt(&baddr, cl);
    if (addr == NULL) {
      clnt_perror(cl, "localhost");
      exit(1);
    }
    printf("get bridge addr %x.%x %x %x\n", addr[0], addr[1], addr[2], addr[3]);
  }

  openetalkdb(NULL);

  printf("zone %s this %d.%d gw %d.%d nis %d.%d intf %s\n", 
	 this_zone, this_net, this_node, bridge_net,
	 bridge_node, nis_net, nis_node, interface);
}
