/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.BigInt;
import java.io.ByteArrayInputStream;
import java.io.IOException;

class DerInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    DerInputBuffer(byte[] byArray) {
        super(byArray);
    }

    DerInputBuffer(byte[] byArray, int n, int n2) {
        super(byArray);
    }

    DerInputBuffer dup() {
        try {
            DerInputBuffer derInputBuffer = (DerInputBuffer)this.clone();
            derInputBuffer.mark(Integer.MAX_VALUE);
            return derInputBuffer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException(cloneNotSupportedException.toString());
        }
    }

    boolean equals(DerInputBuffer derInputBuffer) {
        int n = this.available();
        if (this == derInputBuffer) {
            return true;
        }
        if (derInputBuffer.available() != this.available()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.buf[this.pos + n2] != derInputBuffer.buf[derInputBuffer.pos + n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof DerInputBuffer) {
            return this.equals((DerInputBuffer)object);
        }
        return false;
    }

    byte[] getBitString() {
        if (this.pos >= this.count || this.buf[this.pos] != 0) {
            return null;
        }
        int n = this.available();
        byte[] byArray = new byte[n - 1];
        System.arraycopy(this.buf, this.pos + 1, byArray, 0, n - 1);
        this.pos = this.count;
        return byArray;
    }

    BigInt getUnsigned(int n) throws IOException {
        if (n > this.available()) {
            throw new IOException("short read, getInteger");
        }
        if (this.buf[this.pos] == 0) {
            --n;
            this.skip(1L);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.pos, byArray, 0, n);
        this.skip(n);
        return new BigInt(byArray);
    }

    int peek() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    void truncate(int n) throws IOException {
        if (n > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + n;
    }
}

