/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class DESKeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom random = null;
    private static final byte[][] WEAK_KEYS = new byte[][]{{1, 1, 1, 1, 1, 1, 1, 1}, {-2, -2, -2, -2, -2, -2, -2, -2}, {31, 31, 31, 31, 31, 31, 31, 31}, {-32, -32, -32, -32, -32, -32, -32, -32}, {1, -2, 1, -2, 1, -2, 1, -2}, {31, -32, 31, -32, 14, -15, 14, -15}, {1, -32, 1, -32, 1, -15, 1, -15}, {31, -2, 31, -2, 14, -2, 14, -2}, {1, 31, 1, 31, 1, 14, 1, 14}, {-32, -2, -32, -2, -15, -2, -15, -2}, {-2, 1, -2, 1, -2, 1, -2, 1}, {-32, 31, -32, 31, -15, 14, -15, 14}, {-32, 1, -32, 1, -15, 1, -15, 1}, {-2, 31, -2, 31, -2, 14, -2, 14}, {31, 1, 31, 1, 14, 1, 14, 1}, {-2, -32, -2, -32, -2, -15, -2, -15}};
    private static final byte[] PARITY_BIT_MASK = new byte[]{-128, 64, 32, 16, 8, 4, 2};

    protected SecretKey engineGenerateKey() {
        DESKey dESKey = null;
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        try {
            byte[] byArray = new byte[8];
            do {
                this.random.nextBytes(byArray);
                DESKeyGenerator.setParityBit(byArray, 0);
            } while (this.isWeak(byArray));
            dESKey = new DESKey(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {}
        return dESKey;
    }

    protected void engineInit(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("DES key generation does not take any parameters");
    }

    private boolean isWeak(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        int n = 0;
        while (n < WEAK_KEYS.length) {
            boolean bl = true;
            int n2 = 0;
            while (n2 < byArray.length && bl) {
                if (WEAK_KEYS[n][n2] != byArray[n2]) {
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                return bl;
            }
            ++n;
        }
        return false;
    }

    static void setParityBit(byte[] byArray, int n) {
        if (byArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < 8) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < PARITY_BIT_MASK.length) {
                if ((byArray[n2 + n] & PARITY_BIT_MASK[n4]) == PARITY_BIT_MASK[n4]) {
                    ++n3;
                }
                ++n4;
            }
            byArray[n2 + n] = n3 & true ? (byte)(byArray[n2 + n] & 0xFFFFFFFE) : (byte)(byArray[n2 + n] | 1);
            ++n2;
        }
    }
}

