/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import sunw.hotjava.doc.DocumentEvent;
import sunw.hotjava.doc.ToolTipInfo;
import sunw.hotjava.ui.TimedMessage;
import sunw.hotjava.ui.TimedMessageOwner;

public class ImageToolTip
implements TimedMessageOwner {
    private String message;
    private TimedMessage tm;
    private static int vertShift = 20;
    private static int horizShift;

    public ImageToolTip(String string) {
        this.message = string;
    }

    public void processDocumentEvent(DocumentEvent documentEvent) {
        switch (documentEvent.getID()) {
            case 1033: {
                if (this.tm != null) break;
                ToolTipInfo toolTipInfo = (ToolTipInfo)documentEvent.getArgument();
                this.tm = this.makeNewMessage(toolTipInfo);
                return;
            }
            case 1034: 
            case 1035: {
                if (this.tm == null) break;
                this.tm.processDocumentEvent(documentEvent);
                return;
            }
        }
    }

    public void removeTimedMessage() {
        this.tm = null;
    }

    private TimedMessage makeNewMessage(ToolTipInfo toolTipInfo) {
        Frame frame = this.findFrame(toolTipInfo.source);
        Point point = toolTipInfo.point;
        Point point2 = toolTipInfo.source.getLocationOnScreen();
        point.x += point2.x + horizShift;
        point.y += point2.y + vertShift;
        return new TimedMessage(frame, this.message, point, toolTipInfo.source, this);
    }

    private Frame findFrame(Component component) {
        Component component2 = component;
        while (!(component2 instanceof Frame)) {
            component2 = component2.getParent();
        }
        return (Frame)component2;
    }
}

