/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentRef;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.SelfCleaningHashtable;

public class DocumentCache {
    static final SelfCleaningHashtable hash = new SelfCleaningHashtable();

    public static boolean seenDocument(URL uRL) {
        return hash.get(uRL) != null;
    }

    public static synchronized void putDocument(Document document) {
        URL uRL = document.getURL();
        if (uRL != null) {
            String string = uRL.toExternalForm();
            if (string.indexOf(63) < 0 && string.indexOf("cgi-bin", 0) < 0 && !Boolean.getBoolean("hotjava.documents.disablecache")) {
                hash.put(uRL, (Object)new DocumentRef(uRL, document));
            }
            DocumentCache.putURLPool(string);
        }
    }

    public static Document getDocument(URL uRL) {
        return DocumentCache.getDocument(uRL, null);
    }

    public static synchronized Document getDocument(URL uRL, URL uRL2) {
        Date date;
        DocumentRef documentRef = (DocumentRef)((Object)hash.get(uRL));
        if (documentRef == null) {
            documentRef = new DocumentRef(uRL, uRL2);
            Document document = (Document)documentRef.get();
            DocumentCache.putDocument(document);
            return document;
        }
        DocumentCache.putURLPool(uRL.toExternalForm());
        Document document = (Document)documentRef.get();
        if (document.getPragma() != null && document.getPragma().indexOf("no-cache") >= 0) {
            documentRef = new DocumentRef(uRL, uRL2);
            document = (Document)documentRef.get();
            DocumentCache.putDocument(document);
            return document;
        }
        if (document != null && (date = document.getExpirationDate()) != null && date.getTime() <= System.currentTimeMillis()) {
            documentRef.flush();
            return (Document)documentRef.get();
        }
        return document;
    }

    private static void putURLPool(String string) {
        Globals.pool.add(string);
    }

    public static Enumeration getDocuments() {
        return hash.elements();
    }

    public static void removeDocument(URL uRL) {
        hash.remove(uRL);
    }
}

