//---------------------------------------------
//               S I M P A C K + +
//            Simulation Tool Package
//        Copyright 1992, Paul A. Fishwick
//---------------------------------------------

#include <stream.h>
#include <math.h>

class logistic2 {
  private:
     float a, out[3], in[3];
     int delta_time;
  public:
    logistic2();
    void next_state();
    void update();
    void print_time();
  };

int simtime;

main()
{
  logistic2 log2;
  
  while (simtime <= 100) {
   log2.next_state();
   log2.update(); 
   // output simtime,x
   log2.print_time(); 
  } // end while 
} // end main 

logistic2::logistic2()
{
  out[1] = 0.8;
  out[2] = 0.8;
  delta_time = 1;
  a = 1.5;
}

void logistic2::next_state()
{ 
// Calculate state: x(t) = a*x(t-1)(1.0 - x(t-2)) 
in[1] = out[2];
in[2] = a*out[2]*(1.0 - out[1]);
}
 
void logistic2::update()
{
 int i;
 for(i=1;i<=2;i++)
   out[i] = in[i];
 simtime += delta_time;
}

void logistic2::print_time()
{
  cout<<simtime<<"   "<<in[2]<<"\n";
}
