/************************************************************************\
*                                                                        *
*  GS: A Generalized, stochastic petri net Simulator                     *
*      V0.01      March 1989      Andreas Nowatzyk (agn@unh.cs.cmu.edu)  *
*      Carnegie-Mellon Univerity, School of Computer Science             *
*      Schenley Park, Pittsburgh, PA 15213                               *
*                                                                        *
\************************************************************************/

%%
[ \n\t]*			; /* ignore white space		*/
"/*".*"*/"			; /* skip comments (\n problem) */
^"#".*\n			{if (2 != sscanf (&yytext[1],"%d%s", &yylineno, src_file))
				     yyerror ("malformed cpp-directive");
				}

^"%end"				{return END;}
rate[ \n\t]*"="			{return RATE;}
"#marks"[ \n\t]*"="		{return MARKS;}
dep[ \n\t]*"="			{return DEPEND;}
det|deterministic		{return DET;}
imm|immediate			{return IMM;}
exp|exponential			{return EXP;}
normal				{return NORM;}
bimodal				{return BIMOD;}
TRANS				{return TRANS;}
PLACE				{return PLACE;}
RESULT				{return RESULT;}
PARAM				{return PARAM;}
Prob				{return PROB;}
Expt				{return EXP;}
Dwell				{return DWT;}
Fire				{return FIRE;}

[A-Za-z_][A-Za-z0-9_]*		{yylval.SYM = (char *) malloc (yyleng + 1);
				 strncpy (yylval.SYM, yytext, yyleng);
				 yylval.SYM[yyleng] = 0;
				 return NAME;}

[-+.0-9edED]+			{if (1 != sscanf(yytext, "%lf", &(yylval.VALUE))) REJECT;
				 return VAL;}

"=="|"!="|">="|"<="|">"|"<"	{yylval.SYM = (char *) malloc (yyleng + 1);
				 strncpy (yylval.SYM, yytext, yyleng);
				 yylval.SYM[yyleng] = 0;
				 return REL_OP;}

";"				{return TERM;}
","				{return SEP;}
":"				{return COL;}
"/"				{return COND;}
"-->"				{return NEXT;}
"!"				{return NOT;}
"{"				{return OP_BR;}
"}"				{return CL_BR;}
"("				{return OP_PAR;}
")"				{return CL_PAR;}
"&&"				{return AND;}
"||"				{return OR;}
"#"				{return HASH;}
"+"				{return PLUS;}
"-"				{return MINUS;}

%%
