/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/server/RCS/cdb_setup.c,v $
 *
 *
 *  MODULE NAME:    cdb_setup.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <cdc.h>
#include <cdc_db.h>
#include <string.h>

extern int optind, opterr;
extern char *optarg;
extern char *getpassword();

#define MIN_PASSWORD_LENGTH  6

int     cdc_debug = 0;
char   *progname, *rindex();

main(argc, argv)
    char   *argv[];
{
    char    *cp, *pw;
    int  getuid(), c, errflg = 0, admin_rights = 2, aflag = 0, pid, status, i;
    int  single_CA_password = 0, cdcconf_exists = 0;
    char *database = NULL, *enroll_file = NULL;
    char admin[ANAME_SZ], answ[10];
    char ca_password[40], admin_password[40], cdc_password[40];
    char server[ANAME_SZ], linebuf[200];
    char domainprefix[FULLNAME_SZ], last_ava[ANAME_SZ], last_rdn[ANAME_SZ];
    char parentdomainprefix[FULLNAME_SZ];
    char domainkeyname[ANAME_SZ], adminkeyname[ANAME_SZ], cakeyname[ANAME_SZ];
    char server_ca_name[ANAME_SZ], admin_ca_name[ANAME_SZ];
    char enrollfilename[ANAME_SZ];
    char ca_name[ANAME_SZ], prin_name[ANAME_SZ], op[ANAME_SZ];
    FILE *f;
    
    progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;
    enrollfilename[0] = '\0';
    opterr = 0;
    while ((c=getopt(argc, argv, "f:a")) != EOF)
      switch(c) {
	case 'f' :
	  enroll_file = optarg;
	  break;
	case 'a' :
	  aflag = 1;
	  admin_rights = 0;
	  break;
	case '?' :
	  errflg++;
	}

    printf("Welcome to the SPX CDC Setup program\n\n");
    printf("This utility will create a new domain Certification Authority\n");
    printf("hierarchy\n\n");

    strcpy(domainprefix, get_domain_name(NULL));
    if (domainprefix[0] != '\0') {
      cdcconf_exists = 1;
      printf("Default domain prefix is '%s'. correct? [y] ", domainprefix);
      gets(answ);
    } else answ[0] = 'n';

    if ((answ[0] == 'n') || (answ[0] == 'N')) {
      cdcconf_exists = 0;
enter_domain:

      printf("\nEnter your domain prefix : ");
      gets(domainprefix);
      if (strlen(domainprefix) == 0)  exit(0);
      printf("\nYour domain prefix entered is '%s'.  correct? [y] ", domainprefix);
      gets(answ);
      if ((answ[0] == 'n') || (answ[0] == 'N')) goto enter_domain;
    }

    i = strlen(domainprefix);
    while (domainprefix[--i] != '=');
    strcpy(last_ava, &domainprefix[++i]);

    while (domainprefix[--i] != '/');
    strcpy(last_rdn, &domainprefix[++i]);

    strcpy(parentdomainprefix, domainprefix);
    i--;
    parentdomainprefix[i] = '\0';

    printf("\nWould you like to create new keys [y] ? ");
    gets(answ);
    if ((answ[0] != 'n') && (answ[0] != 'N')) {
      printf("\nWe will create 512-bit RSA keys and X.509 certificates for the\n");
      printf("domain level CA, Users CA, Servers CA, Administrator principal,\n");

      printf("and CDC server principal.\n\n");
      printf("Note that you will need to remember at most 5 passwords (1 for each\n");
      printf("principal).  However, if you choose to use the same password for all\n");
      printf("your CAs, you will need to remember and type fewer passwords during\n");
      printf("setup.  This isn't a security threat as long as the passwords you\n");
      printf("enter are not 'easily guessable'.\n\n");

      printf("Would you like to use the convenient mode (i.e., same password\n");
      printf("for all your CAs) ? [y] ");
      gets(answ);
      if ((answ[0] == 'n') || (answ[0] == 'N'))  single_CA_password = 0;
      else single_CA_password = 1;

      if (single_CA_password) {
      new_ca_password:
	printf("\nEnter your CA password: ");
	fflush(stdout);
	pw = getpassword("");
	if (strlen(pw) < MIN_PASSWORD_LENGTH) {
	  printf("Length error, (must be at least %d char) please re-enter: ", MIN_PASSWORD_LENGTH);
	  fflush(stdout);
	  pw = getpassword("");
	  if (strlen(pw) < MIN_PASSWORD_LENGTH) {
	    printf("Password length error.");
	    memset(pw, 0, strlen(pw));
	    goto new_ca_password;
	  }
	}
	strcpy(ca_password, pw);
	printf("Verifying, please re-enter: ");
	fflush(stdout);
	pw = getpassword("");
	if (strcmp(ca_password, pw) != 0) {
	  printf("Verification error\n");
	  memset(ca_password, 0, sizeof(ca_password));
	  memset(pw, 0, strlen(pw));
	  goto new_ca_password;
	}
	memset(pw, 0, strlen(pw));
      }

      printf("\nCreating the domain level CA key ... \n");
      cp = rindex(domainprefix, '=');
      cp++;
      strcpy(domainkeyname, cp);
      printf("Using '%s' as the file name to store domain's key\n", domainkeyname);

      if ((pid = fork()) == 0) {
	if (single_CA_password)
	  execlp("createkey", "createkey", "-a", "-n", last_ava, "-w", ca_password, domainkeyname, (char *) 0);
	else
	  execlp("createkey", "createkey", "-a", "-n", last_ava, domainkeyname, (char *) 0);
	exit(-1);
      }
      wait(&status);
      if (status != 0) {
        printf("unable to find createkey in execution path\n");
	exit(0);
      }

      printf("\n\nCreating the Users CA key ... in Users_privkey, Users_pubkey\n");
      if ((pid = fork()) == 0) {
	if (single_CA_password)
	  execlp("createkey", "createkey", "-a", "-n", "Users", "-w", ca_password, "Users", (char *) 0);
	else
	  execlp("createkey", "createkey", "-a", "-n", "Users", "Users", (char *) 0);
	exit(-1);
      }
      wait(&status);

      printf("\n\nCreating the Servers CA key ... in Servers_privkey, Servers_pubkey\n");
      if ((pid = fork()) == 0) {
	if (single_CA_password)
	  execlp("createkey", "createkey", "-a", "-n", "Servers", "-w", ca_password, "Servers", (char *) 0);
	else
	  execlp("createkey", "createkey", "-a", "-n", "Servers", "Servers", (char *) 0);
	exit(-1);
      }
      wait(&status);

      printf("\n\nCreating the administrator's key ... (select a new password)\n");
    new_admin_password:
      printf("\nEnter your administrator's password: ");
      fflush(stdout);
      pw = getpassword("");
      if (strlen(pw) < MIN_PASSWORD_LENGTH) {
	printf("Length error, (must be at least %d char) please re-enter: ", MIN_PASSWORD_LENGTH);
	fflush(stdout);
	pw = getpassword("");
	if (strlen(pw) < MIN_PASSWORD_LENGTH) {
	  printf("Password length error.");
	  memset(pw, 0, strlen(pw));
	  goto new_admin_password;
	}
      }
      strcpy(admin_password, pw);
      printf("Verifying, please re-enter: ");
      fflush(stdout);
      pw = getpassword("");
      if (strcmp(admin_password, pw) != 0) {
	printf("Verification error\n");
	memset(admin_password, 0, sizeof(admin_password));
	memset(pw, 0, strlen(pw));
	goto new_admin_password;
      }
      memset(pw, 0, strlen(pw));

      printf("Enter the local file name to store administrator's key : ");
      gets(adminkeyname);
      if ((pid = fork()) == 0) {
	execlp("createkey", "createkey", "-w", admin_password, adminkeyname, (char *) 0);
	exit(-1);
      }
      wait(&status);

      printf("\n\nCreating the cdc's key ... (select a new password)\n");

    new_cdc_password:
      printf("\nEnter your cdc's password: ");
      fflush(stdout);
      pw = getpassword("");
      if (strlen(pw) < MIN_PASSWORD_LENGTH) {
	printf("Length error, (must be at least %d char) please re-enter: ", MIN_PASSWORD_LENGTH);
	fflush(stdout);
	pw = getpassword("");
	if (strlen(pw) < MIN_PASSWORD_LENGTH) {
	  printf("Password length error.");
	  memset(pw, 0, strlen(pw));
	  goto new_cdc_password;
	}
      }
      strcpy(cdc_password, pw);
      printf("Verifying, please re-enter: ");
      fflush(stdout);
      pw = getpassword("");
      if (strcmp(cdc_password, pw) != 0) {
	printf("Verification error\n");
	memset(cdc_password, 0, sizeof(cdc_password));
	memset(pw, 0, strlen(pw));
	goto new_cdc_password;
      }
      memset(pw, 0, strlen(pw));

      if ((pid = fork()) == 0) {
	execlp("createkey", "createkey", "-n", "cdc", "-w", cdc_password, "cdc", (char *) 0);
	exit(-1);
      }
      wait(&status);
    } else {
      printf("Enter the local file name to store domain's key : ");
      gets(domainkeyname);
      printf("Enter the local file name to store administrator's key : ");
      gets(adminkeyname);
    }
    printf("\n\nNow we will create X.509 certificates\n");

    printf("\n\nCreating principal certificate for Users CA ... \n");
    if ((pid = fork()) == 0) {
      if (single_CA_password)
	execlp("createcertif", "createcertif", "-w", ca_password, "-d", parentdomainprefix, domainkeyname, "Users", (char *) 0);
      else
	execlp("createcertif", "createcertif", "-d", parentdomainprefix, domainkeyname, "Users", (char *) 0);
      exit(-1);
    }
    wait(&status);
    if (status != 0) {
      printf("unable to find createcertif in execution path\n");
      exit(0);
    }

    printf("\n\nCreating principal certificate for Servers CA ... \n");
    if ((pid = fork()) == 0) {
      if (single_CA_password)
	execlp("createcertif", "createcertif", "-w", ca_password, "-d", parentdomainprefix, domainkeyname, "Servers", (char *) 0);
      else
	execlp("createcertif", "createcertif", "-d", parentdomainprefix, domainkeyname, "Servers", (char *) 0);
      exit(-1);
    }
    wait(&status);

    printf("\n\nCreating TA certificate for Users CA ... \n");
    if ((pid = fork()) == 0) {
      if (single_CA_password)
	execlp("createcertif", "createcertif", "-t", "-w", ca_password, "-d", parentdomainprefix, "Users", domainkeyname, (char *) 0);
      else
	execlp("createcertif", "createcertif", "-t", "-d", parentdomainprefix, "Users", domainkeyname, (char *) 0);
      exit(-1);
    }
    wait(&status);

    printf("\n\nCreating TA certificate for Servers CA ... \n");
    if ((pid = fork()) == 0) {
      if (single_CA_password)
	execlp("createcertif", "createcertif", "-t", "-w", ca_password, "-d", parentdomainprefix, "Servers", domainkeyname, (char *) 0);
      else
	execlp("createcertif", "createcertif", "-t", "-d", parentdomainprefix, "Servers", domainkeyname, (char *) 0);
      exit(-1);
    }
    wait(&status);

    printf("\n\nCreating cross certificate from Users CA to Servers CA... \n");
    if ((pid = fork()) == 0) {
      if (single_CA_password)
	execlp("createcertif", "createcertif", "-x", "-w", ca_password, "-d", domainprefix, "Users", "Servers", (char *) 0);
      else
	execlp("createcertif", "createcertif", "-x", "-d", domainprefix, "Users", "Servers", (char *) 0);
      exit(-1);
    }
    wait(&status);

    printf("\n\nCreating cross certificate from Servers CA to Users CA... \n");
    if ((pid = fork()) == 0) {
      if (single_CA_password)
	execlp("createcertif", "createcertif", "-x", "-w", ca_password, "-d", domainprefix, "Servers", "Users", (char *) 0);
      else
	execlp("createcertif", "createcertif", "-x", "-d", domainprefix, "Servers", "Users", (char *) 0);
      exit(-1);
    }
    wait(&status);

    printf("\n\nCreating principal certificate for adminstrator ... \n");
    if ((pid = fork()) == 0) {
      if (single_CA_password)
	execlp("createcertif", "createcertif", "-w", ca_password, "-d", domainprefix, "Users", adminkeyname, (char *) 0);
      else
	execlp("createcertif", "createcertif", "-d", domainprefix, "Users", adminkeyname, (char *) 0);
      exit(-1);
    }
    wait(&status);

    printf("\n\nCreating principal certificate for CDC server ... \n");
    if ((pid = fork()) == 0) {
      if (single_CA_password)
	execlp("createcertif", "createcertif", "-w", ca_password, "-d", domainprefix, "Servers", "cdc", (char *) 0);
      else
	execlp("createcertif", "createcertif", "-d", domainprefix, "Servers", "cdc", (char *) 0);
      exit(-1);
    }
    wait(&status);

    printf("\n\nCreating TA certificate for administrator ... \n");
    if ((pid = fork()) == 0) {
      if (single_CA_password)
	execlp("createcertif", "createcertif", "-t", "-w", admin_password, "-d", domainprefix, adminkeyname, "Users", (char *) 0);
      else
	execlp("createcertif", "createcertif", "-t", "-d", domainprefix, adminkeyname, "Users", (char *) 0);
      exit(-1);
    }
    wait(&status);

    printf("\n\nCreating TA certificate for CDC server ... \n");
    if ((pid = fork()) == 0) {
      if (single_CA_password)
	execlp("createcertif", "createcertif", "-t", "-w", cdc_password, "-d", domainprefix, "cdc", "Servers", (char *) 0);
      else
	execlp("createcertif", "createcertif", "-t", "-d", domainprefix, "cdc", "Servers", (char *) 0);
      exit(-1);
    }
    wait(&status);

    bzero(ca_password, sizeof(ca_password));
    bzero(admin_password, sizeof(admin_password));
    bzero(cdc_password, sizeof(cdc_password));

    printf("\n\nNow we will create the enrollment file\n");
    if (enroll_file == NULL) {
      printf("\nEnter the local enrollment file name : ");
      gets(enrollfilename);
    } else strcpy(enrollfilename, enroll_file);
    if ((f = fopen(enrollfilename, "w")) == NULL) {
      printf("unable to open '%s' file to initialize database\n", enrollfilename);
      exit(-1);
    }
    fprintf(f, "Users %s PRINCIPAL\n", adminkeyname);
    fprintf(f, "Servers cdc PRINCIPAL\n");
    fprintf(f, ". Users CA\n");
    fprintf(f, ". Servers CA\n");
    fprintf(f, "Servers Users TACERTIF\n");
    fprintf(f, "Users Servers TACERTIF\n");
    close(f);

    printf("Setup complete.\n");

    if (!cdcconf_exists) {
      printf("\nReminder:  /etc/cdc.conf should contain your domain prefix\n");
      printf("\t\t'%s'\n", domainprefix);
    }
    printf("\nYou need to enter the following command as superuser to\n");
    printf("initialize the CDC database\n");
    printf("\tcdb_init -f %s\n\n", enrollfilename);
    exit(0);
}
