/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/str_to_rdn.c,v $
 *
 *
 *  MODULE NAME:    str_to_rdn.c
 *
 *
 *  AUTHORS:
 *
 *      J. Tardo
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include "SPHINX-types.h"

#define MAX_BUF 255

int abbrev_to_oid(printable_at, new_at)
char *printable_at;
char *new_at;
{
#ifdef sun
  if ((strcmp(printable_at, "C") == 0) || (strcmp(printable_at, "c") == 0)) {
#else
  if (strcasecmp(printable_at, "C") == 0) {
#endif
    strcpy(new_at,"2.5.4.6");
    return(1);
  }
#ifdef sun
  if ((strcmp(printable_at, "O") == 0) || (strcmp(printable_at, "o") == 0)) {
#else
  if (strcasecmp(printable_at, "O") == 0) {
#endif
    strcpy(new_at,"2.5.4.10");
    return(1);
  }
#ifdef sun
  if ((strcmp(printable_at, "OU") == 0) || (strcmp(printable_at, "ou") == 0)) {
#else
  if (strcasecmp(printable_at, "OU") == 0) {
#endif
    strcpy(new_at,"2.5.4.11");
    return(1);
  }
#ifdef sun
  if ((strcmp(printable_at, "CN") == 0) || (strcmp(printable_at, "cn") == 0)) {
#else
  if (strcasecmp(printable_at, "CN") == 0) {
#endif
    strcpy(new_at,"2.5.4.3");
    return(1);

  }
#ifdef sun
  if ((strcmp(printable_at, "DC") == 0) || (strcmp(printable_at, "dc") == 0)) {
#else
  if (strcasecmp(printable_at, "DC") == 0) {
#endif
    strcpy(new_at,"0.9.2342.19200300.100.1.25");
    return(1);
  }

  return(0);   /* syntax error for attribute type */
}

int next_ava(attrib,value,input)
char *attrib, *value, *input;
{
   char *ptr=input;

   for(;(*ptr!='\0') && isspace(*ptr); ptr++);
   if (*ptr == '\0') return(0);

   for(;(*ptr != '\0')&&(*ptr != '='); *attrib++ = *ptr++ );
   if (*ptr == '\0') return(0);
   ptr++;
   *attrib-- = '\0';
   for(;isspace(*attrib);*attrib-- = '\0');

   for(;(*ptr!='\0') && isspace(*ptr); ptr++);
   if (*ptr == '\0') return(0);

   if (*ptr == '"') {
     ptr++;
     for(;(*ptr != '\0')&&(*ptr != '"'); *value++ = *ptr++ );
     *value-- = '\0';
     ptr++;
     for(;(*ptr!='\0') && isspace(*ptr); ptr++);
   } else {
     for(;(*ptr != '\0')&&(*ptr != '/'); *value++ = *ptr++ );
     *value-- = '\0';
   }
   for(;isspace(*value);*value-- = '\0');

   for(*input++ = *ptr++; *ptr != '\0'; *input++ = *ptr++);
   *input = '\0';

   return(1);
}


/* 
  Inserts rdn into set in proper place.  Attribute type cannot be a duplicate.  
*/
int add_RDN_CaseIgnoreString(atype,av,rdn_set)
char *atype, *av;
struct type_SPHINX_RDN **rdn_set;
{
    OID at_oid = oid_cpy(str2oid(atype));
    OID CN_oid = oid_cpy(str2oid("2.5.4.3"));

    struct type_SPHINX_RDN *rdn;

    for(*rdn_set;*rdn_set;rdn_set = &((*rdn_set)->next))
        if (oid_cmp((*rdn_set)->AttributeValueAssertion->type, CN_oid) == 0)  goto syntax_error;
	else if (oid_cmp((*rdn_set)->AttributeValueAssertion->type, at_oid)>0)
		break;
	else if (oid_cmp((*rdn_set)->AttributeValueAssertion->type, at_oid)==0)
	        if (strcmp(atype, "2.5.4.11") != 0)  goto syntax_error;

    for (*rdn_set;*rdn_set;rdn_set = &((*rdn_set)->next))
      if (oid_cmp((*rdn_set)->AttributeValueAssertion->type, CN_oid) == 0)  goto syntax_error;
    rdn = (struct type_SPHINX_RDN *) malloc(sizeof  *rdn);
    rdn->AttributeValueAssertion =
	      (struct type_SPHINX_AttributeValueAssertion *)
			malloc(sizeof(struct type_SPHINX_AttributeValueAssertion));
    rdn->AttributeValueAssertion->type = at_oid ;
    rdn->AttributeValueAssertion->value = 
     (struct type_SPHINX_AttributeValue *) malloc(sizeof(struct type_SPHINX_AttributeValue));
    rdn->AttributeValueAssertion->value->offset = type_SPHINX_CaseIgnoreString_string;
    rdn->AttributeValueAssertion->value->un.string = str2qb(av, strlen(av), 1);
    rdn->next = *rdn_set;
    *rdn_set = rdn;

    return(1);

syntax_error:
    oid_free(at_oid);
    oid_free(CN_oid);
    return(0);
}

struct type_SPHINX_Name *str_to_rdn(strname)
char    *strname;
{
    static char atype[10], new_at[40], av[80], rest[MAX_BUF];
    char *p = rest;
    int  i, c;
    struct type_SPHINX_Name *name, *return_name;
    struct type_SPHINX_RDN **rdn;

    strcpy(p,strname);
    for(;(*p != '\0') && isspace(*p); p++);
    if (*p != '/') {
      return(NULL);
    }
    for (p++; (*p != '\0') && isspace(*p); p++);
    return_name = name = (struct type_SPHINX_Name *) malloc(sizeof *name);
    name->next = NULL;
    name->RDN = NULL;
    for (; *p != '\0'; ) {
      rdn = &(name->RDN);
      if (next_ava(atype,av,p)) {
	if (abbrev_to_oid(atype, new_at)==0) goto syntax_error;
#ifdef sun
        if ((strcmp(atype,"C")==0) || (strcmp(atype,"c")==0)) {
#else
        if (strcasecmp(atype,"C")==0) {
#endif
          for (i=0; i<strlen(av); i++) {
            c = av[i];
            if (islower(c)) av[i] = toupper(c);
          }
        }
	if (add_RDN_CaseIgnoreString(new_at,av,rdn)==0) goto syntax_error;
	if (*p == '/') for (p++; (*p != '\0') && isspace(*p); p++);
      } else goto syntax_error;
      if (*p != '\0') {
         name->next = (struct type_SPHINX_Name *) malloc(sizeof *name);
         name = name->next;
         name->next = NULL;
         name->RDN = NULL;
      }
    }
    return(return_name);

syntax_error:
    free_SPHINX_Name (name);
    return(NULL);
}

hexdump(p, l)
char *p;
int l;
{
  int i;

  for (i=0; i<l; i++)  {
    if ((i>0) && (i%16 == 0))  printf("\n");
    printf(" %02x", (unsigned char ) p[i]);
  }
  printf("\n");
}

nospace_hexdump(p, l)
char *p;
int l;
{
  int i;

  for (i=0; i<l; i++)  {
    if ((i>0) && (i%16 == 0))  printf("\n");
    printf("%02x", (unsigned char ) p[i]);
  }
  printf("\n");
}
