/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/data_from_ticket.c,v $
 *
 *
 *  MODULE NAME:    data_from_ticket.c
 *
 *
 *  AUTHORS:
 *
 *	J. Tardo
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include "SPHINX-types.h"
#include "BigZ.h"
#include "BigRSA.h"

/*
 * Extract user public key and uid from ticket
 */
int data_from_ticket(tktinfo,key,uid,uidlen)
struct type_SPHINX_TicketInfo *tktinfo;
RSAKeyStorage *key;
char *uid;
int *uidlen;
{
  int i;
  char *temp;
  struct type_SPHINX_SubjectPublicKeyInfo *pubkey;

  if(((pubkey=tktinfo->delegatingPublicKey)==NULL) ||
     ((temp=prim2str(pubkey->subjectPublicKey, &i))==NULL) ||
     (DecodePublic(temp+1,key)==NULL)) {
#ifdef DEBUG
printf("\n%s: Error recovering public key.\n", __FILE__);
#endif
       if (temp) free(temp);
       return(0);
  }
  free(temp);
  if ((temp=prim2str(tktinfo->subjectUID, &i)) && (i > 1)) {
        memcpy(uid,temp+1,(*uidlen = --i));
        free(temp);
  }
  return(1);
}
