/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "vars.h"

#define ROW 1
#define COL 2

variable *editvar ;
gmatrix editmat ;
boolean ispfaff ;

edit_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	if (argc IS 1)
		editvar = NULL ;
	else {
		GET_VMOD(editvar, 1) ;
		ispfaff = ((argc IS 3) ? TRUE : FALSE) ;
	}
}

boolean ok_edit(row_or_col)
int row_or_col ;
{
	if (editvar IS NULL) {
		prerror("; no matrix to edit\n") ;
		return(FALSE) ;
	}
	if ((ispfaff) AND (row_or_col IS COL)) {
		prerror("; use row commands for pfaffians\n") ;
		return(FALSE) ;
	}
	vrg_install(editvar->b_ring) ;
	editmat = VAR_MODULE(editvar) ;
	return(TRUE) ;
}

boolean rcheck(n)
int n ;
{
	if ((n <= 0) OR (n > nrows(editmat))) {
		prerror("; row %d out of range\n", n) ;
		return(FALSE) ;
	} 
	return(TRUE) ;
}

boolean ccheck(n)
int n ;
{
	if ((n <= 0) OR (n > ncols(editmat))) {
		prerror("; column %d out of range\n", n) ;
		return(FALSE) ;
	} 
	return(TRUE) ;
}

pr_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	int i1, i2 ;

	if (argc ISNT 3) {
		printnew("pr <row 1> <row 2>		(permute rows)\n") ;
		return ;
	}
	if (NOT ok_edit(ROW)) return ;
	i1 = getInt(argv[1]) ;
	i2 = getInt(argv[2]) ;
	if (NOT rcheck(i1)) return ;
	if (NOT rcheck(i2)) return ;
	gmR_permute(editmat, i1, i2) ;
	if (ispfaff)
		gmC_permute(editmat, i1, i2) ;
}

pc_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	int i1, i2 ;

	if (argc ISNT 3) {
		printnew("pc <column 1> <column 2>		(permute columns)\n") ;
		return ;
	}
	if (NOT ok_edit(COL)) return ;
	i1 = getInt(argv[1]) ;
	i2 = getInt(argv[2]) ;
	if (NOT ccheck(i1)) return ;
	if (NOT ccheck(i2)) return ;
	gmC_permute(editmat, i1, i2) ;
}

mr_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	int i ;
	poly f ;

	if (argc ISNT 3) {
		printnew("mr <row> <poly multiplier>		(multiply row)\n") ;
		return ;
	}
	if (NOT ok_edit(ROW)) return ;
	i = getInt(argv[1]) ;
	if (NOT rcheck(i)) return ;
	f = getPoly(argv[2], 1) ;
	gmR_mult(editmat, i, f) ;
	if (ispfaff)
		gmC_mult(editmat, i, f) ;
	p_kill(&f) ;
}

mc_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	int i ;
	poly f ;

	if (argc ISNT 3) {
		printnew("mc <col> <poly multiplier>		(multiply col.)\n") ;
		return ;
	}
	if (NOT ok_edit(COL)) return ;
	i = getInt(argv[1]) ;
	if (NOT ccheck(i)) return ;
	f = getPoly(argv[2], 1) ;
	gmC_mult(editmat, i, f) ;
	p_kill(&f) ;
}

dr_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	int i ;
	field a ;
	poly f ;

	if (argc ISNT 3) {
		printnew("dr <row> <field elem>		(divide row)\n") ;
		return ;
	}
	if (NOT ok_edit(ROW)) return ;
	i = getInt(argv[1]) ;
	if (NOT rcheck(i)) return ;
	a = getInt(argv[2]) ;
	if (a IS 0) {
		prerror("; can't divide by zero\n") ;
		return ;
	}
	fd_recip(&a) ;
	f = p_monom(a) ;
	tm_copy(zerodegs, INITIAL(f)) ;
	gmR_mult(editmat, i, f) ;
	if (ispfaff)
		gmC_mult(editmat, i, f) ;
	p_kill(&f) ;
}

dc_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	int i ;
	field a ;
	poly f ;

	if (argc ISNT 3) {
		printnew("dc <col> <field elem>		(divide col.)\n") ;
		return ;
	}
	if (NOT ok_edit(COL)) return ;
	i = getInt(argv[1]) ;
	if (NOT ccheck(i)) return ;
	a = getInt(argv[2]) ;
	if (a IS 0) {
		prerror("; can't divide by zero\n") ;
		return ;
	}
	fd_recip(&a) ;
	f = p_monom(a) ;
	tm_copy(zerodegs, INITIAL(f)) ;
	gmC_mult(editmat, i, f) ;
	p_kill(&f) ;
}

ar_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	int i1, i2 ;
	poly f ;

	if (argc ISNT 4) {
		printnew("ar <row> <poly. multiplier> <row to modify> ") ;
		print("		(add to row)\n") ;
		return ;
	}
	if (NOT ok_edit(ROW)) return ;
	i1 = getInt(argv[1]) ;
	i2 = getInt(argv[3]) ;
	if (NOT rcheck(i1)) return ;
	if (NOT rcheck(i2)) return ;
	f = getPoly(argv[2], 1) ;
	gmR_addto(editmat, i1, f, i2) ;
	if (ispfaff)
		gmC_addto(editmat, i1, f, i2) ;
	p_kill(&f) ;
}

ac_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	int i1, i2 ;
	poly f ;

	if (argc ISNT 4) {
		printnew("ac <col> <poly. multiplier> <col to modify> ") ;
		print("		(add to col)\n") ;
		return ;
	}
	if (NOT ok_edit(COL)) return ;
	i1 = getInt(argv[1]) ;
	i2 = getInt(argv[3]) ;
	if (NOT ccheck(i1)) return ;
	if (NOT ccheck(i2)) return ;
	f = getPoly(argv[2], 1) ;
	gmC_addto(editmat, i1, f, i2) ;
}

ce_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	poly f, g ;
	int i, j ;

	if (argc ISNT 4) {
		printnew("ce <row> <col> <new poly. entry>		change entry\n");
		return ;
	}
	if (NOT ok_edit(ROW)) return ;
	i = getInt(argv[1]) ;
	j = getInt(argv[2]) ;
	if (NOT rcheck(i)) return ;
	if (NOT ccheck(j)) return ;
	g = getPoly(argv[3], i) ;
	f = PREF(editmat->gens, j) ;
	p_chEntry(&f, i, g) ;
	PREF(editmat->gens, j) = f ;
}


/*----------------------------------------------------------*/

gmR_permute(g, r1, r2)
gmatrix g ;
int r1, r2 ;
{
	int i ;

	for (i=1; i<=ncols(g); i++) 
		p_perm(&(PREF(g->gens, i)), r1, r2) ;
	dl_permute(&(g->degrees), r1, r2) ;
}

gmC_permute(g, c1, c2)
gmatrix g ;
int c1, c2 ;
{
	poly temp ;

	dl_permute(&(g->deggens), c1, c2) ;
	temp = PREF(g->gens, c1) ;
	PREF(g->gens, c1) = PREF(g->gens, c2) ;
	PREF(g->gens, c2) = temp ;
}

dl_permute(dl, i1, i2)
dlist *dl ;
int i1, i2 ;
{
	int temp ;

	temp = DREF(*dl, i1) ;
	DREF(*dl, i1) = DREF(*dl, i2) ;
	DREF(*dl, i2) = temp ;
}

p_perm(f, i, j)
poly *f ;
int i, j ;
{
	poly result, temp ;
	register poly ff ;
	register int c ;

	result = NULL ;
	ff = *f ;
	while (ff ISNT NULL) {
		temp = ff ;
		ff = ff->next ;
		temp->next = NULL ;
		c = get_comp(temp) ;
		if (c IS i)
			set_comp(temp, j) ;
		else if (c IS j)
			set_comp(temp, i) ;
		p_add(&result, &temp) ;
	}
	*f = result ;
}

/*------------------------------------------------------------*/

gmR_addto(g, r1, f, r2)
gmatrix g ;
int r1, r2 ; /* row r2 of g is set to row r2 + f * row r1 */
poly f ;	/* not modified */
{
	int i ;

	for (i=1; i<=ncols(g); i++) 
		p_addto(&(PREF(g->gens, i)), r1, f, r2) ;
}

gmC_addto(g, c1, f, c2)
gmatrix g ;
int c1, c2 ;
poly f ;
{
	poly a ;

	a = p_mult(f, PREF(g->gens, c1)) ;
	p_add(&PREF(g->gens, c2), &a) ;
}

p_addto(pol, i1, f, i2)
poly *pol ;
int i1, i2 ;
poly f ;
{
	poly result, temp, h ;
	register poly p ;

	result = NULL ;
	p = *pol ;
	while (p ISNT NULL) {
		temp = p ;
		p = p->next ;
		temp->next = NULL ;
		if (get_comp(temp) IS i1) {
			set_comp(temp, i2) ;
			h = p_mult(f, temp) ;
			p_add(&result, &h) ;
			set_comp(temp, i1) ;
		}
		p_add(&result, &temp) ;
	}
	*pol = result ;
}

/*------------------------------------------------------*/

gmC_mult(g, i, f)
gmatrix g ;
int i ;
poly f ;
{
	poly k, h ;

	k = PREF(g->gens, i) ;
	h = p_mult(f, k) ;
	p_kill(&k) ;
	PREF(g->gens, i) = h ;
	DREF(g->deggens, i) = degree(g, h) ;
}

gmR_mult(g, i, f)
gmatrix g ;
int i ;
poly f ;
{
	int deg, j ;

	deg = degree(g, f) ;
	DREF(g->degrees, i) -= deg ;
	for (j=1; j<=ncols(g); j++) 
		p_multcomp(&PREF(g->gens, j), i, f) ;
}

p_multcomp(pol, i, f)
poly *pol ;
int i ;
poly f;
{
	poly result, temp, h ;
	register poly p ;

	result = NULL ;
	p = *pol ;
	while (p ISNT NULL) {
		temp = p ;
		p = p->next ;
		temp->next = NULL ;
		if (get_comp(temp) IS i) {
			h = p_mult(f, temp) ;
			p_add(&result, &h) ;
		} else p_add(&result, &temp) ;
	}
	*pol = result ;
}
