/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _array.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#include <LEDA/array.h>


void gen_array::read(istream& in, string s)
{ cout << s;
  int i = 0; 
  while (in && i<sz)
  { clear_entry(v[i]);
    read_el(v[i],in);
    i++;
   }
 }

void gen_array::print(ostream& out, string s, char space) const
{ cout << s;
  int i = 0; 
  while (i < sz)
    { out << string("%c",space);
      print_el(v[i],out); 
      i++;
     }
  out.flush();
}

void gen_array::clear() 
{ register int i = sz;
  register GenPtr* vv = &v[i];
  while (i--) clear_entry(*--vv);
}

void gen_array::init() 
{ register int i = sz;
  register GenPtr* vv = &v[i];
  while (i--) init_entry(*--vv);
}


gen_array::gen_array(int a, int b)
{ if (a>b) error_handler(1,"bad array size");
  Low = a;
  High = b;
  sz = b-a+1;
  v = new GenPtr[sz];
  if (v==0) error_handler(99,"array: out of memory");
 }

gen_array::gen_array(int n)
{ Low = 0;
  High = n-1;
  sz = n;
  v = new GenPtr[sz];
  if (v==0) error_handler(99,"array: out of memory");

  register int i = sz;
  register GenPtr* vv = &v[i];
  while (i--) init_entry(*--vv);
}

gen_array::gen_array(gen_array& a)
{       register i = a.sz;
	sz = i;	
        Low = a.Low;
        High = a.High;
	v = new GenPtr[i];
	register GenPtr* vv = &v[i];
	register GenPtr* av = &a.v[i];
	while (i--) { *--vv = *--av;
	              copy_entry(*vv);
                     }
}

gen_array& gen_array::operator=(gen_array& a)
{
	register i = a.sz;
	if ((sz != i) || (Low != a.Low) || (High != a.High))
		error_handler(3,"different array types in assignment");
	register GenPtr* vv = &v[i];
	register GenPtr* av = &a.v[i];
	while (i--) 
        { clear_entry(*--vv);
          *vv = *--av;
	  copy_entry(*vv);
        }
	return *this;
}

void gen_array::permute(int l, int r)
{
  if (l<Low || l>High || r<l || r>High) 
         error_handler(2,"array::permute illegal range");

  l -= Low;
  r -= Low;

  register GenPtr* x;
  register GenPtr* stop = v+r+1;
  register int j;

  init_random();
  for(x=v+l;x!=stop;x++) 
  { j = random(l,r);  
    if (x!=v+j) SWAP(*x,v[j]);  
   }
}


void gen_array::sort(int l, int h, int k) 
{ permute(l,h);
  if (k==0)
     quick_sort0(l-Low,h-Low);
  else
     quick_sort1(l-Low,h-Low);
 }

void gen_array::quick_sort0(register int l, register int r)
{ 
  register int i = l;
  register int k = r+1;
  GenPtr s = v[l];

  while (i<k)
  { while (i<r && cmp(v[++i],s)<0);
    while (k>l && cmp(v[--k],s)>0);
    if (k>i) SWAP(v[i],v[k]);
   }

  SWAP(v[l],v[k]);

  if (l < k-1) quick_sort0(l,k-1);
  if (r > k+1) quick_sort0(k+1,r);
}

void gen_array::quick_sort1(register int l, register int r)
{ 
  register int i = l;
  register int k = r+1;
  GenPtr s = v[l];

  while (i<k)
  { while (i<r && usr_cmp(v[++i],s)<0);
    while (k>l && usr_cmp(v[--k],s)>0);
    if (k>i) SWAP(v[i],v[k]);
   }

  SWAP(v[l],v[k]);

  if (l < k-1) quick_sort1(l,k-1);
  if (r > k+1) quick_sort1(k+1,r);
}


int gen_array::binary_search0(GenPtr x)
{ int l = 0;
  int r = sz-1;
  int m;
  while (l<r)
  { m = (l+r)/2;
    if (cmp(x,elem(m))==0) { l = m; break; }
    if (cmp(x,elem(m)) > 0) l = m+1;
    else
    if (cmp(x,elem(m)) < 0) r = m-1;
   }

  return  (cmp(elem(l),x)==0) ? (l+Low) : (Low-1);
}

int gen_array::binary_search1(GenPtr x)
{ int l = 0;
  int r = sz-1;
  int m;
  while (l<r)
  { m = (l+r)/2;
    if (usr_cmp(x,elem(m))==0) { l = m; break; }
    if (usr_cmp(x,elem(m)) > 0) l = m+1;
    else
    if (usr_cmp(x,elem(m)) < 0) r = m-1;
   }

  return  (usr_cmp(elem(l),x)==0) ? (l+Low) : (Low-1);
}



void gen_array2::init(int a, int b, int c, int d)
{ register int i,j;
  for (i=a;i<=b;i++) 
      for (j=c; j<=d; j++) init_entry(row(i)->entry(j));
}

gen_array2::gen_array2(int a, int b, int c, int d) : A(a,b) 
{ Low1  = a;
  High1 = b;
  Low2  = c;
  High2 = d;
  while (b>=a) A.entry(b--) = (GenPtr) new gen_array(c,d); }

gen_array2::gen_array2(int a, int b) : A(a) 
{ Low1  = 0;
  High1 = a-1;
  Low2  = 0;
  High2 = b-1;
  while (a>0) A.entry(--a) = (GenPtr) new gen_array(b); }

void gen_array2::clear()
{ register int i,j;
  for (i=Low1;i<=High1;i++) 
  for (j=Low2;j<=High2;j++) 
  clear_entry(row(i)->entry(j));
 }

gen_array2::~gen_array2()
{ register int i;
  for (i=Low1;i<=High1;i++) delete (gen_array*)A.entry(i);
 }

