// opengl.cpp : capsulates OpenGL contex handling for MS OpenGL
// written in May 1995
// Gerbert Orasche
// copyright: (c) 1994-95
// Institute For Information Processing And Computer Supported New Media (IICM)
// Graz University Of Technology

#include "stdafx.h"
#include <hgapp.h>

#include <gl\gl.h>
#include <gl\glu.h>
#include "scenedoc.h"
#include "scenevw.h"
#include <ge3d/ge3d.h>
#include "scene3d.h"
#include "camera.h"
#include <ge3d/color.h>
#include "vecutil.h"



/////////////////////////////////////////////////////////////////////////////
// Static member data initialization
  unsigned char CSceneView::m_threeto8[8] = {
    0, 0111>>1, 0222>>1, 0333>>1, 0444>>1, 0555>>1, 0666>>1, 0377
  };
  unsigned char CSceneView::m_twoto8[4] = {
    0, 0x55, 0xaa, 0xff
  };
  unsigned char CSceneView::m_oneto8[2] = {
    0, 255
  };
  int CSceneView::m_defaultOverride[13] = {
    0, 3, 24, 27, 64, 67, 88, 173, 181, 236, 247, 164, 91
  };

  PALETTEENTRY CSceneView::m_defaultPalEntry[20] = {
    { 0,   0,   0,    0 },
    { 0x80,0,   0,    0 },
    { 0,   0x80,0,    0 },
    { 0x80,0x80,0,    0 },
    { 0,   0,   0x80, 0 },
    { 0x80,0,   0x80, 0 },
    { 0,   0x80,0x80, 0 },
    { 0xC0,0xC0,0xC0, 0 },

    { 192, 220, 192,  0 },
    { 166, 202, 240,  0 },
    { 255, 251, 240,  0 },
    { 160, 160, 164,  0 },

    { 0x80,0x80,0x80, 0 },
    { 0xFF,0,   0,    0 },
    { 0,   0xFF,0,    0 },
    { 0xFF,0xFF,0,    0 },
    { 0,   0,   0xFF, 0 },
    { 0xFF,0,   0xFF, 0 },
    { 0,   0xFF,0xFF, 0 },
    { 0xFF,0xFF,0xFF, 0 }
  };


/////////////////////////////////////////////////////////////////////////////
// GL-related member functions
void CSceneView::GLCreateRGBPalette(HDC hDC)
{
  PIXELFORMATDESCRIPTOR pfd;
  int n;
  int iCount;
  LOGPALETTE* pBuffer;

  n=::GetPixelFormat(hDC);
  ::DescribePixelFormat(hDC,n,sizeof(PIXELFORMATDESCRIPTOR),&pfd);

  if(pfd.dwFlags & PFD_NEED_PALETTE)
  {
    n=1<<pfd.cColorBits;

    // if we are creating a new palette delete the old one
    if(m_hPal!=NULL)
      return;

    // allocate buffer for colortable
    pBuffer=(LOGPALETTE*)new(char[n*sizeof(PALETTEENTRY)+4]);
    pBuffer->palVersion=0x300;
    pBuffer->palNumEntries=n;

    // calculate colors
    for (iCount=0;iCount<n;iCount++)
    {
      pBuffer->palPalEntry[iCount].peRed=
            GLComponentFromIndex(iCount,pfd.cRedBits,pfd.cRedShift);
      pBuffer->palPalEntry[iCount].peGreen=
            GLComponentFromIndex(iCount, pfd.cGreenBits,pfd.cGreenShift);
      pBuffer->palPalEntry[iCount].peBlue=
            GLComponentFromIndex(iCount, pfd.cBlueBits,pfd.cBlueShift);
      pBuffer->palPalEntry[iCount].peFlags=0;
    }

        // fix up the palette to include the default GDI palette 
    if ((pfd.cColorBits == 8) &&
        (pfd.cRedBits   == 3) && (pfd.cRedShift   == 0) &&
        (pfd.cGreenBits == 3) && (pfd.cGreenShift == 3) &&
        (pfd.cBlueBits  == 2) && (pfd.cBlueShift  == 6))
    {
      for(iCount=1;iCount<=12;iCount++)
        pBuffer->palPalEntry[m_defaultOverride[iCount]]=m_defaultPalEntry[iCount];
    }

    m_hPal=CreatePalette(pBuffer);
    
    // release buffer
    delete[] pBuffer;
  }
} 

// 20.2.95
// gets color from component table
unsigned char CSceneView::GLComponentFromIndex(int i, UINT nbits, UINT shift)
{
  unsigned char val;

  val=(unsigned char)(i >> shift);
  switch(nbits)
  {
    case 1:
      val &= 0x1;
      return(m_oneto8[val]);
    case 2:
      val &= 0x3;
      return(m_twoto8[val]);
    case 3:
      val &= 0x7;
      return(m_threeto8[val]);
    default:
      return(0);
  }
}


// 2.3.95
// Destroys the rendering context, if there are no more references
void CSceneView::GLDestroy()
{
  // Before releasing we are flushing...
  glFlush();
  //Release the current GL rendering context and device context
  if(m_hglrc)
  {
    //make the rendering context not current.
    ::wglMakeCurrent(NULL, NULL);
	  //nuke the rendering context
    wglDeleteContext(m_hglrc);
    m_hglrc=NULL;
    //delete m_pPal;
    if(m_hPal)
      DeleteObject(m_hPal);
  }	 
}

// 16.2.95
// Sets up the pixelformat
BOOL CSceneView::GLSetupPixelFormat(HDC hdc, PIXELFORMATDESCRIPTOR *pPFD)
{
  BOOL bRet = TRUE;
  int pixelformat;
	
  if (!(pixelformat = ::ChoosePixelFormat(hdc, pPFD)))
    bRet = FALSE;

  if(!::SetPixelFormat(hdc, pixelformat, pPFD))
    bRet = FALSE;

  if(bRet)
    GLCreateRGBPalette(hdc);

  return(bRet);
}

void CSceneView::GLSetupContext(CDC* pDC)
{
  PIXELFORMATDESCRIPTOR fdCreate;

  memset(&fdCreate,0,sizeof(PIXELFORMATDESCRIPTOR));
  fdCreate.nSize=sizeof(PIXELFORMATDESCRIPTOR);
  fdCreate.nVersion=1;
  fdCreate.dwFlags=PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER;
  //fdCreate.dwFlags=PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL;
  fdCreate.iPixelType=PFD_TYPE_RGBA;
  //fdCreate.cDepthBits=16;
  fdCreate.cDepthBits=32;
  fdCreate.cAccumBits=0;
  fdCreate.cColorBits=24;

  // ChoosePixelFormat
  if(GLSetupPixelFormat(pDC->m_hDC,&fdCreate))
  {
    if(m_hglrc=::wglCreateContext(pDC->m_hDC))
    {
      if (!::wglMakeCurrent(pDC->m_hDC,m_hglrc))
       {
         wglDeleteContext(m_hglrc);
         m_hglrc=NULL;
         AfxMessageBox("Error creating rendering context",MB_OK,0);
       }
       // if OK turn on dithering!
       glEnable(GL_DITHER);
    }
  }
  else 
  {
   AfxMessageBox("Error getting pixel format",MB_OK,0);
  }            
}

void CSceneView::OnInitialUpdate() 
{
  CDC* pDC;

  //m_iDrawMode=ge3d_wireframe;
  m_iDrawMode=ge3d_flat_shading;
  // interactive mode is switched off (if same as normal drawing mode)
  m_iInteractiveMode=m_iDrawMode;

  pDC=GetDC();
  // so setup the context
  GLSetupContext(pDC);
  if(m_hglrc==NULL)
  {
    AfxMessageBox("Fatal Error at getting Rendering Context",MB_OK|MB_ICONSTOP);
  }
  ReleaseDC(pDC);

  CView::OnInitialUpdate();
}

// 130795
// make context current 
BOOL CSceneView::GLMakeCurrent(CDC* pDC)
{
  return ::wglMakeCurrent(pDC->m_hDC,m_hglrc);
}

// 130795
// test, if rendering context is valid
BOOL CSceneView::GLValidContext()
{
  if(m_hglrc)
    return TRUE;
  else
    return FALSE;
}

// 130795
// swap buffers
BOOL CSceneView::GLSwapBuffers(CDC* pDC)
{
  return ::SwapBuffers(pDC->m_hDC);
}
