 /*
  * Khoros: $Id: kraftsman.c,v 1.4 1992/03/20 22:52:29 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: kraftsman.c,v 1.4 1992/03/20 22:52:29 dkhoros Exp $";
#endif

 /*
  * $Log: kraftsman.c,v $
 * Revision 1.4  1992/03/20  22:52:29  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: kraftsman.c
 >>>>
 >>>>      Program Name: kraftsman
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	This program is for interactive creation and manipulation of
 >>>>	Toolboxes.
 >>>>	
 >>>>	

 >>>>            Author: Steven Jorgensen 
 >>>>
 >>>> Date Last Updated: Fri Dec 13 15:03:14 1991
 >>>>
 >>>>          Routines: main- the main program for kraftsman
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "kraftsman.h"


/****************************************************************
 *
 * Routine Name:  main program for kraftsman
 *
 *       Input:  
 *
 *
 *           [-toolbox] Tool box
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        char *tname = NULL;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (kraftsman->toolbox_flag == TRUE)
          tname = VStrcpy(kraftsman->toolbox_string);
        if (getenv("KHOROS_TOOLBOX") == NULL)
          {
            fprintf(stderr,"kraftsman:\n");
            fprintf(stderr,"KHOROS_TOOLBOX environment variable hasn't been\n");
            fprintf(stderr,"initialized.  To use the other toolboxes within\n");
            fprintf(stderr,"Khoros use the 'setenv' command to set\n");
            fprintf(stderr,"KHOROS_TOOLBOX to the desired toolbox file.\n");
            exit(0);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        lkraftsman(program, tname);
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for kraftsman 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "kraftsman :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tThis program is for interactive creation and manipulation of\n");
	fprintf(stderr, "\tToolboxes.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-toolbox]  Tool box (string) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-jr filename.jp] creates a journal recording\n");
	fprintf(stderr, "\t[-jp filename.jp] executes a journal playback \n");
	fprintf(stderr, "\t[-fn] specifies the font for kraftsman\n");
	fprintf(stderr, "\t[-V] Gives the version for kraftsman\n");
	fprintf(stderr, "\t[-U] Gives the usage for kraftsman\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called kraftsman.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses kraftsman.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for kraftsman
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*toolbox_pstr = 
	"\nEnter: (toolbox) Tool box \n        {string}: "; 
char	*toolbox_def = NULL;
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "kraftsman", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "kraftsman.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "kraftsman: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "kraftsman.ans");
		}

	     }

	}

	/*
	 * allocate the kraftsman structure
	 */
	kraftsman = (kraftsman_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (kraftsman_struct));

	/*
	 * get optional arguments for kraftsman
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	kraftsman->toolbox_flag = vget_string(fid, prompt_flag,
	"-toolbox", toolbox_pstr, &(kraftsman->toolbox_string),
	toolbox_def);

	if (prompt_flag == FALSE)
	{
	    if ((kraftsman->toolbox_flag == 1)&&(kraftsman->toolbox_string == NULL))
    	{
		fprintf(stderr, "kraftsman:\n");
		fprintf(stderr, "you must specify a name following '-toolbox'\n");
		gw_usage();
		exit(1);
		}
	}

}



