 /*
  * Khoros: $Id: create.c,v 1.3 1991/12/18 09:00:43 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: create.c,v 1.3 1991/12/18 09:00:43 dkhoros Exp $";
#endif

 /*
  * $Log: create.c,v $
 * Revision 1.3  1991/12/18  09:00:43  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "cantata.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>								<<<<
   >>>>	    file name:  create.c				<<<<
   >>>>								<<<<
   >>>>   description:						<<<<
   >>>>								<<<<
   >>>>      routines:  xvl_create_color()			<<<<
   >>>>                 xvl_create_font()			<<<<
   >>>>                 xvl_create_bitmap()			<<<<
   >>>>                 xvl_create_stippled()			<<<<
   >>>>								<<<<
   >>>> modifications:						<<<<
   >>>>								<<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
* Routine Name: xvl_create_color
*
*      Purpose: This routine is used to create a color from the
*		desired named color.
*
*        Input: color  - the color to be created
*
*       Output: xcolor - the color allocated.  xvl_create_color()
*		will return True upon sucuess and False upon
*		failure.
*
*    Called By:
*
*   Written By: Mark Young
*
*************************************************************/


int xvl_create_color(color, xcolor)

char	*color;
XColor  *xcolor;
{
	Colormap  colormap = XDefaultColormap(display, xvf_screen_num);

	if (!XParseColor(display, colormap, color, xcolor))
	   return(False);
	else
	{
	   if (!XAllocColor(display, colormap, xcolor))
	      return(False);
	}
	return(True);
}



/************************************************************
*
* Routine Name: xvl_create_font
*
*      Purpose: This routine is used to create a font from the
*		desired named font.  If we are unable to find
*		the font we return False, but we will also return
*		one of the pre-defined fonts as well.  If we
*		are unable to load any of these fonts then we
*		will set the xfont structure to NULL
*
*        Input: font  - the font to be allocated
*
*       Output: xfont - the xfont allocated.  xvl_create_font()
*		will return True upon sucuess and False upon
*		failure.
*
*    Called By:
*
*   Written By: Mark Young
*
*************************************************************/


int xvl_create_font(font, xfont)

char	     *font;
XFontStruct  **xfont;
{
	int	    i;
	XFontStruct *temp;

	static  num_fonts = 5;
	static  char *font_names[] =
	{
		"fixed",
		"-adobe-times-medium-r-normal--12*",
		"-adobe-times-bold-r-normal--12*",
		"6x10",
		"variable"
	};

	/*
	 *  Try to allocate the desired font.  If we fail then we
	 *  will try to load one
	 */
	*xfont = NULL;
	if ((temp = XLoadQueryFont(display, font)) != NULL)
	{
	   *xfont = temp;
	   return(True);
	}

	/*
	 *  We failed try and allocate a different font.
	 */
	for (i = 0; i < num_fonts; i++)
	{
	    if ((temp = XLoadQueryFont(display, font_names[i])) != NULL)
	    {
	       *xfont = temp;
	       break;
	    }
	}
	return(False);
}



/************************************************************
*
* Routine Name: xvl_create_bitmap
*
*      Purpose: This routine is used to create a bitmap from the
*		desired named bitmap file.
*
*        Input: filename  - the bitmap filename
*
*       Output: returns the newly created pixmap otherwise None
*		is returned.
*
*
*   Written By: Mark Young
*
*************************************************************/

#define BITMAPDIR "/usr/include/X11/bitmaps"


Pixmap xvl_create_bitmap(filename)

char	     *filename;
{
	Pixmap    pixmap;
	Window    rootwindow;
	int	  x_hot, y_hot;
	char	  *fullpath, *data;
	unsigned  long fg, bg;
	unsigned  int width, height, depth;


	if ((fullpath = vfullpath(filename, BITMAPDIR, NULL)) == NULL)
	   return(None);

	if ((XmuReadBitmapDataFromFile(fullpath, &width, &height,
			&data, &x_hot, &y_hot)) != BitmapSuccess)
	{
	   return(None);
	}
	rootwindow = XDefaultRootWindow(display);
	depth  = XDefaultDepth(display, xvf_screen_num);

	if (wresource.glyph_fg == ~0L)
	   fg = BlackPixel(display, xvf_screen_num);
	else fg = wresource.glyph_fg;
	if (wresource.glyph_bg == ~0L)
	   bg = WhitePixel(display, xvf_screen_num);
	else bg = wresource.glyph_bg;

	pixmap = XCreatePixmapFromBitmapData(display, rootwindow, data,
			width, height, fg, bg, depth);

	free(data);
	return(pixmap);
}



/************************************************************
*
* Routine Name: xvl_create_stippled
*
*      Purpose: This routine is used to create a stippled bitmap
*
*        Input: none
*
*       Output: returns the newly created pixmap otherwise None
*		is returned.
*
*
*   Written By: Mark Young
*
*************************************************************/


Pixmap xvl_create_stippled()
{
	Pixmap   stippled;
	unsigned long fg, bg;
	unsigned int depth = XDefaultDepth(display, xvf_screen_num);


	if (wresource.glyph_fg == ~0L)
	   fg = BlackPixel(display, xvf_screen_num);
	else fg = wresource.glyph_fg;
	if (wresource.glyph_bg == ~0L)
	   bg = WhitePixel(display, xvf_screen_num);
	else bg = wresource.glyph_bg;

	stippled = XmuCreateStippledPixmap(xvf_screen, fg, bg, depth);
	return(stippled);
}
