 /*
  * Khoros: $Id: vmapdata.c,v 1.2 1991/12/18 09:33:50 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vmapdata.c,v 1.2 1991/12/18 09:33:50 dkhoros Exp $";
#endif

 /*
  * $Log: vmapdata.c,v $
 * Revision 1.2  1991/12/18  09:33:50  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vmapdata.c
 >>>>
 >>>>      Program Name: vmapdata
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Maps the data through the map to create a new data set  with
 >>>>	no map.
 >>>>	
 >>>>	

 >>>>            Author: Tom Sauer
 >>>>
 >>>> Date Last Updated: Wed Nov 13 08:58:31 1991
 >>>>
 >>>>          Routines: main- the main program for vmapdata
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vmapdata.h"


/****************************************************************
 *
 * Routine Name:  main program for vmapdata
 *
 *       Input:  
 *          -i  input image filename 
 *          -o  output image filename 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

image = readimage(vmapdata->i_file);
if (image == NULL) exit(1);                   /* Quit if bad image */

proper_num_images(program,image,1,TRUE);

if(! (propertype(program,image,VFF_TYP_1_BYTE,FALSE) || propertype(program,image,VFF_TYP_4_BYTE,FALSE))) {
     (void) fprintf(stderr,"\n\nvmapdata:  ERROR ");
     (void) fprintf(stderr,"Data type must be byte or integer.n");
     exit(1);
}

if(! (proper_map_scheme(program,image,VFF_MS_ONEPERBAND,FALSE) || proper_map_scheme(program,image,VFF_MS_SHARED,FALSE))) {
     (void) fprintf(stderr,"\n\nvmapdata:  ERROR ");
     (void) fprintf(stderr,"Mapping scheme must be ONEPERBAND or SHARED\n");
     exit(1);
}
if(proper_map_type(program,image,VFF_MAPTYP_NONE,FALSE) || proper_map_type(program,image,VFF_MAPTYP_COMPLEX,FALSE)) {
  (void) fprintf(stderr,"\n\nvmapdata:  ERROR ");
  (void) fprintf(stderr,"Mapping type cannot be COMPLEX or DONTCARE\n");
   exit(1);
}
/* -main_before_lib_call_end */

/* -main_library_call */
if(! lvmapdata(image))
 {
   (void) fprintf(stderr, "lvmapdata Failed\n");
   exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vmapdata->o_file, image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vmapdata 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vmapdata :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tMaps the data through the map to create a new data set  with\n");
	fprintf(stderr, "\tno map.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vmapdata\n");
	fprintf(stderr, "\t[-U] Gives the usage for vmapdata\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vmapdata.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vmapdata.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vmapdata
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vmapdata", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vmapdata.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vmapdata: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vmapdata.ans");
		}

	     }

	}

	/*
	 * allocate the vmapdata structure
	 */
	vmapdata = (vmapdata_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vmapdata_struct));

	/*
	 * get required arguments for vmapdata
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vmapdata->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vmapdata->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmapdata->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vmapdata->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vmapdata->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmapdata->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vmapdata->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmapdata->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vmapdata->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vmapdata->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



