 /*
  * Khoros: $Id: vqerr.c,v 1.1 1991/05/10 15:46:15 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vqerr.c,v 1.1 1991/05/10 15:46:15 khoros Exp $";
#endif

 /*
  * $Log: vqerr.c,v $
 * Revision 1.1  1991/05/10  15:46:15  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vqerr.c
 >>>>
 >>>>      Program Name: vqerr
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute the quantization error between a quantized image and
 >>>>	the original.
 >>>>	
 >>>>	

 >>>> 
 >>>> Date Last Updated: Thu Mar  7 16:15:26 1991
 >>>>
 >>>>          Routines: main- the main program for vqerr
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vqerr.h"


/****************************************************************
 *
 * Routine Name:  main program for vqerr
 *
 *       Input:  
 *       -i1  Quantized image 
 *       -i2  Original image 
 *       -o  Output ASCII File 
 *
 *
 *       [-m] add operation masking image
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img1, *img2, *img3, *readimage();
FILE *file;
double rms;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        img1 = readimage(vqerr->i1_file);
        if (img1 == NULL) exit(1);                    

        img2 = readimage(vqerr->i2_file);
        if (img2 == NULL) exit(1);                      

        if (vqerr->m_flag) img3 = readimage(vqerr->m_file);
        if (vqerr->m_flag && (img3 == NULL)) exit(1);         

        CHECKINPUT(program, img1, img2);      /* Verify input images */
        if (img2->data_storage_type != img1->map_storage_type)
          {
            fprintf(stderr,"vqerr: Second image data type should match first image map data type!\n");
            exit(1);
          }
        if (!(img1->data_storage_type == VFF_TYP_1_BYTE ||
              img1->data_storage_type == VFF_TYP_4_BYTE))
          {
            fprintf(stderr,"vqerr: First image data type should be BYTE or INT!\n");
            exit(1);
          }

        if(vqerr->m_flag)  { 
            MATCHINPUT(program, img1, img3);  /* Verify input images */
        }
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvqerr(img1, img2, img3, vqerr->m_flag,&rms) )
        {
            (void) fprintf(stderr, "lvqerr Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        file = fopen(vqerr->o_file,"w");
        fprintf(file,"%e\n",rms);
        fclose(file);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vqerr 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vqerr :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute the quantization error between a quantized image and\n");
	fprintf(stderr, "\tthe original.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
        fprintf(stderr, "\tOptional third input is a masking image.\n");
        fprintf(stderr, "\t\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  Quantized image  (infile)\n");
	fprintf(stderr,"\t-i2  Original image  (infile)\n");
	fprintf(stderr,"\t-o  Output ASCII File  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-m]  add operation masking image (infile) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vqerr\n");
	fprintf(stderr, "\t[-U] Gives the usage for vqerr\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vqerr.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vqerr.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vqerr
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) Quantized image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) Original image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) Output ASCII File \n        {outfile}: "; 
char	*m_pstr = 
	"\nEnter: (m) add operation masking image \n        {infile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vqerr", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vqerr.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vqerr: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vqerr.ans");
		}

	     }

	}

	/*
	 * allocate the vqerr structure
	 */
	vqerr = (vqerr_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vqerr_struct));

	/*
	 * get required arguments for vqerr
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vqerr->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vqerr->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vqerr->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vqerr->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vqerr->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vqerr->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vqerr->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vqerr->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vqerr->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vqerr->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vqerr->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vqerr->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vqerr->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vqerr->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vqerr->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vqerr
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vqerr->m_flag = vget_infile(fid, prompt_flag,
	"-m", m_pstr, &(vqerr->m_file))
;


}



