#! /bin/csh -f

# 
#  Khoros: $Id: helppage_csh.csh,v 1.3 1991/12/18 08:54:00 dkhoros Exp $
#

#
# $Log: helppage_csh.csh,v $
# Revision 1.3  1991/12/18  08:54:00  dkhoros
# HellPatch3
#
# 

#
#*----------------------------------------------------------------------
#*
#* Copyright 1991, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1991 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>                                                       <<<<
#  >>>>	    file name: helppage_csh                           <<<<
#  >>>>                                                       <<<<
#  >>>>   description: utility for Cantata help system
#  >>>>                Formats a help page for use by cantata <<<<
#  >>>>                                                       <<<<
#  >>>> modifications: Added a C driver to call this script.  <<<<
#  >>>>                Added mach file capability to script.  <<<<
#  >>>>                3/18/91 C.Gage                         <<<<
#  >>>>                                                       <<<<
#  >>>>                Modified to work with the toolbox      <<<<
#  >>>>                concept. 9/20/91 Tom Sauer             <<<<
#  >>>>                                                       <<<<
#  >>>>                                                       <<<<
#  >>>>                                                       <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

# ROUTINE NAME:    helppage_csh
#
# AUTHORS:      Charlie Gage and Tom Sauer
#
# DATE:         3/18/91
#
# DESCRIPTION: This is a shell script that will format a helppage
#		for use by cantata.

umask 002
onintr cleanup


#  Input Argument Checking
#------------------------------------------------------------
if ($#argv != 3) then
  echo ""
  echo "helppage: Invalid number of arguments detected."
  echo "Please invoke this script from the C driver program."
  echo ""
  exit 0
endif

if (! $?KHOROS_HOME ) then
   echo ""
   echo "Error KHOROS_HOME environment variable is not set"
   echo ""
   exit 0
endif

set path = ( . $KHOROS_HOME/bin $path /usr/local/bin /usr/ucb \
             /usr/bin /bin /usr/local/etc/ /usr/etc /etc )


##### initialize variables #####

set INPUT_FILE = $1
set ALL_FLAG = $2
set MACH = $3

if (! -e $INPUT_FILE && $INPUT_FILE != "_NULL_") then
   echo ""
   echo "helppage:  Invalid input file specified."
   echo "Please ensure that the input file exists."
   echo ""
   exit 0
endif

if ($ALL_FLAG != "0" && $ALL_FLAG != "1") then
   echo ""
   echo "helppage:  Invalid entry for the all_flag."
   echo "all_flag = $ALL_FLAG"
   echo "Expecting all_flag to be 0 or 1."
   echo ""
   exit 0
endif

if ($ALL_FLAG == "0" && $INPUT_FILE == "_NULL_") then
   echo ""
   echo "helppage:"
   echo " NULL input file detected."
   echo " Expecting a valid file name"
   echo ""
   exit 0
endif

set FULLHOST = `hostname`

# Get the proper MACH file
#----------------------------------------------------------------
if ($MACH == "_NULL_") then
    if (-f $KHOROS_HOME/repos/config/src_conf/default_mach.{$FULLHOST} ) then
       set MACH = $KHOROS_HOME/repos/config/src_conf/default_mach.{$FULLHOST}
    else if (-f $KHOROS_HOME/repos/config/src_conf/default_mach ) then
        set MACH = $KHOROS_HOME/repos/config/src_conf/default_mach
    else
        echo ""
        echo "helppage: The mach_def file does not exist"
        echo " Please either specify a toolkbox name or create a default"
        echo " mach file in $KHOROS_HOME/repos/config/src_conf/default_mach"
        echo " For more information please Khoros Manual Vol 1, Ch. 9"
        echo ""
        exit 1
    endif
else if (-f $MACH.{$FULLHOST} ) then
           set MACH = $MACH.{$FULLHOST}
    else if (! -f $MACH ) then
           echo ""
           echo "helppage: Error, the mach file '$MACH' for the toolbox"
           echo " specified was not found. Please create a mach file in"
           echo " in $MACH"
           echo ""
           exit 1
    endif
endif

# source the mach file determined in the chaos above
source $MACH

if (! -d $LOCAL_SRC_TOP) then
   echo ""
   echo "helppage: Error, the LOCAL_SRC_TOP field is not set."
   echo "Please set this field in the mach-def file."
   echo ""
   goto cleanup
endif

set HOMEDIR = $LOCAL_SRC_TOP:h
set PWD = `pwd`
set RAW_DIR = $HOMEDIR/man/man1
set FORMAT_DIR = $HOMEDIR/man/cat1
set MANDIR = $HOMEDIR/doc/manpages
set TEMPDIR = /tmp

#-----------  DEBUG INFO  ----------------------
# echo "INPUT_FILE:  $INPUT_FILE"
# echo "ALL_FLAG: $ALL_FLAG"
# echo "MACH:  $MACH"
# echo "HOMEDIR:  $HOMEDIR"
# echo "RAW_DIR:  $RAW_DIR"
# echo "FORMAT_DIR: $FORMAT_DIR"
# echo "MANDIR:  $MANDIR"
# 

    if ( $ALL_FLAG) then

	cd $RAW_DIR
	foreach file (*.1)
  	   set file = `basename $file .1`
  	   echo ".pl 130i" > $TEMPDIR/$file.$$.1
  	   echo ".nr LL 6" >> $TEMPDIR/$file.$$.1
  	   cat $file.1 >> $TEMPDIR/$file.$$.1
  	   if ($TEMPDIR != ".") then
    	     mv $TEMPDIR/$file.$$.1 $file.$$.1
  	   endif
  	   vman -r $file.$$ >>& /dev/null
  	   /bin/rm -f $file.$$.1
	
  	   echo -n "Converting file: $file ... "
  	   cat -s $FORMAT_DIR/$file.$$.1 | sed -e "s|.||g" > $MANDIR/$file.1
  	   /bin/rm -f $FORMAT_DIR/$file.$$.1
  	   echo "done."
	end

        cd $PWD

    else
        cd $RAW_DIR
        if (-e $INPUT_FILE || -e $INPUT_FILE.1) then
          set file = `basename $INPUT_FILE .1`
          echo ".pl 130i" > $TEMPDIR/$file.$$.1
          echo ".nr LL 6" >> $TEMPDIR/$file.$$.1
          cat $file.1 >> $TEMPDIR/$file.$$.1
          if ($TEMPDIR != ".") then
            mv $TEMPDIR/$file.$$.1 $file.$$.1
          endif

          vman -r $file.$$ >>& /dev/null

          /bin/rm -f $file.$$.1
          cd $FORMAT_DIR
          echo -n "Converting file: $file ... "
          cat -s $file.$$.1 | sed -e "s|.||g" > $MANDIR/$file.1
          /bin/rm -f $file.$$.1
          echo "done."
          cd $PWD
        else
          echo "helppage: can not find file '$INPUT_FILE'"
        endif
      endif


cleanup:

   if (-e $file.$$.1) then
       /bin/rm -f $file.$$.1
   endif
   if (-e $FORMAT_DIR/$file.$$.1) then
       /bin/rm -f $FORMAT_DIR/$file.$$.1
   endif
   cd $PWD

   unset LOCAL_SRC_TOP

    exit 0
