 /*
  * Khoros: $Id: dmpp.c,v 1.3 1992/03/20 23:21:59 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dmpp.c,v 1.3 1992/03/20 23:21:59 dkhoros Exp $";
#endif

 /*
  * $Log: dmpp.c,v $
 * Revision 1.3  1992/03/20  23:21:59  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dmpp.c
 >>>>
 >>>>      Program Name: dmpp
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Magnitude, Power, or Phase of 1-D signal(s)
 >>>>	
 >>>>	

 >>>>            Author: Ramiro Jordan, Jeremy Worley
 >>>>
 >>>> Date Last Updated: Mon Mar  9 18:53:58 1992
 >>>>
 >>>>          Routines: main- the main program for dmpp
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dmpp.h"


/****************************************************************
 *
 * Routine Name:  main program for dmpp
 *
 *       Input:  
 *      -i  input data file (xviff file) 
 *      -o  resulting output file (xviff file) 
 *
 *
 *      [-p] type of phase (0-radians, 1-degrees)
 *      [-mp] phase range (0: -pi to pi, 1: - 0 to 2pi)
 *      [-d] data processing direction (0 = down vectors, 1 = across bands)
 *      [-m] type of response desired:
 *		0 (choose Magnitude),
 *		1 (choose Power),
 *		or 2 (choose Phase)
 *		   [default = 0] 
 *      [-s] type of scaling:
 *		0 (choose magnitude),
 *		1 (choose log(magnitude)),
 *		2 (choose log(magnitude+1)),
 *		3 (choose ln(magnitude)),
 *		or 4 (choose ln(magnitude+1))
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *image, *readimage();
int mode, output, phase, min_phase,direction;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);

  READINPUT(image);
  CHECKTYPE(program,image);
  CHECKINPUT(program,image);

  mode = dmpp->m_toggle;
  output = dmpp->s_toggle;
  phase = dmpp->p_logic;
  direction = dmpp->d_logic;
  min_phase = dmpp->mp_logic;
/* -main_before_lib_call_end */

/* -main_library_call */
  if(!(ldmpp(image,mode,output,phase,min_phase,direction))){
     fprintf(stderr,"%s:  ldmpp failed\n",program);
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
(void) writeimage(dmpp->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dmpp 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dmpp :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tMagnitude, Power, or Phase of 1-D signal(s)\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input data file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-p]  type of phase (0-radians, 1-degrees) (boolean) [false]\n");
	fprintf(stderr,"\t[-mp]  phase range (0: -pi to pi, 1: - 0 to 2pi) (boolean) [false]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-m]  type of response desired:\n");
	fprintf(stderr, "\t\t0  (choose Magnitude),\n");
	fprintf(stderr, "\t\t1  (choose Power),\n");
	fprintf(stderr, "\t\tor 2  (choose Phase)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, "\t[-s]  type of scaling:\n");
	fprintf(stderr, "\t\t0  (choose magnitude),\n");
	fprintf(stderr, "\t\t1  (choose log(magnitude)),\n");
	fprintf(stderr, "\t\t2  (choose log(magnitude+1)),\n");
	fprintf(stderr, "\t\t3  (choose ln(magnitude)),\n");
	fprintf(stderr, "\t\tor 4  (choose ln(magnitude+1))\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dmpp\n");
	fprintf(stderr, "\t[-U] Gives the usage for dmpp\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dmpp.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dmpp.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dmpp
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input data file (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*p_pstr = 
	"\nEnter: (p) type of phase (0-radians, 1-degrees) \n        {boolean, (y/n)  [no] }: "; 
char	*mp_pstr = 
	"\nEnter: (mp) phase range (0: -pi to pi, 1: - 0 to 2pi) \n        {boolean, (y/n)  [no] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*m_pstr = "\nEnter: (m) type of response desired: -- \n      \t\t0 (choose Magnitude)\n\t\t1 (choose Power)\n\t\tor 2 (choose Phase)\n  [0]:  "; 
char	*s_pstr = "\nEnter: (s) type of scaling: -- \n      \t\t0 (choose magnitude)\n\t\t1 (choose log(magnitude))\n\t\t2 (choose log(magnitude+1))\n\t\t3 (choose ln(magnitude))\n\t\tor 4 (choose ln(magnitude+1))\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dmpp", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dmpp.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dmpp: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dmpp.ans");
		}

	     }

	}

	/*
	 * allocate the dmpp structure
	 */
	dmpp = (dmpp_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dmpp_struct));

	/*
	 * get required arguments for dmpp
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dmpp->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dmpp->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dmpp->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dmpp->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dmpp->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dmpp->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dmpp->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dmpp->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dmpp->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dmpp->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dmpp
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dmpp->p_flag = vget_logic(fid, prompt_flag,
	"-p", p_pstr, &(dmpp->p_logic), 0);

	dmpp->mp_flag = vget_logic(fid, prompt_flag,
	"-mp", mp_pstr, &(dmpp->mp_logic), 0);

	dmpp->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dmpp->d_logic), 1);


	/*
	 * get optional toggles for dmpp
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dmpp->m_flag = vget_int(fid, prompt_flag,
		"-m", m_pstr, &(dmpp->m_toggle),
		0, 0, 0);

		if ((dmpp->m_toggle == 0 ) || 
		    (dmpp->m_toggle == 1 ) || 
		    (dmpp->m_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	    ok = FALSE;
	    while(!ok)
	    {
		dmpp->s_flag = vget_int(fid, prompt_flag,
		"-s", s_pstr, &(dmpp->s_toggle),
		0, 0, 0);

		if ((dmpp->s_toggle == 0 ) || 
		    (dmpp->s_toggle == 1 ) || 
		    (dmpp->s_toggle == 2 ) || 
		    (dmpp->s_toggle == 3 ) || 
		    (dmpp->s_toggle == 4 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dmpp->m_flag = vget_int(fid, prompt_flag,
		"-m", m_pstr, &(dmpp->m_toggle),
		0, 0, 0);

		if ((dmpp->m_toggle != 0 ) && 
		    (dmpp->m_toggle != 1 ) && 
		    (dmpp->m_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
		dmpp->s_flag = vget_int(fid, prompt_flag,
		"-s", s_pstr, &(dmpp->s_toggle),
		0, 0, 0);

		if ((dmpp->s_toggle != 0 ) && 
		    (dmpp->s_toggle != 1 ) && 
		    (dmpp->s_toggle != 2 ) && 
		    (dmpp->s_toggle != 3 ) && 
		    (dmpp->s_toggle != 4 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



