 /*
  * Khoros: $Id: xvutils.h,v 1.2 1992/03/20 22:35:45 dkhoros Exp $
  */

 /*
  * $Log: xvutils.h,v $
 * Revision 1.2  1992/03/20  22:35:45  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */
#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#ifndef _xvutils_h_
#define _xvutils_h_

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>      file: xvutils.h                                     <<<<
   >>>>                                                          <<<<
   >>>>      contains:  all #defines, structures, and global     <<<<
   >>>>                 definitions used by the xvutils library  <<<<
   >>>>                                                          <<<<
   >>>>      written by: Danielle Argiro, Stephanie Hallett,     <<<<
   >>>>                  Mark Young				 <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


#include "xvinclude.h"  /* includes for xvforms and xvutils */


/*
 *  structure used by xvf_create_display_widget
 */
typedef struct {

	Widget toplevel;
        Widget back;
	Widget label;
	Widget text;
	Widget glyph;

        } DisplayWid_Data;

/*
 *  structure used by the xvf_create_browser
 */
typedef struct
{
        int                    num;
        char                   **list;
} xvf_browser_list;
 
/*
 *  structure used by xvf_create_online_help
 */
typedef struct {

        DisplayWid_Data *wid_data;
        char   *filepath;

        } Help_Data;


int     BROWSER_ON;
int     Error_cnt,
        Browser_cnt,
        Exit_cnt,
        Help_cnt,
        OnlineHelp_cnt,
        Display_cnt,
        View_cnt,
        Inform_cnt,
        Query_cnt,
        List_cnt,
        Text_cnt,
        Select_cnt,
        Warn_cnt;

int     HELP_DONE,
        VIEW_DONE,
        ONLINE_HELP_DONE,
        EXIT_DONE,
        WARN_DONE,
    	ERROR_DONE,
    	QUERY_DONE,
    	BROWSER_DONE,
    	LIST_DONE,
    	TEXT_DONE,
    	SELECT_DONE,
    	DISPLAY_DONE;


int 	EXIT_SIG;
int 	WARN_SIG;
int 	QUERY_SIG;
int 	USE_TEXT;
int 	SELECT_SIG;

#define LEFT_MARGIN 6

#define BOGUS_PATH     0
#define DIRECTORY_PATH 1
#define FILE_PATH      2

#define XVFMaxFileNum     50

/*
 *  Routines to create each type of composite widget
 */  
int     xvf_create_warn();
int     xvf_create_error();
int     xvf_create_exit();
int     xvf_create_select();
int     xvf_create_help();
Widget  xvf_create_query();
int     xvf_create_info();
Widget  xvf_create_list_widget();
int     xvf_create_online_help();

DisplayWid_Data *xvf_create_display_widget();
int     	 xvf_update_display_widget();

/*
 *  Callbacks for each type of composite widget
 */
void xvf_list_multsel_cb();
void xvf_user_defined_cb();
void xvf_user_defined_multsel_cb();
void xvf_list_cb();
void xvf_reg_str_cb();
void xvf_cancel_list_cb();

void xvf_warn_yes();
void xvf_warn_no();
void xvf_error_ok();
void xvf_exit_yes();
void xvf_exit_no();
void xvf_exit_canc();
void xvf_select_cb();
void xvf_select_cancel_cb();
void xvf_quit_help();
void xvf_quit_query();
void xvf_quit_display();
void xvf_unglyph_display();
void xvf_glyph_display();
void xvf_info_ok();

#endif /* _xvutils_h_ */
/* Don't add after the endif */
