#ifndef TRANSFORM3DEF
#define TRANSFORM3DEF

#include "geometry/hpoint3.h"
#include "geometry/hplane3.h"

typedef float Tm3Coord;
typedef Tm3Coord Transform3[4][4];

/* Note: This define was removed when Pat did the late 1989 modications to the library.  I don't know why, and */
 /* since MinneView depends on it, I'm putting it back.  -mark meuer */
#define TMNULL  ((TmCoord (*)[4])0)     /* How to pass a NULL Transform ptr */


#ifndef X
#define X 0
#define Y 1
#define Z 2
#define W 3
#endif


extern void Tm3Adjoint(/* Transform3, Transform3 */);
extern float Tm3Invert(/* Transform3 T, Transform3 Tinv */);
extern float Tm3Determinant(/* Transform3 T */);
extern void Tm3Dual(/* Transform3 T, Transform3 Tdual */);
extern void Tm3Transpose(/* Transform3 Ta, Transform3 Tb */);
extern void Tm3PostConcat(/* Transform3 Ta, Transform3 Tb */);
extern void Tm3PreConcat(/* Transform3 Ta, Transform3 Tb */);
extern void Tm3Concat(/* Transform3 Ta, Transform3 Tb, Transform3 Tc */);

extern void Tm3Print(/* Transform3 T */);
extern void Tm3Copy(/* Transform3 Ta, Transform3 Tb */);
extern void Tm3Push(/* Transform3 T */);
extern void Tm3Pop(/* Transform3 T */);

extern void Tm3Conjugate(/* Transform3 T, Transform3 Tcon, Transform3 Tres */);

extern void Tm3Identity(/* Transform3 T */);
extern void Tm3HypTranslate(/* Transform3 T, float x, float y, float z */);
extern void Tm3Translate(/* Transform3 T, float tx, float ty, float tz */);
extern void Tm3RotateX(/* Transform3 T, float angle */);
extern void Tm3RotateY(/* Transform3 T, float angle */);
extern void Tm3RotateZ(/* Transform3 T, float angle */);
extern void Tm3Rotate(/* Transform3 T, float angle, Point *axis */);
extern void Tm3AlignX(/* Transform3 T, Point *axis */);
extern void Tm3AlignY(/* Transform3 T, Point *axis */);
extern void Tm3AlignZ(/* Transform3 T, Point *axis */);
extern void Tm3Align(/* Transform3 T, Point *axis, Point *newaxis */);
extern void Tm3Scale(/* Transform3 T, float sx, float sy, float sz */);
extern void Tm3Skew(/*Transform3 T, float angle, Point *axis1, Point *axis2*/);
extern void Tm3Shear(/* Transform3 T, Point *pt, Plane *pl */);
extern void Tm3Reflect(/* Transform3 T, Plane *pl */);
extern int  Tm3Refract(/* Transform3 T, Plane *pl, float eta */);
extern int  Tm3Refract2(/* Transform3 T, Plane *pl, float eta */);
extern void Tm3Project(/* Transform3 T, Plane *pl, Point *pt */);

extern void Tm3Orthographic(/* Transform3 T,
    float l, float r, float b, float t, float n, float f */);
extern void Tm3Perspective(/* Transform T,
    float l, float r, float b, float t, float n, float f */);
extern void Tm3Window(/* Transform3 T, float l, float r, float b, float t */);

extern void Ctm3HypTranslate(/* Transform3 T, float x, float y, float z */);
extern void Ctm3Translate(/* Transform3 T, float tx, float ty, float tz */);
extern void Ctm3RotateX(/* Transform3 T, float angle */);
extern void Ctm3RotateY(/* Transform3 T, float angle */);
extern void Ctm3RotateZ(/* Transform3 T, float angle */);
extern void Ctm3Rotate(/* Transform3 T, float angle, Point *axis */);
extern void Ctm3AlignX(/* Transform3 T, Point *axis */);
extern void Ctm3AlignY(/* Transform3 T, Point *axis */);
extern void Ctm3AlignZ(/* Transform3 T, Point *axis */);
extern void Ctm3Align(/* Transform3 T, Point *axis, Point *newaxis */);
extern void Ctm3Scale(/* Transform3 T, float sx, float sy, float sz */);
extern void Ctm3Skew(/*Transform3 T, float angle, Point *axis1, Point *axis2*/);
extern void Ctm3Shear(/* Transform3 T, Point *pt, Plane *pl */);
extern void Ctm3Reflect(/* Transform3 T, Plane *pl */);
extern int  Ctm3Refract(/* Transform3 T, Plane *pl, float eta */);
extern int  Ctm3Refract2(/* Transform3 T, Plane *pl, float eta */);
extern void Ctm3Project(/* Transform3 T, Plane *pl, Point *pt */);

extern void Ctm3Orthographic(/* Transform3 T,
    float l, float r, float b, float t, float n, float f */);
extern void Ctm3Perspective(/* Transform T,
    float l, float r, float b, float t, float n, float f */);
extern void Ctm3Window(/* Transform3 T, float l, float r, float b, float t */);

extern HPoint3 TM3_XAXIS;
extern HPoint3 TM3_YAXIS;
extern HPoint3 TM3_ZAXIS;
extern Transform3 TM3_IDENTITY;
# endif
