* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* **          MATHEMATICAL ANALYSIS BY JOHN SNYDER                    **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
*                       *  POLAR STEREOGRAPHIC  *
* **********************************************************************
*
      SUBROUTINE PJ06Z0
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 SWITCH,IND,I,ZONE,IPFILE,IFLG
      CHARACTER*16 ANGS(2)
      COMMON /ELLPZ0/ AZ,EZ,ESZ,E0Z,E1Z,E2Z,E3Z,E4Z
* **** PARAMETERS **** A,E,ES,LON0,LATC,X0,Y0,E4,MCS,TCS,FAC,IND *******
      DIMENSION DATA(1),GEOG(1),PROJ(1)
      DATA NINTYD /900000.0D0/
      DATA ZERO,ONE,TWO /0.0D0,1.0D0,2.0D0/
      DATA SWITCH /0/
*
* ......................................................................
*      .  INITIALIZATION OF PROJECTION PARAMETERS (ENTRY INPUT)  .
* ......................................................................
*
      ENTRY IS06Z0 (ZONE,DATA,IPFILE,IFLG)
*
      IFLG = 0
      IF (SWITCH.NE.0 .AND. SWITCH.EQ.ZONE) RETURN
      IF (DATA(1) .LE. ZERO) GO TO 100
      A = DATA(1)
      B = DATA(2)
      IF (B .GT. ZERO) GO TO 040
      E = ZERO
      ES = ZERO
      E4 = ONE
      GO TO 120
  040 IF (B .GT. ONE) GO TO 060
      E = DSQRT (B)
      ES = B
      GO TO 080
  060 ES = ONE - (B / A) ** 2
      E = DSQRT (ES)
  080 E4 = E4FNZ0 (E)
      GO TO 120
  100 A = AZ
      E = EZ
      ES = ESZ
      E4 = E4Z
  120 CALL UNITZ0 (DATA(5),5,LON0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      SAVE = DATA(6)
      CALL UNITZ0 (SAVE,5,LATC,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      X0 = DATA(7)
      Y0 = DATA(8)
      FAC = ONE
      IF (SAVE .LT. ZERO) FAC =-ONE
      IND = 0
      IF (DABS(SAVE) .EQ. NINTYD) GO TO 130
      IND = 1
      CON1 = FAC * LATC
      SINPHI = DSIN (CON1)
      COSPHI = DCOS (CON1)
      MCS = MSFNZ0 (E,SINPHI,COSPHI)
      TCS = TSFNZ0 (E,CON1,SINPHI)
*
* LIST RESULTS OF PARAMETER INITIALIZATION.
*
  130 CALL DMSLZ0 (LON0,0,ANGS(1),IPFILE,IFLG)
      CALL DMSLZ0 (LATC,0,ANGS(2),IPFILE,IFLG)
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000) A,ES,ANGS,X0,Y0
 2000 FORMAT (' INITIALIZATION PARAMETERS (POLAR STEREOGRAPHIC',
     .        ' PROJECTION)'/
     .        ' SEMI-MAJOR AXIS OF ELLIPSOID =',F16.4,' METERS'/
     .        ' ECCENTRICITY SQUARED         =',F16.13/
     .        ' LONGITUDE OF Y-AXIS          =',A16/
     .        ' LATITUDE OF TRUE SCALE       =',A16/
     .        ' FALSE EASTING                =',F16.4,' METERS'/
     .        ' FALSE NORTHING               =',F16.4,' METERS')
      SWITCH = ZONE
      RETURN
*
* ......................................................................
*                      .  FORWARD TRANSFORMATION  .
* ......................................................................
*
      ENTRY PF06Z0 (GEOG,PROJ,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 220
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010)
 2010 FORMAT (' UNINITIALIZED TRANSFORMATION')
      IFLG = 600
      RETURN
  220 CON1 = FAC * ADJLZ0 (GEOG(1) - LON0)
      CON2 = FAC * GEOG(2)
      SINPHI = DSIN (CON2)
      TS = TSFNZ0 (E,CON2,SINPHI)
      IF (IND .EQ. 0) GO TO 240
      RH = A * MCS * TS / TCS
      GO TO 260
  240 RH = TWO * A * TS / E4
  260 PROJ(1) = X0 + FAC * RH * DSIN (CON1)
      PROJ(2) = Y0 - FAC * RH * DCOS (CON1)
      RETURN
*
* ......................................................................
*                      .  INVERSE TRANSFORMATION  .
* ......................................................................
*
      ENTRY PI06Z0 (PROJ,GEOG,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 320
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010)
      IFLG = 600
      RETURN
  320 X = FAC * (PROJ(1) - X0)
      Y = FAC * (PROJ(2) - Y0)
      RH = DSQRT (X * X + Y * Y)
      IF (IND .EQ. 0) GO TO 340
      TS = RH * TCS / (A * MCS)
      GO TO 360
  340 TS = RH * E4 / (TWO * A)
  360 GEOG(2) = FAC * PHI2Z0 (E,TS,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      IF (RH .NE. ZERO) GO TO 400
      GEOG(1) = FAC * LON0
      RETURN
  400 GEOG(1) = ADJLZ0 (FAC * DATAN2 (X , -Y) + LON0)
      RETURN
*
      END
