* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
      DOUBLE PRECISION FUNCTION PHI2Z0 (ECCENT,TS,IPFILE,IFLG)
*
* FUNCTION TO COMPUTE LATITUDE ANGLE (PHI-2).
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 II,NIT,IPFILE,IFLG
      DATA HALF,ONE,TWO /0.5D0,1.0D0,2.0D0/
      DATA TOL,NIT /1.0D-10,15/
      DATA HALFPI /1.57079632679489661923D0/
*
      ECCNTH = HALF * ECCENT
      PHI = HALFPI - TWO * DATAN (TS)
      DO 020 II = 1,NIT
      SINPI = DSIN (PHI)
      CON = ECCENT * SINPI
      DPHI = HALFPI - TWO * DATAN (TS * ((ONE - CON) /
     .       (ONE + CON)) ** ECCNTH) - PHI
      PHI = PHI + DPHI
      IF (DABS(DPHI) .GT. TOL) GO TO 020
      PHI2Z0 = PHI
      RETURN
  020 CONTINUE
*
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000)
 2000 FORMAT (' LATITUDE FAILED TO CONVERGE')
      IFLG = 22
      RETURN
*
      END
