/*  				grainv4.c               */
/*    ASC.Lee@ee.qub.ac.uk                              */
/*Copyright 1994, 1995 by the Allan S C Lee, Queen's        */
/*University of Belfast. All rights reserved.               */
/*                                                          */
/*Permission to use, copy, or modify this software and      */
/*documentation for educational and research purposes only  */
/*and without fee is hereby granted, provided that this     */
/*copyright and permission notice appear on all copies and  */
/*supporting documentation.  For any other uses of this     */
/*software, in original or modified form, including but not */
/*limited to distribution in whole or in part, specific     */
/*prior permission from Allan S C Lee must be obtained.     */
/*Allan S C Lee and Queen's University of Belfast make      */
/*no representations about the suitability of this software */
/*for any purpose. It is provided "as is" without express   */
/*or implied warranty.                                      */
/*                                                          */
/*                                                      */
/* Verson 4.0 -    Mar 95                               */
/* Verson 4.1 - 10 Mar 95                               */
/*        Lifted restriction on pitch, now accept       */
/*        anything greater than zero                    */ 
/*        Improved code in handling the warp-round      */
/*        pointer.                                      */
/* Verson 4.2 - 20 Apr 95                               */      
/*        Add optional parameter ifnenv                 */ 
/*        Function table to be used for the shape of the*/
/*        envelop rise and decade curve                 */
/* Minor changes by John Fitch Dec 1995                 */

#include "cs.h"
#include "grain4.h"
#include <math.h>

#define        RNDMUL  15625L

#define		DEBUG	(0)

float grand(GRAINV4 *);
float envv4(int *, GRAINV4 *);

void grainsetv4(GRAINV4 *p)
{
    FUNC	*ftp, *ftp_env;
    int		nvoice, cnt;
    long	tmplong1, tmplong2;
    float	tmpfloat1;
    float	pitch[4];

    /* call ftfind() to get the function table...*/
    if ((ftp = ftfind(p->ifn)) != NULL) {
      if (DEBUG) printf("granule_set: Find ftable OK...\n");
      p->ftp = ftp;
    }
    else {
      initerror("granule_set: Unable to find function table");
      return;
    } 

    /* call ftfind() to get the function table for the envelop...*/
    if (DEBUG) printf ("*p->ifnenv is %f \n", *p->ifnenv);

    if (*p->ifnenv > 0) {
      if ((ftp_env = ftfind(p->ifnenv)) != NULL) {
        if (DEBUG) printf("granule_set: Find ftable for envelop OK...\n");
        p->ftp_env = ftp_env;
      }
      else {
        initerror("granule_set: Unable to find function table for envelop");
        return;
      }
    }

    if (*p->ivoice > MAXVOICE) {
      initerror("granule_set: Too many voices");
      return;
    }
    if (*p->iratio <= 0) {
      initerror("granule_set: iratio must be greater then 0");
      return;
    }
    if ((*p->imode != 0) && ((*p->imode != -1) && (*p->imode != 1))) {
      initerror("granule_set: imode must be -1, 0 or +1");
      return;
    }
    if (*p->ithd < 0) {
      initerror("granule_set: Illegal ithd, must be greater then 0");
      return;
    }
    if ((*p->ipshift != 1) && (*p->ipshift!=2) && (*p->ipshift!=3) &&
	(*p->ipshift!=4) && (*p->ipshift!=0) ) {
      initerror("granule_set: ipshift must be integer between 0 and 4");
      return;
    }
    if (((*p->ipshift >=1) && (*p->ipshift <=4)) &&
	(*p->ivoice < *p->ipshift) ){
      initerror("granule_set: Not enough voices for the number of pitches");
      return;
    }
    if ( *p->ipshift !=0 ) {
      if (*p->ipitch1 < 0.0 ) {
        initerror("granule_set: ipitch1 must be greater then zero");
        return;
      }
      if (*p->ipitch2 < 0.0 ) {
        initerror("granule_set: ipitch2 must be greater then zero");
        return;
      }
      if (*p->ipitch3 < 0.0 ) {
        initerror("granule_set: ipitch3 must be greater then zero");
        return;
      }
      if (*p->ipitch4 < 0.0 ) {
        initerror("granule_set: ipitch4 must be greater then zero");
        return;
      }
    }

    if ((*p->igskip < 0) || (*p->igskip * esr > ftp->flen) ) {
      initerror("granule_set: must be positive and smaller than"
		"function table length");
      return;
    } 
    if (*p->igskip_os < 0) {
      initerror("granule_set: igskip_os must be greater then 0");
      return;
    }

    p->gstart = *p->igskip * esr;
    p->glength = *p->ilength * esr;
    p->gend = p->gstart + p->glength;

    if (*p->kgap < 0) {
      initerror("granule_set: kgap must be greater then 0");
      return;
    }
    if ((*p->igap_os < 0) || (*p->igap_os > 100)) {
      initerror("granule_set: igap_os must be 0%% to 100%%");
      return;
    }
    if (*p->kgsize < 0) {
      initerror("granule_set: kgsize must be greater then 0");
      return;
    }
    if ((*p->igsize_os < 0) || (*p->igsize_os >100)) {
      initerror("granule_set: igsize_os must be 0%% to 100%%");
      return;
    }
    if ((*p->iatt < 0.0) || (*p->idec < 0.0) ||
	((*p->iatt + *p->idec) > 100.0)) {
      initerror("granule_set: Illegal value of iatt and/or idec");
      return;
    } /* end if */


    /* Initialize random number generator */
    if (*p->iseed >=0)
      p->grnd = *p->iseed * 32768;

				/* Initialize variables....*/
    p->gskip_os = *p->igskip_os * esr;/* in number of samples */
    p->gap_os = *p->igap_os / 100.0;
    p->gsize_os = *p->igsize_os / 100.0;

    for (nvoice = 0; nvoice < *p->ivoice; nvoice++) {
      p->fpnt[nvoice] = 0;
      p->cnt[nvoice]  = 0;
      p->phs[nvoice]  = 0.0;
      p->gskip[nvoice] = *p->igskip * esr;
      p->gap[nvoice] = *p->kgap * esr;
    }

    if (*p->igap_os != 0) {
      for (nvoice = 0; nvoice < *p->ivoice; nvoice++) 
	p->gap[nvoice] += (p->gap[nvoice] * p->gap_os) * grand(p);
    }

    if (*p->imode == 0) {
      for (nvoice = 0; nvoice < *p->ivoice; nvoice++)
	p->mode[nvoice] = (grand(p) < 0) ? -1 : 1;
    }
    else {
      for (nvoice = 0; nvoice < *p->ivoice; nvoice++)
	p->mode[nvoice] = *p->imode;
    }

    if ((*p->ipshift >=1) && (*p->ipshift <=4)) {
      pitch[0] = *p->ipitch1;
      pitch[1] = *p->ipitch2;
      pitch[2] = *p->ipitch3;
      pitch[3] = *p->ipitch4;
      cnt = 0;
      for (nvoice = 0; nvoice < *p->ivoice; nvoice++) {
	p->pshift[nvoice] = pitch[cnt++];
	cnt = (cnt < *p->ipshift) ? cnt : 0;
      }
    }
    if (*p->ipshift == 0) {
      for (nvoice = 0; nvoice < *p->ivoice; nvoice++) {
	tmpfloat1 = grand(p);
	p->pshift[nvoice] =
	  (tmpfloat1 <0.0) ? (tmpfloat1*0.5)+1.0 : tmpfloat1+1.0;
      }
    }

    for (nvoice = 0; nvoice < *p->ivoice; nvoice++)
      p->gsize[nvoice] = *p->kgsize * esr * p->pshift[nvoice];

    if (*p->igsize_os != 0) {
      for (nvoice = 0; nvoice < *p->ivoice; nvoice++)
        p->gsize[nvoice] += (p->gsize[nvoice] * p->gsize_os) * grand(p);
    }

    for (nvoice = 0; nvoice < *p->ivoice; nvoice++)
      p->stretch[nvoice] = p->gsize[nvoice] + p->gap[nvoice];

    if (*p->igskip_os != 0) 
      for (nvoice = 0; nvoice < *p->ivoice; nvoice++) {
	tmplong1 = (p->gskip_os * grand(p)) + p->gskip[nvoice];
	p->gskip[nvoice] = (tmplong1 < p->gstart) ? p->gstart : tmplong1;
	p->gskip[nvoice]=
          ((p->gskip[nvoice]+p->stretch[nvoice])>p->gend) ?
	  p->gstart :
	  p->gskip[nvoice];
      }


    if (DEBUG)
      printf("granule_set: User define sampling rate esr is %f samp/sec.\n",
	     esr);
    if (DEBUG)
      printf("granule_set: Funtion table length in samples is %d\n", ftp->flen);
    if (DEBUG)
      printf("granule_set: Funtion table length in seconds is %f\n",
	     ftp->flen / esr);

    if (*p->ithd != 0) {	/* Do thresholding.... */
      if (DEBUG) printf("granule_set: Doing thresholding %f \n",*p->ithd);
      tmplong2 = 0;
      for (tmplong1=0; tmplong1<ftp->flen; tmplong1++)
	if (fabs(*(ftp->ftable + tmplong1)) >= *p->ithd )
	  *(ftp->ftable + tmplong2++) = *(ftp->ftable + tmplong1);
      ftp->flen = tmplong2;
      if (DEBUG)
	printf("granule_set: Function table shrink to %d samples\n",ftp->flen);
      if (DEBUG)
	printf("granule_set: Function table shrink to %f sec"
	       "after thresholding\n", ftp->flen / esr);
    }

    if (p->gend > ftp->flen) {
      initerror("granule_set: Illegal combination of igskip and ilength");
      return;
    }
 

    nvoice = *p->ivoice;
    if (DEBUG) printf("granule_set: nvoice is %d\n",nvoice);

    if (*p->ilength < (20 * *p->kgsize)) {
      printf("granule_set: WARNING * ilength may be too short * \n");
      printf("            ilength should be greater than kgsize * max up\n");
      printf("            pitch shift. Also, igsize_os and igskip_os should\n");
      printf("            be taken into consideration.\nilength is ");
      printf("%f Sec, kgsize is %f Sec\n", *p->ilength, *p->kgsize);
    }
   
    p->clock = 0;		/* init clock */

} /* end grainsetv4(p) */




void graingenv4(GRAINV4 *p)
{
    FUNC	*ftp, *ftp_env;
    float	*ar, *ftbl, *ftbl_env;
    int		nsmps = ksmps;
    int		nvoice;
    long	flen, tmplong1, tmplong2, tmplong3, tmpfpnt, flen_env;
    float	fract, v1, tmpfloat1;
    long	att_len, dec_len, att_sus;
    float	envlop;

 /* Recover parameters from previous call.... */
   ftp = p->ftp;
   flen = ftp->flen;
   ftbl = ftp->ftable;

   if (*p->ifnenv > 0) {
     ftp_env = p->ftp_env;
     flen_env = ftp_env->flen;
     ftbl_env = ftp_env->ftable;
   }

   /* Recover audio output pointor... */
   ar   = p->ar;


   /* *** Start the loop .... *** */
   do {				/* while (--nsmps) */
     *ar = 0;

     for (nvoice = 0; nvoice < *p->ivoice; nvoice++) {

       if (p->fpnt[nvoice] >= (p->gsize[nvoice] -1)) {
	 *ar += 0;
	 p->cnt[nvoice] +=1;
       }
       else {
	 fract = p->phs[nvoice] - p->fpnt[nvoice];

	 if (p->mode[nvoice] < 0) {
	   tmplong1 = p->gskip[nvoice] - p->gstart;
	   if (p->fpnt[nvoice] >= tmplong1) {
	     tmplong1= p->fpnt[nvoice] - tmplong1;
	     tmplong2= tmplong1/p->glength;
	     tmplong1 -= tmplong2 * p->glength;
	     tmpfpnt = p->gend - tmplong1;
	   }
	   else
	     tmpfpnt = p->gskip[nvoice] - p->fpnt[nvoice];
	 }
	 else {
	   tmplong1 = p->gend - p->gskip[nvoice];
	   if (p->fpnt[nvoice] >= tmplong1) {
	     tmplong1= p->fpnt[nvoice] - tmplong1;
	     tmplong2= tmplong1/p->glength;
	     tmplong1 -= tmplong2 * p->glength;
	     tmpfpnt = p->gstart + tmplong1;
	   }
	   else
	     tmpfpnt = p->gskip[nvoice] + p->fpnt[nvoice];
	 }

	 att_len = (p->gsize[nvoice] * *p->iatt) * 0.01;
	 dec_len = (p->gsize[nvoice] * *p->idec) * 0.01;
	 att_sus =  p->gsize[nvoice] -  dec_len;
	 
	 if (p->fpnt[nvoice] < att_sus) {
	   tmpfloat1 = (1.0 * p->fpnt[nvoice]) / att_len;
	   envlop = ((tmpfloat1 >=1.0) ? 1.0 : tmpfloat1);
	 }
	 else 
	   envlop =
	     ((float)(dec_len - (p->fpnt[nvoice] - att_sus)))/((float)dec_len);

	 v1 = *(ftbl + tmpfpnt);
	 
	 tmpfpnt = tmpfpnt + p->mode[nvoice];
	 if (tmpfpnt < p->gstart)
	   tmpfpnt = p->gend - (p->gstart - tmpfpnt) + 1;
	 if (tmpfpnt > p->gend)
	   tmpfpnt = p->gstart + (tmpfpnt - p->gend) - 1;
	 
	 if (*p->ifnenv > 0) {
	   tmplong3 = (envlop * flen_env) -1;
	   envlop = *(ftbl_env + tmplong3);
	 }

	 *ar +=(v1 + ( *(ftbl + tmpfpnt)   - v1) * fract ) * envlop ;
	 
	 p->phs[nvoice] += p->pshift[nvoice];
	 p->fpnt[nvoice] = p->phs[nvoice];
	 p->cnt[nvoice]  = p->phs[nvoice];
       } /* end if (p->fpnt[nvoice] >= (p->gsize[nvoice] -1)) */

       if (p->cnt[nvoice] >= p->stretch[nvoice]) {
	 p->cnt[nvoice] = 0;
	 p->fpnt[nvoice]= 0;
	 p->phs[nvoice] = 0.0;
	 
				/* pick up new values... */

				/* Use the old value of the pshift, gsize and gap */
				/*           to determine the time advanced */
	 /*           p->gskip[nvoice]+=
		      ((p->gsize[nvoice] / p->pshift[nvoice]) + 
		      p->gap[nvoice]) * *p->iratio;
		      */
	 p->gskip[nvoice] +=
           (p->gsize[nvoice] / p->pshift[nvoice]) * *p->iratio;

	 if (*p->igskip_os != 0) 
	   p->gskip[nvoice]  += (p->gskip_os * grand(p));
	 
	 if (p->gskip[nvoice] >= p->gend) {
	   tmplong1 = p->gskip[nvoice] - p->gend;
	   tmplong2 = tmplong1 /p->glength;
	   tmplong1 -= tmplong2 * p->glength;
	   p->gskip[nvoice] = p->gstart + tmplong1;
	 }

	 if (p->gskip[nvoice] < p->gstart) p->gskip[nvoice] = p->gstart;

	 if (*p->imode == 0)
	   p->mode[nvoice] = (grand(p) < 0) ? -1 : 1;
	   
           if (*p->ipshift == 0) {
	     tmpfloat1 = grand(p);
	     p->pshift[nvoice] = (tmpfloat1 < 0.0) ?
	       (tmpfloat1*0.5)+1.0 : tmpfloat1+1.0;
           }

           p->gap[nvoice] = *p->kgap * esr;
           if (*p->igap_os != 0) {
	     p->gap[nvoice] += (p->gap[nvoice] * p->gap_os) * grand(p);
           } 

           p->gsize[nvoice] = *p->kgsize * esr * p->pshift[nvoice];
           if (*p->igsize_os != 0)
             p->gsize[nvoice] += (p->gsize[nvoice] * p->gsize_os) * grand(p);

	     p->stretch[nvoice] = p->gsize[nvoice] + p->gap[nvoice];

         } 
     }

				/*   p->clock++; */
     *ar++ *= *p->xamp;		/* increment audio pointer and multiply the xamp */

   } while (--nsmps);
} /* end graingenv4(p) */


/* Function takes in fpnt pointing to a relative
    position of gsize,
    returns a float between 0.0 to 1.0
*/
float envv4(int *nvoice, GRAINV4 *p)
{
    long	att_len, dec_len, att_sus;
    float	tmp, result;
 
    att_len = (p->gsize[*nvoice] * *p->iatt) * 0.01;
    dec_len = (p->gsize[*nvoice] * *p->idec) * 0.01;
    att_sus =  p->gsize[*nvoice] -  dec_len;
 
    if (p->fpnt[*nvoice] < att_sus) {
      tmp = ((float) p->fpnt[*nvoice]) / (float)att_len;
      result = (tmp >=1.0) ? 1.0 : tmp;
    }
    else 
      result = ((float)(dec_len - (p->fpnt[*nvoice]-att_sus)) / (float)dec_len);
 
/* printf("envv4: %f\n", result); */
    return (result);
}



/* Function return a float random number between -1 to +1 */
float grand( GRAINV4 *p)
{
   p->grnd *= RNDMUL;
   p->grnd += 1;
   return ( (float)p->grnd * dv32768 );
} /* end grand(p) */
