/* --------------------------------- lnxstick.c ----------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Handler for the joystick as a pointing device for Linux/X11.
 *
 *  This one sits above joyport.c/gameport.c and under stick.c.
*/

#include "fly.h"

#ifdef HAVE_JOYSTICK

#include "stick.h"

#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>

#ifdef USE_GAME
extern int	initgame (int which, int fjs, int opts);
extern Uint	readgame (int which, int fjs, STICK *j, int mask, int opts);
#endif

#ifdef USE_JOY
extern int	initjoy (int which, int fjs, int opts);
extern Uint	readjoy (int which, int fjs, STICK *j, int mask, int opts);
#endif

static int	js[2] = {-1, -1};

extern int
initstick (int which, int opts)
{
	int	ret = 1;

	if ((js[which] = open (which ? "/dev/js1" : "/dev/js0", O_RDONLY)) < 0) {
		LogPrintf ("js%d open failed %d\n", which, errno);
		return (1);
	}

#ifdef USE_GAME
	if (opts & USEGAME)
		ret = initgame (which, js[which], opts);
#endif
#ifdef USE_JOY
	if (!(opts & USEGAME))
		 ret = initjoy (which, js[which], opts);
#endif
	return (ret);
}

extern int
termstick (int which, int opts)
{
	if (js[which] >= 0) {
		close (js[which]);
		js[which] = -1;
	}
	return (0);
}

extern Uint
readstick (int which, STICK *j, int mask, int opts)
{
	int	ret = 0xff;

	if (js[which] < 0)
		return (ret);

#ifdef USE_GAME
	if (opts & USEGAME)
		ret = readgame (which, js[which], j, mask, opts);
#endif
#ifdef USE_JOY
	if (!(opts & USEGAME))
		ret = readjoy (which, js[which], j, mask, opts);
#endif
	return (ret);
}

#endif
