# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.hdinsight import HDInsightManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHDInsightManagementExtensionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HDInsightManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_enable_monitoring(self, resource_group):
        response = self.client.extensions.begin_enable_monitoring(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={"primaryKey": "str", "workspaceId": "str"},
            api_version="2024-08-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_monitoring_status(self, resource_group):
        response = self.client.extensions.get_monitoring_status(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_disable_monitoring(self, resource_group):
        response = self.client.extensions.begin_disable_monitoring(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-08-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_enable_azure_monitor(self, resource_group):
        response = self.client.extensions.begin_enable_azure_monitor(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={
                "primaryKey": "str",
                "selectedConfigurations": {
                    "configurationVersion": "str",
                    "globalConfigurations": {"str": "str"},
                    "tableList": [{"name": "str"}],
                },
                "workspaceId": "str",
            },
            api_version="2024-08-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_azure_monitor_status(self, resource_group):
        response = self.client.extensions.get_azure_monitor_status(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_disable_azure_monitor(self, resource_group):
        response = self.client.extensions.begin_disable_azure_monitor(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-08-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_enable_azure_monitor_agent(self, resource_group):
        response = self.client.extensions.begin_enable_azure_monitor_agent(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={
                "primaryKey": "str",
                "selectedConfigurations": {
                    "configurationVersion": "str",
                    "globalConfigurations": {"str": "str"},
                    "tableList": [{"name": "str"}],
                },
                "workspaceId": "str",
            },
            api_version="2024-08-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_azure_monitor_agent_status(self, resource_group):
        response = self.client.extensions.get_azure_monitor_agent_status(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_disable_azure_monitor_agent(self, resource_group):
        response = self.client.extensions.begin_disable_azure_monitor_agent(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-08-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create(self, resource_group):
        response = self.client.extensions.begin_create(
            resource_group_name=resource_group.name,
            cluster_name="str",
            extension_name="str",
            parameters={"primaryKey": "str", "workspaceId": "str"},
            api_version="2024-08-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.extensions.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            extension_name="str",
            api_version="2024-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.extensions.begin_delete(
            resource_group_name=resource_group.name,
            cluster_name="str",
            extension_name="str",
            api_version="2024-08-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_azure_async_operation_status(self, resource_group):
        response = self.client.extensions.get_azure_async_operation_status(
            resource_group_name=resource_group.name,
            cluster_name="str",
            extension_name="str",
            operation_id="str",
            api_version="2024-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...
