# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AcceptJobOfferResult(_serialization.Model):
    """Response containing Id's for the worker, job, and assignment from an accepted offer.

    All required parameters must be populated in order to send to Azure.

    :ivar assignment_id: The assignment Id that assigns a worker that has accepted an offer to a
     job. Required.
    :vartype assignment_id: str
    :ivar job_id: The Id of the job assigned. Required.
    :vartype job_id: str
    :ivar worker_id: The Id of the worker that has been assigned this job. Required.
    :vartype worker_id: str
    """

    _validation = {
        "assignment_id": {"required": True},
        "job_id": {"required": True},
        "worker_id": {"required": True},
    }

    _attribute_map = {
        "assignment_id": {"key": "assignmentId", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "worker_id": {"key": "workerId", "type": "str"},
    }

    def __init__(self, *, assignment_id: str, job_id: str, worker_id: str, **kwargs):
        """
        :keyword assignment_id: The assignment Id that assigns a worker that has accepted an offer to a
         job. Required.
        :paramtype assignment_id: str
        :keyword job_id: The Id of the job assigned. Required.
        :paramtype job_id: str
        :keyword worker_id: The Id of the worker that has been assigned this job. Required.
        :paramtype worker_id: str
        """
        super().__init__(**kwargs)
        self.assignment_id = assignment_id
        self.job_id = job_id
        self.worker_id = worker_id


class DistributionMode(_serialization.Model):
    """Abstract base class for defining a distribution mode.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BestWorkerMode, LongestIdleMode, RoundRobinMode

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Mode. Required.
    :vartype kind: str
    :ivar min_concurrent_offers: Governs the minimum desired number of active concurrent offers a
     job can have. Required.
    :vartype min_concurrent_offers: int
    :ivar max_concurrent_offers: Governs the maximum number of active concurrent offers a job can
     have. Required.
    :vartype max_concurrent_offers: int
    :ivar bypass_selectors: (Optional)
     If set to true, then router will match workers to jobs even if they don't match label
     selectors.
     Warning: You may get workers that are not qualified for the job they are matched with if you
     set this
     variable to true. This flag is intended more for temporary usage.
     By default, set to false.
    :vartype bypass_selectors: bool
    """

    _validation = {
        "kind": {"required": True},
        "min_concurrent_offers": {"required": True},
        "max_concurrent_offers": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "min_concurrent_offers": {"key": "minConcurrentOffers", "type": "int"},
        "max_concurrent_offers": {"key": "maxConcurrentOffers", "type": "int"},
        "bypass_selectors": {"key": "bypassSelectors", "type": "bool"},
    }

    _subtype_map = {
        "kind": {"best-worker": "BestWorkerMode", "longest-idle": "LongestIdleMode", "round-robin": "RoundRobinMode"}
    }

    def __init__(
        self,
        *,
        min_concurrent_offers: int,
        max_concurrent_offers: int,
        bypass_selectors: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword min_concurrent_offers: Governs the minimum desired number of active concurrent offers
         a job can have. Required.
        :paramtype min_concurrent_offers: int
        :keyword max_concurrent_offers: Governs the maximum number of active concurrent offers a job
         can have. Required.
        :paramtype max_concurrent_offers: int
        :keyword bypass_selectors: (Optional)
         If set to true, then router will match workers to jobs even if they don't match label
         selectors.
         Warning: You may get workers that are not qualified for the job they are matched with if you
         set this
         variable to true. This flag is intended more for temporary usage.
         By default, set to false.
        :paramtype bypass_selectors: bool
        """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]
        self.min_concurrent_offers = min_concurrent_offers
        self.max_concurrent_offers = max_concurrent_offers
        self.bypass_selectors = bypass_selectors


class BestWorkerMode(DistributionMode):
    """Jobs are distributed to the worker with the strongest abilities available.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Mode. Required.
    :vartype kind: str
    :ivar min_concurrent_offers: Governs the minimum desired number of active concurrent offers a
     job can have. Required.
    :vartype min_concurrent_offers: int
    :ivar max_concurrent_offers: Governs the maximum number of active concurrent offers a job can
     have. Required.
    :vartype max_concurrent_offers: int
    :ivar bypass_selectors: (Optional)
     If set to true, then router will match workers to jobs even if they don't match label
     selectors.
     Warning: You may get workers that are not qualified for the job they are matched with if you
     set this
     variable to true. This flag is intended more for temporary usage.
     By default, set to false.
    :vartype bypass_selectors: bool
    :ivar scoring_rule: A rule of one of the following types:

     StaticRule:  A rule providing static rules that always return the same result, regardless of
     input.
     DirectMapRule:  A rule that return the same labels as the input labels.
     ExpressionRule: A rule providing inline expression rules.
     AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
    :vartype scoring_rule: ~azure.communication.jobrouter.models.RouterRule
    :ivar scoring_rule_options: Encapsulates all options that can be passed as parameters for
     scoring rule with BestWorkerMode.
    :vartype scoring_rule_options: ~azure.communication.jobrouter.models.ScoringRuleOptions
    """

    _validation = {
        "kind": {"required": True},
        "min_concurrent_offers": {"required": True},
        "max_concurrent_offers": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "min_concurrent_offers": {"key": "minConcurrentOffers", "type": "int"},
        "max_concurrent_offers": {"key": "maxConcurrentOffers", "type": "int"},
        "bypass_selectors": {"key": "bypassSelectors", "type": "bool"},
        "scoring_rule": {"key": "scoringRule", "type": "RouterRule"},
        "scoring_rule_options": {"key": "scoringRuleOptions", "type": "ScoringRuleOptions"},
    }

    def __init__(
        self,
        *,
        min_concurrent_offers: int,
        max_concurrent_offers: int,
        bypass_selectors: Optional[bool] = None,
        scoring_rule: Optional["_models.RouterRule"] = None,
        scoring_rule_options: Optional["_models.ScoringRuleOptions"] = None,
        **kwargs
    ):
        """
        :keyword min_concurrent_offers: Governs the minimum desired number of active concurrent offers
         a job can have. Required.
        :paramtype min_concurrent_offers: int
        :keyword max_concurrent_offers: Governs the maximum number of active concurrent offers a job
         can have. Required.
        :paramtype max_concurrent_offers: int
        :keyword bypass_selectors: (Optional)
         If set to true, then router will match workers to jobs even if they don't match label
         selectors.
         Warning: You may get workers that are not qualified for the job they are matched with if you
         set this
         variable to true. This flag is intended more for temporary usage.
         By default, set to false.
        :paramtype bypass_selectors: bool
        :keyword scoring_rule: A rule of one of the following types:

         StaticRule:  A rule providing static rules that always return the same result, regardless of
         input.
         DirectMapRule:  A rule that return the same labels as the input labels.
         ExpressionRule: A rule providing inline expression rules.
         AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
        :paramtype scoring_rule: ~azure.communication.jobrouter.models.RouterRule
        :keyword scoring_rule_options: Encapsulates all options that can be passed as parameters for
         scoring rule with BestWorkerMode.
        :paramtype scoring_rule_options: ~azure.communication.jobrouter.models.ScoringRuleOptions
        """
        super().__init__(
            min_concurrent_offers=min_concurrent_offers,
            max_concurrent_offers=max_concurrent_offers,
            bypass_selectors=bypass_selectors,
            **kwargs
        )
        self.kind = "best-worker"  # type: str
        self.scoring_rule = scoring_rule
        self.scoring_rule_options = scoring_rule_options


class ExceptionAction(_serialization.Model):
    """The action to take when the exception is triggered.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CancelExceptionAction, ManualReclassifyExceptionAction, ReclassifyExceptionAction

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of ExceptionAction. Required.
    :vartype kind: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "cancel": "CancelExceptionAction",
            "manual-reclassify": "ManualReclassifyExceptionAction",
            "reclassify": "ReclassifyExceptionAction",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class CancelExceptionAction(ExceptionAction):
    """An action that marks a job as cancelled.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of ExceptionAction. Required.
    :vartype kind: str
    :ivar note: (Optional) A note that will be appended to the jobs' Notes collection with th
     current timestamp.
    :vartype note: str
    :ivar disposition_code: (Optional) Indicates the outcome of the job, populate this field with
     your own custom values.
    :vartype disposition_code: str
    """

    _validation = {
        "kind": {"required": True},
        "note": {"max_length": 2000},
        "disposition_code": {"max_length": 500},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "note": {"key": "note", "type": "str"},
        "disposition_code": {"key": "dispositionCode", "type": "str"},
    }

    def __init__(self, *, note: Optional[str] = None, disposition_code: Optional[str] = None, **kwargs):
        """
        :keyword note: (Optional) A note that will be appended to the jobs' Notes collection with th
         current timestamp.
        :paramtype note: str
        :keyword disposition_code: (Optional) Indicates the outcome of the job, populate this field
         with your own custom values.
        :paramtype disposition_code: str
        """
        super().__init__(**kwargs)
        self.kind = "cancel"  # type: str
        self.note = note
        self.disposition_code = disposition_code


class CancelJobRequest(_serialization.Model):
    """Request payload for deleting a job.

    :ivar note: (Optional) A note that will be appended to the jobs' Notes collection with th
     current timestamp.
    :vartype note: str
    :ivar disposition_code: Indicates the outcome of the job, populate this field with your own
     custom values.
     If not provided, default value of "Cancelled" is set.
    :vartype disposition_code: str
    """

    _validation = {
        "note": {"max_length": 2000},
        "disposition_code": {"max_length": 500},
    }

    _attribute_map = {
        "note": {"key": "note", "type": "str"},
        "disposition_code": {"key": "dispositionCode", "type": "str"},
    }

    def __init__(self, *, note: Optional[str] = None, disposition_code: Optional[str] = None, **kwargs):
        """
        :keyword note: (Optional) A note that will be appended to the jobs' Notes collection with th
         current timestamp.
        :paramtype note: str
        :keyword disposition_code: Indicates the outcome of the job, populate this field with your own
         custom values.
         If not provided, default value of "Cancelled" is set.
        :paramtype disposition_code: str
        """
        super().__init__(**kwargs)
        self.note = note
        self.disposition_code = disposition_code


class ChannelConfiguration(_serialization.Model):
    """Represents the capacity a job in this channel will consume from a worker.

    All required parameters must be populated in order to send to Azure.

    :ivar capacity_cost_per_job: The amount of capacity that an instance of a job of this channel
     will consume of the total worker capacity. Required.
    :vartype capacity_cost_per_job: int
    """

    _validation = {
        "capacity_cost_per_job": {"required": True},
    }

    _attribute_map = {
        "capacity_cost_per_job": {"key": "capacityCostPerJob", "type": "int"},
    }

    def __init__(self, *, capacity_cost_per_job: int, **kwargs):
        """
        :keyword capacity_cost_per_job: The amount of capacity that an instance of a job of this
         channel will consume of the total worker capacity. Required.
        :paramtype capacity_cost_per_job: int
        """
        super().__init__(**kwargs)
        self.capacity_cost_per_job = capacity_cost_per_job


class ClassificationPolicy(_serialization.Model):
    """A container for the rules that govern how jobs are classified.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Unique identifier of this policy.
    :vartype id: str
    :ivar name: Friendly name of this policy.
    :vartype name: str
    :ivar fallback_queue_id: The fallback queue to select if the queue selector doesn't find a
     match.
    :vartype fallback_queue_id: str
    :ivar queue_selectors: The queue selectors to resolve a queue for a given job.
    :vartype queue_selectors: list[~azure.communication.jobrouter.models.QueueSelectorAttachment]
    :ivar prioritization_rule: A rule of one of the following types:

     StaticRule:  A rule providing static rules that always return the same result, regardless of
     input.
     DirectMapRule:  A rule that return the same labels as the input labels.
     ExpressionRule: A rule providing inline expression rules.
     AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
    :vartype prioritization_rule: ~azure.communication.jobrouter.models.RouterRule
    :ivar worker_selectors: The worker label selectors to attach to a given job.
    :vartype worker_selectors: list[~azure.communication.jobrouter.models.WorkerSelectorAttachment]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "fallback_queue_id": {"key": "fallbackQueueId", "type": "str"},
        "queue_selectors": {"key": "queueSelectors", "type": "[QueueSelectorAttachment]"},
        "prioritization_rule": {"key": "prioritizationRule", "type": "RouterRule"},
        "worker_selectors": {"key": "workerSelectors", "type": "[WorkerSelectorAttachment]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        fallback_queue_id: Optional[str] = None,
        queue_selectors: Optional[List["_models.QueueSelectorAttachment"]] = None,
        prioritization_rule: Optional["_models.RouterRule"] = None,
        worker_selectors: Optional[List["_models.WorkerSelectorAttachment"]] = None,
        **kwargs
    ):
        """
        :keyword name: Friendly name of this policy.
        :paramtype name: str
        :keyword fallback_queue_id: The fallback queue to select if the queue selector doesn't find a
         match.
        :paramtype fallback_queue_id: str
        :keyword queue_selectors: The queue selectors to resolve a queue for a given job.
        :paramtype queue_selectors: list[~azure.communication.jobrouter.models.QueueSelectorAttachment]
        :keyword prioritization_rule: A rule of one of the following types:

         StaticRule:  A rule providing static rules that always return the same result, regardless of
         input.
         DirectMapRule:  A rule that return the same labels as the input labels.
         ExpressionRule: A rule providing inline expression rules.
         AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
        :paramtype prioritization_rule: ~azure.communication.jobrouter.models.RouterRule
        :keyword worker_selectors: The worker label selectors to attach to a given job.
        :paramtype worker_selectors:
         list[~azure.communication.jobrouter.models.WorkerSelectorAttachment]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = name
        self.fallback_queue_id = fallback_queue_id
        self.queue_selectors = queue_selectors
        self.prioritization_rule = prioritization_rule
        self.worker_selectors = worker_selectors


class ClassificationPolicyCollection(_serialization.Model):
    """A paged collection of classification policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.communication.jobrouter.models.ClassificationPolicyItem]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ClassificationPolicyItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ClassificationPolicyItem"], **kwargs):
        """
        :keyword value: Required.
        :paramtype value: list[~azure.communication.jobrouter.models.ClassificationPolicyItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ClassificationPolicyItem(_serialization.Model):
    """Paged instance of ClassificationPolicy.

    :ivar classification_policy: A container for the rules that govern how jobs are classified.
    :vartype classification_policy: ~azure.communication.jobrouter.models.ClassificationPolicy
    :ivar etag: (Optional) The Concurrency Token.
    :vartype etag: str
    """

    _attribute_map = {
        "classification_policy": {"key": "classificationPolicy", "type": "ClassificationPolicy"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self,
        *,
        classification_policy: Optional["_models.ClassificationPolicy"] = None,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword classification_policy: A container for the rules that govern how jobs are classified.
        :paramtype classification_policy: ~azure.communication.jobrouter.models.ClassificationPolicy
        :keyword etag: (Optional) The Concurrency Token.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.classification_policy = classification_policy
        self.etag = etag


class CloseJobRequest(_serialization.Model):
    """Request payload for closing jobs.

    All required parameters must be populated in order to send to Azure.

    :ivar assignment_id: The assignment within which the job is to be closed. Required.
    :vartype assignment_id: str
    :ivar disposition_code: Indicates the outcome of the job, populate this field with your own
     custom values.
    :vartype disposition_code: str
    :ivar close_time: If not provided, worker capacity is released immediately along with a
     JobClosedEvent notification.
     If provided, worker capacity is released along with a JobClosedEvent notification at a future
     time.
    :vartype close_time: ~datetime.datetime
    :ivar note: (Optional) A note that will be appended to the jobs' Notes collection with th
     current timestamp.
    :vartype note: str
    """

    _validation = {
        "assignment_id": {"required": True, "max_length": 50},
        "disposition_code": {"max_length": 500},
        "note": {"max_length": 2000},
    }

    _attribute_map = {
        "assignment_id": {"key": "assignmentId", "type": "str"},
        "disposition_code": {"key": "dispositionCode", "type": "str"},
        "close_time": {"key": "closeTime", "type": "iso-8601"},
        "note": {"key": "note", "type": "str"},
    }

    def __init__(
        self,
        *,
        assignment_id: str,
        disposition_code: Optional[str] = None,
        close_time: Optional[datetime.datetime] = None,
        note: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword assignment_id: The assignment within which the job is to be closed. Required.
        :paramtype assignment_id: str
        :keyword disposition_code: Indicates the outcome of the job, populate this field with your own
         custom values.
        :paramtype disposition_code: str
        :keyword close_time: If not provided, worker capacity is released immediately along with a
         JobClosedEvent notification.
         If provided, worker capacity is released along with a JobClosedEvent notification at a future
         time.
        :paramtype close_time: ~datetime.datetime
        :keyword note: (Optional) A note that will be appended to the jobs' Notes collection with th
         current timestamp.
        :paramtype note: str
        """
        super().__init__(**kwargs)
        self.assignment_id = assignment_id
        self.disposition_code = disposition_code
        self.close_time = close_time
        self.note = note


class CommunicationErrorResponse(_serialization.Model):
    """The Communication Services error.

    All required parameters must be populated in order to send to Azure.

    :ivar error: The Communication Services error. Required.
    :vartype error: ~azure.communication.jobrouter.models.JobRouterError
    """

    _validation = {
        "error": {"required": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "JobRouterError"},
    }

    def __init__(self, *, error: "_models.JobRouterError", **kwargs):
        """
        :keyword error: The Communication Services error. Required.
        :paramtype error: ~azure.communication.jobrouter.models.JobRouterError
        """
        super().__init__(**kwargs)
        self.error = error


class CompleteJobRequest(_serialization.Model):
    """Request payload for completing jobs.

    All required parameters must be populated in order to send to Azure.

    :ivar assignment_id: The assignment within the job to complete. Required.
    :vartype assignment_id: str
    :ivar note: (Optional) A note that will be appended to the jobs' Notes collection with th
     current timestamp.
    :vartype note: str
    """

    _validation = {
        "assignment_id": {"required": True, "max_length": 50},
        "note": {"max_length": 2000},
    }

    _attribute_map = {
        "assignment_id": {"key": "assignmentId", "type": "str"},
        "note": {"key": "note", "type": "str"},
    }

    def __init__(self, *, assignment_id: str, note: Optional[str] = None, **kwargs):
        """
        :keyword assignment_id: The assignment within the job to complete. Required.
        :paramtype assignment_id: str
        :keyword note: (Optional) A note that will be appended to the jobs' Notes collection with th
         current timestamp.
        :paramtype note: str
        """
        super().__init__(**kwargs)
        self.assignment_id = assignment_id
        self.note = note


class QueueSelectorAttachment(_serialization.Model):
    """An attachment of label selectors to resolve a queue to a job from a classification policy.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConditionalQueueSelectorAttachment, PassThroughQueueSelectorAttachment,
    RuleEngineQueueSelectorAttachment, StaticQueueSelectorAttachment,
    WeightedAllocationQueueSelectorAttachment

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of label selector attachment. Required.
    :vartype kind: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "conditional": "ConditionalQueueSelectorAttachment",
            "pass-through": "PassThroughQueueSelectorAttachment",
            "rule-engine": "RuleEngineQueueSelectorAttachment",
            "static": "StaticQueueSelectorAttachment",
            "weighted-allocation-queue-selector": "WeightedAllocationQueueSelectorAttachment",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class ConditionalQueueSelectorAttachment(QueueSelectorAttachment):
    """Describes a set of label selectors that will be attached if the given condition resolves to true.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of label selector attachment. Required.
    :vartype kind: str
    :ivar condition: A rule of one of the following types:

     StaticRule:  A rule providing static rules that always return the same result, regardless of
     input.
     DirectMapRule:  A rule that return the same labels as the input labels.
     ExpressionRule: A rule providing inline expression rules.
     AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function. Required.
    :vartype condition: ~azure.communication.jobrouter.models.RouterRule
    :ivar label_selectors: The label selectors to attach. Required.
    :vartype label_selectors: list[~azure.communication.jobrouter.models.QueueSelector]
    """

    _validation = {
        "kind": {"required": True},
        "condition": {"required": True},
        "label_selectors": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "condition": {"key": "condition", "type": "RouterRule"},
        "label_selectors": {"key": "labelSelectors", "type": "[QueueSelector]"},
    }

    def __init__(self, *, condition: "_models.RouterRule", label_selectors: List["_models.QueueSelector"], **kwargs):
        """
        :keyword condition: A rule of one of the following types:

         StaticRule:  A rule providing static rules that always return the same result, regardless of
         input.
         DirectMapRule:  A rule that return the same labels as the input labels.
         ExpressionRule: A rule providing inline expression rules.
         AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function. Required.
        :paramtype condition: ~azure.communication.jobrouter.models.RouterRule
        :keyword label_selectors: The label selectors to attach. Required.
        :paramtype label_selectors: list[~azure.communication.jobrouter.models.QueueSelector]
        """
        super().__init__(**kwargs)
        self.kind = "conditional"  # type: str
        self.condition = condition
        self.label_selectors = label_selectors


class WorkerSelectorAttachment(_serialization.Model):
    """An attachment which attaches WorkerSelectors to workers.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConditionalWorkerSelectorAttachment, PassThroughWorkerSelectorAttachment,
    RuleEngineWorkerSelectorAttachment, StaticWorkerSelectorAttachment,
    WeightedAllocationWorkerSelectorAttachment

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of label selector attachment. Required.
    :vartype kind: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "conditional": "ConditionalWorkerSelectorAttachment",
            "pass-through": "PassThroughWorkerSelectorAttachment",
            "rule-engine": "RuleEngineWorkerSelectorAttachment",
            "static": "StaticWorkerSelectorAttachment",
            "weighted-allocation-worker-selector": "WeightedAllocationWorkerSelectorAttachment",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class ConditionalWorkerSelectorAttachment(WorkerSelectorAttachment):
    """Describes a set of label selectors that will be attached if the given condition resolves to true.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of label selector attachment. Required.
    :vartype kind: str
    :ivar condition: A rule of one of the following types:

     StaticRule:  A rule providing static rules that always return the same result, regardless of
     input.
     DirectMapRule:  A rule that return the same labels as the input labels.
     ExpressionRule: A rule providing inline expression rules.
     AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function. Required.
    :vartype condition: ~azure.communication.jobrouter.models.RouterRule
    :ivar label_selectors: The label selectors to attach. Required.
    :vartype label_selectors: list[~azure.communication.jobrouter.models.WorkerSelector]
    """

    _validation = {
        "kind": {"required": True},
        "condition": {"required": True},
        "label_selectors": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "condition": {"key": "condition", "type": "RouterRule"},
        "label_selectors": {"key": "labelSelectors", "type": "[WorkerSelector]"},
    }

    def __init__(self, *, condition: "_models.RouterRule", label_selectors: List["_models.WorkerSelector"], **kwargs):
        """
        :keyword condition: A rule of one of the following types:

         StaticRule:  A rule providing static rules that always return the same result, regardless of
         input.
         DirectMapRule:  A rule that return the same labels as the input labels.
         ExpressionRule: A rule providing inline expression rules.
         AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function. Required.
        :paramtype condition: ~azure.communication.jobrouter.models.RouterRule
        :keyword label_selectors: The label selectors to attach. Required.
        :paramtype label_selectors: list[~azure.communication.jobrouter.models.WorkerSelector]
        """
        super().__init__(**kwargs)
        self.kind = "conditional"  # type: str
        self.condition = condition
        self.label_selectors = label_selectors


class RouterRule(_serialization.Model):
    """A rule of one of the following types:

    StaticRule:  A rule providing static rules that always return the same result, regardless of input.
    DirectMapRule:  A rule that return the same labels as the input labels.
    ExpressionRule: A rule providing inline expression rules.
    AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.

        You probably want to use the sub-classes and not this class directly. Known sub-classes are:
        FunctionRule, DirectMapRule, ExpressionRule, StaticRule

        All required parameters must be populated in order to send to Azure.

        :ivar kind: The type discriminator describing a sub-type of Rule. Required.
        :vartype kind: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "azure-function-rule": "FunctionRule",
            "direct-map-rule": "DirectMapRule",
            "expression-rule": "ExpressionRule",
            "static-rule": "StaticRule",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class DirectMapRule(RouterRule):
    """A rule that return the same labels as the input labels.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Rule. Required.
    :vartype kind: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind = "direct-map-rule"  # type: str


class DistributionPolicy(_serialization.Model):
    """Policy governing how jobs are distributed to workers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique identifier of the policy.
    :vartype id: str
    :ivar name: The human readable name of the policy.
    :vartype name: str
    :ivar offer_ttl_seconds: The expiry time of any offers created under this policy will be
     governed by the offer time to live.
    :vartype offer_ttl_seconds: float
    :ivar mode: Abstract base class for defining a distribution mode.
    :vartype mode: ~azure.communication.jobrouter.models.DistributionMode
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "offer_ttl_seconds": {"key": "offerTtlSeconds", "type": "float"},
        "mode": {"key": "mode", "type": "DistributionMode"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        offer_ttl_seconds: Optional[float] = None,
        mode: Optional["_models.DistributionMode"] = None,
        **kwargs
    ):
        """
        :keyword name: The human readable name of the policy.
        :paramtype name: str
        :keyword offer_ttl_seconds: The expiry time of any offers created under this policy will be
         governed by the offer time to live.
        :paramtype offer_ttl_seconds: float
        :keyword mode: Abstract base class for defining a distribution mode.
        :paramtype mode: ~azure.communication.jobrouter.models.DistributionMode
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = name
        self.offer_ttl_seconds = offer_ttl_seconds
        self.mode = mode


class DistributionPolicyCollection(_serialization.Model):
    """A paged collection of distribution policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.communication.jobrouter.models.DistributionPolicyItem]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DistributionPolicyItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DistributionPolicyItem"], **kwargs):
        """
        :keyword value: Required.
        :paramtype value: list[~azure.communication.jobrouter.models.DistributionPolicyItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DistributionPolicyItem(_serialization.Model):
    """Paged instance of DistributionPolicy.

    :ivar distribution_policy: Policy governing how jobs are distributed to workers.
    :vartype distribution_policy: ~azure.communication.jobrouter.models.DistributionPolicy
    :ivar etag: (Optional) The Concurrency Token.
    :vartype etag: str
    """

    _attribute_map = {
        "distribution_policy": {"key": "distributionPolicy", "type": "DistributionPolicy"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self,
        *,
        distribution_policy: Optional["_models.DistributionPolicy"] = None,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword distribution_policy: Policy governing how jobs are distributed to workers.
        :paramtype distribution_policy: ~azure.communication.jobrouter.models.DistributionPolicy
        :keyword etag: (Optional) The Concurrency Token.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.distribution_policy = distribution_policy
        self.etag = etag


class ExceptionPolicy(_serialization.Model):
    """A policy that defines actions to execute when exception are triggered.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Id of the exception policy.
    :vartype id: str
    :ivar name: (Optional) The name of the exception policy.
    :vartype name: str
    :ivar exception_rules: (Optional) A dictionary collection of exception rules on the exception
     policy. Key is the Id of each exception rule.
    :vartype exception_rules: dict[str, ~azure.communication.jobrouter.models.ExceptionRule]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "exception_rules": {"key": "exceptionRules", "type": "{ExceptionRule}"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        exception_rules: Optional[Dict[str, "_models.ExceptionRule"]] = None,
        **kwargs
    ):
        """
        :keyword name: (Optional) The name of the exception policy.
        :paramtype name: str
        :keyword exception_rules: (Optional) A dictionary collection of exception rules on the
         exception policy. Key is the Id of each exception rule.
        :paramtype exception_rules: dict[str, ~azure.communication.jobrouter.models.ExceptionRule]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = name
        self.exception_rules = exception_rules


class ExceptionPolicyCollection(_serialization.Model):
    """A paged collection of exception policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.communication.jobrouter.models.ExceptionPolicyItem]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExceptionPolicyItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ExceptionPolicyItem"], **kwargs):
        """
        :keyword value: Required.
        :paramtype value: list[~azure.communication.jobrouter.models.ExceptionPolicyItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ExceptionPolicyItem(_serialization.Model):
    """Paged instance of ExceptionPolicy.

    :ivar exception_policy: A policy that defines actions to execute when exception are triggered.
    :vartype exception_policy: ~azure.communication.jobrouter.models.ExceptionPolicy
    :ivar etag: (Optional) The Concurrency Token.
    :vartype etag: str
    """

    _attribute_map = {
        "exception_policy": {"key": "exceptionPolicy", "type": "ExceptionPolicy"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self, *, exception_policy: Optional["_models.ExceptionPolicy"] = None, etag: Optional[str] = None, **kwargs
    ):
        """
        :keyword exception_policy: A policy that defines actions to execute when exception are
         triggered.
        :paramtype exception_policy: ~azure.communication.jobrouter.models.ExceptionPolicy
        :keyword etag: (Optional) The Concurrency Token.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.exception_policy = exception_policy
        self.etag = etag


class ExceptionRule(_serialization.Model):
    """A rule that defines actions to execute upon a specific trigger.

    All required parameters must be populated in order to send to Azure.

    :ivar trigger: The trigger for this exception rule. Required.
    :vartype trigger: ~azure.communication.jobrouter.models.JobExceptionTrigger
    :ivar actions: A dictionary collection of actions to perform once the exception is triggered.
     Key is the Id of each exception action. Required.
    :vartype actions: dict[str, ~azure.communication.jobrouter.models.ExceptionAction]
    """

    _validation = {
        "trigger": {"required": True},
        "actions": {"required": True},
    }

    _attribute_map = {
        "trigger": {"key": "trigger", "type": "JobExceptionTrigger"},
        "actions": {"key": "actions", "type": "{ExceptionAction}"},
    }

    def __init__(
        self, *, trigger: "_models.JobExceptionTrigger", actions: Dict[str, "_models.ExceptionAction"], **kwargs
    ):
        """
        :keyword trigger: The trigger for this exception rule. Required.
        :paramtype trigger: ~azure.communication.jobrouter.models.JobExceptionTrigger
        :keyword actions: A dictionary collection of actions to perform once the exception is
         triggered. Key is the Id of each exception action. Required.
        :paramtype actions: dict[str, ~azure.communication.jobrouter.models.ExceptionAction]
        """
        super().__init__(**kwargs)
        self.trigger = trigger
        self.actions = actions


class ExpressionRule(RouterRule):
    """A rule providing inline expression rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Rule. Required.
    :vartype kind: str
    :ivar language: The expression language to compile to and execute. Required. Default value is
     "powerFx".
    :vartype language: str
    :ivar expression: The string containing the expression to evaluate. Should contain return
     statement with calculated values. Required.
    :vartype expression: str
    """

    _validation = {
        "kind": {"required": True},
        "language": {"required": True, "constant": True},
        "expression": {"required": True, "max_length": 500},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "language": {"key": "language", "type": "str"},
        "expression": {"key": "expression", "type": "str"},
    }

    language = "powerFx"

    def __init__(self, *, expression: str, **kwargs):
        """
        :keyword expression: The string containing the expression to evaluate. Should contain return
         statement with calculated values. Required.
        :paramtype expression: str
        """
        super().__init__(**kwargs)
        self.kind = "expression-rule"  # type: str
        self.expression = expression


class FunctionRule(RouterRule):
    """A rule providing a binding to an HTTP Triggered Azure Function.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Rule. Required.
    :vartype kind: str
    :ivar function_uri: URL for Azure Function. Required.
    :vartype function_uri: str
    :ivar credential: Credentials used to access Azure function rule.
    :vartype credential: ~azure.communication.jobrouter.models.FunctionRuleCredential
    """

    _validation = {
        "kind": {"required": True},
        "function_uri": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "function_uri": {"key": "functionUri", "type": "str"},
        "credential": {"key": "credential", "type": "FunctionRuleCredential"},
    }

    def __init__(self, *, function_uri: str, credential: Optional["_models.FunctionRuleCredential"] = None, **kwargs):
        """
        :keyword function_uri: URL for Azure Function. Required.
        :paramtype function_uri: str
        :keyword credential: Credentials used to access Azure function rule.
        :paramtype credential: ~azure.communication.jobrouter.models.FunctionRuleCredential
        """
        super().__init__(**kwargs)
        self.kind = "azure-function-rule"  # type: str
        self.function_uri = function_uri
        self.credential = credential


class FunctionRuleCredential(_serialization.Model):
    """Credentials used to access Azure function rule.

    :ivar function_key: (Optional) Access key scoped to a particular function.
    :vartype function_key: str
    :ivar app_key: (Optional) Access key scoped to a Azure Function app.
     This key grants access to all functions under the app.
    :vartype app_key: str
    :ivar client_id: (Optional) Client id, when AppKey is provided
     In context of Azure function, this is usually the name of the key.
    :vartype client_id: str
    """

    _validation = {
        "function_key": {"max_length": 500},
        "app_key": {"max_length": 500},
        "client_id": {"max_length": 500},
    }

    _attribute_map = {
        "function_key": {"key": "functionKey", "type": "str"},
        "app_key": {"key": "appKey", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(
        self,
        *,
        function_key: Optional[str] = None,
        app_key: Optional[str] = None,
        client_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword function_key: (Optional) Access key scoped to a particular function.
        :paramtype function_key: str
        :keyword app_key: (Optional) Access key scoped to a Azure Function app.
         This key grants access to all functions under the app.
        :paramtype app_key: str
        :keyword client_id: (Optional) Client id, when AppKey is provided
         In context of Azure function, this is usually the name of the key.
        :paramtype client_id: str
        """
        super().__init__(**kwargs)
        self.function_key = function_key
        self.app_key = app_key
        self.client_id = client_id


class JobAssignment(_serialization.Model):
    """Assignment details of a job to a worker.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The Id of the job assignment. Required.
    :vartype id: str
    :ivar worker_id: The Id of the Worker assigned to the job.
    :vartype worker_id: str
    :ivar assign_time: The assignment time of the job. Required.
    :vartype assign_time: ~datetime.datetime
    :ivar complete_time: The time the job was marked as completed after being assigned.
    :vartype complete_time: ~datetime.datetime
    :ivar close_time: The time the job was marked as closed after being completed.
    :vartype close_time: ~datetime.datetime
    """

    _validation = {
        "id": {"required": True},
        "assign_time": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "worker_id": {"key": "workerId", "type": "str"},
        "assign_time": {"key": "assignTime", "type": "iso-8601"},
        "complete_time": {"key": "completeTime", "type": "iso-8601"},
        "close_time": {"key": "closeTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        assign_time: datetime.datetime,
        worker_id: Optional[str] = None,
        complete_time: Optional[datetime.datetime] = None,
        close_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword id: The Id of the job assignment. Required.
        :paramtype id: str
        :keyword worker_id: The Id of the Worker assigned to the job.
        :paramtype worker_id: str
        :keyword assign_time: The assignment time of the job. Required.
        :paramtype assign_time: ~datetime.datetime
        :keyword complete_time: The time the job was marked as completed after being assigned.
        :paramtype complete_time: ~datetime.datetime
        :keyword close_time: The time the job was marked as closed after being completed.
        :paramtype close_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.id = id
        self.worker_id = worker_id
        self.assign_time = assign_time
        self.complete_time = complete_time
        self.close_time = close_time


class JobCollection(_serialization.Model):
    """A paged collection of jobs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.communication.jobrouter.models.RouterJobItem]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RouterJobItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RouterJobItem"], **kwargs):
        """
        :keyword value: Required.
        :paramtype value: list[~azure.communication.jobrouter.models.RouterJobItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class JobExceptionTrigger(_serialization.Model):
    """The trigger for this exception rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    QueueLengthExceptionTrigger, WaitTimeExceptionTrigger

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of ExceptionTrigger. Required.
    :vartype kind: str
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"queue-length": "QueueLengthExceptionTrigger", "wait-time": "WaitTimeExceptionTrigger"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class JobOffer(_serialization.Model):
    """An offer of a job to a worker.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The Id of the offer. Required.
    :vartype id: str
    :ivar job_id: The Id of the job. Required.
    :vartype job_id: str
    :ivar capacity_cost: The capacity cost consumed by the job offer. Required.
    :vartype capacity_cost: int
    :ivar offer_time_utc: The time the offer was created.
    :vartype offer_time_utc: ~datetime.datetime
    :ivar expiry_time_utc: The time that the offer will expire.
    :vartype expiry_time_utc: ~datetime.datetime
    """

    _validation = {
        "id": {"required": True},
        "job_id": {"required": True},
        "capacity_cost": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "capacity_cost": {"key": "capacityCost", "type": "int"},
        "offer_time_utc": {"key": "offerTimeUtc", "type": "iso-8601"},
        "expiry_time_utc": {"key": "expiryTimeUtc", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        job_id: str,
        capacity_cost: int,
        offer_time_utc: Optional[datetime.datetime] = None,
        expiry_time_utc: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword id: The Id of the offer. Required.
        :paramtype id: str
        :keyword job_id: The Id of the job. Required.
        :paramtype job_id: str
        :keyword capacity_cost: The capacity cost consumed by the job offer. Required.
        :paramtype capacity_cost: int
        :keyword offer_time_utc: The time the offer was created.
        :paramtype offer_time_utc: ~datetime.datetime
        :keyword expiry_time_utc: The time that the offer will expire.
        :paramtype expiry_time_utc: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.id = id
        self.job_id = job_id
        self.capacity_cost = capacity_cost
        self.offer_time_utc = offer_time_utc
        self.expiry_time_utc = expiry_time_utc


class JobPositionDetails(_serialization.Model):
    """Dto for JobPositionDetails.

    All required parameters must be populated in order to send to Azure.

    :ivar job_id: Id of the job these details are about. Required.
    :vartype job_id: str
    :ivar position: Position of the job in question within that queue. Required.
    :vartype position: int
    :ivar queue_id: Id of the queue this job is enqueued in. Required.
    :vartype queue_id: str
    :ivar queue_length: Length of the queue: total number of enqueued jobs. Required.
    :vartype queue_length: int
    :ivar estimated_wait_time_minutes: Estimated wait time of the job rounded up to the nearest
     minute. Required.
    :vartype estimated_wait_time_minutes: float
    """

    _validation = {
        "job_id": {"required": True},
        "position": {"required": True},
        "queue_id": {"required": True},
        "queue_length": {"required": True},
        "estimated_wait_time_minutes": {"required": True},
    }

    _attribute_map = {
        "job_id": {"key": "jobId", "type": "str"},
        "position": {"key": "position", "type": "int"},
        "queue_id": {"key": "queueId", "type": "str"},
        "queue_length": {"key": "queueLength", "type": "int"},
        "estimated_wait_time_minutes": {"key": "estimatedWaitTimeMinutes", "type": "float"},
    }

    def __init__(
        self,
        *,
        job_id: str,
        position: int,
        queue_id: str,
        queue_length: int,
        estimated_wait_time_minutes: float,
        **kwargs
    ):
        """
        :keyword job_id: Id of the job these details are about. Required.
        :paramtype job_id: str
        :keyword position: Position of the job in question within that queue. Required.
        :paramtype position: int
        :keyword queue_id: Id of the queue this job is enqueued in. Required.
        :paramtype queue_id: str
        :keyword queue_length: Length of the queue: total number of enqueued jobs. Required.
        :paramtype queue_length: int
        :keyword estimated_wait_time_minutes: Estimated wait time of the job rounded up to the nearest
         minute. Required.
        :paramtype estimated_wait_time_minutes: float
        """
        super().__init__(**kwargs)
        self.job_id = job_id
        self.position = position
        self.queue_id = queue_id
        self.queue_length = queue_length
        self.estimated_wait_time_minutes = estimated_wait_time_minutes


class JobQueue(_serialization.Model):
    """A queue that can contain jobs to be routed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Id of this queue.
    :vartype id: str
    :ivar name: The name of this queue.
    :vartype name: str
    :ivar distribution_policy_id: The ID of the distribution policy that will determine how a job
     is distributed to workers.
    :vartype distribution_policy_id: str
    :ivar labels: A set of key/value pairs that are identifying attributes used by the rules
     engines to make decisions.
    :vartype labels: dict[str, any]
    :ivar exception_policy_id: (Optional) The ID of the exception policy that determines various
     job escalation rules.
    :vartype exception_policy_id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "distribution_policy_id": {"key": "distributionPolicyId", "type": "str"},
        "labels": {"key": "labels", "type": "{object}"},
        "exception_policy_id": {"key": "exceptionPolicyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        distribution_policy_id: Optional[str] = None,
        labels: Optional[Dict[str, Any]] = None,
        exception_policy_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of this queue.
        :paramtype name: str
        :keyword distribution_policy_id: The ID of the distribution policy that will determine how a
         job is distributed to workers.
        :paramtype distribution_policy_id: str
        :keyword labels: A set of key/value pairs that are identifying attributes used by the rules
         engines to make decisions.
        :paramtype labels: dict[str, any]
        :keyword exception_policy_id: (Optional) The ID of the exception policy that determines various
         job escalation rules.
        :paramtype exception_policy_id: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = name
        self.distribution_policy_id = distribution_policy_id
        self.labels = labels
        self.exception_policy_id = exception_policy_id


class JobQueueItem(_serialization.Model):
    """Paged instance of JobQueue.

    :ivar job_queue: A queue that can contain jobs to be routed.
    :vartype job_queue: ~azure.communication.jobrouter.models.JobQueue
    :ivar etag: (Optional) The Concurrency Token.
    :vartype etag: str
    """

    _attribute_map = {
        "job_queue": {"key": "jobQueue", "type": "JobQueue"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, *, job_queue: Optional["_models.JobQueue"] = None, etag: Optional[str] = None, **kwargs):
        """
        :keyword job_queue: A queue that can contain jobs to be routed.
        :paramtype job_queue: ~azure.communication.jobrouter.models.JobQueue
        :keyword etag: (Optional) The Concurrency Token.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.job_queue = job_queue
        self.etag = etag


class JobRouterError(_serialization.Model):
    """The Communication Services error.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code: The error code. Required.
    :vartype code: str
    :ivar message: The error message. Required.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: Further details about specific errors that led to this error.
    :vartype details: list[~azure.communication.jobrouter.models.JobRouterError]
    :ivar inner_error: The inner error if any.
    :vartype inner_error: ~azure.communication.jobrouter.models.JobRouterError
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "inner_error": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[JobRouterError]"},
        "inner_error": {"key": "innererror", "type": "JobRouterError"},
    }

    def __init__(self, *, code: str, message: str, **kwargs):
        """
        :keyword code: The error code. Required.
        :paramtype code: str
        :keyword message: The error message. Required.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = None
        self.details = None
        self.inner_error = None


class LongestIdleMode(DistributionMode):
    """Jobs are directed to the worker who has been idle longest.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Mode. Required.
    :vartype kind: str
    :ivar min_concurrent_offers: Governs the minimum desired number of active concurrent offers a
     job can have. Required.
    :vartype min_concurrent_offers: int
    :ivar max_concurrent_offers: Governs the maximum number of active concurrent offers a job can
     have. Required.
    :vartype max_concurrent_offers: int
    :ivar bypass_selectors: (Optional)
     If set to true, then router will match workers to jobs even if they don't match label
     selectors.
     Warning: You may get workers that are not qualified for the job they are matched with if you
     set this
     variable to true. This flag is intended more for temporary usage.
     By default, set to false.
    :vartype bypass_selectors: bool
    """

    _validation = {
        "kind": {"required": True},
        "min_concurrent_offers": {"required": True},
        "max_concurrent_offers": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "min_concurrent_offers": {"key": "minConcurrentOffers", "type": "int"},
        "max_concurrent_offers": {"key": "maxConcurrentOffers", "type": "int"},
        "bypass_selectors": {"key": "bypassSelectors", "type": "bool"},
    }

    def __init__(
        self,
        *,
        min_concurrent_offers: int,
        max_concurrent_offers: int,
        bypass_selectors: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword min_concurrent_offers: Governs the minimum desired number of active concurrent offers
         a job can have. Required.
        :paramtype min_concurrent_offers: int
        :keyword max_concurrent_offers: Governs the maximum number of active concurrent offers a job
         can have. Required.
        :paramtype max_concurrent_offers: int
        :keyword bypass_selectors: (Optional)
         If set to true, then router will match workers to jobs even if they don't match label
         selectors.
         Warning: You may get workers that are not qualified for the job they are matched with if you
         set this
         variable to true. This flag is intended more for temporary usage.
         By default, set to false.
        :paramtype bypass_selectors: bool
        """
        super().__init__(
            min_concurrent_offers=min_concurrent_offers,
            max_concurrent_offers=max_concurrent_offers,
            bypass_selectors=bypass_selectors,
            **kwargs
        )
        self.kind = "longest-idle"  # type: str


class ManualReclassifyExceptionAction(ExceptionAction):
    """An action that manually reclassifies a job by providing the queue, priority and worker selectors.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of ExceptionAction. Required.
    :vartype kind: str
    :ivar queue_id: Updated QueueId.
    :vartype queue_id: str
    :ivar priority: Updated Priority.
    :vartype priority: int
    :ivar worker_selectors: Updated WorkerSelectors.
    :vartype worker_selectors: list[~azure.communication.jobrouter.models.WorkerSelector]
    """

    _validation = {
        "kind": {"required": True},
        "queue_id": {"max_length": 50},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "queue_id": {"key": "queueId", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "worker_selectors": {"key": "workerSelectors", "type": "[WorkerSelector]"},
    }

    def __init__(
        self,
        *,
        queue_id: Optional[str] = None,
        priority: Optional[int] = None,
        worker_selectors: Optional[List["_models.WorkerSelector"]] = None,
        **kwargs
    ):
        """
        :keyword queue_id: Updated QueueId.
        :paramtype queue_id: str
        :keyword priority: Updated Priority.
        :paramtype priority: int
        :keyword worker_selectors: Updated WorkerSelectors.
        :paramtype worker_selectors: list[~azure.communication.jobrouter.models.WorkerSelector]
        """
        super().__init__(**kwargs)
        self.kind = "manual-reclassify"  # type: str
        self.queue_id = queue_id
        self.priority = priority
        self.worker_selectors = worker_selectors


class PassThroughQueueSelectorAttachment(QueueSelectorAttachment):
    """Attaches a label selector where the value is pass through from the job label with the same key.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of label selector attachment. Required.
    :vartype kind: str
    :ivar key: The label key to query against. Required.
    :vartype key: str
    :ivar label_operator: Describes how the value of the label is compared to the value pass
     through. Required. Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
     "greaterThan", and "greaterThanEqual".
    :vartype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
    """

    _validation = {
        "kind": {"required": True},
        "key": {"required": True, "max_length": 500},
        "label_operator": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "label_operator": {"key": "labelOperator", "type": "str"},
    }

    def __init__(self, *, key: str, label_operator: Union[str, "_models.LabelOperator"], **kwargs):
        """
        :keyword key: The label key to query against. Required.
        :paramtype key: str
        :keyword label_operator: Describes how the value of the label is compared to the value pass
         through. Required. Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
         "greaterThan", and "greaterThanEqual".
        :paramtype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
        """
        super().__init__(**kwargs)
        self.kind = "pass-through"  # type: str
        self.key = key
        self.label_operator = label_operator


class PassThroughWorkerSelectorAttachment(WorkerSelectorAttachment):
    """Attaches a label selector where the value is pass through from the job label with the same key.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of label selector attachment. Required.
    :vartype kind: str
    :ivar key: The label key to query against. Required.
    :vartype key: str
    :ivar label_operator: Describes how the value of the label is compared to the value pass
     through. Required. Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
     "greaterThan", and "greaterThanEqual".
    :vartype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
    :ivar ttl_seconds: Describes how long the attached label selector is valid in seconds.
    :vartype ttl_seconds: float
    """

    _validation = {
        "kind": {"required": True},
        "key": {"required": True, "max_length": 500},
        "label_operator": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "label_operator": {"key": "labelOperator", "type": "str"},
        "ttl_seconds": {"key": "ttlSeconds", "type": "float"},
    }

    def __init__(
        self,
        *,
        key: str,
        label_operator: Union[str, "_models.LabelOperator"],
        ttl_seconds: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword key: The label key to query against. Required.
        :paramtype key: str
        :keyword label_operator: Describes how the value of the label is compared to the value pass
         through. Required. Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
         "greaterThan", and "greaterThanEqual".
        :paramtype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
        :keyword ttl_seconds: Describes how long the attached label selector is valid in seconds.
        :paramtype ttl_seconds: float
        """
        super().__init__(**kwargs)
        self.kind = "pass-through"  # type: str
        self.key = key
        self.label_operator = label_operator
        self.ttl_seconds = ttl_seconds


class QueueCollection(_serialization.Model):
    """A paged collection of queues.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.communication.jobrouter.models.JobQueueItem]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JobQueueItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.JobQueueItem"], **kwargs):
        """
        :keyword value: Required.
        :paramtype value: list[~azure.communication.jobrouter.models.JobQueueItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class QueueLengthExceptionTrigger(JobExceptionTrigger):
    """Trigger for an exception action on exceeding queue length.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of ExceptionTrigger. Required.
    :vartype kind: str
    :ivar threshold: Threshold of number of jobs ahead in the queue to for this trigger to fire.
     Required.
    :vartype threshold: int
    """

    _validation = {
        "kind": {"required": True},
        "threshold": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "threshold": {"key": "threshold", "type": "int"},
    }

    def __init__(self, *, threshold: int, **kwargs):
        """
        :keyword threshold: Threshold of number of jobs ahead in the queue to for this trigger to fire.
         Required.
        :paramtype threshold: int
        """
        super().__init__(**kwargs)
        self.kind = "queue-length"  # type: str
        self.threshold = threshold


class QueueSelector(_serialization.Model):
    """Describes a condition that must be met against a set of labels for queue selection.

    All required parameters must be populated in order to send to Azure.

    :ivar key: The label key to query against. Required.
    :vartype key: str
    :ivar label_operator: Describes how the value of the label is compared to the value defined on
     the label selector. Required. Known values are: "equal", "notEqual", "lessThan",
     "lessThanEqual", "greaterThan", and "greaterThanEqual".
    :vartype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
    :ivar value: The value to compare against the actual label value with the given operator.
    :vartype value: JSON
    """

    _validation = {
        "key": {"required": True, "max_length": 500},
        "label_operator": {"required": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "label_operator": {"key": "labelOperator", "type": "str"},
        "value": {"key": "value", "type": "object"},
    }

    def __init__(
        self, *, key: str, label_operator: Union[str, "_models.LabelOperator"], value: Optional[JSON] = None, **kwargs
    ):
        """
        :keyword key: The label key to query against. Required.
        :paramtype key: str
        :keyword label_operator: Describes how the value of the label is compared to the value defined
         on the label selector. Required. Known values are: "equal", "notEqual", "lessThan",
         "lessThanEqual", "greaterThan", and "greaterThanEqual".
        :paramtype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
        :keyword value: The value to compare against the actual label value with the given operator.
        :paramtype value: JSON
        """
        super().__init__(**kwargs)
        self.key = key
        self.label_operator = label_operator
        self.value = value


class QueueStatistics(_serialization.Model):
    """Statistics for the queue.

    All required parameters must be populated in order to send to Azure.

    :ivar queue_id: Id of the queue these details are about. Required.
    :vartype queue_id: str
    :ivar length: Length of the queue: total number of enqueued jobs. Required.
    :vartype length: int
    :ivar estimated_wait_time_minutes: The estimated wait time of this queue rounded up to the
     nearest minute, grouped by job priority.
    :vartype estimated_wait_time_minutes: dict[str, float]
    :ivar longest_job_wait_time_minutes: The wait time of the job that has been enqueued in this
     queue for the longest.
    :vartype longest_job_wait_time_minutes: float
    """

    _validation = {
        "queue_id": {"required": True},
        "length": {"required": True},
    }

    _attribute_map = {
        "queue_id": {"key": "queueId", "type": "str"},
        "length": {"key": "length", "type": "int"},
        "estimated_wait_time_minutes": {"key": "estimatedWaitTimeMinutes", "type": "{float}"},
        "longest_job_wait_time_minutes": {"key": "longestJobWaitTimeMinutes", "type": "float"},
    }

    def __init__(
        self,
        *,
        queue_id: str,
        length: int,
        estimated_wait_time_minutes: Optional[Dict[str, float]] = None,
        longest_job_wait_time_minutes: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword queue_id: Id of the queue these details are about. Required.
        :paramtype queue_id: str
        :keyword length: Length of the queue: total number of enqueued jobs. Required.
        :paramtype length: int
        :keyword estimated_wait_time_minutes: The estimated wait time of this queue rounded up to the
         nearest minute, grouped by job priority.
        :paramtype estimated_wait_time_minutes: dict[str, float]
        :keyword longest_job_wait_time_minutes: The wait time of the job that has been enqueued in this
         queue for the longest.
        :paramtype longest_job_wait_time_minutes: float
        """
        super().__init__(**kwargs)
        self.queue_id = queue_id
        self.length = length
        self.estimated_wait_time_minutes = estimated_wait_time_minutes
        self.longest_job_wait_time_minutes = longest_job_wait_time_minutes


class QueueWeightedAllocation(_serialization.Model):
    """Contains the weight percentage and label selectors to be applied if selected for weighted distributions.

    All required parameters must be populated in order to send to Azure.

    :ivar weight: The percentage of this weight, expressed as a fraction of 1. Required.
    :vartype weight: float
    :ivar label_selectors: A collection of label selectors that will be applied if this allocation
     is selected. Required.
    :vartype label_selectors: list[~azure.communication.jobrouter.models.QueueSelector]
    """

    _validation = {
        "weight": {"required": True},
        "label_selectors": {"required": True},
    }

    _attribute_map = {
        "weight": {"key": "weight", "type": "float"},
        "label_selectors": {"key": "labelSelectors", "type": "[QueueSelector]"},
    }

    def __init__(self, *, weight: float, label_selectors: List["_models.QueueSelector"], **kwargs):
        """
        :keyword weight: The percentage of this weight, expressed as a fraction of 1. Required.
        :paramtype weight: float
        :keyword label_selectors: A collection of label selectors that will be applied if this
         allocation is selected. Required.
        :paramtype label_selectors: list[~azure.communication.jobrouter.models.QueueSelector]
        """
        super().__init__(**kwargs)
        self.weight = weight
        self.label_selectors = label_selectors


class ReclassifyExceptionAction(ExceptionAction):
    """An action that modifies labels on a job and then reclassifies it.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of ExceptionAction. Required.
    :vartype kind: str
    :ivar classification_policy_id: (optional) The new classification policy that will determine
     queue, priority and worker selectors.
    :vartype classification_policy_id: str
    :ivar labels_to_upsert: (optional) Dictionary containing the labels to update (or add if not
     existing) in key-value pairs.
    :vartype labels_to_upsert: dict[str, any]
    """

    _validation = {
        "kind": {"required": True},
        "classification_policy_id": {"max_length": 50},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "classification_policy_id": {"key": "classificationPolicyId", "type": "str"},
        "labels_to_upsert": {"key": "labelsToUpsert", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        classification_policy_id: Optional[str] = None,
        labels_to_upsert: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword classification_policy_id: (optional) The new classification policy that will determine
         queue, priority and worker selectors.
        :paramtype classification_policy_id: str
        :keyword labels_to_upsert: (optional) Dictionary containing the labels to update (or add if not
         existing) in key-value pairs.
        :paramtype labels_to_upsert: dict[str, any]
        """
        super().__init__(**kwargs)
        self.kind = "reclassify"  # type: str
        self.classification_policy_id = classification_policy_id
        self.labels_to_upsert = labels_to_upsert


class RoundRobinMode(DistributionMode):
    """Jobs are distributed in order to workers, starting with the worker that is after the last worker to receive a job.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Mode. Required.
    :vartype kind: str
    :ivar min_concurrent_offers: Governs the minimum desired number of active concurrent offers a
     job can have. Required.
    :vartype min_concurrent_offers: int
    :ivar max_concurrent_offers: Governs the maximum number of active concurrent offers a job can
     have. Required.
    :vartype max_concurrent_offers: int
    :ivar bypass_selectors: (Optional)
     If set to true, then router will match workers to jobs even if they don't match label
     selectors.
     Warning: You may get workers that are not qualified for the job they are matched with if you
     set this
     variable to true. This flag is intended more for temporary usage.
     By default, set to false.
    :vartype bypass_selectors: bool
    """

    _validation = {
        "kind": {"required": True},
        "min_concurrent_offers": {"required": True},
        "max_concurrent_offers": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "min_concurrent_offers": {"key": "minConcurrentOffers", "type": "int"},
        "max_concurrent_offers": {"key": "maxConcurrentOffers", "type": "int"},
        "bypass_selectors": {"key": "bypassSelectors", "type": "bool"},
    }

    def __init__(
        self,
        *,
        min_concurrent_offers: int,
        max_concurrent_offers: int,
        bypass_selectors: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword min_concurrent_offers: Governs the minimum desired number of active concurrent offers
         a job can have. Required.
        :paramtype min_concurrent_offers: int
        :keyword max_concurrent_offers: Governs the maximum number of active concurrent offers a job
         can have. Required.
        :paramtype max_concurrent_offers: int
        :keyword bypass_selectors: (Optional)
         If set to true, then router will match workers to jobs even if they don't match label
         selectors.
         Warning: You may get workers that are not qualified for the job they are matched with if you
         set this
         variable to true. This flag is intended more for temporary usage.
         By default, set to false.
        :paramtype bypass_selectors: bool
        """
        super().__init__(
            min_concurrent_offers=min_concurrent_offers,
            max_concurrent_offers=max_concurrent_offers,
            bypass_selectors=bypass_selectors,
            **kwargs
        )
        self.kind = "round-robin"  # type: str


class RouterJob(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """A unit of work to be routed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The id of the job.
    :vartype id: str
    :ivar channel_reference: Reference to an external parent context, eg. call ID.
    :vartype channel_reference: str
    :ivar job_status: The state of the Job. Known values are: "pendingClassification", "queued",
     "assigned", "completed", "closed", "cancelled", "classificationFailed", and "created".
    :vartype job_status: str or ~azure.communication.jobrouter.models.RouterJobStatus
    :ivar enqueue_time_utc: The time a job was queued.
    :vartype enqueue_time_utc: ~datetime.datetime
    :ivar channel_id: The channel identifier. eg. voice, chat, etc.
    :vartype channel_id: str
    :ivar classification_policy_id: The Id of the Classification policy used for classifying a job.
    :vartype classification_policy_id: str
    :ivar queue_id: The Id of the Queue that this job is queued to.
    :vartype queue_id: str
    :ivar priority: The priority of this job.
    :vartype priority: int
    :ivar disposition_code: Reason code for cancelled or closed jobs.
    :vartype disposition_code: str
    :ivar requested_worker_selectors: A collection of manually specified label selectors, which a
     worker must satisfy in order to process this job.
    :vartype requested_worker_selectors: list[~azure.communication.jobrouter.models.WorkerSelector]
    :ivar attached_worker_selectors: A collection of label selectors attached by a classification
     policy, which a worker must satisfy in order to process this job.
    :vartype attached_worker_selectors: list[~azure.communication.jobrouter.models.WorkerSelector]
    :ivar labels: A set of key/value pairs that are identifying attributes used by the rules
     engines to make decisions.
    :vartype labels: dict[str, any]
    :ivar assignments: A collection of the assignments of the job.
     Key is AssignmentId.
    :vartype assignments: dict[str, ~azure.communication.jobrouter.models.JobAssignment]
    :ivar tags: A set of non-identifying attributes attached to this job.
    :vartype tags: dict[str, any]
    :ivar notes: Notes attached to a job, sorted by timestamp.
    :vartype notes: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "job_status": {"readonly": True},
        "enqueue_time_utc": {"readonly": True},
        "attached_worker_selectors": {"readonly": True},
        "assignments": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "channel_reference": {"key": "channelReference", "type": "str"},
        "job_status": {"key": "jobStatus", "type": "str"},
        "enqueue_time_utc": {"key": "enqueueTimeUtc", "type": "iso-8601"},
        "channel_id": {"key": "channelId", "type": "str"},
        "classification_policy_id": {"key": "classificationPolicyId", "type": "str"},
        "queue_id": {"key": "queueId", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "disposition_code": {"key": "dispositionCode", "type": "str"},
        "requested_worker_selectors": {"key": "requestedWorkerSelectors", "type": "[WorkerSelector]"},
        "attached_worker_selectors": {"key": "attachedWorkerSelectors", "type": "[WorkerSelector]"},
        "labels": {"key": "labels", "type": "{object}"},
        "assignments": {"key": "assignments", "type": "{JobAssignment}"},
        "tags": {"key": "tags", "type": "{object}"},
        "notes": {"key": "notes", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        channel_reference: Optional[str] = None,
        channel_id: Optional[str] = None,
        classification_policy_id: Optional[str] = None,
        queue_id: Optional[str] = None,
        priority: Optional[int] = None,
        disposition_code: Optional[str] = None,
        requested_worker_selectors: Optional[List["_models.WorkerSelector"]] = None,
        labels: Optional[Dict[str, Any]] = None,
        tags: Optional[Dict[str, Any]] = None,
        notes: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword channel_reference: Reference to an external parent context, eg. call ID.
        :paramtype channel_reference: str
        :keyword channel_id: The channel identifier. eg. voice, chat, etc.
        :paramtype channel_id: str
        :keyword classification_policy_id: The Id of the Classification policy used for classifying a
         job.
        :paramtype classification_policy_id: str
        :keyword queue_id: The Id of the Queue that this job is queued to.
        :paramtype queue_id: str
        :keyword priority: The priority of this job.
        :paramtype priority: int
        :keyword disposition_code: Reason code for cancelled or closed jobs.
        :paramtype disposition_code: str
        :keyword requested_worker_selectors: A collection of manually specified label selectors, which
         a worker must satisfy in order to process this job.
        :paramtype requested_worker_selectors:
         list[~azure.communication.jobrouter.models.WorkerSelector]
        :keyword labels: A set of key/value pairs that are identifying attributes used by the rules
         engines to make decisions.
        :paramtype labels: dict[str, any]
        :keyword tags: A set of non-identifying attributes attached to this job.
        :paramtype tags: dict[str, any]
        :keyword notes: Notes attached to a job, sorted by timestamp.
        :paramtype notes: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.channel_reference = channel_reference
        self.job_status = None
        self.enqueue_time_utc = None
        self.channel_id = channel_id
        self.classification_policy_id = classification_policy_id
        self.queue_id = queue_id
        self.priority = priority
        self.disposition_code = disposition_code
        self.requested_worker_selectors = requested_worker_selectors
        self.attached_worker_selectors = None
        self.labels = labels
        self.assignments = None
        self.tags = tags
        self.notes = notes


class RouterJobItem(_serialization.Model):
    """Paged instance of RouterJob.

    :ivar router_job: A unit of work to be routed.
    :vartype router_job: ~azure.communication.jobrouter.models.RouterJob
    :ivar etag: (Optional) The Concurrency Token.
    :vartype etag: str
    """

    _attribute_map = {
        "router_job": {"key": "routerJob", "type": "RouterJob"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, *, router_job: Optional["_models.RouterJob"] = None, etag: Optional[str] = None, **kwargs):
        """
        :keyword router_job: A unit of work to be routed.
        :paramtype router_job: ~azure.communication.jobrouter.models.RouterJob
        :keyword etag: (Optional) The Concurrency Token.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.router_job = router_job
        self.etag = etag


class RouterWorker(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """An entity for jobs to be routed to.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar state: The current state of the worker. Known values are: "active", "draining", and
     "inactive".
    :vartype state: str or ~azure.communication.jobrouter.models.RouterWorkerState
    :ivar queue_assignments: The queue(s) that this worker can receive work from.
    :vartype queue_assignments: dict[str, JSON]
    :ivar total_capacity: The total capacity score this worker has to manage multiple concurrent
     jobs.
    :vartype total_capacity: int
    :ivar labels: A set of key/value pairs that are identifying attributes used by the rules
     engines to make decisions.
    :vartype labels: dict[str, any]
    :ivar tags: A set of non-identifying attributes attached to this worker.
    :vartype tags: dict[str, any]
    :ivar channel_configurations: The channel(s) this worker can handle and their impact on the
     workers capacity.
    :vartype channel_configurations: dict[str,
     ~azure.communication.jobrouter.models.ChannelConfiguration]
    :ivar offers: A list of active offers issued to this worker.
    :vartype offers: list[~azure.communication.jobrouter.models.JobOffer]
    :ivar assigned_jobs: A list of assigned jobs attached to this worker.
    :vartype assigned_jobs: list[~azure.communication.jobrouter.models.WorkerAssignment]
    :ivar load_ratio: A value indicating the workers capacity. A value of '1' means all capacity is
     consumed. A value of '0' means no capacity is currently consumed.
    :vartype load_ratio: float
    :ivar available_for_offers: A flag indicating this worker is open to receive offers or not.
    :vartype available_for_offers: bool
    """

    _validation = {
        "id": {"readonly": True},
        "state": {"readonly": True},
        "offers": {"readonly": True},
        "assigned_jobs": {"readonly": True},
        "load_ratio": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "queue_assignments": {"key": "queueAssignments", "type": "{object}"},
        "total_capacity": {"key": "totalCapacity", "type": "int"},
        "labels": {"key": "labels", "type": "{object}"},
        "tags": {"key": "tags", "type": "{object}"},
        "channel_configurations": {"key": "channelConfigurations", "type": "{ChannelConfiguration}"},
        "offers": {"key": "offers", "type": "[JobOffer]"},
        "assigned_jobs": {"key": "assignedJobs", "type": "[WorkerAssignment]"},
        "load_ratio": {"key": "loadRatio", "type": "float"},
        "available_for_offers": {"key": "availableForOffers", "type": "bool"},
    }

    def __init__(
        self,
        *,
        queue_assignments: Optional[Dict[str, JSON]] = None,
        total_capacity: Optional[int] = None,
        labels: Optional[Dict[str, Any]] = None,
        tags: Optional[Dict[str, Any]] = None,
        channel_configurations: Optional[Dict[str, "_models.ChannelConfiguration"]] = None,
        available_for_offers: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword queue_assignments: The queue(s) that this worker can receive work from.
        :paramtype queue_assignments: dict[str, JSON]
        :keyword total_capacity: The total capacity score this worker has to manage multiple concurrent
         jobs.
        :paramtype total_capacity: int
        :keyword labels: A set of key/value pairs that are identifying attributes used by the rules
         engines to make decisions.
        :paramtype labels: dict[str, any]
        :keyword tags: A set of non-identifying attributes attached to this worker.
        :paramtype tags: dict[str, any]
        :keyword channel_configurations: The channel(s) this worker can handle and their impact on the
         workers capacity.
        :paramtype channel_configurations: dict[str,
         ~azure.communication.jobrouter.models.ChannelConfiguration]
        :keyword available_for_offers: A flag indicating this worker is open to receive offers or not.
        :paramtype available_for_offers: bool
        """
        super().__init__(**kwargs)
        self.id = None
        self.state = None
        self.queue_assignments = queue_assignments
        self.total_capacity = total_capacity
        self.labels = labels
        self.tags = tags
        self.channel_configurations = channel_configurations
        self.offers = None
        self.assigned_jobs = None
        self.load_ratio = None
        self.available_for_offers = available_for_offers


class RouterWorkerItem(_serialization.Model):
    """Paged instance of RouterWorker.

    :ivar router_worker: An entity for jobs to be routed to.
    :vartype router_worker: ~azure.communication.jobrouter.models.RouterWorker
    :ivar etag: (Optional) The Concurrency Token.
    :vartype etag: str
    """

    _attribute_map = {
        "router_worker": {"key": "routerWorker", "type": "RouterWorker"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, *, router_worker: Optional["_models.RouterWorker"] = None, etag: Optional[str] = None, **kwargs):
        """
        :keyword router_worker: An entity for jobs to be routed to.
        :paramtype router_worker: ~azure.communication.jobrouter.models.RouterWorker
        :keyword etag: (Optional) The Concurrency Token.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.router_worker = router_worker
        self.etag = etag


class RuleEngineQueueSelectorAttachment(QueueSelectorAttachment):
    """Attaches labels to a worker when a RouterRule is resolved.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of label selector attachment. Required.
    :vartype kind: str
    :ivar rule: A rule of one of the following types:

     StaticRule:  A rule providing static rules that always return the same result, regardless of
     input.
     DirectMapRule:  A rule that return the same labels as the input labels.
     ExpressionRule: A rule providing inline expression rules.
     AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function. Required.
    :vartype rule: ~azure.communication.jobrouter.models.RouterRule
    """

    _validation = {
        "kind": {"required": True},
        "rule": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "rule": {"key": "rule", "type": "RouterRule"},
    }

    def __init__(self, *, rule: "_models.RouterRule", **kwargs):
        """
        :keyword rule: A rule of one of the following types:

         StaticRule:  A rule providing static rules that always return the same result, regardless of
         input.
         DirectMapRule:  A rule that return the same labels as the input labels.
         ExpressionRule: A rule providing inline expression rules.
         AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function. Required.
        :paramtype rule: ~azure.communication.jobrouter.models.RouterRule
        """
        super().__init__(**kwargs)
        self.kind = "rule-engine"  # type: str
        self.rule = rule


class RuleEngineWorkerSelectorAttachment(WorkerSelectorAttachment):
    """Attaches labels to a worker when a RouterRule is resolved.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of label selector attachment. Required.
    :vartype kind: str
    :ivar rule: A rule of one of the following types:

     StaticRule:  A rule providing static rules that always return the same result, regardless of
     input.
     DirectMapRule:  A rule that return the same labels as the input labels.
     ExpressionRule: A rule providing inline expression rules.
     AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function. Required.
    :vartype rule: ~azure.communication.jobrouter.models.RouterRule
    """

    _validation = {
        "kind": {"required": True},
        "rule": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "rule": {"key": "rule", "type": "RouterRule"},
    }

    def __init__(self, *, rule: "_models.RouterRule", **kwargs):
        """
        :keyword rule: A rule of one of the following types:

         StaticRule:  A rule providing static rules that always return the same result, regardless of
         input.
         DirectMapRule:  A rule that return the same labels as the input labels.
         ExpressionRule: A rule providing inline expression rules.
         AzureFunctionRule: A rule providing a binding to an HTTP Triggered Azure Function. Required.
        :paramtype rule: ~azure.communication.jobrouter.models.RouterRule
        """
        super().__init__(**kwargs)
        self.kind = "rule-engine"  # type: str
        self.rule = rule


class ScoringRuleOptions(_serialization.Model):
    """Encapsulates all options that can be passed as parameters for scoring rule with BestWorkerMode.

    :ivar batch_size: (Optional) Set batch size when AllowScoringBatchOfWorkers is set to true.
    :vartype batch_size: int
    :ivar scoring_parameters: (Optional) List of extra parameters from the job that will be sent as
     part of the payload to scoring rule.
     If not set, the job's labels (sent in the payload as ``job``\ ) and the job's worker selectors
     (sent in the payload as ``selectors``\ )
     are added to the payload of the scoring rule by default.
     Note: Worker labels are always sent with scoring payload.
    :vartype scoring_parameters: list[str or
     ~azure.communication.jobrouter.models.ScoringRuleParameterSelector]
    :ivar allow_scoring_batch_of_workers: (Optional)
     If set to true, will score workers in batches, and the parameter name of the worker labels
     will be sent as ``workers``.
     By default, set to false and the parameter name for the worker labels will be sent as
     ``worker``.
     Note: If enabled, use BatchSize to set batch size.
    :vartype allow_scoring_batch_of_workers: bool
    :ivar descending_order: (Optional)
     If false, will sort scores by ascending order. By default, set to true.
    :vartype descending_order: bool
    """

    _attribute_map = {
        "batch_size": {"key": "batchSize", "type": "int"},
        "scoring_parameters": {"key": "scoringParameters", "type": "[str]"},
        "allow_scoring_batch_of_workers": {"key": "allowScoringBatchOfWorkers", "type": "bool"},
        "descending_order": {"key": "descendingOrder", "type": "bool"},
    }

    def __init__(
        self,
        *,
        batch_size: Optional[int] = None,
        scoring_parameters: Optional[List[Union[str, "_models.ScoringRuleParameterSelector"]]] = None,
        allow_scoring_batch_of_workers: Optional[bool] = None,
        descending_order: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword batch_size: (Optional) Set batch size when AllowScoringBatchOfWorkers is set to true.
        :paramtype batch_size: int
        :keyword scoring_parameters: (Optional) List of extra parameters from the job that will be sent
         as part of the payload to scoring rule.
         If not set, the job's labels (sent in the payload as ``job``\ ) and the job's worker selectors
         (sent in the payload as ``selectors``\ )
         are added to the payload of the scoring rule by default.
         Note: Worker labels are always sent with scoring payload.
        :paramtype scoring_parameters: list[str or
         ~azure.communication.jobrouter.models.ScoringRuleParameterSelector]
        :keyword allow_scoring_batch_of_workers: (Optional)
         If set to true, will score workers in batches, and the parameter name of the worker labels
         will be sent as ``workers``.
         By default, set to false and the parameter name for the worker labels will be sent as
         ``worker``.
         Note: If enabled, use BatchSize to set batch size.
        :paramtype allow_scoring_batch_of_workers: bool
        :keyword descending_order: (Optional)
         If false, will sort scores by ascending order. By default, set to true.
        :paramtype descending_order: bool
        """
        super().__init__(**kwargs)
        self.batch_size = batch_size
        self.scoring_parameters = scoring_parameters
        self.allow_scoring_batch_of_workers = allow_scoring_batch_of_workers
        self.descending_order = descending_order


class StaticQueueSelectorAttachment(QueueSelectorAttachment):
    """Describes a label selector that will always be attached.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of label selector attachment. Required.
    :vartype kind: str
    :ivar label_selector: Describes a condition that must be met against a set of labels for queue
     selection. Required.
    :vartype label_selector: ~azure.communication.jobrouter.models.QueueSelector
    """

    _validation = {
        "kind": {"required": True},
        "label_selector": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "label_selector": {"key": "labelSelector", "type": "QueueSelector"},
    }

    def __init__(self, *, label_selector: "_models.QueueSelector", **kwargs):
        """
        :keyword label_selector: Describes a condition that must be met against a set of labels for
         queue selection. Required.
        :paramtype label_selector: ~azure.communication.jobrouter.models.QueueSelector
        """
        super().__init__(**kwargs)
        self.kind = "static"  # type: str
        self.label_selector = label_selector


class StaticRule(RouterRule):
    """A rule providing static rules that always return the same result, regardless of input.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of Rule. Required.
    :vartype kind: str
    :ivar value: The static value this rule always returns.
    :vartype value: JSON
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "value": {"key": "value", "type": "object"},
    }

    def __init__(self, *, value: Optional[JSON] = None, **kwargs):
        """
        :keyword value: The static value this rule always returns.
        :paramtype value: JSON
        """
        super().__init__(**kwargs)
        self.kind = "static-rule"  # type: str
        self.value = value


class StaticWorkerSelectorAttachment(WorkerSelectorAttachment):
    """Describes a label selector that will always be attached.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of label selector attachment. Required.
    :vartype kind: str
    :ivar label_selector: Describes a condition that must be met against a set of labels for worker
     selection. Required.
    :vartype label_selector: ~azure.communication.jobrouter.models.WorkerSelector
    """

    _validation = {
        "kind": {"required": True},
        "label_selector": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "label_selector": {"key": "labelSelector", "type": "WorkerSelector"},
    }

    def __init__(self, *, label_selector: "_models.WorkerSelector", **kwargs):
        """
        :keyword label_selector: Describes a condition that must be met against a set of labels for
         worker selection. Required.
        :paramtype label_selector: ~azure.communication.jobrouter.models.WorkerSelector
        """
        super().__init__(**kwargs)
        self.kind = "static"  # type: str
        self.label_selector = label_selector


class UnassignJobResult(_serialization.Model):
    """Response payload after a job has been successfully unassigned.

    All required parameters must be populated in order to send to Azure.

    :ivar job_id: The Id of the job unassigned. Required.
    :vartype job_id: str
    :ivar unassignment_count: The number of times a job is unassigned. At a maximum 3. Required.
    :vartype unassignment_count: int
    """

    _validation = {
        "job_id": {"required": True},
        "unassignment_count": {"required": True},
    }

    _attribute_map = {
        "job_id": {"key": "jobId", "type": "str"},
        "unassignment_count": {"key": "unassignmentCount", "type": "int"},
    }

    def __init__(self, *, job_id: str, unassignment_count: int, **kwargs):
        """
        :keyword job_id: The Id of the job unassigned. Required.
        :paramtype job_id: str
        :keyword unassignment_count: The number of times a job is unassigned. At a maximum 3. Required.
        :paramtype unassignment_count: int
        """
        super().__init__(**kwargs)
        self.job_id = job_id
        self.unassignment_count = unassignment_count


class WaitTimeExceptionTrigger(JobExceptionTrigger):
    """Trigger for an exception action on exceeding wait time.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing a sub-type of ExceptionTrigger. Required.
    :vartype kind: str
    :ivar threshold_seconds: Threshold for wait time for this trigger. Required.
    :vartype threshold_seconds: float
    """

    _validation = {
        "kind": {"required": True},
        "threshold_seconds": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "threshold_seconds": {"key": "thresholdSeconds", "type": "float"},
    }

    def __init__(self, *, threshold_seconds: float, **kwargs):
        """
        :keyword threshold_seconds: Threshold for wait time for this trigger. Required.
        :paramtype threshold_seconds: float
        """
        super().__init__(**kwargs)
        self.kind = "wait-time"  # type: str
        self.threshold_seconds = threshold_seconds


class WeightedAllocationQueueSelectorAttachment(QueueSelectorAttachment):
    """Describes multiple sets of label selectors, of which one will be selected and attached according to a weighting.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of label selector attachment. Required.
    :vartype kind: str
    :ivar allocations: A collection of percentage based weighted allocations. Required.
    :vartype allocations: list[~azure.communication.jobrouter.models.QueueWeightedAllocation]
    """

    _validation = {
        "kind": {"required": True},
        "allocations": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "allocations": {"key": "allocations", "type": "[QueueWeightedAllocation]"},
    }

    def __init__(self, *, allocations: List["_models.QueueWeightedAllocation"], **kwargs):
        """
        :keyword allocations: A collection of percentage based weighted allocations. Required.
        :paramtype allocations: list[~azure.communication.jobrouter.models.QueueWeightedAllocation]
        """
        super().__init__(**kwargs)
        self.kind = "weighted-allocation-queue-selector"  # type: str
        self.allocations = allocations


class WeightedAllocationWorkerSelectorAttachment(WorkerSelectorAttachment):
    """Describes multiple sets of label selectors, of which one will be selected and attached according to a weighting.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: The type discriminator describing the type of label selector attachment. Required.
    :vartype kind: str
    :ivar allocations: A collection of percentage based weighted allocations. Required.
    :vartype allocations: list[~azure.communication.jobrouter.models.WorkerWeightedAllocation]
    """

    _validation = {
        "kind": {"required": True},
        "allocations": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "allocations": {"key": "allocations", "type": "[WorkerWeightedAllocation]"},
    }

    def __init__(self, *, allocations: List["_models.WorkerWeightedAllocation"], **kwargs):
        """
        :keyword allocations: A collection of percentage based weighted allocations. Required.
        :paramtype allocations: list[~azure.communication.jobrouter.models.WorkerWeightedAllocation]
        """
        super().__init__(**kwargs)
        self.kind = "weighted-allocation-worker-selector"  # type: str
        self.allocations = allocations


class WorkerAssignment(_serialization.Model):
    """The assignment for a worker to a job.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The Id of the assignment. Required.
    :vartype id: str
    :ivar job_id: The Id of the Job assigned. Required.
    :vartype job_id: str
    :ivar capacity_cost: The amount of capacity this assignment has consumed on the worker.
     Required.
    :vartype capacity_cost: int
    :ivar assign_time: The assignment time of the job. Required.
    :vartype assign_time: ~datetime.datetime
    """

    _validation = {
        "id": {"required": True},
        "job_id": {"required": True},
        "capacity_cost": {"required": True},
        "assign_time": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "capacity_cost": {"key": "capacityCost", "type": "int"},
        "assign_time": {"key": "assignTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        job_id: str,
        capacity_cost: int,
        assign_time: datetime.datetime,
        **kwargs
    ):
        """
        :keyword id: The Id of the assignment. Required.
        :paramtype id: str
        :keyword job_id: The Id of the Job assigned. Required.
        :paramtype job_id: str
        :keyword capacity_cost: The amount of capacity this assignment has consumed on the worker.
         Required.
        :paramtype capacity_cost: int
        :keyword assign_time: The assignment time of the job. Required.
        :paramtype assign_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.id = id
        self.job_id = job_id
        self.capacity_cost = capacity_cost
        self.assign_time = assign_time


class WorkerCollection(_serialization.Model):
    """A paged collection of workers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.communication.jobrouter.models.RouterWorkerItem]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RouterWorkerItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RouterWorkerItem"], **kwargs):
        """
        :keyword value: Required.
        :paramtype value: list[~azure.communication.jobrouter.models.RouterWorkerItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class WorkerSelector(_serialization.Model):
    """Describes a condition that must be met against a set of labels for worker selection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar key: The label key to query against. Required.
    :vartype key: str
    :ivar label_operator: Describes how the value of the label is compared to the value defined on
     the label selector. Required. Known values are: "equal", "notEqual", "lessThan",
     "lessThanEqual", "greaterThan", and "greaterThanEqual".
    :vartype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
    :ivar value: The value to compare against the actual label value with the given operator.
    :vartype value: JSON
    :ivar ttl_seconds: Describes how long this label selector is valid in seconds.
    :vartype ttl_seconds: float
    :ivar expedite: Pushes the job to the front of the queue as long as this selector is active.
    :vartype expedite: bool
    :ivar state: The state of the worker selector. Known values are: "active" and "expired".
    :vartype state: str or ~azure.communication.jobrouter.models.WorkerSelectorState
    :ivar expire_time: The time at which this worker selector expires in UTC.
    :vartype expire_time: ~datetime.datetime
    """

    _validation = {
        "key": {"required": True, "max_length": 500},
        "label_operator": {"required": True},
        "state": {"readonly": True},
        "expire_time": {"readonly": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "label_operator": {"key": "labelOperator", "type": "str"},
        "value": {"key": "value", "type": "object"},
        "ttl_seconds": {"key": "ttlSeconds", "type": "float"},
        "expedite": {"key": "expedite", "type": "bool"},
        "state": {"key": "state", "type": "str"},
        "expire_time": {"key": "expireTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        key: str,
        label_operator: Union[str, "_models.LabelOperator"],
        value: Optional[JSON] = None,
        ttl_seconds: Optional[float] = None,
        expedite: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword key: The label key to query against. Required.
        :paramtype key: str
        :keyword label_operator: Describes how the value of the label is compared to the value defined
         on the label selector. Required. Known values are: "equal", "notEqual", "lessThan",
         "lessThanEqual", "greaterThan", and "greaterThanEqual".
        :paramtype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
        :keyword value: The value to compare against the actual label value with the given operator.
        :paramtype value: JSON
        :keyword ttl_seconds: Describes how long this label selector is valid in seconds.
        :paramtype ttl_seconds: float
        :keyword expedite: Pushes the job to the front of the queue as long as this selector is active.
        :paramtype expedite: bool
        """
        super().__init__(**kwargs)
        self.key = key
        self.label_operator = label_operator
        self.value = value
        self.ttl_seconds = ttl_seconds
        self.expedite = expedite
        self.state = None
        self.expire_time = None


class WorkerWeightedAllocation(_serialization.Model):
    """Contains the weight percentage and label selectors to be applied if selected for weighted distributions.

    All required parameters must be populated in order to send to Azure.

    :ivar weight: The percentage of this weight, expressed as a fraction of 1. Required.
    :vartype weight: float
    :ivar label_selectors: A collection of label selectors that will be applied if this allocation
     is selected. Required.
    :vartype label_selectors: list[~azure.communication.jobrouter.models.WorkerSelector]
    """

    _validation = {
        "weight": {"required": True},
        "label_selectors": {"required": True},
    }

    _attribute_map = {
        "weight": {"key": "weight", "type": "float"},
        "label_selectors": {"key": "labelSelectors", "type": "[WorkerSelector]"},
    }

    def __init__(self, *, weight: float, label_selectors: List["_models.WorkerSelector"], **kwargs):
        """
        :keyword weight: The percentage of this weight, expressed as a fraction of 1. Required.
        :paramtype weight: float
        :keyword label_selectors: A collection of label selectors that will be applied if this
         allocation is selected. Required.
        :paramtype label_selectors: list[~azure.communication.jobrouter.models.WorkerSelector]
        """
        super().__init__(**kwargs)
        self.weight = weight
        self.label_selectors = label_selectors
