
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <Plugin.hxx>
#include <Plugin_DataMapIteratorOfMapOfFunctions.hxx>
#include <Plugin_Failure.hxx>
#include <Plugin_Macro.hxx>
#include <Plugin_MapOfFunctions.hxx>

// template related includes

// ./opencascade/Plugin_MapOfFunctions.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_Plugin(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("Plugin"));
py::object klass;

//Python trampoline classes

// classes

    // Class Plugin from ./opencascade/Plugin.hxx
    klass = m.attr("Plugin");

    // default constructor
    register_default_constructor<Plugin , shared_ptr<Plugin>>(m,"Plugin");

    // nested enums

    static_cast<py::class_<Plugin , shared_ptr<Plugin>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Load_s",
                    (opencascade::handle<Standard_Transient> (*)( const Standard_GUID & ,  const Standard_Boolean  ) ) static_cast<opencascade::handle<Standard_Transient> (*)( const Standard_GUID & ,  const Standard_Boolean  ) >(&Plugin::Load),
                    R"#(None)#"  , py::arg("aGUID"),  py::arg("theVerbose")=static_cast<const Standard_Boolean>(Standard_True)
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions
// ./opencascade/Plugin.hxx
// ./opencascade/Plugin_DataMapIteratorOfMapOfFunctions.hxx
// ./opencascade/Plugin_Failure.hxx
// ./opencascade/Plugin_Macro.hxx
// ./opencascade/Plugin_MapOfFunctions.hxx

// Additional functions

// operators

// register typdefs


// exceptions
register_occ_exception<Plugin_Failure>(m, "Plugin_Failure");

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
