# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ConfluentAgreementResource(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Agreement Terms definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM id of the resource.
    :vartype id: str
    :ivar name: The name of the agreement.
    :vartype name: str
    :ivar type: The type of the agreement.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.confluent.models.SystemData
    :ivar publisher: Publisher identifier string.
    :vartype publisher: str
    :ivar product: Product identifier string.
    :vartype product: str
    :ivar plan: Plan identifier string.
    :vartype plan: str
    :ivar license_text_link: Link to HTML with Microsoft and Publisher terms.
    :vartype license_text_link: str
    :ivar privacy_policy_link: Link to the privacy policy of the publisher.
    :vartype privacy_policy_link: str
    :ivar retrieve_datetime: Date and time in UTC of when the terms were accepted. This is empty if
     Accepted is false.
    :vartype retrieve_datetime: ~datetime.datetime
    :ivar signature: Terms signature.
    :vartype signature: str
    :ivar accepted: If any version of the terms have been accepted, otherwise false.
    :vartype accepted: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "product": {"key": "properties.product", "type": "str"},
        "plan": {"key": "properties.plan", "type": "str"},
        "license_text_link": {"key": "properties.licenseTextLink", "type": "str"},
        "privacy_policy_link": {"key": "properties.privacyPolicyLink", "type": "str"},
        "retrieve_datetime": {"key": "properties.retrieveDatetime", "type": "iso-8601"},
        "signature": {"key": "properties.signature", "type": "str"},
        "accepted": {"key": "properties.accepted", "type": "bool"},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        plan: Optional[str] = None,
        license_text_link: Optional[str] = None,
        privacy_policy_link: Optional[str] = None,
        retrieve_datetime: Optional[datetime.datetime] = None,
        signature: Optional[str] = None,
        accepted: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword publisher: Publisher identifier string.
        :paramtype publisher: str
        :keyword product: Product identifier string.
        :paramtype product: str
        :keyword plan: Plan identifier string.
        :paramtype plan: str
        :keyword license_text_link: Link to HTML with Microsoft and Publisher terms.
        :paramtype license_text_link: str
        :keyword privacy_policy_link: Link to the privacy policy of the publisher.
        :paramtype privacy_policy_link: str
        :keyword retrieve_datetime: Date and time in UTC of when the terms were accepted. This is empty
         if Accepted is false.
        :paramtype retrieve_datetime: ~datetime.datetime
        :keyword signature: Terms signature.
        :paramtype signature: str
        :keyword accepted: If any version of the terms have been accepted, otherwise false.
        :paramtype accepted: bool
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None
        self.publisher = publisher
        self.product = product
        self.plan = plan
        self.license_text_link = license_text_link
        self.privacy_policy_link = privacy_policy_link
        self.retrieve_datetime = retrieve_datetime
        self.signature = signature
        self.accepted = accepted


class ConfluentAgreementResourceListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.confluent.models.ConfluentAgreementResource]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConfluentAgreementResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ConfluentAgreementResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.confluent.models.ConfluentAgreementResource]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ErrorResponseBody(_serialization.Model):
    """Response body of Error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar target: Error target.
    :vartype target: str
    :ivar details: Error detail.
    :vartype details: list[~azure.mgmt.confluent.models.ErrorResponseBody]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponseBody]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None


class OfferDetail(_serialization.Model):
    """Confluent Offer detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar publisher_id: Publisher Id. Required.
    :vartype publisher_id: str
    :ivar id: Offer Id. Required.
    :vartype id: str
    :ivar plan_id: Offer Plan Id. Required.
    :vartype plan_id: str
    :ivar plan_name: Offer Plan Name. Required.
    :vartype plan_name: str
    :ivar term_unit: Offer Plan Term unit. Required.
    :vartype term_unit: str
    :ivar status: SaaS Offer Status. Known values are: "Started", "PendingFulfillmentStart",
     "InProgress", "Subscribed", "Suspended", "Reinstated", "Succeeded", "Failed", "Unsubscribed",
     and "Updating".
    :vartype status: str or ~azure.mgmt.confluent.models.SaaSOfferStatus
    """

    _validation = {
        "publisher_id": {"required": True, "max_length": 50},
        "id": {"required": True, "max_length": 50},
        "plan_id": {"required": True, "max_length": 50},
        "plan_name": {"required": True, "max_length": 50},
        "term_unit": {"required": True, "max_length": 25},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "publisher_id": {"key": "publisherId", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "plan_id": {"key": "planId", "type": "str"},
        "plan_name": {"key": "planName", "type": "str"},
        "term_unit": {"key": "termUnit", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher_id: str,
        id: str,  # pylint: disable=redefined-builtin
        plan_id: str,
        plan_name: str,
        term_unit: str,
        **kwargs
    ):
        """
        :keyword publisher_id: Publisher Id. Required.
        :paramtype publisher_id: str
        :keyword id: Offer Id. Required.
        :paramtype id: str
        :keyword plan_id: Offer Plan Id. Required.
        :paramtype plan_id: str
        :keyword plan_name: Offer Plan Name. Required.
        :paramtype plan_name: str
        :keyword term_unit: Offer Plan Term unit. Required.
        :paramtype term_unit: str
        """
        super().__init__(**kwargs)
        self.publisher_id = publisher_id
        self.id = id
        self.plan_id = plan_id
        self.plan_name = plan_name
        self.term_unit = term_unit
        self.status = None


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.Confluent.
    :vartype provider: str
    :ivar resource: Type on which the operation is performed, e.g., 'clusters'.
    :vartype resource: str
    :ivar operation: Operation type, e.g., read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation, e.g., 'Write confluent'.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft.Confluent.
        :paramtype provider: str
        :keyword resource: Type on which the operation is performed, e.g., 'clusters'.
        :paramtype resource: str
        :keyword operation: Operation type, e.g., read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation, e.g., 'Write confluent'.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of GET request to list Confluent operations.

    :ivar value: List of Confluent operations supported by the Microsoft.Confluent provider.
    :vartype value: list[~azure.mgmt.confluent.models.OperationResult]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.OperationResult"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of Confluent operations supported by the Microsoft.Confluent provider.
        :paramtype value: list[~azure.mgmt.confluent.models.OperationResult]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationResult(_serialization.Model):
    """An Confluent REST API operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.confluent.models.OperationDisplay
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        is_data_action: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.confluent.models.OperationDisplay
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.is_data_action = is_data_action


class OrganizationResource(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Organization resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ARM id of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.confluent.models.SystemData
    :ivar tags: Organization resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Location of Organization resource.
    :vartype location: str
    :ivar created_time: The creation time of the resource.
    :vartype created_time: ~datetime.datetime
    :ivar provisioning_state: Provision states for confluent RP. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.confluent.models.ProvisionState
    :ivar organization_id: Id of the Confluent organization.
    :vartype organization_id: str
    :ivar sso_url: SSO url for the Confluent organization.
    :vartype sso_url: str
    :ivar offer_detail: Confluent offer detail. Required.
    :vartype offer_detail: ~azure.mgmt.confluent.models.OfferDetail
    :ivar user_detail: Subscriber detail. Required.
    :vartype user_detail: ~azure.mgmt.confluent.models.UserDetail
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "created_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "organization_id": {"readonly": True},
        "sso_url": {"readonly": True},
        "offer_detail": {"required": True},
        "user_detail": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "created_time": {"key": "properties.createdTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "organization_id": {"key": "properties.organizationId", "type": "str"},
        "sso_url": {"key": "properties.ssoUrl", "type": "str"},
        "offer_detail": {"key": "properties.offerDetail", "type": "OfferDetail"},
        "user_detail": {"key": "properties.userDetail", "type": "UserDetail"},
    }

    def __init__(
        self,
        *,
        offer_detail: "_models.OfferDetail",
        user_detail: "_models.UserDetail",
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: Organization resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Location of Organization resource.
        :paramtype location: str
        :keyword offer_detail: Confluent offer detail. Required.
        :paramtype offer_detail: ~azure.mgmt.confluent.models.OfferDetail
        :keyword user_detail: Subscriber detail. Required.
        :paramtype user_detail: ~azure.mgmt.confluent.models.UserDetail
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None
        self.tags = tags
        self.location = location
        self.created_time = None
        self.provisioning_state = None
        self.organization_id = None
        self.sso_url = None
        self.offer_detail = offer_detail
        self.user_detail = user_detail


class OrganizationResourceListResult(_serialization.Model):
    """The response of a list operation.

    :ivar value: Result of a list operation.
    :vartype value: list[~azure.mgmt.confluent.models.OrganizationResource]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OrganizationResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.OrganizationResource"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Result of a list operation.
        :paramtype value: list[~azure.mgmt.confluent.models.OrganizationResource]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OrganizationResourceUpdate(_serialization.Model):
    """Organization Resource update.

    :ivar tags: ARM resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: ARM resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class ResourceProviderDefaultErrorResponse(_serialization.Model):
    """Default error response for resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Response body of Error.
    :vartype error: ~azure.mgmt.confluent.models.ErrorResponseBody
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseBody"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.error = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.confluent.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.confluent.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.confluent.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.confluent.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserDetail(_serialization.Model):
    """Subscriber detail.

    All required parameters must be populated in order to send to Azure.

    :ivar first_name: First name.
    :vartype first_name: str
    :ivar last_name: Last name.
    :vartype last_name: str
    :ivar email_address: Email address. Required.
    :vartype email_address: str
    """

    _validation = {
        "first_name": {"max_length": 50},
        "last_name": {"max_length": 50},
        "email_address": {"required": True, "pattern": r"^\S+@\S+\.\S+$"},
    }

    _attribute_map = {
        "first_name": {"key": "firstName", "type": "str"},
        "last_name": {"key": "lastName", "type": "str"},
        "email_address": {"key": "emailAddress", "type": "str"},
    }

    def __init__(
        self, *, email_address: str, first_name: Optional[str] = None, last_name: Optional[str] = None, **kwargs
    ):
        """
        :keyword first_name: First name.
        :paramtype first_name: str
        :keyword last_name: Last name.
        :paramtype last_name: str
        :keyword email_address: Email address. Required.
        :paramtype email_address: str
        """
        super().__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.email_address = email_address
