# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class ApiDefinitionInfo(msrest.serialization.Model):
    """Information about the formal API definition for the app.

    :param url: The URL of the API definition.
    :type url: str
    """

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiDefinitionInfo, self).__init__(**kwargs)
        self.url = kwargs.get('url', None)


class ApplicationLogsConfig(msrest.serialization.Model):
    """Application logs configuration.

    :param file_system: Application logs to file system configuration.
    :type file_system: ~azure.mgmt.web.v2016_08_01.models.FileSystemApplicationLogsConfig
    :param azure_table_storage: Application logs to azure table storage configuration.
    :type azure_table_storage:
     ~azure.mgmt.web.v2016_08_01.models.AzureTableStorageApplicationLogsConfig
    :param azure_blob_storage: Application logs to blob storage configuration.
    :type azure_blob_storage:
     ~azure.mgmt.web.v2016_08_01.models.AzureBlobStorageApplicationLogsConfig
    """

    _attribute_map = {
        'file_system': {'key': 'fileSystem', 'type': 'FileSystemApplicationLogsConfig'},
        'azure_table_storage': {'key': 'azureTableStorage', 'type': 'AzureTableStorageApplicationLogsConfig'},
        'azure_blob_storage': {'key': 'azureBlobStorage', 'type': 'AzureBlobStorageApplicationLogsConfig'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationLogsConfig, self).__init__(**kwargs)
        self.file_system = kwargs.get('file_system', None)
        self.azure_table_storage = kwargs.get('azure_table_storage', None)
        self.azure_blob_storage = kwargs.get('azure_blob_storage', None)


class AutoHealActions(msrest.serialization.Model):
    """Actions which to take by the auto-heal module when a rule is triggered.

    :param action_type: Predefined action to be taken. Possible values include: "Recycle",
     "LogEvent", "CustomAction".
    :type action_type: str or ~azure.mgmt.web.v2016_08_01.models.AutoHealActionType
    :param custom_action: Custom action to be taken.
    :type custom_action: ~azure.mgmt.web.v2016_08_01.models.AutoHealCustomAction
    :param min_process_execution_time: Minimum time the process must execute
     before taking the action.
    :type min_process_execution_time: str
    """

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
        'custom_action': {'key': 'customAction', 'type': 'AutoHealCustomAction'},
        'min_process_execution_time': {'key': 'minProcessExecutionTime', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoHealActions, self).__init__(**kwargs)
        self.action_type = kwargs.get('action_type', None)
        self.custom_action = kwargs.get('custom_action', None)
        self.min_process_execution_time = kwargs.get('min_process_execution_time', None)


class AutoHealCustomAction(msrest.serialization.Model):
    """Custom action to be executed
when an auto heal rule is triggered.

    :param exe: Executable to be run.
    :type exe: str
    :param parameters: Parameters for the executable.
    :type parameters: str
    """

    _attribute_map = {
        'exe': {'key': 'exe', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoHealCustomAction, self).__init__(**kwargs)
        self.exe = kwargs.get('exe', None)
        self.parameters = kwargs.get('parameters', None)


class AutoHealRules(msrest.serialization.Model):
    """Rules that can be defined for auto-heal.

    :param triggers: Conditions that describe when to execute the auto-heal actions.
    :type triggers: ~azure.mgmt.web.v2016_08_01.models.AutoHealTriggers
    :param actions: Actions to be executed when a rule is triggered.
    :type actions: ~azure.mgmt.web.v2016_08_01.models.AutoHealActions
    """

    _attribute_map = {
        'triggers': {'key': 'triggers', 'type': 'AutoHealTriggers'},
        'actions': {'key': 'actions', 'type': 'AutoHealActions'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoHealRules, self).__init__(**kwargs)
        self.triggers = kwargs.get('triggers', None)
        self.actions = kwargs.get('actions', None)


class AutoHealTriggers(msrest.serialization.Model):
    """Triggers for auto-heal.

    :param requests: A rule based on total requests.
    :type requests: ~azure.mgmt.web.v2016_08_01.models.RequestsBasedTrigger
    :param private_bytes_in_kb: A rule based on private bytes.
    :type private_bytes_in_kb: int
    :param status_codes: A rule based on status codes.
    :type status_codes: list[~azure.mgmt.web.v2016_08_01.models.StatusCodesBasedTrigger]
    :param slow_requests: A rule based on request execution time.
    :type slow_requests: ~azure.mgmt.web.v2016_08_01.models.SlowRequestsBasedTrigger
    """

    _attribute_map = {
        'requests': {'key': 'requests', 'type': 'RequestsBasedTrigger'},
        'private_bytes_in_kb': {'key': 'privateBytesInKB', 'type': 'int'},
        'status_codes': {'key': 'statusCodes', 'type': '[StatusCodesBasedTrigger]'},
        'slow_requests': {'key': 'slowRequests', 'type': 'SlowRequestsBasedTrigger'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoHealTriggers, self).__init__(**kwargs)
        self.requests = kwargs.get('requests', None)
        self.private_bytes_in_kb = kwargs.get('private_bytes_in_kb', None)
        self.status_codes = kwargs.get('status_codes', None)
        self.slow_requests = kwargs.get('slow_requests', None)


class AzureBlobStorageApplicationLogsConfig(msrest.serialization.Model):
    """Application logs azure blob storage configuration.

    :param level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
     "Error".
    :type level: str or ~azure.mgmt.web.v2016_08_01.models.LogLevel
    :param sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
    :type sas_url: str
    :param retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :type retention_in_days: int
    """

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobStorageApplicationLogsConfig, self).__init__(**kwargs)
        self.level = kwargs.get('level', None)
        self.sas_url = kwargs.get('sas_url', None)
        self.retention_in_days = kwargs.get('retention_in_days', None)


class AzureBlobStorageHttpLogsConfig(msrest.serialization.Model):
    """Http logs to azure blob storage configuration.

    :param sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
    :type sas_url: str
    :param retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :type retention_in_days: int
    :param enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :type enabled: bool
    """

    _attribute_map = {
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobStorageHttpLogsConfig, self).__init__(**kwargs)
        self.sas_url = kwargs.get('sas_url', None)
        self.retention_in_days = kwargs.get('retention_in_days', None)
        self.enabled = kwargs.get('enabled', None)


class AzureTableStorageApplicationLogsConfig(msrest.serialization.Model):
    """Application logs to Azure table storage configuration.

    All required parameters must be populated in order to send to Azure.

    :param level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
     "Error".
    :type level: str or ~azure.mgmt.web.v2016_08_01.models.LogLevel
    :param sas_url: Required. SAS URL to an Azure table with add/query/delete permissions.
    :type sas_url: str
    """

    _validation = {
        'sas_url': {'required': True},
    }

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureTableStorageApplicationLogsConfig, self).__init__(**kwargs)
        self.level = kwargs.get('level', None)
        self.sas_url = kwargs['sas_url']


class ProxyOnlyResource(msrest.serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kwargs.get('kind', None)
        self.type = None


class BackupItem(ProxyOnlyResource):
    """Backup description.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar backup_id: Id of the backup.
    :vartype backup_id: int
    :ivar storage_account_url: SAS URL for the storage account container which contains this
     backup.
    :vartype storage_account_url: str
    :ivar blob_name: Name of the blob which contains data for this backup.
    :vartype blob_name: str
    :ivar name_properties_name: Name of this backup.
    :vartype name_properties_name: str
    :ivar status: Backup status. Possible values include: "InProgress", "Failed", "Succeeded",
     "TimedOut", "Created", "Skipped", "PartiallySucceeded", "DeleteInProgress", "DeleteFailed",
     "Deleted".
    :vartype status: str or ~azure.mgmt.web.v2016_08_01.models.BackupItemStatus
    :ivar size_in_bytes: Size of the backup in bytes.
    :vartype size_in_bytes: long
    :ivar created: Timestamp of the backup creation.
    :vartype created: ~datetime.datetime
    :ivar log: Details regarding this backup. Might contain an error message.
    :vartype log: str
    :ivar databases: List of databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2016_08_01.models.DatabaseBackupSetting]
    :ivar scheduled: True if this backup has been created due to a schedule being triggered.
    :vartype scheduled: bool
    :ivar last_restore_time_stamp: Timestamp of a last restore operation which used this backup.
    :vartype last_restore_time_stamp: ~datetime.datetime
    :ivar finished_time_stamp: Timestamp when this backup finished.
    :vartype finished_time_stamp: ~datetime.datetime
    :ivar correlation_id: Unique correlation identifier. Please use this along with the timestamp
     while communicating with Azure support.
    :vartype correlation_id: str
    :ivar website_size_in_bytes: Size of the original web app which has been backed up.
    :vartype website_size_in_bytes: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'backup_id': {'readonly': True},
        'storage_account_url': {'readonly': True},
        'blob_name': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'status': {'readonly': True},
        'size_in_bytes': {'readonly': True},
        'created': {'readonly': True},
        'log': {'readonly': True},
        'databases': {'readonly': True},
        'scheduled': {'readonly': True},
        'last_restore_time_stamp': {'readonly': True},
        'finished_time_stamp': {'readonly': True},
        'correlation_id': {'readonly': True},
        'website_size_in_bytes': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backup_id': {'key': 'properties.id', 'type': 'int'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'blob_name': {'key': 'properties.blobName', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'size_in_bytes': {'key': 'properties.sizeInBytes', 'type': 'long'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'log': {'key': 'properties.log', 'type': 'str'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
        'scheduled': {'key': 'properties.scheduled', 'type': 'bool'},
        'last_restore_time_stamp': {'key': 'properties.lastRestoreTimeStamp', 'type': 'iso-8601'},
        'finished_time_stamp': {'key': 'properties.finishedTimeStamp', 'type': 'iso-8601'},
        'correlation_id': {'key': 'properties.correlationId', 'type': 'str'},
        'website_size_in_bytes': {'key': 'properties.websiteSizeInBytes', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupItem, self).__init__(**kwargs)
        self.backup_id = None
        self.storage_account_url = None
        self.blob_name = None
        self.name_properties_name = None
        self.status = None
        self.size_in_bytes = None
        self.created = None
        self.log = None
        self.databases = None
        self.scheduled = None
        self.last_restore_time_stamp = None
        self.finished_time_stamp = None
        self.correlation_id = None
        self.website_size_in_bytes = None


class BackupItemCollection(msrest.serialization.Model):
    """Collection of backup items.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.BackupItem]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BackupItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupItemCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class BackupRequest(ProxyOnlyResource):
    """Description of a backup which will be performed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param backup_request_name: Name of the backup.
    :type backup_request_name: str
    :param enabled: True if the backup schedule is enabled (must be included in that case), false
     if the backup schedule should be disabled.
    :type enabled: bool
    :param storage_account_url: SAS URL to the container.
    :type storage_account_url: str
    :param backup_schedule: Schedule for the backup if it is executed periodically.
    :type backup_schedule: ~azure.mgmt.web.v2016_08_01.models.BackupSchedule
    :param databases: Databases included in the backup.
    :type databases: list[~azure.mgmt.web.v2016_08_01.models.DatabaseBackupSetting]
    :param type_properties_type: Type of the backup. Possible values include: "Default", "Clone",
     "Relocation", "Snapshot".
    :type type_properties_type: str or
     ~azure.mgmt.web.v2016_08_01.models.BackupRestoreOperationType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backup_request_name': {'key': 'properties.name', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'backup_schedule': {'key': 'properties.backupSchedule', 'type': 'BackupSchedule'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupRequest, self).__init__(**kwargs)
        self.backup_request_name = kwargs.get('backup_request_name', None)
        self.enabled = kwargs.get('enabled', None)
        self.storage_account_url = kwargs.get('storage_account_url', None)
        self.backup_schedule = kwargs.get('backup_schedule', None)
        self.databases = kwargs.get('databases', None)
        self.type_properties_type = kwargs.get('type_properties_type', None)


class BackupSchedule(msrest.serialization.Model):
    """Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param frequency_interval: Required. How often the backup should be executed (e.g. for weekly
     backup, this should be set to 7 and FrequencyUnit should be set to Day).
    :type frequency_interval: int
    :param frequency_unit: Required. The unit of time for how often the backup should be executed
     (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7).
     Possible values include: "Day", "Hour". Default value: "Day".
    :type frequency_unit: str or ~azure.mgmt.web.v2016_08_01.models.FrequencyUnit
    :param keep_at_least_one_backup: Required. True if the retention policy should always keep at
     least one backup in the storage account, regardless how old it is; false otherwise.
    :type keep_at_least_one_backup: bool
    :param retention_period_in_days: Required. After how many days backups should be deleted.
    :type retention_period_in_days: int
    :param start_time: When the schedule should start working.
    :type start_time: ~datetime.datetime
    :ivar last_execution_time: Last time when this schedule was triggered.
    :vartype last_execution_time: ~datetime.datetime
    """

    _validation = {
        'frequency_interval': {'required': True},
        'frequency_unit': {'required': True},
        'keep_at_least_one_backup': {'required': True},
        'retention_period_in_days': {'required': True},
        'last_execution_time': {'readonly': True},
    }

    _attribute_map = {
        'frequency_interval': {'key': 'frequencyInterval', 'type': 'int'},
        'frequency_unit': {'key': 'frequencyUnit', 'type': 'str'},
        'keep_at_least_one_backup': {'key': 'keepAtLeastOneBackup', 'type': 'bool'},
        'retention_period_in_days': {'key': 'retentionPeriodInDays', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_execution_time': {'key': 'lastExecutionTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupSchedule, self).__init__(**kwargs)
        self.frequency_interval = kwargs.get('frequency_interval', 7)
        self.frequency_unit = kwargs.get('frequency_unit', "Day")
        self.keep_at_least_one_backup = kwargs.get('keep_at_least_one_backup', True)
        self.retention_period_in_days = kwargs.get('retention_period_in_days', 30)
        self.start_time = kwargs.get('start_time', None)
        self.last_execution_time = None


class CloningInfo(msrest.serialization.Model):
    """Information needed for cloning operation.

    All required parameters must be populated in order to send to Azure.

    :param correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
     operations
     together to use the same snapshot.
    :type correlation_id: str
    :param overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
     :code:`<code>false</code>`.
    :type overwrite: bool
    :param clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from source
     app; otherwise, :code:`<code>false</code>`.
    :type clone_custom_host_names: bool
    :param clone_source_control: :code:`<code>true</code>` to clone source control from source app;
     otherwise, :code:`<code>false</code>`.
    :type clone_source_control: bool
    :param source_web_app_id: Required. ARM resource ID of the source app. App resource ID is of
     the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :type source_web_app_id: str
    :param hosting_environment: App Service Environment.
    :type hosting_environment: str
    :param app_settings_overrides: Application setting overrides for cloned app. If specified,
     these settings override the settings cloned
     from source app. Otherwise, application settings from source app are retained.
    :type app_settings_overrides: dict[str, str]
    :param configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
     source and destination app.
    :type configure_load_balancing: bool
    :param traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if it
     exists. Traffic Manager resource ID is of the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
    :type traffic_manager_profile_id: str
    :param traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
     needed if Traffic Manager profile does not already exist.
    :type traffic_manager_profile_name: str
    :param ignore_quotas: :code:`<code>true</code>` if quotas should be ignored; otherwise,
     :code:`<code>false</code>`.
    :type ignore_quotas: bool
    """

    _validation = {
        'source_web_app_id': {'required': True},
    }

    _attribute_map = {
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'overwrite': {'key': 'overwrite', 'type': 'bool'},
        'clone_custom_host_names': {'key': 'cloneCustomHostNames', 'type': 'bool'},
        'clone_source_control': {'key': 'cloneSourceControl', 'type': 'bool'},
        'source_web_app_id': {'key': 'sourceWebAppId', 'type': 'str'},
        'hosting_environment': {'key': 'hostingEnvironment', 'type': 'str'},
        'app_settings_overrides': {'key': 'appSettingsOverrides', 'type': '{str}'},
        'configure_load_balancing': {'key': 'configureLoadBalancing', 'type': 'bool'},
        'traffic_manager_profile_id': {'key': 'trafficManagerProfileId', 'type': 'str'},
        'traffic_manager_profile_name': {'key': 'trafficManagerProfileName', 'type': 'str'},
        'ignore_quotas': {'key': 'ignoreQuotas', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloningInfo, self).__init__(**kwargs)
        self.correlation_id = kwargs.get('correlation_id', None)
        self.overwrite = kwargs.get('overwrite', None)
        self.clone_custom_host_names = kwargs.get('clone_custom_host_names', None)
        self.clone_source_control = kwargs.get('clone_source_control', None)
        self.source_web_app_id = kwargs['source_web_app_id']
        self.hosting_environment = kwargs.get('hosting_environment', None)
        self.app_settings_overrides = kwargs.get('app_settings_overrides', None)
        self.configure_load_balancing = kwargs.get('configure_load_balancing', None)
        self.traffic_manager_profile_id = kwargs.get('traffic_manager_profile_id', None)
        self.traffic_manager_profile_name = kwargs.get('traffic_manager_profile_name', None)
        self.ignore_quotas = kwargs.get('ignore_quotas', None)


class ConnectionStringDictionary(ProxyOnlyResource):
    """String dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: Connection strings.
    :type properties: dict[str, ~azure.mgmt.web.v2016_08_01.models.ConnStringValueTypePair]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{ConnStringValueTypePair}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionStringDictionary, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class ConnStringInfo(msrest.serialization.Model):
    """Database connection string information.

    :param name: Name of connection string.
    :type name: str
    :param connection_string: Connection string value.
    :type connection_string: str
    :param type: Type of database. Possible values include: "MySql", "SQLServer", "SQLAzure",
     "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache",
     "PostgreSQL".
    :type type: str or ~azure.mgmt.web.v2016_08_01.models.ConnectionStringType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnStringInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.connection_string = kwargs.get('connection_string', None)
        self.type = kwargs.get('type', None)


class ConnStringValueTypePair(msrest.serialization.Model):
    """Database connection string value to type pair.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Value of pair.
    :type value: str
    :param type: Required. Type of database. Possible values include: "MySql", "SQLServer",
     "SQLAzure", "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb",
     "RedisCache", "PostgreSQL".
    :type type: str or ~azure.mgmt.web.v2016_08_01.models.ConnectionStringType
    """

    _validation = {
        'value': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnStringValueTypePair, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.type = kwargs['type']


class ContinuousWebJob(ProxyOnlyResource):
    """Continuous Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param status: Job status. Possible values include: "Initializing", "Starting", "Running",
     "PendingRestart", "Stopped".
    :type status: str or ~azure.mgmt.web.v2016_08_01.models.ContinuousWebJobStatus
    :param detailed_status: Detailed status.
    :type detailed_status: str
    :param log_url: Log URL.
    :type log_url: str
    :ivar name_properties_name: Job name. Used as job identifier in ARM resource URI.
    :vartype name_properties_name: str
    :param run_command: Run command.
    :type run_command: str
    :param url: Job URL.
    :type url: str
    :param extra_info_url: Extra Info URL.
    :type extra_info_url: str
    :param job_type: Job type. Possible values include: "Continuous", "Triggered".
    :type job_type: str or ~azure.mgmt.web.v2016_08_01.models.WebJobType
    :param error: Error information.
    :type error: str
    :param using_sdk: Using SDK?.
    :type using_sdk: bool
    :param settings: Job settings.
    :type settings: dict[str, object]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'detailed_status': {'key': 'properties.detailedStatus', 'type': 'str'},
        'log_url': {'key': 'properties.logUrl', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'run_command': {'key': 'properties.runCommand', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extraInfoUrl', 'type': 'str'},
        'job_type': {'key': 'properties.jobType', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.usingSdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContinuousWebJob, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.detailed_status = kwargs.get('detailed_status', None)
        self.log_url = kwargs.get('log_url', None)
        self.name_properties_name = None
        self.run_command = kwargs.get('run_command', None)
        self.url = kwargs.get('url', None)
        self.extra_info_url = kwargs.get('extra_info_url', None)
        self.job_type = kwargs.get('job_type', None)
        self.error = kwargs.get('error', None)
        self.using_sdk = kwargs.get('using_sdk', None)
        self.settings = kwargs.get('settings', None)


class ContinuousWebJobCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.ContinuousWebJob]
    :param next_link: Link to next page of resources.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ContinuousWebJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContinuousWebJobCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class CorsSettings(msrest.serialization.Model):
    """Cross-Origin Resource Sharing (CORS) settings for the app.

    :param allowed_origins: Gets or sets the list of origins that should be allowed to make cross-
     origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
    :type allowed_origins: list[str]
    """

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CorsSettings, self).__init__(**kwargs)
        self.allowed_origins = kwargs.get('allowed_origins', None)


class CsmPublishingProfileOptions(msrest.serialization.Model):
    """Publishing options for requested profile.

    :param format: Name of the format. Valid values are:
     FileZilla3
     WebDeploy -- default
     Ftp. Possible values include: "FileZilla3", "WebDeploy", "Ftp".
    :type format: str or ~azure.mgmt.web.v2016_08_01.models.PublishingProfileFormat
    """

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmPublishingProfileOptions, self).__init__(**kwargs)
        self.format = kwargs.get('format', None)


class CsmSlotEntity(msrest.serialization.Model):
    """Deployment slot parameters.

    All required parameters must be populated in order to send to Azure.

    :param target_slot: Required. Destination deployment slot during swap operation.
    :type target_slot: str
    :param preserve_vnet: Required. :code:`<code>true</code>` to preserve Virtual Network to the
     slot during swap; otherwise, :code:`<code>false</code>`.
    :type preserve_vnet: bool
    """

    _validation = {
        'target_slot': {'required': True},
        'preserve_vnet': {'required': True},
    }

    _attribute_map = {
        'target_slot': {'key': 'targetSlot', 'type': 'str'},
        'preserve_vnet': {'key': 'preserveVnet', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmSlotEntity, self).__init__(**kwargs)
        self.target_slot = kwargs['target_slot']
        self.preserve_vnet = kwargs['preserve_vnet']


class CsmUsageQuota(msrest.serialization.Model):
    """Usage of the quota resource.

    :param unit: Units of measurement for the quota resource.
    :type unit: str
    :param next_reset_time: Next reset time for the resource counter.
    :type next_reset_time: ~datetime.datetime
    :param current_value: The current value of the resource counter.
    :type current_value: long
    :param limit: The resource limit.
    :type limit: long
    :param name: Quota name.
    :type name: ~azure.mgmt.web.v2016_08_01.models.LocalizableString
    """

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmUsageQuota, self).__init__(**kwargs)
        self.unit = kwargs.get('unit', None)
        self.next_reset_time = kwargs.get('next_reset_time', None)
        self.current_value = kwargs.get('current_value', None)
        self.limit = kwargs.get('limit', None)
        self.name = kwargs.get('name', None)


class CsmUsageQuotaCollection(msrest.serialization.Model):
    """Collection of CSM usage quotas.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.CsmUsageQuota]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CsmUsageQuota]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmUsageQuotaCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class CustomHostnameAnalysisResult(ProxyOnlyResource):
    """Custom domain analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_hostname_already_verified: :code:`<code>true</code>` if hostname is already verified;
     otherwise, :code:`<code>false</code>`.
    :vartype is_hostname_already_verified: bool
    :ivar custom_domain_verification_test: DNS verification test result. Possible values include:
     "Passed", "Failed", "Skipped".
    :vartype custom_domain_verification_test: str or
     ~azure.mgmt.web.v2016_08_01.models.DnsVerificationTestResult
    :ivar custom_domain_verification_failure_info: Raw failure information if DNS verification
     fails.
    :vartype custom_domain_verification_failure_info:
     ~azure.mgmt.web.v2016_08_01.models.ErrorEntity
    :ivar has_conflict_on_scale_unit: :code:`<code>true</code>` if there is a conflict on a scale
     unit; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_on_scale_unit: bool
    :ivar has_conflict_across_subscription: :code:`<code>true</code>` if there is a conflict across
     subscriptions; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_across_subscription: bool
    :ivar conflicting_app_resource_id: Name of the conflicting app on scale unit if it's within the
     same subscription.
    :vartype conflicting_app_resource_id: str
    :param c_name_records: CName records controller can see for this hostname.
    :type c_name_records: list[str]
    :param txt_records: TXT records controller can see for this hostname.
    :type txt_records: list[str]
    :param a_records: A records controller can see for this hostname.
    :type a_records: list[str]
    :param alternate_c_name_records: Alternate CName records controller can see for this hostname.
    :type alternate_c_name_records: list[str]
    :param alternate_txt_records: Alternate TXT records controller can see for this hostname.
    :type alternate_txt_records: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'is_hostname_already_verified': {'readonly': True},
        'custom_domain_verification_test': {'readonly': True},
        'custom_domain_verification_failure_info': {'readonly': True},
        'has_conflict_on_scale_unit': {'readonly': True},
        'has_conflict_across_subscription': {'readonly': True},
        'conflicting_app_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_hostname_already_verified': {'key': 'properties.isHostnameAlreadyVerified', 'type': 'bool'},
        'custom_domain_verification_test': {'key': 'properties.customDomainVerificationTest', 'type': 'str'},
        'custom_domain_verification_failure_info': {'key': 'properties.customDomainVerificationFailureInfo', 'type': 'ErrorEntity'},
        'has_conflict_on_scale_unit': {'key': 'properties.hasConflictOnScaleUnit', 'type': 'bool'},
        'has_conflict_across_subscription': {'key': 'properties.hasConflictAcrossSubscription', 'type': 'bool'},
        'conflicting_app_resource_id': {'key': 'properties.conflictingAppResourceId', 'type': 'str'},
        'c_name_records': {'key': 'properties.cNameRecords', 'type': '[str]'},
        'txt_records': {'key': 'properties.txtRecords', 'type': '[str]'},
        'a_records': {'key': 'properties.aRecords', 'type': '[str]'},
        'alternate_c_name_records': {'key': 'properties.alternateCNameRecords', 'type': '[str]'},
        'alternate_txt_records': {'key': 'properties.alternateTxtRecords', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomHostnameAnalysisResult, self).__init__(**kwargs)
        self.is_hostname_already_verified = None
        self.custom_domain_verification_test = None
        self.custom_domain_verification_failure_info = None
        self.has_conflict_on_scale_unit = None
        self.has_conflict_across_subscription = None
        self.conflicting_app_resource_id = None
        self.c_name_records = kwargs.get('c_name_records', None)
        self.txt_records = kwargs.get('txt_records', None)
        self.a_records = kwargs.get('a_records', None)
        self.alternate_c_name_records = kwargs.get('alternate_c_name_records', None)
        self.alternate_txt_records = kwargs.get('alternate_txt_records', None)


class DatabaseBackupSetting(msrest.serialization.Model):
    """Database backup settings.

    All required parameters must be populated in order to send to Azure.

    :param database_type: Required. Database type (e.g. SqlAzure / MySql). Possible values include:
     "SqlAzure", "MySql", "LocalMySql", "PostgreSql".
    :type database_type: str or ~azure.mgmt.web.v2016_08_01.models.DatabaseType
    :param name:
    :type name: str
    :param connection_string_name: Contains a connection string name that is linked to the
     SiteConfig.ConnectionStrings.
     This is used during restore with overwrite connection strings options.
    :type connection_string_name: str
    :param connection_string: Contains a connection string to a database which is being backed up
     or restored. If the restore should happen to a new database, the database name inside is the
     new one.
    :type connection_string: str
    """

    _validation = {
        'database_type': {'required': True},
    }

    _attribute_map = {
        'database_type': {'key': 'databaseType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'connection_string_name': {'key': 'connectionStringName', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseBackupSetting, self).__init__(**kwargs)
        self.database_type = kwargs['database_type']
        self.name = kwargs.get('name', None)
        self.connection_string_name = kwargs.get('connection_string_name', None)
        self.connection_string = kwargs.get('connection_string', None)


class Deployment(ProxyOnlyResource):
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param id_properties_id: Identifier for deployment.
    :type id_properties_id: str
    :param status: Deployment status.
    :type status: int
    :param message: Details about deployment status.
    :type message: str
    :param author: Who authored the deployment.
    :type author: str
    :param deployer: Who performed the deployment.
    :type deployer: str
    :param author_email: Author email.
    :type author_email: str
    :param start_time: Start time.
    :type start_time: ~datetime.datetime
    :param end_time: End time.
    :type end_time: ~datetime.datetime
    :param active: True if deployment is currently active, false if completed and null if not
     started.
    :type active: bool
    :param details: Details on deployment.
    :type details: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'int'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'deployer': {'key': 'properties.deployer', 'type': 'str'},
        'author_email': {'key': 'properties.authorEmail', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'active': {'key': 'properties.active', 'type': 'bool'},
        'details': {'key': 'properties.details', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Deployment, self).__init__(**kwargs)
        self.id_properties_id = kwargs.get('id_properties_id', None)
        self.status = kwargs.get('status', None)
        self.message = kwargs.get('message', None)
        self.author = kwargs.get('author', None)
        self.deployer = kwargs.get('deployer', None)
        self.author_email = kwargs.get('author_email', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.active = kwargs.get('active', None)
        self.details = kwargs.get('details', None)


class DeploymentCollection(msrest.serialization.Model):
    """Collection of app deployments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.Deployment]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Deployment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeploymentCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class EnabledConfig(msrest.serialization.Model):
    """Enabled configuration.

    :param enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :type enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnabledConfig, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)


class ErrorEntity(msrest.serialization.Model):
    """Body of the error response returned from the API.

    :param extended_code: Type of error.
    :type extended_code: str
    :param message_template: Message template.
    :type message_template: str
    :param parameters: Parameters for the template.
    :type parameters: list[str]
    :param inner_errors: Inner errors.
    :type inner_errors: list[~azure.mgmt.web.v2016_08_01.models.ErrorEntity]
    :param code: Basic error code.
    :type code: str
    :param message: Any details of the error.
    :type message: str
    """

    _attribute_map = {
        'extended_code': {'key': 'extendedCode', 'type': 'str'},
        'message_template': {'key': 'messageTemplate', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[str]'},
        'inner_errors': {'key': 'innerErrors', 'type': '[ErrorEntity]'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorEntity, self).__init__(**kwargs)
        self.extended_code = kwargs.get('extended_code', None)
        self.message_template = kwargs.get('message_template', None)
        self.parameters = kwargs.get('parameters', None)
        self.inner_errors = kwargs.get('inner_errors', None)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class Experiments(msrest.serialization.Model):
    """Routing rules in production experiments.

    :param ramp_up_rules: List of ramp-up rules.
    :type ramp_up_rules: list[~azure.mgmt.web.v2016_08_01.models.RampUpRule]
    """

    _attribute_map = {
        'ramp_up_rules': {'key': 'rampUpRules', 'type': '[RampUpRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Experiments, self).__init__(**kwargs)
        self.ramp_up_rules = kwargs.get('ramp_up_rules', None)


class FileSystemApplicationLogsConfig(msrest.serialization.Model):
    """Application logs to file system configuration.

    :param level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
     "Error".
    :type level: str or ~azure.mgmt.web.v2016_08_01.models.LogLevel
    """

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileSystemApplicationLogsConfig, self).__init__(**kwargs)
        self.level = kwargs.get('level', None)


class FileSystemHttpLogsConfig(msrest.serialization.Model):
    """Http logs to file system configuration.

    :param retention_in_mb: Maximum size in megabytes that http log files can use.
     When reached old log files will be removed to make space for new ones.
     Value can range between 25 and 100.
    :type retention_in_mb: int
    :param retention_in_days: Retention in days.
     Remove files older than X days.
     0 or lower means no retention.
    :type retention_in_days: int
    :param enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :type enabled: bool
    """

    _validation = {
        'retention_in_mb': {'maximum': 100, 'minimum': 25},
    }

    _attribute_map = {
        'retention_in_mb': {'key': 'retentionInMb', 'type': 'int'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileSystemHttpLogsConfig, self).__init__(**kwargs)
        self.retention_in_mb = kwargs.get('retention_in_mb', None)
        self.retention_in_days = kwargs.get('retention_in_days', None)
        self.enabled = kwargs.get('enabled', None)


class FunctionEnvelope(ProxyOnlyResource):
    """Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Function name.
    :vartype name_properties_name: str
    :ivar function_app_id: Function App ID.
    :vartype function_app_id: str
    :param script_root_path_href: Script root path URI.
    :type script_root_path_href: str
    :param script_href: Script URI.
    :type script_href: str
    :param config_href: Config URI.
    :type config_href: str
    :param secrets_file_href: Secrets file URI.
    :type secrets_file_href: str
    :param href: Function URI.
    :type href: str
    :param config: Config information.
    :type config: object
    :param files: File list.
    :type files: dict[str, str]
    :param test_data: Test data used when testing via the Azure Portal.
    :type test_data: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'function_app_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'function_app_id': {'key': 'properties.functionAppId', 'type': 'str'},
        'script_root_path_href': {'key': 'properties.scriptRootPathHref', 'type': 'str'},
        'script_href': {'key': 'properties.scriptHref', 'type': 'str'},
        'config_href': {'key': 'properties.configHref', 'type': 'str'},
        'secrets_file_href': {'key': 'properties.secretsFileHref', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'config': {'key': 'properties.config', 'type': 'object'},
        'files': {'key': 'properties.files', 'type': '{str}'},
        'test_data': {'key': 'properties.testData', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionEnvelope, self).__init__(**kwargs)
        self.name_properties_name = None
        self.function_app_id = None
        self.script_root_path_href = kwargs.get('script_root_path_href', None)
        self.script_href = kwargs.get('script_href', None)
        self.config_href = kwargs.get('config_href', None)
        self.secrets_file_href = kwargs.get('secrets_file_href', None)
        self.href = kwargs.get('href', None)
        self.config = kwargs.get('config', None)
        self.files = kwargs.get('files', None)
        self.test_data = kwargs.get('test_data', None)


class FunctionEnvelopeCollection(msrest.serialization.Model):
    """Collection of Kudu function information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.FunctionEnvelope]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FunctionEnvelope]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionEnvelopeCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class FunctionSecrets(ProxyOnlyResource):
    """Function secrets.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key: Secret key.
    :type key: str
    :param trigger_url: Trigger URL.
    :type trigger_url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key': {'key': 'properties.key', 'type': 'str'},
        'trigger_url': {'key': 'properties.triggerUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionSecrets, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.trigger_url = kwargs.get('trigger_url', None)


class HandlerMapping(msrest.serialization.Model):
    """The IIS handler mappings used to define which handler processes HTTP requests with certain extension. 
For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php extension.

    :param extension: Requests with this extension will be handled using the specified FastCGI
     application.
    :type extension: str
    :param script_processor: The absolute path to the FastCGI application.
    :type script_processor: str
    :param arguments: Command-line arguments to be passed to the script processor.
    :type arguments: str
    """

    _attribute_map = {
        'extension': {'key': 'extension', 'type': 'str'},
        'script_processor': {'key': 'scriptProcessor', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HandlerMapping, self).__init__(**kwargs)
        self.extension = kwargs.get('extension', None)
        self.script_processor = kwargs.get('script_processor', None)
        self.arguments = kwargs.get('arguments', None)


class HostingEnvironmentProfile(msrest.serialization.Model):
    """Specification for an App Service Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID of the App Service Environment.
    :type id: str
    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar type: Resource type of the App Service Environment.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostingEnvironmentProfile, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.type = None


class HostNameBinding(ProxyOnlyResource):
    """A hostname binding object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param site_name: App Service app name.
    :type site_name: str
    :param domain_id: Fully qualified ARM domain resource URI.
    :type domain_id: str
    :param azure_resource_name: Azure resource name.
    :type azure_resource_name: str
    :param azure_resource_type: Azure resource type. Possible values include: "Website",
     "TrafficManager".
    :type azure_resource_type: str or ~azure.mgmt.web.v2016_08_01.models.AzureResourceType
    :param custom_host_name_dns_record_type: Custom DNS record type. Possible values include:
     "CName", "A".
    :type custom_host_name_dns_record_type: str or
     ~azure.mgmt.web.v2016_08_01.models.CustomHostNameDnsRecordType
    :param host_name_type: Hostname type. Possible values include: "Verified", "Managed".
    :type host_name_type: str or ~azure.mgmt.web.v2016_08_01.models.HostNameType
    :param ssl_state: SSL type. Possible values include: "Disabled", "SniEnabled",
     "IpBasedEnabled".
    :type ssl_state: str or ~azure.mgmt.web.v2016_08_01.models.SslState
    :param thumbprint: SSL certificate thumbprint.
    :type thumbprint: str
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_ip': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'domain_id': {'key': 'properties.domainId', 'type': 'str'},
        'azure_resource_name': {'key': 'properties.azureResourceName', 'type': 'str'},
        'azure_resource_type': {'key': 'properties.azureResourceType', 'type': 'str'},
        'custom_host_name_dns_record_type': {'key': 'properties.customHostNameDnsRecordType', 'type': 'str'},
        'host_name_type': {'key': 'properties.hostNameType', 'type': 'str'},
        'ssl_state': {'key': 'properties.sslState', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'virtual_ip': {'key': 'properties.virtualIP', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostNameBinding, self).__init__(**kwargs)
        self.site_name = kwargs.get('site_name', None)
        self.domain_id = kwargs.get('domain_id', None)
        self.azure_resource_name = kwargs.get('azure_resource_name', None)
        self.azure_resource_type = kwargs.get('azure_resource_type', None)
        self.custom_host_name_dns_record_type = kwargs.get('custom_host_name_dns_record_type', None)
        self.host_name_type = kwargs.get('host_name_type', None)
        self.ssl_state = kwargs.get('ssl_state', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.virtual_ip = None


class HostNameBindingCollection(msrest.serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.HostNameBinding]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HostNameBinding]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostNameBindingCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class HostNameSslState(msrest.serialization.Model):
    """SSL-enabled hostname.

    :param name: Hostname.
    :type name: str
    :param ssl_state: SSL type. Possible values include: "Disabled", "SniEnabled",
     "IpBasedEnabled".
    :type ssl_state: str or ~azure.mgmt.web.v2016_08_01.models.SslState
    :param virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :type virtual_ip: str
    :param thumbprint: SSL certificate thumbprint.
    :type thumbprint: str
    :param to_update: Set to :code:`<code>true</code>` to update existing hostname.
    :type to_update: bool
    :param host_type: Indicates whether the hostname is a standard or repository hostname. Possible
     values include: "Standard", "Repository".
    :type host_type: str or ~azure.mgmt.web.v2016_08_01.models.HostType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'ssl_state': {'key': 'sslState', 'type': 'str'},
        'virtual_ip': {'key': 'virtualIP', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'to_update': {'key': 'toUpdate', 'type': 'bool'},
        'host_type': {'key': 'hostType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostNameSslState, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.ssl_state = kwargs.get('ssl_state', None)
        self.virtual_ip = kwargs.get('virtual_ip', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.to_update = kwargs.get('to_update', None)
        self.host_type = kwargs.get('host_type', None)


class HttpLogsConfig(msrest.serialization.Model):
    """Http logs configuration.

    :param file_system: Http logs to file system configuration.
    :type file_system: ~azure.mgmt.web.v2016_08_01.models.FileSystemHttpLogsConfig
    :param azure_blob_storage: Http logs to azure blob storage configuration.
    :type azure_blob_storage: ~azure.mgmt.web.v2016_08_01.models.AzureBlobStorageHttpLogsConfig
    """

    _attribute_map = {
        'file_system': {'key': 'fileSystem', 'type': 'FileSystemHttpLogsConfig'},
        'azure_blob_storage': {'key': 'azureBlobStorage', 'type': 'AzureBlobStorageHttpLogsConfig'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpLogsConfig, self).__init__(**kwargs)
        self.file_system = kwargs.get('file_system', None)
        self.azure_blob_storage = kwargs.get('azure_blob_storage', None)


class HybridConnection(ProxyOnlyResource):
    """Hybrid Connection contract. This is used to configure a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param service_bus_namespace: The name of the Service Bus namespace.
    :type service_bus_namespace: str
    :param relay_name: The name of the Service Bus relay.
    :type relay_name: str
    :param relay_arm_uri: The ARM URI to the Service Bus relay.
    :type relay_arm_uri: str
    :param hostname: The hostname of the endpoint.
    :type hostname: str
    :param port: The port of the endpoint.
    :type port: int
    :param send_key_name: The name of the Service Bus key which has Send permissions. This is used
     to authenticate to Service Bus.
    :type send_key_name: str
    :param send_key_value: The value of the Service Bus key. This is used to authenticate to
     Service Bus. In ARM this key will not be returned
     normally, use the POST /listKeys API instead.
    :type send_key_value: str
    :param service_bus_suffix: The suffix for the service bus endpoint. By default this is
     .servicebus.windows.net.
    :type service_bus_suffix: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'relay_name': {'key': 'properties.relayName', 'type': 'str'},
        'relay_arm_uri': {'key': 'properties.relayArmUri', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
        'service_bus_suffix': {'key': 'properties.serviceBusSuffix', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridConnection, self).__init__(**kwargs)
        self.service_bus_namespace = kwargs.get('service_bus_namespace', None)
        self.relay_name = kwargs.get('relay_name', None)
        self.relay_arm_uri = kwargs.get('relay_arm_uri', None)
        self.hostname = kwargs.get('hostname', None)
        self.port = kwargs.get('port', None)
        self.send_key_name = kwargs.get('send_key_name', None)
        self.send_key_value = kwargs.get('send_key_value', None)
        self.service_bus_suffix = kwargs.get('service_bus_suffix', None)


class HybridConnectionKey(ProxyOnlyResource):
    """Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar send_key_name: The name of the send key.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the send key.
    :vartype send_key_value: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'send_key_name': {'readonly': True},
        'send_key_value': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridConnectionKey, self).__init__(**kwargs)
        self.send_key_name = None
        self.send_key_value = None


class Identifier(ProxyOnlyResource):
    """A domain specific resource identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param id_properties_id: String representation of the identity.
    :type id_properties_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Identifier, self).__init__(**kwargs)
        self.id_properties_id = kwargs.get('id_properties_id', None)


class IdentifierCollection(msrest.serialization.Model):
    """Collection of identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.Identifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Identifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IdentifierCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class IpSecurityRestriction(msrest.serialization.Model):
    """IP security restriction on an app.

    All required parameters must be populated in order to send to Azure.

    :param ip_address: Required. IP address the security restriction is valid for.
    :type ip_address: str
    :param subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
    :type subnet_mask: str
    """

    _validation = {
        'ip_address': {'required': True},
    }

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'subnet_mask': {'key': 'subnetMask', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IpSecurityRestriction, self).__init__(**kwargs)
        self.ip_address = kwargs['ip_address']
        self.subnet_mask = kwargs.get('subnet_mask', None)


class LocalizableString(msrest.serialization.Model):
    """Localizable string object containing the name and a localized value.

    :param value: Non-localized name.
    :type value: str
    :param localized_value: Localized name.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocalizableString, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class ManagedServiceIdentity(msrest.serialization.Model):
    """Managed service identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type: Type of managed service identity. Possible values include: "SystemAssigned".
    :type type: str or ~azure.mgmt.web.v2016_08_01.models.ManagedServiceIdentityType
    :ivar tenant_id: Tenant of managed service identity.
    :vartype tenant_id: str
    :ivar principal_id: Principal Id of managed service identity.
    :vartype principal_id: str
    """

    _validation = {
        'tenant_id': {'readonly': True},
        'principal_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.tenant_id = None
        self.principal_id = None


class MigrateMySqlRequest(ProxyOnlyResource):
    """MySQL migration request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param connection_string: Connection string to the remote MySQL database.
    :type connection_string: str
    :param migration_type: The type of migration operation to be done. Possible values include:
     "LocalToRemote", "RemoteToLocal".
    :type migration_type: str or ~azure.mgmt.web.v2016_08_01.models.MySqlMigrationType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'migration_type': {'key': 'properties.migrationType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateMySqlRequest, self).__init__(**kwargs)
        self.connection_string = kwargs.get('connection_string', None)
        self.migration_type = kwargs.get('migration_type', None)


class MigrateMySqlStatus(ProxyOnlyResource):
    """MySQL migration status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar migration_operation_status: Status of the migration task. Possible values include:
     "InProgress", "Failed", "Succeeded", "TimedOut", "Created".
    :vartype migration_operation_status: str or ~azure.mgmt.web.v2016_08_01.models.OperationStatus
    :ivar operation_id: Operation ID for the migration task.
    :vartype operation_id: str
    :ivar local_my_sql_enabled: True if the web app has in app MySql enabled.
    :vartype local_my_sql_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'migration_operation_status': {'readonly': True},
        'operation_id': {'readonly': True},
        'local_my_sql_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'migration_operation_status': {'key': 'properties.migrationOperationStatus', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'properties.localMySqlEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateMySqlStatus, self).__init__(**kwargs)
        self.migration_operation_status = None
        self.operation_id = None
        self.local_my_sql_enabled = None


class MSDeploy(ProxyOnlyResource):
    """MSDeploy ARM PUT information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param package_uri: Package URI.
    :type package_uri: str
    :param connection_string: SQL Connection String.
    :type connection_string: str
    :param db_type: Database Type.
    :type db_type: str
    :param set_parameters_xml_file_uri: URI of MSDeploy Parameters file. Must not be set if
     SetParameters is used.
    :type set_parameters_xml_file_uri: str
    :param set_parameters: MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is used.
    :type set_parameters: dict[str, str]
    :param skip_app_data: Controls whether the MSDeploy operation skips the App_Data directory.
     If set to :code:`<code>true</code>`, the existing App_Data directory on the destination
     will not be deleted, and any App_Data directory in the source will be ignored.
     Setting is :code:`<code>false</code>` by default.
    :type skip_app_data: bool
    :param app_offline: Sets the AppOffline rule while the MSDeploy operation executes.
     Setting is :code:`<code>false</code>` by default.
    :type app_offline: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'package_uri': {'key': 'properties.packageUri', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'db_type': {'key': 'properties.dbType', 'type': 'str'},
        'set_parameters_xml_file_uri': {'key': 'properties.setParametersXmlFileUri', 'type': 'str'},
        'set_parameters': {'key': 'properties.setParameters', 'type': '{str}'},
        'skip_app_data': {'key': 'properties.skipAppData', 'type': 'bool'},
        'app_offline': {'key': 'properties.appOffline', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MSDeploy, self).__init__(**kwargs)
        self.package_uri = kwargs.get('package_uri', None)
        self.connection_string = kwargs.get('connection_string', None)
        self.db_type = kwargs.get('db_type', None)
        self.set_parameters_xml_file_uri = kwargs.get('set_parameters_xml_file_uri', None)
        self.set_parameters = kwargs.get('set_parameters', None)
        self.skip_app_data = kwargs.get('skip_app_data', None)
        self.app_offline = kwargs.get('app_offline', None)


class MSDeployLog(ProxyOnlyResource):
    """MSDeploy log.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar entries: List of log entry messages.
    :vartype entries: list[~azure.mgmt.web.v2016_08_01.models.MSDeployLogEntry]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'entries': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'entries': {'key': 'properties.entries', 'type': '[MSDeployLogEntry]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MSDeployLog, self).__init__(**kwargs)
        self.entries = None


class MSDeployLogEntry(msrest.serialization.Model):
    """MSDeploy log entry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time: Timestamp of log entry.
    :vartype time: ~datetime.datetime
    :ivar type: Log entry type. Possible values include: "Message", "Warning", "Error".
    :vartype type: str or ~azure.mgmt.web.v2016_08_01.models.MSDeployLogEntryType
    :ivar message: Log entry message.
    :vartype message: str
    """

    _validation = {
        'time': {'readonly': True},
        'type': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'time': {'key': 'time', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MSDeployLogEntry, self).__init__(**kwargs)
        self.time = None
        self.type = None
        self.message = None


class MSDeployStatus(ProxyOnlyResource):
    """MSDeploy ARM response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deployer: Username of deployer.
    :vartype deployer: str
    :ivar provisioning_state: Provisioning state. Possible values include: "accepted", "running",
     "succeeded", "failed", "canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2016_08_01.models.MSDeployProvisioningState
    :ivar start_time: Start time of deploy operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of deploy operation.
    :vartype end_time: ~datetime.datetime
    :ivar complete: Whether the deployment operation has completed.
    :vartype complete: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'deployer': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'complete': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deployer': {'key': 'properties.deployer', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'complete': {'key': 'properties.complete', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MSDeployStatus, self).__init__(**kwargs)
        self.deployer = None
        self.provisioning_state = None
        self.start_time = None
        self.end_time = None
        self.complete = None


class NameValuePair(msrest.serialization.Model):
    """Name value pair.

    :param name: Pair name.
    :type name: str
    :param value: Pair value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameValuePair, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class NetworkFeatures(ProxyOnlyResource):
    """Full view of network features for an app (presently VNET integration and Hybrid Connections).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar virtual_network_name: The Virtual Network name.
    :vartype virtual_network_name: str
    :ivar virtual_network_connection: The Virtual Network summary view.
    :vartype virtual_network_connection: ~azure.mgmt.web.v2016_08_01.models.VnetInfo
    :ivar hybrid_connections: The Hybrid Connections summary view.
    :vartype hybrid_connections:
     list[~azure.mgmt.web.v2016_08_01.models.RelayServiceConnectionEntity]
    :ivar hybrid_connections_v2: The Hybrid Connection V2 (Service Bus) view.
    :vartype hybrid_connections_v2: list[~azure.mgmt.web.v2016_08_01.models.HybridConnection]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_network_name': {'readonly': True},
        'virtual_network_connection': {'readonly': True},
        'hybrid_connections': {'readonly': True},
        'hybrid_connections_v2': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'virtual_network_name': {'key': 'properties.virtualNetworkName', 'type': 'str'},
        'virtual_network_connection': {'key': 'properties.virtualNetworkConnection', 'type': 'VnetInfo'},
        'hybrid_connections': {'key': 'properties.hybridConnections', 'type': '[RelayServiceConnectionEntity]'},
        'hybrid_connections_v2': {'key': 'properties.hybridConnectionsV2', 'type': '[HybridConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkFeatures, self).__init__(**kwargs)
        self.virtual_network_name = None
        self.virtual_network_connection = None
        self.hybrid_connections = None
        self.hybrid_connections_v2 = None


class Operation(msrest.serialization.Model):
    """An operation on a resource.

    :param id: Operation ID.
    :type id: str
    :param name: Operation name.
    :type name: str
    :param status: The current status of the operation. Possible values include: "InProgress",
     "Failed", "Succeeded", "TimedOut", "Created".
    :type status: str or ~azure.mgmt.web.v2016_08_01.models.OperationStatus
    :param errors: Any errors associate with the operation.
    :type errors: list[~azure.mgmt.web.v2016_08_01.models.ErrorEntity]
    :param created_time: Time when operation has started.
    :type created_time: ~datetime.datetime
    :param modified_time: Time when operation has been updated.
    :type modified_time: ~datetime.datetime
    :param expiration_time: Time when operation will expire.
    :type expiration_time: ~datetime.datetime
    :param geo_master_operation_id: Applicable only for stamp operation ids.
    :type geo_master_operation_id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ErrorEntity]'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'expirationTime', 'type': 'iso-8601'},
        'geo_master_operation_id': {'key': 'geoMasterOperationId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.status = kwargs.get('status', None)
        self.errors = kwargs.get('errors', None)
        self.created_time = kwargs.get('created_time', None)
        self.modified_time = kwargs.get('modified_time', None)
        self.expiration_time = kwargs.get('expiration_time', None)
        self.geo_master_operation_id = kwargs.get('geo_master_operation_id', None)


class PerfMonCounterCollection(msrest.serialization.Model):
    """Collection of performance monitor counters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.PerfMonResponse]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PerfMonResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PerfMonCounterCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class PerfMonResponse(msrest.serialization.Model):
    """Performance monitor API response.

    :param code: The response code.
    :type code: str
    :param message: The message.
    :type message: str
    :param data: The performance monitor counters.
    :type data: ~azure.mgmt.web.v2016_08_01.models.PerfMonSet
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'data': {'key': 'data', 'type': 'PerfMonSet'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PerfMonResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.data = kwargs.get('data', None)


class PerfMonSample(msrest.serialization.Model):
    """Performance monitor sample in a set.

    :param time: Point in time for which counter was measured.
    :type time: ~datetime.datetime
    :param instance_name: Name of the server on which the measurement is made.
    :type instance_name: str
    :param value: Value of counter at a certain time.
    :type value: float
    :param core_count: Core Count of worker. Not a data member.
    :type core_count: int
    """

    _attribute_map = {
        'time': {'key': 'time', 'type': 'iso-8601'},
        'instance_name': {'key': 'instanceName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
        'core_count': {'key': 'coreCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PerfMonSample, self).__init__(**kwargs)
        self.time = kwargs.get('time', None)
        self.instance_name = kwargs.get('instance_name', None)
        self.value = kwargs.get('value', None)
        self.core_count = kwargs.get('core_count', None)


class PerfMonSet(msrest.serialization.Model):
    """Metric information.

    :param name: Unique key name of the counter.
    :type name: str
    :param start_time: Start time of the period.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the period.
    :type end_time: ~datetime.datetime
    :param time_grain: Presented time grain.
    :type time_grain: str
    :param values: Collection of workers that are active during this time.
    :type values: list[~azure.mgmt.web.v2016_08_01.models.PerfMonSample]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'values': {'key': 'values', 'type': '[PerfMonSample]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PerfMonSet, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.time_grain = kwargs.get('time_grain', None)
        self.values = kwargs.get('values', None)


class Resource(msrest.serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kwargs.get('kind', None)
        self.location = kwargs['location']
        self.type = None
        self.tags = kwargs.get('tags', None)


class PremierAddOn(Resource):
    """Premier add-on.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Premier add on SKU.
    :type sku: str
    :param product: Premier add on Product.
    :type product: str
    :param vendor: Premier add on Vendor.
    :type vendor: str
    :param premier_add_on_name: Premier add on Name.
    :type premier_add_on_name: str
    :param location_properties_location: Premier add on Location.
    :type location_properties_location: str
    :param tags_properties_tags: Premier add on Tags.
    :type tags_properties_tags: dict[str, str]
    :param marketplace_publisher: Premier add on Marketplace publisher.
    :type marketplace_publisher: str
    :param marketplace_offer: Premier add on Marketplace offer.
    :type marketplace_offer: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'vendor': {'key': 'properties.vendor', 'type': 'str'},
        'premier_add_on_name': {'key': 'properties.name', 'type': 'str'},
        'location_properties_location': {'key': 'properties.location', 'type': 'str'},
        'tags_properties_tags': {'key': 'properties.tags', 'type': '{str}'},
        'marketplace_publisher': {'key': 'properties.marketplacePublisher', 'type': 'str'},
        'marketplace_offer': {'key': 'properties.marketplaceOffer', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PremierAddOn, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.product = kwargs.get('product', None)
        self.vendor = kwargs.get('vendor', None)
        self.premier_add_on_name = kwargs.get('premier_add_on_name', None)
        self.location_properties_location = kwargs.get('location_properties_location', None)
        self.tags_properties_tags = kwargs.get('tags_properties_tags', None)
        self.marketplace_publisher = kwargs.get('marketplace_publisher', None)
        self.marketplace_offer = kwargs.get('marketplace_offer', None)


class ProcessInfo(ProxyOnlyResource):
    """Process Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param id_properties_id: ARM Identifier for deployment.
    :type id_properties_id: int
    :param name_properties_name: Deployment name.
    :type name_properties_name: str
    :param href: HRef URI.
    :type href: str
    :param mini_dump: Minidump URI.
    :type mini_dump: str
    :param is_profile_running: Is profile running?.
    :type is_profile_running: bool
    :param is_iis_profile_running: Is the IIS Profile running?.
    :type is_iis_profile_running: bool
    :param iis_profile_timeout_in_seconds: IIS Profile timeout (seconds).
    :type iis_profile_timeout_in_seconds: float
    :param parent: Parent process.
    :type parent: str
    :param children: Child process list.
    :type children: list[str]
    :param threads: Thread list.
    :type threads: list[~azure.mgmt.web.v2016_08_01.models.ProcessThreadInfo]
    :param open_file_handles: List of open files.
    :type open_file_handles: list[str]
    :param modules: List of modules.
    :type modules: list[~azure.mgmt.web.v2016_08_01.models.ProcessModuleInfo]
    :param file_name: File name of this process.
    :type file_name: str
    :param command_line: Command line.
    :type command_line: str
    :param user_name: User name.
    :type user_name: str
    :param handle_count: Handle count.
    :type handle_count: int
    :param module_count: Module count.
    :type module_count: int
    :param thread_count: Thread count.
    :type thread_count: int
    :param start_time: Start time.
    :type start_time: ~datetime.datetime
    :param total_processor_time: Total CPU time.
    :type total_processor_time: str
    :param user_processor_time: User CPU time.
    :type user_processor_time: str
    :param privileged_processor_time: Privileged CPU time.
    :type privileged_processor_time: str
    :param working_set64: Working set.
    :type working_set64: long
    :param peak_working_set64: Peak working set.
    :type peak_working_set64: long
    :param private_memory_size64: Private memory size.
    :type private_memory_size64: long
    :param virtual_memory_size64: Virtual memory size.
    :type virtual_memory_size64: long
    :param peak_virtual_memory_size64: Peak virtual memory usage.
    :type peak_virtual_memory_size64: long
    :param paged_system_memory_size64: Paged system memory.
    :type paged_system_memory_size64: long
    :param nonpaged_system_memory_size64: Non-paged system memory.
    :type nonpaged_system_memory_size64: long
    :param paged_memory_size64: Paged memory.
    :type paged_memory_size64: long
    :param peak_paged_memory_size64: Peak paged memory.
    :type peak_paged_memory_size64: long
    :param time_stamp: Time stamp.
    :type time_stamp: ~datetime.datetime
    :param environment_variables: List of environment variables.
    :type environment_variables: dict[str, str]
    :param is_scm_site: Is this the SCM site?.
    :type is_scm_site: bool
    :param is_web_job: Is this a Web Job?.
    :type is_web_job: bool
    :param description: Description of process.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'int'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'mini_dump': {'key': 'properties.miniDump', 'type': 'str'},
        'is_profile_running': {'key': 'properties.isProfileRunning', 'type': 'bool'},
        'is_iis_profile_running': {'key': 'properties.isIisProfileRunning', 'type': 'bool'},
        'iis_profile_timeout_in_seconds': {'key': 'properties.iisProfileTimeoutInSeconds', 'type': 'float'},
        'parent': {'key': 'properties.parent', 'type': 'str'},
        'children': {'key': 'properties.children', 'type': '[str]'},
        'threads': {'key': 'properties.threads', 'type': '[ProcessThreadInfo]'},
        'open_file_handles': {'key': 'properties.openFileHandles', 'type': '[str]'},
        'modules': {'key': 'properties.modules', 'type': '[ProcessModuleInfo]'},
        'file_name': {'key': 'properties.fileName', 'type': 'str'},
        'command_line': {'key': 'properties.commandLine', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'handle_count': {'key': 'properties.handleCount', 'type': 'int'},
        'module_count': {'key': 'properties.moduleCount', 'type': 'int'},
        'thread_count': {'key': 'properties.threadCount', 'type': 'int'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'total_processor_time': {'key': 'properties.totalProcessorTime', 'type': 'str'},
        'user_processor_time': {'key': 'properties.userProcessorTime', 'type': 'str'},
        'privileged_processor_time': {'key': 'properties.privilegedProcessorTime', 'type': 'str'},
        'working_set64': {'key': 'properties.workingSet64', 'type': 'long'},
        'peak_working_set64': {'key': 'properties.peakWorkingSet64', 'type': 'long'},
        'private_memory_size64': {'key': 'properties.privateMemorySize64', 'type': 'long'},
        'virtual_memory_size64': {'key': 'properties.virtualMemorySize64', 'type': 'long'},
        'peak_virtual_memory_size64': {'key': 'properties.peakVirtualMemorySize64', 'type': 'long'},
        'paged_system_memory_size64': {'key': 'properties.pagedSystemMemorySize64', 'type': 'long'},
        'nonpaged_system_memory_size64': {'key': 'properties.nonpagedSystemMemorySize64', 'type': 'long'},
        'paged_memory_size64': {'key': 'properties.pagedMemorySize64', 'type': 'long'},
        'peak_paged_memory_size64': {'key': 'properties.peakPagedMemorySize64', 'type': 'long'},
        'time_stamp': {'key': 'properties.timeStamp', 'type': 'iso-8601'},
        'environment_variables': {'key': 'properties.environmentVariables', 'type': '{str}'},
        'is_scm_site': {'key': 'properties.isScmSite', 'type': 'bool'},
        'is_web_job': {'key': 'properties.isWebJob', 'type': 'bool'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProcessInfo, self).__init__(**kwargs)
        self.id_properties_id = kwargs.get('id_properties_id', None)
        self.name_properties_name = kwargs.get('name_properties_name', None)
        self.href = kwargs.get('href', None)
        self.mini_dump = kwargs.get('mini_dump', None)
        self.is_profile_running = kwargs.get('is_profile_running', None)
        self.is_iis_profile_running = kwargs.get('is_iis_profile_running', None)
        self.iis_profile_timeout_in_seconds = kwargs.get('iis_profile_timeout_in_seconds', None)
        self.parent = kwargs.get('parent', None)
        self.children = kwargs.get('children', None)
        self.threads = kwargs.get('threads', None)
        self.open_file_handles = kwargs.get('open_file_handles', None)
        self.modules = kwargs.get('modules', None)
        self.file_name = kwargs.get('file_name', None)
        self.command_line = kwargs.get('command_line', None)
        self.user_name = kwargs.get('user_name', None)
        self.handle_count = kwargs.get('handle_count', None)
        self.module_count = kwargs.get('module_count', None)
        self.thread_count = kwargs.get('thread_count', None)
        self.start_time = kwargs.get('start_time', None)
        self.total_processor_time = kwargs.get('total_processor_time', None)
        self.user_processor_time = kwargs.get('user_processor_time', None)
        self.privileged_processor_time = kwargs.get('privileged_processor_time', None)
        self.working_set64 = kwargs.get('working_set64', None)
        self.peak_working_set64 = kwargs.get('peak_working_set64', None)
        self.private_memory_size64 = kwargs.get('private_memory_size64', None)
        self.virtual_memory_size64 = kwargs.get('virtual_memory_size64', None)
        self.peak_virtual_memory_size64 = kwargs.get('peak_virtual_memory_size64', None)
        self.paged_system_memory_size64 = kwargs.get('paged_system_memory_size64', None)
        self.nonpaged_system_memory_size64 = kwargs.get('nonpaged_system_memory_size64', None)
        self.paged_memory_size64 = kwargs.get('paged_memory_size64', None)
        self.peak_paged_memory_size64 = kwargs.get('peak_paged_memory_size64', None)
        self.time_stamp = kwargs.get('time_stamp', None)
        self.environment_variables = kwargs.get('environment_variables', None)
        self.is_scm_site = kwargs.get('is_scm_site', None)
        self.is_web_job = kwargs.get('is_web_job', None)
        self.description = kwargs.get('description', None)


class ProcessInfoCollection(msrest.serialization.Model):
    """Collection of Kudu process information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.ProcessInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProcessInfoCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ProcessModuleInfo(ProxyOnlyResource):
    """Process Module Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param base_address: Base address. Used as module identifier in ARM resource URI.
    :type base_address: str
    :param file_name: File name.
    :type file_name: str
    :param href: HRef URI.
    :type href: str
    :param file_path: File path.
    :type file_path: str
    :param module_memory_size: Module memory size.
    :type module_memory_size: int
    :param file_version: File version.
    :type file_version: str
    :param file_description: File description.
    :type file_description: str
    :param product: Product name.
    :type product: str
    :param product_version: Product version.
    :type product_version: str
    :param is_debug: Is debug?.
    :type is_debug: bool
    :param language: Module language (locale).
    :type language: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'base_address': {'key': 'properties.baseAddress', 'type': 'str'},
        'file_name': {'key': 'properties.fileName', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'file_path': {'key': 'properties.filePath', 'type': 'str'},
        'module_memory_size': {'key': 'properties.moduleMemorySize', 'type': 'int'},
        'file_version': {'key': 'properties.fileVersion', 'type': 'str'},
        'file_description': {'key': 'properties.fileDescription', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'product_version': {'key': 'properties.productVersion', 'type': 'str'},
        'is_debug': {'key': 'properties.isDebug', 'type': 'bool'},
        'language': {'key': 'properties.language', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProcessModuleInfo, self).__init__(**kwargs)
        self.base_address = kwargs.get('base_address', None)
        self.file_name = kwargs.get('file_name', None)
        self.href = kwargs.get('href', None)
        self.file_path = kwargs.get('file_path', None)
        self.module_memory_size = kwargs.get('module_memory_size', None)
        self.file_version = kwargs.get('file_version', None)
        self.file_description = kwargs.get('file_description', None)
        self.product = kwargs.get('product', None)
        self.product_version = kwargs.get('product_version', None)
        self.is_debug = kwargs.get('is_debug', None)
        self.language = kwargs.get('language', None)


class ProcessModuleInfoCollection(msrest.serialization.Model):
    """Collection of Kudu thread information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.ProcessModuleInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessModuleInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProcessModuleInfoCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ProcessThreadInfo(ProxyOnlyResource):
    """Process Thread Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param id_properties_id: ARM Identifier for deployment.
    :type id_properties_id: int
    :param href: HRef URI.
    :type href: str
    :param process: Process URI.
    :type process: str
    :param start_address: Start address.
    :type start_address: str
    :param current_priority: Current thread priority.
    :type current_priority: int
    :param priority_level: Thread priority level.
    :type priority_level: str
    :param base_priority: Base priority.
    :type base_priority: int
    :param start_time: Start time.
    :type start_time: ~datetime.datetime
    :param total_processor_time: Total processor time.
    :type total_processor_time: str
    :param user_processor_time: User processor time.
    :type user_processor_time: str
    :param priviledged_processor_time: Privileged processor time.
    :type priviledged_processor_time: str
    :param state: Thread state.
    :type state: str
    :param wait_reason: Wait reason.
    :type wait_reason: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'int'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'process': {'key': 'properties.process', 'type': 'str'},
        'start_address': {'key': 'properties.startAddress', 'type': 'str'},
        'current_priority': {'key': 'properties.currentPriority', 'type': 'int'},
        'priority_level': {'key': 'properties.priorityLevel', 'type': 'str'},
        'base_priority': {'key': 'properties.basePriority', 'type': 'int'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'total_processor_time': {'key': 'properties.totalProcessorTime', 'type': 'str'},
        'user_processor_time': {'key': 'properties.userProcessorTime', 'type': 'str'},
        'priviledged_processor_time': {'key': 'properties.priviledgedProcessorTime', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'wait_reason': {'key': 'properties.waitReason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProcessThreadInfo, self).__init__(**kwargs)
        self.id_properties_id = kwargs.get('id_properties_id', None)
        self.href = kwargs.get('href', None)
        self.process = kwargs.get('process', None)
        self.start_address = kwargs.get('start_address', None)
        self.current_priority = kwargs.get('current_priority', None)
        self.priority_level = kwargs.get('priority_level', None)
        self.base_priority = kwargs.get('base_priority', None)
        self.start_time = kwargs.get('start_time', None)
        self.total_processor_time = kwargs.get('total_processor_time', None)
        self.user_processor_time = kwargs.get('user_processor_time', None)
        self.priviledged_processor_time = kwargs.get('priviledged_processor_time', None)
        self.state = kwargs.get('state', None)
        self.wait_reason = kwargs.get('wait_reason', None)


class ProcessThreadInfoCollection(msrest.serialization.Model):
    """Collection of Kudu thread information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.ProcessThreadInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessThreadInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProcessThreadInfoCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class PublicCertificate(ProxyOnlyResource):
    """Public certificate object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param blob: Public Certificate byte array.
    :type blob: bytearray
    :param public_certificate_location: Public Certificate Location. Possible values include:
     "CurrentUserMy", "LocalMachineMy", "Unknown".
    :type public_certificate_location: str or
     ~azure.mgmt.web.v2016_08_01.models.PublicCertificateLocation
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'thumbprint': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'blob': {'key': 'properties.blob', 'type': 'bytearray'},
        'public_certificate_location': {'key': 'properties.publicCertificateLocation', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublicCertificate, self).__init__(**kwargs)
        self.blob = kwargs.get('blob', None)
        self.public_certificate_location = kwargs.get('public_certificate_location', None)
        self.thumbprint = None


class PublicCertificateCollection(msrest.serialization.Model):
    """Collection of public certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.PublicCertificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PublicCertificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublicCertificateCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class PushSettings(ProxyOnlyResource):
    """Push settings for the App.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
    :type is_push_enabled: bool
    :param tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are
     whitelisted for use by the push registration endpoint.
    :type tag_whitelist_json: str
    :param tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
     user authentication to be used in the push registration endpoint.
     Tags can consist of alphanumeric characters and the following:
     '_', '@', '#', '.', ':', '-'.
     Validation should be performed at the PushRequestHandler.
    :type tags_requiring_auth: str
    :param dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that
     will be evaluated from user claims in the push registration endpoint.
    :type dynamic_tags_json: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_push_enabled': {'key': 'properties.isPushEnabled', 'type': 'bool'},
        'tag_whitelist_json': {'key': 'properties.tagWhitelistJson', 'type': 'str'},
        'tags_requiring_auth': {'key': 'properties.tagsRequiringAuth', 'type': 'str'},
        'dynamic_tags_json': {'key': 'properties.dynamicTagsJson', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PushSettings, self).__init__(**kwargs)
        self.is_push_enabled = kwargs.get('is_push_enabled', None)
        self.tag_whitelist_json = kwargs.get('tag_whitelist_json', None)
        self.tags_requiring_auth = kwargs.get('tags_requiring_auth', None)
        self.dynamic_tags_json = kwargs.get('dynamic_tags_json', None)


class RampUpRule(msrest.serialization.Model):
    """Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually change routing % based on performance.

    :param action_host_name: Hostname of a slot to which the traffic will be redirected if decided
     to. E.g. myapp-stage.azurewebsites.net.
    :type action_host_name: str
    :param reroute_percentage: Percentage of the traffic which will be redirected to
     :code:`<code>ActionHostName</code>`.
    :type reroute_percentage: float
    :param change_step: In auto ramp up scenario this is the step to add/remove from
     :code:`<code>ReroutePercentage</code>` until it reaches
     :code:`<code>MinReroutePercentage</code>` or :code:`<code>MaxReroutePercentage</code>`. Site
     metrics are checked every N minutes specified in :code:`<code>ChangeIntervalInMinutes</code>`.
     Custom decision algorithm can be provided in TiPCallback site extension which URL can be
     specified in :code:`<code>ChangeDecisionCallbackUrl</code>`.
    :type change_step: float
    :param change_interval_in_minutes: Specifies interval in minutes to reevaluate
     ReroutePercentage.
    :type change_interval_in_minutes: int
    :param min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will
     stay.
    :type min_reroute_percentage: float
    :param max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will
     stay.
    :type max_reroute_percentage: float
    :param change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
     site extension which URL can be specified. See TiPCallback site extension for the scaffold and
     contracts.
     https://www.siteextensions.net/packages/TiPCallback/.
    :type change_decision_callback_url: str
    :param name: Name of the routing rule. The recommended name would be to point to the slot which
     will receive the traffic in the experiment.
    :type name: str
    """

    _attribute_map = {
        'action_host_name': {'key': 'actionHostName', 'type': 'str'},
        'reroute_percentage': {'key': 'reroutePercentage', 'type': 'float'},
        'change_step': {'key': 'changeStep', 'type': 'float'},
        'change_interval_in_minutes': {'key': 'changeIntervalInMinutes', 'type': 'int'},
        'min_reroute_percentage': {'key': 'minReroutePercentage', 'type': 'float'},
        'max_reroute_percentage': {'key': 'maxReroutePercentage', 'type': 'float'},
        'change_decision_callback_url': {'key': 'changeDecisionCallbackUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RampUpRule, self).__init__(**kwargs)
        self.action_host_name = kwargs.get('action_host_name', None)
        self.reroute_percentage = kwargs.get('reroute_percentage', None)
        self.change_step = kwargs.get('change_step', None)
        self.change_interval_in_minutes = kwargs.get('change_interval_in_minutes', None)
        self.min_reroute_percentage = kwargs.get('min_reroute_percentage', None)
        self.max_reroute_percentage = kwargs.get('max_reroute_percentage', None)
        self.change_decision_callback_url = kwargs.get('change_decision_callback_url', None)
        self.name = kwargs.get('name', None)


class RelayServiceConnectionEntity(ProxyOnlyResource):
    """Hybrid Connection for an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param entity_name:
    :type entity_name: str
    :param entity_connection_string:
    :type entity_connection_string: str
    :param resource_type:
    :type resource_type: str
    :param resource_connection_string:
    :type resource_connection_string: str
    :param hostname:
    :type hostname: str
    :param port:
    :type port: int
    :param biztalk_uri:
    :type biztalk_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'entity_name': {'key': 'properties.entityName', 'type': 'str'},
        'entity_connection_string': {'key': 'properties.entityConnectionString', 'type': 'str'},
        'resource_type': {'key': 'properties.resourceType', 'type': 'str'},
        'resource_connection_string': {'key': 'properties.resourceConnectionString', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'biztalk_uri': {'key': 'properties.biztalkUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RelayServiceConnectionEntity, self).__init__(**kwargs)
        self.entity_name = kwargs.get('entity_name', None)
        self.entity_connection_string = kwargs.get('entity_connection_string', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.resource_connection_string = kwargs.get('resource_connection_string', None)
        self.hostname = kwargs.get('hostname', None)
        self.port = kwargs.get('port', None)
        self.biztalk_uri = kwargs.get('biztalk_uri', None)


class RequestsBasedTrigger(msrest.serialization.Model):
    """Trigger based on total requests.

    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RequestsBasedTrigger, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.time_interval = kwargs.get('time_interval', None)


class ResourceMetric(msrest.serialization.Model):
    """Object representing a metric for any resource .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of metric.
    :vartype name: ~azure.mgmt.web.v2016_08_01.models.ResourceMetricName
    :ivar unit: Metric unit.
    :vartype unit: str
    :ivar time_grain: Metric granularity. E.g PT1H, PT5M, P1D.
    :vartype time_grain: str
    :ivar start_time: Metric start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Metric end time.
    :vartype end_time: ~datetime.datetime
    :ivar resource_id: Metric resource Id.
    :vartype resource_id: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar metric_values: Metric values.
    :vartype metric_values: list[~azure.mgmt.web.v2016_08_01.models.ResourceMetricValue]
    :ivar properties: Resource metric properties collection.
    :vartype properties: list[~azure.mgmt.web.v2016_08_01.models.ResourceMetricProperty]
    """

    _validation = {
        'name': {'readonly': True},
        'unit': {'readonly': True},
        'time_grain': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'resource_id': {'readonly': True},
        'id': {'readonly': True},
        'metric_values': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'ResourceMetricName'},
        'unit': {'key': 'unit', 'type': 'str'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'metric_values': {'key': 'metricValues', 'type': '[ResourceMetricValue]'},
        'properties': {'key': 'properties', 'type': '[ResourceMetricProperty]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetric, self).__init__(**kwargs)
        self.name = None
        self.unit = None
        self.time_grain = None
        self.start_time = None
        self.end_time = None
        self.resource_id = None
        self.id = None
        self.metric_values = None
        self.properties = None


class ResourceMetricAvailability(msrest.serialization.Model):
    """Metrics availability and retention.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time_grain: Time grain .
    :vartype time_grain: str
    :ivar retention: Retention period for the current time grain.
    :vartype retention: str
    """

    _validation = {
        'time_grain': {'readonly': True},
        'retention': {'readonly': True},
    }

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'retention': {'key': 'retention', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricAvailability, self).__init__(**kwargs)
        self.time_grain = None
        self.retention = None


class ResourceMetricCollection(msrest.serialization.Model):
    """Collection of metric responses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.ResourceMetric]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceMetric]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ResourceMetricDefinition(ProxyOnlyResource):
    """Metadata for the metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name of the metric.
    :vartype name_properties_name: ~azure.mgmt.web.v2016_08_01.models.ResourceMetricName
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric together with
     retention period.
    :vartype metric_availabilities:
     list[~azure.mgmt.web.v2016_08_01.models.ResourceMetricAvailability]
    :ivar resource_uri: Resource URI.
    :vartype resource_uri: str
    :ivar id_properties_id: Resource ID.
    :vartype id_properties_id: str
    :ivar properties: Resource metric definition properties.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'unit': {'readonly': True},
        'primary_aggregation_type': {'readonly': True},
        'metric_availabilities': {'readonly': True},
        'resource_uri': {'readonly': True},
        'id_properties_id': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'ResourceMetricName'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
        'primary_aggregation_type': {'key': 'properties.primaryAggregationType', 'type': 'str'},
        'metric_availabilities': {'key': 'properties.metricAvailabilities', 'type': '[ResourceMetricAvailability]'},
        'resource_uri': {'key': 'properties.resourceUri', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'properties': {'key': 'properties.properties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricDefinition, self).__init__(**kwargs)
        self.name_properties_name = None
        self.unit = None
        self.primary_aggregation_type = None
        self.metric_availabilities = None
        self.resource_uri = None
        self.id_properties_id = None
        self.properties = None


class ResourceMetricDefinitionCollection(msrest.serialization.Model):
    """Collection of metric definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.ResourceMetricDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceMetricDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricDefinitionCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ResourceMetricName(msrest.serialization.Model):
    """Name of a metric for any resource .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: metric name value.
    :vartype value: str
    :ivar localized_value: Localized metric name value.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class ResourceMetricProperty(msrest.serialization.Model):
    """Resource metric property.

    :param key: Key for resource metric property.
    :type key: str
    :param value: Value of pair.
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricProperty, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class ResourceMetricValue(msrest.serialization.Model):
    """Value of resource metric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: Value timestamp.
    :vartype timestamp: str
    :ivar average: Value average.
    :vartype average: float
    :ivar minimum: Value minimum.
    :vartype minimum: float
    :ivar maximum: Value maximum.
    :vartype maximum: float
    :ivar total: Value total.
    :vartype total: float
    :ivar count: Value count.
    :vartype count: float
    :ivar properties: Resource metric properties collection.
    :vartype properties: list[~azure.mgmt.web.v2016_08_01.models.ResourceMetricProperty]
    """

    _validation = {
        'timestamp': {'readonly': True},
        'average': {'readonly': True},
        'minimum': {'readonly': True},
        'maximum': {'readonly': True},
        'total': {'readonly': True},
        'count': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'str'},
        'average': {'key': 'average', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'total': {'key': 'total', 'type': 'float'},
        'count': {'key': 'count', 'type': 'float'},
        'properties': {'key': 'properties', 'type': '[ResourceMetricProperty]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricValue, self).__init__(**kwargs)
        self.timestamp = None
        self.average = None
        self.minimum = None
        self.maximum = None
        self.total = None
        self.count = None
        self.properties = None


class RestoreRequest(ProxyOnlyResource):
    """Description of a restore request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param storage_account_url: SAS URL to the container.
    :type storage_account_url: str
    :param blob_name: Name of a blob which contains the backup.
    :type blob_name: str
    :param overwrite: :code:`<code>true</code>` if the restore operation can overwrite target app;
     otherwise, :code:`<code>false</code>`. :code:`<code>true</code>` is needed if trying to restore
     over an existing app.
    :type overwrite: bool
    :param site_name: Name of an app.
    :type site_name: str
    :param databases: Collection of databases which should be restored. This list has to match the
     list of databases included in the backup.
    :type databases: list[~azure.mgmt.web.v2016_08_01.models.DatabaseBackupSetting]
    :param ignore_conflicting_host_names: Changes a logic when restoring an app with custom
     domains. :code:`<code>true</code>` to remove custom domains automatically. If
     :code:`<code>false</code>`, custom domains are added to
     the app's object when it is being restored, but that might fail due to conflicts during the
     operation.
    :type ignore_conflicting_host_names: bool
    :param ignore_databases: Ignore the databases and only restore the site content.
    :type ignore_databases: bool
    :param app_service_plan: Specify app service plan that will own restored site.
    :type app_service_plan: str
    :param operation_type: Operation type. Possible values include: "Default", "Clone",
     "Relocation", "Snapshot".
    :type operation_type: str or ~azure.mgmt.web.v2016_08_01.models.BackupRestoreOperationType
    :param adjust_connection_strings: :code:`<code>true</code>` if SiteConfig.ConnectionStrings
     should be set in new app; otherwise, :code:`<code>false</code>`.
    :type adjust_connection_strings: bool
    :param hosting_environment: App Service Environment name, if needed (only when restoring an app
     to an App Service Environment).
    :type hosting_environment: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'blob_name': {'key': 'properties.blobName', 'type': 'str'},
        'overwrite': {'key': 'properties.overwrite', 'type': 'bool'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
        'ignore_conflicting_host_names': {'key': 'properties.ignoreConflictingHostNames', 'type': 'bool'},
        'ignore_databases': {'key': 'properties.ignoreDatabases', 'type': 'bool'},
        'app_service_plan': {'key': 'properties.appServicePlan', 'type': 'str'},
        'operation_type': {'key': 'properties.operationType', 'type': 'str'},
        'adjust_connection_strings': {'key': 'properties.adjustConnectionStrings', 'type': 'bool'},
        'hosting_environment': {'key': 'properties.hostingEnvironment', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestoreRequest, self).__init__(**kwargs)
        self.storage_account_url = kwargs.get('storage_account_url', None)
        self.blob_name = kwargs.get('blob_name', None)
        self.overwrite = kwargs.get('overwrite', None)
        self.site_name = kwargs.get('site_name', None)
        self.databases = kwargs.get('databases', None)
        self.ignore_conflicting_host_names = kwargs.get('ignore_conflicting_host_names', False)
        self.ignore_databases = kwargs.get('ignore_databases', False)
        self.app_service_plan = kwargs.get('app_service_plan', None)
        self.operation_type = kwargs.get('operation_type', None)
        self.adjust_connection_strings = kwargs.get('adjust_connection_strings', None)
        self.hosting_environment = kwargs.get('hosting_environment', None)


class RestoreResponse(ProxyOnlyResource):
    """Response for an app restore request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar operation_id: When server starts the restore process, it will return an operation ID
     identifying that particular restore operation.
    :vartype operation_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestoreResponse, self).__init__(**kwargs)
        self.operation_id = None


class Site(Resource):
    """A web app, a mobile app backend, or an API app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: Managed service identity.
    :type identity: ~azure.mgmt.web.v2016_08_01.models.ManagedServiceIdentity
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Possible values include: "Normal", "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2016_08_01.models.UsageState
    :param enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :type enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Possible
     values include: "Normal", "Limited", "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2016_08_01.models.SiteAvailabilityState
    :param host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :type host_name_ssl_states: list[~azure.mgmt.web.v2016_08_01.models.HostNameSslState]
    :param server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    :param reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :type reserved: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :param site_config: Configuration of the app.
    :type site_config: ~azure.mgmt.web.v2016_08_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :param scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :type scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :param hosting_environment_profile: App Service Environment to use for the app.
    :type hosting_environment_profile: ~azure.mgmt.web.v2016_08_01.models.HostingEnvironmentProfile
    :param client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :type client_affinity_enabled: bool
    :param client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :type client_cert_enabled: bool
    :param host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :type host_names_disabled: bool
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants. Read-only.
    :vartype possible_outbound_ip_addresses: str
    :param container_size: Size of the function container.
    :type container_size: int
    :param daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :type daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :param cloning_info: If specified during app creation, the app is cloned from a source app.
    :type cloning_info: ~azure.mgmt.web.v2016_08_01.models.CloningInfo
    :param snapshot_info: If specified during app creation, the app is created from a previous
     snapshot.
    :type snapshot_info: ~azure.mgmt.web.v2016_08_01.models.SnapshotRecoveryRequest
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2016_08_01.models.SlotSwapStatus
    :param https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :type https_only: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'host_names': {'readonly': True},
        'repository_site_name': {'readonly': True},
        'usage_state': {'readonly': True},
        'enabled_host_names': {'readonly': True},
        'availability_state': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'traffic_manager_host_names': {'readonly': True},
        'target_swap_slot': {'readonly': True},
        'outbound_ip_addresses': {'readonly': True},
        'possible_outbound_ip_addresses': {'readonly': True},
        'suspended_till': {'readonly': True},
        'max_number_of_workers': {'readonly': True},
        'resource_group': {'readonly': True},
        'is_default_container': {'readonly': True},
        'default_host_name': {'readonly': True},
        'slot_swap_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'repository_site_name': {'key': 'properties.repositorySiteName', 'type': 'str'},
        'usage_state': {'key': 'properties.usageState', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'enabled_host_names': {'key': 'properties.enabledHostNames', 'type': '[str]'},
        'availability_state': {'key': 'properties.availabilityState', 'type': 'str'},
        'host_name_ssl_states': {'key': 'properties.hostNameSslStates', 'type': '[HostNameSslState]'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'site_config': {'key': 'properties.siteConfig', 'type': 'SiteConfig'},
        'traffic_manager_host_names': {'key': 'properties.trafficManagerHostNames', 'type': '[str]'},
        'scm_site_also_stopped': {'key': 'properties.scmSiteAlsoStopped', 'type': 'bool'},
        'target_swap_slot': {'key': 'properties.targetSwapSlot', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'client_affinity_enabled': {'key': 'properties.clientAffinityEnabled', 'type': 'bool'},
        'client_cert_enabled': {'key': 'properties.clientCertEnabled', 'type': 'bool'},
        'host_names_disabled': {'key': 'properties.hostNamesDisabled', 'type': 'bool'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': 'str'},
        'possible_outbound_ip_addresses': {'key': 'properties.possibleOutboundIpAddresses', 'type': 'str'},
        'container_size': {'key': 'properties.containerSize', 'type': 'int'},
        'daily_memory_time_quota': {'key': 'properties.dailyMemoryTimeQuota', 'type': 'int'},
        'suspended_till': {'key': 'properties.suspendedTill', 'type': 'iso-8601'},
        'max_number_of_workers': {'key': 'properties.maxNumberOfWorkers', 'type': 'int'},
        'cloning_info': {'key': 'properties.cloningInfo', 'type': 'CloningInfo'},
        'snapshot_info': {'key': 'properties.snapshotInfo', 'type': 'SnapshotRecoveryRequest'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'is_default_container': {'key': 'properties.isDefaultContainer', 'type': 'bool'},
        'default_host_name': {'key': 'properties.defaultHostName', 'type': 'str'},
        'slot_swap_status': {'key': 'properties.slotSwapStatus', 'type': 'SlotSwapStatus'},
        'https_only': {'key': 'properties.httpsOnly', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Site, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = kwargs.get('enabled', None)
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = kwargs.get('host_name_ssl_states', None)
        self.server_farm_id = kwargs.get('server_farm_id', None)
        self.reserved = kwargs.get('reserved', False)
        self.last_modified_time_utc = None
        self.site_config = kwargs.get('site_config', None)
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = kwargs.get('scm_site_also_stopped', False)
        self.target_swap_slot = None
        self.hosting_environment_profile = kwargs.get('hosting_environment_profile', None)
        self.client_affinity_enabled = kwargs.get('client_affinity_enabled', None)
        self.client_cert_enabled = kwargs.get('client_cert_enabled', None)
        self.host_names_disabled = kwargs.get('host_names_disabled', None)
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = kwargs.get('container_size', None)
        self.daily_memory_time_quota = kwargs.get('daily_memory_time_quota', None)
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = kwargs.get('cloning_info', None)
        self.snapshot_info = kwargs.get('snapshot_info', None)
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = kwargs.get('https_only', None)


class SiteAuthSettings(ProxyOnlyResource):
    """Configuration settings for the Azure App Service Authentication / Authorization feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
     enabled for the current app; otherwise, :code:`<code>false</code>`.
    :type enabled: bool
    :param runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of certain features in the Authentication /
     Authorization module.
    :type runtime_version: str
    :param unauthenticated_client_action: The action to take when an unauthenticated client
     attempts to access the app. Possible values include: "RedirectToLoginPage", "AllowAnonymous".
    :type unauthenticated_client_action: str or
     ~azure.mgmt.web.v2016_08_01.models.UnauthenticatedClientAction
    :param token_store_enabled: :code:`<code>true</code>` to durably store platform-specific
     security tokens that are obtained during login flows; otherwise, :code:`<code>false</code>`.
      The default is :code:`<code>false</code>`.
    :type token_store_enabled: bool
    :param allowed_external_redirect_urls: External URLs that can be redirected to as part of
     logging in or logging out of the app. Note that the query string part of the URL is ignored.
     This is an advanced setting typically only needed by Windows Store application backends.
     Note that URLs within the current domain are always implicitly allowed.
    :type allowed_external_redirect_urls: list[str]
    :param default_provider: The default authentication provider to use when multiple providers are
     configured.
     This setting is only needed if multiple providers are configured and the unauthenticated
     client
     action is set to "RedirectToLoginPage". Possible values include: "AzureActiveDirectory",
     "Facebook", "Google", "MicrosoftAccount", "Twitter".
    :type default_provider: str or ~azure.mgmt.web.v2016_08_01.models.BuiltInAuthenticationProvider
    :param token_refresh_extension_hours: The number of hours after session token expiration that a
     session token can be used to
     call the token refresh API. The default is 72 hours.
    :type token_refresh_extension_hours: float
    :param client_id: The Client ID of this relying party application, known as the client_id.
     This setting is required for enabling OpenID Connection authentication with Azure Active
     Directory or
     other 3rd party OpenID Connect providers.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :type client_id: str
    :param client_secret: The Client Secret of this relying party application (in Azure Active
     Directory, this is also referred to as the Key).
     This setting is optional. If no client secret is configured, the OpenID Connect implicit auth
     flow is used to authenticate end users.
     Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :type client_secret: str
    :param issuer: The OpenID Connect Issuer URI that represents the entity which issues access
     tokens for this application.
     When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
     https://sts.windows.net/{tenant-guid}/.
     This URI is a case-sensitive identifier for the token issuer.
     More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-
     discovery-1_0.html.
    :type issuer: str
    :param allowed_audiences: Allowed audience values to consider when validating JWTs issued by
     Azure Active Directory. Note that the :code:`<code>ClientID</code>` value is always considered
     an
     allowed audience, regardless of this setting.
    :type allowed_audiences: list[str]
    :param additional_login_params: Login parameters to send to the OpenID Connect authorization
     endpoint when
     a user logs in. Each parameter must be in the form "key=value".
    :type additional_login_params: list[str]
    :param google_client_id: The OpenID Connect Client ID for the Google web application.
     This setting is required for enabling Google Sign-In.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :type google_client_id: str
    :param google_client_secret: The client secret associated with the Google web application.
     This setting is required for enabling Google Sign-In.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :type google_client_secret: str
    :param google_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Google
     Sign-In authentication.
     This setting is optional. If not specified, "openid", "profile", and "email" are used as
     default scopes.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :type google_o_auth_scopes: list[str]
    :param facebook_app_id: The App ID of the Facebook app used for login.
     This setting is required for enabling Facebook Login.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :type facebook_app_id: str
    :param facebook_app_secret: The App Secret of the Facebook app used for Facebook Login.
     This setting is required for enabling Facebook Login.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :type facebook_app_secret: str
    :param facebook_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Facebook
     Login authentication.
     This setting is optional.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :type facebook_o_auth_scopes: list[str]
    :param twitter_consumer_key: The OAuth 1.0a consumer key of the Twitter application used for
     sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :type twitter_consumer_key: str
    :param twitter_consumer_secret: The OAuth 1.0a consumer secret of the Twitter application used
     for sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :type twitter_consumer_secret: str
    :param microsoft_account_client_id: The OAuth 2.0 client ID that was created for the app used
     for authentication.
     This setting is required for enabling Microsoft Account authentication.
     Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
    :type microsoft_account_client_id: str
    :param microsoft_account_client_secret: The OAuth 2.0 client secret that was created for the
     app used for authentication.
     This setting is required for enabling Microsoft Account authentication.
     Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
    :type microsoft_account_client_secret: str
    :param microsoft_account_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of
     Microsoft Account authentication.
     This setting is optional. If not specified, "wl.basic" is used as the default scope.
     Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-
     us/library/dn631845.aspx.
    :type microsoft_account_o_auth_scopes: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'runtime_version': {'key': 'properties.runtimeVersion', 'type': 'str'},
        'unauthenticated_client_action': {'key': 'properties.unauthenticatedClientAction', 'type': 'str'},
        'token_store_enabled': {'key': 'properties.tokenStoreEnabled', 'type': 'bool'},
        'allowed_external_redirect_urls': {'key': 'properties.allowedExternalRedirectUrls', 'type': '[str]'},
        'default_provider': {'key': 'properties.defaultProvider', 'type': 'str'},
        'token_refresh_extension_hours': {'key': 'properties.tokenRefreshExtensionHours', 'type': 'float'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'allowed_audiences': {'key': 'properties.allowedAudiences', 'type': '[str]'},
        'additional_login_params': {'key': 'properties.additionalLoginParams', 'type': '[str]'},
        'google_client_id': {'key': 'properties.googleClientId', 'type': 'str'},
        'google_client_secret': {'key': 'properties.googleClientSecret', 'type': 'str'},
        'google_o_auth_scopes': {'key': 'properties.googleOAuthScopes', 'type': '[str]'},
        'facebook_app_id': {'key': 'properties.facebookAppId', 'type': 'str'},
        'facebook_app_secret': {'key': 'properties.facebookAppSecret', 'type': 'str'},
        'facebook_o_auth_scopes': {'key': 'properties.facebookOAuthScopes', 'type': '[str]'},
        'twitter_consumer_key': {'key': 'properties.twitterConsumerKey', 'type': 'str'},
        'twitter_consumer_secret': {'key': 'properties.twitterConsumerSecret', 'type': 'str'},
        'microsoft_account_client_id': {'key': 'properties.microsoftAccountClientId', 'type': 'str'},
        'microsoft_account_client_secret': {'key': 'properties.microsoftAccountClientSecret', 'type': 'str'},
        'microsoft_account_o_auth_scopes': {'key': 'properties.microsoftAccountOAuthScopes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteAuthSettings, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.runtime_version = kwargs.get('runtime_version', None)
        self.unauthenticated_client_action = kwargs.get('unauthenticated_client_action', None)
        self.token_store_enabled = kwargs.get('token_store_enabled', None)
        self.allowed_external_redirect_urls = kwargs.get('allowed_external_redirect_urls', None)
        self.default_provider = kwargs.get('default_provider', None)
        self.token_refresh_extension_hours = kwargs.get('token_refresh_extension_hours', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)
        self.issuer = kwargs.get('issuer', None)
        self.allowed_audiences = kwargs.get('allowed_audiences', None)
        self.additional_login_params = kwargs.get('additional_login_params', None)
        self.google_client_id = kwargs.get('google_client_id', None)
        self.google_client_secret = kwargs.get('google_client_secret', None)
        self.google_o_auth_scopes = kwargs.get('google_o_auth_scopes', None)
        self.facebook_app_id = kwargs.get('facebook_app_id', None)
        self.facebook_app_secret = kwargs.get('facebook_app_secret', None)
        self.facebook_o_auth_scopes = kwargs.get('facebook_o_auth_scopes', None)
        self.twitter_consumer_key = kwargs.get('twitter_consumer_key', None)
        self.twitter_consumer_secret = kwargs.get('twitter_consumer_secret', None)
        self.microsoft_account_client_id = kwargs.get('microsoft_account_client_id', None)
        self.microsoft_account_client_secret = kwargs.get('microsoft_account_client_secret', None)
        self.microsoft_account_o_auth_scopes = kwargs.get('microsoft_account_o_auth_scopes', None)


class SiteCloneability(msrest.serialization.Model):
    """Represents whether or not an app is cloneable.

    :param result: Name of app. Possible values include: "Cloneable", "PartiallyCloneable",
     "NotCloneable".
    :type result: str or ~azure.mgmt.web.v2016_08_01.models.CloneAbilityResult
    :param blocking_features: List of features enabled on app that prevent cloning.
    :type blocking_features: list[~azure.mgmt.web.v2016_08_01.models.SiteCloneabilityCriterion]
    :param unsupported_features: List of features enabled on app that are non-blocking but cannot
     be cloned. The app can still be cloned
     but the features in this list will not be set up on cloned app.
    :type unsupported_features: list[~azure.mgmt.web.v2016_08_01.models.SiteCloneabilityCriterion]
    :param blocking_characteristics: List of blocking application characteristics.
    :type blocking_characteristics:
     list[~azure.mgmt.web.v2016_08_01.models.SiteCloneabilityCriterion]
    """

    _attribute_map = {
        'result': {'key': 'result', 'type': 'str'},
        'blocking_features': {'key': 'blockingFeatures', 'type': '[SiteCloneabilityCriterion]'},
        'unsupported_features': {'key': 'unsupportedFeatures', 'type': '[SiteCloneabilityCriterion]'},
        'blocking_characteristics': {'key': 'blockingCharacteristics', 'type': '[SiteCloneabilityCriterion]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteCloneability, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.blocking_features = kwargs.get('blocking_features', None)
        self.unsupported_features = kwargs.get('unsupported_features', None)
        self.blocking_characteristics = kwargs.get('blocking_characteristics', None)


class SiteCloneabilityCriterion(msrest.serialization.Model):
    """An app cloneability criterion.

    :param name: Name of criterion.
    :type name: str
    :param description: Description of criterion.
    :type description: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteCloneabilityCriterion, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)


class SiteConfig(msrest.serialization.Model):
    """Configuration of an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param number_of_workers: Number of workers.
    :type number_of_workers: int
    :param default_documents: Default documents.
    :type default_documents: list[str]
    :param net_framework_version: .NET Framework version.
    :type net_framework_version: str
    :param php_version: Version of PHP.
    :type php_version: str
    :param python_version: Version of Python.
    :type python_version: str
    :param node_version: Version of Node.js.
    :type node_version: str
    :param linux_fx_version: Linux App Framework and version.
    :type linux_fx_version: str
    :param request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :type request_tracing_enabled: bool
    :param request_tracing_expiration_time: Request tracing expiration time.
    :type request_tracing_expiration_time: ~datetime.datetime
    :param remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :type remote_debugging_enabled: bool
    :param remote_debugging_version: Remote debugging version.
    :type remote_debugging_version: str
    :param http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :type http_logging_enabled: bool
    :param logs_directory_size_limit: HTTP logs directory size limit.
    :type logs_directory_size_limit: int
    :param detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :type detailed_error_logging_enabled: bool
    :param publishing_username: Publishing user name.
    :type publishing_username: str
    :param app_settings: Application settings.
    :type app_settings: list[~azure.mgmt.web.v2016_08_01.models.NameValuePair]
    :param connection_strings: Connection strings.
    :type connection_strings: list[~azure.mgmt.web.v2016_08_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2016_08_01.models.SiteMachineKey
    :param handler_mappings: Handler mappings.
    :type handler_mappings: list[~azure.mgmt.web.v2016_08_01.models.HandlerMapping]
    :param document_root: Document root.
    :type document_root: str
    :param scm_type: SCM type. Possible values include: "None", "Dropbox", "Tfs", "LocalGit",
     "GitHub", "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit",
     "ExternalHg", "OneDrive", "VSO".
    :type scm_type: str or ~azure.mgmt.web.v2016_08_01.models.ScmType
    :param use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :type use32_bit_worker_process: bool
    :param web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :type web_sockets_enabled: bool
    :param always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :type always_on: bool
    :param java_version: Java version.
    :type java_version: str
    :param java_container: Java container.
    :type java_container: str
    :param java_container_version: Java container version.
    :type java_container_version: str
    :param app_command_line: App command line to launch.
    :type app_command_line: str
    :param managed_pipeline_mode: Managed pipeline mode. Possible values include: "Integrated",
     "Classic".
    :type managed_pipeline_mode: str or ~azure.mgmt.web.v2016_08_01.models.ManagedPipelineMode
    :param virtual_applications: Virtual applications.
    :type virtual_applications: list[~azure.mgmt.web.v2016_08_01.models.VirtualApplication]
    :param load_balancing: Site load balancing. Possible values include: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash".
    :type load_balancing: str or ~azure.mgmt.web.v2016_08_01.models.SiteLoadBalancing
    :param experiments: This is work around for polymorphic types.
    :type experiments: ~azure.mgmt.web.v2016_08_01.models.Experiments
    :param limits: Site limits.
    :type limits: ~azure.mgmt.web.v2016_08_01.models.SiteLimits
    :param auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :type auto_heal_enabled: bool
    :param auto_heal_rules: Auto Heal rules.
    :type auto_heal_rules: ~azure.mgmt.web.v2016_08_01.models.AutoHealRules
    :param tracing_options: Tracing options.
    :type tracing_options: str
    :param vnet_name: Virtual Network name.
    :type vnet_name: str
    :param cors: Cross-Origin Resource Sharing (CORS) settings.
    :type cors: ~azure.mgmt.web.v2016_08_01.models.CorsSettings
    :param push: Push endpoint settings.
    :type push: ~azure.mgmt.web.v2016_08_01.models.PushSettings
    :param api_definition: Information about the formal API definition for the app.
    :type api_definition: ~azure.mgmt.web.v2016_08_01.models.ApiDefinitionInfo
    :param auto_swap_slot_name: Auto-swap slot name.
    :type auto_swap_slot_name: str
    :param local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :type local_my_sql_enabled: bool
    :param ip_security_restrictions: IP security restrictions.
    :type ip_security_restrictions: list[~azure.mgmt.web.v2016_08_01.models.IpSecurityRestriction]
    :param http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :type http20_enabled: bool
    :param min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Possible values include: "1.0", "1.1", "1.2".
    :type min_tls_version: str or ~azure.mgmt.web.v2016_08_01.models.SupportedTlsVersions
    """

    _validation = {
        'machine_key': {'readonly': True},
    }

    _attribute_map = {
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'default_documents': {'key': 'defaultDocuments', 'type': '[str]'},
        'net_framework_version': {'key': 'netFrameworkVersion', 'type': 'str'},
        'php_version': {'key': 'phpVersion', 'type': 'str'},
        'python_version': {'key': 'pythonVersion', 'type': 'str'},
        'node_version': {'key': 'nodeVersion', 'type': 'str'},
        'linux_fx_version': {'key': 'linuxFxVersion', 'type': 'str'},
        'request_tracing_enabled': {'key': 'requestTracingEnabled', 'type': 'bool'},
        'request_tracing_expiration_time': {'key': 'requestTracingExpirationTime', 'type': 'iso-8601'},
        'remote_debugging_enabled': {'key': 'remoteDebuggingEnabled', 'type': 'bool'},
        'remote_debugging_version': {'key': 'remoteDebuggingVersion', 'type': 'str'},
        'http_logging_enabled': {'key': 'httpLoggingEnabled', 'type': 'bool'},
        'logs_directory_size_limit': {'key': 'logsDirectorySizeLimit', 'type': 'int'},
        'detailed_error_logging_enabled': {'key': 'detailedErrorLoggingEnabled', 'type': 'bool'},
        'publishing_username': {'key': 'publishingUsername', 'type': 'str'},
        'app_settings': {'key': 'appSettings', 'type': '[NameValuePair]'},
        'connection_strings': {'key': 'connectionStrings', 'type': '[ConnStringInfo]'},
        'machine_key': {'key': 'machineKey', 'type': 'SiteMachineKey'},
        'handler_mappings': {'key': 'handlerMappings', 'type': '[HandlerMapping]'},
        'document_root': {'key': 'documentRoot', 'type': 'str'},
        'scm_type': {'key': 'scmType', 'type': 'str'},
        'use32_bit_worker_process': {'key': 'use32BitWorkerProcess', 'type': 'bool'},
        'web_sockets_enabled': {'key': 'webSocketsEnabled', 'type': 'bool'},
        'always_on': {'key': 'alwaysOn', 'type': 'bool'},
        'java_version': {'key': 'javaVersion', 'type': 'str'},
        'java_container': {'key': 'javaContainer', 'type': 'str'},
        'java_container_version': {'key': 'javaContainerVersion', 'type': 'str'},
        'app_command_line': {'key': 'appCommandLine', 'type': 'str'},
        'managed_pipeline_mode': {'key': 'managedPipelineMode', 'type': 'str'},
        'virtual_applications': {'key': 'virtualApplications', 'type': '[VirtualApplication]'},
        'load_balancing': {'key': 'loadBalancing', 'type': 'str'},
        'experiments': {'key': 'experiments', 'type': 'Experiments'},
        'limits': {'key': 'limits', 'type': 'SiteLimits'},
        'auto_heal_enabled': {'key': 'autoHealEnabled', 'type': 'bool'},
        'auto_heal_rules': {'key': 'autoHealRules', 'type': 'AutoHealRules'},
        'tracing_options': {'key': 'tracingOptions', 'type': 'str'},
        'vnet_name': {'key': 'vnetName', 'type': 'str'},
        'cors': {'key': 'cors', 'type': 'CorsSettings'},
        'push': {'key': 'push', 'type': 'PushSettings'},
        'api_definition': {'key': 'apiDefinition', 'type': 'ApiDefinitionInfo'},
        'auto_swap_slot_name': {'key': 'autoSwapSlotName', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'localMySqlEnabled', 'type': 'bool'},
        'ip_security_restrictions': {'key': 'ipSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'http20_enabled': {'key': 'http20Enabled', 'type': 'bool'},
        'min_tls_version': {'key': 'minTlsVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteConfig, self).__init__(**kwargs)
        self.number_of_workers = kwargs.get('number_of_workers', None)
        self.default_documents = kwargs.get('default_documents', None)
        self.net_framework_version = kwargs.get('net_framework_version', "v4.6")
        self.php_version = kwargs.get('php_version', None)
        self.python_version = kwargs.get('python_version', None)
        self.node_version = kwargs.get('node_version', None)
        self.linux_fx_version = kwargs.get('linux_fx_version', None)
        self.request_tracing_enabled = kwargs.get('request_tracing_enabled', None)
        self.request_tracing_expiration_time = kwargs.get('request_tracing_expiration_time', None)
        self.remote_debugging_enabled = kwargs.get('remote_debugging_enabled', None)
        self.remote_debugging_version = kwargs.get('remote_debugging_version', None)
        self.http_logging_enabled = kwargs.get('http_logging_enabled', None)
        self.logs_directory_size_limit = kwargs.get('logs_directory_size_limit', None)
        self.detailed_error_logging_enabled = kwargs.get('detailed_error_logging_enabled', None)
        self.publishing_username = kwargs.get('publishing_username', None)
        self.app_settings = kwargs.get('app_settings', None)
        self.connection_strings = kwargs.get('connection_strings', None)
        self.machine_key = None
        self.handler_mappings = kwargs.get('handler_mappings', None)
        self.document_root = kwargs.get('document_root', None)
        self.scm_type = kwargs.get('scm_type', None)
        self.use32_bit_worker_process = kwargs.get('use32_bit_worker_process', None)
        self.web_sockets_enabled = kwargs.get('web_sockets_enabled', None)
        self.always_on = kwargs.get('always_on', None)
        self.java_version = kwargs.get('java_version', None)
        self.java_container = kwargs.get('java_container', None)
        self.java_container_version = kwargs.get('java_container_version', None)
        self.app_command_line = kwargs.get('app_command_line', None)
        self.managed_pipeline_mode = kwargs.get('managed_pipeline_mode', None)
        self.virtual_applications = kwargs.get('virtual_applications', None)
        self.load_balancing = kwargs.get('load_balancing', None)
        self.experiments = kwargs.get('experiments', None)
        self.limits = kwargs.get('limits', None)
        self.auto_heal_enabled = kwargs.get('auto_heal_enabled', None)
        self.auto_heal_rules = kwargs.get('auto_heal_rules', None)
        self.tracing_options = kwargs.get('tracing_options', None)
        self.vnet_name = kwargs.get('vnet_name', None)
        self.cors = kwargs.get('cors', None)
        self.push = kwargs.get('push', None)
        self.api_definition = kwargs.get('api_definition', None)
        self.auto_swap_slot_name = kwargs.get('auto_swap_slot_name', None)
        self.local_my_sql_enabled = kwargs.get('local_my_sql_enabled', False)
        self.ip_security_restrictions = kwargs.get('ip_security_restrictions', None)
        self.http20_enabled = kwargs.get('http20_enabled', True)
        self.min_tls_version = kwargs.get('min_tls_version', None)


class SiteConfigResource(ProxyOnlyResource):
    """Web app configuration ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param number_of_workers: Number of workers.
    :type number_of_workers: int
    :param default_documents: Default documents.
    :type default_documents: list[str]
    :param net_framework_version: .NET Framework version.
    :type net_framework_version: str
    :param php_version: Version of PHP.
    :type php_version: str
    :param python_version: Version of Python.
    :type python_version: str
    :param node_version: Version of Node.js.
    :type node_version: str
    :param linux_fx_version: Linux App Framework and version.
    :type linux_fx_version: str
    :param request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :type request_tracing_enabled: bool
    :param request_tracing_expiration_time: Request tracing expiration time.
    :type request_tracing_expiration_time: ~datetime.datetime
    :param remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :type remote_debugging_enabled: bool
    :param remote_debugging_version: Remote debugging version.
    :type remote_debugging_version: str
    :param http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :type http_logging_enabled: bool
    :param logs_directory_size_limit: HTTP logs directory size limit.
    :type logs_directory_size_limit: int
    :param detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :type detailed_error_logging_enabled: bool
    :param publishing_username: Publishing user name.
    :type publishing_username: str
    :param app_settings: Application settings.
    :type app_settings: list[~azure.mgmt.web.v2016_08_01.models.NameValuePair]
    :param connection_strings: Connection strings.
    :type connection_strings: list[~azure.mgmt.web.v2016_08_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2016_08_01.models.SiteMachineKey
    :param handler_mappings: Handler mappings.
    :type handler_mappings: list[~azure.mgmt.web.v2016_08_01.models.HandlerMapping]
    :param document_root: Document root.
    :type document_root: str
    :param scm_type: SCM type. Possible values include: "None", "Dropbox", "Tfs", "LocalGit",
     "GitHub", "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit",
     "ExternalHg", "OneDrive", "VSO".
    :type scm_type: str or ~azure.mgmt.web.v2016_08_01.models.ScmType
    :param use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :type use32_bit_worker_process: bool
    :param web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :type web_sockets_enabled: bool
    :param always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :type always_on: bool
    :param java_version: Java version.
    :type java_version: str
    :param java_container: Java container.
    :type java_container: str
    :param java_container_version: Java container version.
    :type java_container_version: str
    :param app_command_line: App command line to launch.
    :type app_command_line: str
    :param managed_pipeline_mode: Managed pipeline mode. Possible values include: "Integrated",
     "Classic".
    :type managed_pipeline_mode: str or ~azure.mgmt.web.v2016_08_01.models.ManagedPipelineMode
    :param virtual_applications: Virtual applications.
    :type virtual_applications: list[~azure.mgmt.web.v2016_08_01.models.VirtualApplication]
    :param load_balancing: Site load balancing. Possible values include: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash".
    :type load_balancing: str or ~azure.mgmt.web.v2016_08_01.models.SiteLoadBalancing
    :param experiments: This is work around for polymorphic types.
    :type experiments: ~azure.mgmt.web.v2016_08_01.models.Experiments
    :param limits: Site limits.
    :type limits: ~azure.mgmt.web.v2016_08_01.models.SiteLimits
    :param auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :type auto_heal_enabled: bool
    :param auto_heal_rules: Auto Heal rules.
    :type auto_heal_rules: ~azure.mgmt.web.v2016_08_01.models.AutoHealRules
    :param tracing_options: Tracing options.
    :type tracing_options: str
    :param vnet_name: Virtual Network name.
    :type vnet_name: str
    :param cors: Cross-Origin Resource Sharing (CORS) settings.
    :type cors: ~azure.mgmt.web.v2016_08_01.models.CorsSettings
    :param push: Push endpoint settings.
    :type push: ~azure.mgmt.web.v2016_08_01.models.PushSettings
    :param api_definition: Information about the formal API definition for the app.
    :type api_definition: ~azure.mgmt.web.v2016_08_01.models.ApiDefinitionInfo
    :param auto_swap_slot_name: Auto-swap slot name.
    :type auto_swap_slot_name: str
    :param local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :type local_my_sql_enabled: bool
    :param ip_security_restrictions: IP security restrictions.
    :type ip_security_restrictions: list[~azure.mgmt.web.v2016_08_01.models.IpSecurityRestriction]
    :param http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :type http20_enabled: bool
    :param min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Possible values include: "1.0", "1.1", "1.2".
    :type min_tls_version: str or ~azure.mgmt.web.v2016_08_01.models.SupportedTlsVersions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'machine_key': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'number_of_workers': {'key': 'properties.numberOfWorkers', 'type': 'int'},
        'default_documents': {'key': 'properties.defaultDocuments', 'type': '[str]'},
        'net_framework_version': {'key': 'properties.netFrameworkVersion', 'type': 'str'},
        'php_version': {'key': 'properties.phpVersion', 'type': 'str'},
        'python_version': {'key': 'properties.pythonVersion', 'type': 'str'},
        'node_version': {'key': 'properties.nodeVersion', 'type': 'str'},
        'linux_fx_version': {'key': 'properties.linuxFxVersion', 'type': 'str'},
        'request_tracing_enabled': {'key': 'properties.requestTracingEnabled', 'type': 'bool'},
        'request_tracing_expiration_time': {'key': 'properties.requestTracingExpirationTime', 'type': 'iso-8601'},
        'remote_debugging_enabled': {'key': 'properties.remoteDebuggingEnabled', 'type': 'bool'},
        'remote_debugging_version': {'key': 'properties.remoteDebuggingVersion', 'type': 'str'},
        'http_logging_enabled': {'key': 'properties.httpLoggingEnabled', 'type': 'bool'},
        'logs_directory_size_limit': {'key': 'properties.logsDirectorySizeLimit', 'type': 'int'},
        'detailed_error_logging_enabled': {'key': 'properties.detailedErrorLoggingEnabled', 'type': 'bool'},
        'publishing_username': {'key': 'properties.publishingUsername', 'type': 'str'},
        'app_settings': {'key': 'properties.appSettings', 'type': '[NameValuePair]'},
        'connection_strings': {'key': 'properties.connectionStrings', 'type': '[ConnStringInfo]'},
        'machine_key': {'key': 'properties.machineKey', 'type': 'SiteMachineKey'},
        'handler_mappings': {'key': 'properties.handlerMappings', 'type': '[HandlerMapping]'},
        'document_root': {'key': 'properties.documentRoot', 'type': 'str'},
        'scm_type': {'key': 'properties.scmType', 'type': 'str'},
        'use32_bit_worker_process': {'key': 'properties.use32BitWorkerProcess', 'type': 'bool'},
        'web_sockets_enabled': {'key': 'properties.webSocketsEnabled', 'type': 'bool'},
        'always_on': {'key': 'properties.alwaysOn', 'type': 'bool'},
        'java_version': {'key': 'properties.javaVersion', 'type': 'str'},
        'java_container': {'key': 'properties.javaContainer', 'type': 'str'},
        'java_container_version': {'key': 'properties.javaContainerVersion', 'type': 'str'},
        'app_command_line': {'key': 'properties.appCommandLine', 'type': 'str'},
        'managed_pipeline_mode': {'key': 'properties.managedPipelineMode', 'type': 'str'},
        'virtual_applications': {'key': 'properties.virtualApplications', 'type': '[VirtualApplication]'},
        'load_balancing': {'key': 'properties.loadBalancing', 'type': 'str'},
        'experiments': {'key': 'properties.experiments', 'type': 'Experiments'},
        'limits': {'key': 'properties.limits', 'type': 'SiteLimits'},
        'auto_heal_enabled': {'key': 'properties.autoHealEnabled', 'type': 'bool'},
        'auto_heal_rules': {'key': 'properties.autoHealRules', 'type': 'AutoHealRules'},
        'tracing_options': {'key': 'properties.tracingOptions', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'cors': {'key': 'properties.cors', 'type': 'CorsSettings'},
        'push': {'key': 'properties.push', 'type': 'PushSettings'},
        'api_definition': {'key': 'properties.apiDefinition', 'type': 'ApiDefinitionInfo'},
        'auto_swap_slot_name': {'key': 'properties.autoSwapSlotName', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'properties.localMySqlEnabled', 'type': 'bool'},
        'ip_security_restrictions': {'key': 'properties.ipSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'http20_enabled': {'key': 'properties.http20Enabled', 'type': 'bool'},
        'min_tls_version': {'key': 'properties.minTlsVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteConfigResource, self).__init__(**kwargs)
        self.number_of_workers = kwargs.get('number_of_workers', None)
        self.default_documents = kwargs.get('default_documents', None)
        self.net_framework_version = kwargs.get('net_framework_version', "v4.6")
        self.php_version = kwargs.get('php_version', None)
        self.python_version = kwargs.get('python_version', None)
        self.node_version = kwargs.get('node_version', None)
        self.linux_fx_version = kwargs.get('linux_fx_version', None)
        self.request_tracing_enabled = kwargs.get('request_tracing_enabled', None)
        self.request_tracing_expiration_time = kwargs.get('request_tracing_expiration_time', None)
        self.remote_debugging_enabled = kwargs.get('remote_debugging_enabled', None)
        self.remote_debugging_version = kwargs.get('remote_debugging_version', None)
        self.http_logging_enabled = kwargs.get('http_logging_enabled', None)
        self.logs_directory_size_limit = kwargs.get('logs_directory_size_limit', None)
        self.detailed_error_logging_enabled = kwargs.get('detailed_error_logging_enabled', None)
        self.publishing_username = kwargs.get('publishing_username', None)
        self.app_settings = kwargs.get('app_settings', None)
        self.connection_strings = kwargs.get('connection_strings', None)
        self.machine_key = None
        self.handler_mappings = kwargs.get('handler_mappings', None)
        self.document_root = kwargs.get('document_root', None)
        self.scm_type = kwargs.get('scm_type', None)
        self.use32_bit_worker_process = kwargs.get('use32_bit_worker_process', None)
        self.web_sockets_enabled = kwargs.get('web_sockets_enabled', None)
        self.always_on = kwargs.get('always_on', None)
        self.java_version = kwargs.get('java_version', None)
        self.java_container = kwargs.get('java_container', None)
        self.java_container_version = kwargs.get('java_container_version', None)
        self.app_command_line = kwargs.get('app_command_line', None)
        self.managed_pipeline_mode = kwargs.get('managed_pipeline_mode', None)
        self.virtual_applications = kwargs.get('virtual_applications', None)
        self.load_balancing = kwargs.get('load_balancing', None)
        self.experiments = kwargs.get('experiments', None)
        self.limits = kwargs.get('limits', None)
        self.auto_heal_enabled = kwargs.get('auto_heal_enabled', None)
        self.auto_heal_rules = kwargs.get('auto_heal_rules', None)
        self.tracing_options = kwargs.get('tracing_options', None)
        self.vnet_name = kwargs.get('vnet_name', None)
        self.cors = kwargs.get('cors', None)
        self.push = kwargs.get('push', None)
        self.api_definition = kwargs.get('api_definition', None)
        self.auto_swap_slot_name = kwargs.get('auto_swap_slot_name', None)
        self.local_my_sql_enabled = kwargs.get('local_my_sql_enabled', False)
        self.ip_security_restrictions = kwargs.get('ip_security_restrictions', None)
        self.http20_enabled = kwargs.get('http20_enabled', True)
        self.min_tls_version = kwargs.get('min_tls_version', None)


class SiteConfigResourceCollection(msrest.serialization.Model):
    """Collection of site configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.SiteConfigResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteConfigResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteConfigResourceCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class SiteConfigurationSnapshotInfo(ProxyOnlyResource):
    """A snapshot of a web app configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: ~datetime.datetime
    :ivar id_properties_id: The id of the snapshot.
    :vartype id_properties_id: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time': {'readonly': True},
        'id_properties_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'iso-8601'},
        'id_properties_id': {'key': 'properties.id', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteConfigurationSnapshotInfo, self).__init__(**kwargs)
        self.time = None
        self.id_properties_id = None


class SiteConfigurationSnapshotInfoCollection(msrest.serialization.Model):
    """Collection of metadata for the app configuration snapshots that can be restored.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.SiteConfigurationSnapshotInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteConfigurationSnapshotInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteConfigurationSnapshotInfoCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class SiteExtensionInfo(ProxyOnlyResource):
    """Site Extension Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param id_properties_id: Site extension ID.
    :type id_properties_id: str
    :param title: Site extension title.
    :type title: str
    :param type_properties_type: Site extension type. Possible values include: "Gallery",
     "WebRoot".
    :type type_properties_type: str or ~azure.mgmt.web.v2016_08_01.models.SiteExtensionType
    :param summary: Summary description.
    :type summary: str
    :param description: Detailed description.
    :type description: str
    :param version: Version information.
    :type version: str
    :param extension_url: Extension URL.
    :type extension_url: str
    :param project_url: Project URL.
    :type project_url: str
    :param icon_url: Icon URL.
    :type icon_url: str
    :param license_url: License URL.
    :type license_url: str
    :param feed_url: Feed URL.
    :type feed_url: str
    :param authors: List of authors.
    :type authors: list[str]
    :param installation_args: Installer command line parameters.
    :type installation_args: str
    :param published_date_time: Published timestamp.
    :type published_date_time: ~datetime.datetime
    :param download_count: Count of downloads.
    :type download_count: int
    :param local_is_latest_version: :code:`<code>true</code>` if the local version is the latest
     version; :code:`<code>false</code>` otherwise.
    :type local_is_latest_version: bool
    :param local_path: Local path.
    :type local_path: str
    :param installed_date_time: Installed timestamp.
    :type installed_date_time: ~datetime.datetime
    :param provisioning_state: Provisioning state.
    :type provisioning_state: str
    :param comment: Site Extension comment.
    :type comment: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'summary': {'key': 'properties.summary', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'extension_url': {'key': 'properties.extensionUrl', 'type': 'str'},
        'project_url': {'key': 'properties.projectUrl', 'type': 'str'},
        'icon_url': {'key': 'properties.iconUrl', 'type': 'str'},
        'license_url': {'key': 'properties.licenseUrl', 'type': 'str'},
        'feed_url': {'key': 'properties.feedUrl', 'type': 'str'},
        'authors': {'key': 'properties.authors', 'type': '[str]'},
        'installation_args': {'key': 'properties.installationArgs', 'type': 'str'},
        'published_date_time': {'key': 'properties.publishedDateTime', 'type': 'iso-8601'},
        'download_count': {'key': 'properties.downloadCount', 'type': 'int'},
        'local_is_latest_version': {'key': 'properties.localIsLatestVersion', 'type': 'bool'},
        'local_path': {'key': 'properties.localPath', 'type': 'str'},
        'installed_date_time': {'key': 'properties.installedDateTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'comment': {'key': 'properties.comment', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteExtensionInfo, self).__init__(**kwargs)
        self.id_properties_id = kwargs.get('id_properties_id', None)
        self.title = kwargs.get('title', None)
        self.type_properties_type = kwargs.get('type_properties_type', None)
        self.summary = kwargs.get('summary', None)
        self.description = kwargs.get('description', None)
        self.version = kwargs.get('version', None)
        self.extension_url = kwargs.get('extension_url', None)
        self.project_url = kwargs.get('project_url', None)
        self.icon_url = kwargs.get('icon_url', None)
        self.license_url = kwargs.get('license_url', None)
        self.feed_url = kwargs.get('feed_url', None)
        self.authors = kwargs.get('authors', None)
        self.installation_args = kwargs.get('installation_args', None)
        self.published_date_time = kwargs.get('published_date_time', None)
        self.download_count = kwargs.get('download_count', None)
        self.local_is_latest_version = kwargs.get('local_is_latest_version', None)
        self.local_path = kwargs.get('local_path', None)
        self.installed_date_time = kwargs.get('installed_date_time', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.comment = kwargs.get('comment', None)


class SiteExtensionInfoCollection(msrest.serialization.Model):
    """Collection of Kudu site extension information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.SiteExtensionInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteExtensionInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteExtensionInfoCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class SiteInstance(ProxyOnlyResource):
    """Instance of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name of instance.
    :vartype name_properties_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteInstance, self).__init__(**kwargs)
        self.name_properties_name = None


class SiteLimits(msrest.serialization.Model):
    """Metric limits set on an app.

    :param max_percentage_cpu: Maximum allowed CPU usage percentage.
    :type max_percentage_cpu: float
    :param max_memory_in_mb: Maximum allowed memory usage in MB.
    :type max_memory_in_mb: long
    :param max_disk_size_in_mb: Maximum allowed disk size usage in MB.
    :type max_disk_size_in_mb: long
    """

    _attribute_map = {
        'max_percentage_cpu': {'key': 'maxPercentageCpu', 'type': 'float'},
        'max_memory_in_mb': {'key': 'maxMemoryInMb', 'type': 'long'},
        'max_disk_size_in_mb': {'key': 'maxDiskSizeInMb', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteLimits, self).__init__(**kwargs)
        self.max_percentage_cpu = kwargs.get('max_percentage_cpu', None)
        self.max_memory_in_mb = kwargs.get('max_memory_in_mb', None)
        self.max_disk_size_in_mb = kwargs.get('max_disk_size_in_mb', None)


class SiteLogsConfig(ProxyOnlyResource):
    """Configuration of App Service site logs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param application_logs: Application logs configuration.
    :type application_logs: ~azure.mgmt.web.v2016_08_01.models.ApplicationLogsConfig
    :param http_logs: HTTP logs configuration.
    :type http_logs: ~azure.mgmt.web.v2016_08_01.models.HttpLogsConfig
    :param failed_requests_tracing: Failed requests tracing configuration.
    :type failed_requests_tracing: ~azure.mgmt.web.v2016_08_01.models.EnabledConfig
    :param detailed_error_messages: Detailed error messages configuration.
    :type detailed_error_messages: ~azure.mgmt.web.v2016_08_01.models.EnabledConfig
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'application_logs': {'key': 'properties.applicationLogs', 'type': 'ApplicationLogsConfig'},
        'http_logs': {'key': 'properties.httpLogs', 'type': 'HttpLogsConfig'},
        'failed_requests_tracing': {'key': 'properties.failedRequestsTracing', 'type': 'EnabledConfig'},
        'detailed_error_messages': {'key': 'properties.detailedErrorMessages', 'type': 'EnabledConfig'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteLogsConfig, self).__init__(**kwargs)
        self.application_logs = kwargs.get('application_logs', None)
        self.http_logs = kwargs.get('http_logs', None)
        self.failed_requests_tracing = kwargs.get('failed_requests_tracing', None)
        self.detailed_error_messages = kwargs.get('detailed_error_messages', None)


class SiteMachineKey(msrest.serialization.Model):
    """MachineKey of an app.

    :param validation: MachineKey validation.
    :type validation: str
    :param validation_key: Validation key.
    :type validation_key: str
    :param decryption: Algorithm used for decryption.
    :type decryption: str
    :param decryption_key: Decryption key.
    :type decryption_key: str
    """

    _attribute_map = {
        'validation': {'key': 'validation', 'type': 'str'},
        'validation_key': {'key': 'validationKey', 'type': 'str'},
        'decryption': {'key': 'decryption', 'type': 'str'},
        'decryption_key': {'key': 'decryptionKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteMachineKey, self).__init__(**kwargs)
        self.validation = kwargs.get('validation', None)
        self.validation_key = kwargs.get('validation_key', None)
        self.decryption = kwargs.get('decryption', None)
        self.decryption_key = kwargs.get('decryption_key', None)


class SitePatchResource(ProxyOnlyResource):
    """ARM resource for a site.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Possible values include: "Normal", "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2016_08_01.models.UsageState
    :param enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :type enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Possible
     values include: "Normal", "Limited", "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2016_08_01.models.SiteAvailabilityState
    :param host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :type host_name_ssl_states: list[~azure.mgmt.web.v2016_08_01.models.HostNameSslState]
    :param server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    :param reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :type reserved: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :param site_config: Configuration of the app.
    :type site_config: ~azure.mgmt.web.v2016_08_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :param scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :type scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :param hosting_environment_profile: App Service Environment to use for the app.
    :type hosting_environment_profile: ~azure.mgmt.web.v2016_08_01.models.HostingEnvironmentProfile
    :param client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :type client_affinity_enabled: bool
    :param client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :type client_cert_enabled: bool
    :param host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :type host_names_disabled: bool
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants. Read-only.
    :vartype possible_outbound_ip_addresses: str
    :param container_size: Size of the function container.
    :type container_size: int
    :param daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :type daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :param cloning_info: If specified during app creation, the app is cloned from a source app.
    :type cloning_info: ~azure.mgmt.web.v2016_08_01.models.CloningInfo
    :param snapshot_info: If specified during app creation, the app is created from a previous
     snapshot.
    :type snapshot_info: ~azure.mgmt.web.v2016_08_01.models.SnapshotRecoveryRequest
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2016_08_01.models.SlotSwapStatus
    :param https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :type https_only: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'host_names': {'readonly': True},
        'repository_site_name': {'readonly': True},
        'usage_state': {'readonly': True},
        'enabled_host_names': {'readonly': True},
        'availability_state': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'traffic_manager_host_names': {'readonly': True},
        'target_swap_slot': {'readonly': True},
        'outbound_ip_addresses': {'readonly': True},
        'possible_outbound_ip_addresses': {'readonly': True},
        'suspended_till': {'readonly': True},
        'max_number_of_workers': {'readonly': True},
        'resource_group': {'readonly': True},
        'is_default_container': {'readonly': True},
        'default_host_name': {'readonly': True},
        'slot_swap_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'repository_site_name': {'key': 'properties.repositorySiteName', 'type': 'str'},
        'usage_state': {'key': 'properties.usageState', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'enabled_host_names': {'key': 'properties.enabledHostNames', 'type': '[str]'},
        'availability_state': {'key': 'properties.availabilityState', 'type': 'str'},
        'host_name_ssl_states': {'key': 'properties.hostNameSslStates', 'type': '[HostNameSslState]'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'site_config': {'key': 'properties.siteConfig', 'type': 'SiteConfig'},
        'traffic_manager_host_names': {'key': 'properties.trafficManagerHostNames', 'type': '[str]'},
        'scm_site_also_stopped': {'key': 'properties.scmSiteAlsoStopped', 'type': 'bool'},
        'target_swap_slot': {'key': 'properties.targetSwapSlot', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'client_affinity_enabled': {'key': 'properties.clientAffinityEnabled', 'type': 'bool'},
        'client_cert_enabled': {'key': 'properties.clientCertEnabled', 'type': 'bool'},
        'host_names_disabled': {'key': 'properties.hostNamesDisabled', 'type': 'bool'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': 'str'},
        'possible_outbound_ip_addresses': {'key': 'properties.possibleOutboundIpAddresses', 'type': 'str'},
        'container_size': {'key': 'properties.containerSize', 'type': 'int'},
        'daily_memory_time_quota': {'key': 'properties.dailyMemoryTimeQuota', 'type': 'int'},
        'suspended_till': {'key': 'properties.suspendedTill', 'type': 'iso-8601'},
        'max_number_of_workers': {'key': 'properties.maxNumberOfWorkers', 'type': 'int'},
        'cloning_info': {'key': 'properties.cloningInfo', 'type': 'CloningInfo'},
        'snapshot_info': {'key': 'properties.snapshotInfo', 'type': 'SnapshotRecoveryRequest'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'is_default_container': {'key': 'properties.isDefaultContainer', 'type': 'bool'},
        'default_host_name': {'key': 'properties.defaultHostName', 'type': 'str'},
        'slot_swap_status': {'key': 'properties.slotSwapStatus', 'type': 'SlotSwapStatus'},
        'https_only': {'key': 'properties.httpsOnly', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SitePatchResource, self).__init__(**kwargs)
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = kwargs.get('enabled', None)
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = kwargs.get('host_name_ssl_states', None)
        self.server_farm_id = kwargs.get('server_farm_id', None)
        self.reserved = kwargs.get('reserved', False)
        self.last_modified_time_utc = None
        self.site_config = kwargs.get('site_config', None)
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = kwargs.get('scm_site_also_stopped', False)
        self.target_swap_slot = None
        self.hosting_environment_profile = kwargs.get('hosting_environment_profile', None)
        self.client_affinity_enabled = kwargs.get('client_affinity_enabled', None)
        self.client_cert_enabled = kwargs.get('client_cert_enabled', None)
        self.host_names_disabled = kwargs.get('host_names_disabled', None)
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = kwargs.get('container_size', None)
        self.daily_memory_time_quota = kwargs.get('daily_memory_time_quota', None)
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = kwargs.get('cloning_info', None)
        self.snapshot_info = kwargs.get('snapshot_info', None)
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = kwargs.get('https_only', None)


class SitePhpErrorLogFlag(ProxyOnlyResource):
    """Used for getting PHP error logging flag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param local_log_errors: Local log_errors setting.
    :type local_log_errors: str
    :param master_log_errors: Master log_errors setting.
    :type master_log_errors: str
    :param local_log_errors_max_length: Local log_errors_max_len setting.
    :type local_log_errors_max_length: str
    :param master_log_errors_max_length: Master log_errors_max_len setting.
    :type master_log_errors_max_length: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'local_log_errors': {'key': 'properties.localLogErrors', 'type': 'str'},
        'master_log_errors': {'key': 'properties.masterLogErrors', 'type': 'str'},
        'local_log_errors_max_length': {'key': 'properties.localLogErrorsMaxLength', 'type': 'str'},
        'master_log_errors_max_length': {'key': 'properties.masterLogErrorsMaxLength', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SitePhpErrorLogFlag, self).__init__(**kwargs)
        self.local_log_errors = kwargs.get('local_log_errors', None)
        self.master_log_errors = kwargs.get('master_log_errors', None)
        self.local_log_errors_max_length = kwargs.get('local_log_errors_max_length', None)
        self.master_log_errors_max_length = kwargs.get('master_log_errors_max_length', None)


class SiteSourceControl(ProxyOnlyResource):
    """Source control configuration for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param repo_url: Repository or source control URL.
    :type repo_url: str
    :param branch: Name of branch to use for deployment.
    :type branch: str
    :param is_manual_integration: :code:`<code>true</code>` to limit to manual integration;
     :code:`<code>false</code>` to enable continuous integration (which configures webhooks into
     online repos like GitHub).
    :type is_manual_integration: bool
    :param deployment_rollback_enabled: :code:`<code>true</code>` to enable deployment rollback;
     otherwise, :code:`<code>false</code>`.
    :type deployment_rollback_enabled: bool
    :param is_mercurial: :code:`<code>true</code>` for a Mercurial repository;
     :code:`<code>false</code>` for a Git repository.
    :type is_mercurial: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'repo_url': {'key': 'properties.repoUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'is_manual_integration': {'key': 'properties.isManualIntegration', 'type': 'bool'},
        'deployment_rollback_enabled': {'key': 'properties.deploymentRollbackEnabled', 'type': 'bool'},
        'is_mercurial': {'key': 'properties.isMercurial', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteSourceControl, self).__init__(**kwargs)
        self.repo_url = kwargs.get('repo_url', None)
        self.branch = kwargs.get('branch', None)
        self.is_manual_integration = kwargs.get('is_manual_integration', None)
        self.deployment_rollback_enabled = kwargs.get('deployment_rollback_enabled', None)
        self.is_mercurial = kwargs.get('is_mercurial', None)


class SlotConfigNamesResource(ProxyOnlyResource):
    """Slot Config names azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param connection_string_names: List of connection string names.
    :type connection_string_names: list[str]
    :param app_setting_names: List of application settings names.
    :type app_setting_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'connection_string_names': {'key': 'properties.connectionStringNames', 'type': '[str]'},
        'app_setting_names': {'key': 'properties.appSettingNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SlotConfigNamesResource, self).__init__(**kwargs)
        self.connection_string_names = kwargs.get('connection_string_names', None)
        self.app_setting_names = kwargs.get('app_setting_names', None)


class SlotDifference(ProxyOnlyResource):
    """A setting difference between two deployment slots of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar type_properties_type: Type of the difference: Information, Warning or Error.
    :vartype type_properties_type: str
    :ivar setting_type: The type of the setting: General, AppSetting or ConnectionString.
    :vartype setting_type: str
    :ivar diff_rule: Rule that describes how to process the setting difference during a slot swap.
    :vartype diff_rule: str
    :ivar setting_name: Name of the setting.
    :vartype setting_name: str
    :ivar value_in_current_slot: Value of the setting in the current slot.
    :vartype value_in_current_slot: str
    :ivar value_in_target_slot: Value of the setting in the target slot.
    :vartype value_in_target_slot: str
    :ivar description: Description of the setting difference.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'type_properties_type': {'readonly': True},
        'setting_type': {'readonly': True},
        'diff_rule': {'readonly': True},
        'setting_name': {'readonly': True},
        'value_in_current_slot': {'readonly': True},
        'value_in_target_slot': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'setting_type': {'key': 'properties.settingType', 'type': 'str'},
        'diff_rule': {'key': 'properties.diffRule', 'type': 'str'},
        'setting_name': {'key': 'properties.settingName', 'type': 'str'},
        'value_in_current_slot': {'key': 'properties.valueInCurrentSlot', 'type': 'str'},
        'value_in_target_slot': {'key': 'properties.valueInTargetSlot', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SlotDifference, self).__init__(**kwargs)
        self.type_properties_type = None
        self.setting_type = None
        self.diff_rule = None
        self.setting_name = None
        self.value_in_current_slot = None
        self.value_in_target_slot = None
        self.description = None


class SlotDifferenceCollection(msrest.serialization.Model):
    """Collection of slot differences.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.SlotDifference]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SlotDifference]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SlotDifferenceCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class SlotSwapStatus(msrest.serialization.Model):
    """The status of the last successful slot swap operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp_utc: The time the last successful slot swap completed.
    :vartype timestamp_utc: ~datetime.datetime
    :ivar source_slot_name: The source slot of the last swap operation.
    :vartype source_slot_name: str
    :ivar destination_slot_name: The destination slot of the last swap operation.
    :vartype destination_slot_name: str
    """

    _validation = {
        'timestamp_utc': {'readonly': True},
        'source_slot_name': {'readonly': True},
        'destination_slot_name': {'readonly': True},
    }

    _attribute_map = {
        'timestamp_utc': {'key': 'timestampUtc', 'type': 'iso-8601'},
        'source_slot_name': {'key': 'sourceSlotName', 'type': 'str'},
        'destination_slot_name': {'key': 'destinationSlotName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SlotSwapStatus, self).__init__(**kwargs)
        self.timestamp_utc = None
        self.source_slot_name = None
        self.destination_slot_name = None


class SlowRequestsBasedTrigger(msrest.serialization.Model):
    """Trigger based on request execution time.

    :param time_taken: Time taken.
    :type time_taken: str
    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'time_taken': {'key': 'timeTaken', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SlowRequestsBasedTrigger, self).__init__(**kwargs)
        self.time_taken = kwargs.get('time_taken', None)
        self.count = kwargs.get('count', None)
        self.time_interval = kwargs.get('time_interval', None)


class Snapshot(ProxyOnlyResource):
    """A snapshot of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Snapshot, self).__init__(**kwargs)
        self.time = None


class SnapshotCollection(msrest.serialization.Model):
    """Collection of snapshots which can be used to revert an app to a previous time.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.Snapshot]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Snapshot]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SnapshotCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class SnapshotRecoveryRequest(ProxyOnlyResource):
    """Details about app recovery operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param snapshot_time: Point in time in which the app recovery should be attempted, formatted as
     a DateTime string.
    :type snapshot_time: str
    :param recovery_target: Specifies the web app that snapshot contents will be written to.
    :type recovery_target: ~azure.mgmt.web.v2016_08_01.models.SnapshotRecoveryTarget
    :param overwrite: If :code:`<code>true</code>` the recovery operation can overwrite source app;
     otherwise, :code:`<code>false</code>`.
    :type overwrite: bool
    :param recover_configuration: If true, site configuration, in addition to content, will be
     reverted.
    :type recover_configuration: bool
    :param ignore_conflicting_host_names: If true, custom hostname conflicts will be ignored when
     recovering to a target web app.
     This setting is only necessary when RecoverConfiguration is enabled.
    :type ignore_conflicting_host_names: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'snapshot_time': {'key': 'properties.snapshotTime', 'type': 'str'},
        'recovery_target': {'key': 'properties.recoveryTarget', 'type': 'SnapshotRecoveryTarget'},
        'overwrite': {'key': 'properties.overwrite', 'type': 'bool'},
        'recover_configuration': {'key': 'properties.recoverConfiguration', 'type': 'bool'},
        'ignore_conflicting_host_names': {'key': 'properties.ignoreConflictingHostNames', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SnapshotRecoveryRequest, self).__init__(**kwargs)
        self.snapshot_time = kwargs.get('snapshot_time', None)
        self.recovery_target = kwargs.get('recovery_target', None)
        self.overwrite = kwargs.get('overwrite', None)
        self.recover_configuration = kwargs.get('recover_configuration', None)
        self.ignore_conflicting_host_names = kwargs.get('ignore_conflicting_host_names', None)


class SnapshotRecoveryTarget(msrest.serialization.Model):
    """Specifies the web app that snapshot contents will be written to.

    :param location: Geographical location of the target web app, e.g. SouthEastAsia,
     SouthCentralUS.
    :type location: str
    :param id: ARM resource ID of the target app.
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :type id: str
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SnapshotRecoveryTarget, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.id = kwargs.get('id', None)


class StatusCodesBasedTrigger(msrest.serialization.Model):
    """Trigger based on status code.

    :param status: HTTP status code.
    :type status: int
    :param sub_status: Request Sub Status.
    :type sub_status: int
    :param win32_status: Win32 error code.
    :type win32_status: int
    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'int'},
        'sub_status': {'key': 'subStatus', 'type': 'int'},
        'win32_status': {'key': 'win32Status', 'type': 'int'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StatusCodesBasedTrigger, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.sub_status = kwargs.get('sub_status', None)
        self.win32_status = kwargs.get('win32_status', None)
        self.count = kwargs.get('count', None)
        self.time_interval = kwargs.get('time_interval', None)


class StorageMigrationOptions(ProxyOnlyResource):
    """Options for app content migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param azurefiles_connection_string: AzureFiles connection string.
    :type azurefiles_connection_string: str
    :param azurefiles_share: AzureFiles share.
    :type azurefiles_share: str
    :param switch_site_after_migration: :code:`<code>true</code>`if the app should be switched
     over; otherwise, :code:`<code>false</code>`.
    :type switch_site_after_migration: bool
    :param block_write_access_to_site: :code:`<code>true</code>` if the app should be read only
     during copy operation; otherwise, :code:`<code>false</code>`.
    :type block_write_access_to_site: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'azurefiles_connection_string': {'key': 'properties.azurefilesConnectionString', 'type': 'str'},
        'azurefiles_share': {'key': 'properties.azurefilesShare', 'type': 'str'},
        'switch_site_after_migration': {'key': 'properties.switchSiteAfterMigration', 'type': 'bool'},
        'block_write_access_to_site': {'key': 'properties.blockWriteAccessToSite', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageMigrationOptions, self).__init__(**kwargs)
        self.azurefiles_connection_string = kwargs.get('azurefiles_connection_string', None)
        self.azurefiles_share = kwargs.get('azurefiles_share', None)
        self.switch_site_after_migration = kwargs.get('switch_site_after_migration', False)
        self.block_write_access_to_site = kwargs.get('block_write_access_to_site', False)


class StorageMigrationResponse(ProxyOnlyResource):
    """Response for a migration of app content request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar operation_id: When server starts the migration process, it will return an operation ID
     identifying that particular migration operation.
    :vartype operation_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageMigrationResponse, self).__init__(**kwargs)
        self.operation_id = None


class StringDictionary(ProxyOnlyResource):
    """String dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: Settings.
    :type properties: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StringDictionary, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class TriggeredJobHistory(ProxyOnlyResource):
    """Triggered Web Job History. List of Triggered Web Job Run Information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param triggered_job_runs: List of triggered web job runs.
    :type triggered_job_runs: list[~azure.mgmt.web.v2016_08_01.models.TriggeredJobRun]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'triggered_job_runs': {'key': 'properties.triggeredJobRuns', 'type': '[TriggeredJobRun]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggeredJobHistory, self).__init__(**kwargs)
        self.triggered_job_runs = kwargs.get('triggered_job_runs', None)


class TriggeredJobHistoryCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.TriggeredJobHistory]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TriggeredJobHistory]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggeredJobHistoryCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class TriggeredJobRun(ProxyOnlyResource):
    """Triggered Web Job Run Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param id_properties_id: Job ID.
    :type id_properties_id: str
    :ivar name_properties_name: Job name.
    :vartype name_properties_name: str
    :param status: Job status. Possible values include: "Success", "Failed", "Error".
    :type status: str or ~azure.mgmt.web.v2016_08_01.models.TriggeredWebJobStatus
    :param start_time: Start time.
    :type start_time: ~datetime.datetime
    :param end_time: End time.
    :type end_time: ~datetime.datetime
    :param duration: Job duration.
    :type duration: str
    :param output_url: Output URL.
    :type output_url: str
    :param error_url: Error URL.
    :type error_url: str
    :param url: Job URL.
    :type url: str
    :param job_name: Job name.
    :type job_name: str
    :param trigger: Job trigger.
    :type trigger: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'duration': {'key': 'properties.duration', 'type': 'str'},
        'output_url': {'key': 'properties.outputUrl', 'type': 'str'},
        'error_url': {'key': 'properties.errorUrl', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'job_name': {'key': 'properties.jobName', 'type': 'str'},
        'trigger': {'key': 'properties.trigger', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggeredJobRun, self).__init__(**kwargs)
        self.id_properties_id = kwargs.get('id_properties_id', None)
        self.name_properties_name = None
        self.status = kwargs.get('status', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.duration = kwargs.get('duration', None)
        self.output_url = kwargs.get('output_url', None)
        self.error_url = kwargs.get('error_url', None)
        self.url = kwargs.get('url', None)
        self.job_name = kwargs.get('job_name', None)
        self.trigger = kwargs.get('trigger', None)


class TriggeredWebJob(ProxyOnlyResource):
    """Triggered Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param latest_run: Latest job run information.
    :type latest_run: ~azure.mgmt.web.v2016_08_01.models.TriggeredJobRun
    :param history_url: History URL.
    :type history_url: str
    :param scheduler_logs_url: Scheduler Logs URL.
    :type scheduler_logs_url: str
    :ivar name_properties_name: Job name. Used as job identifier in ARM resource URI.
    :vartype name_properties_name: str
    :param run_command: Run command.
    :type run_command: str
    :param url: Job URL.
    :type url: str
    :param extra_info_url: Extra Info URL.
    :type extra_info_url: str
    :param job_type: Job type. Possible values include: "Continuous", "Triggered".
    :type job_type: str or ~azure.mgmt.web.v2016_08_01.models.WebJobType
    :param error: Error information.
    :type error: str
    :param using_sdk: Using SDK?.
    :type using_sdk: bool
    :param settings: Job settings.
    :type settings: dict[str, object]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'latest_run': {'key': 'properties.latestRun', 'type': 'TriggeredJobRun'},
        'history_url': {'key': 'properties.historyUrl', 'type': 'str'},
        'scheduler_logs_url': {'key': 'properties.schedulerLogsUrl', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'run_command': {'key': 'properties.runCommand', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extraInfoUrl', 'type': 'str'},
        'job_type': {'key': 'properties.jobType', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.usingSdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggeredWebJob, self).__init__(**kwargs)
        self.latest_run = kwargs.get('latest_run', None)
        self.history_url = kwargs.get('history_url', None)
        self.scheduler_logs_url = kwargs.get('scheduler_logs_url', None)
        self.name_properties_name = None
        self.run_command = kwargs.get('run_command', None)
        self.url = kwargs.get('url', None)
        self.extra_info_url = kwargs.get('extra_info_url', None)
        self.job_type = kwargs.get('job_type', None)
        self.error = kwargs.get('error', None)
        self.using_sdk = kwargs.get('using_sdk', None)
        self.settings = kwargs.get('settings', None)


class TriggeredWebJobCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.TriggeredWebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TriggeredWebJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggeredWebJobCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class User(ProxyOnlyResource):
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param user_name: Username.
    :type user_name: str
    :param publishing_user_name: Username used for publishing.
    :type publishing_user_name: str
    :param publishing_password: Password used for publishing.
    :type publishing_password: str
    :param publishing_password_hash: Password hash used for publishing.
    :type publishing_password_hash: str
    :param publishing_password_hash_salt: Password hash salt used for publishing.
    :type publishing_password_hash_salt: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_name': {'key': 'properties.name', 'type': 'str'},
        'publishing_user_name': {'key': 'properties.publishingUserName', 'type': 'str'},
        'publishing_password': {'key': 'properties.publishingPassword', 'type': 'str'},
        'publishing_password_hash': {'key': 'properties.publishingPasswordHash', 'type': 'str'},
        'publishing_password_hash_salt': {'key': 'properties.publishingPasswordHashSalt', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(User, self).__init__(**kwargs)
        self.user_name = kwargs.get('user_name', None)
        self.publishing_user_name = kwargs.get('publishing_user_name', None)
        self.publishing_password = kwargs.get('publishing_password', None)
        self.publishing_password_hash = kwargs.get('publishing_password_hash', None)
        self.publishing_password_hash_salt = kwargs.get('publishing_password_hash_salt', None)


class VirtualApplication(msrest.serialization.Model):
    """Virtual application in an app.

    :param virtual_path: Virtual path.
    :type virtual_path: str
    :param physical_path: Physical path.
    :type physical_path: str
    :param preload_enabled: :code:`<code>true</code>` if preloading is enabled; otherwise,
     :code:`<code>false</code>`.
    :type preload_enabled: bool
    :param virtual_directories: Virtual directories for virtual application.
    :type virtual_directories: list[~azure.mgmt.web.v2016_08_01.models.VirtualDirectory]
    """

    _attribute_map = {
        'virtual_path': {'key': 'virtualPath', 'type': 'str'},
        'physical_path': {'key': 'physicalPath', 'type': 'str'},
        'preload_enabled': {'key': 'preloadEnabled', 'type': 'bool'},
        'virtual_directories': {'key': 'virtualDirectories', 'type': '[VirtualDirectory]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualApplication, self).__init__(**kwargs)
        self.virtual_path = kwargs.get('virtual_path', None)
        self.physical_path = kwargs.get('physical_path', None)
        self.preload_enabled = kwargs.get('preload_enabled', None)
        self.virtual_directories = kwargs.get('virtual_directories', None)


class VirtualDirectory(msrest.serialization.Model):
    """Directory for virtual application.

    :param virtual_path: Path to virtual application.
    :type virtual_path: str
    :param physical_path: Physical path.
    :type physical_path: str
    """

    _attribute_map = {
        'virtual_path': {'key': 'virtualPath', 'type': 'str'},
        'physical_path': {'key': 'physicalPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualDirectory, self).__init__(**kwargs)
        self.virtual_path = kwargs.get('virtual_path', None)
        self.physical_path = kwargs.get('physical_path', None)


class VnetGateway(ProxyOnlyResource):
    """The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_name: The Virtual Network name.
    :type vnet_name: str
    :param vpn_package_uri: The URI where the VPN package can be downloaded.
    :type vpn_package_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vpn_package_uri': {'key': 'properties.vpnPackageUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VnetGateway, self).__init__(**kwargs)
        self.vnet_name = kwargs.get('vnet_name', None)
        self.vpn_package_uri = kwargs.get('vpn_package_uri', None)


class VnetInfo(ProxyOnlyResource):
    """Virtual Network information contract.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_resource_id: The Virtual Network's resource ID.
    :type vnet_resource_id: str
    :ivar cert_thumbprint: The client certificate thumbprint.
    :vartype cert_thumbprint: str
    :param cert_blob: A certificate file (.cer) blob containing the public key of the private key
     used to authenticate a
     Point-To-Site VPN connection.
    :type cert_blob: bytearray
    :ivar routes: The routes that this Virtual Network connection uses.
    :vartype routes: list[~azure.mgmt.web.v2016_08_01.models.VnetRoute]
    :ivar resync_required: :code:`<code>true</code>` if a resync is required; otherwise,
     :code:`<code>false</code>`.
    :vartype resync_required: bool
    :param dns_servers: DNS servers to be used by this Virtual Network. This should be a comma-
     separated list of IP addresses.
    :type dns_servers: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'cert_thumbprint': {'readonly': True},
        'routes': {'readonly': True},
        'resync_required': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_resource_id': {'key': 'properties.vnetResourceId', 'type': 'str'},
        'cert_thumbprint': {'key': 'properties.certThumbprint', 'type': 'str'},
        'cert_blob': {'key': 'properties.certBlob', 'type': 'bytearray'},
        'routes': {'key': 'properties.routes', 'type': '[VnetRoute]'},
        'resync_required': {'key': 'properties.resyncRequired', 'type': 'bool'},
        'dns_servers': {'key': 'properties.dnsServers', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VnetInfo, self).__init__(**kwargs)
        self.vnet_resource_id = kwargs.get('vnet_resource_id', None)
        self.cert_thumbprint = None
        self.cert_blob = kwargs.get('cert_blob', None)
        self.routes = None
        self.resync_required = None
        self.dns_servers = kwargs.get('dns_servers', None)


class VnetRoute(ProxyOnlyResource):
    """Virtual Network route contract used to pass routing information for a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_route_name: The name of this route. This is only returned by the server and does
     not need to be set by the client.
    :type vnet_route_name: str
    :param start_address: The starting address for this route. This may also include a CIDR
     notation, in which case the end address must not be specified.
    :type start_address: str
    :param end_address: The ending address for this route. If the start address is specified in
     CIDR notation, this must be omitted.
    :type end_address: str
    :param route_type: The type of route this is:
     DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
     INHERITED - Routes inherited from the real Virtual Network routes
     STATIC - Static route set on the app only
    
     These values will be used for syncing an app's routes with those from a Virtual Network.
     Possible values include: "DEFAULT", "INHERITED", "STATIC".
    :type route_type: str or ~azure.mgmt.web.v2016_08_01.models.RouteType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_route_name': {'key': 'properties.name', 'type': 'str'},
        'start_address': {'key': 'properties.startAddress', 'type': 'str'},
        'end_address': {'key': 'properties.endAddress', 'type': 'str'},
        'route_type': {'key': 'properties.routeType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VnetRoute, self).__init__(**kwargs)
        self.vnet_route_name = kwargs.get('vnet_route_name', None)
        self.start_address = kwargs.get('start_address', None)
        self.end_address = kwargs.get('end_address', None)
        self.route_type = kwargs.get('route_type', None)


class WebAppCollection(msrest.serialization.Model):
    """Collection of App Service apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.Site]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Site]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebAppCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class WebAppInstanceCollection(msrest.serialization.Model):
    """Collection of app instances.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.SiteInstance]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteInstance]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebAppInstanceCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class WebJob(ProxyOnlyResource):
    """Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Job name. Used as job identifier in ARM resource URI.
    :vartype name_properties_name: str
    :param run_command: Run command.
    :type run_command: str
    :param url: Job URL.
    :type url: str
    :param extra_info_url: Extra Info URL.
    :type extra_info_url: str
    :param job_type: Job type. Possible values include: "Continuous", "Triggered".
    :type job_type: str or ~azure.mgmt.web.v2016_08_01.models.WebJobType
    :param error: Error information.
    :type error: str
    :param using_sdk: Using SDK?.
    :type using_sdk: bool
    :param settings: Job settings.
    :type settings: dict[str, object]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'run_command': {'key': 'properties.runCommand', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extraInfoUrl', 'type': 'str'},
        'job_type': {'key': 'properties.jobType', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.usingSdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebJob, self).__init__(**kwargs)
        self.name_properties_name = None
        self.run_command = kwargs.get('run_command', None)
        self.url = kwargs.get('url', None)
        self.extra_info_url = kwargs.get('extra_info_url', None)
        self.job_type = kwargs.get('job_type', None)
        self.error = kwargs.get('error', None)
        self.using_sdk = kwargs.get('using_sdk', None)
        self.settings = kwargs.get('settings', None)


class WebJobCollection(msrest.serialization.Model):
    """Collection of Kudu web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2016_08_01.models.WebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WebJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebJobCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None
