/*
 * Decompiled with CFR 0.152.
 */
package gnu.commonlisp.lang;

import gnu.bytecode.Type;
import gnu.commonlisp.lang.Lisp2;
import gnu.commonlisp.lang.UnwindProtect;
import gnu.commonlisp.lang.defun;
import gnu.commonlisp.lang.defvar;
import gnu.commonlisp.lang.function;
import gnu.commonlisp.lang.prog1;
import gnu.commonlisp.lang.setq;
import gnu.expr.Language;
import gnu.kawa.functions.DisplayFormat;
import gnu.kawa.functions.IsEq;
import gnu.kawa.functions.IsEqual;
import gnu.kawa.functions.NumberCompare;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.reflect.InstanceOf;
import gnu.lists.AbstractFormat;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.LocationEnumeration;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.text.Char;
import kawa.lang.Lambda;
import kawa.standard.Scheme;
import kawa.standard.begin;
import kawa.standard.not;

public class CommonLisp
extends Lisp2 {
    static boolean charIsInt = false;
    public static final CommonLisp instance;
    public static final Environment clispEnvironment;
    public static final NumberCompare numEqu;
    public static final NumberCompare numGrt;
    public static final NumberCompare numGEq;
    public static final NumberCompare numLss;
    public static final NumberCompare numLEq;
    static final AbstractFormat writeFormat;
    static final AbstractFormat displayFormat;
    LangPrimType booleanType;

    public static Object getCharacter(int c) {
        if (charIsInt) {
            return IntNum.make(c);
        }
        return Char.make((char)c);
    }

    public static Numeric asNumber(Object arg) {
        if (arg instanceof Char) {
            return IntNum.make(((Char)arg).intValue());
        }
        return (Numeric)arg;
    }

    public static char asChar(Object x) {
        if (x instanceof Char) {
            return ((Char)x).charValue();
        }
        int i = x instanceof Numeric ? ((Numeric)x).intValue() : -1;
        if (i < 0 || i > 65535) {
            throw new ClassCastException("not a character value");
        }
        return (char)i;
    }

    public String getName() {
        return "CommonLisp";
    }

    public CommonLisp() {
        this.environ = clispEnvironment;
    }

    void initLisp() {
        LocationEnumeration e = Scheme.builtin().enumerateAllLocations();
        while (e.hasMoreElements()) {
            this.importLocation(e.nextLocation());
        }
        try {
            this.loadClass("kawa.lib.prim_syntax");
            this.loadClass("kawa.lib.std_syntax");
            this.loadClass("kawa.lib.lists");
            this.loadClass("kawa.lib.strings");
            this.loadClass("gnu.commonlisp.lisp.PrimOps");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        Lambda lambda = new Lambda();
        lambda.setKeywords(CommonLisp.asSymbol("&optional"), CommonLisp.asSymbol("&rest"), CommonLisp.asSymbol("&key"));
        lambda.defaultDefault = nilExpr;
        this.defun("lambda", (Object)lambda);
        this.defun("defun", (Object)new defun(lambda));
        this.defun("defvar", (Object)new defvar(false));
        this.defun("defconst", (Object)new defvar(true));
        this.defun("defsubst", (Object)new defun(lambda));
        this.defun("function", (Object)new function(lambda));
        this.defun("setq", (Object)new setq());
        this.defun("prog1", (Object)new prog1("prog1", 1));
        this.defun("prog2", (Object)prog1.prog2);
        this.defun("progn", (Object)new begin());
        this.defun("unwind-protect", (Object)new UnwindProtect());
        not not2 = new not(this);
        this.defun("not", (Object)not2);
        this.defun("null", (Object)not2);
        this.defun("eq", (Object)new IsEq(this, "eq"));
        this.defun("equal", (Object)new IsEqual(this, "equal"));
        this.defun("typep", (Object)new InstanceOf(this));
        this.defun("princ", (Object)displayFormat);
        this.defun("prin1", (Object)writeFormat);
        this.defProcStFld("=", "gnu.commonlisp.lang.CommonLisp", "numEqu");
        this.defProcStFld("<", "gnu.commonlisp.lang.CommonLisp", "numLss");
        this.defProcStFld(">", "gnu.commonlisp.lang.CommonLisp", "numGrt");
        this.defProcStFld("<=", "gnu.commonlisp.lang.CommonLisp", "numLEq");
        this.defProcStFld(">=", "gnu.commonlisp.lang.CommonLisp", "numGEq");
        this.defProcStFld("functionp", "gnu.commonlisp.lisp.PrimOps");
    }

    public static CommonLisp getInstance() {
        return instance;
    }

    public static void registerEnvironment() {
        Language.setDefaults(instance);
    }

    public AbstractFormat getFormat(boolean readable) {
        return readable ? writeFormat : displayFormat;
    }

    public Type getTypeFor(String name) {
        if (name == "t") {
            name = "java.lang.Object";
        }
        return Scheme.string2Type(name);
    }

    public Type getTypeFor(Class clas) {
        if (clas.isPrimitive()) {
            String name = clas.getName();
            if (name.equals("boolean")) {
                if (this.booleanType == null) {
                    this.booleanType = new LangPrimType(Type.boolean_type, this);
                }
                return this.booleanType;
            }
            return Scheme.getNamedType(name);
        }
        return Type.make(clas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        clispEnvironment = Environment.make("clisp-environment");
        instance = new CommonLisp();
        instance.define("t", TRUE);
        instance.define("nil", FALSE);
        numEqu = NumberCompare.make(instance, "=", 8);
        numGrt = NumberCompare.make(instance, ">", 16);
        numGEq = NumberCompare.make(instance, ">=", 24);
        numLss = NumberCompare.make(instance, "<", 4);
        numLEq = NumberCompare.make(instance, "<=", 12);
        CallContext ctx = CallContext.getInstance();
        Environment saveEnv = ctx.getEnvironmentRaw();
        try {
            ctx.setEnvironmentRaw(clispEnvironment);
            instance.initLisp();
        }
        finally {
            ctx.setEnvironmentRaw(saveEnv);
        }
        writeFormat = new DisplayFormat(true, 'C');
        displayFormat = new DisplayFormat(false, 'C');
    }
}

