# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MatchRecord(Model):
    """MatchRecord.

    :param wikipedia_score: (optional) If a well-known item with Wikipedia
     link is recognized, a decimal number denoting the confidence level of the
     Wikipedia info will be returned.
    :type wikipedia_score: float
    :param entity_type_score: (optional) If an entity type is recognized, a
     decimal number denoting the confidence level of the entity type will be
     returned.
    :type entity_type_score: float
    :param text: Entity text as appears in the request.
    :type text: str
    :param offset: Start position (in Unicode characters) for the entity match
     text.
    :type offset: int
    :param length: Length (in Unicode characters) for the entity match text.
    :type length: int
    """

    _attribute_map = {
        'wikipedia_score': {'key': 'wikipediaScore', 'type': 'float'},
        'entity_type_score': {'key': 'entityTypeScore', 'type': 'float'},
        'text': {'key': 'text', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(MatchRecord, self).__init__(**kwargs)
        self.wikipedia_score = kwargs.get('wikipedia_score', None)
        self.entity_type_score = kwargs.get('entity_type_score', None)
        self.text = kwargs.get('text', None)
        self.offset = kwargs.get('offset', None)
        self.length = kwargs.get('length', None)
