# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._data_share_management_client_enums import *


class DefaultDto(msrest.serialization.Model):
    """Base data transfer object implementation for default resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :param location: Location of the azure resource.
    :type location: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :param tags: A set of tags. Tags on the azure resource.
    :type tags: dict[str, str]
    :ivar type: Type of the azure resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(DefaultDto, self).__init__(**kwargs)
        self.id = None
        self.location = location
        self.name = None
        self.tags = tags
        self.type = None


class Account(DefaultDto):
    """An account data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :param location: Location of the azure resource.
    :type location: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :param tags: A set of tags. Tags on the azure resource.
    :type tags: dict[str, str]
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param identity: Required. Identity Info on the Account.
    :type identity: ~azure.mgmt.datashare.models.Identity
    :ivar created_at: Time at which the account was created.
    :vartype created_at: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the Account. Possible values include:
     "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar user_email: Email of the user who created the resource.
    :vartype user_email: str
    :ivar user_name: Name of the user who created the resource.
    :vartype user_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'identity': {'required': True},
        'created_at': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'user_email': {'readonly': True},
        'user_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'type': {'key': 'type', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'user_email': {'key': 'properties.userEmail', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        identity: "Identity",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Account, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.created_at = None
        self.provisioning_state = None
        self.user_email = None
        self.user_name = None


class AccountList(msrest.serialization.Model):
    """List response for get Accounts.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.Account]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Account]'},
    }

    def __init__(
        self,
        *,
        value: List["Account"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AccountList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class AccountUpdateParameters(msrest.serialization.Model):
    """Update parameters for accounts.

    :param tags: A set of tags. Tags on the azure resource.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(AccountUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class ProxyDto(msrest.serialization.Model):
    """Base data transfer object implementation for proxy resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyDto, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class DataSet(ProxyDto):
    """A DataSet data transfer object.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ADLSGen1FileDataSet, ADLSGen1FolderDataSet, ADLSGen2FileDataSet, ADLSGen2FileSystemDataSet, ADLSGen2FolderDataSet, BlobDataSet, BlobFolderDataSet, BlobContainerDataSet, KustoClusterDataSet, KustoDatabaseDataSet, SqlDBTableDataSet, SqlDWTableDataSet.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set.Constant filled by server.  Possible values include:
     "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File",
     "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable",
     "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'AdlsGen1File': 'ADLSGen1FileDataSet', 'AdlsGen1Folder': 'ADLSGen1FolderDataSet', 'AdlsGen2File': 'ADLSGen2FileDataSet', 'AdlsGen2FileSystem': 'ADLSGen2FileSystemDataSet', 'AdlsGen2Folder': 'ADLSGen2FolderDataSet', 'Blob': 'BlobDataSet', 'BlobFolder': 'BlobFolderDataSet', 'Container': 'BlobContainerDataSet', 'KustoCluster': 'KustoClusterDataSet', 'KustoDatabase': 'KustoDatabaseDataSet', 'SqlDBTable': 'SqlDBTableDataSet', 'SqlDWTable': 'SqlDWTableDataSet'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataSet, self).__init__(**kwargs)
        self.kind = 'DataSet'  # type: str


class ADLSGen1FileDataSet(DataSet):
    """An ADLS Gen 1 file data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set.Constant filled by server.  Possible values include:
     "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File",
     "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable",
     "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param account_name: Required. The ADLS account name.
    :type account_name: str
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :param file_name: Required. The file name in the ADLS account.
    :type file_name: str
    :param folder_path: Required. The folder path within the ADLS account.
    :type folder_path: str
    :param resource_group: Required. Resource group of ADLS account.
    :type resource_group: str
    :param subscription_id: Required. Subscription id of ADLS account.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'account_name': {'required': True},
        'data_set_id': {'readonly': True},
        'file_name': {'required': True},
        'folder_path': {'required': True},
        'resource_group': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'account_name': {'key': 'properties.accountName', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'file_name': {'key': 'properties.fileName', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_name: str,
        file_name: str,
        folder_path: str,
        resource_group: str,
        subscription_id: str,
        **kwargs
    ):
        super(ADLSGen1FileDataSet, self).__init__(**kwargs)
        self.kind = 'AdlsGen1File'  # type: str
        self.account_name = account_name
        self.data_set_id = None
        self.file_name = file_name
        self.folder_path = folder_path
        self.resource_group = resource_group
        self.subscription_id = subscription_id


class ADLSGen1FolderDataSet(DataSet):
    """An ADLS Gen 1 folder data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set.Constant filled by server.  Possible values include:
     "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File",
     "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable",
     "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param account_name: Required. The ADLS account name.
    :type account_name: str
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :param folder_path: Required. The folder path within the ADLS account.
    :type folder_path: str
    :param resource_group: Required. Resource group of ADLS account.
    :type resource_group: str
    :param subscription_id: Required. Subscription id of ADLS account.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'account_name': {'required': True},
        'data_set_id': {'readonly': True},
        'folder_path': {'required': True},
        'resource_group': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'account_name': {'key': 'properties.accountName', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_name: str,
        folder_path: str,
        resource_group: str,
        subscription_id: str,
        **kwargs
    ):
        super(ADLSGen1FolderDataSet, self).__init__(**kwargs)
        self.kind = 'AdlsGen1Folder'  # type: str
        self.account_name = account_name
        self.data_set_id = None
        self.folder_path = folder_path
        self.resource_group = resource_group
        self.subscription_id = subscription_id


class ADLSGen2FileDataSet(DataSet):
    """An ADLS Gen 2 file data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set.Constant filled by server.  Possible values include:
     "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File",
     "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable",
     "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :param file_path: Required. File path within the file system.
    :type file_path: str
    :param file_system: Required. File system to which the file belongs.
    :type file_system: str
    :param resource_group: Required. Resource group of storage account.
    :type resource_group: str
    :param storage_account_name: Required. Storage account name of the source data set.
    :type storage_account_name: str
    :param subscription_id: Required. Subscription id of storage account.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'data_set_id': {'readonly': True},
        'file_path': {'required': True},
        'file_system': {'required': True},
        'resource_group': {'required': True},
        'storage_account_name': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'file_path': {'key': 'properties.filePath', 'type': 'str'},
        'file_system': {'key': 'properties.fileSystem', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'storage_account_name': {'key': 'properties.storageAccountName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        file_path: str,
        file_system: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        super(ADLSGen2FileDataSet, self).__init__(**kwargs)
        self.kind = 'AdlsGen2File'  # type: str
        self.data_set_id = None
        self.file_path = file_path
        self.file_system = file_system
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class DataSetMapping(ProxyDto):
    """A data set mapping data transfer object.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ADLSGen2FileDataSetMapping, ADLSGen2FileSystemDataSetMapping, ADLSGen2FolderDataSetMapping, BlobDataSetMapping, BlobFolderDataSetMapping, BlobContainerDataSetMapping, KustoClusterDataSetMapping, KustoDatabaseDataSetMapping, SqlDBTableDataSetMapping, SqlDWTableDataSetMapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set mapping.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'AdlsGen2File': 'ADLSGen2FileDataSetMapping', 'AdlsGen2FileSystem': 'ADLSGen2FileSystemDataSetMapping', 'AdlsGen2Folder': 'ADLSGen2FolderDataSetMapping', 'Blob': 'BlobDataSetMapping', 'BlobFolder': 'BlobFolderDataSetMapping', 'Container': 'BlobContainerDataSetMapping', 'KustoCluster': 'KustoClusterDataSetMapping', 'KustoDatabase': 'KustoDatabaseDataSetMapping', 'SqlDBTable': 'SqlDBTableDataSetMapping', 'SqlDWTable': 'SqlDWTableDataSetMapping'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataSetMapping, self).__init__(**kwargs)
        self.kind = 'DataSetMapping'  # type: str


class ADLSGen2FileDataSetMapping(DataSetMapping):
    """An ADLS Gen2 file data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set mapping.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param data_set_id: Required. The id of the source data set.
    :type data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Possible values
     include: "Ok", "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :param file_path: Required. File path within the file system.
    :type file_path: str
    :param file_system: Required. File system to which the file belongs.
    :type file_system: str
    :param output_type: Type of output file. Possible values include: "Csv", "Parquet".
    :type output_type: str or ~azure.mgmt.datashare.models.OutputType
    :ivar provisioning_state: Provisioning state of the data set mapping. Possible values include:
     "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :param resource_group: Required. Resource group of storage account.
    :type resource_group: str
    :param storage_account_name: Required. Storage account name of the source data set.
    :type storage_account_name: str
    :param subscription_id: Required. Subscription id of storage account.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'data_set_id': {'required': True},
        'data_set_mapping_status': {'readonly': True},
        'file_path': {'required': True},
        'file_system': {'required': True},
        'provisioning_state': {'readonly': True},
        'resource_group': {'required': True},
        'storage_account_name': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'data_set_mapping_status': {'key': 'properties.dataSetMappingStatus', 'type': 'str'},
        'file_path': {'key': 'properties.filePath', 'type': 'str'},
        'file_system': {'key': 'properties.fileSystem', 'type': 'str'},
        'output_type': {'key': 'properties.outputType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'storage_account_name': {'key': 'properties.storageAccountName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_set_id: str,
        file_path: str,
        file_system: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        output_type: Optional[Union[str, "OutputType"]] = None,
        **kwargs
    ):
        super(ADLSGen2FileDataSetMapping, self).__init__(**kwargs)
        self.kind = 'AdlsGen2File'  # type: str
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.file_path = file_path
        self.file_system = file_system
        self.output_type = output_type
        self.provisioning_state = None
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class ADLSGen2FileSystemDataSet(DataSet):
    """An ADLS Gen 2 file system data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set.Constant filled by server.  Possible values include:
     "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File",
     "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable",
     "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :param file_system: Required. The file system name.
    :type file_system: str
    :param resource_group: Required. Resource group of storage account.
    :type resource_group: str
    :param storage_account_name: Required. Storage account name of the source data set.
    :type storage_account_name: str
    :param subscription_id: Required. Subscription id of storage account.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'data_set_id': {'readonly': True},
        'file_system': {'required': True},
        'resource_group': {'required': True},
        'storage_account_name': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'file_system': {'key': 'properties.fileSystem', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'storage_account_name': {'key': 'properties.storageAccountName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        file_system: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        super(ADLSGen2FileSystemDataSet, self).__init__(**kwargs)
        self.kind = 'AdlsGen2FileSystem'  # type: str
        self.data_set_id = None
        self.file_system = file_system
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class ADLSGen2FileSystemDataSetMapping(DataSetMapping):
    """An ADLS Gen2 file system data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set mapping.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param data_set_id: Required. The id of the source data set.
    :type data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Possible values
     include: "Ok", "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :param file_system: Required. The file system name.
    :type file_system: str
    :ivar provisioning_state: Provisioning state of the data set mapping. Possible values include:
     "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :param resource_group: Required. Resource group of storage account.
    :type resource_group: str
    :param storage_account_name: Required. Storage account name of the source data set.
    :type storage_account_name: str
    :param subscription_id: Required. Subscription id of storage account.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'data_set_id': {'required': True},
        'data_set_mapping_status': {'readonly': True},
        'file_system': {'required': True},
        'provisioning_state': {'readonly': True},
        'resource_group': {'required': True},
        'storage_account_name': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'data_set_mapping_status': {'key': 'properties.dataSetMappingStatus', 'type': 'str'},
        'file_system': {'key': 'properties.fileSystem', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'storage_account_name': {'key': 'properties.storageAccountName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_set_id: str,
        file_system: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        super(ADLSGen2FileSystemDataSetMapping, self).__init__(**kwargs)
        self.kind = 'AdlsGen2FileSystem'  # type: str
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.file_system = file_system
        self.provisioning_state = None
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class ADLSGen2FolderDataSet(DataSet):
    """An ADLS Gen 2 folder data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set.Constant filled by server.  Possible values include:
     "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File",
     "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable",
     "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :param file_system: Required. File system to which the folder belongs.
    :type file_system: str
    :param folder_path: Required. Folder path within the file system.
    :type folder_path: str
    :param resource_group: Required. Resource group of storage account.
    :type resource_group: str
    :param storage_account_name: Required. Storage account name of the source data set.
    :type storage_account_name: str
    :param subscription_id: Required. Subscription id of storage account.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'data_set_id': {'readonly': True},
        'file_system': {'required': True},
        'folder_path': {'required': True},
        'resource_group': {'required': True},
        'storage_account_name': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'file_system': {'key': 'properties.fileSystem', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'storage_account_name': {'key': 'properties.storageAccountName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        file_system: str,
        folder_path: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        super(ADLSGen2FolderDataSet, self).__init__(**kwargs)
        self.kind = 'AdlsGen2Folder'  # type: str
        self.data_set_id = None
        self.file_system = file_system
        self.folder_path = folder_path
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class ADLSGen2FolderDataSetMapping(DataSetMapping):
    """An ADLS Gen2 folder data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set mapping.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param data_set_id: Required. The id of the source data set.
    :type data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Possible values
     include: "Ok", "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :param file_system: Required. File system to which the folder belongs.
    :type file_system: str
    :param folder_path: Required. Folder path within the file system.
    :type folder_path: str
    :ivar provisioning_state: Provisioning state of the data set mapping. Possible values include:
     "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :param resource_group: Required. Resource group of storage account.
    :type resource_group: str
    :param storage_account_name: Required. Storage account name of the source data set.
    :type storage_account_name: str
    :param subscription_id: Required. Subscription id of storage account.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'data_set_id': {'required': True},
        'data_set_mapping_status': {'readonly': True},
        'file_system': {'required': True},
        'folder_path': {'required': True},
        'provisioning_state': {'readonly': True},
        'resource_group': {'required': True},
        'storage_account_name': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'data_set_mapping_status': {'key': 'properties.dataSetMappingStatus', 'type': 'str'},
        'file_system': {'key': 'properties.fileSystem', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'storage_account_name': {'key': 'properties.storageAccountName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_set_id: str,
        file_system: str,
        folder_path: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        super(ADLSGen2FolderDataSetMapping, self).__init__(**kwargs)
        self.kind = 'AdlsGen2Folder'  # type: str
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.file_system = file_system
        self.folder_path = folder_path
        self.provisioning_state = None
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class BlobContainerDataSet(DataSet):
    """An Azure storage blob container data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set.Constant filled by server.  Possible values include:
     "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File",
     "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable",
     "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param container_name: Required. BLOB Container name.
    :type container_name: str
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :param resource_group: Required. Resource group of storage account.
    :type resource_group: str
    :param storage_account_name: Required. Storage account name of the source data set.
    :type storage_account_name: str
    :param subscription_id: Required. Subscription id of storage account.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'container_name': {'required': True},
        'data_set_id': {'readonly': True},
        'resource_group': {'required': True},
        'storage_account_name': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'container_name': {'key': 'properties.containerName', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'storage_account_name': {'key': 'properties.storageAccountName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_name: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        super(BlobContainerDataSet, self).__init__(**kwargs)
        self.kind = 'Container'  # type: str
        self.container_name = container_name
        self.data_set_id = None
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class BlobContainerDataSetMapping(DataSetMapping):
    """A Blob container data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set mapping.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param container_name: Required. BLOB Container name.
    :type container_name: str
    :param data_set_id: Required. The id of the source data set.
    :type data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Possible values
     include: "Ok", "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :ivar provisioning_state: Provisioning state of the data set mapping. Possible values include:
     "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :param resource_group: Required. Resource group of storage account.
    :type resource_group: str
    :param storage_account_name: Required. Storage account name of the source data set.
    :type storage_account_name: str
    :param subscription_id: Required. Subscription id of storage account.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'container_name': {'required': True},
        'data_set_id': {'required': True},
        'data_set_mapping_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_group': {'required': True},
        'storage_account_name': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'container_name': {'key': 'properties.containerName', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'data_set_mapping_status': {'key': 'properties.dataSetMappingStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'storage_account_name': {'key': 'properties.storageAccountName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_name: str,
        data_set_id: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        super(BlobContainerDataSetMapping, self).__init__(**kwargs)
        self.kind = 'Container'  # type: str
        self.container_name = container_name
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.provisioning_state = None
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class BlobDataSet(DataSet):
    """An Azure storage blob data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set.Constant filled by server.  Possible values include:
     "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File",
     "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable",
     "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param container_name: Required. Container that has the file path.
    :type container_name: str
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :param file_path: Required. File path within the source data set.
    :type file_path: str
    :param resource_group: Required. Resource group of storage account.
    :type resource_group: str
    :param storage_account_name: Required. Storage account name of the source data set.
    :type storage_account_name: str
    :param subscription_id: Required. Subscription id of storage account.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'container_name': {'required': True},
        'data_set_id': {'readonly': True},
        'file_path': {'required': True},
        'resource_group': {'required': True},
        'storage_account_name': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'container_name': {'key': 'properties.containerName', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'file_path': {'key': 'properties.filePath', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'storage_account_name': {'key': 'properties.storageAccountName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_name: str,
        file_path: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        super(BlobDataSet, self).__init__(**kwargs)
        self.kind = 'Blob'  # type: str
        self.container_name = container_name
        self.data_set_id = None
        self.file_path = file_path
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class BlobDataSetMapping(DataSetMapping):
    """A Blob data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set mapping.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param container_name: Required. Container that has the file path.
    :type container_name: str
    :param data_set_id: Required. The id of the source data set.
    :type data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Possible values
     include: "Ok", "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :param file_path: Required. File path within the source data set.
    :type file_path: str
    :param output_type: File output type. Possible values include: "Csv", "Parquet".
    :type output_type: str or ~azure.mgmt.datashare.models.OutputType
    :ivar provisioning_state: Provisioning state of the data set mapping. Possible values include:
     "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :param resource_group: Required. Resource group of storage account.
    :type resource_group: str
    :param storage_account_name: Required. Storage account name of the source data set.
    :type storage_account_name: str
    :param subscription_id: Required. Subscription id of storage account.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'container_name': {'required': True},
        'data_set_id': {'required': True},
        'data_set_mapping_status': {'readonly': True},
        'file_path': {'required': True},
        'provisioning_state': {'readonly': True},
        'resource_group': {'required': True},
        'storage_account_name': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'container_name': {'key': 'properties.containerName', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'data_set_mapping_status': {'key': 'properties.dataSetMappingStatus', 'type': 'str'},
        'file_path': {'key': 'properties.filePath', 'type': 'str'},
        'output_type': {'key': 'properties.outputType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'storage_account_name': {'key': 'properties.storageAccountName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_name: str,
        data_set_id: str,
        file_path: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        output_type: Optional[Union[str, "OutputType"]] = None,
        **kwargs
    ):
        super(BlobDataSetMapping, self).__init__(**kwargs)
        self.kind = 'Blob'  # type: str
        self.container_name = container_name
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.file_path = file_path
        self.output_type = output_type
        self.provisioning_state = None
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class BlobFolderDataSet(DataSet):
    """An Azure storage blob folder data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set.Constant filled by server.  Possible values include:
     "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File",
     "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable",
     "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param container_name: Required. Container that has the file path.
    :type container_name: str
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :param prefix: Required. Prefix for blob folder.
    :type prefix: str
    :param resource_group: Required. Resource group of storage account.
    :type resource_group: str
    :param storage_account_name: Required. Storage account name of the source data set.
    :type storage_account_name: str
    :param subscription_id: Required. Subscription id of storage account.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'container_name': {'required': True},
        'data_set_id': {'readonly': True},
        'prefix': {'required': True},
        'resource_group': {'required': True},
        'storage_account_name': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'container_name': {'key': 'properties.containerName', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'prefix': {'key': 'properties.prefix', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'storage_account_name': {'key': 'properties.storageAccountName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_name: str,
        prefix: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        super(BlobFolderDataSet, self).__init__(**kwargs)
        self.kind = 'BlobFolder'  # type: str
        self.container_name = container_name
        self.data_set_id = None
        self.prefix = prefix
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class BlobFolderDataSetMapping(DataSetMapping):
    """A Blob folder data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set mapping.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param container_name: Required. Container that has the file path.
    :type container_name: str
    :param data_set_id: Required. The id of the source data set.
    :type data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Possible values
     include: "Ok", "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :param prefix: Required. Prefix for blob folder.
    :type prefix: str
    :ivar provisioning_state: Provisioning state of the data set mapping. Possible values include:
     "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :param resource_group: Required. Resource group of storage account.
    :type resource_group: str
    :param storage_account_name: Required. Storage account name of the source data set.
    :type storage_account_name: str
    :param subscription_id: Required. Subscription id of storage account.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'container_name': {'required': True},
        'data_set_id': {'required': True},
        'data_set_mapping_status': {'readonly': True},
        'prefix': {'required': True},
        'provisioning_state': {'readonly': True},
        'resource_group': {'required': True},
        'storage_account_name': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'container_name': {'key': 'properties.containerName', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'data_set_mapping_status': {'key': 'properties.dataSetMappingStatus', 'type': 'str'},
        'prefix': {'key': 'properties.prefix', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'storage_account_name': {'key': 'properties.storageAccountName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_name: str,
        data_set_id: str,
        prefix: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        super(BlobFolderDataSetMapping, self).__init__(**kwargs)
        self.kind = 'BlobFolder'  # type: str
        self.container_name = container_name
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.prefix = prefix
        self.provisioning_state = None
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class ConsumerInvitation(ProxyDto):
    """A consumer Invitation data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar data_set_count: Number of data sets in a share.
    :vartype data_set_count: int
    :ivar description: Description shared when the invitation was created.
    :vartype description: str
    :param invitation_id: Required. Unique id of the invitation.
    :type invitation_id: str
    :ivar invitation_status: The status of the invitation. Possible values include: "Pending",
     "Accepted", "Rejected", "Withdrawn".
    :vartype invitation_status: str or ~azure.mgmt.datashare.models.InvitationStatus
    :ivar location: invitation location.
    :vartype location: str
    :ivar provider_email: Email of the provider who created the resource.
    :vartype provider_email: str
    :ivar provider_name: Name of the provider who created the resource.
    :vartype provider_name: str
    :ivar provider_tenant_name: Tenant name of the provider who created the resource.
    :vartype provider_tenant_name: str
    :ivar responded_at: The time the recipient responded to the invitation.
    :vartype responded_at: ~datetime.datetime
    :ivar sent_at: Gets the time at which the invitation was sent.
    :vartype sent_at: ~datetime.datetime
    :ivar share_name: Gets the source share Name.
    :vartype share_name: str
    :ivar terms_of_use: Terms of use shared when the invitation was created.
    :vartype terms_of_use: str
    :ivar user_email: Email of the user who created the resource.
    :vartype user_email: str
    :ivar user_name: Name of the user who created the resource.
    :vartype user_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'data_set_count': {'readonly': True},
        'description': {'readonly': True},
        'invitation_id': {'required': True},
        'invitation_status': {'readonly': True},
        'location': {'readonly': True},
        'provider_email': {'readonly': True},
        'provider_name': {'readonly': True},
        'provider_tenant_name': {'readonly': True},
        'responded_at': {'readonly': True},
        'sent_at': {'readonly': True},
        'share_name': {'readonly': True},
        'terms_of_use': {'readonly': True},
        'user_email': {'readonly': True},
        'user_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data_set_count': {'key': 'properties.dataSetCount', 'type': 'int'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'invitation_id': {'key': 'properties.invitationId', 'type': 'str'},
        'invitation_status': {'key': 'properties.invitationStatus', 'type': 'str'},
        'location': {'key': 'properties.location', 'type': 'str'},
        'provider_email': {'key': 'properties.providerEmail', 'type': 'str'},
        'provider_name': {'key': 'properties.providerName', 'type': 'str'},
        'provider_tenant_name': {'key': 'properties.providerTenantName', 'type': 'str'},
        'responded_at': {'key': 'properties.respondedAt', 'type': 'iso-8601'},
        'sent_at': {'key': 'properties.sentAt', 'type': 'iso-8601'},
        'share_name': {'key': 'properties.shareName', 'type': 'str'},
        'terms_of_use': {'key': 'properties.termsOfUse', 'type': 'str'},
        'user_email': {'key': 'properties.userEmail', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        invitation_id: str,
        **kwargs
    ):
        super(ConsumerInvitation, self).__init__(**kwargs)
        self.data_set_count = None
        self.description = None
        self.invitation_id = invitation_id
        self.invitation_status = None
        self.location = None
        self.provider_email = None
        self.provider_name = None
        self.provider_tenant_name = None
        self.responded_at = None
        self.sent_at = None
        self.share_name = None
        self.terms_of_use = None
        self.user_email = None
        self.user_name = None


class ConsumerInvitationList(msrest.serialization.Model):
    """List response for get InvitationList.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.ConsumerInvitation]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ConsumerInvitation]'},
    }

    def __init__(
        self,
        *,
        value: List["ConsumerInvitation"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ConsumerInvitationList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ConsumerSourceDataSet(ProxyDto):
    """A consumer side dataSet data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar data_set_id: DataSet Id.
    :vartype data_set_id: str
    :ivar data_set_location: Location of the data set.
    :vartype data_set_location: str
    :ivar data_set_name: DataSet name.
    :vartype data_set_name: str
    :ivar data_set_path: DataSet path.
    :vartype data_set_path: str
    :ivar data_set_type: Type of data set. Possible values include: "Blob", "Container",
     "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder",
     "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable".
    :vartype data_set_type: str or ~azure.mgmt.datashare.models.DataSetType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'data_set_id': {'readonly': True},
        'data_set_location': {'readonly': True},
        'data_set_name': {'readonly': True},
        'data_set_path': {'readonly': True},
        'data_set_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'data_set_location': {'key': 'properties.dataSetLocation', 'type': 'str'},
        'data_set_name': {'key': 'properties.dataSetName', 'type': 'str'},
        'data_set_path': {'key': 'properties.dataSetPath', 'type': 'str'},
        'data_set_type': {'key': 'properties.dataSetType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConsumerSourceDataSet, self).__init__(**kwargs)
        self.data_set_id = None
        self.data_set_location = None
        self.data_set_name = None
        self.data_set_path = None
        self.data_set_type = None


class ConsumerSourceDataSetList(msrest.serialization.Model):
    """A consumer side list of source dataSets.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.ConsumerSourceDataSet]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ConsumerSourceDataSet]'},
    }

    def __init__(
        self,
        *,
        value: List["ConsumerSourceDataSet"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ConsumerSourceDataSetList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DataSetList(msrest.serialization.Model):
    """List response for get DataSets.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.DataSet]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DataSet]'},
    }

    def __init__(
        self,
        *,
        value: List["DataSet"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DataSetList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DataSetMappingList(msrest.serialization.Model):
    """List response for get DataSetMappings.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.DataSetMapping]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DataSetMapping]'},
    }

    def __init__(
        self,
        *,
        value: List["DataSetMapping"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DataSetMappingList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DataShareError(msrest.serialization.Model):
    """The data share error model.

    All required parameters must be populated in order to send to Azure.

    :param error: Required. The data share error body.
    :type error: ~azure.mgmt.datashare.models.DataShareErrorInfo
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'DataShareErrorInfo'},
    }

    def __init__(
        self,
        *,
        error: "DataShareErrorInfo",
        **kwargs
    ):
        super(DataShareError, self).__init__(**kwargs)
        self.error = error


class DataShareErrorInfo(msrest.serialization.Model):
    """The data share error body model.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Code of the error.
    :type code: str
    :param details: Nested details of the error model.
    :type details: list[~azure.mgmt.datashare.models.DataShareErrorInfo]
    :param message: Required. Message of the error.
    :type message: str
    :param target: Target of the error.
    :type target: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'details': {'key': 'details', 'type': '[DataShareErrorInfo]'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[List["DataShareErrorInfo"]] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        super(DataShareErrorInfo, self).__init__(**kwargs)
        self.code = code
        self.details = details
        self.message = message
        self.target = target


class DimensionProperties(msrest.serialization.Model):
    """properties for dimension.

    :param display_name: localized display name of the dimension to customer.
    :type display_name: str
    :param name: dimension name.
    :type name: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(DimensionProperties, self).__init__(**kwargs)
        self.display_name = display_name
        self.name = name


class Identity(msrest.serialization.Model):
    """Identity of resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: service principal Id.
    :vartype principal_id: str
    :ivar tenant_id: Tenant Id.
    :vartype tenant_id: str
    :param type: Identity Type. Possible values include: "SystemAssigned".
    :type type: str or ~azure.mgmt.datashare.models.Type
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "Type"]] = None,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class Invitation(ProxyDto):
    """A Invitation data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar invitation_id: unique invitation id.
    :vartype invitation_id: str
    :ivar invitation_status: The status of the invitation. Possible values include: "Pending",
     "Accepted", "Rejected", "Withdrawn".
    :vartype invitation_status: str or ~azure.mgmt.datashare.models.InvitationStatus
    :ivar responded_at: The time the recipient responded to the invitation.
    :vartype responded_at: ~datetime.datetime
    :ivar sent_at: Gets the time at which the invitation was sent.
    :vartype sent_at: ~datetime.datetime
    :param target_active_directory_id: The target Azure AD Id. Can't be combined with email.
    :type target_active_directory_id: str
    :param target_email: The email the invitation is directed to.
    :type target_email: str
    :param target_object_id: The target user or application Id that invitation is being sent to.
     Must be specified along TargetActiveDirectoryId. This enables sending
     invitations to specific users or applications in an AD tenant.
    :type target_object_id: str
    :ivar user_email: Email of the user who created the resource.
    :vartype user_email: str
    :ivar user_name: Name of the user who created the resource.
    :vartype user_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'invitation_id': {'readonly': True},
        'invitation_status': {'readonly': True},
        'responded_at': {'readonly': True},
        'sent_at': {'readonly': True},
        'user_email': {'readonly': True},
        'user_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'invitation_id': {'key': 'properties.invitationId', 'type': 'str'},
        'invitation_status': {'key': 'properties.invitationStatus', 'type': 'str'},
        'responded_at': {'key': 'properties.respondedAt', 'type': 'iso-8601'},
        'sent_at': {'key': 'properties.sentAt', 'type': 'iso-8601'},
        'target_active_directory_id': {'key': 'properties.targetActiveDirectoryId', 'type': 'str'},
        'target_email': {'key': 'properties.targetEmail', 'type': 'str'},
        'target_object_id': {'key': 'properties.targetObjectId', 'type': 'str'},
        'user_email': {'key': 'properties.userEmail', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_active_directory_id: Optional[str] = None,
        target_email: Optional[str] = None,
        target_object_id: Optional[str] = None,
        **kwargs
    ):
        super(Invitation, self).__init__(**kwargs)
        self.invitation_id = None
        self.invitation_status = None
        self.responded_at = None
        self.sent_at = None
        self.target_active_directory_id = target_active_directory_id
        self.target_email = target_email
        self.target_object_id = target_object_id
        self.user_email = None
        self.user_name = None


class InvitationList(msrest.serialization.Model):
    """List response for get InvitationList.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.Invitation]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Invitation]'},
    }

    def __init__(
        self,
        *,
        value: List["Invitation"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(InvitationList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class KustoClusterDataSet(DataSet):
    """A kusto cluster data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set.Constant filled by server.  Possible values include:
     "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File",
     "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable",
     "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :param kusto_cluster_resource_id: Required. Resource id of the kusto cluster.
    :type kusto_cluster_resource_id: str
    :ivar location: Location of the kusto cluster.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the kusto cluster data set. Possible values
     include: "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'data_set_id': {'readonly': True},
        'kusto_cluster_resource_id': {'required': True},
        'location': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'kusto_cluster_resource_id': {'key': 'properties.kustoClusterResourceId', 'type': 'str'},
        'location': {'key': 'properties.location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kusto_cluster_resource_id: str,
        **kwargs
    ):
        super(KustoClusterDataSet, self).__init__(**kwargs)
        self.kind = 'KustoCluster'  # type: str
        self.data_set_id = None
        self.kusto_cluster_resource_id = kusto_cluster_resource_id
        self.location = None
        self.provisioning_state = None


class KustoClusterDataSetMapping(DataSetMapping):
    """A Kusto cluster data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set mapping.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param data_set_id: Required. The id of the source data set.
    :type data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Possible values
     include: "Ok", "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :param kusto_cluster_resource_id: Required. Resource id of the sink kusto cluster.
    :type kusto_cluster_resource_id: str
    :ivar location: Location of the sink kusto cluster.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the data set mapping. Possible values include:
     "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'data_set_id': {'required': True},
        'data_set_mapping_status': {'readonly': True},
        'kusto_cluster_resource_id': {'required': True},
        'location': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'data_set_mapping_status': {'key': 'properties.dataSetMappingStatus', 'type': 'str'},
        'kusto_cluster_resource_id': {'key': 'properties.kustoClusterResourceId', 'type': 'str'},
        'location': {'key': 'properties.location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_set_id: str,
        kusto_cluster_resource_id: str,
        **kwargs
    ):
        super(KustoClusterDataSetMapping, self).__init__(**kwargs)
        self.kind = 'KustoCluster'  # type: str
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.kusto_cluster_resource_id = kusto_cluster_resource_id
        self.location = None
        self.provisioning_state = None


class KustoDatabaseDataSet(DataSet):
    """A kusto database data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set.Constant filled by server.  Possible values include:
     "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File",
     "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable",
     "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :param kusto_database_resource_id: Required. Resource id of the kusto database.
    :type kusto_database_resource_id: str
    :ivar location: Location of the kusto cluster.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the kusto database data set. Possible values
     include: "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'data_set_id': {'readonly': True},
        'kusto_database_resource_id': {'required': True},
        'location': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'kusto_database_resource_id': {'key': 'properties.kustoDatabaseResourceId', 'type': 'str'},
        'location': {'key': 'properties.location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kusto_database_resource_id: str,
        **kwargs
    ):
        super(KustoDatabaseDataSet, self).__init__(**kwargs)
        self.kind = 'KustoDatabase'  # type: str
        self.data_set_id = None
        self.kusto_database_resource_id = kusto_database_resource_id
        self.location = None
        self.provisioning_state = None


class KustoDatabaseDataSetMapping(DataSetMapping):
    """A Kusto database data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set mapping.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param data_set_id: Required. The id of the source data set.
    :type data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Possible values
     include: "Ok", "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :param kusto_cluster_resource_id: Required. Resource id of the sink kusto cluster.
    :type kusto_cluster_resource_id: str
    :ivar location: Location of the sink kusto cluster.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the data set mapping. Possible values include:
     "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'data_set_id': {'required': True},
        'data_set_mapping_status': {'readonly': True},
        'kusto_cluster_resource_id': {'required': True},
        'location': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'data_set_mapping_status': {'key': 'properties.dataSetMappingStatus', 'type': 'str'},
        'kusto_cluster_resource_id': {'key': 'properties.kustoClusterResourceId', 'type': 'str'},
        'location': {'key': 'properties.location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_set_id: str,
        kusto_cluster_resource_id: str,
        **kwargs
    ):
        super(KustoDatabaseDataSetMapping, self).__init__(**kwargs)
        self.kind = 'KustoDatabase'  # type: str
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.kusto_cluster_resource_id = kusto_cluster_resource_id
        self.location = None
        self.provisioning_state = None


class OperationList(msrest.serialization.Model):
    """List response for get operations.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.OperationModel]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[OperationModel]'},
    }

    def __init__(
        self,
        *,
        value: List["OperationModel"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class OperationMetaLogSpecification(msrest.serialization.Model):
    """log specifications for operation api.

    :param blob_duration: blob duration of the log.
    :type blob_duration: str
    :param display_name: localized name of the log category.
    :type display_name: str
    :param name: name of the log category.
    :type name: str
    """

    _attribute_map = {
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        blob_duration: Optional[str] = None,
        display_name: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(OperationMetaLogSpecification, self).__init__(**kwargs)
        self.blob_duration = blob_duration
        self.display_name = display_name
        self.name = name


class OperationMetaMetricSpecification(msrest.serialization.Model):
    """metric specifications for the operation.

    :param aggregation_type: aggregation type of metric.
    :type aggregation_type: str
    :param dimensions: properties for dimension.
    :type dimensions: list[~azure.mgmt.datashare.models.DimensionProperties]
    :param display_description: description of the metric.
    :type display_description: str
    :param display_name: localized name of the metric.
    :type display_name: str
    :param enable_regional_mdm_account: enable regional mdm account.
    :type enable_regional_mdm_account: str
    :param internal_metric_name: internal metric name.
    :type internal_metric_name: str
    :param name: name of the metric.
    :type name: str
    :param resource_id_dimension_name_override: dimension name use to replace resource id if
     specified.
    :type resource_id_dimension_name_override: str
    :param supported_aggregation_types: supported aggregation types.
    :type supported_aggregation_types: list[str]
    :param supported_time_grain_types: supported time grain types.
    :type supported_time_grain_types: list[str]
    :param unit: units for the metric.
    :type unit: str
    """

    _attribute_map = {
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[DimensionProperties]'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'str'},
        'internal_metric_name': {'key': 'internalMetricName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        aggregation_type: Optional[str] = None,
        dimensions: Optional[List["DimensionProperties"]] = None,
        display_description: Optional[str] = None,
        display_name: Optional[str] = None,
        enable_regional_mdm_account: Optional[str] = None,
        internal_metric_name: Optional[str] = None,
        name: Optional[str] = None,
        resource_id_dimension_name_override: Optional[str] = None,
        supported_aggregation_types: Optional[List[str]] = None,
        supported_time_grain_types: Optional[List[str]] = None,
        unit: Optional[str] = None,
        **kwargs
    ):
        super(OperationMetaMetricSpecification, self).__init__(**kwargs)
        self.aggregation_type = aggregation_type
        self.dimensions = dimensions
        self.display_description = display_description
        self.display_name = display_name
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.internal_metric_name = internal_metric_name
        self.name = name
        self.resource_id_dimension_name_override = resource_id_dimension_name_override
        self.supported_aggregation_types = supported_aggregation_types
        self.supported_time_grain_types = supported_time_grain_types
        self.unit = unit


class OperationMetaServiceSpecification(msrest.serialization.Model):
    """The operation meta service specification.

    :param log_specifications: log specifications for the operation.
    :type log_specifications: list[~azure.mgmt.datashare.models.OperationMetaLogSpecification]
    :param metric_specifications: metric specifications for the operation.
    :type metric_specifications:
     list[~azure.mgmt.datashare.models.OperationMetaMetricSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[OperationMetaLogSpecification]'},
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[OperationMetaMetricSpecification]'},
    }

    def __init__(
        self,
        *,
        log_specifications: Optional[List["OperationMetaLogSpecification"]] = None,
        metric_specifications: Optional[List["OperationMetaMetricSpecification"]] = None,
        **kwargs
    ):
        super(OperationMetaServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = log_specifications
        self.metric_specifications = metric_specifications


class OperationModel(msrest.serialization.Model):
    """The response model for get operations.

    :param display: Properties on the operation.
    :type display: ~azure.mgmt.datashare.models.OperationModelProperties
    :param name: Operation name for display purposes.
    :type name: str
    :param origin: origin of the operation.
    :type origin: str
    :param service_specification: meta service specification.
    :type service_specification: ~azure.mgmt.datashare.models.OperationMetaServiceSpecification
    """

    _attribute_map = {
        'display': {'key': 'display', 'type': 'OperationModelProperties'},
        'name': {'key': 'name', 'type': 'str'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'OperationMetaServiceSpecification'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationModelProperties"] = None,
        name: Optional[str] = None,
        origin: Optional[str] = None,
        service_specification: Optional["OperationMetaServiceSpecification"] = None,
        **kwargs
    ):
        super(OperationModel, self).__init__(**kwargs)
        self.display = display
        self.name = name
        self.origin = origin
        self.service_specification = service_specification


class OperationModelProperties(msrest.serialization.Model):
    """Properties on operations.

    :param description: Description of the operation for display purposes.
    :type description: str
    :param operation: Name of the operation for display purposes.
    :type operation: str
    :param provider: Name of the provider for display purposes.
    :type provider: str
    :param resource: Name of the resource type for display purposes.
    :type resource: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        operation: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        **kwargs
    ):
        super(OperationModelProperties, self).__init__(**kwargs)
        self.description = description
        self.operation = operation
        self.provider = provider
        self.resource = resource


class OperationResponse(msrest.serialization.Model):
    """Response for long running operation.

    All required parameters must be populated in order to send to Azure.

    :param end_time: start time.
    :type end_time: ~datetime.datetime
    :param error: The error property when status is failed.
    :type error: ~azure.mgmt.datashare.models.DataShareErrorInfo
    :param start_time: start time.
    :type start_time: ~datetime.datetime
    :param status: Required. Operation state of the long running operation. Possible values
     include: "Accepted", "InProgress", "TransientFailure", "Succeeded", "Failed", "Canceled".
    :type status: str or ~azure.mgmt.datashare.models.Status
    """

    _validation = {
        'status': {'required': True},
    }

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'DataShareErrorInfo'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "Status"],
        end_time: Optional[datetime.datetime] = None,
        error: Optional["DataShareErrorInfo"] = None,
        start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(OperationResponse, self).__init__(**kwargs)
        self.end_time = end_time
        self.error = error
        self.start_time = start_time
        self.status = status


class ProviderShareSubscription(ProxyDto):
    """A provider side share subscription data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar consumer_email: Email of the consumer who created the share subscription.
    :vartype consumer_email: str
    :ivar consumer_name: Name of the consumer who created the share subscription.
    :vartype consumer_name: str
    :ivar consumer_tenant_name: Tenant name of the consumer who created the share subscription.
    :vartype consumer_tenant_name: str
    :ivar created_at: created at.
    :vartype created_at: ~datetime.datetime
    :ivar provider_email: Email of the provider who created the share.
    :vartype provider_email: str
    :ivar provider_name: Name of the provider who created the share.
    :vartype provider_name: str
    :ivar shared_at: Shared at.
    :vartype shared_at: ~datetime.datetime
    :ivar share_subscription_object_id: share Subscription Object Id.
    :vartype share_subscription_object_id: str
    :ivar share_subscription_status: Gets the status of share subscription. Possible values
     include: "Active", "Revoked", "SourceDeleted", "Revoking".
    :vartype share_subscription_status: str or ~azure.mgmt.datashare.models.ShareSubscriptionStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'consumer_email': {'readonly': True},
        'consumer_name': {'readonly': True},
        'consumer_tenant_name': {'readonly': True},
        'created_at': {'readonly': True},
        'provider_email': {'readonly': True},
        'provider_name': {'readonly': True},
        'shared_at': {'readonly': True},
        'share_subscription_object_id': {'readonly': True},
        'share_subscription_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'consumer_email': {'key': 'properties.consumerEmail', 'type': 'str'},
        'consumer_name': {'key': 'properties.consumerName', 'type': 'str'},
        'consumer_tenant_name': {'key': 'properties.consumerTenantName', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'provider_email': {'key': 'properties.providerEmail', 'type': 'str'},
        'provider_name': {'key': 'properties.providerName', 'type': 'str'},
        'shared_at': {'key': 'properties.sharedAt', 'type': 'iso-8601'},
        'share_subscription_object_id': {'key': 'properties.shareSubscriptionObjectId', 'type': 'str'},
        'share_subscription_status': {'key': 'properties.shareSubscriptionStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProviderShareSubscription, self).__init__(**kwargs)
        self.consumer_email = None
        self.consumer_name = None
        self.consumer_tenant_name = None
        self.created_at = None
        self.provider_email = None
        self.provider_name = None
        self.shared_at = None
        self.share_subscription_object_id = None
        self.share_subscription_status = None


class ProviderShareSubscriptionList(msrest.serialization.Model):
    """List response for get ShareSubscription.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.ProviderShareSubscription]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ProviderShareSubscription]'},
    }

    def __init__(
        self,
        *,
        value: List["ProviderShareSubscription"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ProviderShareSubscriptionList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class SourceShareSynchronizationSetting(msrest.serialization.Model):
    """A view of synchronization setting added by the provider.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ScheduledSourceSynchronizationSetting.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Kind of synchronization.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'ScheduleBased': 'ScheduledSourceSynchronizationSetting'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceShareSynchronizationSetting, self).__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class ScheduledSourceSynchronizationSetting(SourceShareSynchronizationSetting):
    """A type of synchronization setting based on schedule.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Kind of synchronization.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param recurrence_interval: Recurrence Interval. Possible values include: "Hour", "Day".
    :type recurrence_interval: str or ~azure.mgmt.datashare.models.RecurrenceInterval
    :param synchronization_time: Synchronization time.
    :type synchronization_time: ~datetime.datetime
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'recurrence_interval': {'key': 'properties.recurrenceInterval', 'type': 'str'},
        'synchronization_time': {'key': 'properties.synchronizationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        recurrence_interval: Optional[Union[str, "RecurrenceInterval"]] = None,
        synchronization_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(ScheduledSourceSynchronizationSetting, self).__init__(**kwargs)
        self.kind = 'ScheduleBased'  # type: str
        self.recurrence_interval = recurrence_interval
        self.synchronization_time = synchronization_time


class SynchronizationSetting(ProxyDto):
    """A Synchronization Setting data transfer object.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ScheduledSynchronizationSetting.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of synchronization.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'ScheduleBased': 'ScheduledSynchronizationSetting'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SynchronizationSetting, self).__init__(**kwargs)
        self.kind = 'SynchronizationSetting'  # type: str


class ScheduledSynchronizationSetting(SynchronizationSetting):
    """A type of synchronization setting based on schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of synchronization.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :ivar created_at: Time at which the synchronization setting was created.
    :vartype created_at: ~datetime.datetime
    :ivar provisioning_state: Gets or sets the provisioning state. Possible values include:
     "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :param recurrence_interval: Required. Recurrence Interval. Possible values include: "Hour",
     "Day".
    :type recurrence_interval: str or ~azure.mgmt.datashare.models.RecurrenceInterval
    :param synchronization_time: Required. Synchronization time.
    :type synchronization_time: ~datetime.datetime
    :ivar user_name: Name of the user who created the synchronization setting.
    :vartype user_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'created_at': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'recurrence_interval': {'required': True},
        'synchronization_time': {'required': True},
        'user_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'recurrence_interval': {'key': 'properties.recurrenceInterval', 'type': 'str'},
        'synchronization_time': {'key': 'properties.synchronizationTime', 'type': 'iso-8601'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recurrence_interval: Union[str, "RecurrenceInterval"],
        synchronization_time: datetime.datetime,
        **kwargs
    ):
        super(ScheduledSynchronizationSetting, self).__init__(**kwargs)
        self.kind = 'ScheduleBased'  # type: str
        self.created_at = None
        self.provisioning_state = None
        self.recurrence_interval = recurrence_interval
        self.synchronization_time = synchronization_time
        self.user_name = None


class Trigger(ProxyDto):
    """A Trigger data transfer object.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ScheduledTrigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of synchronization.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'ScheduleBased': 'ScheduledTrigger'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Trigger, self).__init__(**kwargs)
        self.kind = 'Trigger'  # type: str


class ScheduledTrigger(Trigger):
    """A type of trigger based on schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of synchronization.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :ivar created_at: Time at which the trigger was created.
    :vartype created_at: ~datetime.datetime
    :ivar provisioning_state: Gets the provisioning state. Possible values include: "Succeeded",
     "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :param recurrence_interval: Required. Recurrence Interval. Possible values include: "Hour",
     "Day".
    :type recurrence_interval: str or ~azure.mgmt.datashare.models.RecurrenceInterval
    :param synchronization_mode: Synchronization mode. Possible values include: "Incremental",
     "FullSync".
    :type synchronization_mode: str or ~azure.mgmt.datashare.models.SynchronizationMode
    :param synchronization_time: Required. Synchronization time.
    :type synchronization_time: ~datetime.datetime
    :ivar trigger_status: Gets the trigger state. Possible values include: "Active", "Inactive",
     "SourceSynchronizationSettingDeleted".
    :vartype trigger_status: str or ~azure.mgmt.datashare.models.TriggerStatus
    :ivar user_name: Name of the user who created the trigger.
    :vartype user_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'created_at': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'recurrence_interval': {'required': True},
        'synchronization_time': {'required': True},
        'trigger_status': {'readonly': True},
        'user_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'recurrence_interval': {'key': 'properties.recurrenceInterval', 'type': 'str'},
        'synchronization_mode': {'key': 'properties.synchronizationMode', 'type': 'str'},
        'synchronization_time': {'key': 'properties.synchronizationTime', 'type': 'iso-8601'},
        'trigger_status': {'key': 'properties.triggerStatus', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recurrence_interval: Union[str, "RecurrenceInterval"],
        synchronization_time: datetime.datetime,
        synchronization_mode: Optional[Union[str, "SynchronizationMode"]] = None,
        **kwargs
    ):
        super(ScheduledTrigger, self).__init__(**kwargs)
        self.kind = 'ScheduleBased'  # type: str
        self.created_at = None
        self.provisioning_state = None
        self.recurrence_interval = recurrence_interval
        self.synchronization_mode = synchronization_mode
        self.synchronization_time = synchronization_time
        self.trigger_status = None
        self.user_name = None


class Share(ProxyDto):
    """A share data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar created_at: Time at which the share was created.
    :vartype created_at: ~datetime.datetime
    :param description: Share description.
    :type description: str
    :ivar provisioning_state: Gets or sets the provisioning state. Possible values include:
     "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :param share_kind: Share kind. Possible values include: "CopyBased", "InPlace".
    :type share_kind: str or ~azure.mgmt.datashare.models.ShareKind
    :param terms: Share terms.
    :type terms: str
    :ivar user_email: Email of the user who created the resource.
    :vartype user_email: str
    :ivar user_name: Name of the user who created the resource.
    :vartype user_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_at': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'user_email': {'readonly': True},
        'user_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'share_kind': {'key': 'properties.shareKind', 'type': 'str'},
        'terms': {'key': 'properties.terms', 'type': 'str'},
        'user_email': {'key': 'properties.userEmail', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        share_kind: Optional[Union[str, "ShareKind"]] = None,
        terms: Optional[str] = None,
        **kwargs
    ):
        super(Share, self).__init__(**kwargs)
        self.created_at = None
        self.description = description
        self.provisioning_state = None
        self.share_kind = share_kind
        self.terms = terms
        self.user_email = None
        self.user_name = None


class ShareList(msrest.serialization.Model):
    """List response for get Shares.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.Share]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Share]'},
    }

    def __init__(
        self,
        *,
        value: List["Share"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ShareList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ShareSubscription(ProxyDto):
    """A share subscription data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar created_at: Time at which the share subscription was created.
    :vartype created_at: ~datetime.datetime
    :param invitation_id: Required. The invitation id.
    :type invitation_id: str
    :ivar provider_email: Email of the provider who created the resource.
    :vartype provider_email: str
    :ivar provider_name: Name of the provider who created the resource.
    :vartype provider_name: str
    :ivar provider_tenant_name: Tenant name of the provider who created the resource.
    :vartype provider_tenant_name: str
    :ivar provisioning_state: Provisioning state of the share subscription. Possible values
     include: "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar share_description: Description of share.
    :vartype share_description: str
    :ivar share_kind: Kind of share. Possible values include: "CopyBased", "InPlace".
    :vartype share_kind: str or ~azure.mgmt.datashare.models.ShareKind
    :ivar share_name: Name of the share.
    :vartype share_name: str
    :ivar share_subscription_status: Gets the current status of share subscription. Possible values
     include: "Active", "Revoked", "SourceDeleted", "Revoking".
    :vartype share_subscription_status: str or ~azure.mgmt.datashare.models.ShareSubscriptionStatus
    :ivar share_terms: Terms of a share.
    :vartype share_terms: str
    :param source_share_location: Required. Source share location.
    :type source_share_location: str
    :ivar user_email: Email of the user who created the resource.
    :vartype user_email: str
    :ivar user_name: Name of the user who created the resource.
    :vartype user_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_at': {'readonly': True},
        'invitation_id': {'required': True},
        'provider_email': {'readonly': True},
        'provider_name': {'readonly': True},
        'provider_tenant_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'share_description': {'readonly': True},
        'share_kind': {'readonly': True},
        'share_name': {'readonly': True},
        'share_subscription_status': {'readonly': True},
        'share_terms': {'readonly': True},
        'source_share_location': {'required': True},
        'user_email': {'readonly': True},
        'user_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'invitation_id': {'key': 'properties.invitationId', 'type': 'str'},
        'provider_email': {'key': 'properties.providerEmail', 'type': 'str'},
        'provider_name': {'key': 'properties.providerName', 'type': 'str'},
        'provider_tenant_name': {'key': 'properties.providerTenantName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'share_description': {'key': 'properties.shareDescription', 'type': 'str'},
        'share_kind': {'key': 'properties.shareKind', 'type': 'str'},
        'share_name': {'key': 'properties.shareName', 'type': 'str'},
        'share_subscription_status': {'key': 'properties.shareSubscriptionStatus', 'type': 'str'},
        'share_terms': {'key': 'properties.shareTerms', 'type': 'str'},
        'source_share_location': {'key': 'properties.sourceShareLocation', 'type': 'str'},
        'user_email': {'key': 'properties.userEmail', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        invitation_id: str,
        source_share_location: str,
        **kwargs
    ):
        super(ShareSubscription, self).__init__(**kwargs)
        self.created_at = None
        self.invitation_id = invitation_id
        self.provider_email = None
        self.provider_name = None
        self.provider_tenant_name = None
        self.provisioning_state = None
        self.share_description = None
        self.share_kind = None
        self.share_name = None
        self.share_subscription_status = None
        self.share_terms = None
        self.source_share_location = source_share_location
        self.user_email = None
        self.user_name = None


class ShareSubscriptionList(msrest.serialization.Model):
    """List response for get ShareSubscription.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.ShareSubscription]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ShareSubscription]'},
    }

    def __init__(
        self,
        *,
        value: List["ShareSubscription"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ShareSubscriptionList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ShareSubscriptionSynchronization(msrest.serialization.Model):
    """A ShareSubscriptionSynchronization data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar duration_ms: Synchronization duration.
    :vartype duration_ms: int
    :ivar end_time: End time of synchronization.
    :vartype end_time: ~datetime.datetime
    :ivar message: message of Synchronization.
    :vartype message: str
    :ivar start_time: start time of synchronization.
    :vartype start_time: ~datetime.datetime
    :ivar status: Raw Status.
    :vartype status: str
    :param synchronization_id: Required. Synchronization id.
    :type synchronization_id: str
    :ivar synchronization_mode: Synchronization Mode. Possible values include: "Incremental",
     "FullSync".
    :vartype synchronization_mode: str or ~azure.mgmt.datashare.models.SynchronizationMode
    """

    _validation = {
        'duration_ms': {'readonly': True},
        'end_time': {'readonly': True},
        'message': {'readonly': True},
        'start_time': {'readonly': True},
        'status': {'readonly': True},
        'synchronization_id': {'required': True},
        'synchronization_mode': {'readonly': True},
    }

    _attribute_map = {
        'duration_ms': {'key': 'durationMs', 'type': 'int'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'synchronization_id': {'key': 'synchronizationId', 'type': 'str'},
        'synchronization_mode': {'key': 'synchronizationMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        synchronization_id: str,
        **kwargs
    ):
        super(ShareSubscriptionSynchronization, self).__init__(**kwargs)
        self.duration_ms = None
        self.end_time = None
        self.message = None
        self.start_time = None
        self.status = None
        self.synchronization_id = synchronization_id
        self.synchronization_mode = None


class ShareSubscriptionSynchronizationList(msrest.serialization.Model):
    """A consumer side list of share subscription synchronizations.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.ShareSubscriptionSynchronization]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ShareSubscriptionSynchronization]'},
    }

    def __init__(
        self,
        *,
        value: List["ShareSubscriptionSynchronization"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ShareSubscriptionSynchronizationList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ShareSynchronization(msrest.serialization.Model):
    """A ShareSynchronization data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param consumer_email: Email of the user who created the synchronization.
    :type consumer_email: str
    :param consumer_name: Name of the user who created the synchronization.
    :type consumer_name: str
    :param consumer_tenant_name: Tenant name of the consumer who created the synchronization.
    :type consumer_tenant_name: str
    :param duration_ms: synchronization duration.
    :type duration_ms: int
    :param end_time: End time of synchronization.
    :type end_time: ~datetime.datetime
    :param message: message of synchronization.
    :type message: str
    :param start_time: start time of synchronization.
    :type start_time: ~datetime.datetime
    :param status: Raw Status.
    :type status: str
    :param synchronization_id: Synchronization id.
    :type synchronization_id: str
    :ivar synchronization_mode: Synchronization mode. Possible values include: "Incremental",
     "FullSync".
    :vartype synchronization_mode: str or ~azure.mgmt.datashare.models.SynchronizationMode
    """

    _validation = {
        'synchronization_mode': {'readonly': True},
    }

    _attribute_map = {
        'consumer_email': {'key': 'consumerEmail', 'type': 'str'},
        'consumer_name': {'key': 'consumerName', 'type': 'str'},
        'consumer_tenant_name': {'key': 'consumerTenantName', 'type': 'str'},
        'duration_ms': {'key': 'durationMs', 'type': 'int'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'synchronization_id': {'key': 'synchronizationId', 'type': 'str'},
        'synchronization_mode': {'key': 'synchronizationMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        consumer_email: Optional[str] = None,
        consumer_name: Optional[str] = None,
        consumer_tenant_name: Optional[str] = None,
        duration_ms: Optional[int] = None,
        end_time: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        status: Optional[str] = None,
        synchronization_id: Optional[str] = None,
        **kwargs
    ):
        super(ShareSynchronization, self).__init__(**kwargs)
        self.consumer_email = consumer_email
        self.consumer_name = consumer_name
        self.consumer_tenant_name = consumer_tenant_name
        self.duration_ms = duration_ms
        self.end_time = end_time
        self.message = message
        self.start_time = start_time
        self.status = status
        self.synchronization_id = synchronization_id
        self.synchronization_mode = None


class ShareSynchronizationList(msrest.serialization.Model):
    """List response for get ShareSynchronization.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.ShareSynchronization]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ShareSynchronization]'},
    }

    def __init__(
        self,
        *,
        value: List["ShareSynchronization"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ShareSynchronizationList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class SourceShareSynchronizationSettingList(msrest.serialization.Model):
    """List response for get source share Synchronization settings.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.SourceShareSynchronizationSetting]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[SourceShareSynchronizationSetting]'},
    }

    def __init__(
        self,
        *,
        value: List["SourceShareSynchronizationSetting"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SourceShareSynchronizationSettingList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class SqlDBTableDataSet(DataSet):
    """A SQL DB table data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set.Constant filled by server.  Possible values include:
     "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File",
     "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable",
     "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param database_name: Database name of the source data set.
    :type database_name: str
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :param schema_name: Schema of the table. Default value is dbo.
    :type schema_name: str
    :param sql_server_resource_id: Resource id of SQL server.
    :type sql_server_resource_id: str
    :param table_name: SQL DB table name.
    :type table_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'data_set_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'schema_name': {'key': 'properties.schemaName', 'type': 'str'},
        'sql_server_resource_id': {'key': 'properties.sqlServerResourceId', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        sql_server_resource_id: Optional[str] = None,
        table_name: Optional[str] = None,
        **kwargs
    ):
        super(SqlDBTableDataSet, self).__init__(**kwargs)
        self.kind = 'SqlDBTable'  # type: str
        self.database_name = database_name
        self.data_set_id = None
        self.schema_name = schema_name
        self.sql_server_resource_id = sql_server_resource_id
        self.table_name = table_name


class SqlDBTableDataSetMapping(DataSetMapping):
    """A SQL DB Table data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set mapping.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param database_name: Required. DatabaseName name of the sink data set.
    :type database_name: str
    :param data_set_id: Required. The id of the source data set.
    :type data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Possible values
     include: "Ok", "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :ivar provisioning_state: Provisioning state of the data set mapping. Possible values include:
     "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :param schema_name: Required. Schema of the table. Default value is dbo.
    :type schema_name: str
    :param sql_server_resource_id: Required. Resource id of SQL server.
    :type sql_server_resource_id: str
    :param table_name: Required. SQL DB table name.
    :type table_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'database_name': {'required': True},
        'data_set_id': {'required': True},
        'data_set_mapping_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'schema_name': {'required': True},
        'sql_server_resource_id': {'required': True},
        'table_name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'data_set_mapping_status': {'key': 'properties.dataSetMappingStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'schema_name': {'key': 'properties.schemaName', 'type': 'str'},
        'sql_server_resource_id': {'key': 'properties.sqlServerResourceId', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        database_name: str,
        data_set_id: str,
        schema_name: str,
        sql_server_resource_id: str,
        table_name: str,
        **kwargs
    ):
        super(SqlDBTableDataSetMapping, self).__init__(**kwargs)
        self.kind = 'SqlDBTable'  # type: str
        self.database_name = database_name
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.provisioning_state = None
        self.schema_name = schema_name
        self.sql_server_resource_id = sql_server_resource_id
        self.table_name = table_name


class SqlDWTableDataSet(DataSet):
    """A SQL DW table data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set.Constant filled by server.  Possible values include:
     "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File",
     "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable",
     "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :param data_warehouse_name: DataWarehouse name of the source data set.
    :type data_warehouse_name: str
    :param schema_name: Schema of the table. Default value is dbo.
    :type schema_name: str
    :param sql_server_resource_id: Resource id of SQL server.
    :type sql_server_resource_id: str
    :param table_name: SQL DW table name.
    :type table_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'data_set_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'data_warehouse_name': {'key': 'properties.dataWarehouseName', 'type': 'str'},
        'schema_name': {'key': 'properties.schemaName', 'type': 'str'},
        'sql_server_resource_id': {'key': 'properties.sqlServerResourceId', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_warehouse_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        sql_server_resource_id: Optional[str] = None,
        table_name: Optional[str] = None,
        **kwargs
    ):
        super(SqlDWTableDataSet, self).__init__(**kwargs)
        self.kind = 'SqlDWTable'  # type: str
        self.data_set_id = None
        self.data_warehouse_name = data_warehouse_name
        self.schema_name = schema_name
        self.sql_server_resource_id = sql_server_resource_id
        self.table_name = table_name


class SqlDWTableDataSetMapping(DataSetMapping):
    """A SQL DW Table data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar type: Type of the azure resource.
    :vartype type: str
    :param kind: Required. Kind of data set mapping.Constant filled by server.  Possible values
     include: "Blob", "Container", "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder",
     "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File", "KustoCluster", "KustoDatabase",
     "SqlDBTable", "SqlDWTable", "ScheduleBased".
    :type kind: str or ~azure.mgmt.datashare.models.Kind
    :param data_set_id: Required. The id of the source data set.
    :type data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Possible values
     include: "Ok", "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :param data_warehouse_name: Required. DataWarehouse name of the source data set.
    :type data_warehouse_name: str
    :ivar provisioning_state: Provisioning state of the data set mapping. Possible values include:
     "Succeeded", "Creating", "Deleting", "Moving", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :param schema_name: Required. Schema of the table. Default value is dbo.
    :type schema_name: str
    :param sql_server_resource_id: Required. Resource id of SQL server.
    :type sql_server_resource_id: str
    :param table_name: Required. SQL DW table name.
    :type table_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'data_set_id': {'required': True},
        'data_set_mapping_status': {'readonly': True},
        'data_warehouse_name': {'required': True},
        'provisioning_state': {'readonly': True},
        'schema_name': {'required': True},
        'sql_server_resource_id': {'required': True},
        'table_name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_set_id': {'key': 'properties.dataSetId', 'type': 'str'},
        'data_set_mapping_status': {'key': 'properties.dataSetMappingStatus', 'type': 'str'},
        'data_warehouse_name': {'key': 'properties.dataWarehouseName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'schema_name': {'key': 'properties.schemaName', 'type': 'str'},
        'sql_server_resource_id': {'key': 'properties.sqlServerResourceId', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_set_id: str,
        data_warehouse_name: str,
        schema_name: str,
        sql_server_resource_id: str,
        table_name: str,
        **kwargs
    ):
        super(SqlDWTableDataSetMapping, self).__init__(**kwargs)
        self.kind = 'SqlDWTable'  # type: str
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.data_warehouse_name = data_warehouse_name
        self.provisioning_state = None
        self.schema_name = schema_name
        self.sql_server_resource_id = sql_server_resource_id
        self.table_name = table_name


class SynchronizationDetails(msrest.serialization.Model):
    """Synchronization details at data set level.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar data_set_id: Id of data set.
    :vartype data_set_id: str
    :ivar data_set_type: Type of the data set. Possible values include: "Blob", "Container",
     "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder",
     "AdlsGen1File", "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable".
    :vartype data_set_type: str or ~azure.mgmt.datashare.models.DataSetType
    :ivar duration_ms: Duration of data set level copy.
    :vartype duration_ms: int
    :ivar end_time: End time of data set level copy.
    :vartype end_time: ~datetime.datetime
    :ivar files_read: The number of files read from the source data set.
    :vartype files_read: long
    :ivar files_written: The number of files written into the sink data set.
    :vartype files_written: long
    :ivar message: Error message if any.
    :vartype message: str
    :ivar name: Name of the data set.
    :vartype name: str
    :ivar rows_copied: The number of files copied into the sink data set.
    :vartype rows_copied: long
    :ivar rows_read: The number of rows read from the source data set.
    :vartype rows_read: long
    :ivar size_read: The size of the data read from the source data set in bytes.
    :vartype size_read: long
    :ivar size_written: The size of the data written into the sink data set in bytes.
    :vartype size_written: long
    :ivar start_time: Start time of data set level copy.
    :vartype start_time: ~datetime.datetime
    :ivar status: Raw Status.
    :vartype status: str
    :ivar v_core: The vCore units consumed for the data set synchronization.
    :vartype v_core: long
    """

    _validation = {
        'data_set_id': {'readonly': True},
        'data_set_type': {'readonly': True},
        'duration_ms': {'readonly': True},
        'end_time': {'readonly': True},
        'files_read': {'readonly': True},
        'files_written': {'readonly': True},
        'message': {'readonly': True},
        'name': {'readonly': True},
        'rows_copied': {'readonly': True},
        'rows_read': {'readonly': True},
        'size_read': {'readonly': True},
        'size_written': {'readonly': True},
        'start_time': {'readonly': True},
        'status': {'readonly': True},
        'v_core': {'readonly': True},
    }

    _attribute_map = {
        'data_set_id': {'key': 'dataSetId', 'type': 'str'},
        'data_set_type': {'key': 'dataSetType', 'type': 'str'},
        'duration_ms': {'key': 'durationMs', 'type': 'int'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'files_read': {'key': 'filesRead', 'type': 'long'},
        'files_written': {'key': 'filesWritten', 'type': 'long'},
        'message': {'key': 'message', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'rows_copied': {'key': 'rowsCopied', 'type': 'long'},
        'rows_read': {'key': 'rowsRead', 'type': 'long'},
        'size_read': {'key': 'sizeRead', 'type': 'long'},
        'size_written': {'key': 'sizeWritten', 'type': 'long'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'v_core': {'key': 'vCore', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SynchronizationDetails, self).__init__(**kwargs)
        self.data_set_id = None
        self.data_set_type = None
        self.duration_ms = None
        self.end_time = None
        self.files_read = None
        self.files_written = None
        self.message = None
        self.name = None
        self.rows_copied = None
        self.rows_read = None
        self.size_read = None
        self.size_written = None
        self.start_time = None
        self.status = None
        self.v_core = None


class SynchronizationDetailsList(msrest.serialization.Model):
    """details of synchronization.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.SynchronizationDetails]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[SynchronizationDetails]'},
    }

    def __init__(
        self,
        *,
        value: List["SynchronizationDetails"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SynchronizationDetailsList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class SynchronizationSettingList(msrest.serialization.Model):
    """List response for get Synchronization settings.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.SynchronizationSetting]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[SynchronizationSetting]'},
    }

    def __init__(
        self,
        *,
        value: List["SynchronizationSetting"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SynchronizationSettingList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class Synchronize(msrest.serialization.Model):
    """Payload for the synchronizing the data.

    :param synchronization_mode: Mode of synchronization used in triggers and snapshot sync.
     Incremental by default. Possible values include: "Incremental", "FullSync".
    :type synchronization_mode: str or ~azure.mgmt.datashare.models.SynchronizationMode
    """

    _attribute_map = {
        'synchronization_mode': {'key': 'synchronizationMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        synchronization_mode: Optional[Union[str, "SynchronizationMode"]] = None,
        **kwargs
    ):
        super(Synchronize, self).__init__(**kwargs)
        self.synchronization_mode = synchronization_mode


class TriggerList(msrest.serialization.Model):
    """List response for get triggers.

    All required parameters must be populated in order to send to Azure.

    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type DataTransferObjects.
    :type value: list[~azure.mgmt.datashare.models.Trigger]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Trigger]'},
    }

    def __init__(
        self,
        *,
        value: List["Trigger"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(TriggerList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value
