
      SUBROUTINE SETPAR
C     -----------------

C    Sets parameters connected with convegence criteria and rate of
C    convergence. These parameters do not affect performance.

      INTEGER  NSWEEP, MAXIT, SIGFIG
      DOUBLE PRECISION     H,  HALFH,  MQUARK,  MSQ 
      COMMON / PARAMS / H,HALFH,MQUARK,MSQ,NSWEEP,MAXIT,SIGFIG

      MAXIT = 150
C  maxit is the maximum number of CG iterations allowed to achieve convergence

      SIGFIG = 7
C  sigfig is the number of significant figures used in the convergence test

      NSWEEP = 8
C  nsweep is the number of timed sweeps (an initial untimed sweep is also made)

      H = 0.01D0
      MQUARK = 0.2D0
C  mquark is the quark mass
 
      HALFH = H / 2.0D0
      MSQ = MQUARK * MQUARK

      END
